 $PASCAL ',7 92081-1X698 REV.2540' $       $ Include '[LBOPT'  $       PROGRAM database_delete_operation;      !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18698                                        *)  ! !(* RELOC:   92081-16698                                        *)  ! !(*                                                             *)  ! !(* PGMR:         <stc>                                         *)  ! !(*                                                             *)  ! (* Date of last modification: <850416.1426>   !(*                                                             *)  ! !(***************************************************************)  !             $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)      $ Include '[BMCCT'  $    (* Workhorse constants and types. *)    $ Include '[BMCTV'  $    (* DBMON Constants, Types and Vars. *)    #$ Include '[BMSAM'  $    (* Main globals used by Samurai Segmenter *)  #     $ Include '[XWRKH'  $    (* Workhorse externals. *)   $ Include '[XBSDR'  $    (* Commonly used externals. *)   $ Include '[XWBUF'  $    (* Data buffering routines. *)   $ Include '[XWBIF'  $    (* Before image buffering routines *)  $ Include '[XBFMC'  $    (* First DB modify check *)  $ Include '[XBLOG'  $    (* Transaction log file routines *)  $ Include '[XLGLB'  $    (* Transaction log file routines *)  $ Include '[XBUCP'  $    (* Checkpoint routines. *)   $ Include '[XBLUR'  $    (* Lock checking routines *)   $ List ON $   $ Page $  #(********************************************************************) # #(*                                                                  *) # #(*  PROCEDURE Delete_operation                                      *) # #(*                                                                  *) # #(*                                                                  *) # #(*  Input: The global message buffer: it contains                   *) # #(*         (1) the transaction number                               *) # #(*         (2) the post/no post indicator                           *) # #(*         (3) the data set number                                  *) # #(*         (4) the current record number                            *) # #(*                                                                  *) # #(*                                                                  *) # #(*  Output:                                                         *) # #(*         The message buffer if successful.                        *) # #(*                                                                  *) # #(*                                                                  *) # #(*  Errors:                                                         *) # #(*     107: No master entry for the detail key value.               *) # #(*     113: A non-empty chain upon manual master delete.            *) # #(*     114: The record accessed is empty.                           *) # #(*     154: Bad path pointers in a data set.                        *) # #(*     156: Detail does not contain any entries along the chain of  *) # #(*            key value.                                            *) # #(*     160: The run table is corrupt.                               *) # #(*                                                                  *) # #(********************************************************************) #     	$ Heapparms OFF $  	     PROCEDURE Delete_operation   $ Alias 'Mon.DeleteRecord' $;      LABEL 99,   (* Error return label after log record. *)        88;   (* Error processing prior to log record. *)       VAR          (**)      (* global variables used are :      (*   rootx : database number      (*   error : latest error number      (*   rt_header : pointer to the root file header      (*   dst_entry : pointer to the data set table entry      (*   itm_table : pointer to the item table      (*   frt_entry : pointer to the free record table     (*   mpt_table : pointer to the master path table     (*   mit_entry : pointer to the master information table      (*   dpt_table : pointer to the detail path table     (**)           xaction_num : long_int;      (* current transaction number *)       post_data : boolean;         (* post (1)/ no post (0) flag *)   %   del_set_num : short_int;     (* set # from which a record is deleted *) % #   del_rec_num : long_int;      (* record # which is to be deleted *)  # "   del_rec_len : short_int;     (* word length of deleted record *)  "    del_data_len : short_int;    (* length of record's data *)      del_set_type : dataset_type;     (* data set types *)      $   del_data_ptr : data_record_ptr_type;  (* ptr to data only portion *)  $        del_mstr_rec_ptr : master_media_record_ptr_type;      del_dtl_rec_ptr : detail_media_record_ptr_type;         logging : boolean;           (* true if we are logging *)  #   del_log_rec_len : short_int; (* word length of dbdel log record *)  # '   del_log_data_ptr : data_record_ptr_type; (* ptr to del log rec data rec *)  '     &   log_block_num : Long_int;     (* TUF block # where log rec may reside *)  & 
   save_error : Short_int; 
    any_ptr    : All_pointers_type;  
   coordx     : Short_int; 
    proc_id    : Process_description_type;           BEGIN (* delete_operation *)      WITH workhorse_data DO BEGIN         (**)      (* Get pointers to various tables in the run table.  These   	   (* are global.  	    (**)          message_len := to_user_del_mesg_len;          mb_ptr^.user.request := to_user_del_code;         WITH MB_ptr^.dbmon.delete DO BEGIN         proc_id := user.proc;         xaction_num := xact_num;        post_data := post_ind;        del_set_num := set_num;         del_rec_num := current_rec_num;         WITH user DO BEGIN           rootx := db_id;           local_db_number := local_db_num;            END;   
      END;  (* end with *) 
     
   IF find_process (rootx, 
                     local_db_number,                      proc_id,                      coordx,                       workhorse_data,   
                    error) 
 
      THEN GOTO 88;  
        IF make_global_ptrs (rootx,                          del_set_num,                          error)  
      THEN GOTO 88;  
        (**)   "   (* Do the before image file check BEFORE creating the log record  " !   (* because it may perform a checkpoint and we want to make sure ! #   (* the log record is in memory in case we run into a problem later  #    (* and have to remove it from the log buffer.     (**)          IF before_image_file_check (to_bm_del_code,                                 dst_entry,                                  workhorse_data,                                 error)   
      THEN GOTO 88;  
        (**)   "   (* Verify that the dataset in question is locked to the program.  "    (**)          IF verify_set_lock (rootx,                          del_set_num,                          coordx,                         workhorse_data,                         error)         THEN GOTO 88;  (* If lock was not found *)          #   (* Get some info from the data set control block, for use later *)  #    WITH dst_entry^ DO BEGIN         del_set_type := gdt.set_type;         del_rec_len  := gdt.media_len + data_len;         del_data_len := data_len;         END;         (**)      (* Read in the current record (the one which is to      (* be deleted) and see if it is empty.      (**)          IF read_master_record (rootx,                            del_set_num,                            del_rec_num,                            do_not_copy,      (* returns *)         del_mstr_rec_ptr,                             workhorse_data,                             error)  
      THEN GOTO 88;  
        (* Check to see if it is empty *)     IF (del_mstr_rec_ptr^.entry_type = empty ) THEN BEGIN        error := record_empty_err;        GOTO 88;  
      END;    (* end if *) 
            (**)      (* Make proper bit settings in the rootfile for     (* first modification, etc.     (**)          IF check_first_mod (rootx,                          workhorse_data,                         error)   
      THEN GOTO 88;  
            (**)      (* If we are logging, create a transaction log record.      (**)          IF opn_tbl_ptr^[rootx].logging_status THEN BEGIN         logging := true;            (*  determine the log record length *)        del_log_rec_len := dbdel_log_rec_size +            del_data_len;            (* make a general log record *)         IF make_log_record (dbdel_log_code,                             del_log_rec_len,                            logrec_ptr,                             log_block_num,                            error)           THEN GOTO 88;            WITH mb_ptr^.dbmon.delete DO           Operating_transaction := trans_id (xact_num);                WITH logrec_ptr^.delete DO BEGIN           trans_num := operating_transaction;               (* if a singleton, set the flag to true *)            IF (mb_ptr^.dbmon.delete.xact_num = zero) THEN               singleton := true            ELSE               singleton := false;                proc_info := MB_ptr^.dbmon.delete.user.proc;            db_name_id := opn_tbl_ptr^[rootx].root_file_name;               (**)            (* Save system DB # for use by DBRFR.           (**)                sysdb_num := rootx;               ds_num := del_set_num;            rec_num := del_rec_num;           data_len := dst_entry^.data_len;            END;   (* end with *)                Any_ptr.master_media_record := del_mstr_rec_ptr;         Any_ptr.value := any_ptr.value + dst_entry^.gdt.media_len;         Del_data_ptr  := any_ptr.data_record;             Any_ptr.log_record_header := logrec_ptr;        Any_ptr.value := any_ptr.value + dbdel_data_off;        del_log_data_ptr := any_ptr.data_record;            (* copy data record to log record *)        IF move_words (            del_data_ptr^[zero],            del_log_data_ptr^[zero],            del_data_len,  
         error) THEN 
 	         GOTO 99;  	           END    (* end if logging *)          (**)      (* Set the logging flag to false.     (**)   
   ELSE logging := false;  
         !   IF common_delete_routine (rootx,        (* Delete the record *) !                              del_set_num,                                del_rec_num,                                workhorse_data,                               error)   
      THEN GOTO 99;  
        (**)      (* If a singleton transaction, flush TUB to TUF.      (**)          IF (MB_ptr^.dbmon.delete.xact_num = zero) AND (logging)        THEN commit_singleton (error);        IF error <> zero THEN   	         GOTO 99;  	        (* If the posting flag is set, post all data blocks *)      IF (NOT logging) THEN  	      IF post_data 	          THEN IF check_point (workhorse_data, error)  
             THEN GOTO 99; 
         END; (* with workhorse data *)          99:    (* error exit *)          IF (error <> no_image_err)         THEN IF (logging)            THEN remove_log_record;       88:  (* error processing for code prior to making log record. *)          IF (error <> no_image_err)         THEN message_len := to_user_intr_header_len;      (**)  
(* That's all folks! 
 (**)      END;  .  