 $PASCAL ',7 92081-1X484 REV.2540' $       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18484                                        *)  ! !(* RELOC:   92081-16484                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified: <850819.1500>  !(*                                                             *)  ! !(***************************************************************)  !     $ Include '[LBOPT'  $       PROGRAM first_db_modification_library;      $ List OFF, Include '[IMAGE' , List ON $      $ List OFF, Include '[BMCCT' , List ON $  $ List OFF, Include '[BMCTV' , List ON $  $ List OFF, Include '[BMSAM' , List ON $      $ List OFF, Include '[XWPTS' , List ON $      $ Page $  !(****************************************************************) ! !(*                                                              *) ! !(* function CHECK_FIRST_MOD : Boolean;                          *) ! !(*                                                              *) ! !(* Purpose:                                                     *) ! !(*    To see if this is the first modification to the           *) ! !(*    database since the last backup.                           *) ! !(*    If this is the first modification, the MB bit is set in   *) ! !(*    the root file.  MW is set if RFLogging is off.            *) ! !(*                                                              *) ! !(* Parameters:                                                  *) ! !(*    (in)     (1) Database number.                             *) ! !(*    (in/out) (2) Workhorse info.                              *) ! !(*    (out)    (3) IMAGE error if an error occurs.              *) ! !(*                                                              *) ! !(* Function result:  'true' if an error occured,                *) ! !(*                   'false' otherwise.                         *) ! !(*                                                              *) ! !(* Possible errors:                                             *) ! !(*    disc I/O, EMA mapping failure, corrupt data structures.   *) ! !(*                                                              *) ! !(*                                                              *) ! !(****************************************************************) !     	$ Heapparms OFF $  	     FUNCTION check_first_mod  $ Alias 'Mon.FirstTrans' $            (VAR dbase_index    : Short_int;             VAR workhorse_data : Workhorse_info_type;             VAR error          : Short_int) : Boolean;       LABEL 99;  (* error exit *)       VAR      runtable_ptr : Rootfile_header_ptr_type;           BEGIN  (* check_first_mod *)      WITH workhorse_data DO BEGIN         check_first_mod := true;  (* assume an error will occur *)          IF make_rt_header_ptr (dbase_index,                            runtable_ptr,                             workhorse_data,                             error)  
      THEN GOTO 99;  
        WITH runtable_ptr^ DO BEGIN            (**)        (* If this is the first xaction for this database, then         (* make sure the mb and mw bits are set properly for        (* the rootfile.        (**)            IF opn_tbl_ptr^[dbase_index].first_Xact THEN BEGIN               opn_tbl_ptr^[dbase_index].first_xact := false;       #         (* Set some other rootfile flags for first DB modification *) #          flags.mb := true;  (* Modified since backup *)            IF ((system_log_status <> rb_rf) AND                (system_log_status <> rf_nospool)) OR              NOT (opn_tbl_ptr^[dbase_index].logging_status)  "            THEN flags.mw := true;  (* modified without RFLogging *) "          flags.ha := true;  (* rootfile header altered *)            END;  (* if *)                END;  (* with *)            check_first_mod := false;      END; (* with workhorse_data *)      99:  (* error exit *)       END; (* function check_first_mod *)   .  