 $PASCAL ',7 92081-1X711 REV.2540' $       $ Include '[LBOPT'  $       PROGRAM database_find_operation;      !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18711                                        *)  ! !(* RELOC:   92081-16711                                        *)  ! !(*                                                             *)  ! !(* PGMR:         <stc>                                         *)  ! !(*                                                             *)  ! !(* Date of last modification: <811124.1141>                    *)  ! !(*                                                             *)  ! !(***************************************************************)  !             $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)      $ Include '[BMCCT'  $    (* Workhorse constants and types *)   $ Include '[BMCTV'  $    (* DBMON Constants, Types and Vars. *)    #$ Include '[BMSAM'  $    (* Main globals used by Samurai Segmenter *)  #     $ Include '[XBSDR'  $    (* Commonly used externals. *)   $ Include '[XWBUF'  $    (* Data buffering routines. *)   $ Include '[XWHRD'  $    (* Hash Read routine. *)   $ Include '[XWPTS'  $    (* Pointer Construction routines. *)   $ List ON $           #(********************************************************************) # #(*                                                                  *) # #(*  PROCEDURE find_operation                                        *) # #(*                                                                  *) # #(*  Purpose :  This procedure locates the beginning of a data set   *) # #(*  chain in preparation for access to entries in the chain.        *) # #(*  It does this by locating the master set entry that matches the  *) # #(*  specified key item value and sets up pointers to the detail     *) # #(*  data set chain.                                                 *) # #(*                                                                  *) # #(*  Input: The global message buffer: it contains                   *) # #(*         (1) the detail set number                                *) # #(*         (2) the master set number                                *) # #(*         (3) the key item number                                  *) # #(*         (4) the key item length                                  *) # #(*         (5) the key item value                                   *) # #(*                                                                  *) # #(*                                                                  *) # #(*  Output:                                                         *) # #(*         The message buffer if successful. The specific find      *) # #(*         information returned is:                                 *) # #(*         (1) chain length                                         *) # #(*         (2) chain tail record number                             *) # #(*         (3) chain head record number                             *) # #(*                                                                  *) # #(*  Errors:                                                         *) # #(*     107: No master entry for the detail key value.               *) # #(*     156: Detail does not contain any entries along the chain of  *) # #(*            key value.                                            *) # #(*     160: The run table is corrupt.                               *) # #(*                                                                  *) # #(********************************************************************) #     	$ Heapparms OFF $  	     PROCEDURE find_operation  $ Alias 'Mon.FindChain' $;      LABEL 99,  (* Error return label. *)        88;  (* for skipping around error processing. *)      VAR          (**)      (* global variables used are :      (*   rootx : database number      (*   error : latest error number      (*   message_len : return message length      (**)       !   dtl_set_num : short_int;          (* detail data set number *)  ! !   mstr_set_num : short_int;         (* master data set number *)  !    key_itm_num : short_int;          (* key item number *)         key_val_ptr :  data_record_ptr_type;       mstr_rec_num : long_int;          (* master record number *)       hash_bucket_rec : long_int;       (* record hashed into *)   #   hash_bucket_free : boolean;       (* true if hash bucket is free *) #     synonym_head_rec : long_int;      (* head of synonym chain *)       synonym_tail_rec : long_int;      (* tail of synonym chain *)   #   next_free_rec : long_int;         (* next free record for chain *)  # %   record_found : boolean;           (* true if sought record is found *)  %        master_rec_ptr : master_media_record_ptr_type;   #   data_ptr : db_ptr_type;           (* ptr to a data-buffer-record *) # #   rec_word_off : short_int;         (* start word of rec in buffer *) #        mstr_dscb_entry : global_dataset_ctl_table_ptr_type;      mstr_path_table : global_md_path_table_ptr_type;      mstr_info_table : global_md_info_ptr_type;      mstr_free_rec_table : global_frt_entry_ptr_type;          path : short_int;                 (* path number *)  '   num_paths : short_int;            (* number of paths for the master set *)  '    chain_length : Long_int;  (* Length of synonym chain *)          BEGIN  (* find_operation *)          message_len := to_user_fnd_mesg_len;          MB_ptr^.user.request := to_user_fnd_code;         (**)   &   (* Retrieve some of the message buffer fields into simple variables now,  & #   (* to avoid pointer calculation every time we reference them later. #    (**)          WITH MB_ptr^.dbmon.find DO BEGIN         dtl_set_num := detail_set_num;        mstr_set_num := master_set_num;         key_itm_num := key_item_num;        END;  (* end with mb_ptr *)          rootx := MB_ptr^.dbmon.find.user.db_id;         (**)   #   (* First, we must locate the master data set record which contains  #    (* the user specified key item value.     (**)          IF (get_item_value_addr (mb_ptr^.dbmon.find.key_value,   &                            key_val_ptr,    (* create ptr to the key item *) & &                            error)) THEN    (* value which hash_read can  *) & &      GOTO 99;                             (* understand.                *)  &         %   (* Do a hashed read of the key value to determine IF an entry exists *) %    IF hash_read (rootx,                (* data base number *)   "                 mstr_set_num,         (* master data set number *)  "                  key_val_ptr,          (* ptr to key value *)                    do_not_copy,          (* No before_image *)     (* returns *) mstr_rec_num,         (* Record number *)                   record_found,         (* record exists? *)                    hash_bucket_rec,      (* Hash bucket record*)                   hash_bucket_free,     (* Empty?  *)                   synonym_head_rec,     (* Syn. chain head. *)                    synonym_tail_rec,     (* Syn. chain tail  *)                     chain_length,         (* Syn. chain length. *)                     next_free_rec,        (* Next free record *)                     master_rec_ptr,        (* Ptr to data buffer *)   #                 workhorse_data,        (* Start word of rec in buf *) #                  error)   
      THEN GOTO 99;  
        IF NOT (record_found) THEN BEGIN         error := no_master_for_key_err;         goto 99;        END;         (**)   $   (* Now that we have the record, determine the master's path for this  $ !   (* detail.  First we need the master's data set control block.  ! !   (* Then we need to get the master's path count and path table.  !     (* We will look through the master's path table, looking for    %   (* a match between the path entry and the detail set &key item number.  %    (**)          (* Get pointers to the master tables *)     IF make_master_pointers (rootx, mstr_set_num,                              mstr_dscb_entry,                              mstr_path_table,                              mstr_info_table,                              mstr_free_rec_table,                              workhorse_data,                               error)  
      THEN GOTO 99;  
        (* Loop through the path table *)         num_paths := mstr_dscb_entry^.gdt.set_paths;      path := one;   
   record_found := false;  
    WHILE NOT (record_found) and (path <= num_paths) DO         IF (mstr_path_table^[path].related_key = key_itm_num) THEN   "         IF (mstr_path_table^[path].related_set = dtl_set_num) THEN  "            record_found := true            ELSE              path := succ (path)    (* next path *)         ELSE           path := succ (path);  (* next path *)             IF (record_found) THEN BEGIN             (**)         (* Get return info from the master media record and store           (* it in the reply message buffer to be sent to the user.          (**)            WITH master_rec_ptr^.chains[path] DO BEGIN      #         (* Detail must have records on the chain of this key value *) #          IF (recs_in_chain= zero) THEN BEGIN              error := empty_detail_chain_err;  
            goto 99; 
             END;               WITH MB_ptr^.user.find  DO BEGIN               chain_len :=  recs_in_chain;              chain_head :=  head_of_chain;               chain_tail :=  tail_of_chain;               END;  (* end with reply message buffer *)            END;  (* end with master media record *)             END    (* end if found - match! *)     ELSE   $      error := db_corrupt_err;   (* no match of set and key item nums *) $        GOTO 88;       
99: (* error exit *) 
        message_len := to_user_intr_header_len;          88: (* skip around error processing. *)       END;  .  