$PASCAL ',7 92081-1X690 REV.5000' $ 
$ Include '[LBOPT'  $ 
    PROGRAM init_dbmon_environment;      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18690                                        *)   (* RELOC:   92081-16690                                        *)   (*                                                             *)   (* PGMR:        <MRL>                                          *)   (*                                                             *)  (* Date of last modification: <870113.1448>  (*                                                             *)   (* Modified to handle using a different class number than that *)   (* found in the communications buffer, so that PIGGY can       *)   (* intercept and record all messages to DBMON.                 *)   (*                                                             *)   (***************************************************************)       $ List OFF, Include '[IMAGE' , List ON $      $ List OFF, Include '[BMCCT' , List ON $  $ List OFF, Include '[BMCTV' , List ON $  $ List OFF, Include '[BMSAM' , List ON $          #(*******************************************************************)  # #(*                 EXTERNAL ROUTINE DEFINITIONS                    *)  # #(*******************************************************************)  #     $ List OFF, Include '[XDGDN' , List ON $  $ List OFF, Include '[XDGCB' , List ON $  $ List OFF, Include '[XDCCP' , List ON $  $ List OFF, Include '[XDCIO' , List ON $  $ List OFF, Include '[XDFMP' , List ON $  $ List OFF, Include '[XBLOG' , List ON $  $ List OFF, Include '[XLGLB' , List ON $  $ List OFF, Include '[XBSDR' , List ON $  $ List OFF, Include '[XBOPS' , List ON $  $ List OFF, Include '[XERWD' , List ON $          	$ Heapparms OFF $  	     PROCEDURE lock_in_memory  $ Alias 'EXEC' $     (swap_control_code : short_int;      lock_unlock_code  : short_int);      EXTERNAL;      	$ Heapparms OFF $  	 PROCEDURE unlock_memory  $ Alias 'EXEC' $      (swap_control_code : short_int;      lock_unlock_code  : short_int);      EXTERNAL;      	$ Heapparms OFF $  	     FUNCTION allocate_comm_id   $ alias 'GETCL' $      (VAR class_num : short_int;          alloc_flag : short_int) : BOOLEAN;     EXTERNAL;          $ Page $  (************************************************************)  (*                                                          *)  (*  Function  Init_log_system                               *)  (*                                                          *)  (*  Purpose : This routine serves to initialize the logging *)  (*  system variables and files.                             *)  (*                                                          *)  (*  Input : none                                            *)  (*                                                          *)  (*  Output: error number if one occurs                      *)  (*                                                          *)  (*  Function value returned:                                *)  (*    False if no error occurs, true otherwise              *)  (*                                                          *)  (*  Calls:                                                  *)  (*    (1) Init_TUB                                          *)  (*                                                          *)  (************************************************************)      	$ HEAPPARMS OFF $  	     Function Init_log_system   $ Alias 'Mon.InitLogSys' $     (VAR workhorse_data : Workhorse_info_type;      VAR return_status  : short_int):    BOOLEAN;     LABEL 99;     VAR    head_log_rec_ptr : ptr_log_record_header_type;  	   ix : short_int; 	 
   dummy_stats : long_int; 
    BEGIN      %WITH workhorse_data DO BEGIN (* info for data access/logging workhorses *) %       init_log_system := true;  (* Assume an error will occur *)        (**)     (* Open the before-image file and set initial variable values.     (**)        WITH dbcon_block.dbcon_bif_info_block DO BEGIN        IF read_dbcon_table (dbcon_descriptor,                             dbc_bif_info_blk,                             do_not_lock_dbcon_file,                            block,                            error) 	         THEN BEGIN 	             error := dbmon_internal_err;             evaluate_error (error);              END; (* then fatal error has occurred *)           before_image_file_id.newfl := bif_name;            END; (* with dbcon bif info block *)        IF open_existing_file (before_image_file_id,                            error)        THEN BEGIN           error := bif_corrupt_err;           evaluate_error (error);          END; (* then fatal error has occurred *)         intrinsic_in_progress := false;         current_intrinsic_num := one;      
   bi_buf_state := clean;  
        bi_file_block := one;             (**)      (* Write an initializing buffer to the BIF.     (**)          IF read_write_disc (write_to_device_code,                         Before_image_file_ID,                         bifi_buf_ptr^.bi_end_of_file_mark,                          one, (* blocks to transfer *)                         one, (* block in file *)                          return_status)         THEN BEGIN           return_status := hard_crash_err;           GOTO 99;           END; (* then *)                (**)    (* Initialize transaction logging only if logging enabled.    (**)            IF (system_log_status <> intr_only) THEN BEGIN        (**)    (* Initialization of the Transaction Log    (* buffer related variables.    (**)        TUB_next_word := zero;     TUB_prev_chunks_blks_per_chunk := zero;     cur_log_rec_size := zero;        (**)    (* Initialization of the Transaction Log    (* file related variables.    (* Blocks begin numbering from zero.    (**)        IF read_dbcon_block (dbcon_descriptor,                         dbc_tlf_info_blk,                         do_not_lock_dbcon_file,                          dbcon_block,                          return_status) 	      THEN GOTO 99; 	            (* open the transaction log file *) "   tlf_descriptor.newfl := dbcon_block.dbcon_tlf_info_block.tlf_name; "    IF open_existing_file      (tlf_descriptor,   (* returns filled descriptor *)       return_status) THEN BEGIN        return_status := tlf_open_err;        GOTO 99;        END;         TUF_max_avail_blks := tlf_descriptor.fsize;     num_current_avail_TUF_blks :=                TUF_max_avail_blks - num_blks_in_TUF_header;     Dummy_chunk_written := false; 
   TUF_wraparound := false; 
   Tuf_next_blk := TUF_first_blk_num;  %   TUF_last_blk_num := TUF_max_avail_blks;       (* blk num starts at 1 *) %        #   (* Create a pointer to the TUF label - needed for making BI later *) #       IF get_TUF_label_ptr (        TUF_label,  
      TUF_label_ptr, 
      return_status) THEN        GOTO 99;        (* Initialize label *)  
   WITh TUF_label Do BEGIN 
       cur_ckpt_rec_block_num := tuf_first_blk_num;        cur_ckpt_rec_word_off := zero;        logical_beg_of_tuf := tuf_first_blk_num;        spooled_block_num := zero;  
      END;  (* end with *) 
        
   (* write it out *) 
 
   IF tuf_label_io ( 

      tlf_descriptor, 
      write_code,        tuf_label,  	      dummy_stats, 	      return_status) THEN        GOTO 99;            temp_block[zero] := zero;  (* Will be used as an EOF mark *)      !   (* Initialize the TUF by writing an EOF at tuf_first_blk_num *) !    IF read_write_disc (write_code,                         tlf_descriptor,                         temp_block[zero],                         one, (* block to write out *)                        tuf_first_blk_num,                        return_status) 	      THEN GOTO 99; 	             "   (* Initialize TUF pointers wraparound status.  When all fields *) " "   (* are false, all are moving in the same cycle around the TUF. *) "    WITH TUF_wraparound_status DO BEGIN       spooled := false;        cur_cp := false;        oldest_trans := false;        END;        (* Init the TUB/TUF eof block *)    TUB_ptr^.TUB_eof_block.eof_indicator := TUF_eof_indicator;         (* Init the TUB with the head chunk log record *)    IF init_TUB (head_log_rec_ptr,return_status) THEN;         (* init the transaction log tables related variables *)     last_allocated_xaction_table_entry_num := zero;         (* init the active transaction table (ATT) *)     FOR ix := one to max_num_open_xactions DO        WITH xaction_tbl_ptr^[ix] DO BEGIN $         xaction_num := -1;   (* must not be init to zero because      *) $$                              (* data records contain tran numbers     *) $$                              (* which are init to zero - those        *) $$                              (* tran #s determine owners of free recs *) $ 
         undoing := false; 

         block_num := zero; 
         word_offset := zero;          END;  (* with *)             last_allocated_xaction_table_entry_num := zero;    TUF_full_warn_flag := false;        (* If roll forward logging is enabled ..... *)    IF ((system_log_status = rb_rf) OR        (system_log_status = rf_nospool)) THEN BEGIN            (**)       (* Notify the spooler - without wait.        (**)           IF dbspl_message_sender (           to_spl_cont_log_code,           to_spl_cont_log_mesg_len,           return_status) THEN          GOTO 99;            END;  (* end if rb_rf *)         END; (* then logging is enabled *)              (* allocate a special comm id for auto cleanup *)     IF allocate_comm_id (        dbmon_DBCLN_spec_comm_id,         zero) THEN; (* local  allocation *)   	   (* all done! *) 	    init_log_system := false;      99:       END;  (* end with workhorse *)      END;      $ page $  #(*******************************************************************)  # #(*                                                                 *)  # #(* function  Init_dbmon_environment;                               *)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To initialize structures required for DBMON                  *)  # #(*    operation (not workhorse structures).                        *)  # #(*    Message structures and the IMAGE communications buffer       *)  # #(*    need to be set up.                                           *)  # #(*                                                                 *)  # #(*     params :  none                                              *)  # #(*     returns:  error (global) set if an error is encountered     *)  # #(*                                                                 *)  # #(*    function result:                                             *)  # #(*       'True' if an error occurs, 'False' otherwise.             *)  # #(*                                                                 *)  # #(*     called by: main.                                            *)  # #(*     calls: (1) detach_from_session - to detach from session     *)  # #(*                                                                 *)  # #(*******************************************************************)  #     	$ Heapparms OFF $  	     FUNCTION init_dbmon_environment   $ Alias 'Mon.InitDBMON' $                           : Boolean;      LABEL      99; (* error exit *)       CONST  
   swap_control_code  = 22; 
 
   memory_unlock_code = 0; 
 
   memory_lock_code   = 1; 
        do_not_extend_file = false;     VAR     dummy: short_int;                   (* detach parameter  *) 	   i,j : short_int; 	         BEGIN (* init_dbmon_environment *)      WITH workhorse_data DO BEGIN      "   init_dbmon_environment := true;  (* Assume an error will occur *) "            detach_from_session(dummy);            (**)    (* Get the IMAGE communications buffer (from SAM).    (**)        IF get_IMAGE_comm_buffer (IMAGE_comm_buffer)        THEN BEGIN           error := IMAGE_not_initialized_err;          GOTO 99;           END; (* then *)         WITH DBMON_startup_message DO !   IF (IMAGE_comm_buffer.dbmon_comm_id <> dbmon_comm_id) THEN BEGIN !           (**)       (* Special for 3M - if class number is legal, it has been       (* supplied by DBUTL to be used in conjunction with the !      (* PIGGY and SLURP tools, which record all messages to DBMON. !       (**)            IF (dbmon_comm_id > 0)  &         THEN image_comm_buffer.dbmon_comm_id := dbmon_comm_id (* use it! *) &           ELSE BEGIN (* Mis-scheduled; return an error! *)           (* Someone other than DBUTL tried scheduling DBMON *)          error := IMAGE_program_scheduled_improperly_err;          GOTO 99;           END; (* else *)       END; (* then comm id's not equal *)        (**)    (* The default is to lock DBMON in memory.     (* If the user does not wish this to happen, IMAGE can be    (* started up with the 'SU,UNLOCK' option.    (**)         IF (DBMON_startup_message.memlock = zero) (* do not lock *)         THEN unlock_memory (swap_control_code, memory_unlock_code)        ELSE lock_in_memory(swap_control_code, memory_lock_code);        (**)     (* Open the DBCON file to extract the warning log file.     (* (If it is a file, it will be appended to).    (**)        WITH workhorse_data DO BEGIN             IF get_db_control_file_name (dbcon_descriptor.newfl) THEN;             IF open_existing_file (dbcon_descriptor,                              error)           THEN evaluate_error (dbcon_open_err);            WITH dbcon_block.dbcon_status_block DO BEGIN          IF read_dbcon_table (dbcon_descriptor,                               dbc_status_blk,                               do_not_lock_dbcon_file,                                block,                                error)              THEN evaluate_error (error);               system_db_access_status := system_access;               system_log_status := logging_state;              system_xaction_num := xaction_num;          TUB_chunk_sequence_num := chunk_seq_num;               oldest_tran_block_num := tuf_first_blk_num;               warning_log_descriptor.newfl := wlf_name;                (* Will open the system console if WLF is undefined. *)            IF warning_log_descriptor.newfl = ' '             THEN default_file (warning_log_descriptor.newfl);              IF open_file_for_append (warning_log_descriptor,                                    error)             THEN BEGIN  (* Shucks! warning log open error! *)                default_file (warning_log_descriptor.newfl);  #               IF open_file_for_append (warning_log_descriptor, error) #                   THEN evaluate_error (warning_log_acc_err);  !               END; (* error with regular log - so open sys-con *) !              END; (* with *)     
      END; (* with *) 
        (** Initialize the lock table **)     FOR i := one TO max_image_db DO     FOR j := one TO max_data_sets DO         lock_table_ptr^[i].entry[j] := zero;          "   IF make_pointer (temp_block[zero],   (* Make ptr to disc block *) "                     temp_block_ptr,   
                    error) 
 
      THEN GOTO 99;  
            (**)      (* initialize coordination table      (* and associated variables.     (**)            FOR i := one TO max_image_users DO     WITH image_users^[i] DO BEGIN        opn_tbl_num := zero;  (* Index into open db table *)  
      open_mode   := zero; 

      END; (* for...with *) 
           IF init_log_system (workhorse_data, error) 	      THEN GOTO 99; 	       (* Initialize message I/O environment *)        shut_down            := false;        (* Init qa crash flag - used for QA ONLY! *)    qa_crash_code := zero;   (* DO NOT CRASH  *)        init_dbmon_environment := false;     
99:  (* error exit *) 
     END; (* with workhorse data *)      END; (* init_dbmon_environment *)       $ Page $      (*********************************************************)   (*                                                       *)   (* Procedure CHANGE_STATUS_OPERATION;                    *)   (*                                                       *)   (* Purpose:                                              *)   (*    To retrieve the most current system status from    *)   (*    the DBCON file, determine which attribute has      *)   (*    changed and do the right thing.  Presently,        *)   (*    the logging state, system access flags,            *)   (*    the warning log and shutdown status can change.    *)   (*                                                       *)   (* No parameters.                                        *)   (*                                                       *)   (* Possible errors: Disc and resource number errors.     *)   (*                                                       *)   (*********************************************************)       	$ Heapparms OFF $  	     PROCEDURE change_status_operation   $ Alias 'Mon.ChangeStatus' $;       
LABEL 99; (* error exit *) 
    VAR  
   loop : short_int; 

   dummy_error : short_int; 
    BEGIN (* change_status_operation *)      WITH workhorse_data DO BEGIN        message_len := to_user_utl_stat_change_mesg_len;        (* Assume an error will occur *)     mb_ptr^.user.request := to_user_error_code;        WITH dbcon_block.dbcon_status_block DO BEGIN        IF read_dbcon_table (dbcon_descriptor,                             dbc_status_blk,                             do_not_lock_dbcon_file,                            block,                            error)           THEN GOTO 99;            CASE mb_ptr^.dbmon.change_status.changed_status OF               logging_state_changed : BEGIN                  (**)             (* If we are going from RF to either RB or DI, then             (* tell DBSPL to wrap up and terminate.              (**)                 IF (ord(system_log_status) >= ord(rb_rf)) AND                (ord(logging_state) < ord(rb_rf)) THEN BEGIN                   IF dbspl_message_sender (to_spl_finis_code,                                             to_spl_finis_mesg_len,                                             error)                       THEN GOTO 99;                    (* clear saved dbspl error code *)                   spl_save_error := zero;                    END;                  (**)             (*  Make a copy of the new logging state.              (**)                 system_log_status := logging_state;                      (**)              (* Next, if logging is now disabled,              (* then set all logging indicators everywhere to              (* 'Disabled' or 'Not Logging' or whatever.   "            (* In particular, the open rootfile table has a boolean  "              (* logging indicator which will need to be 'false'.                (**)                  IF (logging_state = intr_only)                 THEN FOR loop := one TO max_image_db DO                    opn_tbl_ptr^[loop].logging_status :=false;                  END; (* case of logging state changed *)                   system_access_changed : BEGIN                  (**)  !            (* First, make a local copy of the new system access.  !             (**)                  system_db_access_status := system_access;                   END; (* case of system access changed *)                   warning_log_changed   : BEGIN                  (**)             (* Close the current warning log, then open the new              (* for write access.              (**)                  IF close_file (warning_log_descriptor,                            error)                THEN; (* Don't do anything about an error *)                 warning_log_descriptor.newfl := wlf_name;                  IF open_file_for_append (warning_log_descriptor,                                       error) THEN BEGIN                default_file (warning_log_descriptor.newfl);                IF open_existing_file (warning_log_descriptor,                                        dummy_error) THEN;                GOTO 99;                 END; (* can't open the warning log *)                  END; (* case of warning log changed *)                  shutdown_changed : BEGIN                  IF (open_databases = zero)                THEN BEGIN                    shut_down := true;                    (**)  !                  (* Set message_len to zero so that we don't send !"                  (* a reply to DBUTL (caller) until resign_operation "                  (* has completed.                    (**)                    message_len := zero;                    END       
               ELSE BEGIN  
                   error := databases_are_open_err;  
                  GOTO 99; 
                   END;                      END; (* case of shutdown changed *)                    END; (* case *)            END; (* with dbcon table *)              real_tlf_full_err_flag := false;      real_opn_tbl_full_err_flag := false;      real_att_full_err_flag := false;      real_lock_tbl_full_err_flag := false;         (**)      (* The proper change has been made, so send back an  
   (* 'All is well' reply. 
    (**)          mb_ptr^.user.request := to_user_no_error_code;       
   error := no_image_err;  
     99:  (* error exit *)       END; (* with workhorse_data *)      END; (* change_status_operation *)      .  