$PASCAL ',7 92081-1X481 REV.5000' $      
$ Include '[LBOPT' $ 
     PROGRAM Database_logging_routines;      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18481                                        *)   (* RELOC:   NONE                                               *)   (*                                                             *)   (* PGMR:        <stc>                                          *)   (*                                                             *)   (* Date last modified: <870113.1447>  (*                                                             *)   (* Bug fix, January 16,1986: With RF no-spooling on, DBMON     *)   (* wait for a reply from DBSPL that the log record for DBEND   *)   (* had been posted, unfortunately, any other reply from DBSPL  *)   (* such as 'switching to spare' was interpreted as a fatal     *)   (* error from DBSPL and DBMON would assume rf logging was      *)   (* turned off.                                                 *)   (*                                                             *)   (* Enhancement request, June 24, 1986: Don't post an empty TUB.*)   (*                                                             *)   (***************************************************************)       #$ List OFF, Include '[IMAGE', List ON $  (* General IMAGE defn's.   *) #     $ List OFF, Include '[BMCCT', List ON $  (* Workhorse types *)  #$ List OFF, Include '[BMCTV', List ON $  (* DBMON const, types, vars*) # #$ List OFF, Include '[BMSAM', List ON $  (* DBMON Main defenitions  *) #     #$ List OFF, Include '[QA',    List ON $  (* IMAGE error definitions *) #     $ List OFF, Include '[XDFMP', List ON $  (* FMP externals *)  !$ List OFF, Include '[XDTDY', List ON $  (* Timestamp Externals *) !"$ List OFF, Include '[XBUCP', List ON $  (* Before image externals *) " $ List OFF, Include '[XWBIF', List ON $  (* BIF externals *)  $ List OFF, Include '[XWDDT', List ON $  (* Disc I/O externals *)    $ List OFF, Include '[XEMSG', List ON $  (* Message externals *)  #$ List OFF, Include '[XBSDR', List ON $  (* Commonly used externals. *) #!$ List OFF, Include '[XDCIO', List ON $  (* DBCON I/O externals. *) !    #$ List OFF, Include '[XLGLB', List ON $  (* Logging library externals*) #"$ List OFF, Include '[XERWD', List ON $  (* EMA disc I/O externals *) ""$ List OFF, Include '[XDSMR', List ON $  (* String manipulation    *) ""$ List OFF, Include '[XDLDP', List ON $  (* local dormant program  *) " $ List OFF, Include '[XBQA',  List ON $  (* QA external *)     $ Heapparms OFF $     (**** Copy data into the before-image buffer. ****)      FUNCTION Copy_tuf_header_image  $ Alias 'DBW.MakeBImage' $             (VAR data_ptr    : tuf_header_ptr_type;                  blocks      : Short_int;                   start_block : Long_int;                   type_of_file: image_file_types;  $ Heapparms ON $              VAR file_dcb    : new_file_name; $ Heapparms OFF $              VAR workhorse   : Workhorse_info_type;               VAR error       : Short_int) : Boolean;     EXTERNAL;          	$ Heapparms OFF $  	 PROCEDURE convert_shorti_to_ascii    $ alias 'CITA' $      (     value : short_int;       VAR  asci_string : short_str);     EXTERNAL;          	$ Heapparms OFF $  	 PROCEDURE get_date_and_time_string   $ Alias 'FTIME' $     (VAR time_string : long_str);     EXTERNAL;          FUNCTION move_att   $ Alias 'EMA.MoveWords' $   $ Heapparms ON $     (VAR att_one : active_xaction_table_type;      VAR att_two : active_xaction_table_type;          length  : short_int;      VAR error   : short_int) : Boolean;      EXTERNAL;      $ Page $  (************************************************************)  (*                                                          *)  (* Function  Init_TUB : boolean                             *)  (*                                                          *)  (* Purpose : This routine is responsible for initializing   *)  (* a new transaction log buffer (TUB).  It creates a        *)  (* chunk head log record at the start of the TUB.           *)  (*                                                          *)  (* Input: none                                              *)  (*                                                          *)  (* Output:                                                  *)  (*   (1) Pointer to the chunk head log record               *)  (*   (2) Return error if one occurs                         *)  (*                                                          *)  (* Function value returned:                                 *)  (*    False if no error occurs, true otherwise              *)  (*                                                          *)  (* Called by:                                               *)  (*    (1) Init_log_system                                   *)  (*    (2) Get_new_TUB                                       *)  (*                                                          *)  (* Calls :                                                  *)  (*    (1) Make_gen_log_rec_ptr                              *)  (*    (2) Create_timestamp                                  *)  (*                                                          *)  (************************************************************)     $ Heapparms OFF $      FUNCTION  Init_TUB   $ Alias 'DBM.InitTUB' $     (VAR head_log_rec_ptr : ptr_log_record_header_type;     VAR return_status    : short_int) :    BOOLEAN;     LABEL 99;      (**)  (* Globals initialized :  (*    TUB - transaction log buffer   (*    TUB_next_word - word offset within TUB for next log record  (*    TUB_avail_space - number of words left in the TUB  (* (* Globals referenced :   (*    TUB_prev_chunks_blks_per_chunk - the number of blks in the  (*       previous chunk  (**)     BEGIN     
   (* assume error *) 
 
   Init_TUB := true; 
       TUB_next_word := zero;        (* Create chunk head log record *)    If make_gen_log_rec_ptr ( TUB_ptr^.log_buf[TUB_next_word],                               head_log_rec_ptr,                               return_status) THEN        GOTO 99;         TUB_next_word := TUB_next_word + chunk_head_log_rec_size;     $   (* the reserved space is for the tail (including slop area) and eof *) $   TUB_avail_space := tub_word_size - TUB_reserved_space_size -                        chunk_head_log_rec_size;         (* Fill in head log record *)     WITH head_log_rec_ptr^ DO BEGIN        rec_type := chunk_head_log_code;        rec_len1 := chunk_head_log_rec_size;       create_timestamp (timestamp);       TUB_chunk_sequence_num := TUB_chunk_sequence_num + one; !      IF tub_chunk_sequence_num = maxint THEN  (* wrapped around *) !         tub_chunk_sequence_num := one;            WITH chunk_head DO BEGIN          rec_len2 := chunk_head_log_rec_size;          chunk_seq_num := TUB_chunk_sequence_num;           blks_per_chunk := zero;          prev_blks_per_chunk := TUB_prev_chunks_blks_per_chunk;           checksum_value := zero;          END;        END;     
   Init_TUB := false; 
    99:      END;  (* end init_tub *)  $ Page $  !(****************************************************************) ! !(*                                                              *) ! !(* Function Output_warning_message                              *) ! !(*                                                              *) ! !(* Purpose : This function outputs a warning message to the     *) ! !(* warning file.                                                *) ! !(*                                                              *) ! !(* Input :                                                      *) ! !(*    (1) The warning code.                                     *) ! !(*                                                              *) ! !(* Calls :                                                      *) ! !(*    (1) Send_request                                          *) ! !(*                                                              *) ! !(* Called by :                                                  *) ! !(*    (1) Drain_TUB                                             *) ! !(*    (2) spool_reply_handler                                   *) ! !(*                                                              *) ! !(****************************************************************) !    $ Heapparms OFF $      PROCEDURE Output_warning_message   $ Alias 'DBM.WarningMesg' $    (warning_mesg_code : short_int);     LABEL 99;     VAR 
   wlf_long_str : long_str; 
   return_status : short_int;    number_string : short_str;      BEGIN (* output_warning_message *)        wlf_long_str := ' ';        get_date_and_time_string (wlf_long_str);        IF write_long_str (warning_log_descriptor,                             wlf_long_str,                              return_status) THEN;        wlf_long_str := 'IMAGE Warning';      #   short_int_to_readable_short_str (warning_mesg_code, number_string); #        append_blank_and_str (wlf_long_str, number_string);         IF write_long_str (       warning_log_descriptor, 	      wlf_long_str, 	 
      return_status) THEN; 
       IF post_file (warning_log_descriptor, return_status) THEN;     99:        (* if an error occured, switch the warning log to LU1 *)     IF return_status <> no_image_err THEN BEGIN        default_file (warning_log_descriptor.newfl);            (* open the new one *)  "      IF open_file_for_write (warning_log_descriptor, return_status) "          THEN GOTO 99;            (* Write the message again. *)       IF write_long_str (           warning_log_descriptor,           wlf_long_str,          return_status) THEN;       END; (* end writing warning we switched due to error *)     END; (* output_warning_message *)  $ Page $  (************************************************************)  (*                                                          *)  (* Function determine_if_tuf_full                           *)  (*                                                          *)  (* Purpose : This procedure calculates the number of        *)  (* blocks that needs to be reserved at the end of the       *)  (* TUF to allow the currently active transactions to each   *)  (* log either a DBEND or DBUND log record and to allow      *)  (* a checkpoint to be  performed.  If there is not enough   *)  (* room in the TUF for all currently active transactions    *)  (* to complete, then the function returns the value true.   *)  (*                                                          *)  (************************************************************)     $ Heapparms OFF $     FUNCTION determine_if_tuf_full     $ Alias 'DBM.DetTUFfull' $        : boolean;     CONST    blks_in_logging_text = words_in_logging_text DIV  
      words_in_disc_block; 
    VAR  
   num_active : short_int; 
   res_blocks : short_int;   (*  no. reserved blocks *)    max_blks_available : long_int;  	   ix : short_int; 	    BEGIN        (**)      (* if the save_warning_mesg is tuf_full then clear it.  we'll      (* reset it here if we need to.    (**)    IF save_warning_message_code = tlf_full_warn_code THEN        save_warning_message_code := zero;         num_active := zero;     FOR ix := one to max_IMAGE_users DO        IF (xaction_tbl_ptr^[ix].xaction_num <> -1) THEN           num_active := num_active + one;     !   IF (num_active = zero) THEN     (* only a singleton is active *) !     res_blocks := (2*tub_block_size)    ELSE            (**)  "      (* dbend_chunk_blk_size is the number of blks needed to retain "      (* the dbend log record + chunk head + chunk tail because       (* the tub is flushed at every dbend. We need to always        (* have enough room for the current tub to flush and for       (* all active transactions to end or be undone.       (* Add one more tub_block_size to guarantee we can wrap        (* around the physical end of tuf with at most one tub size  
      (* dummy chunk. 
       (**)           res_blocks :=  num_active * (dbend_chunk_blk_size +                       blks_in_logging_text) +                       (2*tub_block_size);      $   (* calculate the amount of space we have left less reserved blocks *) $    max_blks_available := num_current_avail_tuf_blks - res_blocks;         IF (max_blks_available <= zero) THEN BEGIN        determine_if_tuf_full := true;        save_warning_message_code := tlf_full_warn_code;       END    ELSE       determine_if_tuf_full := false;      END;   (* determine_if_tuf_full   *)  $ Page $ (*************************************************************) (*                                                           *) (* Procedure check_wraparound_status                         *) (*                                                           *) (* Purpose : This procedure determines if all pointers       *) (* to the transaction log file (TUF) have wrapped around     *) (* the physical eof.  This is necessary in order to          *) (* determine (perform pointer block address comparisons)     *) (* if the pointer to the logical beginning of TUF can be     *) (* updated.  An example follows:                             *) (*                                                           *)   (* OT - beginning of oldest transaction                      *)     (* PC - previous checkpoint                                  *)     (* CC - most current checkpoint                              *)     (*                                                           *)     (*                                                           *)     (* a. |-----------------------------------------------|      *)     (*                                ^PC    ^OT   ^CC           *)     (*                                                           *)     (* b. oldest transaction ends                                *)     (*                                                           *)     (*                                                           *)     (* c. |-----------------------------------------------|      *)     (*          ^OT                   ^PC          ^CC           *)     (*                                                           *)     (* d. Procedure 'determine_oldest_tran_addr' calls us.       *)     (*                                                           *)     (* e. checkpoint occurs                                      *)     (*                                                           *)     (* f  |-----------------------------------------------|      *)     (*          ^OT      ^CC                       ^PC           *)     (*                                                           *)     (* g. Procedure 'update_TUF_label' called us.                *)     (*                                                           *)     (* h. another checkpoint occurs                              *)     (*                                                           *)     (* i. |-----------------------------------------------|      *)     (*          ^OT      ^PC    ^CC                              *)     (*                                                           *)     (* j. Procedure 'update_TUF_label' calls us.  We see that    *)     (*    all pointers have wrapped around and clear all flags.  *)     (*                                                           *)     (*                                                           *)     (* Input :                                                   *)     (*   (1) old TUF block number                                *)     (*   (2) new TUF block number                                *)     (*   (3) TUF_wraparound_status flag (field in that record)   *)     (*                                                           *)     (* Called by :                                               *)     (*   (1) drain_tub                                           *)   (*   (2) checkpoint                                          *) (*                                                           *) (*                                                           *) (*************************************************************)     $ Heapparms OFF $     PROCEDURE check_wraparound_status  $ Alias 'DBM.WrapStatus' $    (VAR old_block_num : long_int;     VAR new_block_num : long_int;      VAR flag : boolean);      (**) 	(* Globals altered: 	(*   TUF_wraparound_status record  (*  (**)         BEGIN         IF (new_block_num < old_block_num) THEN 	      flag := TRUE; 	        WITH TUF_wraparound_status DO BEGIN        IF ord(system_log_status) >= ord(rb_rf) THEN BEGIN            IF (spooled) AND (cur_cp) AND (oldest_trans) THEN BEGIN                spooled := false;              cur_cp := false;              oldest_trans := false;               END;   (* end if *)           END   (* end rb_rf *)            ELSE BEGIN    (* else rb only *)           IF (cur_cp) AND (oldest_trans) THEN BEGIN              cur_cp := false;              oldest_trans := false;              END;          END;  (* else rb only *) 
      END; (* with *) 
     END;  $ Page $ (*************************************************************)   (*                                                           *)     (*  Function Update_TUF_label                                *)     (*                                                           *)     (*  Purpose: This function updates the transaction log       *)     (*  file label with the current checkpoint record            *)     (*  address.  The label is the first block of the TUF.       *)     (*  This also updates the TUF_wraparound_status record.      *)     (*                                                           *)     (*  Input:  (1) and (2) The new checkpoint address.          *)     (*          (3) Workhorse data.                              *)     (*  Returns:                                                 *)     (*    (4) Error number if one occurs                         *)     (*                                                           *)     (*  Calls:                                                   *)     (*    (1) Checkwraparound_status                             *)   (*                                                           *) (*  Called by:                                               *) (*                                                           *) (*************************************************************)     $ Heapparms OFF $     FUNCTION update_TUF_label   $ Alias 'DBM.UpdTUFLabel' $     (VAR new_ckpt_block_num : long_int;     VAR new_ckpt_word_off  : short_int;     VAR return_status      : short_int) :  Boolean;     LABEL 99;      (**)  (* globals referenced: (*    xaction_file_id - ID for the transaction log file  (* 	(* globals altered: 	 (*    TUF_label - label for the transaction log file  (*  (**)     VAR    start_time : long_int;     BEGIN      WITH workhorse_data DO BEGIN     
   (* assume error *) 
    update_TUF_label := true;        (* update the label *)  
   WITH TUF_label DO BEGIN 
          check_wraparound_status (           cur_ckpt_rec_block_num,           new_ckpt_block_num,          TUF_wraparound_status.cur_cp);       cur_ckpt_rec_block_num := new_ckpt_block_num;       cur_ckpt_rec_word_off := new_ckpt_word_off;       last_xaction_num := system_xaction_num;      
      END;  (* end with *) 
        start_time := get_start_time;        (* write it to disc *)    IF read_write_disc (       write_code, 
      tlf_descriptor, 
      TUF_label.reserved,  
      one, (* one block *) 
       TUF_label_blk_num,       return_status) THEN        GOTO 99;        WITH sys_stats.system_stats DO BEGIN        tlf_write_io_time := tlf_write_io_time +                            get_elapsed_time (start_time);       tlf_writes := tlf_writes + one;        END;         IF qa_crash_code = qa_update_tuf_label THEN       terminate_program (terminate_code);        update_TUF_label := false;     99:  END; (* with workhorse_data *)  END;  $ Page $ (*************************************************************) (*                                                           *) (*  Function Update_TUF_header                               *) (*                                                           *) (*  Purpose: This function updates the transaction log       *) (*  file header (which includes the TUF label and ATT)       *) (*  with the new checkpoint address and ATT.                 *) (*  This also updates the TUF_wraparound_status record.      *) (*                                                           *) (*  Input:  (1) and (2) The new checkpoint address.          *)   (*          (3) Workhorse data.                              *)     (*  Returns:                                                 *)     (*    (4) Error number if one occurs                         *)     (*                                                           *)     (*  Calls:                                                   *)     (*    (1) Checkwraparound_status                             *)   (*                                                           *) (*  Called by:                                               *) (*                                                           *) (*************************************************************)     $ Heapparms OFF $      FUNCTION update_TUF_Header  $ Alias 'DBM.UpdTUFHeader' $     (VAR new_ckpt_block_num : long_int;     VAR new_ckpt_word_off  : short_int;     VAR return_status      : short_int) :  Boolean;     LABEL 99;      (**)  (* globals referenced: (*    xaction_file_id - ID for the transaction log file  (* 	(* globals altered: 	 (*    TUF_label - label for the transaction log file  (*  (**)     VAR    start_time : long_int;          BEGIN  (* update TUF header *)      WITH workhorse_data DO BEGIN     
   (* assume error *) 
   update_TUF_header := true;        (* update the label *)  
   WITH tuf_label DO BEGIN 
          check_wraparound_status (           cur_ckpt_rec_block_num,           new_ckpt_block_num,          TUF_wraparound_status.cur_cp);       cur_ckpt_rec_block_num := new_ckpt_block_num;       cur_ckpt_rec_word_off := new_ckpt_word_off;       last_xaction_num := system_xaction_num;      
      END;  (* end with *) 
        tuf_header_ptr^.tuf_label := tuf_label;        IF move_att (xaction_tbl_ptr^,                  tuf_header_ptr^.tuf_att,                  len_att,                  error) 	      THEN GOTO 99; 	        start_time := get_start_time;        (* write it to disc *)    IF read_write_disc (       write_code, 
      tlf_descriptor, 
      TUF_header_ptr^.tuf_label.reserved,       num_blks_in_tuf_header,       TUF_header_blk_num,       return_status) THEN        GOTO 99;        WITH sys_stats.system_stats DO BEGIN        tlf_write_io_time := tlf_write_io_time +                            get_elapsed_time (start_time);       tlf_writes := tlf_writes + one;        END;         IF qa_crash_code = qa_update_tuf_label THEN       terminate_program (terminate_code);         update_TUF_header := false;     99:  END; (* with workhorse_data *)  END;  $ Page $ (*************************************************************) (*                                                           *) (* Procedure determine_oldest_tran_addr                      *) (*                                                           *) (* Purpose : This procedure determines the TUF block         *) (* address of the DBBEG log record for the oldest active     *) (* transaction.  It searches the active_transaction_table.   *) (*                                                           *) (* Input : none                                              *) (*                                                           *) (* Returns : none                                            *) (*                                                           *) (* Calls :                                                   *) (*    (1) check_wraparound_status                            *) (*                                                           *) (* Called by :                                               *) (*    (1) bump_beg_of_tuf                                    *) (*                                                           *) (*************************************************************)     $ Heapparms OFF $      !PROCEDURE determine_oldest_tran_addr  $ Alias 'DBM.OldestTrans' $; !        VAR    new_oldest_block_num : long_int;  	   ix : short_int; 	    oldest_tran_num : long_int;      (**) 
(* globals referened: 
 (*   xaction_tbl_ptr - pointer to the active transaction table  #(*   oldest_tran_block_num - block_number where the oldest transaction #(*                           resides in the tuf  (**)     BEGIN        (**)     (* Determine the TUF block number where the oldest active    (* transaction log record resides by looking through the    (* active transaction table.    (**)         oldest_tran_num := maxdint;     FOR ix := 1 to max_IMAGE_users DO        WITh xaction_tbl_ptr^[ix] DO           IF (xaction_num < oldest_tran_num) and (* is older *)  #            (xaction_num <> -1) and   (* is not a free entry in att *) # #            (block_num <> zero)  (* has been written to tuf already *) #             THEN BEGIN             oldest_tran_num := xaction_num;              new_oldest_block_num := block_num;             END;   (* end if *)        (**)  #   (* if there were no transaction left, then the tuf block number for #     (* the oldest transaction is the current ckpt block (if there     (* has been a checkpoint) OR the next available tuf block.    (**) #   IF oldest_tran_num = maxdint THEN BEGIN (* did not find a xaction *) #      new_oldest_block_num := tuf_label.cur_ckpt_rec_block_num;       WITH tuf_wraparound_status DO BEGIN           oldest_trans := cur_cp;           check_wraparound_status (                oldest_tran_block_num,                 new_oldest_block_num,                oldest_trans);          END;  (* with *)        END   (* if no transactions in progress *)          ELSE    (* there is an oldest transaction *)             (* Did our new oldest block num wrap us around the TUF? *)          check_wraparound_status (            oldest_tran_block_num,      (* previous block number *)            new_oldest_block_num,            TUF_wraparound_status.oldest_trans);     !   (* set the global with our new oldest tran's tuf block number *) !   oldest_tran_block_num := new_oldest_block_num;     END;   (* end determine_oldest_tran_addr *)  $ Page $  (***************************************************************)   (*                                                             *)   (* Procedure Bump_beg_of_TUF                                   *)   (*                                                             *)   (* Purpose : This procedure updates the logical beginning      *)   (* of TUF whenever space can be recovered in the circular      *)   (* TUF. Space is RECOVERED in block units. The following       *)   (* three pointers must be compared to discover the oldest.     *)   (* (1) last block spooled (acknowledged by DBSPL)              *)   (* (2) current checkpoint                                      *)   (* (3) beginning of the oldest transaction                     *)   (*                                                             *)   (* Input :  no one                                             *)   (*                                                             *)   (* Returns :  nothing                                          *)   (*                                                             *)   (* Calls :                                                     *)   (*   (1) determine_oldest_tran_addr                            *)   (*                                                             *)   (* Called by :                                                 *)   (*   (1) drain_tub                                             *)   (*   (2) spool_reply_handler                                   *)   (*                                                             *)   (***************************************************************)      $ Heapparms OFF $      PROCEDURE bump_beg_of_TUF  $ Alias 'DBM.BumpBegOfTUF' $;      (**) (* globals referenced :  "(*   spooled_block_num - the block number of the last block spooled. "(*      (aknowledged by DBSPL). (*   TUF_label - the one block transaction log file label (*   TUF_wraparound_status - the boolean array containing the  (*     wraparound status of the pointers to the TUF. (*   system_log_status - logging status  (*  
(* globals altered : 
 %(*   logical_beg_of_TUF : the block number of the logical beginning of TUF %%(*   num_current_avail_TUF_blks : the number of available blocks in the TUF % (*  (*   TUF_full_warn_flag !!!!!!!!!!  (**)      VAR      return_status : short_int;       (**)  "(* This function compares the pointer to the current checkpoint with " (* the pointer to the last spooled block to determine the oldest.   !(* The tuf_wraparound_status flags are used to determine direction !(* of comparison.  (**)      
FUNCTION compare_cp_and_sp 
    (VAR cur_cp_blk : long_int;  %    VAR sp_blk : long_int ) : long_int;  (* returns oldest block number *) %    VAR    oldest_blk : long_int;     BEGIN      #   (* this structure (tuf_wraparound_status) contains boolean flags *) #    WITH TUF_wraparound_status DO        IF cur_cp = spooled  THEN       (* same cycle *)           IF cur_cp_blk < sp_blk THEN              oldest_blk := cur_cp_blk          ELSE              oldest_blk := sp_blk        ELSE                       (* different cycle *)          IF cur_cp THEN  "            oldest_blk := sp_blk (* current cp has wrapped around *) "         ELSE  &            oldest_blk := cur_cp_blk;  (* last spooled has wrapped around *) &       compare_cp_and_sp := oldest_blk;      END;  (* end function *)          (**)  (* Function to compare the pointers to the  oldest (* transaction with the pointer to the last spooled block.  The  (* oldest of the blocks is returned.  (* The tuf_wraparound_status flags are used to determine the 
(* direction of comparison. 
 (**)          
FUNCTION compare_ot_and_sp 
 
   (VAR ot_blk : long_int; 
 %    VAR sp_blk : long_int ) : long_int;  (* returns oldest block number *) %    VAR    oldest_blk : long_int;     BEGIN         WITH TUF_wraparound_status DO        IF oldest_trans = spooled  THEN   (* same cycle *)           IF ot_blk < sp_blk THEN              oldest_blk := ot_blk          ELSE              oldest_blk := sp_blk       ELSE                              (* different cycle *)  $         IF oldest_trans THEN       (* oldest tran has wrapped around *) $             oldest_blk := sp_blk $         ELSE                       (* last spooled has wrapped around *) $            oldest_blk := ot_blk;        compare_ot_and_sp := oldest_blk;      END;  (* end function *)         
(* Begin Bump_beg_of_TUF *) 
    BEGIN      WITH workhorse_data DO BEGIN        (**)     (* Determine the oldest transaction tuf block    (**)     determine_oldest_tran_addr;        WITH tuf_label, tuf_wraparound_status DO BEGIN            (**)        (* Compare the 'oldest transaction ' pointer and the       (* 'current checkpointer' pointer to find the oldest.       (* Then, if roll forward logging, compare the results        (* with the 'spooled' pointer.        (**)           IF (cur_cp = oldest_trans) THEN BEGIN            (* In same cycle around TUF *)     #         IF (cur_ckpt_rec_block_num < oldest_tran_block_num) THEN BEGIN #             IF ord(system_log_status) >= ord(rb_rf) THEN                 logical_beg_of_TUF := compare_cp_and_sp (                                            cur_ckpt_rec_block_num,                                             spooled_block_num)              ELSE                logical_beg_of_TUF := cur_ckpt_rec_block_num              END (* end if cp < old tran *)          ELSE              IF ord(system_log_status) >= ord(rb_rf) THEN                 logical_beg_of_TUF := compare_ot_and_sp (                                          oldest_tran_block_num,                                          spooled_block_num)              ELSE                 logical_beg_of_TUF := oldest_tran_block_num 
         END   (* end if *) 
           ELSE BEGIN       (* In different cycles around TUF  *)              IF TUF_wraparound_status.cur_cp THEN              IF ord(system_log_status) >= ord(rb_rf) THEN                 logical_beg_of_TUF := compare_ot_and_sp (                                          oldest_tran_block_num,                                          spooled_block_num)              ELSE                 logical_beg_of_TUF := oldest_tran_block_num          ELSE              IF ord(system_log_status) >= ord(rb_rf) THEN                 logical_beg_of_TUF := compare_cp_and_sp (                                            cur_ckpt_rec_block_num,                                           spooled_block_num)              ELSE                 logical_beg_of_TUF := cur_ckpt_rec_block_num;          END;  (* end else *)            (**) !      (* If no checkpoint has occurred yet (initial condition) then ! "      (* use the first tuf block as our logical beginning.  This may "        (* not be optimal, but suffices (less code) for a starting        (* point.        (**)           IF logical_beg_of_TUF = zero THEN          logical_beg_of_TUF := tuf_first_blk_num;            WITH sys_stats.system_stats DO BEGIN           tlf_writes := tlf_writes + one;            (* update the label *)       IF tuf_label_io (           tlf_descriptor,  
         write_code, 
	         tuf_label, 	
         tlf_write_io_time, 
         return_status) THEN;               END; (* with stats *)            (**)        (* Update the number of available TUF blks        (*        (*  - we have a circular TUF - label must be skipped        (*       (*                no. avail        (*             *.............*         (* CASE 1   -- |--------------|--------------------------|   #      (*         tuf_next_blk     logical_beg_of_tuf  tuf_last_blk_num # "      (*                                              (physical end) "       (*        (*           no.avail +                    no. avail         (*          ........*               *...................*           (* CASE 2   ---------|-------------|---------------------|   $      (*           logical_beg_of_tuf   tuf_next_blk   tuf_last_blk_num  $ #      (*                                               (physical end)  #       (*        (**)                num_current_avail_tuf_blks :=   (* case 1 *)          logical_beg_of_tuf - tuf_next_blk;                IF num_current_avail_tuf_blks <= zero THEN           num_current_avail_tuf_blks :=    (* case 2 *)             (TUF_last_blk_num - tuf_next_blk + one) +              (logical_beg_of_tuf - num_blks_in_TUF_header);        END;  (* end with *)        (* determine if the tuf is full *)    tuf_full_warn_flag := determine_if_tuf_full;     END;  (* with workhorse_data *)     END;  (* end bump_beg_of_TUF *)  $ Page $  !(****************************************************************) ! !(*                                                              *) ! !(* Function dbspl_message_sender                                *) ! !(*                                                              *) ! !(* Purpose : This procedure forms the message header for        *) ! !(* messages sent to DBSPL and then sends it.                    *) ! !(*                                                              *) ! !(* Input :                                                      *) ! !(*    (1) request code                                          *) ! !(*    (2) message length (words)                                *) ! !(*                                                              *) ! !(* Returns :                                                    *) ! !(*    (3) return status (0 if okay)                             *) ! !(*                                                              *) ! !(****************************************************************) !     	$ HEAPPARMS OFF $  	     FUNCTION dbspl_message_sender   $ Alias 'DBM.SpoolSender' $      (    spool_request : short_int;          spool_msg_len : short_int;     VAR return_status : short_int) : BOOLEAN;         LABEL 99;     	$ Include '[PROG' $ 	     TYPE    immediate_reply_buffer_type = RECORD       from_comm_id   : short_int;       from_comm_lock : short_int;       to_comm_id     : short_int;       to_comm_lock   : short_int;       request        : short_int;       reply_status   : short_int;        spooled_block  : long_int;        END;         VAR     mesg_len : short_int;    waiting_for_reply : boolean;    immediate_buffer  : immediate_reply_buffer_type;     next_block        : long_int;          (**)  	(* Globals used :  	 (*    (1) image_comm_buffer   (*    (2) DBSPL message buffer.   (*  (**)      BEGIN  (* dbspl_message_sender *)          (* assume error *)          dbspl_message_sender := true;         (* determine if dbspl is alive *)     IF local_dormant_program (dbspl_program) THEN BEGIN        return_status := dbspl_comm_err;        GOTO 99;        END;         WITH dbspl_mesg_buf, image_comm_buffer DO BEGIN        from_comm_id := dbmon_comm_id;        from_comm_lock := dbmon_comm_lock;        to_comm_id := dbspl_comm_id;        to_comm_lock := dbspl_comm_lock;       request := spool_request;        END;      
   IF send_request ( 
           dbspl_mesg_buf.from_comm_id,            spool_msg_len,            return_status) 	      THEN GOTO 99; 	           (**)        (* To fix the Feb '84 bug, DBMON with the no-spooling         (* option will wait for DBSPL to post its buffer to the          (* RFL.  This will guarantee the user that the transaction         (* is recoverable.        (**)            waiting_for_reply := true;           IF (system_log_status = rf_nospool) AND          (spool_request = to_spl_spool_code) THEN            WHILE (waiting_for_reply) DO BEGIN              (**)          (* Wait for DBSPL's reply.          (**)               WITH image_comm_buffer DO              IF get_message (spl_reply_comm_id,                              zero, (* no resource number *)                              zero, (* wait for message *)                              immediate_buffer.from_comm_id,                             mesg_len,                             to_bm_spool_reply_mesg_len,                              return_status)                 THEN GOTO 99;              WITH immediate_buffer DO BEGIN     "            IF (request = to_bm_spl_spool_reply_mesg_code) THEN BEGIN "                waiting_for_reply := false;                 IF reply_status = zero THEN BEGIN                    next_block := spooled_block;                   check_wraparound_status (                        tuf_label.spooled_block_num,                         next_block,                         tuf_wraparound_status.spooled);                    tuf_label.spooled_block_num := next_block;                    bump_beg_of_tuf;                   END; (* then non-error reply *)                 END; (* then a spool reply *)                  IF (request = to_bm_spl_contlog_reply_mesg_code)                THEN spl_save_error := zero;                  IF reply_status <> zero THEN BEGIN                save_warning_message_code := reply_status;                IF (reply_status = spare_rfl_missing_err) OR                   (reply_status = spare_rfl_undefined_err) OR                   (reply_status = rfl_device_not_ready_err)                    THEN spl_save_error := reply_status; 	               END; 	     #            IF (reply_status = dbspl_terminating_warn_code) THEN BEGIN #                system_log_status := rb_only;                spl_save_error    := zero; 	               END; 	                 END; (* with immediate buffer *)              END;  (* while waiting for DBSPL to reply *)        dbspl_message_sender := false;  (* successful *)      99 :      END;  (* end dbspl_message_sender *)  $ Page $  (************************************************************)  (*                                                          *)  (* Function Drain_TUB                                       *)  (*                                                          *)  (* Purpose : This function handles writing the TUB chunk    *)  (* to the TUF.  It is aware of special situations, such     *)  (* as wrapping around the physical end of TUF.              *)  (*                                                          *)  (* Input :                                                  *)  (*   (1) Number of required TUF blocks for the write        *)  (*                                                          *)  (* Returns:                                                 *)  (*   (2) return_status - if an error occurs, the error      *)  (*                      number is returned.                 *)  (*                                                          *)  (* Called by:                                               *)  (*   (1) Get_new_TUB                                        *)  (*                                                          *)  (* Calls:                                                   *)  (*   (1) Chunk_IO                                           *)  (*   (2) make_gen_log_rec_ptr                               *)  (*                                                          *)  (* Enhancement request:  June 24, 1986                      *)  (*    Do not post an 'empty' TUB to the transaction log.    *)  (*    A customer found that a database without logging      *)  (*    enabled (but system logging was RF spooled) caused    *)  (*    log records to be generated anyway.  This was due     *)  (*    to DBMON posting the TUB when the TUB only contained  *)  (*    chunk head and chunk tail log records.                *)  (*    DBMON now checks for a tub_next_word equal to the     *)  (*    chunk head log record length, which means the TUB     *)  (*    is empty and doesn't need to be posted.  <MRL>        *)  (*                                                          *)  (************************************************************)     $ Heapparms OFF $     FUNCTION Drain_TUB   $ Alias 'DBM.DrainTUB' $     (    num_blocks_in_TUB_chunk : short_int;      VAR return_status           : short_int) :    BOOLEAN;     LABEL 99;     VAR     warning_code     : short_int;    head_log_rec_ptr : ptr_log_record_header_type;    num_blks_till_phys_end : long_int;     TUB_flush_start_TUF_blk : long_int;     BEGIN  WITH workhorse_data DO BEGIN      (**) (* Globals referenced or used :  (*    tuf_next_blk - next available tuf block number  (*    tuf_wraparound - true if we're wrapping around physical eof   (*    tlf_descriptor - file descriptor for the tuf  (**)             (* See if the TUB is empty.  Don't post an empty TUB *)     IF TUB_next_word = chunk_head_log_rec_size THEN BEGIN       Drain_TUB := false;        GOTO 99;        END;     
   (* assume error *) 

   Drain_TUB := true; 
       (* Write the TUB chunk to the TUF *)    TUB_flush_start_TUF_blk := TUF_next_blk;        WITH sys_stats.system_stats DO BEGIN      
   write_TUF_chunk ( 
        tlf_descriptor,         TUB_ptr^,          TUB_flush_start_TUF_blk,          num_blocks_in_TUB_chunk,         true,  (* attach eof block *)          TUF_next_blk,            (* returns last block written *)   
        tlf_write_io_time, 
        return_status);           tlf_writes := tlf_writes + one; 
      END; (* with stats *) 
       (* SPECIAL FOR QA ONLY! *)     IF qa_crash_code = qa_chunk_IO THEN       terminate_program (terminate_code);         IF return_status <> zero THEN        GOTO 99;        (**)     (* If roll forward logging, then spool out the chunk.    (**)            IF ord(system_log_status) >= ord(rb_rf) THEN BEGIN        WITH sys_stats.system_stats DO           rlb_writes := rlb_writes + one;            WITH dbspl_mesg_buf.spool DO BEGIN           start_block := TUB_flush_start_tuf_blk; $         end_block := TUF_next_blk - one;  (* do not include eof block *) $         END;  (* with *)       IF dbspl_message_sender ( 
         to_spl_spool_code, 
         to_spl_spool_mesg_len,           return_status) THEN BEGIN          (**)          (* dbspl is not around - turn off roll forward logging           (* and writing a warning message.          (**)           save_warning_message_code := return_status;          return_status := zero;           system_log_status := rb_only;          END;            END;     
   (* did we wraparound? *) 
   IF tuf_wraparound THEN BEGIN &      (* update the label with corrected dummy count - include old eof blk *) &       tuf_label.num_dummy_blks := tuf_label.num_dummy_blks + one;             WITH sys_stats.system_stats DO BEGIN           IF tuf_label_io (           tlf_descriptor,  
         write_code, 
	         tuf_label, 	
         tlf_write_io_time, 
          return_status) THEN          GOTO 99;               tlf_writes := tlf_writes + one;           END; (* with stats *)            tuf_wraparound := false;     	     END;  (* if *) 	       (**) !   (* Do we need to update the number of blocks in the dummy chunk? ! !   (* i.e. we are approaching the physical end of TUF and may have !   (* a different number of unused blocks this time around.    (* If so, there are two steps to the update.      (*   (1) write the number of dummy blocks into the label - do     (*       not include the logical eof block in the count. !   (*   (2) indicate we are wrapping around so that the first write !   (*       to the beginning of TUF will know to update the tuf    (*       label to include the previous chunk's logical eof     (*       block into the dummy block count.  This is done in    (*       two steps because we do not want to ever lose the     (*       logical eof block.    (**)     !   num_blks_till_phys_end := TUF_last_blk_num - TUF_next_blk + one; !        (* enough blocks left for maximum TUB flush? *)     IF (num_blks_till_phys_end < tub_block_size) THEN BEGIN            TUF_wraparound := true;          num_current_avail_tuf_blks := num_current_avail_tuf_blks -            num_blks_till_phys_end;           (* do not include the eof block at this time.  *)       TUF_label.num_dummy_blks := num_blks_till_phys_end - one;        TUF_next_blk := TUF_first_blk_num;            WITH sys_stats.system_stats DO BEGIN           (* write the label to disc *)       IF TUF_label_IO (           tlf_descriptor,  
         write_code, 
	         tuf_label, 	
         tlf_write_io_time, 
          return_status) THEN          GOTO 99;               tlf_writes := tlf_writes + one;           END; (* with stats *)      
      END;  (* if *) 
        drain_TUB := false;     99:  END; (* with workhorse_data *)  END;  $ Page $  (************************************************************)  (*                                                          *)  (* Function Get_new_TUB  : boolean                          *)  (*                                                          *)  (* Purpose : This function is called whenver the TUB        *)  (* is full (i.e. has no room for another log record)        *)  (* OR when the TUB must be flushed due to a transaction end *)  (* OR when checkpoint occur.                                *)  (* Its job is to prepare the chunk (the part of the TUB     *)  (* which is written to the TUF) for flushing, and to        *)  (* initialize the new TUB.                                  *)  (*                                                          *)  (* Input:                                                   *)  (*                                                          *)  (* Returns:                                                 *) (*   (1) return_status - error number if an error occurs     *)  (*                                                          *)  (* Function value returned                                  *)  (*   False if no error occurs, true otherwise.              *)  (*                                                          *)  (* Called by:                                               *)  (*   (1) Make_log_record                                    *)  (*   (2) End_operation                                      *)  (*   (3) Checkpoint                                         *)  (*                                                          *)  (* Calls:                                                   *)  (*    (1) Drain_TUB                                         *)  (*    (2) Init_TUB                                          *)  (*    (3) make_gen_log_rec_ptr                              *)  (*    (4) make_eof_block_ptr                                *)  (*                                                          *)  (************************************************************)     $ Heapparms OFF $      FUNCTION Get_new_TUB   $ Alias 'DBM.GetNewTUB' $    (VAR return_status  : short_int) :    BOOLEAN;     LABEL 99;     VAR    log_head_ptr : ptr_log_record_header_type;    log_tail_ptr : ptr_log_record_header_type;     chunk_eof_block_ptr : ptr_TUF_eof_block_type; $   number_slop_words : short_int;   (* extra words in chunk, excluding *) $$                                    (* minimal chunk tail log rec len  *) $$   tail_log_rec_len : short_int;    (* length of chunk tail log record *) $    BEGIN        Get_new_TUB := true;  (* assume error *)        last_log_rec_word_offset := tub_next_word;        (* Create a chunk tail log record *)    IF make_gen_log_rec_ptr ( TUB_ptr^.log_buf[TUB_next_word],                               log_tail_ptr,                               return_status) THEN        GOTO 99;         (**)   %   (* The length of the chunk tail log record is determined by the number  %    (* of words needed to end the record on a block boundary.  #   (* The number of 'slop words' excludes the fixed number of words in #    (* a chunk tail log record.     (**)      &   (* the chunk tail log rec size does NOT includes the second length word *) &    TUB_next_word := TUB_next_word + chunk_tail_log_rec_size;    number_slop_words := words_in_disc_block -                           (TUB_next_word MOD words_in_disc_block);  !   tail_log_rec_len := number_slop_words + chunk_tail_log_rec_size; !        (* Fill the general chunk tail log record fields *)     WITH log_tail_ptr^ DO BEGIN       rec_len1 := tail_log_rec_len;        rec_type := chunk_tail_log_code;       create_timestamp (timestamp);       chunk_tail.num_slop_words := number_slop_words;        END;        (* reposition to exclude second length word *)     TUB_next_word := TUB_next_word - one;         IF fill_with_word (        number_slop_words,        TUB_ptr^.log_buf[TUB_next_word],        zero,   
      return_status) THEN  
       GOTO 99;      "   (* Store the log record length in the last word of the record *)  "    TUB_next_word := TUB_next_word + number_slop_words;     TUB_ptr^.log_buf[TUB_next_word] := tail_log_rec_len;          TUB_next_word := succ (TUB_next_word);              (**)   !   (* Compute the number of blocks in this soon to be gone chunk.  !    (* The DIV operation had better NOT have any remainders.      (* The computation does NOT include the EOF block.      (**)          TUB_prev_chunks_blks_per_chunk := TUB_next_word  DIV                                        words_in_disc_block;       $   (* Must be at least one block - thats why theres a tail log record *) $    IF TUB_prev_chunks_blks_per_chunk < one THEN BEGIN         return_status := dbmon_internal_err;        GOTO 99;        END;         (* Fill in the chunk head log information *)      IF make_gen_log_rec_ptr ( TUB_ptr^.log_buf[zero],                               log_head_ptr,                               return_status) THEN        GOTO 99;         WITH log_head_ptr^.chunk_head DO BEGIN         blks_per_chunk := TUB_prev_chunks_blks_per_chunk;   $      TUF_block_num := TUF_next_blk;  (* Where in the TUF this chunk *)  $ $                                      (* will be written .           *)  $       log_tail_ptr^.chunk_tail.tuf_block_num :=   %         tuf_next_blk + blks_per_chunk - (* Last TUF block occupied by  *) % %         one;                            (* this chunk.                 *) %       checksum_value := checksum_short (           TUB_ptr^.log_buf[zero],          first_chunk_checksum_word,          last_chunk_checksum_word);        END;         last_log_rec_block := tuf_next_blk;        (* flush this TUB chunk *)    IF Drain_TUB ( TUB_prev_chunks_blks_per_chunk,                   return_status) THEN        GOTO 99;        (* decrement the number of available TUF blks *)    num_current_avail_TUF_blks := num_current_avail_TUF_blks -                                    TUB_prev_chunks_blks_per_chunk;         (* Initialize our new empty TUB *)     IF init_TUB (log_head_ptr,return_status) THEN        GOTO 99;        Get_new_TUB := false; (* no error *)     99:  (* error return *)      END;  $ Page $  (************************************************************)  (*                                                          *)  (* Procedure REMOVE_LOG_RECORD;                             *)  (*                                                          *)  (* Purpose: To reset the pointers to the 'next available    *)  (* log record space' back to the beginning of the current   *)  (* aborted intrinsic's log record.  (The intrinsic did not  *)  (* succeed, therefore the log record is unneeded).          *)  (*                                                          *)  (* Inputs: None                                             *)  (*                                                          *)  (* Outputs: None.                                           *)  (*                                                          *)  (* Errors: None.                                            *)  (*                                                          *)  (* Calls : No one                                           *)  (*                                                          *)  (* Called by :                                              *)  (*   (1)  beg_operation                                     *)  (*   (2)  cls_operation                                     *)  (*   (3)  del_operation                                     *)  (*   (4)  end_operation                                     *)  (*   (5)  mem_operation                                     *)  (*   (6)  opn_operation                                     *)  (*   (7)  put_operation                                     *)  (*   (8)  und_operation                                     *)  (*   (9)  upd_operation                                     *)  (*                                                          *)  (************************************************************)     $ Heapparms OFF $     PROCEDURE remove_log_record  $ Alias 'DBM.RemoveLogRec'  $;      (**) 	(* globals altered: 	(*    TUB_next_word - next available TUB word (*    TUF_avail_space - amount of TUB available space, in words  (**)     BEGIN        TUB_next_word := TUB_next_word - cur_log_rec_size;    TUB_avail_space := TUB_avail_space + cur_log_rec_size;      END;  $ Page $  (************************************************************)  (*                                                          *)  (* Function MAKE_LOG_RECORD : boolean;                      *)  (*                                                          *)  (* Purpose: To create room in the transaction log buffer    *)  (* for another log record, flushing the buffer if necessary.*)  (* After the room is acquired, the header portion is filled *)  (* in with the necessary data.                              *)  (*                                                          *)  (* Input:                                                   *)  (*    (1) The log record type (integer value).              *)  (*    (2) The size of the log record in words.              *)  (*                                                          *)  (* Output:                                                  *)  (*    (3) Pointer to the start of the log record            *)  (*    (4) The TUF block number where the log record         *)  (*        will reside - currently needed only for DBBEG.    *)  (*    (5) The return error number, if an error occurs.      *)  (*                                                          *)  (* Function result:                                         *)  (*    'FALSE' if the function completes successfully.       *)  (*    'TRUE' if any error (I/O) occurs.                     *)  (*                                                          *)  (* Calls:                                                   *)  (*   (1) Make_gen_log_rec_ptr                               *)  (*   (2) Get_new_TUB                                        *)  (*                                                          *)  (* Called by:                                               *)  (*   (1)  beg_operation                                     *)  (*   (2)  cls_operation                                     *)  (*   (3)  del_operation                                     *)  (*   (4)  end_operation                                     *)  (*   (5)  mem_operation                                     *)  (*   (6)  opn_operation                                     *)  (*   (7)  put_operation                                     *)  (*   (8)  und_operation                                     *)  (*   (9)  upd_operation                                     *)  (*                                                          *)  (************************************************************)     $ Heapparms OFF $     FUNCTION make_log_record   $ Alias 'DBM.MakeLogRec' $    (    log_rec_type   : log_record_type;         log_rec_size   : short_int;      VAR log_rec_ptr    : ptr_log_record_header_type;      VAR log_block_num  : long_int;      VAR return_status  : short_int) : BOOLEAN;     LABEL 99;      (**)  (*  globals referenced : #(*     logging_initialized - true if image log subsystem is initialized # (* 
(*  globals altered : 
  (*     TUB_avail_space - amount of available TUB space, in words   !(*     TUB_next_word - next available word in TUB (starts at zero) ! (*     cur_log_rec_size - current log record size in words  (*  (*  (**)      BEGIN (* Function MAKE_LOG_RECORD *)      WITH workhorse_data DO BEGIN        return_status := no_image_err;         make_log_record := true;   (* assume error *)     log_rec_ptr := nil;        WITH sys_stats.system_stats DO       tlb_writes := tlb_writes + one;        (**)    (* if dbspl has run into problems (i.e. tape off line or     (* roll forward log is full), then do not perform     (* any logging until we get the okay from dbspl    (**)    IF (spl_save_error <> zero) THEN BEGIN        return_status := spl_save_error;        GOTO 99;        END;        (**)     (* Is there room in the TUF for more log records?    (* determine_if_tuf_full will set the save_warning_mesg_code    (* if the tuf is full.    (**)         tuf_full_warn_flag :=  determine_if_tuf_full;    IF tuf_full_warn_flag THEN BEGIN        (**)        (* TUF IS FULL.  Time to recover some space.         (* Update the pointer to the logical beginning of TUF.  It        (* checks to see how much space is left in the TUF.  If        (* there is not enougn space for one more flush plus for       (* currently active transactions to end or undo, then !      (* a flag is set to ONLY allow dbends, undos and checkpoints. !       (* 'Bump_beg_of_tuf' updates the tuf_full_warn_flag.       (* It also calls determine_if_tuf_full to reset the       (* tuf_full_warn_flag and save_warning_mesg_code.        (**)        bump_beg_of_tuf;        IF tuf_full_warn_flag THEN BEGIN           IF (log_rec_type <> dbend_log_code) AND             (log_rec_type <> dbund_log_code) THEN BEGIN             return_status := transaction_log_file_full_err;              (**)              (* Did we succeed last time we did cleanup due               (* to log full problem?  If not, (flag is true) then              (* don't try cleanup again.              (**)              IF NOT (real_tlf_full_err_flag) THEN BEGIN                auto_cleanup_needed := true;                 real_tlf_full_err_flag := true; 	               END; 	 
            GOTO 99; 
            END;          (* end if not dbend or dbund     *)           END  (* end if tuf is full after bumping bof *)       END;  (* if tuf_full *)        (**)     (* (1) Is there room in the transaction log buffer for   
   (*     the log record?  
    (*     NO: Flush the transaction log buffer (TUB) to disc.      (*         Initialize the next TUB      (* (2) Determine where the log record will begin.     (* (3) Update the TUB's next available location address.      (* (4) Fill in the header of the log record.      (*     (**)          !   (* Is the remaining room in the TUB enough for this log rec? *) !       TUB_avail_space := TUB_avail_space - log_rec_size;    IF (TUB_avail_space < zero) THEN BEGIN           (* Must get new TUB - resets TUB_avail_space *)       IF get_new_TUB (return_status) THEN          GOTO 99;        TUB_avail_space := TUB_avail_space - log_rec_size;     %      (* there SHOULD be enough space in the TUB for the largest log rec *) %       IF (TUB_avail_space < zero) THEN BEGIN          return_status := dbmon_internal_err;          GOTO 99; 
         END;  (* end if *) 
      END;   (* end if *)            (* Allocate the space and initialize the log record *)        IF make_gen_log_rec_ptr ( TUB_ptr^.log_buf[TUB_next_word],                              log_rec_ptr,                               return_status) THEN        GOTO 99;         IF fill_with_word (        (* fill with zeroes *) 	      log_rec_size, 	 "      log_rec_ptr^.rec_len1,  (* log record address - first field *) "       zero,   
      return_status) THEN  
       GOTO 99;         (* Return the TUF block number where chunk will reside *)     log_block_num := TUF_next_blk;          (* SPECIAL TEST FOR QA ONLY *)     If qa_crash_code = qa_make_log_record THEN       terminate_program (terminate_code);                TUB_next_word := TUB_next_word + log_rec_size;        WITH log_rec_ptr^ DO BEGIN "       rec_len1 := log_rec_size;             (* header length word *) "        rec_type := log_rec_type;         create_timestamp (timestamp); "       buffer[log_rec_size] := log_rec_size; (* Tailer length word *) "       END;         (* Sets the global value of the current log record size. *)     cur_log_rec_size := log_rec_size;     make_log_record := false;  (* no error *)      99: (* error return *)      END; (* with workhorse_data *)     END; (* Function MAKE_LOG_RECORD *)  $ Page $   (**************************************************************)    (*                                                            *)    (* Function copy_TUF_label                                    *)    (*                                                            *)    (* Purpose : This function creates a before image of the      *)    (* TUF label.                                                 *)    (*                                                            *)    (* Input:  none                                               *)    (*                                                            *)    (* Returns : error number if an error occurs                  *)    (*                                                            *)    (* Function value returned :                                  *)    (*    False if no error occurs, true otherwise.               *)    (*                                                            *)    (* Calls :                                                    *)    (*    (1) copy_before_image                                   *)    (*                                                            *)    (* Called by :                                                *)    (*    (1) checkpoint                                          *)    (*                                                            *)    (*                                                            *)    (**************************************************************)      $ Heapparms OFF $      Function copy_TUF_label   $ Alias 'DBM.CopyTUFLabel' $     (VAR return_status  : short_int ) :    BOOLEAN;         LABEL 99;         BEGIN     
   (* assume error *) 
 
   copy_TUF_label := true; 
       IF get_tuf_label_ptr (        tuf_label,  
      tuf_label_ptr, 
      return_status) THEN        GOTO 99;        IF copy_before_image (  
      TUF_label_ptr, 
       num_blks_in_TUF_label,        TUF_label_blk_num,       TLF, (* type of file being before-imaged *) 
      tlf_descriptor.newfl, 
      workhorse_data, 
      return_status) THEN        GOTO 99;     
   copy_TUF_label := false; 
    99:      END;  $ Page $   (**************************************************************)    (*                                                            *)    (* Function copy_TUF_header                                   *)    (*                                                            *)    (* Purpose : This function creates a before image of the      *)    (* TUF header.                                                *)    (*                                                            *)    (* Input:  none                                               *)    (*                                                            *)    (* Returns : error number if an error occurs                  *)    (*                                                            *)    (* Function value returned :                                  *)    (*    False if no error occurs, true otherwise.               *)    (*                                                            *)    (* Calls :                                                    *)    (*    (1) copy_before_image                                   *)    (*                                                            *)    (* Called by :                                                *)    (*    (1) checkpoint                                          *)    (*                                                            *)    (*                                                            *)    (**************************************************************)      $ Heapparms OFF $      Function copy_TUF_header  $ Alias 'DBM.CopyTUFHeade' $     (VAR return_status  : short_int ) :    BOOLEAN;         LABEL 99;     BEGIN     
   (* assume error *) 

   copy_TUF_header := true; 
       IF copy_tuf_header_image ( 
      TUF_header_ptr, 
      num_blks_in_TUF_header,       TUF_header_blk_num,       TLF, (* type of file being before-imaged *) 
      tlf_descriptor.newfl, 
      workhorse_data, 
      return_status) THEN        GOTO 99;         copy_TUF_header := false;     99:      END;  $ Page $  (************************************************************)  (*                                                          *)  (* Procedure spool_reply_handler                            *)  (*                                                          *)  (* Purpose : To handle replies  received from the spool     *)  (* program.                                                 *)  (*                                                          *)  (************************************************************)      PROCEDURE spool_reply_handler  $ Alias 'DBM.SpoolReply' $;     VAR 	   dummy : boolean; 	 
   reply : long_int; 
   return_status : short_int;  
   spl_status : short_int; 
   next_block : long_int;     BEGIN  WITH workhorse_data DO BEGIN         WITH MB_ptr^.dbmon DO BEGIN     
      CASE request OF 
             (* reply from a spool request *)           to_bm_spl_spool_reply_mesg_code :             IF spl_reply.status = zero THEN BEGIN                    WITH sys_stats.system_stats DO BEGIN                   rlf_writes := rlf_writes + one;                    rlf_write_io_time := rlf_write_io_time +                                          spl_reply.rfl_write_time;                     END;     	               (**) 	!               (* Spooled_block pts to start of last spooled chunk. !                (* We must refer only to blocks which begin chunks   !               (* because this ptr is used in considering what the !               (* logical beginning of TUF should be. 	               (**) 	               next_block := spl_reply.spooled_block;                 check_wraparound_status (                    tuf_label.spooled_block_num,                   next_block,                   tuf_wraparound_status.spooled);                TUF_label.spooled_block_num := next_block;                bump_beg_of_tuf; 	               END; 	             (* dbspl is continuing to log - all is okay *)           to_bm_spl_contlog_reply_mesg_code :             spl_save_error := zero;      	         otherwise 	             END;  (* case *)           spl_status := spl_reply.status;        IF spl_status <> zero THEN BEGIN          save_warning_message_code := spl_status;              (**)  "         (* For the following errors, dbspl stops accepting messages " #         (* until an operator/user intervenes.  So we output a warning # #         (* message to the warning log and give users errors until the # '         (* situation is corrected and we can clear our flag (spl_save_error). '         (**)               IF ((spl_status = spare_rfl_missing_err) OR             (spl_status = spare_rfl_undefined_err) OR             (spl_status = rfl_device_not_ready_err)) THEN              spl_save_error := spl_status;    (* save the error *)           END;      #      (* has dbspl encountered a fatal error so that it terminated? *) # !      IF spl_reply.status = dbspl_terminating_warn_code THEN BEGIN !             (**)           (* Change the log status in case dbmon hasn't           (* received the change log status from dbutl yet.           (* Just change it to rb_only until the message from           (* dbutl is received.          (**)               system_log_status := rb_only;           spl_save_error := zero;          END;            END;         message_len := zero;  (* do not reply to DBSPL *)     END;  (* with workhorse_data *) END;  (* end spool_reply_handler *)  $ Page $ (***********************************************************) (*                                                         *) (* FUNCTION trans_id : Long_int;                           *) (*                                                         *) (* Purpose:                                                *) (*    To create a transaction number.                      *) (*                                                         *) (* Parameters:                                             *) (*    (1) A transaction number.                            *) (*                                                         *) (*    Function result:                                     *) (*         The next transaction number, if the function    *) (*         input parameter is zero,  If non-zero, the      *) (*         same number is returned.  This is because       *) (*         put, del and upd may want a transaction number  *)  (*         assigned to a singleton, so they pass in        *)   (*         the value zero.                                 *)   (*                                                         *)   (* Errors: If the max transaction number is reached,       *)   (*         the value zero is returned to indicate this     *)   (*         to the caller. The caller (begin_operation will *)   (*         do this) will test for this value and return    *)   (*         an error (max_transaction_id_err) to the        *)   (*         user.                                           *)   (*                                                         *)   (* Called by:  begin_operation,                            *)  (*             delete_operation,                           *) (*             put_operation,                              *) (*             update_operation.                           *) (*                                                         *) (***********************************************************)         FUNCTION trans_id  $ Alias 'DBM.CreateID' $     (transaction_number : Long_int) : Long_int;     VAR 
   dummy : short_int; 
    BEGIN        IF transaction_number <> zero THEN        trans_id := transaction_number        ELSE BEGIN            IF system_xaction_num = maxdint THEN BEGIN  "         system_xaction_num := zero;      (* - return value zero  *) "!         save_warning_message_code := max_transaction_id_warn_code; !          END        ELSE           system_xaction_num := system_xaction_num + one;           trans_id := system_xaction_num;            END;  (* else *)      END;  $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* Procedure commit_singleton                                       *) # #(*                                                                  *) # #(* Purpose - This procedure is needed by the modifying intrinsics   *) # #(* (update, put and delete) when the intrinsic is a singleton       *) # #(* and has successfully completed.                                  *) # #(*                                                                  *) # #(********************************************************************) #    PROCEDURE commit_singleton       $ alias 'DBM.CommitSngltn' $     (VAR return_status  : short_int);     VAR 	   dummy : boolean; 	    BEGIN          (* make sure the log record for the singleton gets flushed *)     dummy := get_new_tub ( 
      return_status); 
     END;  .  