$PASCAL ',7 92081-1X485 REV.2440' $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18485                                        *)   (* RELOC:   92081-16485                                        *)   (*                                                             *)   (* PGMR:        <MRL>                                          *)   (*                                                             *)   (* Date last modified: <840912.1407>  (*                                                             *)   (***************************************************************)      
$ Include '[LBOPT'  $ 
     PROGRAM global_pointer_construction;      $ List OFF, Include '[IMAGE' , List ON $      $ List OFF, Include '[BMCCT' , List ON $  $ List OFF, Include '[BMCTV' , List ON $  $ List OFF, Include '[BMSAM' , List ON $      $ List OFF, Include '[XWRTF' , List ON $  $ List OFF, Include '[XWPTS' , List ON $  $ Page $   (**************************************************************)    (*                                                            *)    (* FUNCTION make_global_ptrs : Boolean;                       *)    (*                                                            *)    (*    Purpose: To take ANY dataset number and return the      *)    (* appropriate pointers for it in some global pointer         *)    (* variables.  The pointers always calculated are:            *)    (*                                                            *)    (*    rt_header : Root file header.                           *)    (*    itm_table : Item table pointer.                         *)    (*    dst_entry : Dataset table entry.                        *)    (*    frt_entry : Free record table entry.                    *)    (*                                                            *)    (* Dataset dependent pointers are:                            *)    (*                                                            *)    (*    mpt_table : Master path table.                          *)    (*    mit_entry : Master information table.                   *)    (*    dpt_table : Detail path table.                          *)    (*                                                            *)    (* Parameters:                                                *)    (*    (1) Database number.                                    *)    (*    (2) Dataset number.                                     *)    (*    (3) IMAGE error if an error occurs.                     *)    (*                                                            *)    (* Function result:                                           *)    (*    'False' if no error occurs.                             *)    (*    'True' if an error does occur.                          *)    (*                                                            *)    (**************************************************************)      $ Heapparms OFF $      FUNCTION make_global_ptrs   $ Alias 'Mon.GlobalPtrs' $    (VAR database_num   : Short_int;         dataset_num    : Short_int;      VAR error          : Short_int) : Boolean;     LABEL 99;     VAR     rt_header : rootfile_header_ptr_type;    Any_ptr1  : All_pointers_type;    Any_ptr2  : All_pointers_type;      BEGIN      make_global_ptrs := true;         IF make_rt_header_ptr (database_num,                             rt_header,                            workhorse_data,                             error)  
      THEN GOTO 99;  
        Any_ptr1.rootfile_header := rt_header;          Any_ptr2.value := any_ptr1.value + rt_header^.it_off;         (* Make global pointer to item table *)         itm_table := any_ptr2.global_item_table;          any_ptr2.value := any_ptr1.value + rt_header^.set_off +                       ((dataset_num - one) * bm_set_len);         (* Make global pointer to dataset control block entry *)          dst_entry := any_ptr2.global_dataset_ctl_table;         IF (dst_entry^.set_type = detail)        THEN           IF make_detail_pointers                 (database_num,                   dataset_num,  
                dst_entry, 
 
                dpt_table, 
 
                frt_entry, 
                 workhorse_data,                   error)              THEN GOTO 99                 ELSE (*do nothing*)        ELSE           IF make_master_pointers                (database_num,                  dataset_num,  
                dst_entry, 
 
                mpt_table, 
 
                mit_entry, 
 
                frt_entry, 
                workhorse_data,                  error)             THEN GOTO 99;        make_global_ptrs := false;   (* No error! *)     
99:  (* error exit *) 
    
END; (* make_global_ptrs *) 
 .  