 $PASCAL ',7 92081-1X705 REV.2540' $       $ Include '[LBOPT'  $       PROGRAM resource_list_processing;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18705                                        *)  ! !(* RELOC:   92081-16705                                        *)  ! !(*                                                             *)  ! !(* PGMR:         <stc>                                         *)  ! !(*                                                             *)  ! (* Date of last modification: <850416.1427>   !(*                                                             *)  ! !(***************************************************************)  !             $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)      $ Include '[BMCCT'  $    (* Workhorse constants and types *)   $ Include '[BMCTV'  $    (* DBMON Constants, Types and Vars. *)    #$ Include '[BMSAM'  $    (* Main globals used by Samurai Segmenter *)  #     $ Include '[XBSDR'  $    (* Commonly used externals. *)   $ Include '[XWPTS'  $    (* Pointer Construction routines. *)   $ Include '[XWOCL'  $    (* Open/close library externals. *)  $ Include '[XBLUR'  $    (* Lock/unlock externals *)      (**** See if two process id's match ****)       FUNCTION resource_process_match  $ Alias 'Mon.ResourceProc' $   $ Heapparms ON $     ( VAR proc_id : process_description_type;       VAR resource_list : resource_msg_format;   	$ Heapparms OFF $  	      VAR num_entries : short_int;        VAR matched_ix : short_int ): BOOLEAN;      EXTERNAL;          (**** Clean up resources owned by an aborted program ****)      FUNCTION cleanup_program  $ Alias 'Mon.CleanupProg' $   $ Heapparms on $     ( VAR prog_entry : program_entry_format;   	$ Heapparms off $  	      VAR workhorse_data : workhorse_info_type;       VAR return_status : short_int) : BOOLEAN;     EXTERNAL;          (**** Perform the system cleanup operation ****)      	$ Heapparms OFF $  	     PROCEDURE cleanup_operation   $ Alias 'Mon.CleanUp' $;     EXTERNAL;          $ Page $  #(********************************************************************) # #(*                                                                  *) # #(*  PROCEDURE resource_list_gather_operation                        *) # #(*                                                                  *) # #(*  Purpose :  This procedure creates a list of resources held      *) # #(*  by IMAGE programs.  This list is passed to DBCLN so that        *) # #(*  DBCLN may note those programs which have aborted.               *) # #(*                                                                  *) # #(*  The stats list (for databases opened, locks acquired and        *) # #(*  transaction in progress) is NOT filled out at this point        *) # #(*  because they could change during the time DBCLN is looking      *) # #(*  at the ID segments.                                             *) # #(*                                                                  *) # #(*  Input:                                                          *) # #(*                                                                  *) # #(*  Output:                                                         *) # #(*                                                                  *) # #(*  Errors:                                                         *) # #(*                                                                  *) # #(********************************************************************) #     	$ Heapparms OFF $  	     #PROCEDURE resource_list_gather_operation $ Alias 'Mon.ResourceList'$;  #         VAR          (**)      (* global variables used are :      (*   message_len : return message length      (**)          tbl_ix : short_int;        (* index into various tables *)   #   num_entries : short_int;   (* number of resource message entries *) #    matched_ix : short_int;    (* index into resource msg *)   '   db_ix, ds_ix : short_int;  (* locktable indice - by database and dataset *) '     BEGIN  (* resource_list_gather_operation *)          num_entries := zero;       WITH workhorse_data DO BEGIN         WITH MB_ptr^.DBCLN.resource_msg DO BEGIN             (**)  "      (* If the original request is to gather resource information,  " !      (* then the request came from DBUTL.  Set the 'orig comm id' ! !      (* field in DBCLN's message so that when DBCLN returns to us !       (* later, we will remember to reply to DBUTL.         (**)             IF MB_ptr^.dbmon.request = to_bm_resource_recov_code THEN             original_comm_id := mb_ptr^.dbmon.from_comm_id         ELSE           original_comm_id := zero;                (**)        (* The coordination table contains a list of        (* all IMAGE programs which have a database         (* open.  In order to do any IMAGE processing, a        (* database must be open.  Hence all known IMAGE        (* programs are in this table.  Gather all unique         (* process ID's from this table (a process may have         (* more than one db open), and enter it into the  
      (* resource message. 
       (**)            FOR tbl_ix := one to max_IMAGE_users DO BEGIN       "         (* If open mode field is not 0, then tis occupied entry *)  "          WITH image_users^[tbl_ix] DO BEGIN               IF open_mode <> zero THEN BEGIN       $               (* If we have not encountered this process before,    *)  $ $               (* then enter it from the co_ord tbl to resource msg. *)  $                    IF NOT (resource_process_match (prog_id,   %                                               mb_ptr^.DBCLN.resource_msg, %                                                num_entries,   #                                               matched_ix)) THEN BEGIN #                   num_entries := succ (num_entries);                    WITH entry[num_entries] DO BEGIN                       proc := prog_id;                        statistics.active_trans   := false;                       statistics.estab_locks    := false;                       statistics.open_databases := false;  
                     END;  
                       END;  (* end if *)                     END;  (* end if *)                   END;  (* end with *)           END;  (* end for *)      !      (* store the number of entries into the resource message *)  !       number_of_entries := num_entries;          END;  (* End with DBCLN message *)          (**)       (* Make the from comm id look like DBCLN so that the general       (* purpose DBMON message replier procedure will send it to   "   (* DBCLN.  Set up the to comm id as DBMON.  Note that send_reply  "    (* will reverse the comm id's before sending the message.     (* Message_len is global.     (**)          WITH mb_ptr^.DBCLN,image_comm_buffer DO BEGIN        from_comm_id := DBCLN_comm_id;        from_comm_lock := DBCLN_comm_lock;        to_comm_id := dbmon_comm_id;        to_comm_lock := dbmon_comm_lock;        request := to_DBCLN_resource_msg_code;        END;  (* with *)     message_len := to_DBCLN_resource_msg_len;         auto_cleanup_in_progress := true;          END; (* end with workhorse data *)  END;      .  