 $PASCAL ',7 92081-1X482 REV.2540' $       $ Include '[LBOPT'  $       PROGRAM chkpt_routines;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18482                                        *)  ! !(* RELOC:   92081-16482                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>, <stc>                                   *)  ! !(*                                                             *)  ! (* Last modified: <850819.1457>   !(*                                                             *)  ! !(***************************************************************)  !         $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)      $ Include '[BMCCT'  $    (* Workhorse constants and types *)  $ Include '[BMCTV'  $    (* Workhorse constants and types *)  #$ Include '[BMSAM'  $    (* Main globals used by Samurai Segmenter *)  #     $ Include '[QA'     $    (* IMAGE error definitions *)      $ Include '[XBLOG'  $    (* Transaction logging routines *)   $ Include '[XLGLB'  $    (* Transaction logging library  *)   $ Include '[XWRTF'  $    (* Run table I/O routines. *)  $ Include '[XWPDB'  $    (* Post DataBlocks externals. *)   $ Include '[XWBIF'  $    (* Before-image externals. *)  $ Include '[XERWD'  $    (* Read/write disc routine.*)  $ Include '[XWPTS'  $    (* Pointer calculation externals.*)  $ Include '[XDFMP'  $    (* File access and I/O routines *)   $ Include '[XWDDT'  $    (* EMA disc I/O routines *)  $ Include '[XBSDR'  $    (* DBMON macro routines *)   $ Include '[XDCIO'  $    (* DBCON file I/O routines *)  $ Include '[XBQA'   $    (* QA external *)  $ Include '[XDTDY'  $    (* timing routines *)  $ List ON $   $ Page $   (**************************************************************)    (*                                                            *)    (* The following externals are for routines used exclusively  *)    (* by routines in BMUCP.PAS. Externals used in more than one  *)    (* routine should probably be placed in an include file.      *)    (*                                                            *)    (**************************************************************)       (**** Checksum the before-image buffer table. ****)           FUNCTION check_sum  $ Alias 'EMA.CheckSum' $  $ Heapparms ON $              (VAR BI_table   : Before_image_entry_types;   	$ Heapparms OFF $  	                  first_word : Short_int;                   last_word  : Short_int) : Short_int;      EXTERNAL;          $ Page $   (**************************************************************)    (*                                                            *)    (* Function CHECK_POINT : Boolean;                            *)    (*                                                            *)    (*    Purpose: To flush the before-image, transaction,        *)    (* data block and rootfile buffers to their respective places *)    (* when any of the following conditions exist:                *)    (*                                                            *)    (* (1) The before-image file is full.                         *)    (* (2) A database is closed.                                  *)    (* (3) A checkpoint message is received.                      *)    (* (4) Just prior to cleanup.                                 *)    (*                                                            *)    (* Parameters:                                                *)    (*    (in/out) (1) Workhorse information.                     *)    (*    (out)    (2) IMAGE error if an error occurs.            *)    (*                                                            *)    (* Function result:                                           *)    (*    'false' if no error occurs.                             *)    (*    'true' if an error does occur.                          *)    (*                                                            *)    (* Algorithm:                                                 *)    (*                                                            *)    (*  (1)   Flush the before-image buffers.                     *)    (*  (2)   Reset variables                                     *)    (*        (a) BIB flush count (b) undo_counter                *)    (*  (3)   Flush the data block buffers.                       *)    (*  (4)   Set all data block indicators to 'clean'.           *)    (*  (5)   Flush the rootfile buffers.                         *)    (*  (6)   Set the rootfile indicators to 'clean'.             *)    (*  (7)   If logging, create a checkpoint record in the TUB   *)    (*  (8)   If logging, flush the TUF to the TUB.               *)    (*  (9)   If logging, before image the TUF label.             *)    (*  (10)  If logging, update the TUF label.                   *)    (*  (11)  Set the before-image file to EMPTY.                 *)    (*  (12)  If spooling, notify the spooler                     *)    (*  (13)  If logging, update the beginning of TUF pointer     *)    (*  (14)  Done.                                               *)    (*                                                            *)    (*                                                            *)    (**************************************************************)   	$ Heapparms OFF $  	     FUNCTION check_point  (* DO NOT ALIAS! *)      (VAR workhorse_data : Workhorse_info_type;       VAR error          : Short_int) : Boolean;      
LABEL 99; (* error exit *) 
     VAR   
   loop : Short_int; 
    logrec_ptr : ptr_log_record_header_type;      cp_block_num : long_int;      cp_word_off : short_int;          return_block : long_int;      Any_ptr      : All_pointers_type;         (* Performance statistics variables. *)     start_time   : long_int;      bif_time     : long_int;      save_time    : long_int;      save_count   : long_int;       BEGIN (* check_point *)       WITH workhorse_data DO BEGIN         check_point := true; (* Assume an error will occur *)         WITH sys_stats.system_stats DO         checkpoint_count := checkpoint_count + one;          start_time := get_start_time;         (**)      (*  Flush the Before-image buffer to disc     (*  and reset it to empty.      (**)          (* Save current I/O count and time stats to see how much *)     (* is being done for checkpoint. *)         WITH sys_stats.system_stats DO BEGIN         save_time := bif_write_io_time +                     tlf_write_io_time +                     tlf_read_io_time +                      cache_elapsed_io;            save_count := bif_writes +                      tlf_writes +                      tlf_reads  +                      non_miss_io_count;        END;         IF Flush_BI_buf (workhorse_data, error)        THEN GOTO 99; (* if error occurs *)              (* SPECIAL TEST FOR QA ONLY *)      IF qa_crash_code = qa_cp_flush_bif THEN        terminate_program (terminate_code);          (**)      (*  Flush dirty data block buffers to the databases.      (*  Set all data blocks to 'clean'.     (*     (post_data_blocks does both operations).     (*  Set all data block 'last_intrinsic' counts to zero.     (**)          IF post_data_blocks (workhorse_data, error)        THEN GOTO 99; (* if an error occurs *)             (**)      (* Reset bib flush counts in all data blocks to zero.     (**)              FOR loop := zero to last_db_block DO      WITH db_ptr^.data_buf_id[loop] DO BEGIN  
      last_flush := zero;  
 
      last_intrin:= zero;  
 
      END; (* for with *)  
        current_bib_flush_num := one;     current_intrinsic_num := one;         (**)      (*  Flush dirty run tables to the rootfiles.      (*  Set all run table indicators to 'clean.'      (*    (Post_run_tables does both operations).     (**)                  IF post_run_tables (workhorse_data, error)         THEN GOTO 99;  (* if an error occurs *)              (* SPECIAL TEST FOR QA ONLY *)      IF qa_crash_code = qa_cp_flush_data_buffer THEN        terminate_program (terminate_code);          (* IF TRANSACTION LOGGING.... *)      IF (system_log_status <> intr_only) THEN BEGIN             (**)  !      (* Flush the transaction log buffer (TUB) to the transaction !       (* log file (TUF).        (**)            IF get_new_TUB (error)           THEN GOTO 99;             (* SPECIAL TEST FOR QA ONLY *)      IF qa_crash_code = qa_cp_checkpoint_record THEN        terminate_program (terminate_code);             (**)        (* Make a before image of the TUF label.        (**)            WITH sys_stats.system_stats DO BEGIN           tlf_reads := tlf_reads + one;            IF TUF_header_io (tlf_descriptor,                           read_from_device_code,                          tuf_header_ptr^,                          tlf_read_io_time,                           error)           THEN GOTO 99;               END; (* with stats *)            IF copy_TUF_header (error) THEN GOTO 99;            IF flush_bi_buf (workhorse_data, error) THEN GOTO 99;             (**)  !      (* Update the TUF label and write the tuf header to the TUF. !       (**)            IF update_TUF_header (           last_log_rec_block,           last_log_rec_word_offset,           error) THEN GOTO 99;             END;  (* end if transaction logging *)         (* SPECIAL TEST FOR QA ONLY *)      IF qa_crash_code = qa_cp_write_tuf_label THEN        terminate_program (terminate_code);          (**)      (*  Reset before-image file by writing EOF on block 1.      (*  Reset internal before-image pointers.     (**)          db_block[zero] := end_of_file_mark;         WITH sys_stats.system_stats DO BEGIN         bif_time := get_start_time;             IF read_write_disc (write_to_device_code,                             Before_image_file_ID,                             db_block[zero],                             one,                            one,                            error)           THEN GOTO 99;            bif_time          := get_elapsed_time(bif_time);        bif_writes        := bif_writes + one;        bif_write_io_time := bif_write_io_time + bif_time;        END;             BI_file_block := one;         WITH bifi_buf_ptr^ DO BEGIN        tbl_hdr.entries := one;   (* Reset the BIB *)         bi_table[one].entry_type := intrinsic_end;        END;         IF qa_crash_code = qa_cp_set_bif_empty THEN        terminate_program (terminate_code);              (**)      (* All done with checkpoint!      (**)          check_point := false;  (* No error! *)          (* SPECIAL TEST FOR QA ONLY *)      IF qa_crash_code = qa_checkpoint_complete THEN         terminate_program (terminate_code);          WITH sys_stats.system_stats DO BEGIN         chkpt_elapsed_time := chkpt_elapsed_time +                              get_elapsed_time (start_time);            chkpt_io_time := chkpt_io_time +                         (bif_write_io_time +                           tlf_write_io_time +                           tlf_read_io_time +                          cache_elapsed_io) - save_time;            chkpt_cpu_time := chkpt_cpu_time +                          chkpt_elapsed_time - chkpt_io_time;             chkpt_io_count := chkpt_io_count +                          (bif_writes +                            tlf_writes +                            tlf_reads  +                            non_miss_io_count) - save_count;         END;      END; (* with workhorse_data *)      99:  (* error exit *)       END; (* check_point *)  .  