 $PASCAL ',7 92081-1X702 REV.5010' $       $ Include '[LBOPT'  $       PROGRAM database_update_operation;      !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18702                                        *)  ! !(* RELOC:   92081-16702                                        *)  ! !(*                                                             *)  ! !(* PGMR:        stc                                            *)  ! !(*                                                             *)  ! (* Date of last modification: <880829.1714>   !(*                                                             *)  ! !(***************************************************************)  !     $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)      $ Include '[BMCCT'  $    (* Workhorse constants and types *)   $ Include '[BMCTV'  $    (* DBMON Constants, Types and Vars. *)    #$ Include '[BMSAM'  $    (* Main globals used by Samurai Segmenter *)  #     $ Include '[XWRKH'  $    (* Workhorse externals. *)   $ Include '[XBSDR'  $    (* Commonly used externals. *)   $ Include '[XWBUF'  $    (* Data buffering routines. *)    $ Include '[XWBIF'  $    (* Before image buffer/file routines *)   $ Include '[XBFMC'  $    (* First DB modify check *)  $ Include '[XBLOG'  $    (* Transaction Log buffer routines *)  $ Include '[XLGLB'  $    (* Transaction Log buffer routines *)  $ Include '[XBUCP'  $    (* Checkpoint routine. *)  $ Include '[XBLUR'  $    (* Lock/Unlock routines *)   $ List ON $       $ Page $  !(***************************************************************)  ! !(*                                                             *)  ! !(*  PROCEDURE upd_operation                                    *)  ! !(*                                                             *)  ! !(*  Purpose:  This procedure is responsible for replacing      *)  ! !(*  non-key items which the user has write access in the       *)  ! !(*  current record of the specified manual master or detail    *)  ! !(*  data set.  These items are replaced with the values        *)  ! !(*  specified by the user.                                     *)  ! !(*                                                             *)  ! !(*  Input : The global message buffer: it contains             *)  ! !(*          (1) the transaction number                         *)  ! !(*          (2) the post indicator                             *)  ! !(*          (3) the data set number                            *)  ! !(*          (4) the current record number                      *)  ! !(*          (5) the tempx table length                         *)  ! !(*          (6) the tempx table                                *)  ! !(*          (7) the data (concatenated item values) length     *)  ! !(*          (8) the data                                       *)  ! !(*                                                             *)  ! !(*  Output:                                                    *)  ! !(*          The message buffer if successful.  Only the        *)  ! !(*          status is returned.                                *)  ! !(*                                                             *)  ! !(*  Errors:                                                    *)  ! !(*                                                             *)  ! !(*     112: Attempt to change a key, sort, or non-writeable    *)  ! !(*          item value.                                        *)  ! !(*     114: The record accessed is empty.                      *)  ! !(*     160: The run table is corrupt.                          *)  ! !(*                                                             *)  ! !(***************************************************************)  !     	$ Heapparms OFF $  	     PROCEDURE update_operation   $ Alias 'Mon.UpdateRecord' $;      LABEL 99,   (* Error return label - error processing first *)         88;  (* Return label *)   VAR          (**)      (* global variables used are :      (*      (*   rootx  : database number     (*   error  : latest error number     (*   message_len : return message length      (*   rt_header : pointer to the root file header      (*   dst_entry : pointer to the data set table entry      (*   itm_table : pointer to the item table      (*   frt_entry : pointer to the free record table     (*   mpt_table : pointer to the master path table     (*   mit_entry : pointer to the master information table      (*   dpt_table : pointer to the detail path table     (*   logrec_ptr : pointer to the log record     (*      (**)          logging : boolean;             (* are we logging? *)   !   xaction_num : long_int;        (* current transaction number *) ! !   post_data : boolean;           (* post (1) / nopost (0) flag *) !    upd_set_num : short_int;       (* data set number *)      upd_rec_num : long_int;        (* current record number *)   !   upd_num_items : short_int;     (* num of items to be updated *) !    tempx_tbl : tempx_table_type;  (* table of item info *)  "   upd_data_len : short_int;      (* total length of item values *)  " '   this_upd_log_rec_len : short_int;   (* length of log record for update *)   ' #   log_offset_new_item_val_list : (* offset to new item values list *) #      short_int;       "   data_ptr : db_ptr_type;        (* ptr to a data-buffer-record *)  " "   rec_word_off : short_int;      (* start word of rec in buffer *)  " $   data_rec_ptr :                 (* ptr to the data set data record *)  $        data_record_ptr_type;     cur_item_val_ptr : item_value_ptr_type;     new_item_val_ptr : item_value_ptr_type;      $   upd_data_ptr :                 (* ptr to the user data item values *) $        data_record_ptr_type;      &   upd_log_old_data_ptr :         (* ptr to old data part of the log rec *)  &        data_record_ptr_type;      %   upd_log_new_data_ptr:          (* ditto, but to the new item values *)  %        data_record_ptr_type;      !   media_rec_len : short_int;     (* length of the media record *) ! "   item_len : short_int;          (* length of a data item value *)  "    item_val_off : short_int;      (* offset to item value *)     ix, dr_ix : short_int;         (* indice *)      $   log_block_num : long_int;      (* TUF block # where the log record *) $ $                                  (* potentially will reside.         *) $ 
   save_error : Short_int; 
    any_ptr    : All_pointers_type;     any_ptr2   : All_pointers_type;  
   coordx     : Short_int; 
    proc_id    : Process_description_type;           BEGIN  (* update_operation *)       WITH workhorse_data DO BEGIN         message_len := to_user_upd_mesg_len;          MB_ptr^.user.request := to_user_upd_code;         WITH MB_ptr^.dbmon.update DO BEGIN         rootx     := user.db_id;        local_db_number := user.local_db_num;         proc_id   := user.proc;         post_data := post_ind;        upd_set_num := set_num;         upd_rec_num := current_rec_num;         upd_num_items := num_items;         tempx_tbl := tempx_table;         upd_data_len := data_len;   "      IF get_upd_data_rec_addr (data_rec, upd_data_ptr, error) THEN  " 	         GOTO 88;  	 
      END;  (* end with *) 
     
   IF find_process (rootx, 
                     local_db_number,                      proc_id,                      coordx,                       workhorse_data,   
                    error) 
 
      THEN GOTO 88;  
        (**)   #   (* Get pointers to various tables in the run table. These pointers  # 	   (* are global.  	    (**)          IF make_global_ptrs (rootx, upd_set_num, error)  
      THEN GOTO 88;  
        (**)   #   (* Determine how much before-image space we may need.  This routine # &   (* performs checkpoints if necessary (lack of before image buffer space)  &     (* Following the call to this routine, we are guaranteed that      (* we have enough before image space for this intrinsic.      (**)          IF before_image_file_check (to_bm_upd_code,                                 dst_entry,                                  workhorse_data,                                 error)   
      THEN GOTO 88;  
            (**)   "   (* Verify that the dataset in question is locked to the program.  "    (**)          IF verify_set_lock (rootx,                          upd_set_num,                          coordx,                         workhorse_data,                         error)         THEN GOTO 88;  (* If lock was not found *)                 (**)      (* Set 'First modification' bits.     (**)          IF check_first_mod (rootx,                          workhorse_data,                         error)   
      THEN GOTO 88;  
            (**)      (* IF we are logging, create a transaction log record.      (**)          IF opn_tbl_ptr^[rootx].logging_status THEN BEGIN             logging := true;            (* determine the log record length *)         this_upd_log_rec_len := dbupd_log_rec_size +  #                         (2 * upd_data_len);  (* old and new values *) #           log_offset_new_item_val_list := dbupd_log_rec_size +                                        upd_data_len - one;             (* make a general log record *)         IF make_log_record (dbupd_log_code,                             this_upd_log_rec_len,                             logrec_ptr,                             log_block_num,                            error)           THEN GOTO 88;            WITH mb_ptr^.dbmon.update DO           Operating_transaction := trans_id (xact_num);                (* add the specific dbupd log information *)            WITH logrec_ptr^.update DO BEGIN           trans_num := Operating_transaction;           (* if a singleton, set the flag to true *)            IF (mb_ptr^.dbmon.update.xact_num = zero) THEN               singleton := true            ELSE               singleton := false;                IF trans_num = zero              THEN BEGIN                 error := max_transaction_id_err;                  GOTO 99;                  END; (* then *)               proc_info := MB_ptr^.dbmon.update.user.proc;            db_name_id := opn_tbl_ptr^[rootx].root_file_name;               (**)            (* Save system DB # for use by DBRFR.           (**)                sysdb_num := rootx;               ds_num  := upd_set_num;           rec_num := upd_rec_num;           new_data_off := log_offset_new_item_val_list;           data_len := upd_data_len;           num_items := upd_num_items;           tempx_table := tempx_tbl;           END;   (* end with upd_data_ptr *)             (**)        (* The rest of the update log info will be entered as we        (* loop throught the tempx table using the info there to        (* enter the item number, retrieve the old item values        (* from the data record and to retrieve the new item        (* values from the message buffer.        (**)                (**)        (* Set ptrs to (1) dbupd log record old data field  !      (*             (2) dbupd log record item numbers list field  !       (*             (3) dbupd log record new data field        (*  %      (* Log record the contains old data field before the new data field  %       (**)            Any_ptr.log_record_header := logrec_ptr;  !      Any_ptr2.value := any_ptr.value + dbupd_log_rec_size - one;  !       upd_log_old_data_ptr := any_ptr2.data_record;       #      Any_ptr2.value := any_ptr.value + log_offset_new_item_val_list;  #       upd_log_new_data_ptr := any_ptr2.data_record;             END   
   ELSE logging := false;  
                (**)      (*  Now to fully create the log record:     (*  Read the user's current record and extract the old      (*  information to be placed in the log record.     (**)          IF read_master_record (rootx,                            upd_set_num,                            upd_rec_num,                            do_not_copy,                            dummy_mst_ptr,                            workhorse_data,                             error)  
      THEN GOTO 99;  
 #   (* check to see if the record has been deleted  5-9-88 Andy Jian *) #    if dummy_mst_ptr^.entry_type = empty then        begin            error := record_empty_err;   	         goto 99;  	       end;         (**)      (* Make a ptr to the data set record in memory.     (* First word of media record is pointed to.      (**)          any_ptr.master_media_record := dummy_mst_ptr;     data_rec_ptr := any_ptr.data_record;              (* determine the length of the media record *)      media_rec_len := dst_entry^.gdt.media_len;          (**)   "   (* Transfer the data item values from the user's buffer into the  " #   (* data record.  The tempx table has all the data item information  #    (* we need.     (*   "   (* During this transfer loop, we look at the write, key and sort  " !   (* flags.  If an item is not writeable OR a key or sort item is ! !   (* included, the user supplied item value MUST match the value  !     (* in the data record.  We do a comparison and halt the loop    !   (* processing if there is no match (error 112).  In that case,  !    (* we must restore the before image to the data record.     (**)       	   dr_ix := zero;  	    FOR ix := one TO upd_num_items DO BEGIN            item_len := tempx_tbl[ix].word_length;             item_val_off := media_rec_len + tempx_tbl[ix].start_word;        "      (* Set up pointer to start of item value within data record *) "       Any_ptr.data_record := data_rec_ptr;        Any_ptr.value := any_ptr.value + item_val_off;        Cur_item_val_ptr := any_ptr.item_value;       !      (* Set up pointer to start of new item value within mesg *)  !       Any_ptr.data_record := upd_data_ptr;        Any_ptr.value := any_ptr.value + dr_ix;         new_item_val_ptr := any_ptr.item_value;                 IF logging THEN BEGIN            (* Move the current item value into the log record *)           IF move_one_item_value ( cur_item_val_ptr^,                                     upd_log_old_data_ptr^[dr_ix],                                      item_len,                                     error)  
            THEN GOTO 99;  
                  (* Move the new item value into the log record *)           IF move_one_item_value (new_item_val_ptr^,                                    upd_log_new_data_ptr^[dr_ix],                                   item_len,                                   error)   
            THEN GOTO 99;  
              END;  (* end if logging *)                 dr_ix := dr_ix + item_len;            END;   (* end for loop *)              IF common_update_routine            (rootx,              (* Perform the actual update *)             upd_set_num,        (* using the update workhorse*)             upd_rec_num,        (* to do the dirty work.     *)             upd_num_items,  
          tempx_tbl, 
           upd_data_len,             upd_data_ptr,   
          workhorse_data,  
           error)  
      THEN GOTO 99;  
        (**)      (* If a singleton, then flush TUB to TUF. *)      (**)          IF (MB_ptr^.dbmon.update.xact_num = zero) AND        (opn_tbl_ptr^[rootx].logging_status)        THEN           commit_singleton (error);           IF error <> zero THEN  
            GOTO 99; 
        (* If the posting flag is set, post all data blocks *)      IF (NOT logging) THEN        IF post_data THEN            IF check_point (workhorse_data, error)   
            THEN GOTO 99;  
        (* IF theres been an error, remove the log record *)       END; (* with workhorse_data *)      99:      save_error := no_image_err;         IF (error <> no_image_err)         THEN BEGIN           IF logging THEN remove_log_record;            END;       88:      IF (error <> no_image_err)         THEN           message_len := to_user_intr_header_len;         (**)      (* That's all folks.      (**)       END;  (* update_operation *)      .  