 $PASCAL ',3,30 92081-16830 REV.5000' $  $ TITLE 'DBCLN: IMAGE cleanup utility program' $ 
$ SUBTITLE 'Main program' $ 
 $ HEAP 0 $ $ RECURSIVE OFF $  $ RUN_STRING 0 $ $ RANGE OFF $      PROGRAM DBCLN;      #(* **************************************************************** *) # #(* * (C) Copyright 1983 Hewlett-Packard.  All rights reserved.    * *) # #(* * No part of this program may be photocopied, reproduced or    * *) # #(* * translated to another program language without the express   * *) # #(* * written consent of Hewlett-Packard Company.                  * *) # #(* **************************************************************** *) #     #(********************************************************************) # #(*                                                                  *) # #(* PROGRAM : DBCLN                                                  *) # #(*                                                                  *) # #(* SOURCE:  92081-18830                                             *) # #(* RELOC:   92081-16830                                             *) # #(*                                                                  *) # #(* PURPOSE : This program assists in the resource recovery          *) # #(*           operation of IMAGE.  DBCLN is used to detect the       *) # #(*           absence of programs which have allocated IMAGE         *) # #(*           resources (which, because they no longer exist,        *) # #(*           cannot deallocate the resources themselves.)           *) # #(*                                                                  *) # #(* PGMR:        <EDB> <MRL> <STC>                                   *) # #(*                                                                  *) # #(* DATE : (1) first version - October, 1981                         *) # #(*                                                                  *) # #(********************************************************************) # $ Page $  #(********************************************************************) # #(*                      DATA STRUCTURES                             *) # #(********************************************************************) # #(*                                                                  *) # #(* Resources message format:                                        *) # #(*                                                                  *) # #(*   1-5:  message header                                           *) # #(*   6-9:  unused                                                   *) # #(*    10:  original sender (dbmon uses this word)                   *) # #(*    11:  number of entries                                        *) # #(*  12-    entries                                                  *) # #(*         .                                                        *) # #(*         .                                                        *) # #(*                                                                  *) # #(* Program entry format:                                            *) # #(*                                                                  *) # #(*     N:  unused reserved word                                     *) # #(*   N+1:  Local program name (6 characters)                        *) # #(*   N+4:  'Unique' program random number (unused by DBCLN)         *) # #(*   N+5:  Unused                                                   *) # #(*   N+6:  Master program name, if remote program (6 characters)    *) # #(*   N+9:  Master program node                                      *) # #(*  N+10:  Image resource statistics (see below)                    *) # #(*                                                                  *) # #(* Image resource statistics format:                                *) # #(*                                                                  *) # #(* bit 15: Program has aborted (non-existent or dormant)            *) # #(* bit 14: Program has open databases                               *) # #(* bit 13: Program has active transaction                           *) # #(* bit 12: Program has established locks                            *) # #(*                                                                  *) # #(********************************************************************) # $ Page $  #(********************************************************************) # #(*                      LABEL DEFINITIONS                           *) # #(********************************************************************) #     LABEL          99;                             (* ignore message *)       $ Page $ $ List OFF, Include '[IMAGE', List ON $          #(********************************************************************) # #(*                 LOCAL CONSTANTS                                  *) # #(********************************************************************) #CONST      
   word_len_err_mesg = 30; 
   char_len_err_mesg = word_len_err_mesg * chars_in_word;     system_console = 1;    max_num_open_db = 100;        (* errors to system console *)        DBCLN_to_dbmon_comm_err_mesg =       'IMAGE ERROR!  DBCLN COULD NOT COMMUNICATE TO DBMON';        DBCLN_comm_init_err_mesg = !      'IMAGE ERROR!  DBCLN COULD NOT OBTAIN COMMUNICATIONS BUFFER'; !       DBCLN_comm_buff_corrupt_err_mesg =        'IMAGE ERROR!  DBCLN DISCOVERED CORRUPT IMAGE COMM BUFFER';         DBCLN_illegal_msg_err_mesg =       'IMAGE ERROR!  DBCLN RECEIVED ILLEGAL MESSAGE (IGNORED)';         DBCLN_remote_communication_err_mesg =       'IMAGE ERROR!  DBCLN ENCOUNTERED DS ERROR';  #(********************************************************************) # #(*                LOCAL TYPES                                       *) # #(********************************************************************) #     TYPE      return_buffer =                 (* return parameter buffer *)        ARRAY[1..5] OF short_int;      !   remote_status_type =            (* remote status word format *) !	      PACKED RECORD 	         segment: boolean;         (* segment flag (1 bit) *)           unused: 0..2047;          (* unused area (11 bits) *)            state: -8..7;             (* program status (4 bits) *)   
         END; (* RECORD *) 
       err_mesg_buf_type =             (* holds error messages *)        PACKED ARRAY [1..char_len_err_mesg] of char;        PAC_20 = PACKED ARRAY [1..20] OF CHAR;      $ Page $  #(********************************************************************) # #(*                      LOCAL VARIABLES                             *) # #(********************************************************************) #     VAR       !   continue : boolean;             (* while true, process msgs *)  !     #   image_comm_buffer:              (* global communications buffer *)  #       image_comm_buffer_type;          request_msg:                    (* DBCLN request message *)        RECORD  
         CASE short_int OF 
 %            0: (DBCLN:             (* DBCLN message buffer (from DBMON) *) %                    to_DBCLN_mesg_type);   $            1: (dbmon:             (* DBCLN message buffer (to DBMON) *) $                    to_bm_mesg_type);              2: (buffer :                     array [1..2] of short_int);  
         END; (* RECORD *) 
         request_msg_len: short_int;     (* resource message length *)       !   return_status: short_int;              (* return error value *) !    dummy : short_int;       #   from_comm_identifier : short_int;  (* identifiers for where the *)  # #   from_comm_locker : short_int;      (* request came from - hence *)  # #                                      (* will be where reply goes. *)  #    err_mesg_buf : err_mesg_buf_type;      $ Page $  #(********************************************************************) # #(*                      EXTERNAL SYSTEM PROCEDURES                  *) # #(********************************************************************) #     (* writes critical errors to the system console *)      PROCEDURE write_error_to_sys_console $ alias 'REIO' $   
   (    code : short_int;  
         lu : short_int;       VAR buffer_addr : err_mesg_buf_type;  
        len : short_int);  
    EXTERNAL;      (* detach from session if in session environment *)       PROCEDURE detach_from_session $ alias 'DTACH' $      ( VAR dummy: short_int);      EXTERNAL;      (* Get message from DBMON *)      FUNCTION get_dbmon_request_mesg   $ alias 'IMG.LclGetmesg' $    (   from_comm_id : short_int;         from_comm_lock : short_int;         wait_option : short_int;    VAR mesg_buf :  short_int;     VAR mesg_len : short_int;         max_mesg_len : short_int;     VAR status :short_int) : BOOLEAN;     EXTERNAL;          #(* Get_DBCLN_startup_request_mesg gets the startup request message  *) # #(* for DBCLN.                                                       *) #     PROCEDURE get_DBCLN_startup_request_mesg $ALIAS 'RMPAR'$     ( VAR startup_request_mesg: DBCLN_startup_request_mesg );     EXTERNAL;      PROCEDURE CLEAN_UP_SAM                   $ALIAS 'GETST'$    ( VAR BUFR  :  PAC_20;  
         BUFRL :  INTEGER; 
     VAR TLOG  :  INTEGER);     {  AHJ  3-30-87 }     EXTERNAL;         $ List OFF, Include '[XDGCB', List ON $         $ List OFF, Include '[XDMSG', List ON $         $ List OFF, Include '[XDLDP', List ON $      #(* Remote_program_status returns the status of a specified program  *) # #(* on a remote node.  If an error occurs, the function value        *) # #(* returned is true.  If successfuly the function value returned is *) # #(* false.                                                           *) #     FUNCTION remote_program_status $ALIAS 'RMCHK'$  
   (     node: short_int;  
 
         name: prog_name;  
      VAR status: remote_status_type ): BOOLEAN;      EXTERNAL;      #(* Slave_to_master searches for the specified slave program in the  *) # #(* RD.TB table, and if found, the function value will be false,     *) # #(* and the master program name and node number will be returned.    *) # #(* If not found, the function value will be true.                   *) #     FUNCTION slave_to_master $ALIAS 'RMSER'$     (     slave_prog: prog_name;        VAR master_prog: prog_name;       VAR master_node: short_int ): boolean;      EXTERNAL;      #(* Remove_master sends a message to RDBAM to remove the specified   *) # #(* master program entry from the RD.TB table, and destroy the slave *) # #(* program.                                                         *) #     PROCEDURE remove_master $ALIAS 'RMCLN'$      (     master_prog: prog_name;           master_node: short_int;       VAR return_status: short_int );     EXTERNAL;      #(* Rdbap_cmpare compares a given name to that of an rdbap copy.     *) # #(* The value true is returned if the program is an rdbap copy.      *) #     FUNCTION rdbap_compare $ ALIAS 'RDCMP' $    ( VAR pname : prog_name): BOOLEAN;     EXTERNAL;  $ Page $  #(********************************************************************) # #(*                      initialize                                  *) # #(********************************************************************) # #(*                                                                  *) # #(* Initialize sets up the necessary DBCLN environment for           *) # #(* communicating with the outside world.                            *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE initialize   $ Alias 'DBCLN.INIT' $;      $ List OFF, Include '[PROG', List ON $     CONST     startup_reply_mesg_len = 5;     VAR &   startup_request_mesg:           (* DBCLN startup request message buffer *) &      DBCLN_startup_request_mesg;    startup_reply_mesg :       to_dbutl_startup_reply_mesg_type;     JUNK_BUFF : PAC_20;    JUNK_INT  : INTEGER;          BEGIN (* initialize *)         (* get startup request message *)    get_DBCLN_startup_request_mesg (startup_request_mesg);      !   { ADD THIS GETST CALL TO CLEAN UP DBCLN'S RUN STRING FROM SAM } ! 	   { 3-30-87 AHJ } 	    CLEAN_UP_SAM (JUNK_BUFF, 10, JUNK_INT);        (* reply to dbutl *)    WITH startup_reply_mesg DO BEGIN       to_comm_id := startup_request_mesg.reply_comm_id; 
      to_comm_lock := zero; 
       END;  
   IF send_request ( 
       startup_reply_mesg.from_comm_id,  (* 1st word *)       startup_reply_mesg_len,       return_status) THEN        GOTO 99;         (* get communications buffer *)     IF get_image_comm_buffer (image_comm_buffer)         THEN BEGIN                   (* generate error *)            (* write error to system console *)           err_mesg_buf := DBCLN_comm_init_err_mesg;           write_error_to_sys_console (               write_code,               system_console,   
            err_mesg_buf,  
             word_len_err_mesg);       $         GOTO 99;                  (* take abnormal termination exit *)  $          END; (* THEN *)         IF startup_request_mesg.DBCLN_comm_id <>         image_comm_buffer.DBCLN_comm_id         THEN BEGIN                   (* generate error *)       $         GOTO 99;                  (* take abnormal termination exit *)  $          END; (* THEN *)      END; (* initialize *)   $ Page $  #(********************************************************************) # #(*                      recv_message                                *) # #(********************************************************************) # #(*                                                                  *) # #(* Recv_message receives an request message for processing.         *) # #(* This message (which should be a program check request) is        *) # #(* placed in the global variable resource_message.                  *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE recv_message   $ Alias 'DBCLN.RCVMSG' $;      CONST       wait_for_message = 0;           (* wait for message option *)       BEGIN (* recv_message *)         (* get message from DBMON *)      IF get_dbmon_request_mesg           (image_comm_buffer.DBCLN_comm_id,            image_comm_buffer.DBCLN_comm_lock,            wait_for_message,             request_msg.buffer[one], request_msg_len,             to_DBCLN_resource_msg_len,            return_status)        THEN BEGIN                   (* generate error *)            request_msg.DBCLN.request := 0;               END; (* THEN *)     from_comm_identifier := request_msg.DBCLN.from_comm_id;     from_comm_locker := request_msg.DBCLN.from_comm_lock;      END; (* recv_message *)   $ Page $  #(********************************************************************) # #(*                      check_local_node                            *) # #(********************************************************************) # #(*                                                                  *) # #(* Check_local_node searches the local node for inactive programs.  *) # #(* It goes through the request message buffer and tests each        *) # #(* program entry for existance.  If the program does not exist,     *) # #(* the program entry is copied to the request message buffer,       *) # #(* and the request entry counter is incremented.                    *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE check_local_node   $ Alias 'DBCLN.CHECKLOCAL' $;      VAR       prog_index: 1..max_IMAGE_users;  (* program index counter *)            BEGIN (* check_local_node *)      '   FOR prog_index := 1 TO request_msg.DBCLN.resource_msg.number_of_entries DO  ' "      WITH request_msg.DBCLN.resource_msg.entry[prog_index] DO BEGIN "          IF RTE_A2_local_dormant_program (proc.pname,                                             proc.process_id)              THEN statistics.prog_aborted := true           ELSE               statistics.prog_aborted := false;            END; (* WITH *)      END; (* check_local_node *)   $ Page $  #(********************************************************************) # #(*                      check_remote_node                           *) # #(********************************************************************) # #(*                                                                  *) # #(* Check_remote_node searches remote nodes for inactive master      *) # #(* programs.   The local slave program is always an RDBAP copy.     *) # #(* The following steps are taken :                                  *) # #(*    - Comparing the program name with that of an RDBAP copy.      *) # #(*    - If it is, then the RD.TB table is searched in order         *) # #(*        to determine the master program name and node.            *) # #(*    - The master program status is checked.                       *) # #(*    - If it is no longer active (system dependent id segment      *) # #(*        is no longer around), then RDBAM (the monitor on the      *) # #(*        remote node) is sent a message to clean up the RDBAP      *) # #(*        copy.                                                     *) # #(*    - The information in the local resource message is updated.   *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE check_remote_node $ALIAS 'DBCLN.CHECKREMOTE'$;      LABEL 99;       CONST      remote_status_check_code =  99;     prog_non_existant_code = -1;       TYPE  
   master_id_type = RECORD 
       pname : prog_name;        node_num : short_int;         END;      VAR       prog_index: 1..max_IMAGE_users;  (* program index counter *)    %   master_status : remote_status_type;  (* remote master program status *) % !   master_id_table : array [1..max_num_open_db] of master_id_type; !    num_aborted : short_int;   	   ix : short_int; 	     BEGIN (* check_remote_node *)          num_aborted := zero;   '   FOR prog_index := 1 TO request_msg.DBCLN.resource_msg.number_of_entries DO  ' "      WITH request_msg.DBCLN.resource_msg.entry[prog_index] DO BEGIN "     !         (* compare the program name with that of an rdbap copy *) !          IF rdbap_compare ( proc.pname) THEN BEGIN                  (* get the master program's name and node *)              IF slave_to_master (  
               proc.pname, 
                master_pname,                 master_node) THEN                 GOTO 99;                       (*  Check on the status of the master program *)              IF remote_program_status (                 master_node,   %               master_pname,                        (* program name     *) %                master_status) THEN BEGIN  "               err_mesg_buf := DBCLN_remote_communication_err_mesg;  "                write_error_to_sys_console (                     write_code,                     system_console,                     err_mesg_buf,                     word_len_err_mesg);                  GOTO 99;   
               END;  
     #            IF master_status.state = prog_non_existant_code THEN BEGIN #                     (* save info to RDBAM to clean up the program! *)                  num_aborted := num_aborted + one;                 WITH master_id_table[num_aborted] DO BEGIN                     pname := master_pname;                    node_num := master_node;                    END;  (* with *)                     (* update the reource msg *)                  statistics.prog_aborted := true;                      END  (* THEN *)              ELSE                 statistics.prog_aborted := false;              END   (* then *)               ELSE               master_node := zero;  (* local indicator *)             END; (* WITH *)          FOR ix := one TO num_aborted DO        WITH master_id_table[ix] DO         remove_master (pname, node_num, return_status);       99 :      END; (* check_remote_node *)  $ Page $  #(********************************************************************) # #(*                      send_message                                *) # #(********************************************************************) # #(*                                                                  *) # #(* Send_message sends an resource message to the DBMON progam.      *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE send_message   $ Alias 'DBCLN.SNDMSG' $;      BEGIN (* send_message *)         (* format universal message header *)     WITH request_msg.dbmon, image_comm_buffer DO BEGIN         from_comm_id := DBCLN_comm_id;        from_comm_lock := DBCLN_comm_lock;        to_comm_id := from_comm_identifier;         to_comm_lock := from_comm_locker;         request := to_bm_resource_msg_code;         END; (* WITH *)       %   (* send message on to DBMON, using the proper request message length *) % 	   IF send_request 	        (request_msg.buffer[one], request_msg_len, return_status)    "      THEN BEGIN                   (* Internal IMAGE system error.*) "          (* write a message to the system console *)           err_mesg_buf :=  DBCLN_to_dbmon_comm_err_mesg;            write_error_to_sys_console (               write_code,               system_console,   
            err_mesg_buf,  
             word_len_err_mesg);                END; (* THEN *)      END; (* send_message *)   $ Page $  #(********************************************************************) # #(*                      MAIN CODE                                   *) # #(********************************************************************) #     BEGIN (* DBCLN main program *)         (* initialize DBCLN environment *)      initialize;  
   continue := true; 
        (* detach from session *)     detach_from_session (dummy);          WHILE (continue) DO BEGIN            (* receive request resource message *)  
      recv_message;  
           CASE request_msg.DBCLN.request OF                to_DBCLN_resource_msg_code :            BEGIN                  (* search for inactive programs on local node *)              check_local_node;                   (* search for inactive programs on remote nodes *)              check_remote_node;                  (* send request message *)  
            send_message;  
              END;  (* end resource case *)                   to_DBCLN_finis_code :           BEGIN              (* terminate DBCLN *)               continue := false;           END;       	         otherwise 	          BEGIN              (* illegal message *)               err_mesg_buf := DBCLN_illegal_msg_err_mesg;               write_error_to_sys_console (  
               write_code, 
                system_console,                 err_mesg_buf,                 word_len_err_mesg);           END;  (* otherwise *)      
      END;  (* End case *) 
     99:             END;  (* end while loop *)      END (* DBCLN main program *)  .  