$PASCAL ',7 92081-12008 REV.5000' $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18008                                        *)   (* RELOC:   92081-12008                                        *)   (*                                                             *)   (* PGMR:        <MRL>                                          *)   (*                                                             *)   (* NLS localized by TH                                         *)   (*                                                             *)   (* Date last modified: <870423.1403>  (*                                                             *)   (* Bug fix, January 1986 - DBDS was not allowing special       *)   (*    characters to be the first 'letter' of an item name      *)   (*    or level word. <MRL>                                     *)   (*                                                             *)   (* Bug fix, July 1986: NOLIST option turned on, if an error    *)   (*    occurred, the offending schem line would not be printed. *)   (*    <MRL>                                                    *)   (*                                                             *)   (***************************************************************)      $ List ON $  $ Heap 2 $  $ Range ON $ $ Recursive OFF $ $ Heapparms OFF $  $ Subprogram $      PROGRAM dbds_library_routines;      (**) (*:nl:$ %(*:nl:$atb mdbds_lib %db000 relocatable,messages for dbds_lib <870423.1403> %(*:nl:$ (*:nl:$counter 1 1000 1 (*:nl:$  (**)     "(*******************************************************************) ""(*                      global constants and types                 *) ""(*******************************************************************) "    $ List OFF, Include '[IMAGE', List ON $ $ List OFF, Include '[DBDS ', List ON $      $ Page $     "(*******************************************************************) ""(*                   External definitions                          *) ""(*******************************************************************) "    $ List OFF, Include '[XDFMP', List ON $ $ List OFF, Include '[XUSHF', List ON $      PROCEDURE convert_to_long_int  $ Alias 'CATDI' $    (    char_str : short_str;         start_col: short_int;         str_len  : short_int;      VAR result   : long_int;      VAR status   : short_int);     EXTERNAL;      PROCEDURE fatal_error  $ Alias 'DBDS.FatalError' $    (VAR file_descrip : file_descriptor;          error_number : short_int);     EXTERNAL;     (* The external declarations for NLS below *)      (*:nl:$COPY 'PROCEDURE &; EXTERNAL;'*)  PROCEDURE MDBDS_LIB; EXTERNAL;      FUNCTION  nlread $ Alias 'NLREADREL' $  
   (PROCEDURE ext_module ; 
        msgnum   : short_int;         nlerror  : short_int;      VAR nlsbuff_string : long_str;          nllength : short_int) : short_int;     EXTERNAL;     	FUNCTION NLScanMove 	    (VAR instring : long_str;      VAR outstring: long_str;         flags    : short_int;         length   : short_int;         langnum  : short_int;     VAR error    : short_int; 
    VAR charset  : nltable; 
     VAR shiftset : nltable) : short_int;     EXTERNAL;      $ Page $ "(*******************************************************************) ""(*                       switch_list_file                          *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    When an error occurs writing to the list file,               *) ""(*    switch to the default file (scheduling terminal).            *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "    $ Heapparms OFF $  PROCEDURE switch_list_file  $ Alias 'DBDS.SwitchList' $;     VAR     status : short_int;      BEGIN (* switch_list_file *)         IF close_file (list_file, status) THEN;     default_file (list_file.newfl);    IF open_file_for_write (list_file, status) THEN;     
END; (* switch_list_file *) 
 $ Page $ "(*******************************************************************) ""(*                     check_too_many_errs                         *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To see if too many errors have occurred, and if so, to       *) ""(*    terminate with a fatal error.                                *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "    $ Heapparms OFF $  PROCEDURE check_too_many_errs  $ Alias 'DBDS.TooManyErrs' $;     VAR    display_string : long_str;     status         : short_int;     BEGIN (* check_too_many_errs *)         error_count := error_count + one;        IF (error_count >= dbds_options.errs) THEN BEGIN       display_string := ' Too many schema errors.';  #      IF write_long_str (list_file, display_string, status) THEN BEGIN # 
         switch_list_file; 
 "         IF write_long_str (list_file, display_string, status) THEN; "         END; (* then switch *)           fatal_error(list_file, zero);       END; (* then too many errors *)      END; (* check_too_many_errs *)      $ Page $ "(*******************************************************************) ""(*                       nonfatal_error                            *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To display a DBDS-specific error message, generally regarding*) ""(*    the schema syntax or token value.  Also, if the error count  *) ""(*    is exceeded (default is 100), a fatal_error call is made.    *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in) (1) The DBDS internal error code.                       *) ""(*                                                                 *) ""(*******************************************************************) "    $ Heapparms OFF $  PROCEDURE nonfatal_error  $ Alias 'DBDS.NonFatalErr' $     (errnum : short_int);     LABEL     91, 92;                  (* For NLS test by DEBUG/1000 *)     VAR    display_string : long_str;     status         : short_int;     nlerr          : short_int;     length         : short_int;     msgnum         : short_int;     CONST 
   len = chars_in_long_str; 
    max_input_len = 72; (* chars *)      
BEGIN (* nonfatal_error *) 
     %91:IF (last_error = zero) AND (errnum <> dbds_unreferenced_items_err) THEN %
      last_error := errnum; 
    #   (* If 'NOLIST' was specified, echo the offending (upshifted) line *) #
   IF NOT dbds_options.list 
       THEN IF write_long_str (list_file, input_line, status)           THEN fatal_error (list_file, status);        (* Make a pointer to the offending character/symbol *)        display_string := ' ';    IF next_char <= zero       THEN display_string[2] := '^'    ELSE IF next_char >= chars_in_long_str       THEN display_string[max_input_len] := '^'    ELSE display_string[next_char+one] := '^';         IF write_long_str (list_file, display_string, status)       THEN fatal_error (list_file, status);         (* Decide which error message to print *)        display_string := ' ';        CASE errnum OF %      (******** These messages are extracted to <DB000 for NLS  **********) %           dbds_illegal_keyword_err :          (*:nl:#*1 1000 ' Illegal keyword' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1000;           dbds_illegal_number_err :          (*:nl:#*1 1001 ' Numeric value expected'  *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1001;               dbds_illegal_char_err :          (*:nl:#*1 1002 ' Illegal character' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1002;                dbds_illegal_file_name_err :          (*:nl:#*1 1003 ' Illegal file name' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1003;               dbds_illegal_identifier_err : #         (*:nl:#*1 1004 ' Illegal level word, item name or set name' *) #         (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1004;               dbds_illegal_purge_option_err :           (*:nl:#*1 1005 ' Illegal purge option' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1005;               dbds_control_expected_err :           (*:nl:#*1 1006 ' ''$CONTROL:'' expected' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1006;               dbds_illegal_control_option_err :           (*:nl:#*1 1007 ' Illegal control option' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1007;                dbds_begin_database_expected_err :          (*:nl:#*1 1008 ' ''BEGIN DATA BASE:'' expected' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1008;                dbds_levels_expected_err :           (*:nl:#*1 1009 ' ''LEVELS:'' expected' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1009;                dbds_illegal_level_number_err  :           (*:nl:#*1 1010 ' Illegal level number' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1010;               dbds_level_out_of_bounds_err  :           (*:nl:#*1 1011 ' Level out of range' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1011;               dbds_level_number_used_err  :           (*:nl:#*1 1012 ' Level number already defined' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1012;                dbds_semicolon_expected_err  :           (*:nl:#*1 1013 ' Bad terminator: '';'' expected' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1013;               dbds_sets_expected_err      :           (*:nl:#*1 1014 ' ''SETS:'' expected' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1014;               dbds_items_expected_err     :          (*:nl:#*1 1015 ' ''ITEMS:'' expected' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1015;               dbds_unexpected_eof_err     :          (*:nl:#*1 1016 ' End of file encountered' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1016;               dbds_bad_element_count_err  :          (*:nl:#*1 1017 ' Illegal element count' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1017;               dbds_bad_item_type_err      :           (*:nl:#*1 1018 ' Bad item type designator' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1018;               dbds_odd_character_err      :  !         (*:nl:#*1 1019 ' Total item length not integral words' *) !         (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1019;               dbds_level_not_defined_err  :          (*:nl:#*1 1020 ' Level not defined' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1020;               dbds_comma_expected_err     :           (*:nl:#*1 1021 ' '','' expected' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1021;               dbds_bad_write_level_err    :          (*:nl:#*1 1022 ' Bad write level' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1022;                dbds_right_paren_expected_err  :           (*:nl:#*1 1023 ' '')'' expected' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1023;               dbds_duplicate_level_err    :           (*:nl:#*1 1024 ' Duplicate level word' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1024;               dbds_duplicate_item_err     :          (*:nl:#*1 1025 ' Duplicate item name' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1025;               dbds_name_expected_err      :           (*:nl:#*1 1026 ' ''NAME:'' expected' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1026;               dbds_bad_set_type_err       :          (*:nl:#*1 1027 ' Bad set type designator' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1027;               dbds_too_many_items_err     :          (*:nl:#*1 1028 ' Too many data items in database' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1028;               dbds_too_many_sets_err      :           (*:nl:#*1 1029 ' Too many data sets' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1029;               dbds_entry_expected_err     :          (*:nl:#*1 1030 ' ''ENTRY:'' expected' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1030;               dbds_item_not_defined_err   :          (*:nl:#*1 1031 ' Undefined item referenced' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1031;                dbds_non_numeric_path_count_err  :           (*:nl:#*1 1032 ' Non-numeric path count' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1032;               dbds_invalid_path_count_err :           (*:nl:#*1 1033 ' Bad path count' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1033;               dbds_no_entries_defined_err :          (*:nl:#*1 1034 ' At least one item must be defined' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1034;               dbds_no_key_defined_err     :          (*:nl:#*1 1035 ' Master must have a path' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1035;               dbds_automaster_has_nonkey_items_err  :  #         (*:nl:#*1 1036 ' Automatic master must have key item only' *) #         (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1036;               dbds_compound_item_cant_be_key_err  :           (*:nl:#*1 1037 ' Path item cannot be an array' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1037;               dbds_too_many_items_in_set_err  :           (*:nl:#*1 1038 ' Too many items in data set' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1038;               dbds_set_not_defined_err    :           (*:nl:#*1 1039 ' Undefined set referenced' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1039;               dbds_incompatible_keys_err  :  !         (*:nl:#*1 1040 ' Key items not of same length or type' *) !         (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1040;                dbds_compound_item_cannot_be_sorted_err  :           (*:nl:#*1 1041 ' Sort item cannot be an array' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1041;               dbds_key_and_sort_items_the_same_err  :           (*:nl:#*1 1042 ' Path and sort items are the same' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1042;                dbds_sort_item_not_in_set_err  :           (*:nl:#*1 1043 ' Sort item is not in data set' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1043;                dbds_master_not_writeable_err  : "         (*:nl:#*1 1044 ' Auto-master needs more write capability' *) "         (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1044;               dbds_path_item_already_defined_err  :          (*:nl:#*1 1045 ' Search item already defined' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1045;               dbds_too_many_paths_err :         (*:nl:#*1 1046 ' Too many paths' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1046;                dbds_capacity_expected_err :         (*:nl:#*1 1047 ' ''CAPACITY:'' expected' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1047;               dbds_end_expected_err :          (*:nl:#*1 1048 ' ''END.'' expected' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1048;               dbds_bad_capacity_count_err :         (*:nl:#*1 1049 ' Bad capacity count' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1049;                dbds_file_already_used_err :         (*:nl:#*1 1050 ' File name already used' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1050;                dbds_set_name_too_long_err :          (*:nl:#*1 1051 ' Data set name is too long' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1051;               dbds_duplicate_set_name_err :         (*:nl:#*1 1052 ' Duplicate set name' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1052;               dbds_unreferenced_items_err :          (*:nl:#*1 1053 ' The following item(s) are unused:' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1053;               dbds_too_many_paths_to_master_err :         (*:nl:#*1 1054 ' Too many paths to master' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1054;                dbds_undefined_paths_err :           (*:nl:#*1 1055 ' All paths to master are not defined' *)           (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1055;               dbds_no_items_in_database_err :          (*:nl:#*1 1056 ' Database must have at least one item' *)           (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1056;                dbds_no_items_in_set_err :          (*:nl:#*1 1057 ' Data set must have at least one item' *)           (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1057;          
      dbds_list_file_err : 
        (*:nl:#*1 1058 ' Error writing to list file' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1058;                dbds_entry_too_big_err :          (*:nl:#*1 1059 ' Entry too big' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1059;               dbds_file_too_large_err :          (*:nl:#*1 1060 ' Data set file too large' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1060;             OTHERWISE          (*:nl:#*1 1061 ' *** Unexpected DBDS error ***' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1061;          	   END; (* case *) 	    %(*:nl:$COPY '   length := nlread(&, msgnum, nlerr, display_string, len);'*) % #   length := nlread(MDBDS_LIB, msgnum, nlerr, display_string, len);    #   display_string[length+1] := ' ';     (*NLS*)        IF errnum = dbds_list_file_err        THEN switch_list_file;         !   IF write_long_str (list_file, display_string, status) THEN BEGIN !      switch_list_file;        IF write_long_str (list_file, display_string, status) THEN;   92:   END;      !   (* Increment error count and see if too many have been found *) !       if msgnum <> 1053 then  !      check_too_many_errs;   {allow unreferenced item ahj 4-23-87} !    END; (* nonfatal_error *)  $ Page $ "(*******************************************************************) ""(*                         peek_ahead                              *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose: To look at the next character and return what kind it  *) ""(*          is (alpha, numeric, special or terminator)             *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(* Function result is the next character's type.                   *) ""(*                                                                 *) ""(*******************************************************************) "    $ Heapparms OFF $ FUNCTION peek_ahead  $ Alias 'DBDS.PeekAhead' $    : character_classes;     CONST !   (* Native language character sets range from 128-255 per byte *) !    min_native_language_char = 128;     VAR  
   peek_char : char; 
     BEGIN (* peek_ahead *)         peek_char := input_line[next_char];        (**)    (* IMAGE/1000 supports native language identifiers for     (* data item, data set, level and file names.     (* This is accomplished by treating any character above the     (* ASCII range (0-127) as a Capital 'letter'.    (* In this way, an identifier beginning with a foreign     (* character is acceptable.    (*    (* Note:  At this time (January 1985) there are no other    (* IMAGE products which support native language identifiers.    (* We are pioneering the effort within HP, hence, a database      (* with native language set and item names cannot be directly     (* migrated to another HP machine.    (**)             IF ((peek_char >= 'A') AND (peek_char <= 'Z')) OR        (ord(peek_char) >= min_native_language_char)       THEN peek_ahead := alphabetic     ELSE IF (peek_char >= '0') AND (peek_char <= '9')        THEN peek_ahead := numeric    ELSE       CASE peek_char OF      	         ':', '=', 	          ' ', ';', '(', ')', ',', '.' : peek_ahead := terminator;               '<' : IF input_line[next_char+1] = '<'                   THEN peek_ahead := terminator                    ELSE peek_ahead := alphabetic;     "         '!', '#', '$', '%', '&', '''', '^', '@', '*', '>', '?', '_', "              '/' : peek_ahead := alphabetic;              OTHERWISE BEGIN (* illegal character! *)             nonfatal_error (dbds_illegal_char_err);              peek_ahead := special;              END; (* otherwise *)           END; (* case *)     
END; (* peek_ahead *) 
 $ Page $ "(*******************************************************************) ""(*                      determine_char_type                        *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To identify what type of special symbol a character          *) ""(*    represents, and return the tokens_type value to the caller.  *) ""(*    The character is assumed to not be alphanumeric!!!           *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in) (1) The character to identify.                          *) ""(*                                                                 *) ""(* Function result:                                                *) ""(*    'tokens_type' as defined in [dbds.                           *) ""(*                                                                 *) ""(*******************************************************************) "    $ Heapparms OFF $  FUNCTION determine_char_type  $ Alias 'DBDS.DetCharType' $    (char_val : char) : tokens_type;     BEGIN (* determine_char_type *)     	   CASE char_val OF 	           '(' : determine_char_type := left_paren;       ')' : determine_char_type := right_paren;       ',' : determine_char_type := comma;       ';' : determine_char_type := semicolon;       ':' : determine_char_type := colon;        '.' : determine_char_type := period;        '=' : determine_char_type := equals;     #      '!', '#', '$', '%', '&', '''', '^', '@', '*', '<', '>', '?', '_', #           '/' : determine_char_type := name_token;            OTHERWISE determine_char_type := illegal_symbol; 
      END; (* case *) 
 END; (* determine_char_type *)  $ Page $ "(*******************************************************************) ""(*                      upshift_line                               *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To perform upshifting for the various native languages.      *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The source long str.                               *) ""(*    (out) (2) The upshifted long str.                            *) ""(*    (in)  (3) The character length of long_str.                  *) ""(*                                                                 *) ""(*******************************************************************) "    PROCEDURE upshift_line   $ Alias 'DBDS.Upshift' $  
   (VAR instr  : long_str; 
 
    VAR outstr : long_str; 
         len    : short_int);     VAR 
   flags : short_int; 

   numch : short_int; 

   error : short_int; 
     BEGIN (* upshift_line *)        flags := 47;         IF langid <> zero THEN BEGIN (* non-English language *)       numch := nlscanmove (instr, outstr, flags, len,  "                           langid, error, chara_table, shift_table); " 
      END (* then *) 
        ELSE BEGIN (* do English upshift *)        upshift_long_str (instr, outstr, len); 
      END; (* else *) 
    END; (* upshift_line *)  $ Page $ "(*******************************************************************) ""(*                      get_char                                   *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To get the pending character from the input line.            *) ""(*    Since the input line is longer (128 chars) than the          *) ""(*    max allowable input (72 chars), there will always be         *) ""(*    trailing blanks in the buffer which will act as a            *) ""(*    separator.                                                   *) ""(*                                                                 *) ""(*    Get_char automatically advances the pending-char pointer.    *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(* Function result: The pending character (see peek_ahead)         *) ""(*                                                                 *) ""(*******************************************************************) "    $ Heapparms OFF $ FUNCTION get_char  $ Alias 'DBDS.GetChar' $     : char;     VAR     status : short_int; 
   display_line : long_str; 
     
BEGIN (* get_char *) 
     !   IF next_char > chars_in_long_str THEN BEGIN (* get next line *) ! !      IF read_long_str (input_file, input_line, status) THEN BEGIN !          nonfatal_error (dbds_unexpected_eof_err);           fatal_error (input_file, status);          END;           IF dbds_options.list THEN BEGIN          display_line := ' ';               long_dest_long_srce (display_line, chars_in_long_str,                                input_line, chars_in_long_str,                                str_overlay, 2);               IF write_long_str (list_file, display_line, status)             THEN fatal_error (list_file, status);           END; (* then *)           upshift_line (input_line, input_line, chars_in_long_str);       next_char := one;        END;        get_char := input_line[next_char];         next_char := next_char + one;     	END; (* get_char *) 	 $ Page $ "(*******************************************************************) ""(*                     next_significant                            *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose: To advance the pending character pointer to the next   *) ""(*    character of some signifigance, skipping over comments and   *) ""(*    blanks.                                                      *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "    $ Heapparms OFF $  PROCEDURE next_significant  $ Alias 'DBDS.NextSignif' $;     VAR    significant_found : boolean;    end_of_comment    : boolean;     cur_char          : char;      BEGIN (* next_significant *)         significant_found := false;        WHILE NOT significant_found DO BEGIN     
      cur_char := get_char; 
           IF (cur_char <> ' ') AND (cur_char <> '<')           THEN significant_found := true;            WHILE cur_char = ' ' DO  (* skip blanks *)           cur_char := get_char;      #      IF (cur_char = '<') AND (input_line[next_char] = '<') THEN BEGIN #         end_of_comment := false;          REPEAT             IF get_char = '>'                THEN IF get_char = '>'                    THEN end_of_comment := true;             UNTIL end_of_comment;          END (* then was a comment *)           ELSE significant_found := true;            END; (* while *)        (* Bump pending char back to significant char *)     next_char := next_char - one;     
END; (* next_significant *) 
 $ Page $ "(*******************************************************************) ""(*                    semicolon_scan                               *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To skip all tokens up to and including the next semicolon.   *) ""(*    This is primarily used when an error is encountered          *) ""(*    in a clause.  The semicolon terminates most clauses.         *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "    $ Heapparms OFF $ PROCEDURE semicolon_scan  $ Alias 'DBDS.Semicolon' $;      
BEGIN (* semicolon_scan *) 
       (* Skip all tokens up to and including the next semicolon *)        REPEAT       next_significant; (* find next significant token *)     UNTIL get_char = ';';        current_token.token_kind := semicolon;     END; (* semicolon_scan *)  $ Page $ "(*******************************************************************) ""(*                      terminator_scan                            *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To scan up to a comma or semicolon, either of which can      *) ""(*    terminate an 'expression'.                                   *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "    $ Heapparms OFF $ PROCEDURE terminator_scan  $ Alias 'DBDS.Terminator' $;     VAR 	   cur_char : char; 	    
BEGIN (* terminator_scan *) 
       REPEAT       next_significant; 
      cur_char := get_char; 
    UNTIL (cur_char = ',') OR (cur_char = ';');         WITH current_token DO  
   IF cur_char = ',' 
       THEN token_kind := comma       ELSE token_kind := semicolon;      
END; (* terminator_scan *) 
 $ Page $ "(*******************************************************************) ""(*                      get_token                                  *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To specifically look for a token from the schema which is    *) ""(*    either all alphabetic, a separator or terminator, or a       *) ""(*    number.  Key words, in particular, like NAME and CAPACITY    *) ""(*    are examples.  Semi-colons, colons, commas, etc., are in the *) ""(*    class of separators and terminators.                         *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(* Function result is the token type.                              *) ""(*                                                                 *) ""(*******************************************************************) "    $ Heapparms OFF $ FUNCTION get_token  $ Alias 'DBDS.GetToken' $    : tokens_type;     LABEL 99;     VAR    char_kind     : character_classes;     current_char  : char;    cur_index     : short_int;    status        : short_int;     
BEGIN (* get_token *) 
       next_significant; (* advance to a significant character *)         char_kind := peek_ahead; (* look at the next character *)  
   cur_index := one; 
   current_token.identifier.keyword := ' '; (* set to blanks *)         WITH current_token DO  
   CASE char_kind OF 
           alphabetic : BEGIN (* must all be alpha *)              REPEAT                  IF cur_index > chars_in_short_str THEN BEGIN                nonfatal_error (dbds_illegal_keyword_err);                GOTO 99; 	               END; 	                 identifier.keyword[cur_index] := get_char;             cur_index := cur_index + one;               UNTIL peek_ahead <> alphabetic;          token_kind := alpha_token;           END; (* case of alphabetic token *)          !      numeric : BEGIN (* must not exceed a 32-bit integer value *) !             REPEAT                  IF cur_index > chars_in_short_str THEN BEGIN                 nonfatal_error (dbds_illegal_number_err);                GOTO 99; 	               END; 	                 identifier.keyword[cur_index] := get_char;             cur_index := cur_index + one;              UNTIL peek_ahead <> numeric;               convert_to_long_int (identifier.keyword, one,                                 chars_in_short_str, numeric_value,                                 status);          IF status <> zero THEN BEGIN             nonfatal_error (dbds_illegal_number_err);              numeric_value := zero;  
            GOTO 99; 
             END;               token_kind := number_token;          END; (* case of numeric token *)           OTHERWISE BEGIN (* non alpha-numeric character *)           current_char := get_char;           token_kind   := determine_char_type (current_char);          identifier.keyword[one] := current_char;          END;       END; (* case of initial character type *)     
99:  (* error exit *) 
       get_token := current_token.token_kind;      
END; (* get_token *) 
 $ Page $ "(*******************************************************************) ""(*                     scan_for_keyword                            *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To get token-by-token from the schema until a specified      *) ""(*    token is found (must be alpha, special or terminator).       *) ""(*                                                                 *) ""(* Parameter:                                                      *) ""(*    (in)  (1) The token to find.                                 *) ""(*                                                                 *) ""(* The token may be up to 16 alpha chars or one non-alphanumeric.  *) ""(*                                                                 *) ""(*******************************************************************) "    $ Heapparms OFF $ PROCEDURE scan_for_keyword  $ Alias 'DBDS.ScanForKey' $ 
   (key_value : short_str); 
    VAR    kind_of_token : tokens_type;      BEGIN (* scan_for_keyword *)        REPEAT kind_of_token := get_token;     UNTIL key_value = current_token.identifier.keyword;     
END; (* scan_for_keyword *) 
 $ Page $ "(*******************************************************************) ""(*                      get_filename                               *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    Retrieve all characters up to a terminator, except a colon   *) ""(*    is not considered a terminator.  The set of characters makes *) ""(*    up the file name.                                            *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(* File name is placed in the global variable current_token.       *) ""(*                                                                 *) ""(*******************************************************************) "    $ Heapparms OFF $ PROCEDURE get_filename  $ Alias 'DBDS.GetFileName' $;     LABEL 99;     VAR     char_pos : short_int; 	   cur_char : char; 	     BEGIN (* get_filename *)         WITH current_token DO BEGIN        file_value := ' ';        token_kind := illegal_symbol; (* assume worst *)            char_pos := one;            next_significant; (* advance to first sig. char *)        REPEAT        IF (peek_ahead = terminator) AND          (input_line[next_char] <> ':') AND           (input_line[next_char] <> '.') THEN BEGIN           token_kind := filename_token;           END (* then end of file name *)            ELSE IF (char_pos > chars_in_new_file_name) THEN BEGIN          nonfatal_error (dbds_illegal_file_name_err);           token_kind := illegal_symbol;          GOTO 99;           END (* then too many chars *)           ELSE BEGIN (* append char to file name *)           file_value[char_pos] := get_char;           char_pos := char_pos + one;           END; (* else *)        UNTIL token_kind = filename_token;           IF file_value = ' '           THEN nonfatal_error (dbds_illegal_file_name_err);     
      END; (* with *) 
    
99:  (* error exit *) 
    END; (* get_filename *)  $ Page $ "(*******************************************************************) ""(*                      get_identifier                             *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To retrieve an IMAGE identifier, which must obey the rules   *) ""(*    for IMAGE item/set names: A-Z for the first character,       *) ""(*    0-9, ! # $ % & ' ^ @ * < > / ? for the remaining characters, *) ""(*    (except <<) up to 6 characters maximum.                      *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "    $ Heapparms OFF $ PROCEDURE get_identifier $ Alias 'DBDS.GetIdent' $;     LABEL 99;     VAR     char_pos : short_int;      
BEGIN (* get_identifier *) 
    	   char_pos := one; 	    next_significant; (* scan over blanks/comments *)     WITH current_token DO 
   WITH identifier DO BEGIN 
          item_name := ' ';            IF peek_ahead <> alphabetic THEN BEGIN           nonfatal_error (dbds_illegal_identifier_err);           token_kind := illegal_symbol;          GOTO 99;          END;           WHILE peek_ahead <> terminator DO BEGIN           IF (char_pos > chars_in_short_str) THEN BEGIN             nonfatal_error (dbds_illegal_identifier_err);             token_kind := illegal_symbol;  
            GOTO 99; 
             END;          keyword[char_pos] := get_char;           char_pos := char_pos + one;          END; (* while *)           token_kind := name_token;     
      END; (* with *) 
     
99: (* error exit *) 
    END; (* get_identifier *)  $ Page $ "(*******************************************************************) ""(*                    nonfatal_error_with_item                     *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To display an error message which includes an item name.     *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The error number                                   *) ""(*    (in)  (2) The item name                                      *) ""(*                                                                 *) ""(*******************************************************************) "     PROCEDURE nonfatal_error_with_item  $ Alias 'DBDS.ItemError' $ $ Heapparms OFF $     (err_num : short_int;  $ Heapparms ON $      item_id : item_name_type);     LABEL     91,92;         (* For NLS test by DEBUG/1000 *)     CONST 
   len = chars_in_long_str; 
    VAR    display_string : long_str;     status         : short_int;     length         : short_int;     nlerr          : short_int;      BEGIN (* nonfatal_error_with_item *)     91:last_error := err_num;        display_string := ' ';      	   CASE err_num OF 	          dbds_sort_item_not_in_set_err : BEGIN       (* display_string := ' Sort item is not defined:'; *)        (*:nl:#*1 1062 ' Sort item is not defined:' *)       (*:nl:$COPY '         length := nlread (&, #, nlerr' *)          length := nlread (MDBDS_LIB, 1062, nlerr                                 , display_string, len);          display_string[length+1] := ' ';                long_dest_item_srce (display_string, chars_in_long_str,                                 item_id, chars_in_item_name,                               str_blankappend, zero);           END; (* case of sort item not in set *)           OTHERWISE        (*:nl:#*1 1063 ' *** Unexpected item error ***' *)        (*:nl:$COPY '      length := nlread (&, #, nlerr' *)        length := nlread (MDBDS_LIB, 1063, nlerr                             , display_string, len);        display_string[length+1] := ' ';     
      END; (* case *) 
        !   IF write_long_str (list_file, display_string, status) THEN BEGIN !      switch_list_file;        IF write_long_str (list_file, display_string, status) THEN;   92:   END;        (* See if too many errors have been encountered *)    check_too_many_errs;     END; (* nonfatal_error_with_item *)  $ Page $ "(*******************************************************************) ""(*                    nonfatal_error_with_set                      *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To display an error message related to a data set, including *) ""(*    the data set name in the message.                            *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The error number                                   *) ""(*    (in)  (2) The data set name.                                 *) ""(*                                                                 *) ""(*******************************************************************) "     PROCEDURE nonfatal_error_with_set  $ Alias 'DBDS.SetError' $ $ Heapparms OFF $     (err_num : short_int;  $ Heapparms ON $     set_id  : set_name_type);     LABEL     91,92;           (* For NLS test by DEBUG/1000 *)     CONST 
   len = chars_in_long_str; 
    VAR    display_string : long_str;     status         : short_int;     length         : short_int;     nlerr          : short_int;     msgnum         : short_int;     BEGIN (* nonfatal_error_with_set *)     91:last_error := err_num;      	   CASE err_num OF 	          dbds_master_not_writeable_err :  #         (*:nl:#*1 1064 ' Auto-master needs more write capability:' *) #         (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1064;                dbds_no_items_in_set_err :           (*:nl:#*1 1065 ' No items defined in set:' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1065;               dbds_no_key_defined_err :           (*:nl:#*1 1066 ' Master must have path:' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1066;                dbds_entry_too_big_err :           (*:nl:#*1 1067 ' Entry too big:' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1067;                dbds_undefined_paths_err :  !         (*:nl:#*1 1068 ' All paths to master are not defined:' *) !         (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1068;               dbds_file_too_large_err :           (*:nl:#*1 1069 ' Data set file too large:' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1069;               OTHERWISE           (*:nl:#*1 1070 ' *** Unexpected set error ***' *)          (*:nl:$COPY '         msgnum := #;' *)           msgnum := 1070;         
      END; (* case *) 
       display_string := ' ';      &(*:nl:$COPY '   length := nlread (&, msgnum, nlerr, display_string, len);'*) &#   length := nlread (MDBDS_LIB, msgnum, nlerr, display_string, len);    #   display_string[length+1] := ' ';        long_dest_set_srce (display_string, chars_in_long_str,                        set_id, chars_in_set_name,                         str_blankappend, zero);         IF write_long_str (list_file, display_string, status)       THEN fatal_error (list_file, status);     92:check_too_many_errs;      END; (* nonfatal_error_with_set *)  $ Page $ "(*******************************************************************) ""(*                        post_runtable_buffer                     *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To flush whatever is in the root_buffer to the root file,    *) ""(*    set the root_buffer to all zeroes, and the root_bufx variable*) ""(*    to zero.                                                     *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "    $ Heapparms OFF $ PROCEDURE post_runtable_buffer   $ Alias 'DBDS.PostBuffer' $;     VAR    i : short_int;     status : short_int;      BEGIN (* post_runtable_buffer *)        (**)    (* If there is data in root_buffer, post it to disc.    (**)        IF root_bufx > zero THEN BEGIN       IF do_block_transfer (write_code,                            root_file,                            root_blkx,                            one,                            root_buffer[zero],                             status)           THEN fatal_error (root_file, status);           root_blkx := root_blkx + one;        END; (* then write the buffer to disc *)        (* Set the buffer to empty and used words to zero *)     
   root_bufx := zero; 
    FOR i := zero TO words_in_disc_block-one DO       root_buffer[i] := zero;     END; (* post_runtable_buffer *)  $ Page $ "(*******************************************************************) ""(*                    add_entry_to_runtable                        *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To add an arbitrary-size buffer to the run table.            *) ""(*    It may be a header or a table entry or anything else.        *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The buffer to be added.                            *) ""(*    (in)  (2) The word length of the buffer.                     *) ""(*                                                                 *) ""(*******************************************************************) "     PROCEDURE add_entry_to_runtable  $ Alias 'DBDS.AddEntry' $  $ Heapparms ON $     (VAR buffer : data_record_type;          length : short_int);     VAR     status : short_int;     i      : short_int;         BEGIN (* add_entry_to_runtable *)        (**)    (* Move one word at a time, posting the root_buffer when     (* it becomes full.    (**)        FOR i := zero TO length-1 DO BEGIN            IF root_bufx = words_in_disc_block          THEN post_runtable_buffer;            root_buffer[root_bufx] := buffer[i];       root_bufx := root_bufx + one;  
      END; (* for *) 
     END; (* add_entry_to_runtable *)          $ Page $ "(*******************************************************************) ""(*                       null_pad                                  *) ""(*******************************************************************) ""(*                                                                 *) ""(*    This procedure added here for NLS localizatin by T.H.        *) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    Put the null at the end of the string of NLS                 *) ""(*    parameter substitution.                                      *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in/out) (1) Buffer name for NLS parameter substitution.     *) ""(*    (in)     (2) Buffer length.                                  *) ""(*******************************************************************) "    $ Heapparms OFF $  PROCEDURE null_pad   $ Alias  'DBDS.NlsTerm' $     (VAR buffer  : short_str;         length  : short_int);     CONST     null = 0;     VAR  
   count      : short_int; 
     
BEGIN (* null_pad *) 
        FOR count := length DOWNTO 1 DO         IF (buffer[count] = ' ') AND (buffer[count-1] <> ' ') THEN            buffer[count] := chr(null);     	END; (* null_pad *) 	     .  