 $PASCAL ',7 92081-1X656 REV.2540' $       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18656                                        *)  ! !(* RELOC:   92081-1X656                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified: <860206.1133>  !(*                                                             *)  ! !(***************************************************************)  !     $ List ON $   $ Heap 2 $  $ Range ON $  	$ Recursive OFF $  	 	$ Heapparms OFF $  	 $ Subprogram $      PROGRAM dbds_subs_for_segment_two;      #(*******************************************************************)  # #(*                      global constants and types                 *)  # #(*******************************************************************)  #     $ List OFF, Include '[IMAGE', List ON $   $ List OFF, Include '[DBDS ', List ON $   $ Page $      #(*******************************************************************)  # #(*                   External definitions                          *)  # #(*******************************************************************)  #     $ List OFF, Include '[XDBDS', List ON $   $ List OFF, Include '[XDFMP', List ON $   $ List OFF, Include '[XUSHF', List ON $       $ Page $  #(*******************************************************************)  # #(*                     Check_level_defined                         *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    Given a level number, to check that the level number is      *)  # #(*    within bounds.  Next, to return whether or not the level     *)  # #(*    number has been defined in the schema.                       *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) The level number.                                  *)  # #(*                                                                 *)  # #(*                                                                 *)  # #(*******************************************************************)  #     $ Heapparms ON $  FUNCTION check_level_defined  $ Alias 'DBDS.LevelDef' $      (level_num : short_int) : boolean;       BEGIN (* check_level_defined *)          check_level_defined := false; (* Assume not defined *)       !   IF (level_num <= 0) OR (level_num > entries_in_password_block)  !       THEN nonfatal_error (dbds_level_out_of_bounds_err)         ELSE IF level_words.levels[level_num] <> ' '         THEN check_level_defined := true;       END; (* check_level_defined *)  $ Page $  #(*******************************************************************)  # #(*                     Check_duplicate_level                       *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To insure that all defined level words are unique.           *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) The level word to check against.                   *)  # #(*                                                                 *)  # #(* Function result: 'true' if a duplicate is found.                *)  # #(*                                                                 *)  # #(*******************************************************************)  #     $ Heapparms ON $  FUNCTION check_duplicate_level  $ Alias 'DBDS.DupLevel' $      (    level_num  : short_int;       VAR level_word : level_word_type) : boolean;      VAR   	   i : short_int;  	     BEGIN (* check_duplicate_level *)          check_duplicate_level := false; (* Assume no duplicate *)         IF level_words.levels[level_num] <> ' '        THEN check_duplicate_level := true         ELSE FOR i := one TO entries_in_password_block DO        IF level_words.levels[i] = level_word            THEN check_duplicate_level := true;      END; (* check_duplicate_level *)  $ Page $  #(*******************************************************************)  # #(*                   levels_clause                                 *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To process the LEVELS: portion of the IMAGE/1000 schema.     *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE levels_clause  $ Alias 'DBDS.Levels' $;       LABEL 88, (* For null level word list *)        77; (* when a level-word definition has an error *)       VAR   	   i : short_int;  	    ttype : tokens_type;      any_level  : boolean;      
BEGIN (* levels_clause *)  
        (**)      (* Syntax is:     (*      (* LEVELS: <level-defs>;  or LEVELS:; if no levels defined.     (*      (* <level-defs> can be null, or a sequence of up to 15 of:      (*      (* <level#> <identifier> ;      (*   $   (* where <level#> is from 1 to 15 (appearing only once in the list),  $    (*   and <identifier> conforms to IMAGE identifier rules.     (*       (* The end of the LEVELS: part is signified by a null list or   "   (* by a non-numeric token after a semicolon (must then be ITEMS). "    (**)          (* Initialize the level word entries *)         FOR i := one TO entries_in_password_block DO         level_words.levels[i] := ' ';          any_level := false; (* no level defined yet *)       
   (* Look for LEVELS: *)  
        WITH current_token.identifier DO BEGIN         IF (get_token <> alpha_token) OR (keyword <> 'LEVELS')           THEN nonfatal_error (dbds_levels_expected_err);            IF get_token <> colon THEN BEGIN           nonfatal_error (dbds_levels_expected_err);            scan_for_key (':');           END;             (* Expect a list of <lev#> <ident> ; *)         (* ITEMS is a reserved word here.    *)       $      REPEAT (* at least one level present; quit when alpha is peeked *) $              IF get_token <> number_token THEN BEGIN      %            (* If no levels, must be semicolon, otherwise must be ITEMS *) %             WITH current_token DO BEGIN                  IF NOT any_level                     THEN IF token_kind = semicolon                       THEN ttype := get_token  %                     ELSE nonfatal_error (dbds_illegal_level_number_err);  %                IF (token_kind = alpha_token) AND                    (identifier.keyword = 'ITEMS')                    THEN GOTO 88;                  END; (* with *)                  nonfatal_error (dbds_illegal_level_number_err);               semicolon_scan;               GOTO 77; (* skip through next semicolon *)              END;               any_level := true; (* at least one level defined *)               i := current_token.numeric_value;      #         IF (i <= zero) OR (i > entries_in_password_block) THEN BEGIN  #             nonfatal_error (dbds_level_out_of_bounds_err);              semicolon_scan;   
            GOTO 77; 
             END;               get_identifier; (* get the level word *)                IF level_word <> ' '               THEN IF check_duplicate_level (i,level_word)                 THEN nonfatal_error (dbds_duplicate_level_err)                  ELSE level_words.levels[i] := level_word;               IF get_token <> semicolon THEN BEGIN               nonfatal_error (dbds_semicolon_expected_err);               semicolon_scan;               END;      77: (* to skip to next level-word statement *)      
         next_significant; 
              UNTIL 1=2; (* repeat forever until ITEMS is found *)       88: (* when ITEMS is encountered *)             (**)        (* Ok, we have processed the LEVELS: statement.   #      (* The ITEMS: keyword should be next, so end processing LEVELS.  #       (**)            END; (* with current_token.identifier *)      END;  $ Page $  #(*******************************************************************)  # #(*                   Duplicate_item_name                           *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To return the item number of a supplied data item name,      *)  # #(*    if one exists.                                               *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) The item name.                                     *)  # #(*                                                                 *)  # #(* Function result: Item table index, or zero if not found.        *)  # #(*                                                                 *)  # #(*******************************************************************)  #     $ Heapparms ON $  FUNCTION find_item  $ Alias 'DBDS.FindItem' $      (item_identifier : item_name_type) : short_int;      VAR   	   i : short_int;  	     BEGIN (* find_item *)          find_item := zero;   (* assume non-existent *)          FOR i := one TO numitems DO        IF item_table_ptr^[i].item_id = item_identifier            THEN find_item := i;       
END; (* find_item *) 
 $ Page $  #(*******************************************************************)  # #(*                   items_clause                                  *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To process the ITEMS: portion of the IMAGE/1000 schema.      *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE items_clause  $ Alias 'DBDS.Items' $;       LABEL 88, (* skip to next item statement *)         99; (* skip to SETS: clause        *)       VAR      elems : short_int;      itemx : short_int;      length: short_int;      kind_of_token : tokens_type;       BEGIN (* items_clause *)         (**)      (* Syntax:      (*      (*    ITEMS: <item-list>      (*      (* <item-list> cannot be empty and has the syntax:      (*   %   (*    <identifier>, [<elements>] <type> <length> [ (<rlev>,<wlev>) ] ;  %    (*      (* where <identifier> is the item name      (*       <elements>   is the array-size for a compound item     (*       <type>       is 'I', 'R' or 'X'   %   (*       <length>     is 1 or 2 for 'I', 2 or 4 for 'R', 1-255 for 'X'  %    (*       <rlev>       is a defined level number (default=0)  $   (*       <wlev>       is a defined level number > rlev (default = 15) $    (**)          (**)      (* ITEMS was found by levels_clause.      (* Make sure a colon follows ITEMS.     (**)          IF get_token <> colon        THEN nonfatal_error (dbds_items_expected_err);             (* Process the item-list part *)          WITH current_token DO     REPEAT (* until an identifier SETS is found *)             itemx := numitems + one;                 get_identifier; (* get the item name or 'SETS' keyword *)              IF identifier.keyword <> 'SETS' THEN BEGIN                IF numitems = max_items THEN BEGIN (* too many items *)               nonfatal_error (dbds_too_many_items_err);               scan_for_key ('SETS');  
            GOTO 99; 
             END;               WITH item_table_ptr^[itemx] DO BEGIN   $         IF identifier.keyword[chars_in_item_name+one] <> ' ' THEN BEGIN $             nonfatal_error (dbds_illegal_identifier_err);               semicolon_scan;   
            GOTO 88; 
             END;               (* Process the item definition statement *)               (* Save the item name *)            WITH identifier DO BEGIN               item_id := item_name;               IF find_item (item_name) > zero THEN BEGIN                 nonfatal_error (dbds_duplicate_item_err);                 semicolon_scan;                 GOTO 88;   
               END;  
             END;               (* Make sure the comma is there *)            IF get_token <> comma THEN BEGIN               nonfatal_error (dbds_comma_expected_err);               semicolon_scan;   
            GOTO 88; 
             END;               (* Look for optional [elements] *)   "         token_kind := get_token; (* either elements or item type *) "              IF token_kind = number_token THEN BEGIN                  elems := numeric_value;   #            IF (elems <= 0) OR (elems > max_item_elements) THEN BEGIN  #                nonfatal_error (dbds_bad_element_count_err);                  semicolon_scan;                 GOTO 88;   
               END;  
             elements := elems;  "            (* fetch the next token: ought to be 'I', 'R' or 'X' *)  "             kind_of_token := get_token;               END (* then process element count *)                  ELSE elements := one; (* default scalar count *)               (* Process the item type clause *)            WITH identifier DO             IF (token_kind <> alpha_token) OR ((keyword <> 'I') AND                (keyword <> 'R') AND (keyword <> 'X')) THEN BEGIN              nonfatal_error (dbds_bad_item_type_err);              semicolon_scan;   
            GOTO 88; 
             END;               item_kind := identifier.keyword[one]; (* I, R or X *)               (* Get the item length part *)            IF get_token <> number_token THEN BEGIN              nonfatal_error (dbds_bad_item_type_err);              semicolon_scan;   
            GOTO 88; 
             END;      "         (* Check the length for validity with the specified type *) "          length := numeric_value;       #         IF ((item_kind = 'I') AND (length <> 1) AND (length <> 2)) OR # #            ((item_kind = 'R') AND (length <> 2) AND (length <> 4)) OR #             ((item_kind = 'X') AND               ((length < 1) OR (length > 255))) THEN BEGIN               nonfatal_error (dbds_bad_item_type_err);              semicolon_scan;               END;                (* Check that for 'X' type, length*elements is even *)    &         IF (item_kind = 'X') AND ((length*elements MOD 2) <> 0) THEN BEGIN  &             nonfatal_error (dbds_odd_character_err);              semicolon_scan;   
            GOTO 88; 
             END;               (* Save the total item length in WORDS *)           IF item_kind = 'X'   #            THEN item_length := (length * elements) DIV chars_in_word  #             ELSE item_length := length * elements;               (* Choose default item read/write levels of 0/15 *)  
         r_level := zero;  
          w_level := 15;                (* Check for optional (rlev,wlev) clause. *)            IF get_token = left_paren THEN BEGIN                   (* process the read/write levels clause *)              IF get_token <> number_token THEN BEGIN                  nonfatal_error (dbds_illegal_level_number_err);                 semicolon_scan;                 GOTO 88;   
               END;  
     !            IF NOT check_level_defined (numeric_value) THEN BEGIN  !                nonfatal_error (dbds_level_not_defined_err);                  semicolon_scan;                 GOTO 88;   
               END;  
                 r_level := numeric_value;                   (* Make sure a comma follows the read-level *)              IF get_token <> comma THEN BEGIN                 nonfatal_error (dbds_comma_expected_err);                 semicolon_scan;                 GOTO 88;   
               END;  
                 (* Get the write-level *)               IF (get_token <> number_token) THEN BEGIN                  nonfatal_error (dbds_illegal_level_number_err);                 semicolon_scan;                 GOTO 88;   
               END;  
                 (* Make sure write-level is valid *)  !            IF NOT check_level_defined (numeric_value) THEN BEGIN  !                nonfatal_error (dbds_level_not_defined_err);                  semicolon_scan;                 GOTO 88;   
               END;  
                 w_level := numeric_value;                   IF (w_level < r_level) THEN BEGIN                  nonfatal_error (dbds_bad_write_level_err);                  semicolon_scan;                 GOTO 88;   
               END;  
                 IF get_token <> right_paren THEN BEGIN                 nonfatal_error (dbds_right_paren_expected_err);                 semicolon_scan;                 GOTO 88;   
               END;  
     !            kind_of_token := get_token; (* should be semicolon *)  !                 END; (* then process read-write levels clause *)               IF token_kind <> semicolon THEN BEGIN              nonfatal_error (dbds_semicolon_expected_err);               semicolon_scan;   
            GOTO 88; 
             END;      "         references := zero; (* set number of references to zero *)  "              (* The item clause was perfect if we get here!!! *)           numitems := numitems + one;               END; (* then *)           END; (* with *)      88: (* to skip to next item statement or SETS clause *)             UNTIL identifier.keyword = 'SETS';      "   (* We fall out here when we have an identifier (keyword) SETS *)  " "   (* Make sure a colon follows the keyword.                     *)  "     99: (* we come here if too many items were defined *)          IF get_token <> colon        THEN nonfatal_error (dbds_sets_expected_err);          (* Make sure at least one item was defined *)     IF numitems <= zero        THEN nonfatal_error (dbds_no_items_in_database_err);             (* We should now be looking at the keyword 'NAME' *)      (* Transfer control to the sets_clause module.    *)       END; (* items_clause *)   $ Page $  #(*******************************************************************)  # #(*                   initialize_set                                *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To initialize data for a particular set in the set table.    *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) The set table index.                               *)  # #(*                                                                 *)  # #(*******************************************************************)  #     $ Heapparms ON $  PROCEDURE initialize_set  $ Alias 'DBDS.InitSet'$      (setx : short_int);      VAR   	   i : short_int;  	     
BEGIN (* initialize_set *) 
        WITH set_table_ptr^[setx] DO BEGIN         descriptor := ' ';        set_kind   := auto_master; (* has numeric value 0 *)        media_length := zero;         data_length  := zero;         items_in_set := zero;         paths_in_set := zero;         paths_used   := zero;         high_write_level := zero;         low_read_level   := zero;         master_key_item  := zero;         master_key_offset:= zero;         capacity         := zero;             FOR i := one TO max_paths DO        WITH path_table[i] DO BEGIN            key_item    := zero;            key_offset  := zero;            rel_set     := zero;            sort_item   := zero;            sort_offset := zero;            END; (* for...with *)            FOR i := one TO max_items_per_dataset+one DO           item_order[i] := zero;             END; (* with *)       
END; (* initialize_set *)  
 $ Page $  #(*******************************************************************)  # #(*                 process_master_entry_list                       *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    Given a set table index and positioned just after the        *)  # #(*    ENTRY: keyword, to process the list of items for the         *)  # #(*    auto or manual master,  building the necessary path and      *)  # #(*    record definition tables for the set.                        *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) the set index.                                     *)  # #(*                                                                 *)  # #(*******************************************************************)  #     $ Heapparms ON $  !PROCEDURE process_master_entry_list  $ Alias 'DBDS.MasterItems' $  !    (setx : short_int);      LABEL 88; (* when CAPACITY found *)       VAR      fieldx : short_int;     i      : short_int;     item_num : short_int;     temp_token : tokens_type;      BEGIN (* process_master_entry_list *)          (**)      (* Syntax:      (*      (* <item-id> [ (<paths>) ] ;      (*      (* where <item-id> is an existing item name  !   (*       <paths> is the number of paths from the master (0-16)  !    (*      (* There must be one and only one item with a path count.  "   (* For an automatic master only the key item can be in the list.  "    (* For an automatic master, the path count cannot be zero.      (* Manual masters can have a zero path count.  "   (* Up to 127 item definitions can be in the list (manual master). "    (**)          fieldx := zero; (* number of fields in the set *)         WITH set_table_ptr^[setx] DO BEGIN         high_write_level := zero;         low_read_level   := entries_in_password_block;            media_length := master_dataset_media_header_len;                 REPEAT (* until a semicolon is found *)            get_identifier; (* <item-name> *)             WITH current_token, current_token.identifier DO BEGIN                IF fieldx = max_items_per_dataset THEN BEGIN               nonfatal_error (dbds_too_many_items_in_set_err);              semicolon_scan;   
            GOTO 88; 
             END;               IF keyword[chars_in_item_name+one] <> ' ' THEN BEGIN               nonfatal_error (dbds_illegal_identifier_err);               terminator_scan;  
            GOTO 88; 
             END;      !         (* Get the item number: make sure it is a defined item *) !          item_num := find_item (item_name);                IF item_num = zero THEN BEGIN              nonfatal_error (dbds_item_not_defined_err);               terminator_scan;  
            GOTO 88; 
             END;      !         (* See that the item is not defined twice in this set *)  !          FOR i := one TO fieldx DO              IF item_order[i] = item_num THEN BEGIN                 nonfatal_error (dbds_duplicate_item_err);                 terminator_scan;                  GOTO 88;   
               END;  
              (* Increment the reference count for the item *)            WITH item_table_ptr^[item_num] DO BEGIN              references := references + one;               data_length := data_length + item_length;               END;                   (* Look for optional path count (<paths>) *)                IF get_token = left_paren THEN BEGIN                   (* Make sure this item is not a compound item *)  !            IF item_table_ptr^[item_num].elements > one THEN BEGIN ! "               nonfatal_error (dbds_compound_item_cant_be_key_err);  "                terminator_scan;                  GOTO 88;   
               END;  
                 (* get the path count, 0-16 *)              IF get_token <> number_token THEN BEGIN                   nonfatal_error (dbds_non_numeric_path_count_err);                  terminator_scan;                  GOTO 88;   
               END;  
     "            IF (numeric_value < 0) OR (numeric_value > max_paths) OR " &               ((set_kind = auto_master) AND (numeric_value = 0)) THEN BEGIN &                nonfatal_error (dbds_invalid_path_count_err);                 terminator_scan;                  GOTO 88;   
               END;  
                 (* Make sure a key has not already been defined *)              IF master_key_item <> zero THEN BEGIN   "               nonfatal_error (dbds_path_item_already_defined_err);  "                terminator_scan;                  GOTO 88;   
               END;  
                 paths_in_set := numeric_value;                  media_length := media_length +  $                            (paths_in_set * master_path_info_entry_len); $                 (* Make sure a right parentheses follows *)               IF get_token <> right_paren THEN BEGIN                 nonfatal_error (dbds_right_paren_expected_err);                 terminator_scan;                  GOTO 88;   
               END;  
     #            (* Save this item number as the key item for the master *) #             master_key_item := item_num;                  (* Prefetch what should be a semicolon *)               temp_token := get_token;                  END; (* then process paths option *)      %         IF (token_kind <> semicolon) AND (token_kind <> comma) THEN BEGIN %             nonfatal_error (dbds_comma_expected_err);               terminator_scan;  
            GOTO 88; 
             END; (* then *)       "         (* We join processing here after verifying the semicolon.*) "     "         (* Add the item to the set's record definition table.    *) "          fieldx := fieldx + one;           item_order[fieldx] := item_num;               (* Update the read/write levels for the set *)            WITH item_table_ptr^[item_num] DO BEGIN              IF high_write_level < w_level                  THEN high_write_level := w_level;              IF low_read_level > r_level                  THEN low_read_level := r_level;              END; (* with *)                END; (* with current_token *)      88:   (* to skip to next item statement if an error occurs *)             UNTIL current_token.token_kind = semicolon;          (* Check that all master restrictions are satisfied *)          (* At least one item must be defined in the set. *)  
   IF fieldx = zero  
       THEN nonfatal_error (dbds_no_entries_defined_err);         (* One item must be defined as a key item *)      IF master_key_item = zero        THEN Nonfatal_error (dbds_no_key_defined_err);         (* An automatic master must only have the key item *)     IF (set_kind = auto_master) AND (fieldx > one)   !      THEN nonfatal_error (dbds_automaster_has_nonkey_items_err);  !        (* Save other item information in the set table. *)  
   items_in_set := fieldx; 
        END; (* with set_table_ptr *)      END; (* process_master_entry_list *)  $ Page $  #(*******************************************************************)  # #(*                     find_set                                    *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To return the data set number for the supplied set name.     *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) The data set name (not the file name)              *)  # #(*                                                                 *)  # #(* Function result:                                                *)  # #(*    0 if not found, otherwise the set table index (1-50).        *)  # #(*                                                                 *)  # #(*******************************************************************)  #     $ Heapparms ON $  FUNCTION find_set  $ Alias 'DBDS.FindSet' $      (set_name : set_name_type) : short_int;      VAR   	   i : short_int;  	     
BEGIN (* find_set *) 
        find_set := 0; (* assume does not exist *)          FOR i := one TO numsets DO         IF set_name = set_table_ptr^[i].set_id           THEN find_set := i;      
END; (* find_set *)  
 $ Page $  #(*******************************************************************)  # #(*                 process_detail_entry_list                       *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    Given a set table index and positioned just after the        *)  # #(*    ENTRY: keyword, to process the list of items for the         *)  # #(*    detail data set,        building the necessary path and      *)  # #(*    record definition tables for the set.                        *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) the set index.                                     *)  # #(*                                                                 *)  # #(*******************************************************************)  #     $ Heapparms ON $  !PROCEDURE process_detail_entry_list  $ Alias 'DBDS.DetailItems' $  !    (setx : short_int);      LABEL 88,99; (* when CAPACITY found *)      VAR      fieldx : short_int;     i,j    : short_int;         item_num : short_int;     set_num  : short_int;     sort_num : short_int;         temp_token : tokens_type;  
   next_path  : short_int; 
     BEGIN (* process_detail_entry_list *)          (**)      (* Syntax:      (*      (* <item-id> [ (<master> [ (<sort-item>) ] ) ]      (*      (* where <item-id> is an existing item name      (*       <master>  is the name of an existing master data set      (*       <sort-item> is an item name existing in the set.     (*   
   (* Restrictions:  
    (*    Up to 127 items in the data set.      (*    No more than 16 items designated as key items.      (*    Key and sort items cannot be compound items.   "   (*    The master's key item must be of the same type as <item-id> " %   (*    The related masters must be writable when the detail is writable  %    (*    Item statements are separated by commas.      (*    The last item statement is followed by a semicolon.     (**)          fieldx := zero; (* number of fields in the set *)         WITH set_table_ptr^[setx] DO BEGIN         high_write_level := zero;         low_read_level   := entries_in_password_block;        paths_in_set     := zero;             media_length := detail_dataset_media_header_len;                 REPEAT (* until semicolon found *)             item_num := zero;         set_num  := zero;         sort_num := zero;             get_identifier; (* <item-name> *)             WITH current_token, current_token.identifier DO BEGIN                IF fieldx = max_items_per_dataset THEN BEGIN               nonfatal_error (dbds_too_many_items_in_set_err);              semicolon_scan;   
            GOTO 88; 
             END;               IF keyword[chars_in_item_name+one] <> ' ' THEN BEGIN               nonfatal_error (dbds_illegal_identifier_err);               terminator_scan;  
            GOTO 88; 
             END;      !         (* Get the item number: make sure it is a defined item *) !          item_num := find_item (item_name);                IF item_num = zero THEN BEGIN              nonfatal_error (dbds_item_not_defined_err);               terminator_scan;  
            GOTO 88; 
             END;               (* Increment the item reference count *)            WITH item_table_ptr^[item_num] DO BEGIN              references := references + one;               data_length := data_length + item_length;               END;      !         (* See that the item is not defined twice in this set *)  !          FOR i := one TO fieldx DO              IF item_order[i] = item_num THEN BEGIN                 nonfatal_error (dbds_duplicate_item_err);                 terminator_scan;                  GOTO 88;   
               END;  
                  (* Look for optional master name (<master>) *)                IF get_token = left_paren THEN BEGIN                   (* Make sure we are not exceeding 16 paths *)               IF paths_in_set = max_paths THEN BEGIN                 nonfatal_error (dbds_too_many_paths_err);                 terminator_scan;                  GOTO 88;   
               END;  
                 (* Make sure this item is not a compound item *)  !            IF item_table_ptr^[item_num].elements > one THEN BEGIN ! "               nonfatal_error (dbds_compound_item_cant_be_key_err);  "                terminator_scan;                  GOTO 88;   
               END;  
                 (* get the master name *)               get_identifier;               set_num := find_set (set_name);                   IF set_num = zero THEN BEGIN                 nonfatal_error (dbds_set_not_defined_err);                  terminator_scan;                  GOTO 88;   
               END;  
                 (* Make sure the keys are of the same type *)   &            WITH item_table_ptr^[set_table_ptr^[set_num].master_key_item] DO & $               IF (item_kind <> item_table_ptr^[item_num].item_kind) OR  $ $                  (item_length <> item_table_ptr^[item_num].item_length) $ 
               THEN BEGIN  
                   nonfatal_error (dbds_incompatible_keys_err);                    terminator_scan;  
                  GOTO 88; 
                   END;                  (* Increment the media record length *)   #            media_length := media_length + detail_path_info_entry_len; #                     (* See if the optional sort item is specified. *)               IF get_token = left_paren THEN BEGIN                     (* get the sort item name *)                  get_identifier;      "               IF keyword[chars_in_item_name+one] <> ' ' THEN BEGIN  "                    nonfatal_error (dbds_illegal_identifier_err);                      terminator_scan;  
                  GOTO 88; 
                   END;                     sort_num := find_item (item_name);                      (* Make sure sort item exists *)                  IF sort_num = zero THEN BEGIN                    nonfatal_error (dbds_item_not_defined_err);                     terminator_scan;  
                  GOTO 88; 
                   END;                     (* Make sure the item is simple *)   #               IF item_table_ptr^[sort_num].elements > one THEN BEGIN  # &                  nonfatal_error (dbds_compound_item_cannot_be_sorted_err);  &                   terminator_scan;  
                  GOTO 88; 
                   END;      !               (* Make sure key and sort item are not the same *)  !                IF item_num = sort_num THEN BEGIN  $                  nonfatal_error (dbds_key_and_sort_items_the_same_err); $                   terminator_scan;  
                  GOTO 88; 
                   END;                     (* Make sure right paren follows sort item *)                 IF get_token <> right_paren THEN BEGIN   !                  nonfatal_error (dbds_right_paren_expected_err);  !                   terminator_scan;  
                  GOTO 88; 
                   END;                      (* Prefetch next token, should be right paren *)                   temp_token := get_token;                      END; (* then process optional sort-item *)                   IF token_kind <> right_paren THEN BEGIN                  nonfatal_error (dbds_right_paren_expected_err);                 terminator_scan;                  GOTO 88;   
               END;  
                 (* Prefetch what should be a semicolon *)               temp_token := get_token;                  END; (* then process key item option *)                    (* We join processing here. *)   !         (* Current token must be either a comma or a semicolon *) !     %         IF (token_kind <> comma) AND (token_kind <> semicolon) THEN BEGIN %             nonfatal_error (dbds_comma_expected_err);               terminator_scan;  
            GOTO 88; 
             END;      "         (* Add the item to the set's record definition table.    *) "          fieldx := fieldx + one;           item_order[fieldx] := item_num;      "         (* If the item is a key item, save the set and sort info *) "          IF set_num > zero THEN BEGIN               paths_in_set := paths_in_set + one;               WITH path_table[paths_in_set] DO BEGIN                 key_item := item_num;                 rel_set  := set_num;                  sort_item := sort_num;                  END; (* with *)                  (* Check for too many references to master *)   !            next_path := set_table_ptr^[set_num].paths_used + one; !     %            IF next_path > set_table_ptr^[set_num].paths_in_set THEN BEGIN % !               nonfatal_error (dbds_too_many_paths_to_master_err); !                GOTO 88;   
               END;  
                 (* Add the path info to the master's path table *)  $            WITH set_table_ptr^[set_num].path_table[next_path] DO BEGIN  $                key_item    := item_num;                  rel_set     := setx;                  sort_item   := sort_num;                  END; (* with *)                  set_table_ptr^[set_num].paths_used := next_path;                  END; (* then *)                (* Update the read/write levels for the set *)            WITH item_table_ptr^[item_num] DO BEGIN              IF high_write_level < w_level                  THEN high_write_level := w_level;              IF low_read_level > r_level                  THEN low_read_level := r_level;              END; (* with *)                END; (* with current_token *)      88:   (* to skip to next item statement if an error occurs *)             UNTIL current_token.token_kind = semicolon;          (* Check that all detail restrictions are satisfied *)          (* At least one item must be defined in the set. *)  
   IF fieldx = zero  
       THEN nonfatal_error (dbds_no_entries_defined_err);         (* All sort items must exist in the data set *)     FOR i := one TO paths_in_set DO BEGIN        sort_num := path_table[i].sort_item;            IF sort_num = zero           THEN GOTO 99 (* no sort item for this path *)      $         ELSE FOR j := one TO fieldx DO (* make sure sort item exists *) $             IF item_order[j] = sort_num THEN GOTO 99;             nonfatal_error_with_item (dbds_sort_item_not_in_set_err,  "                                item_table_ptr^[sort_num].item_id);  "     99:   (* skip around error message *)             END; (* for i *)      &   (* Make sure all related masters are writeable if detail is writeable *)  &    FOR i := one TO paths_in_set DO BEGIN        set_num := path_table[i].rel_set;   %      IF (high_write_level < set_table_ptr^[set_num].high_write_level) AND %          (set_table_ptr^[set_num].set_kind = auto_master)   #         THEN nonfatal_error_with_set (dbds_master_not_writeable_err,  # $                                       set_table_ptr^[set_num].set_id);  $ 
      END; (* for *) 
        (* Save other info in the set table *)   
   items_in_set := fieldx; 
        END; (* with set_table_ptr *)      END; (* process_detail_entry_list *)  $ Page $  #(*******************************************************************)  # #(*                       check_set_name                            *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To parse the data set file name and insure that there is     *)  # #(*    no conflict between the data set name and other data set     *)  # #(*    names, and that the data set name is not also the root name. *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) The file name of the data set.                     *)  # #(*    (in)  (2) The index of the current data set.                 *)  # #(*                                                                 *)  # #(* Function result is 'true' if an error occurs.                   *)  # #(*                                                                 *)  # #(*******************************************************************)  #     $ Heapparms ON $  FUNCTION check_set_name  $ Alias 'DBDS.CheckSet' $     (set_desc : new_file_name;       setx     : short_int) : Boolean;      LABEL 99;       VAR      new_comps : file_components_type;     components: file_components_type;  
   i         : short_int;  
     
BEGIN (* check_set_name *) 
        check_set_name := true;  (* Assume an error will occur *)         (**)      (* Break the set name up into its components.  "   (* Compare the path and file name components with all other file  " !   (* names (root and sets) and make sure there are no duplicates. !     (* While comparing set file names, make sure the new name is    "   (* 6 or fewer characters, and that no two set names are the same. "    (**)       !   (* Make sure the file NAME part is no more than 6 characters *) !    parse_descriptor (set_desc, new_comps);          IF new_comps.filename[chars_in_set_name+1] <> ' ' THEN BEGIN          nonfatal_error (dbds_set_name_too_long_err);        GOTO 99;        END;         (* Compare with root file descriptor *)     parse_descriptor (root_file.newfl, components);         WITH components DO         IF (directory = new_comps.directory) AND           (filename  = new_comps.filename) THEN BEGIN           nonfatal_error (dbds_file_already_used_err);   	         GOTO 99;  	          END;          (* Now compare with other set names *)      FOR i := one TO setx-1 DO BEGIN      !      parse_descriptor (set_table_ptr^[i].descriptor, components); !           WITH components DO        IF (filename = new_comps.filename) THEN BEGIN            nonfatal_error (dbds_duplicate_set_name_err);  	         GOTO 99;  	          END; (* then *)      
      END; (* for *) 
     #   (* Place the data set file and name information in the set table *) #    WITH set_table_ptr^[setx] DO BEGIN         descriptor := set_desc;         set_dest_short_srce (set_id, chars_in_set_name,   !                           new_comps.filename, chars_in_short_str, !                            str_assign, zero);         END;         check_set_name := false;       99:  (* error label *)      
END; (* check_set_name *)  
 $ Page $  #(*******************************************************************)  # #(*                       sets_clause                               *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To process the SETS: portion of the schema and build         *)  # #(*    the set-table information.                                   *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(* NOTE: The keyword SETS: should have already been retrieved      *)  # #(*       by the items_clause module.  The token NAME: should be    *)  # #(*       gotten as the first token.                                *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE sets_clause  $ Alias 'DBDS.Sets' $;       LABEL 99;       VAR      set_id  : set_name_type;      set_num : short_int;      item_id : item_name_type;     item_num: short_int;          setx    : short_int;      paths   : short_int;       $   error_for_set : boolean; (* if any error has happened for the set *)  $    end_found : boolean;           BEGIN (* sets_clause *)          (**)      (* We should be positioned just before NAME: keyword *)     (* Syntax for master data sets:     (*      (* NAME: <set-name>,<AUTOMATIC, A, MANUAL or M> ;  
   (* ENTRY: <master-list> 
    (* CAPACITY: <record-count> ;     (*      (*      (* Syntax for detail data sets:     (*      (* NAME: <set-name>, <DETAIL or D> ;   
   (* ENTRY: <detail-list> 
    (* CAPACITY: <record-count> ;     (*   !   (* where <set-name>     is the file descriptor of the data set, ! !   (*                      with a 6-character file name, maximum.  !    (*       <master-list>  is at least one of:     (*          <item-name> [(<path-count>)] ;   !   (*       <record-count> is a 32-bit positive number of records. !    (*       <detail-list>  is at least one of:     (*          <item-name> [(<master-name> [(sort-item)] )] ;      (*   
   (* Other restrictions:  
 !   (*    <path-count> in the master must be equal to the number of !    (*       detail sets referring to that master.      (*    Automatic masters can only have one item, a key item.     (*    Any master can have only one key item.      (*    A detail can have at most 16 key items.     (*    A compound item cannot be a key item nor a sort item.     (*    All items in the ITEMS: must be used at least once.     (*    An item cannot appear twice in the same data set.     (*    Maximum of 127 items in a data set.     (*    Maximum of 2048 words for media and data.     (*    Maximum of 50 data sets.      (*      (* The SETS: clause is terminated when an END. is found     (* instead of NAME:, but at least one set must exist.     (*      (**)          WITH current_token DO     REPEAT             setx := numsets + one;        error_for_set := false;             IF get_token <> alpha_token THEN BEGIN           nonfatal_error (dbds_name_expected_err);            scan_for_key ('NAME');            error_for_set := true;            END;             WITH identifier DO BEGIN  !         IF keyword = 'END' THEN GOTO 99; (* do END processing *)  !              IF keyword <> 'NAME' THEN BEGIN              nonfatal_error (dbds_name_expected_err);              scan_for_key ('NAME');              error_for_set := true;              END; (* then *)            END; (* with *)            (* Check for too many sets *)         IF setx > max_data_sets THEN BEGIN           nonfatal_error (dbds_too_many_sets_err);            scan_for_key ('END');  	         GOTO 99;  	          END;             IF get_token <> colon THEN BEGIN           nonfatal_error (dbds_name_expected_err);            error_for_set := true;            END;                 WITH set_table_ptr^[setx] DO BEGIN            (* Set default/initial values for the set *)        initialize_set(setx);             get_filename; (* get the data set's file name *)      $      (* Check for legality of the file name, and duplicate set name *)  $       IF check_set_name (file_value, setx) THEN BEGIN            semicolon_scan;           error_for_set := true;            END;             descriptor := file_value;             (* Check for comma *)         IF get_token <> comma THEN BEGIN           nonfatal_error (dbds_comma_expected_err);           semicolon_scan;           error_for_set := true;            END      $      (* Check for 'AUTOMATIC' , 'A', 'MANUAL', 'M', 'DETAIL' or 'D' *)  $       ELSE IF get_token <> alpha_token THEN BEGIN            nonfatal_error (dbds_bad_set_type_err);           semicolon_scan;           error_for_set := true;            END        ELSE WITH identifier DO BEGIN            IF (keyword = 'A') OR (keyword = 'AUTOMATIC')              THEN set_kind := auto_master           ELSE IF (keyword = 'D') OR (keyword = 'DETAIL')              THEN set_kind := detail            ELSE IF (keyword = 'M') OR (keyword = 'MANUAL')              THEN set_kind := man_master   
         ELSE BEGIN  
             nonfatal_error (dbds_bad_set_type_err);               error_for_set := true;  "            set_kind := detail; (* Assume set is a detail for fun *) "             END;               IF get_token <> semicolon THEN BEGIN               nonfatal_error (dbds_semicolon_expected_err);               error_for_set := true;              END; (* then no semicolon *)           END; (* else check the set type *)             (* At this point we should next get the ENTRY token *)            IF (get_token <> alpha_token) OR           (identifier.keyword <> 'ENTRY') THEN BEGIN            nonfatal_error (dbds_entry_expected_err);           error_for_set := true;            END; (* then ENTRY was not given *)            IF (get_token <> colon) THEN BEGIN           nonfatal_error (dbds_entry_expected_err);           error_for_set := true;            END; (* then a colon did not follow ENTRY *)           
      IF set_kind = detail 
          THEN process_detail_entry_list(setx)            ELSE process_master_entry_list(setx);            (**)        (* The entry processors will have stopped just prior to         (* the CAPACITY keyword.        (* Make sure it is followed by a colon.         (**)            IF (get_token <> alpha_token) OR           (identifier.keyword <> 'CAPACITY') THEN BEGIN           nonfatal_error (dbds_capacity_expected_err);            error_for_set := true;            END;             IF get_token <> colon THEN BEGIN           nonfatal_error (dbds_capacity_expected_err);            error_for_set := true;            END;             (**)  !      (* Make certain the colon is followed by number of records.  !       (**)      %      IF (get_token <> number_token) OR (numeric_value <= zero) THEN BEGIN %          nonfatal_error (dbds_bad_capacity_count_err);           error_for_set := true;            END (* then bad capacity count *)        ELSE capacity := numeric_value;       "      (* Make sure the capacity count is followed by a semicolon *)  "       IF get_token <> semicolon THEN BEGIN           nonfatal_error (dbds_semicolon_expected_err);           error_for_set := true;            END;              (* Make sure at least one item was defined for the set *)          IF items_in_set <= zero THEN BEGIN  "         nonfatal_error_with_set (dbds_no_items_in_set_err, set_id); "          error_for_set := true;            END;             (* Make sure that a master has a key item defined *)  #      IF (set_kind <> detail) AND (master_key_item <= zero) THEN BEGIN # "         nonfatal_error_with_set (dbds_no_key_defined_err, set_id);  "          error_for_set := true;            END;       #      (* Make sure the media and data combined does not exceed max *)  # $      IF (media_length + data_length) > max_data_in_a_record THEN BEGIN  $ !         nonfatal_error_with_set (dbds_entry_too_big_err, set_id); !          error_for_set := true;            END;       
      IF NOT error_for_set 
          THEN numsets := numsets + one; (* no error! *)       $      IF (data_length > largest_data) THEN largest_data := data_length;  $           END; (* with set_table_ptr^[setx] *)      99: (* when END is found *)          UNTIL identifier.keyword = 'END';             (* Make sure a period follows the END statement *)   
   IF get_token <> period  
       THEN nonfatal_error (dbds_end_expected_err);      END; (* sets_clause *)  .  