$PASCAL ',7 92081-1X657 REV.5000' $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18657                                        *)   (* RELOC:   92081-1X657                                        *)   (*                                                             *)   (* PGMR:        <MRL>                                          *)   (*                                                             *)   (*          NLS localized by TH                                *)   (*                                                             *)   (* Date last modified: <870423.1155>  (*                                                             *)   (* Bug fix, July 1986: If NOLIST was specified, FIELD and      *)   (*    TABLE options were ignored (no listing done).  FIELD     *)   (*    and TABLE should always be printed if specified. <MRL>   *)   (*                                                             *)   (***************************************************************)       (**) (*:nl:$  &(*:nl:$ATB mdbds_subc %db000 relocatable, 92081-16069 REV.2540 <870423.1155> &(*:nl:$ (*:nl:$COUNTER 1 1000 1  (**)     $ List ON $  $ Heap 2 $  $ Range ON $ $ Recursive OFF $ $ Heapparms OFF $  $ Subprogram $      PROGRAM dbds_subs_for_segment_three;     "(*******************************************************************) ""(*                      global constants and types                 *) ""(*******************************************************************) "    $ List OFF, Include '[IMAGE', List ON $ $ List OFF, Include '[DBDS ', List ON $      $ Page $     "(*******************************************************************) ""(*                   External definitions                          *) ""(*******************************************************************) "    $ List OFF, Include '[XDBDS', List ON $ $ Heapparms OFF $ $ List OFF, Include '[XDTDY', List ON $ $ List OFF, Include '[XDFMP', List ON $ $ List OFF, Include '[XUSHF', List ON $ $ List OFF, Include '[XDSMR', List ON $     $ Heapparms OFF $      FUNCTION operating_system   $ Alias 'IMG.OPSY' $     : os_kinds;     EXTERNAL;      %(* Fmp wants positive blocks or negative 128-block chunks for file size *) %    FUNCTION fmp_pack_size  $ Alias 'FmpPackSize' $     (long_int_size : long_int) : short_int; (* packed size *)     EXTERNAL;      PROCEDURE get_file_size   $ Alias 'SIZE' $     (    capacity : long_int;         rec_size : short_int;     VAR status   : short_int;     VAR blocks   : long_int);     EXTERNAL;     (* The external declarations for NLS below *)      (*:nl:$COPY 'PROCEDURE &; EXTERNAL;'*) PROCEDURE MDBDS_SUBC; EXTERNAL;      FUNCTION  nlread $ Alias 'NLREADREL' $  
   (PROCEDURE ext_module ; 
        msgnum   : short_int;         nlerror  : short_int;      VAR nlsbuff_string : long_str;          nllength : short_int) : short_int;     EXTERNAL;      FUNCTION  nlread_s $ Alias 'NLREADREL' $  
   (PROCEDURE ext_module ; 
        msgnum   : short_int;         nlerror  : short_int;     VAR short_string : short_str;          nllength : short_int) : short_int;     EXTERNAL; FUNCTION  nlread_p1 $ Alias 'NLREADREL' $  
   (PROCEDURE ext_module ; 
        msgnum   : short_int;         nlerror  : short_int;      VAR nlsbuff_string : long_str;         nllength : short_int;      VAR parameter: short_str) : short_int;     EXTERNAL;         FUNCTION  nlread_p2 $ Alias 'NLREADREL' $  
   (PROCEDURE ext_module ; 
        msgnum   : short_int;         nlerror  : short_int;      VAR nlsbuff_string : long_str;         nllength : short_int;     VAR parameter: short_str;     VAR parameter1: short_str) : short_int;     EXTERNAL;     PROCEDURE null_pad   $ Alias 'DBDS.NlsTerm' $    (VAR buff     : short_str;          len      : short_int);     EXTERNAL;     $ Heapparms ON $ (* must be on *)  PROCEDURE dbds_write_header  $ Alias 'DBDS.AddEntry' $    (VAR root_header : rootfile_header_type;         length      : short_int);     EXTERNAL;         PROCEDURE dbds_write_item_entry $ Alias 'DBDS.AddEntry' $    (VAR item_entry  : global_item_table_entry_type;         length      : short_int);     EXTERNAL;         PROCEDURE dbds_write_bmset_entry  $ Alias 'DBDS.AddEntry' $     (VAR set_entry   : global_dataset_ctl_table_type;         length      : short_int);     EXTERNAL;          PROCEDURE dbds_write_bmdetail_path $ Alias 'DBDS.AddEntry' $     (VAR bmdpath     : global_dd_path_entry_type;         length      : short_int);     EXTERNAL;         PROCEDURE dbds_write_bmmaster_path  $ Alias 'DBDS.AddEntry' $     (VAR bmmpath     : global_md_path_entry_type;         length      : short_int);     EXTERNAL;          PROCEDURE dbds_write_bmkey_info  $ Alias 'DBDS.AddEntry' $     (VAR bmkey       : global_md_info_type;         length      : short_int);     EXTERNAL;         PROCEDURE dbds_write_frt_entry  $ Alias 'DBDS.AddEntry' $     (VAR frt_entry   : global_frt_entry_type;         length      : short_int);     EXTERNAL;          PROCEDURE dbds_write_local_header  $ Alias 'DBDS.AddEntry' $     (VAR localh      : local_run_table_header_type;         length      : short_int);     EXTERNAL;           PROCEDURE dbds_write_local_item_entry  $ Alias 'DBDS.AddEntry' $      (VAR item_entry  : local_item_table_entry_type;         length      : short_int);     EXTERNAL;         PROCEDURE dbds_write_local_set_entry  $ Alias 'DBDS.AddEntry' $    (VAR set_entry   : local_dataset_ctl_table_type;         length      : short_int);     EXTERNAL;          PROCEDURE dbds_write_set_sort_table  $ Alias 'DBDS.AddEntry' $     (VAR sstable     : set_sort_table_type;         length      : short_int);     EXTERNAL;         PROCEDURE dbds_write_item_sort_table  $ Alias 'DBDS.AddEntry' $    (VAR istable     : item_sort_table_type;         length      : short_int);     EXTERNAL;          PROCEDURE dbds_write_record_def  $ Alias 'DBDS.AddEntry' $     (VAR record_def  : item_order_type;         length      : short_int);     EXTERNAL;         PROCEDURE dbds_write_path_info  $ Alias 'DBDS.AddEntry' $    (VAR path_info   : local_dd_path_entry_type;         length      : short_int);     EXTERNAL;         PROCEDURE dbds_write_passwords  $ Alias 'DBDS.AddEntry' $     (VAR passwords   : passwords_disc_block_type;         length      : short_int);     EXTERNAL;         $ Heapparms OFF $  PROCEDURE post_runtable_buffer  $ Alias 'DBDS.PostBuffer' $;     EXTERNAL;      $ Page $ "(*******************************************************************) ""(*                       find_offset                               *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*                                                                 *) ""(*    Given a data set number and item number, to return the       *) ""(*    word offset (relative to the start of the record) where      *) ""(*    the item exists.                                             *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The data set number.                               *) ""(*    (in)  (2) The item number in the set.                        *) ""(*                                                                 *) ""(* Function result:                                                *) ""(*    Zero if the item is illegal or doesn't exist.                *) ""(*    Positive offset if the item exists in the data set.          *) ""(*                                                                 *) ""(*******************************************************************) "     $ Heapparms ON $ FUNCTION find_offset  $ Alias 'DBDS.FindOffset' $     (set_number  : short_int;     item_number : short_int) : short_int;     VAR     offset : short_int;     index  : short_int;     inum   : short_int;         BEGIN (* find_offset *)        WITH set_table_ptr^[set_number] DO BEGIN            offset := media_length; (* items follow the media *)       index  := one;          (* index into item order table *)            REPEAT (* until desired item is found *)              inum := item_order[index];               IF inum <> item_number THEN BEGIN              offset := offset + item_table_ptr^[inum].item_length;              index := index + one;              END;               UNTIL (inum = item_number) OR (index > items_in_set);     
      IF inum = item_number 
         THEN find_offset := offset           ELSE find_offset := zero;     
      END; (* with *) 
     END; (* find_offset *)  $ Page $ "(*******************************************************************) ""(*                       check_semantics                           *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    After the END. keyword has been encountered, the first pass  *) ""(*    of schema processing is complete.  Now we need to insure     *) ""(*    that the following conditions have been met:                 *) ""(*                                                                 *) ""(*    (1) All items must be used at least once.                    *) ""(*    (2) Every master path must be defined in a detail.           *) ""(*                                                                 *) ""(*******************************************************************) "     PROCEDURE check_semantics  $ Alias 'DBDS.Semantics' $;     VAR    i,j,k     : short_int;    header_out: boolean;    display_string : long_str;     status         : short_int;     error_message  : short_str;         koffset        : short_int;     soffset        : short_int;     inum           : short_int;     
BEGIN (* check_semantics *) 
       (**)     (* Check that every item has been referenced at least once.    (**)          header_out := false; (* if 'unreferenced items' is printed *)      error_message := 'undefined items';         FOR i := one TO numitems DO    WITH item_table_ptr^[i] DO        IF references <= zero THEN BEGIN  
         IF NOT header_out 
             THEN nonfatal_error (dbds_unreferenced_items_err);          display_string := item_id;           IF write_long_str (list_file, display_string, status)             THEN fatal_error (list_file, status);           header_out := true;           END; (* then *)            (* Check that all paths have been defined *)        FOR i := one TO numsets DO     WITH set_table_ptr^[i] DO        (* Look at all master data sets *) 
      IF set_kind <> detail 
         THEN IF paths_used <> paths_in_set  &            THEN nonfatal_error_with_set (dbds_undefined_paths_err, set_id); &           (* Calculate the offsets to the key and sort items: *)    (* For master data sets, the hashed key item.       *)    (* For details, all key and sort items.             *)        FOR i := one TO numsets DO     WITH set_table_ptr^[i] DO     IF set_kind = detail THEN       FOR j := one TO paths_in_set DO       WITH path_table[j] DO BEGIN               koffset := find_offset (i, key_item);          key_offset := koffset;              soffset := zero;              IF sort_item > zero THEN BEGIN              soffset := find_offset (i, sort_item);             sort_offset := soffset; 
            END; (* then *) 
              (* Set the related path info in the master *)            FOR k := one TO set_table_ptr^[rel_set].paths_in_set DO           IF (set_table_ptr^[rel_set].path_table[k].key_item  !                                                   = key_item) AND !             (set_table_ptr^[rel_set].path_table[k].rel_set  !                                                   = i) THEN BEGIN ! $            set_table_ptr^[rel_set].path_table[k].key_offset := koffset; $$            set_table_ptr^[rel_set].path_table[k].sort_offset := soffset; $
            END; (* then *) 
             END  (* then...for...with *)        ELSE BEGIN (* determine the master's key offset *)            master_key_offset := find_offset (i, master_key_item);            END;      
END; (* check_semantics *) 
 $ Page $ "(*******************************************************************) ""(*                    dbds_table_report                            *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To generate the TABLE information for the DBDS summary.      *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "     PROCEDURE dbds_table_report  $ Alias 'DBDS.TableReport' $;     CONST    (* TABLE column positions *)    set_name_pos    = 2;     set_type_pos    = 12;     numitems_pos    = 18;     num_paths_pos   = 25;     data_words_pos  = 32;     media_words_pos = 38;     capacity_pos    = 45;     size_pos        = 57;        len             = chars_in_long_str;     VAR    display_string : long_str;     number_string  : short_str;     status         : short_int;     i,j,k          : short_int;        set_file_size  : long_int;     header_displayed : boolean;     data_offset    : short_int;     inum           : short_int;         nlerr          : short_int;     length         : short_int;             BEGIN (* dbds_table_report *)        (* Display TABLE information if desired *)         IF (dbds_options.table) AND (error_count = zero) THEN BEGIN           display_string := '1'; (* do a top-of-form *)           IF write_long_str (list_file, display_string, status)           THEN nonfatal_error (dbds_list_file_err);            (* Write out the TABLE header *)  %(*    display_string :=                                             *nls*) % %(* ' Set-name  Type  Items  Paths  Data  Media  Capacity    Blocks';*nls*) % (*:nl:$ ' ' *)  (*:nl:$ 'The column positions below could not be changed.' '(*:nl:#*1 1000 ' Set-name  Type  Items  Paths  Data  Media  Capacity    Blocks' ' *)  %(*:nl:$COPY '     length := nlread (&, #, nlerr, display_string, len);' *) %$     length := nlread (MDBDS_SUBC, 1000, nlerr, display_string, len);     $         display_string[length+1] := ' ';     (*NLS*)           IF write_long_str (list_file, display_string, status)           THEN nonfatal_error (dbds_list_file_err);                (* For each data set, display the information *)            FOR i := one TO numsets DO       WITH set_table_ptr^[i] DO BEGIN               display_string := ' '; (* blank the string *)              (* Set name in column 3 *)          long_dest_set_srce (display_string, chars_in_long_str,                              set_id, chars_in_set_name,                               str_overlay, set_name_pos);                  (* Set type character *)           IF set_kind = auto_master              THEN display_string[set_type_pos] := 'A'           ELSE IF set_kind = detail              THEN display_string[set_type_pos] := 'D'             ELSE display_string[set_type_pos] := 'M';                   (* # of items in set *) #         short_int_to_readable_short_str (items_in_set, number_string); #              long_dest_short_srce (display_string, chars_in_long_str,                                  number_string, chars_in_short_str,                                  str_overlay, numitems_pos);                   (* # of paths in set *) #         short_int_to_readable_short_str (paths_in_set, number_string); #              long_dest_short_srce (display_string, chars_in_long_str,                                  number_string, chars_in_short_str,                                 str_overlay, num_paths_pos);                  (* word length of data in set *)  #         short_int_to_readable_short_str (data_length, number_string); #              long_dest_short_srce (display_string, chars_in_long_str,                                  number_string, chars_in_short_str,                                  str_overlay, data_words_pos);                   (* word length of media in set *) #         short_int_to_readable_short_str (media_length, number_string); #              long_dest_short_srce (display_string, chars_in_long_str,                                  number_string, chars_in_short_str,                                 str_overlay, media_words_pos);                   (* Capacity of set *)  !         long_int_to_readable_short_str (capacity, number_string); !              long_dest_short_srce (display_string, chars_in_long_str,                                  number_string, chars_in_short_str,                                  str_overlay, capacity_pos);              (* Block size of the file *)          get_file_size (capacity, (media_length+data_length),                         status, set_file_size);           IF (status <> zero)  !            THEN nonfatal_error_with_set (dbds_file_too_large_err, !                                           set_id);     #         long_int_to_readable_short_str (set_file_size, number_string); #          long_dest_short_srce (display_string, chars_in_long_str,                                  number_string, chars_in_short_str,                                  str_overlay, size_pos);               IF write_long_str (list_file, display_string, status)             THEN nonfatal_error (dbds_list_file_err);               END; (* for...with *)           END; (* then display table information *)      END; (* dbds_table_report *)  $ Page $ "(*******************************************************************) ""(*                       dbds_field_report                         *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To generate the FIELD information for the DBDS summary.      *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "     PROCEDURE dbds_field_report  $ Alias 'DBDS.FieldReport' $;     CONST        (* FIELD column positions *)    set_nam_pos     = 2;     set_num_pos     = 12;     item_name_pos   = 19;     item_num_pos    = 30;     item_type_pos   = 38;     start_word_pos  = 44;     length_pos      = 55;     path_pos        = 63;     sort_pos        = 70;        len             = chars_in_long_str;     VAR    display_string : long_str;     number_string  : short_str;     status         : short_int;     i,j,k          : short_int;         header_displayed : boolean;     data_offset    : short_int;     inum           : short_int;         length         : short_int;     nlerr          : short_int;     yes_str        : short_str;     BEGIN (* dbds_field_report *)            (* Display the FIELD information if requested *)        IF (dbds_options.field) AND (error_count = 0) THEN BEGIN            (**)       (* FIELD information is the data set record layout:        (*    Item name, number.        (*    Word offset of the item, and its length.       (*    Whether the item is a key or sort item.        (**)           display_string := '1'; (* Do a top-of-page *)           IF write_long_str (list_file, display_string, status)           THEN nonfatal_error (dbds_list_file_err);      (**) (*    display_string :=  '(*' Set name  Set#   Item name  Item#   Type  Start wd.  Length  Path?  Sort?' '(*nls*)  (*:nl:$ ' ' *)  (*:nl:$ 'The column positions below could not be changed.'  '(*:nl:#*1 1001 ' Set name  Set#   Item name  Item#   Type  Start wd.  Length&' ' (*:nl:#        '  Path?  Sort?' *)     %(*:nl:$COPY '      length := nlread (&, #, nlerr, display_string, len);' *) % %      length := nlread (MDBDS_SUBC, 1001, nlerr, display_string, len);     %           display_string[length+1] := ' ';     (*NLS*)           IF write_long_str (list_file, display_string, status)           THEN nonfatal_error (dbds_list_file_err);           (* Display FIELD info for each set *)        FOR i := one TO numsets DO       WITH set_table_ptr^[i] DO BEGIN     #         data_offset := zero; (* for displaying start word in record *) #             display_string := ' ';               (* Space between individual sets *)           IF write_long_str (list_file, display_string, status)             THEN nonfatal_error (dbds_list_file_err);               (* Set name and number displayed only once *)          header_displayed := false;               FOR j := one TO items_in_set DO          WITH item_table_ptr^[item_order[j]] DO BEGIN              display_string := ' ';                  IF NOT header_displayed THEN BEGIN                 header_displayed := true; "               long_dest_set_srce (display_string, chars_in_long_str, "                                   set_id, chars_in_set_name,                                    str_overlay, set_nam_pos);      !               short_int_to_readable_short_str (i, number_string); !    #               long_dest_short_srce (display_string, chars_in_long_str, ##                                     number_string, chars_in_short_str, #                                     str_overlay, set_num_pos); !               END; (* then display the set name and number info *) !                    (* Display the item name *) !            long_dest_item_srce (display_string, chars_in_long_str, !                                 item_id, chars_in_item_name,                                  str_overlay, item_name_pos);                 (* Display the item number *)              inum := item_order[j];  !            short_int_to_readable_short_str (inum, number_string); !     "            long_dest_short_srce (display_string, chars_in_long_str, " "                                  number_string, chars_in_short_str, "                                  str_overlay, item_num_pos);                 (* Display the item type *)             display_string[item_type_pos] := item_kind;                 (* Display the start word; start = data offset+1 *) $            (* Note: do not include the media record for this display! *) $$            (* It is for the user so he knows where data is relative to*) $$            (* the data returned by DBGET.                             *) $    %            short_int_to_readable_short_str (data_offset+1, number_string); %     "            long_dest_short_srce (display_string, chars_in_long_str, " "                                  number_string, chars_in_short_str, "                                  str_overlay, start_word_pos);                 (* Increment the data offset *)             data_offset := data_offset + item_length;                 (* Display the item length *) $            short_int_to_readable_short_str (item_length, number_string); $     "            long_dest_short_srce (display_string, chars_in_long_str, " "                                  number_string, chars_in_short_str, "                                  str_overlay, length_pos);                  (* Display 'YES' if item is a key/path item *) 
            yes_str := ' '; 
                 (*:nl:$ ' '                                   *)              (*:nl:$ 'This message must be within 4 bytes' *)              (*:nl:#*1 1002 'YES'                          *) $            (*:nl:$COPY '            length := nlread_s (&, #, nlerr,' *) $             length := nlread_s (MDBDS_SUBC, 1002, nlerr,                           yes_str, chars_in_short_str);                 yes_str[length+1] := ' ';                  IF set_kind = detail                THEN FOR k := one TO paths_in_set DO                    IF path_table[k].key_item = inum                      THEN long_dest_short_srce (display_string,  !                                                chars_in_long_str, ! &                                                yes_str, chars_in_short_str, & #                                                str_overlay, path_pos) #                      ELSE (* do nothing *)                ELSE IF master_key_item = inum                    THEN long_dest_short_srce (display_string,                                              chars_in_long_str, $                                             yes_str, chars_in_short_str, $ "                                             str_overlay, path_pos); "                 (* Display 'YES' if item is a sort item *) "            IF set_kind = detail THEN FOR k := one TO paths_in_set DO "                IF path_table[k].sort_item = inum                    THEN long_dest_short_srce (display_string,                                              chars_in_long_str, $                                             yes_str, chars_in_short_str, $ "                                             str_overlay, sort_pos); "                 (* Write the line to the list *)              IF write_long_str (list_file, display_string, status)                  THEN nonfatal_error (dbds_list_file_err);                 END; (* for each item in the set *)               END; (* for each set *)           END; (* then display the field information *)      END; (* dbds_field_report *)  $ Page $ "(*******************************************************************) ""(*                          summary_report                         *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To generate the final DBDS summary reports about the schema  *) ""(*    and the creation of the database.                            *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "    PROCEDURE summary_report  $ Alias 'DBDS.Summary' $;      
BEGIN (* summary_report *) 
    
   dbds_table_report; 
    
   dbds_field_report; 
    END; (* summary_report *)  $ Page $ "(*******************************************************************) ""(*                        build_global_run_table                   *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To build the run table used by DBMON:                        *) ""(*       A) The root file header.                                  *) ""(*       B) Item table.                                            *) ""(*       C) Data set table.                                        *) ""(*       D) Data set info table.                                   *) ""(*       E) Free record table.                                     *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) Number of blocks in the global run table.          *) ""(*    (in)  (2) Number of blocks in the local run table.           *) ""(*    (in)  (3) Starting block of the free record table.           *) ""(*    (in)  (4) Security code of the root file.                    *) ""(*                                                                 *) ""(*******************************************************************) "     $ Heapparms ON $  PROCEDURE build_global_run_table  $ Alias 'DBDS.BuildGlobal' $  "   (global_blocks, local_size, free_rec_block, root_sc : short_int); "    VAR     root_header : rootfile_header_type;     item_entry  : global_item_table_entry_type;    set_entry   : global_dataset_ctl_table_type; 
   next_offset : short_int; 
       master_path : global_md_path_entry_type;    master_keyi : global_md_info_type;        detail_path : global_dd_path_entry_type;    free_entry  : global_frt_entry_type; 
   i,j,k       : short_int; 
 
   setsize     : long_int; 
    set_comps   : file_components_type; 
   status      : short_int; 
       temp_descriptor : file_descriptor;          BEGIN (* build_global_run_table *)        (**)     (* Fill in the root header information first.    (**)         WITH root_header DO BEGIN            (* Initialize the entire buffer *)       FOR i := zero TO words_in_disc_block-one DO           unused2[i] := zero;           revision := current_rootfile_version_num;       reserved := reserved_rootfile_word;       get_timestamp (creation);       get_timestamp (backup);            vol_num  := one; (* in case RFL is on *)       vol_xct  := zero;        vol_nam  := ' ';       logical_rlf_set_nam := ' ';            dbase_name := root_file.newfl;           WITH flags DO BEGIN          cs := dbds_options.checksum; 
         mb := false; 

         mw := false; 

         ha := false; 

         ft := false; 

         bu := false; 
         logging := dbds_options.logging;           access  := dbds_options.access;          END;      !      bm_rt_block := one; (* starting block of global run table *) !       bm_rt_len   := global_blocks; (* size in blocks *)           sets    := numsets;        set_off := root_header_len + (numitems*bm_item_len);      
      items   := numitems; 
      it_off  := root_header_len;            free_tbl_off := (free_rec_block-one) * words_in_disc_block;         free_tbl_len := numsets * bm_free_rec_len;       free_tbl_block := free_rec_block;           lc_rt_block := global_blocks + one;        lc_rt_len   := local_size;            passw_block := global_blocks +                       ((local_size+words_in_disc_block-one) DIV                       words_in_disc_block) + one;       passw_len   := one; (* one block *)            largest_rec := largest_data;       END; (* with root_header *)         dbds_write_header (root_header, root_header_len);            (* Build the DBMON item table *)         FOR i := one TO numitems DO    WITH item_entry, item_table_ptr^[i] DO BEGIN       ite.item_type := item_kind;        ite.elem_ct   := elements;       item_len  := item_length;            dbds_write_item_entry (item_entry, bm_item_len);       END; (* for with *)            (* Build the DBMON data set table *)         next_offset := root_header_len + (numsets * bm_set_len) +                   (numitems * bm_item_len);        FOR i := one TO numsets DO    WITH set_entry, set_table_ptr^[i] DO BEGIN            (**)         (* We need to place the data set file characteristics into   !      (* the set descriptor for the file type, size, security code !
      (* and record length. 
       (**)           parse_descriptor (descriptor, set_comps);           WITH set_comps DO BEGIN          security := root_sc;           filetype := 2; (* random access, fixed length records *)            recordlen:= media_length + data_length;               get_file_size (capacity, recordlen, status, setsize);     $         IF (status <> no_image_err) OR (setsize >= 32768*128) THEN BEGIN $             temp_descriptor.newfl := descriptor;              fatal_error (temp_descriptor, cartridge_full_err);              END;     "         (* Have FMP convert double-integer blocks into 16-bit int *) "         filesize := fmp_pack_size (setsize);          END; (* with components *)           build_descriptor (set_comps, descriptor);           (* In this case, appends a working directory as needed *)       build_root_name (descriptor);           set_name := descriptor;           WITH gdt DO BEGIN  
         unused   := zero; 
          set_type := set_kind;          media_len := media_length;          set_items := items_in_set;          set_paths := paths_in_set;           END; (* with *)           data_len  := data_length;       info_off  := next_offset;        IF gdt.set_type = detail "         THEN next_offset := next_offset + (paths_in_set*bm_detl_len) "          ELSE next_offset := next_offset + bm_mstr_key_len +                              (paths_in_set * bm_mstr_path_len);     
      hash_val := capacity; 
 
      file_size:= setsize; 
          dbds_write_bmset_entry (set_entry, bm_set_len); 
      END; (* for...with *) 
           (**)    (* Now construct the path information for the data sets *)    (**)        FOR i := one TO numsets DO     WITH set_table_ptr^[i] DO BEGIN       FOR j := one TO paths_in_set DO       WITH path_table[j] DO BEGIN               IF set_kind = detail THEN WITH detail_path DO BEGIN              gdt.related_key := key_item;             gdt.related_set := rel_set;              key_begin   := key_offset;             sort_num    := sort_item;             sort_begin  := sort_offset;                   dbds_write_bmdetail_path (detail_path, bm_detl_len);               END (* if-then with *)              ELSE WITH master_path DO BEGIN              related_key := key_item;             related_set := rel_set;     "            dbds_write_bmmaster_path (master_path, bm_mstr_path_len); "             END;               END; (* for each path with *)            IF set_kind <> detail THEN WITH master_keyi DO BEGIN          master_key := master_key_item;          key_start  := master_key_offset;               dbds_write_bmkey_info (master_keyi, bm_mstr_key_len);           END; (* if-then with *)            END; (* for each set with *)        (**)    (* Force the free record table to begin on a block boundary.    (**)         post_runtable_buffer;             (* Write out the free record table *)        FOR i := one TO numsets DO     WITH set_table_ptr^[i], free_entry DO BEGIN           count := capacity; (* All records are free *) !      chain := one;      (* free record chain begins at record 1 *) !       leof  := zero;     (* Logical eof is record 1 *)  !      setcp := capacity; (* Current capacity is same as defined *) !          dbds_write_frt_entry (free_entry, bm_free_rec_len);       END; (* for with *)             (* Start the local run table on a block boundary *)     post_runtable_buffer;     END; (* build_global_run_table *)  $ Page $ "(*******************************************************************) ""(*                     make_set_sort_table                         *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To construct the data set sort table, which is an array      *) ""(*    of set numbers in alphabetical order by set name.            *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (out) (1) The set sort table.                                *) ""(*                                                                 *) ""(*******************************************************************) "     $ Heapparms ON $ PROCEDURE make_set_sort_table  $ Alias 'DBDS.MakeSSort' $     (VAR ss_table : set_sort_table_type);     VAR  
   i, j, temp : short_int; 
    BEGIN (* make_set_sort_table *)        (**)     (* Just be brute force about it: Use a swap-sort.    (**)        (* Initialize the set sort table. *)    FOR i := one TO numsets DO       ss_table[i] := i;         (* Begin the swap sort *)        FOR i := one TO numsets-one DO BEGIN     	      j := i + one; 	          WHILE j <= numsets DO BEGIN           IF set_table_ptr^[ss_table[i]].set_id >                 set_table_ptr^[ss_table[j]].set_id THEN BEGIN             (* Swap the elements *)              temp := ss_table[i];             ss_table[i] := ss_table[j];              ss_table[j] := temp;             END; (* then swap the elements *)               j := j + one;          END; (* while *)      
      END; (* for *) 
        (* The set sort table is constructed *)      END; (* make_set_sort_table *)  $ Page $ "(*******************************************************************) ""(*                     make_item_sort_table                        *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To construct the data item sort table, which is an array     *) ""(*    of item numbers in alphabetical order by item name.          *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (out) (1) The item sort table.                               *) ""(*                                                                 *) ""(*******************************************************************) "     $ Heapparms ON $  PROCEDURE make_item_sort_table  $ Alias 'DBDS.MakeISort' $    (VAR is_table : item_sort_table_type);     VAR  
   i, j, temp : short_int; 
     BEGIN (* make_item_sort_table *)        (**)     (* Just be brute force about it: Use a swap-sort.    (**)         (* Initialize the item sort table. *)     FOR i := one TO numitems DO       is_table[i] := i;         (* Begin the swap sort *)         FOR i := one TO numitems-one DO BEGIN     	      j := i + one; 	           WHILE j <= numitems DO BEGIN           IF item_table_ptr^[is_table[i]].item_id >                 item_table_ptr^[is_table[j]].item_id THEN BEGIN             (* Swap the elements *)              temp := is_table[i];             is_table[i] := is_table[j];              is_table[j] := temp;             END; (* then swap the elements *)               j := j + one;          END; (* while *)      
      END; (* for *) 
       (* The item sort table is constructed *)     END; (* make_item_sort_table *)  $ Page $ "(*******************************************************************) ""(*                   build_local_run_table                         *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To create the local (user) run table portion of the          *) ""(*    database root file.                                          *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The total size of the local run table in words.    *) ""(*    (in)  (2) The offset of the set sort table.                  *) ""(*                                                                 *) ""(*******************************************************************) "     $ Heapparms ON $  PROCEDURE build_local_run_table  $ Alias 'DBDS.BuildLocal' $ 
   (local_size : short_int; 
     sort_offset: short_int);     VAR     local_header : local_run_table_header_type;     item_entry   : local_item_table_entry_type;    set_entry    : local_dataset_ctl_table_type;    path_entry   : local_dd_path_entry_type;     rec_def      : ds_inf_table_type;         i,j,k        : short_int;         set_sort     : set_sort_table_type;    item_sort    : item_sort_table_type;     next_offset  : short_int;         BEGIN (* build_local_run_table *)        (**)     (* The local run table consists of:    (*    A) The local run table header.    (*    B) The local item table.    (*    C) The local data set control table.    (*    D) The data set information table.     (*    E) The item and set sort table.    (**)        WITH local_header DO BEGIN        (* Set run-time variables to zero *)       transaction_id := zero;       multi_db_count := zero;       sys_dbnum      := zero;       db_node        := zero;       db_num         := zero;            WITH indicators DO BEGIN           remote      := false;          posting     := true;           statistics  := false;          unused      := zero;          END;            open_mode := zero;        rtbl_len  := local_size; 
      set_count := numsets; 
       set_off   := local_headr_len + (numitems*itmtbl_entry_len);             itm_count := numitems;       itm_off   := local_headr_len;           setsort   := sort_offset; !      itmsort   := sort_offset + ((numsets+one) DIV chars_in_word); !       END; (* with local header *)        dbds_write_local_header (local_header, local_headr_len);            (* Construct the local item table *)     FOR i := one TO numitems DO    WITH item_entry, item_table_ptr^[i] DO BEGIN       WITH rw_access DO BEGIN          item_type    := item_kind;           elem_count   := elements;          write_access := false;          read_access  := false;           unused       := zero;          write_level  := w_level;          read_level   := r_level;           END; (* with rw_access *)            item_len := item_length;  
      item_name:= item_id; 
           dbds_write_local_item_entry (item_entry, itmtbl_entry_len);        END; (* for with *)            (* Write the dataset control table to the root file *) !   next_offset := sort_offset + ((numsets+one) DIV chars_in_word) + !                  ((numitems+one) DIV chars_in_word);        FOR i := one TO numsets DO    WITH set_entry, set_table_ptr^[i] DO BEGIN           set_name := set_id;        WITH set_indics DO BEGIN           write_allowed := false;           read_allowed  := false;          set_type      := set_kind;          unused        := zero;          high_write_lev:= high_write_level;          low_read_lev  := low_read_level;          num_items     := items_in_set;          num_paths     := paths_in_set; &         last_key      := master_key_item; (* 0 for detail, key for master *) &         last_path     := zero;           END; (* with *)           data_len      := data_length;       info_off      := next_offset; #      next_offset   := next_offset + (paths_in_set*lc_path_table_len) + #                        ((items_in_set+1) DIV chars_in_word);        last_rec      := zero;        prev_rec      := zero;        next_rec      := zero;           dbds_write_local_set_entry (set_entry, settbl_entry_len);       END; (* for with *)             (* Write the set sort table to the root file *)         make_set_sort_table (set_sort); $   dbds_write_set_sort_table (set_sort, (numsets+one) DIV chars_in_word); $           (* Write the item sort table to the root file *)     make_item_sort_table (item_sort);  &   dbds_write_item_sort_table (item_sort, (numitems+one) DIV chars_in_word); &           (* Write the data set information tables to the root file *)    FOR i := one TO numsets DO     WITH set_table_ptr^[i] DO BEGIN            dbds_write_record_def (item_order, !                             (items_in_set+one) DIV chars_in_word); !          FOR j := one TO paths_in_set DO       WITH path_entry, path_table[j] DO BEGIN           detl_key := key_item;          rltd_set := rel_set;          sort_itm := sort_item;               dbds_write_path_info (path_entry, lc_path_table_len);           END; (* for each path with *)       END; (* for each set *)     #   post_runtable_buffer; (* password block must be on block boundary *) #     END; (* build_local_run_table *)  $ Page $ "(*******************************************************************) ""(*                      build_password_table                       *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To create the passwords block of the root file.              *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "     PROCEDURE build_password_table   $ Alias 'DBDS.BuildPasswd' $;      BEGIN (* build_password_table *)        (**) #   (* The password block of the root file is an array of 15 6-character # 	   (* level words. 	   (**)        dbds_write_passwords (level_words, !                         entries_in_password_block * password_len); !        post_runtable_buffer;     END; (* build_password_table *)  $ Page $ "(*******************************************************************) ""(*                           create_rootfile                       *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To take the existing schema information in the tables and    *) ""(*    create from them a root file.                                *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "    PROCEDURE create_rootfile  $ Alias 'DBDS.CreateRoot' $;      LABEL 99; (* to skip root file creation *)     CONST  $   mem_mgt_overhead = 2;   (* two word overhead for memory management *) $   password_blocks  = one; (* number of blocks for passwords *)         len              = chars_in_long_str;     VAR    display_string : long_str;     status         : short_int;     number_string  : short_str;     number_string1 : short_str;         i              : short_int;     global_size    : short_int;     local_size     : short_int;     message_size   : short_int;         global_blocks  : short_int;     local_blocks   : short_int;         free_rec_block : short_int;     sorttable_off  : short_int;    root_components: file_components_type;         length         : short_int;     nlerr          : short_int;     
BEGIN (* create_rootfile *) 
     "   IF (error_count <> zero) OR (NOT dbds_options.root) THEN GOTO 99; "       (**)     (* Initialize for creating the root file.    (**)         FOR i := zero TO words_in_disc_block-one DO       root_buffer[i] := zero;        root_bufx := zero; (* number of used words in root_buffer *)     root_blkx := one;  (* Pending block to write root_buffer to *)         (**)    (* Calculate the root file size.    (**)     !   global_size := root_header_len +             (* global header *) !!                  (bm_item_len*numitems) +      (* item table    *) !!                  (bm_set_len*numsets);         (* set table     *) !    !   local_size := local_headr_len +              (* local header  *) !!                 (itmtbl_entry_len*numitems) +  (* item table    *) !!                 (settbl_entry_len*numsets) +   (* set table     *) !!                 ((numitems+one) DIV 2) +       (* item sort tbl *) !!                 ((numsets+one) DIV 2);         (* set sort tbl  *) !     #   sorttable_off := local_headr_len +              (* local header  *) # #                    (itmtbl_entry_len*numitems) +  (* item table    *) # #                    (settbl_entry_len*numsets);    (* set table     *) #        (* Add in the record layout table size and path tables *)    FOR i := one TO numsets DO     WITH set_table_ptr^[i] DO BEGIN            local_size := local_size +  %                    ((items_in_set+one) DIV chars_in_word) + (* rec def *) % %                    (paths_in_set*lc_path_table_len);        (* pth tbl *) %     
      IF set_kind = detail 
          THEN global_size := global_size +                              (paths_in_set * bm_detl_len)           ELSE global_size := global_size +                                (paths_in_set * bm_mstr_path_len) +                               bm_mstr_key_len;            END; (* for each data set *)        (**)  "   (* Round the global run table up to a block boundary to begin the "
   (* free record table on. 
   (**)         global_size := ((global_size + words_in_disc_block - one)  !                   DIV words_in_disc_block) * words_in_disc_block; !       (* Start of the free record table *)     free_rec_block := (global_size DIV words_in_disc_block) + one;             (**)     (* Now add the free record table size, and round up to a block     (* boundary to begin the local run table at.    (**)        global_size := global_size +                    (numsets * bm_free_rec_len);         global_size := ((global_size + words_in_disc_block - one)  !                   DIV words_in_disc_block) * words_in_disc_block; !        global_blocks := global_size DIV words_in_disc_block;         local_blocks  := (local_size + words_in_disc_block - one)                      DIV words_in_disc_block;        (**) #   (* Inform the user (if listing is on) what the size of the run table # "   (* and message buffer will have to be. (Include memory management "    (* overhead).    (**)         IF dbds_options.list THEN BEGIN           (* Skip to top of page *)        display_string := '1';       IF write_long_str (list_file, display_string, status)           THEN nonfatal_error (dbds_list_file_err);           (* Global (DBMON) run table: xxxx words, yy blocks *)  (*:nl:$ ' ' *) (*:nl:$ '!1 is the number of words in single integer.' *)  (*:nl:$ '!2 is the number of blocks in single integer.' *) !(*:nl:#*1 1003 ' Global (DBMON) run table: !1 words, !2 blocks.' *) !    $(*    display_string := ' Global (DBMON) run table:';              *nls*) $    !      short_int_to_readable_short_str (global_size, number_string); !      null_pad (number_string, chars_in_short_str);     $(*    append_blank_and_str (display_string, number_string);        *nls*) $$(*    append_str (display_string, ' words,');                      *nls*) $     #      short_int_to_readable_short_str (global_blocks, number_string1); #       null_pad (number_string1, chars_in_short_str);     $(*    append_blank_and_str (display_string, number_string);        *nls*) $$(*    append_str (display_string, ' blocks.');                     *nls*) $           display_string := ' ';  &(*:nl:$COPY '      length := nlread_p2 (&, #, nlerr, display_string, len,'*) &%      length := nlread_p2 (MDBDS_SUBC, 1003, nlerr, display_string, len,    %                          number_string, number_string1);            display_string[length+1] := ' ';     (*NLS*)           IF write_long_str (list_file, display_string, status)           THEN nonfatal_error (dbds_list_file_err);                (* Local (user) run table: xxxx words, yy blocks. *)  (*:nl:$ ' ' *) (*:nl:$ '!1 is the number of words in single integer.' *)  (*:nl:$ '!2 is the number of blocks in single integer.' *)  (*:nl:#*1 1004 ' Local (user) run table: !1 words, !2 blocks.' *)      %(*    display_string := ' Local (user) run table:';                  *nls*) %    "      short_int_to_readable_short_str (local_size + mem_mgt_overhead, "                                        number_string);       null_pad (number_string, chars_in_short_str);     %(*    append_blank_and_str (display_string, number_string);          *nls*) %%(*    append_str (display_string, ' words,');                        *nls*) %    "      short_int_to_readable_short_str (local_blocks, number_string1); "       null_pad (number_string1, chars_in_short_str);     %(*    append_blank_and_str (display_string, number_string);          *nls*) %%(*    append_str (display_string, ' blocks.');                       *nls*) %           display_string := ' ';  &(*:nl:$COPY '      length := nlread_p2 (&, #, nlerr, display_string, len,'*) &%      length := nlread_p2 (MDBDS_SUBC, 1004, nlerr, display_string, len,    %                              number_string, number_string1);            display_string[length+1] := ' ';     (*NLS*)           IF write_long_str (list_file, display_string, status)           THEN fatal_error (list_file, status);            (* IMAGE message buffer size: xxxx words. *)  (*:nl:$ ' ' *) (*:nl:$ '!1 is the number of words in single integer.' *) (*:nl:#*1 1005 ' IMAGE message buffer size: !1 words.' *)     #(*    display_string := ' IMAGE message buffer size:';           *nls*) #           (**)        (* The message buffer size is the largest of the following:        (*    A) A DBUPD message.       (*    B) A DBGET message.        (**)           message_size := to_bm_update_mesg_len + largest_data;            IF (message_size < to_bm_get_mesg_len)          THEN message_size := to_bm_get_mesg_len;            message_size := message_size + mem_mgt_overhead;      "      short_int_to_readable_short_str (message_size, number_string); "      null_pad (number_string, chars_in_short_str);     %(*    append_blank_and_str (display_string, number_string);          *nls*) %    %(*    append_str (display_string, ' words.');                        *nls*) %           display_string := ' ';  &(*:nl:$COPY '      length := nlread_p1 (&, #, nlerr, display_string, len,'*) &%      length := nlread_p1 (MDBDS_SUBC, 1005, nlerr, display_string, len,    %                            number_string);            display_string[length+1] := ' ';     (*NLS*)           IF write_long_str (list_file, display_string, status)           THEN nonfatal_error (dbds_list_file_err);      #      END; (* displaying memory and disc requirements of run tables *) #           (**)    (* Create the root file. with the proper size.    (**)        parse_descriptor (root_file.newfl, root_components);         WITH root_components DO BEGIN        (* directory, name, extension and security code supplied *)       "      (* Backward compatibility: If security code is given        *) " "      (* it must be made negative.  (Gives read/write protection) *) "       IF (security <> zero) THEN security := -abs(security);            filetype := one; (* type 1 FMP file *)        filesize := global_blocks + local_blocks + password_blocks;             recordlen:= words_in_disc_block; 
      END; (* with *) 
       build_descriptor (root_components, root_file.newfl);            (**)    (* See if we should purge an existing root file.    (**)         IF dbds_options.purge        THEN IF purge_file (root_file, status)           THEN fatal_error (root_file, status);            IF create_file (root_file, status)       THEN fatal_error (root_file, status);        (**)  !   (* The new file system has a feature that writing into the last !!   (* block of an extendible file will cause it to be automatically !   (* extended.  Create_file opens a file extendible, so to get    (* around the feature, let's re-open the file non-extendible    (* and exclusive (the 'true' parameter).    (**)         IF close_file (root_file, status) THEN;     IF open_existing_non_extendible (root_file, true, status)       THEN fatal_error (root_file, status);      $   (* On RTE-6/VM, the root file must be read/write accessible to all *) $   IF operating_system = RTE6       THEN IF remove_file_protections (root_file, status)           THEN fatal_error (root_file, status);        (**) !   (* Now that the file is created, fill in the appropriate tables. !   (**)     "   build_global_run_table (global_blocks, local_size, free_rec_block, "                           root_components.security);        build_local_run_table (local_size, sorttable_off);         build_password_table;         IF close_file (root_file, status) THEN;        (**)     (* Now go on to create the data sets.    (**)     99:  (* for skipping rootfile creation *)      
END; (* create_rootfile *) 
 .  