$PASCAL ',7 92081-1X658 REV.5000' $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18658                                        *)   (* RELOC:   92081-1X658                                        *)   (*                                                             *)   (* PGMR:        <MRL>                                          *)   (*                                                             *)   (* Date last modified: <870113.1606>  (*                                                             *)   (* Altered: July 1986 for new O/S numbers                      *)   (*                                                             *)   (***************************************************************)       (**) (*:nl:$  &(*:nl:$ATB mdbds_subd %db000 relocatable, 92081-16069 REV.2540 <870113.1606> &(*:nl:$ (*:nl:$COUNTER 1 1000 1  (**)     $ List ON $  $ Heap 2 $  $ Range ON $ $ Recursive OFF $ $ Heapparms OFF $  $ Subprogram $     PROGRAM dbds_subs_for_segment_four;     "(*******************************************************************) ""(*                      global constants and types                 *) ""(*******************************************************************) "    $ List OFF, Include '[IMAGE', List ON $ $ List OFF, Include '[DBDS ', List ON $  $ Page $      (* Definition of types local to this module for large DCB *)     CONST         (* If you are looking for some space to recover, reduce the *)      (* value of big_dcb_blocks to 64 or 48.                     *)     big_dcb_blocks = 96;  (* arbitrarily large number *)      TYPE    big_descriptor_type = RECORD        fdesc : file_descriptor;        more  : ARRAY [2..big_dcb_blocks] OF disc_block;        END;         (* Definitions of data set record for this source module *) 
   set_record_type = RECORD 
      CASE short_int OF          1: (wds : data_record_type);          2: (mst : master_media_record_type);          3: (dtl : detail_media_record_type);        END; (* record case *)      $ Page $ "(*******************************************************************) ""(*                   External definitions                          *) ""(*******************************************************************) "    $ List OFF, Include '[XDBDS', List ON $ $ List OFF, Include '[XDFMP', List ON $ $ List OFF, Include '[XUSHF', List ON $     (* The external declarations for NLS below *)      (*:nl:$COPY 'PROCEDURE &; EXTERNAL;'*) PROCEDURE MDBDS_SUBD; EXTERNAL;      FUNCTION  nlread $ Alias 'NLREADREL' $  
   (PROCEDURE ext_module ; 
        msgnum   : short_int;         nlerror  : short_int;      VAR nlsbuff_string : long_str;          nllength : short_int) : short_int;     EXTERNAL;     FUNCTION operating_system  $ Alias 'IMG.OPSY' $     : os_kinds;     EXTERNAL;     $ Heapparms ON $ (* must be on *)  $ Page $ "(*******************************************************************) ""(*                      fatal_create_error                         *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    When an error occurs in creating, opening or writing to      *) ""(*    a data set, all sets created to up through the failure       *) ""(*    must be purged, then a meaningful error message displayed.   *) ""(*    Such an error is fatal.                                      *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The number of sets created so far.                 *) ""(*    (in)  (2) The error that occurred.                           *) ""(*    (in/out) (3) The set file_descriptor type.                   *) ""(*                                                                 *) ""(*******************************************************************) "    $ Heapparms OFF $  PROCEDURE fatal_create_error  $ Alias 'DBDS.CreateError' $    (    sets_created : short_int;         error_number : short_int;      VAR set_desc     : big_descriptor_type);  $ Heapparms ON $     VAR    i : short_int;     status : short_int;      BEGIN (* fatal_create_error *)        (**)     (* First, purge all sets that were created.    (**)     $   IF close_file (set_desc.fdesc, status) THEN; (* close any open file *) $        (* Purge all created data sets *)     FOR i := one TO sets_created DO     WITH set_table_ptr^[i] DO BEGIN           set_desc.fdesc.newfl := descriptor;     %      IF purge_file (set_desc.fdesc, status) THEN; (* ignore errors here *) %      END; (* for with *)             (* Make the fatal_error call *)     IF sets_created = numsets       THEN fatal_error (set_desc.fdesc, error_number)    ELSE BEGIN  %      set_desc.fdesc.newfl := set_table_ptr^[sets_created+one].descriptor; %      fatal_error (set_desc.fdesc, error_number);        END;     END; (* fatal_create_error *)  $ Page $ "(*******************************************************************) ""(*                       create_datasets                           *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To create the data sets of the database.  This routine was   *) ""(*    placed by itself in a segment to maximize the size of the    *) ""(*    DCB for creating data sets.                                  *) ""(*                                                                 *) ""(*******************************************************************) "    PROCEDURE create_datasets  $ Alias 'DBDS.CreateSets' $;      LABEL 99;  (* To skip creation of data sets *)     CONST 
   len = chars_in_long_str; 
VAR    i, j, k   : short_int;    set_desc  : big_descriptor_type;    set_record: set_record_type;     recnum    : long_int;        display_string : long_str;     status         : short_int;         length         : short_int;     nlerr          : short_int;     
BEGIN (* create_datasets *) 
       (**)     (* The purpose of placing create_datasets in a separate    (* segment is to maximize the size of the FMP data control    (* block (DCB) which will keep I/O's to a minimum.  This     (* is especially important for very large databases where    (* the time spent creating the database is 90% disc I/O.    (**)        (* Don't bother creating sets if NOSET was specified    *)    (* or NOROOT was specified, or if an error has occurred *)         IF (NOT dbds_options.sets) OR (error_count > zero) OR       (NOT dbds_options.root) THEN GOTO 99;        (**)     (* Create and initialize the data sets in two phases:  !   (*    Phase 1:  Create the data sets.  This way, if there isn't !   (*              enough room, we found out quickly.     (*    Phase 2:  Initialize the data sets.    (**)         FOR i := one TO numsets DO        (* Create the datasets *)     WITH set_table_ptr^[i] DO BEGIN           set_desc.fdesc.newfl := descriptor;           (* The descriptor was made when creating the root file *)       (* so let's purge an existing set, if desired.         *)           IF (dbds_options.purge)           THEN IF purge_file (set_desc.fdesc, status)              THEN fatal_create_error (i-one, status, set_desc);            (* Now attempt to create the file *)       IF create_file (set_desc.fdesc, status)          THEN fatal_create_error (i-one, status, set_desc);      
      (* Close the file *) 
       IF close_file (set_desc.fdesc, status) THEN;            END; (* for..with each data set *)            (**)     (* Now open each data set non-extendible and initialize it.    (**)        FOR i := one TO numsets DO     WITH set_table_ptr^[i] DO BEGIN           set_desc.fdesc.newfl := descriptor;            (* Open an existing set, exclusive, read/write access *) "      IF open_big_dcb (set_desc.fdesc, 'rwo', big_dcb_blocks, status) "         THEN fatal_create_error (numsets, status, set_desc);            (* Remove file protections on RTE-6 *)        IF operating_system = RTE6           THEN IF remove_file_protections (set_desc.fdesc, status)                THEN fatal_create_error (numsets, status, set_desc);            (* Set the full record to zeroes *)        FOR j := zero TO max_data_in_a_record-1 DO          set_record.wds[j] := zero;            (* For each record in the set, write a record to disc *)        FOR recnum := one TO capacity DO BEGIN              WITH set_record.mst DO BEGIN             backward_ptr := recnum-one;             forward_ptr  := recnum+one;                  IF recnum = capacity THEN forward_ptr := zero;      #            (* 6-9 are the word offsets of the backward and forward *) # #            (* pointers in the media record.                        *) #     !            IF dbds_options.checksum THEN WITH set_record DO BEGIN !$               media_checksum := wds[6] + wds[7] + wds[8] + wds[9] + one; $               data_checksum  := one;                END; (* then with *)     
            END; (* with *) 
     $         (* Write the record to the data set file at current position *) $         IF write_buffer (set_desc.fdesc, set_record.wds[zero],                           media_length + data_length, status)               THEN fatal_create_error (numsets, status, set_desc);               END; (* for each record *)            IF close_file (set_desc.fdesc, status) THEN;           END; (* for each set *)        (**)    (* At this point, all data sets have been created.     (* Write a completion message if listing is on.    (**)         IF dbds_options.list THEN BEGIN  !(*    display_string := ' Data sets are created.';          *nls*) !           display_string := ' ';         (*nls*)      (*:nl:#*1 1000 ' Data sets are created.'*) %(*:nl:$COPY '      length := nlread (&, #, nlerr, display_string, len);' *) % %      length := nlread (MDBDS_SUBD, 1000, nlerr, display_string, len);     %           display_string[length+1] := ' ';     (*NLS*)           IF write_long_str (list_file, display_string, status)           THEN fatal_error (list_file, status); 
      END; (* then *) 
    
99:  (* exit label *) 
     
END; (* create_datasets *) 
 .  