$PASCAL ',7 92081-1X218 REV.5000' $ $ Title 'IMAGE subsystem Hari Kari Routine' $ $ Recursive OFF $ $ Range OFF $      $ Subprogram $  $ Heap 0 $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18218                                        *)   (* RELOC:   92081-16218                                        *)   (*                                                             *)   (* PGMR:        <MRL>                                          *)   (*                                                             *)   (* Date last modified: <870113.1631>  (*                                                             *)   (* June 19, 1986: Removed code which checked caller's program  *)   (* name, to avoid sending hari-kari message to self.  DBUTL    *)   (* cleans up extraneous messages anyway at startup, plus the   *)   (* 'die now' message was useful for PIGGY and SLURP, being     *)   (* used to collect messages at a 3M hot site.  <MRL>           *)   (*                                                             *)   (***************************************************************)       PROGRAM image_suicide_routine;      (***************************************************************)   (*       Global constants, types and external definitions      *)   (***************************************************************)      $ List OFF, Include '[IMAGE', List ON $     $ List OFF, Include '[XDGCB', List ON $ $ List OFF, Include '[XDMSG', List ON $ $ List OFF, Include '[XDLDP', List ON $ $ List OFF, Include '[XDSEM', List ON $      (***************************************************************)   (*                  IMAGE_Hari_Kari                            *)   (***************************************************************)   (*                                                             *)   (* IMAGE subsystem Hari Kari Routine:                          *)   (*                                                             *)   (* Purpose:                                                    *)   (*    To send suicide messages to all active IMAGE subsystem   *)   (*    programs.  Those programs are expected to IMMEDIATELY    *)   (*    wrap up any loose ends (like open files and other system *)   (*    resources), and TERMINATE!                               *)   (*                                                             *)   (* No parameters needed.                                       *)   (*                                                             *)   (* Called by:                                                  *)   (*    Health_check in DBUTL.                                   *)   !(*                                                             *)  ! (* Errors:                                                     *)   (*    This routine is exited if any error occurs, such as      *)   (*    the IMAGE communication buffer not being set up.         *)   (*                                                             *)   (***************************************************************)      PROCEDURE IMAGE_hari_kari   $ Alias 'Img.HarryKerry' $;      
LABEL 99; (* error exit *) 
     $ List OFF, Include '[PROG', List ON $      TYPE     message_header_type =        RECORD           from_comm_id   : Short_int;           from_comm_lock : Short_int;           to_comm_id     : Short_int;           to_comm_lock   : Short_int;           request        : Short_int;        END;     VAR    comm_buffer    : IMAGE_comm_buffer_type;     message_header : Message_header_type;     return_status  : Short_int;     
BEGIN (* image_hari_kari *) 
       IF get_image_comm_buffer (comm_buffer) 	      THEN GOTO 99; 	       WITH message_header DO BEGIN       from_comm_id   := zero;       from_comm_lock := zero;           IF (NOT program_is_dormant (dbmon_program)) 	         THEN BEGIN 	             to_comm_id   := comm_buffer.dbmon_comm_id;              to_comm_lock := comm_buffer.dbmon_comm_lock;             request      := to_bm_finis_code;             IF send_request (message_header.from_comm_id,                               to_bm_finis_mesg_len,                              return_status)                THEN; (* do nothing *) 
            END; (* then *) 
          IF (NOT program_is_dormant (DBCLN_program)) 	         THEN BEGIN 	             to_comm_id   := comm_buffer.DBCLN_comm_id;             to_comm_lock := zero;              request      := to_DBCLN_finis_code;             IF send_request (message_header.from_comm_id,                               to_DBCLN_finis_msg_len,                              return_status)                THEN; (* do nothing *) 
            END; (* then *) 
          IF (NOT program_is_dormant (dbspl_program)) 	         THEN BEGIN 	             to_comm_id   := comm_buffer.dbspl_comm_id;             to_comm_lock := zero;              request      := to_spl_finis_code;             IF send_request (message_header.from_comm_id,                              to_spl_finis_mesg_len,                              return_status)                THEN; (* do nothing *)              END; (* then *)             END; (* with *)              WITH comm_buffer DO BEGIN  "      IF unlock_comm_lock_id (dbmon_comm_lock, return_status) THEN;  " "      IF unlock_comm_lock_id (dbspl_comm_lock, return_status) THEN;  " "      IF unlock_comm_lock_id (DBCLN_comm_lock, return_status) THEN;  " "      IF unlock_comm_lock_id (dblck_wait_lock, return_status) THEN;  " "      IF unlock_comm_lock_id (dbcon_file_lock, return_status) THEN;  "       END; (* with *)           99:  (* error exit *)       
END; (* Image_hari_kari *) 
 .  