 $PASCAL ',7 92081-1X239 REV.2540' $   !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18239                                        *)  ! !(* RELOC:   92081-1X239                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <edb>                                          *)  ! !(*                                                             *)  ! (* Date last modified: <851107.0919>  !(*                                                             *)  ! !(* Altered:  October, 1983 for RTE-A file system.  <MRL>       *)  ! !(*                                                             *)  ! !(***************************************************************)  !     $ Title 'IMAGE String Manipulators' $   $ Subtitle 'System-independent utility routines' $  $ Heap 0 $  	$ Recursive OFF $  	 $ Subprogram  $   $ Range OFF $       PROGRAM string_manipulators;          #(********************************************************************) # #(*                                                                  *) # #(* PROGRAM : IMAGE string manipulation/conversion routines.         *) # #(*                                                                  *) # #(* PURPOSE : These routines perform various system independent      *) # #(*           string manipulations for IMAGE programs.               *) # #(*                                                                  *) # #(* PROGRAMMER : <EDB> <MRL> <MES>                                   *) # #(*                                                                  *) # #(* Date of last modification: <821110.1555>                         *) # #(*                                                                  *) # #(********************************************************************) #     $ List OFF, Include '[IMAGE', List ON $       $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) #         (**** Convert a short_int value to ascii string ****)       PROCEDURE convert_shorti_to_ascii   $ Alias 'CITA' $     (    short_int_value : Short_int;      VAR return_string   : Short_int_str_type);     EXTERNAL;              (**** Convert octal (integer) to ascii characters ****)       PROCEDURE convert_octal_to_ascii   $ Alias 'COTA' $      (    octal_value : short_int;      VAR return_str  : short_str);      EXTERNAL;          (**** Convert a long_int value to ascii string ****)      PROCEDURE convert_longi_to_ascii  $ Alias 'CDITA' $      (    long_int_value : Long_int;      VAR return_string  : Long_int_str_type);     EXTERNAL;          $ Include '[XUSHF' $    (* Upshift external Defn's *)        $ Include '[XDSLJ' $    (* External defn's for zero-suppress *)    "                            (* and left justification of result. *)  "     $ Page $  #(********************************************************************) # #(*    Truncate a long string into a short string.                   *) # #(********************************************************************) # #(*                                                                  *) # #(* Routine: Truncate_str                                            *) # #(*                                                                  *) # #(* Purpose: To take the leftmost 16 characters of a long_str and    *) # #(*          place them into a short_str.                            *) # #(*                                                                  *) # #(* PGMR:       <MRL>                                                *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE truncate_str   $ Alias 'IMG.TruncateStr' $     ( VAR long_string  : long_str;        VAR short_string : short_str);       BEGIN (* truncate_str *)         short_dest_long_srce (short_string, chars_in_short_str,                           long_string, chars_in_long_str,                           str_assign, zero);           (* Assigning to a shorter string automatically truncates. *)        END; (* truncate_str *)   $ Page $  #(********************************************************************) # #(*                      replace_str                                 *) # #(********************************************************************) # #(*                                                                  *) # #(* Replace_str replaces a short string with another short string    *) # #(* in the specified long string.  The search string is first found  *) # #(* in the source string, and if found, is replaced by the replace   *) # #(* string. Each of the strings is determined to end with the last   *) # #(* non-blank character.                                             *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE replace_str   $ Alias 'IMG.ReplaceStr'$   
   ( VAR source: long_str; 
          search: short_str;            replace: short_str );      VAR      start_byte : short_int; (* location of SEARCH in SOURCE *)       BEGIN (* replace_str *)          start_byte := find_substring (source, chars_in_long_str,                                    search, chars_in_short_str);          IF (start_byte > zero) THEN BEGIN (* do the replace *)             (* Remove SEARCH from SOURCE *)             long_dest_short_srce (source, chars_in_long_str,                              search, chars_in_short_str,                               str_remove, zero);                (* insert REPLACE into SOURCE *)            long_dest_short_srce (source, chars_in_long_str,                              replace, chars_in_short_str,                              str_insert, start_byte);            END; (* then do the replace *)      END; (* replace_str *)  $ Page $  #(********************************************************************) # #(*                      append_str                                  *) # #(********************************************************************) # #(*                                                                  *) # #(* Append_str appends a short string to the specified long string.  *) # #(* Each of the strings is determined to end with the last           *) # #(* non-blank character.                                             *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE append_str   $ Alias 'IMG.AppendStr'$   
   ( VAR source: long_str; 
          append: short_str );       BEGIN (* append_str *)         long_dest_short_srce (source, chars_in_long_str,                            append, chars_in_short_str,                           str_append, zero);       END; (* append_str *)   $ Page $  #(********************************************************************) # #(*                    append_long_str                               *) # #(********************************************************************) # #(*                                                                  *) # #(* Append_str appends a long  string to the specified long string.  *) # #(* Each of the strings is determined to end with the last           *) # #(* non-blank character.                                             *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE append_long_str   $ Alias 'IMG.ApndLongStr' $   
   ( VAR source: long_str; 
          append: long_str );      BEGIN (* append_long_str *)          long_dest_long_srce (source, chars_in_long_str,                          append, chars_in_long_str,                          str_append, zero);      
END; (* append_long_str *) 
 $ Page $   (*************************************************************)     (* Convert a short integer to a left-justified ascii string  *)     (*************************************************************)     (*                                                           *)     (* Routine :  Short_int_to_readable_short_str                *)     (*                                                           *)     (* Purpose :  To take a short_int value and convert it to    *)     (*            a short string, suppressing non-significant    *)     (*            zeroes and left justifying the result.         *)     (*                                                           *)     (* Parameters:                                               *)     (*    (in)  (1) The short_int value to convert.              *)     (*    (out) (2) the short_str result.                        *)     (*                                                           *)     (* Called by inverse_file_desc.                              *)     (*                                                           *)     (*************************************************************)            #PROCEDURE short_int_to_readable_short_str  $ Alias 'IMG.SintToSstr' $  #    (    short_int_val : short_int;      VAR result_str    : short_str);       VAR      short_int_string : short_int_str_type;       BEGIN  (* short_int_to_readable_short_str *)         convert_shorti_to_ascii (short_int_val, short_int_string);          suppress_zeroes_and_left_justify_short_int_str         (short_int_string,  	       result_str, 	        chars_in_short_int_str);       END; (* short_int_to_readable_short_str *)  $ Page $   (*************************************************************)     (* Convert an octal value  to a left-justified ascii string  *)     (*************************************************************)     (*                                                           *)     (* Routine :  Octal_to_readable_short_str                    *)     (*                                                           *)     (* Purpose :  To take a short_int value and convert it to    *)     (*            a short string of an octal representation left *)     (*            justified and zero-filled on the left.         *)     (*                                                           *)     (* Parameters:                                               *)     (*    (in)  (1) The short_int value to convert.              *)     (*    (out) (2) the short_str result.                        *)     (*                                                           *)     (* Called by inverse_file_desc.                              *)     (*                                                           *)     (*************************************************************)            !PROCEDURE octal_to_readable_short_str  $ Alias 'IMG.OctalToSstr' $ !    (    octal_val  : short_int;       VAR result_str : short_str);      CONST      octal_length = 6; (* characters *)       VAR loop : short_int;           BEGIN  (* octal_to_readable_short_str *)         convert_octal_to_ascii (octal_val, result_str);         FOR loop := (octal_length + one) TO chars_in_short_str DO        result_str[loop] := ' ';      END; (* short_int_to_readable_short_str *)  $ Page $   (*************************************************************)     (* Convert a long  integer to a left-justified ascii string  *)     (*************************************************************)     (*                                                           *)     (* Routine :  long_int_to_readable_short_str                 *)     (*                                                           *)     (* Purpose :  To take a  long_int value and convert it to    *)     (*            a short string, suppressing non-significant    *)     (*            zeroes and left justifying the result.         *)     (*                                                           *)     (* Parameters:                                               *)     (*    (in)  (1) The long_int  value to convert.              *)     (*    (out) (2) the short_str result.                        *)     (*                                                           *)     (* Called by inverse_file_desc.                              *)     (*                                                           *)     (*************************************************************)            "PROCEDURE long_int_to_readable_short_str  $ Alias 'IMG.LintToSstr' $ "    (    long_int_val : long_int;      VAR result_str   : short_str);      VAR      long_int_string : long_int_str_type;           BEGIN  (* long_int_to_readable_short_str *)          convert_longi_to_ascii (long_int_val, long_int_string);         suppress_zeroes_and_left_justify_long_int_str        (long_int_string,   	       result_str, 	        chars_in_long_int_str);      END; (* long_int_to_readable_short_str *)   $ Page $  #(********************************************************************) # #(*                positional_append_str                             *) # #(********************************************************************) # #(*                                                                  *) # #(* positional_append_str appends a given number of characters to    *) # #(* the given long string starting at the character position         *) # #(* passed as the last parameter.                                    *) # #(*                                                                  *) # #(********************************************************************) # PROCEDURE positional_append_str   $ Alias 'IMG.PosAppendStr'$   
   ( VAR source: long_str; 
 
         append: long_str; 
          append_len: short_int;            position:  short_int);       BEGIN (* positional_append_str *)       !   (* NOTE! This works with whatever size string append_len is. *) !        long_dest_long_srce (source, chars_in_long_str,                          append, append_len,                           str_overlay, position+one);       END; (* positional_append_str *)  $ Page $  #(********************************************************************) # #(*                      append_blank_and_str                        *) # #(********************************************************************) # #(*                                                                  *) # #(* Append_blank_and_str appends a short string to the specified     *) # #(* long string, leaving one blank in front.  Each of the strings is *) # #(* determined to end with the last non-blank character.             *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE append_blank_and_str   $ Alias 'IMG.AppndBandS'$  
   ( VAR source: long_str; 
          append: short_str );       BEGIN (* append_blank_and_str *)         long_dest_short_srce (source, chars_in_long_str,                            append, chars_in_short_str,                           str_blankappend, zero);      END; (* append_blank_and_str *)   $ Page $  #(********************************************************************) # #(*                      append_blank_and_file                       *) # #(********************************************************************) # #(*                                                                  *) # #(* Append_blank_and_file appends a file name   to the specified     *) # #(* long string, leaving one blank in front.  Each of the strings is *) # #(* determined to end with the last non-blank character.             *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE append_blank_and_file  $ Alias 'IMG.AppndBandF'$  
   (VAR source: long_str;  
         append: new_file_name);       BEGIN (* append_blank_and_file *)          long_dest_file_srce (source, chars_in_long_str,                          append, chars_in_new_file_name,                           str_blankappend, zero);       END; (* append_blank_and_file *)  $ Page $   (*************************************************************)     (* Convert an integer crn to a printable crn                 *)     (*************************************************************)     (*                                                           *)     (* Routine :  Int_crn_to_readable_short_str                  *)     (*                                                           *)     (* Purpose :  To take an integer crn and convert it to two   *)     (*            ascii characters if in the range 20000B to     *)     (*            55132B or to a printable numeric short_str     *)     (*            if outside that range.                         *)     (*                                                           *)     (* Parameters:                                               *)     (*    (in)  (1) The short_int value to convert.              *)     (*    (out) (2) the short_str result.                        *)     (*                                                           *)     (* Called by inverse_file_desc.                              *)     (*                                                           *)     (*************************************************************)            !PROCEDURE int_crn_to_readable_short_str  $ Alias 'IMG.CrnToSstr' $ !    (    short_int_val : short_int;      VAR result_str    : short_str);           TYPE     two_char_ascii = packed array [1..2] of char;  
   ascii_crn_type = RECORD 
                        CASE short_int OF                            1: (int:  short_int);                             2: (ascii:  two_char_ascii);                         END;       VAR      short_int_string : short_int_str_type;      ascii_crn:  ascii_crn_type;      BEGIN  (* int_crn_to_readable_short_str *)         result_str := '                ';         (* see if in range of two ascii chars *)      IF (short_int_val >= 8192) AND (short_int_val <= 23130)        THEN BEGIN           ascii_crn.int := short_int_val;           result_str[1] := ascii_crn.ascii[1];            result_str[2] := ascii_crn.ascii[2];         END      ELSE BEGIN          convert_shorti_to_ascii (short_int_val, short_int_string);             suppress_zeroes_and_left_justify_short_int_str           (short_int_string,             result_str,             chars_in_short_int_str);     END;       END; (* int_crn_to_readable_short_str *)  .  