 $PASCAL ',3,50 92081-16775 REV.5000' $  $TITLE 'DBSPL: IMAGE spool utility program'$ $SUBTITLE 'Main program'$  $HEAP 0$  $RECURSIVE ON$  $RUN_STRING 0$ $ Range OFF $      PROGRAM DBSPL;      #(* **************************************************************** *) # #(* * (C) Copyright 1983 Hewlett-Packard.  All rights reserved.    * *) # #(* * No part of this program may be photocopied, reproduced or    * *) # #(* * translated to another program language without the express   * *) # #(* * written consent of Hewlett-Packard Company.                  * *) # #(* **************************************************************** *) #     #(********************************************************************) # #(*                                                                  *) # #(* PROGRAM : DBSPL                                                  *) # #(*                                                                  *) # #(* PURPOSE : This program performs spooling of log chunks from the  *) # #(*           transaction file to the roll forward file.             *) # #(*                                                                  *) # #(* PGMR:        <stc>                                               *) # #(*                                                                  *) # #(* SOURCE:  92081-18775                                             *) # #(* RELOC:   92081-16775                                             *) # #(*                                                                  *) #(* DATE LAST MODIFIED : <870113.1606>  #(*                                                                  *) # #(* There was a bug in IMAGE-II where transactions could be lost     *) # #(* by combination power fail and TLF corruption, so the no-spool    *) # #(* option was added to roll-forward logging.  The fix was made in   *) # #(* February, 1984.  <MRL>                                           *) # #(*                                                                  *) # #(* Another bug, introduced at Rev.2440 when heirarchical log files  *) # #(* were supported: The 'eof' error trapped was +12, but the routine *) # #(* rfl_chunk_io was looking for -12.  Now both are accepted.        *) # #(* June, 1985. <MRL>                                                *) # #(*                                                                  *) # #(* Workaround June 1985 <MRL>:  FMP automatically allocated an      *) # #(* extent to the RFL when the last block was written to.  The work- *) # #(* around was to open the file non-extendible.                      *) # #(*                                                                  *) # #(* Bug, January 1986:  If DBSPL must write a buffer to the log, but *) # #(* is currently waiting for a spare to be defined, and somebody     *) # #(* issues a ShutDown command, DBSPL will shut down without writing  *) # #(* the buffer anywhere, thereby silently losing log records.        *) # #(*                                                                  *) # #(* Another bug, January 1986:  A difference in the way EWRIT and    *) # #(* FmpWrite work:  EWRIT would not partially write a buffer, whereas*) # #(* FmpWrite will write as much as it can.  For example, an attempt  *) # #(* to write 20 blocks of data when only 15 blocks remain in the     *) # #(* file: EWRIT will not write any data (thus leaving the log file in*) # #(* a good state with an EOF block still present), but FmpWrite will *) # #(* write out 15 blocks (overwriting the EOF block of zeros).        *) # #(* Overwriting the EOF block screws up DBARC and DBRFR which are    *) # #(* looking for that block to indicate the end of log records.       *) # #(*                                                                  *) # #(* Bug, January 1986:  RF no-spooling option fills first volume and *) # #(* switches to spare OK, but only writes first TLB to the log file  *) # #(* and ignores all subsequent log records.                          *) # #(*                                                                  *) # #(********************************************************************) #     $PAGE$  #(********************************************************************) # #(*                      LABEL DEFINITIONS                           *) # #(********************************************************************) #    LABEL        99,                             (* ignore message *)    999;                            (* abnormal termination *)         CONST  !   inactive_wait_increment = 1*100; (* 100 10's of milliseconds *) !!   max_inactive_wait_time = 60*100; (* 6000 10's of milliseconds *) !    min_inactive_wait_time = 1*100;      $PAGE$  $ List off $ "$ Include '[IMAGE' $          (* General IMAGE constants and types *) " $ Include '[LOG' $            (* Structured log constants *) $ List on $      #(********************************************************************) # #(*                      LOCAL TYPES                                 *) # #(********************************************************************) # #(*                      LOCAL VARIABLES                             *) # #(********************************************************************) #    VAR     "   image_comm_buffer:              (* global communications buffer *) "      image_comm_buffer_type;        message :                       (* general message type *)        RECORD  
         CASE short_int OF 
 $            0: (dbspl:             (* dbspl message buffer (to DBSPL) *) $                   to_spl_mesg_type);  $            1: (dbmon:             (* dbspl message buffer (to DBMON) *) $                    to_bm_mesg_type);  
         END; (* RECORD *) 
       msg_reply_code : short_int;     (* reply message code *)    msg_len : short_int;            (* request message length *)     ret_msg_len : short_int;        (* return message length *)             (* tables and buffers *)      dbcon_block : dbcon_table_type;     rfl_label : rfl_label_type;     spl_buffer : rfl_tape_buffer_type;      history_table_entry : history_table_entry_type;      
   (* file descriptors *)  
    dbcon_descriptor : file_descriptor;     rfl_descriptor : file_descriptor;     tlf_descriptor : file_descriptor;         max_blks_in_spl_buffer : short_int;  #   last_spooled_block : long_int;  (* block # of last spooled block *) #    next_spl_buf_blk_num : short_int; &   continue : boolean;             (* flag to indicate continue processing *) &#   okay_to_spool : boolean;        (* is true if pre-spool init done *) #   return_status : short_int;    flag_send_message : boolean; #   inactive_wait_time : short_int; (* # of 10's of millisec to sleep *) # &   abnormal_finish : boolean;    (* true if we're to terminate abnormally *) &       post_rfl_immediate : boolean;  (* for Feb '84 fix *)         (* temporary variables *)  !   dummy_long_str : long_str;      (* dummy to occupy parameter *) !    dummy_boolean : boolean;        (* ditto *)     dummy_short_int : short_int;    (* ditto *)         rfl_io_time : long_int; (* Performance stats *)      $PAGE$  #(********************************************************************) # #(*                      EXTERNAL SYSTEM PROCEDURES                  *) # #(********************************************************************) #     $ LIST OFF $  $ Include '[XDMSG' $          (* message exchange externals *) !$ Include '[XDGDN' $          (* External to get dbcon file name *) !"$ Include '[XDFMP' $          (* Externals to non EMA I/O routines *) "!$ Include '[XDCIO' $          (* Externals to dbcon I/O routines *) !  $ Include '[XDTDY' $          (* External to create timestamp *)   !$ Include '[XDGCB' $          (* Get the communications buffer *)  ! $ Include '[XDCCP' $          (* Clear the comm. buffer *)  $ Include '[XDSLP' $          (* Sleep routine *)   
$ Include '[XDSEM' $ 
     $ LIST ON $       	$ Heapparms off $  	     
(* detach from session *)  
 PROCEDURE detach_from_session $ ALIAS 'DTACH' $      ( VAR dummy : short_int);     EXTERNAL;      	$ Heapparms off $  	     (* determine if the end of tape mark has been reached *)      FUNCTION eot_check $ alias 'IEOT' $      ( VAR device_name : file_name) :      short_int;      EXTERNAL;     $ Heapparms off $     (* do device I/O control functions *)      FUNCTION device_control_operation    $ alias 'DBIOC' $     ( VAR device_name : dcb_type;          fctn_code : device_ctrl_fctn_type;      VAR return_status : short_int) :      BOOLEAN;     EXTERNAL;         $ Heapparms off $     FUNCTION cmp_blocks $ alias 'DBCMW' $     ( VAR buffer1 : disc_block;           buffer2 : disc_block;          num_words : short_int) :    short_int;     EXTERNAL;          #(* Get_dbspl_startup_request_mesg gets the startup request message  *) # #(* for DBSPL.                                                       *) #     PROCEDURE get_dbspl_startup_request_mesg $ALIAS 'RMPAR'$     ( VAR startup_request_mesg: dbspl_startup_request_mesg );     EXTERNAL;      #(* Get_dbmon_request_mesg gets a message from the DBMON program.    *) #     FUNCTION get_dbmon_request_mesg $ALIAS 'IMG.LCLGETMESG'$     (     from_comm_id: short_int;            from_comm_lock: short_int;   
         wait: short_int;  
      VAR from_message: to_spl_mesg_type;       VAR from_message_len: short_int;            max_message_len: short_int;       VAR errval: short_int ): boolean;     EXTERNAL;      #(* Put_dbmon_request_mesg puts a message to the DBMON program.      *) #     FUNCTION put_dbmon_request_mesg $ALIAS 'IMG.LCLSENDRQST'$      ( VAR to_message: to_bm_mesg_type;            to_message_len: short_int;        VAR errval: short_int ): boolean;     EXTERNAL;          $PAGE$  #(********************************************************************) # #(* Procdure initialize                                              *) # #(*                                                                  *) # #(* Purpose : Initialize sets up the DBSPL environment for           *) # #(* communicating with the outside world (namely, DBMON).            *) # #(*                                                                  *) # #(* Input : none                                                     *) # #(*                                                                  *) # #(* Returns : nothing                                                *) # #(*                                                                  *) # #(* Called by :                                                      *) # #(*    (1) main                                                      *) # #(*                                                                  *) # #(* Calls :                                                          *) # #(*    (1) get_dbspl_startup_request_mesg                            *) # #(*    (2) get_image_comm_buffer                                     *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE initialize $ALIAS 'DBSPL.INITIALIZE'$;      CONST   "   dbspl = prog_name               (* dbspl standard program name *) "       [ 'DBSPL', chars_in_prog_name-5 of ' ' ];      startup_reply_mesg_len = 5;      VAR   '   startup_request_mesg:           (* DBSPL startup request message buffer *)  '       dbspl_startup_request_mesg;      error : short_int;      startup_reply_mesg : to_dbutl_startup_reply_mesg_type;       BEGIN (* initialize *)             (* get startup request message *)     get_dbspl_startup_request_mesg (startup_request_mesg);          (* reply to dbutl *)      WITH startup_reply_mesg DO BEGIN         to_comm_id := startup_request_mesg.reply_comm_id;         to_comm_lock := zero;         END;  
   IF send_request ( 
       startup_reply_mesg.from_comm_id,  (* 1st word *)        startup_reply_mesg_len,   	      error) THEN  	       GOTO 999;           (* get communications buffer - contains communication ids *)       IF get_image_comm_buffer (image_comm_buffer)         THEN BEGIN                   (* generate error *)   $         GOTO 999;                 (* take abnormal termination exit *)  $          END; (* THEN *)         IF startup_request_mesg.dbspl_comm_id <>        image_comm_buffer.dbspl_comm_id       THEN BEGIN                   (* generate error *)  	         GOTO 999; 	          END; (* THEN *)            (* initialize the inactive wait value *)     inactive_wait_time := min_inactive_wait_time;        (* initialize other dbspl variables *)        next_spl_buf_blk_num := one;        (* reserve a block for an eof block *)    max_blks_in_spl_buffer := num_blks_in_rfl_tape_buffer - one;      "   (* Open up the DBCON file and set the 'spool immediate' option *) " "   (* as the user desires.                                        *) "     !   IF get_db_control_file_name (dbcon_descriptor.newfl) THEN BEGIN !      return_status := image_not_initialized_err;       GOTO 999;        END;        IF open_existing_file (dbcon_descriptor,                           return_status) THEN BEGIN        return_status := rfl_dbcon_access_err;       GOTO 999;        END;             IF read_dbcon_block (        dbcon_descriptor,         dbc_status_blk,         do_not_lock_dbcon_file,   	      dbcon_block, 	       return_status) THEN BEGIN         return_status := rfl_dbcon_access_err;        GOTO 999;         END;        (**)     (* The default RF logging mode is spooled.  If the user really      (* desires no spooling, set the 'immediate posting' flag.    (**)         post_rfl_immediate := false;  (* Assume spooling *)         IF (dbcon_block.dbcon_status_block.logging_state = rf_nospool)         THEN post_rfl_immediate := true;     
END; (* initialize *) 
     $PAGE$  #(********************************************************************) # #(* Function  recv_message                                           *) # #(*                                                                  *) # #(* Purpose : This function  receives a dbspl request message.       *) # #(* This message (which should be a rfl_spool request) is            *) # #(* placed in the global variable message.                           *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION  recv_message $ALIAS 'DBSPL.RCVMSG'$      (VAR return_status : short_int):        BOOLEAN;       LABEL 99;       CONST       wait_for_message = 0;           (* wait for message option *)       BEGIN (* recv_message *)         (* assume error *)      recv_message := true;         (* get message from DBMON *)      IF get_dbmon_request_mesg           (image_comm_buffer.dbspl_comm_id,            image_comm_buffer.dbspl_comm_lock,            wait_for_message,             message.dbspl, msg_len,             to_spl_max_mesg_len,            return_status) THEN         GOTO 99;         (* okay *)   
   recv_message := false;  
    99:     END; (* recv_message *)      $ page $  #(********************************************************************) # #(*                                                                  *) # #(* Function send_message                                            *) # #(*                                                                  *) # #(* Purpose : This function sends a reply to DBMON.  This reply      *) # #(* is sent on a special class number so that it does not have       *) # #(* to wait in a queue of 'user-DBMON' messages.  Instead, DBMON     *) # #(* checks this special class after processing every user-DBMON      *) # #(* message.                                                         *) # #(*                                                                  *) # #(* Note : This function uses a constant message length since        *) # #(* all to_bm_spool_reply messages are the same length.              *) # #(*                                                                  *) # #(* Input :                                                          *) # #(*    (1) message code - reply message type                         *) # #(*    (2) reply status - status of the operation to which dbspl     *) # #(*           completed or is working on ( a single request may      *) # #(*           have several replies, giving DBMON information         *) # #(*           which may need to be written to the warning log).      *) # #(*    (3) block num - this is only necessary when the reply is      *) # #(*           due to a successful spool operation.  The block        *) # #(*           number of the last spooled block is returned           *) # #(*           DBMON ignores this field for all other spl mesg replies*) # #(*                                                                  *) # #(********************************************************************) #         FUNCTION send_message $ALIAS 'DBSPL.SNDMSG'$      (    message_code : short_int;           reply_status : short_int;           spool_reply_block_num : long_int) :     BOOLEAN;       LABEL 99;       VAR      local_status : short_int;      BEGIN (* send_message *)     
   (* assume error *) 
    send_message := true;         (* format universal message header *)    WITH message.dbmon, image_comm_buffer DO BEGIN        from_comm_id := dbspl_comm_id;        from_comm_lock := dbspl_comm_lock;        to_comm_id := spl_reply_comm_id; 
      to_comm_lock := zero; 
      request := message_code;  (* indicates type of reply *)  &      WITH spl_reply DO BEGIN   (* format is the same for all spl replies *) &          (* status of operation *)           status := reply_status;           (* only meaningful for rfl spool request *)           spooled_block := spool_reply_block_num;          rfl_write_time := rfl_io_time;          END;  (* end with *) 
      END; (* WITH *) 
         %   (* send message on to DBMON, using the proper request message length *) %    IF put_dbmon_request_mesg (  
      message.dbmon, 
      to_bm_spool_reply_mesg_len,        local_status) THEN        GOTO 99;        (* okay *)    send_message := false;     99:     END; (* send_message *)  $ page $  !(****************************************************************) ! !(*                                                              *) ! !(* Procedure set_rfl_corrupt_flag                               *) ! !(*                                                              *) ! !(* Purpose : This procedure is needed when DBSPL detects        *) ! !(* that the rfl is corrupt.                                     *) ! !(*                                                              *) ! !(****************************************************************) ! PROCEDURE set_rfl_corrupt_flag (VAR return_status: short_int);     VAR     status : short_int;     BEGIN         (* read the dbcon status block *)     IF read_dbcon_block (       dbcon_descriptor, 
      dbc_status_blk, 
       lock_dbcon_file,  	      dbcon_block, 	 	      status) THEN 	      return_status := rfl_dbcon_access_err    ELSE BEGIN        dbcon_block.dbcon_status_block.flag.corrupt_rfl := true;        IF write_dbcon_block (  
         dbcon_descriptor, 
          dbc_status_blk, 
         unlock_dbcon_file, 
         dbcon_block, 

         status) THEN 
         return_status := rfl_dbcon_access_err;        END;  (* else *)  END;  $ PAGE $  #(********************************************************************) # #(*                                                                  *) # #(* Procedure Check_image_status                                     *) # #(*                                                                  *) # #(* Purpose : This procedure checks the status of image to determine *) # #(* if DBSPL should terminate.  The log state and image active       *) # #(* states are determined by looking in DBCON.  The callers of       *) # #(* this routine are in a time list wait loop because of some        *) # #(* abnormal situation (eg. mag tape down, spare not defined, etc. ) *) # #(* and do not want to do anything until the situation is either     *) # #(* corrected or the IMAGE state has been changed.  The reason       *) # #(* callers do not hang on a class wait in those situations is       *) # #(* because the IMAGE system was not designed to allow users to      *) # #(* talk directly to DBSPL, for example when a user puts the tape    *) # #(* on line.  DBSPL must determine the situation change itself.      *) # #(*                                                                  *) # #(* If there has been no change in the IMAGE status, then            *) # #(* return_status returns the value it held when this proc was       *) # #(* called.  The only exception is if we get an error accessing      *) # #(* DBCON.                                                           *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE check_image_status (     VAR return_status : short_int);     LABEL 99;     VAR 
  status : short_int; 
    BEGIN         (* read the dbcon status block *)     IF read_dbcon_block (       dbcon_descriptor, 
      dbc_status_blk, 
      do_not_lock_dbcon_file,  	      dbcon_block, 	       status) THEN BEGIN        return_status := rfl_dbcon_access_err;        GOTO 99;        END;        (**) %   (* Log or active status changed? If so, change return status to indicate %#   (* that dbspl is terminating. If not, leave the return_status along. #   (**)        WITH dbcon_block.dbcon_status_block DO $      IF (ord(logging_state) < ord(rb_rf)) or NOT(flag.image_active) THEN $      return_status := dbspl_terminating_warn_code;     99:     END;  (* end proc check_image_status *)  $PAGE$  !(****************************************************************) ! !(*                                                              *) ! !(* Function Device_control                                      *) ! !(*                                                              *) ! !(* Purpose : This function performs control functions on a      *) ! !(* peripheral device. The functions performed include :         *) ! !(* backspace one record, forward space one record, rewind,      *) ! !(* forward one file, and write tape eof.                        *) ! !(*                                                              *) ! !(* If a parity error is encountered, the IMAGE error 335 is     *) ! !(* returned.  The driver puts the device down when a parity     *) ! !(* error occurs.  We do not recover from it because it is       *) ! !(* very system dependent ( must 'UP' the eqt).  If the device   *) ! !(* is not ready, the IMAGE error 334 is returned.  For all      *) ! !(* other device I/O errors, 336 is returned.  If an             *) ! !(* illegal request is made, an internal RFLogging error has     *) ! !(* occurred - error 339.                                        *) ! !(*                                                              *) ! !(* Input :                                                      *) ! !(*    (1) rfl_descriptor (contains the system dependent LU      *) ! !(*          among other info)                                   *) ! !(*    (2) request code                                          *) ! !(*                                                              *) ! !(* Returns :                                                    *) ! !(*    (3) return status ( zero if successful)                   *) ! !(*                                                              *) ! !(* The function value false is returned if successful,          *) ! !(*                    true otherwise.                           *) ! !(*                                                              *) ! !(* Called by :                                                  *) ! !(*    (1) rfl_find_end_of_file                                  *) ! !(*    (2) rfl_label_create                                      *) ! !(*    (3) rfl_continuelog                                       *) ! !(*    (4) rfl_endlog                                            *) ! !(*                                                              *) ! !(* Calls :                                                      *) ! !(*    (1) device_control_operation                              *) ! !(*                                                              *) ! !(****************************************************************) !     	$ Heapparms off $  	     FUNCTION device_control     (VAR RFL_descriptor : file_descriptor;         code : device_ctrl_fctn_type;    VAR return_status : short_int) :    BOOLEAN;     VAR 	   dummy : boolean; 	    BEGIN        return_status := zero;   (* assume no error *)     dummy := device_control_operation (       rfl_descriptor.dcb,       code, 
      return_status); 
    IF return_status <> zero THEN       device_control := true    (* error *)    ELSE        device_control := false;  (* no error *)      
END;  (* device_control *) 
 $ PAGE $  !(****************************************************************) ! !(*                                                              *) ! !(* Function Find_RFL_end_of_file                                *) ! !(*                                                              *) ! !(* Purpose : This function finds the end of roll forward log    *) ! !(* file by looking for an eof mark.  It will backspace one      *) ! !(* record to sit on the eof mark.  This function is needed      *) ! !(* when a user mounts the same volume used at the last          *) ! !(* shutdown and DBSPL needs to find out where to continue       *) ! !(* logging.                                                     *) ! !(*                                                              *) ! !(* If a parity error is encountered, the IMAGE parity error     *) ! !(* 335 will be returned.                                        *) ! !(*                                                              *) ! !(* Note : It is expected that the caller has checked that       *) ! !(* the volume mounted corresponds with the volume indicated     *) ! !(* in DBCON.  An EOF mark is also expected to be out there      *) ! !(* for the following reasons:                                   *) ! !(*    If the last roll forward logging session terminated       *) ! !(* normally, DBSPL wrote the eof mark (end_log routine).        *) ! !(* If it did not, then a crash must have occurred (DBSPL        *) ! !(* never aknowledged completion in which case DBMON never       *) ! !(* cleared the crash flag in DBCON).  DBRBR must be executed    *) ! !(* in the case of a crash.  DBRBR recovers the current volume,  *) ! !(* thus writing the eof.  If it cannot, then a flag is set      *) ! !(* within DBCON indicating that a new log set must be defined   *) ! !(* (a new volume, hence this function will not be called).      *) ! !(* Thus the justification.                                      *) ! !(*                                                              *) ! !(* Input:                                                       *) ! !(*    (1) RFL descriptor ( contains fields for the rfl name,    *) ! !(*           status and other system dependent info, such       *) ! !(*           as the dcb)                                        *) ! !(*                                                              *) ! !(* Returns:                                                     *) ! !(*    (2) Return status                                         *) ! !(*        - Zero if successful, positive IMAGE error otherwise  *) ! !(*                                                              *) ! !(* Calls :                                                      *) ! !(*    (1) Device_control                                        *) ! !(*                                                              *) ! !(* Called by:                                                   *) ! !(*    (1) RFL_continuelog                                       *) ! !(*                                                              *) ! !(****************************************************************) !     FUNCTION RFL_find_end_of_file (      VAR RFL_descriptor : file_descriptor;     VAR return_status : short_int) :       BOOLEAN;     LABEL     99;     VAR    end_of_file : BOOLEAN;         BEGIN         (* assume error will occur *)     RFL_find_end_of_file := true;        (* Fast forward until EOF or an error is detected *)     IF device_control ( 
      rfl_descriptor, 
	      forward_file, 	      return_status) THEN        GOTO 99;   (* error *)        (* end_of_file is found, backspace one record *)     IF device_control ( 
      rfl_descriptor, 
       backspace,       return_status) THEN        GOTO 99;     	   (* successful *) 	   RFL_find_end_of_file := false;     99:    (* exit *)      END;  $ page $  (***************************************************************)   (*                                                             *)   (* Procedure wait_loop                                         *)   (*                                                             *)   (* Purpose - This procedure puts DBSPL into a wait loop        *)   !(* while it waits for the user to do something.  For example,  *)  ! !(* when encountering that the mag tape is down, a message      *)  ! !(* is sent to DBMON.  We go into a loop, putting ourselves     *)  ! !(* into the time list (by calling this procedure) and          *)  ! !(* when we return we check to see if the device is ready       *)  ! !(* OR roll forward logging has been terminated.  In the        *)  ! !(* latter case, we terminate.                                  *)  ! !(*                                                             *)  ! !(* Input - none, but uses the following global values          *)  ! !(*         and constants.                                      *)  ! !(*                                                             *)  ! !(*    (1) inactive_wait_time - the number of 10's of           *)  ! !(*        milliseconds to stay in the time list.  This         *)  ! !(*        proc increments that value by the  constant          *)  ! !(*    (2) inactive_wait_increment                              *)  ! !(*    (3) max_inactive_wait_time is the maximum number         *)  ! !(*        of 10's of milliseconds which we wait.               *)  ! (*                                                             *)   (***************************************************************)       
PROCEDURE wait_loop; 
    BEGIN         sleep (inactive_wait_time);  #   inactive_wait_time := inactive_wait_time + inactive_wait_increment; #    IF inactive_wait_time > max_inactive_wait_time THEN       inactive_wait_time := max_inactive_wait_time;      END;  $ Page $  (***************************************************************)   (*                                                             *)   (*  procedure try_request_again                                *)   (*                                                             *)   (*  purpose : to try a tape control request again due to       *)   (*  a tape device problem. It goes into the time list,         *)   (*  sends dbmon a message and tries again.                     *)   (*                                                             *)   (***************************************************************)      
PROCEDURE try_request_again 
   ( VAR request_error : short_int;         request : device_ctrl_fctn_type);     VAR     status : short_int;         BEGIN     
   status := request_error; 
   WHILE (status = request_error) and (status <> zero) DO BEGIN       dummy_boolean := send_message (           msg_reply_code,          request_error,          zero);        (* wait a while *)       inactive_wait_time := max_inactive_wait_time;        wait_loop;       (* perhaps logging has been disabled or IMAGE shutdown *)       check_image_status ( status);       (* no change in status - try again *)        IF status = request_error THEN           dummy_boolean := device_control ( 
            rfl_descriptor, 
 
            request, 
	            status) 	       ELSE  (**) (* If logging is disabled or image shutdown, terminate.  (* Check_image_status would return dbspl_terminating_warn_code  (* Set the abnormal_finish flag because users would or could (* not get the device ready, so we can't terminate normally 
(* by writing an eof. 
 (**)          abnormal_finish := true;    (* global var *)      
    END; (* while *) 
        request_error := status;  (* return our status *)          (**)     (* If all is well now, tell DBMON so it can clear its spool 	    (* error flag . 	     (**)      IF request_error = zero THEN         dummy_boolean := send_message (            to_bm_spl_contlog_reply_mesg_code,           zero,  (* no error *)           zero); (* meaningless here *)          END;  (* proc try_request_again *)  $ page $  (***************************************************************)   !(*                                                             *)  ! !(* Function RFL_label_create                                   *)  ! !(*                                                             *)  ! !(* Purpose : This function creates the roll forward log        *)  ! !(* label and writes it to the roll forward log - the           *)  ! !(* first block of the file (disc or device).                   *)  ! !(*                                                             *)  ! !(* Assumption : This function assumes that the roll forward    *)  ! !(*    log file has been created and opened.                    *)  ! !(*                                                             *)  ! !(* Input :                                                     *)  ! !(*    (1) rfl descriptor (contains the name, size and other    *)  ! !(*                        roll forward log information)        *)  ! !(*    (2) dbcon block which contains information about         *)  ! !(*           the roll forward log.                             *)  ! !(*                                                             *)  ! !(* Returns :                                                   *)  ! (*    (3) RFL label                                            *)   (*    (4) return status                                        *)   (*                                                             *)   (* Called by :                                                 *)   (*   (1) RFL_continuelog                                       *)   (*                                                             *)   (* Calls :                                                     *)   (*   (1) device_control                                        *)   (*   (2) do_block_transfer                                     *)   (*                                                             *)   (***************************************************************)      FUNCTION RFL_label_create     ( VAR rfl_descriptor : file_descriptor;       VAR dbcon_rfl_info_block : dbcon_rfl_info_block_type;       VAR rfl_label : rfl_label_type;      VAR return_status : short_int) :    BOOLEAN;     LABEL 99;          CONST  
   rfl_label_block_num = 1; 
     TYPE  '   label_and_eof_block_type =   (* scratch area for new label with eof blk *)  '       RECORD           labl : rfl_label_type;            eof_block : disc_block;        END;      VAR      rfl_start_header : label_and_eof_block_type;           BEGIN          (* assume error *)      RFL_label_create := true;        (* form the label *)     WITH rfl_label, dbcon_rfl_info_block DO BEGIN        reserved := current_rev_num;        logical_beg_of_tuf := rfl_start_block;        log_set_name := rflf_set_name; 
      vol_name := rfl_name; 
       vol_num := rflf_vol_num;       logical_vol_name := rfl_logical_name;       current_eof_blk := rfl_start_block;  %      blks_remaining := rfl_descriptor.fsize - one; (* less label block *) %       END;        WITH rfl_start_header DO BEGIN        labl := rfl_label;        eof_block := rfl_eof_block_constant;  
      END;  (* end with *) 
           IF is_tape_file(rfl_descriptor) THEN BEGIN     
      (* rewind the tape *) 
      IF device_control (                 rfl_descriptor,                 rewind,                 return_status) THEN BEGIN                 try_request_again (return_status,rewind);                 IF return_status <> zero THEN                GOTO 99; 	               END; 	          (* write label *)        IF do_block_transfer (  
               write_code, 
                rfl_descriptor, 	               one, 	               num_blks_in_rfl_label,                 rfl_start_header.labl.reserved,                 return_status) THEN                GOTO 99;                 (* Note that an eof is not written until end log *)            END  (* end then is magtape *)        ELSE BEGIN (* rfl volume is a disc file *)           rfl_start_header.eof_block := rfl_eof_block_constant;        IF do_block_transfer (  
               write_code, 
                rfl_descriptor,                rfl_label_block_num,                 num_blks_for_label_and_eof,                 rfl_start_header.labl.reserved,                 return_status) THEN                IF return_status = disc_failure_err THEN BEGIN                    return_status := rfl_access_err;  
                  GOTO 99; 
                   END;            END;  (* end is disc_file *)          !   (* update the history entry for this roll forward log volume *) !    IF read_history_table_entry (        dbcon_descriptor,         lock_dbcon_file,  %      rfl_label.vol_num,  (* history table entry index - current volume *) % 
      history_table_entry, 
       return_status) THEN BEGIN         return_status := rfl_dbcon_access_err;        GOTO 99;        END;         history_table_entry.used_volume_flag := true;         IF write_history_table_entry (         dbcon_descriptor,         unlock_dbcon_file,        rfl_label.vol_num,  
      history_table_entry, 
       return_status) THEN BEGIN         return_status := rfl_dbcon_access_err;        GOTO 99;        END;             (**)      (* Update the RFL info block to show volume is initialized.     (**)          WITH dbcon_block.dbcon_rfl_info_block DO BEGIN             IF read_dbcon_table (dbcon_descriptor,                             dbc_rfl_info_blk,                             lock_dbcon_file,                              block,                              return_status)   
         THEN BEGIN  
             return_status := rfl_dbcon_access_err;  
            GOTO 99; 
             END;            rfl_new_log := false;  (* volume has been initialized *)            IF write_dbcon_table (dbcon_descriptor,                               dbc_rfl_info_blk,                               unlock_dbcon_file,                              block,                              return_status)  
         THEN BEGIN  
             return_status := rfl_dbcon_access_err;  
            GOTO 99; 
             END;            END; (* with dbcon rfl info block *)         
   (* all is well! *) 
   RFL_label_create := false;     99:     END;  (* end rfl_label_create fctn *)         $ Heapparms off $ FUNCTION get_new_roll_forward_log     ( VAR rfl_descriptor : file_descriptor;       VAR rfl_label : rfl_label_type;          parity_flag : BOOLEAN;      VAR chunk_seq_num : short_int;       VAR return_status : short_int) : BOOLEAN;    FORWARD;      $ PAGE $  !(****************************************************************) ! !(*                                                              *) ! !(* Function RFL_chunk_io;                                       *) ! !(*                                                              *) ! !(* Purpose : This function                                      *) ! !(*    (1) writes a chunk to the RFL                             *) ! !(*    (2) reads a chunk from the RFL                            *) ! !(*                                                              *) ! !(* Input :                                                      *) ! !(*    (1) Chunk buffer address which is                         *) ! !(*         - the source for a write                             *) ! !(*         - the destination for a read                         *) ! !(*    (2) Starting block number within RFL, which is            *) ! !(*         - the destination for a write                        *) ! !(*         - the source for a read                              *) ! !(*    (3) Number of blocks to read/write                        *) ! !(*    (4) RFL descriptor                                        *) ! !(*    (5) RFL label                                             *) ! !(*                                                              *) ! !(* Returns:                                                     *) ! !(*    (6) status                                                *) ! !(*                                                              *) ! !(* Called by :                                                  *) ! !(*    (1) spool_chunk                                           *) ! !(*    (2) end_log                                               *) ! !(*                                                              *) ! !(* Calls:                                                       *) ! !(*    (1) do_block_transfer                                     *) ! !(*                                                              *) ! !(****************************************************************) !    $ Heapparms off $     
FUNCTION RFL_chunk_io 
   ( VAR buffer : rfl_tape_buffer_type;           start_block : long_int;       VAR num_blocks_to_xfer : short_int;       VAR RFL_descriptor : file_descriptor;      VAR RFL_label: rfl_label_type;      VAR return_status : short_int) :    BOOLEAN;     LABEL 99;      (**) 
(* rfl_io_time global used. 
 (**)         VAR    last_block_xferred : long_int;     next_word : long_int;  
   num_blocks : short_int; 
   dummy : short_int; 
   get_new_rfl : boolean;    parity_flag : boolean;    rfl_type : boolean;  (* is rfl volume a tape? *)          PROCEDURE try_while_not_ready;      VAR      error : short_int;   
   go_to_sleep : boolean;  
    BEGIN        (* if the device was not ready, keep trying *)    IF return_status = rfl_device_not_ready_err THEN BEGIN           (* tell DBMON about it *)        dummy_boolean :=  send_message (           msg_reply_code,           rfl_device_not_ready_err,          zero);      
      go_to_sleep := true; 
           WHILE (go_to_sleep) DO BEGIN               (* go to sleep for a while *)           inactive_wait_time := max_inactive_wait_time; 	         wait_loop; 	             (**)            (* If logging is disabled or image shtudown, terminate.   $         (* Check_image_status would return dbspl_terminating_warn_code  $ #         (* Set the abnormal_finish flag because users would or could  # "         (* not get the device ready, so we can't terminate normally "          (* by writing an eof.           (**)            check_image_status ( return_status);   !         IF return_status = dbspl_terminating_warn_code THEN BEGIN !             abnormal_finish := true;              go_to_sleep := false;               END;               IF go_to_sleep THEN BEGIN                  (**)             (* nope - logging still on , try again.  &            (* We may hang on this try if the device 'eqt' (system dependent & $            (* term) is down.  Once it is 'upped', the call will go thru $             (* although the device itself may still not be ready.               (**)                 return_status := zero;  (* reset error *)                  rfl_io_time := get_start_time;                  IF do_block_transfer (  
               write_code, 
                rfl_descriptor, 
               start_block, 
                num_blocks_to_xfer,                buffer.wds[one],                return_status) THEN;                  rfl_io_time := get_elapsed_time (rfl_io_time);                  IF return_status = zero THEN                 go_to_sleep := false;  
            END;  (* if *) 
              END;  (* end while *)           (* if it still did not complete, return the status *)     IF return_status <> zero THEN        GOTO 99;         END (* end if rfl_device_not_ready *)      END; (* procedure try_while_not_ready *)          BEGIN (* begin rfl_chunk_io *)     
   (* assume error *) 
    rfl_chunk_io := true;     get_new_rfl := false;         (* if the roll forward log is a disc file, add an eof block *)     rfl_type := is_tape_file (rfl_descriptor);         IF NOT (rfl_type) THEN BEGIN  (* rfl is a disc *)     "      (* add an eof block - 'buffer' starts at block one, not zero *) "      num_blocks := num_blocks_to_xfer + one;       buffer.blk[num_blocks] := rfl_eof_block_constant;            END   (* end if *)        ELSE       num_blocks := num_blocks_to_xfer;            (* Can buffer fit in what is left of log? *)      IF (NOT rfl_type) AND (num_blocks > rfl_label.blks_remaining)        THEN return_status := fmp_bof_eof_err (* simulated *)            ELSE BEGIN (* attempt the write to tape or not-full file *)               (**)           (* Write chunk to the roll forward log.          (**)              rfl_io_time := get_start_time;              IF do_block_transfer (               write_code,               rfl_descriptor,  !              start_block,       (* no meaning if rfl is device *) !              num_blocks,                buffer.wds[one],                return_status) THEN;               END; (* else *)        IF return_status <> 0 THEN BEGIN      $      (* if device not ready - keep trying until ready or log disable *) $       IF return_status = rfl_device_not_ready_err THEN BEGIN          try_while_not_ready;          (* tell dbmon we're ready now *)           dummy_boolean := send_message (              to_bm_spl_contlog_reply_mesg_code,             zero,              zero);     (* meaningless *)                 END;  (* then tape went down *)            (**) !      (* Note - the rfl file is opened non-extendible, thus we will !       (* switch to the spare when the file becomes full.        (*        (* Have we run out of space on the current volume?       (* If so, use the spare RFL volume.        (*        (* Have we run into a parity error ?       (* If so, use the spare RFL volume.        (**)     
      parity_flag := false; 
          IF NOT is_tape_file (rfl_descriptor) THEN BEGIN               (* disc file *)               CASE return_status OF              bof_eof_err,              fmp_bof_eof_err :  BEGIN                get_new_rfl := true;                return_status := rfl_full_warn_code; 	               END; 	                otherwise get_new_rfl := false;                  END;  (* case *)           END            ELSE BEGIN (* magtape *)           IF (return_status = rfl_end_of_tape_err) THEN BEGIN              get_new_rfl := true;              return_status := rfl_full_warn_code;  
            END;  (* if *) 
             IF (return_status = rfl_parity_err) THEN BEGIN              (* tell dbmon *)             dummy_boolean := send_message (                         msg_reply_code,                         rfl_parity_err,                          zero);             (* set rfl corrupt flag within DBCON *)             set_rfl_corrupt_flag (Return_status);              (* We will terminate because return status <> zero;*)               (* this will occur in the main.   *)              END;           END;  (* else mag tape *)               IF get_new_rfl THEN BEGIN      $         (* send a message to DBMON indicating that the return status *) $          dummy_boolean := send_message ( 
            msg_reply_code, 
 
            return_status, 
 	            zero); 	             (* get new rfl volume *)           IF get_new_roll_forward_log ( 
            rfl_descriptor, 
             rfl_label,  	            false, 	 	            dummy, 	            return_status) THEN  
            GOTO 99; 
             (**)  #         (* If we switched from a (a) file to tape, don't write an eof #          (* block   (b) tape to file, append an eof block.          (**)           IF (NOT rfl_type) AND is_tape_file (rfl_descriptor) THEN               num_blocks := num_blocks - one          ELSE              IF (rfl_type) AND (NOT is_tape_file (rfl_descriptor))                 THEN BEGIN                 num_blocks := num_blocks + one;                  buffer.blk[num_blocks] := rfl_eof_block_constant;  	               END; 	    #         (* rewrite the chunk to the beginning of the new rfl volume *) #          start_block := rfl_label.current_eof_blk;              rfl_io_time := get_start_time;              IF do_block_transfer (             write_code, 
            rfl_descriptor, 
             start_block,             num_blocks,              buffer.wds[one],             return_status) THEN      $            try_while_not_ready    (* invoke this proc to keep trying *) $                                    (* the request *)             ELSE rfl_io_time := get_elapsed_time (rfl_io_time);                 END;  (* end if need to get new rfl volume *)           END  (* end if error on block transfer *)     ELSE (* original write succeeded *)        rfl_io_time := get_elapsed_time (rfl_io_time);         (* error ? *)     IF return_status <> zero THEN        GOTO 99;        (**)     (* On successful writes, update the rfl label     (* (though it is actually meaningless if rfl is a device) .    (**)        (* update the rfl label *)  
   WITH rfl_label DO BEGIN 
       current_eof_blk := current_eof_blk + num_blocks_to_xfer;        blks_remaining := blks_remaining - num_blocks_to_xfer;        END;  (* with *)     
   (* all is well! *) 
   rfl_chunk_io := false; 99:      END;      $ PAGE $  !(****************************************************************) ! !(*                                                              *) ! !(* Procedure RFL_endlog                                         *) ! !(*                                                              *) ! !(* Purpose : The routine is called when roll forward logging    *) ! !(* is disabled, whether it is done explicitly  (through         *) ! !(* DBUTL's logging change command) or implicitly when           *) ! !(* DBMON is shutdown.  The RFL label contains the current eof   *) ! !(* block number.                                                *) ! !(*                                                              *) ! !(* Input :                                                      *) ! !(*    (1) RFL descriptor (contains rfl name, status and other   *) ! !(*           system dependent information)                      *) ! !(*    (2) RFL label                                             *) ! !(*    (3) flag indicating whether we should dump out what is    *) ! !(*           remaining in the buffer                            *) ! !(*                                                              *) ! !(* Output :                                                     *) ! !(*    (4) return status                                         *) ! !(*                                                              *) ! !(* Called by:                                                   *) ! !(*    (1) terminate_dbspl                                       *) ! !(*    (2) get_new_roll_forward_log                              *) ! !(*                                                              *) ! !(*                                                              *) ! !(* Calls:                                                       *) ! !(*    (1) Do_block_transfer                                     *) ! !(*    (2) device_control                                        *) ! !(*    (3) close_file                                            *) ! !(*                                                              *) ! !(****************************************************************) !     	$ Heapparms off $  	     PROCEDURE RFL_endlog (     VAR RFL_descriptor : file_descriptor;     VAR rfl_label : rfl_label_type;         buffer_dump_flag : boolean;     VAR return_status : short_int) ;       LABEL      99;     VAR     num_blks_in_spl_buffer : short_int;         BEGIN        IF buffer_dump_flag THEN BEGIN            (* write out what remains in our spool buffer *)       num_blks_in_spl_buffer := next_spl_buf_blk_num - one;       IF rfl_chunk_io (  
         spl_buffer, 
         rfl_label.current_eof_blk,           num_blks_in_spl_buffer,           rfl_descriptor, 	         rfl_label, 	          return_status) THEN          GOTO 99;  
      END;  (* if *) 
       next_spl_buf_blk_num := one;          
   (* Write an eof mark *) 
        IF NOT is_tape_file (rfl_descriptor) THEN BEGIN 
      (* disc file *) 
           IF do_block_transfer (               write_code,               RFL_descriptor,                RFL_label_block_num,                num_blks_in_rfl_label,               rfl_label.reserved,               return_status) THEN                GOTO 99;            END   (* disc file case *)     
   ELSE BEGIN (* magtape *) 
          IF device_control (                 rfl_descriptor,                write_eof,                 return_status) THEN BEGIN 	               (**) 	 "               (* Probably the device is off-line.  For this special "                (* case (writing the eof can be dangerous), !               (* treat this as a fatal error because we don't know !!               (* where the tape is positioned at this point (maybe !"               (* a different tape is mounted).  Let DBRBR recover it "                (* and write the eof. 	               (**) 	                IF return_status <> zero THEN  
                  GOTO 99; 
	               END; 	          END; (* magtape case *)             (* close the roll forward log file *)     dummy_boolean := close_file ( 
      rfl_descriptor, 

      return_status); 
    99:      END;  (* procedure endlog *)  $ Page $  !(****************************************************************) ! !(*                                                              *) ! !(*  Function Get_new_roll_forward_log                           *) ! !(*                                                              *) ! !(*  Purpose : This function is called when it is necessary to   *) ! !(*  get a  new roll forward log.  It is called upon the         *) ! !(*  following conditions :                                      *) ! !(*     - the current volume is full (eot encountered)           *) ! !(*     - a parity error on the rfl is encountered               *) ! !(*                                                              *) ! !(*  Input :                                                     *) ! !(*     (1) parity error flag (true if parity error, else false) *) ! !(*     (2) chunk sequence number (only if PE occurred)          *) ! !(*                                                              *) ! !(*  Returns :                                                   *) ! !(*     (3) return status (0:no occur, n: IMAGE error number)    *) ! !(*                                                              *) ! !(*  Called by:                                                  *) ! !(*                                                              *) ! !(*                                                              *) ! !(*  Calls :                                                     *) ! !(*                                                              *) ! !(****************************************************************) !         FUNCTION get_new_roll_forward_log;         $ Heapparms off $     LABEL     99;     VAR  $   new_rfl_logical_name : short_str;    (* new rflf logical user name *) $
   new_vol_num : short_int; 
"   dbcon_block : dbcon_table_type;      (* use a local copy of the *) " #                                        (* dbcon block so as not to *) # #                                        (* interfere with caller's  *) # #                                        (* use of global defn of it *) #   dummy_status    : short_int;    status          : short_int;  "   spare_opened    : boolean;           (* Has spare been opened? *) " &   dbmon_informed  : boolean;           (* Does DBMON know we need spare? *) &    BEGIN     
   (* assume error *) 
    get_new_roll_forward_log := true;        (**)     (* Get the spare rfl volume from DBCON - if it does not    (* exist, return an error.    (**)         IF read_dbcon_block (       dbcon_descriptor,       dbc_rfl_info_blk,       do_not_lock_dbcon_file,  	      dbcon_block, 	      return_status) THEN BEGIN        return_status := rfl_dbcon_access_err;        GOTO 99;        END;         (* Does a spare exist? *)     IF dbcon_block.dbcon_rfl_info_block.srfl_name = ' ' THEN BEGIN        return_status := spare_rfl_undefined_err;           (* tell dbmon about it *)       dummy_boolean := send_message (           msg_reply_code,          spare_rfl_undefined_err,          zero);            (* Turn the "can't shut down" flag on *)        IF read_dbcon_block (dbcon_descriptor,                             dbc_status_blk,                            lock_dbcon_file,                            dbcon_block,                            dummy_status) THEN BEGIN          return_status := rfl_dbcon_access_err;          GOTO 99;          END;            dbcon_block.dbcon_status_block.flag.cant_shut_down := true;            IF write_dbcon_block (dbcon_descriptor,                             dbc_status_blk,                              unlock_dbcon_file,                              dbcon_block,                              dummy_status) THEN BEGIN          return_status := rfl_dbcon_access_err;          GOTO 99;          END;     $      (* loop until either one is defined or logging/IMAGE is disabled *) $       WHILE (return_status = spare_rfl_undefined_err) DO BEGIN               wait_loop;   (* go to sleep for a little while *)              IF read_dbcon_block (dbcon_descriptor,                               dbc_rfl_info_blk,                               do_not_lock_dbcon_file,                                dbcon_block,                                status) THEN BEGIN              return_status := status;  
            GOTO 99; 
             END;      $         IF dbcon_block.dbcon_rfl_info_block.srfl_name <> ' ' THEN BEGIN $                return_status := zero; (* a spare was defined! *)             (* tell dbmon we're okay now *)             dummy_boolean := send_message (                to_bm_spl_contlog_reply_mesg_code,  
               zero, 

               zero); 
            END          ELSE                  (**) "            (* Check to see if roll forward logging has been disabled "            (* or IMAGE shutdown. %            (* If so, (return_status will be 'dbspl_terminating_warn_code') % #            (* then terminate dbspl gracefully ( return_status checked #             (* in the main).              (**)     "            check_image_status (return_status);   (* state change? *) "              END;  (* end while *)           (* Turn off the "can't shut down" flag *)        IF read_dbcon_block (dbcon_descriptor,                             dbc_status_blk,                            lock_dbcon_file,                            dbcon_block,                            return_status)           THEN GOTO 99;      !      dbcon_block.dbcon_status_block.flag.cant_shut_down := false; !          IF write_dbcon_block (dbcon_descriptor,                             dbc_status_blk,                              unlock_dbcon_file,                              dbcon_block,                              return_status)           THEN GOTO 99;      
      END;  (* if *) 
    $   (* Was logging terminated or shutdown? If so, return_status <> zero *) $$   (* In that case, return_status was set by check_image_status above. *) $    IF return_status <> zero THEN        (* return to main which will call terminate_dbspl *)        GOTO 99;             (* If normal end of volume is encountered, write EOF *)     IF NOT (parity_flag) THEN BEGIN  	      rfl_endlog ( 	          rfl_descriptor,  
         rfl_label,  
 "         false,    (* do not write out what remains in our buffer *) "          return_status);        IF return_status = rfl_end_of_tape_err THEN            return_status := zero  
      END  (* if *)  
    ELSE (* just close it *)         dummy_boolean := close_file (            rfl_descriptor,           return_status);     IF return_status <> zero THEN        GOTO 99;        (**)    (* Give the new RFL volume the spare's file description.    (**)     
   dbmon_informed := false; 
       REPEAT (* until spare log is opened *)            IF read_dbcon_block (dbcon_descriptor,                         dbc_rfl_info_blk,                         do_not_lock_dbcon_file,                          dbcon_block,                          return_status) 	      THEN GOTO 99; 	     #   rfl_descriptor.newfl := dbcon_block.dbcon_rfl_info_block.srfl_name; #       IF open_existing_non_extendible (rfl_descriptor,                                      true,  (* exclusive *)                                     return_status) THEN BEGIN            IF NOT dbmon_informed THEN BEGIN           (* Tell DBMON we had trouble opening the spare *)          dummy_boolean := send_message (msg_reply_code,                                          spare_rfl_missing_err,                                          zero);           dbmon_informed := true;          END;           (* Sleep for a while to avoid CPU-bound loop *)        wait_loop;           check_image_status (return_status);        IF return_status = dbspl_terminating_warn_code           THEN GOTO 99;        END  (* then error opening file *)           ELSE spare_opened := true; (* no error opening spare *)         UNTIL spare_opened;        (**)     (* At this point, the spare is open    (* so update the rfl info block in the DBCON file.    (**)        WITH dbcon_block.dbcon_rfl_info_block DO BEGIN            IF read_dbcon_block (dbcon_descriptor,                             dbc_rfl_info_blk,                            lock_dbcon_file,                            dbcon_block,                            return_status)           THEN GOTO 99;            (* Change the appropriate fields in DBCON *)           new_vol_num := succ (rflf_vol_num);        rflf_vol_num := new_vol_num;        rfl_name := srfl_name;  
      rfl_new_log := true; 
       rfl_logical_name := srfl_logical_name;       srfl_name := ' ';       srfl_logical_name := ' '; &      new_rfl_logical_name :=  rfl_logical_name;  (* Save the logical name *) &&                                                  (* to update table later.*) &
      rfl_new_log := false; 
           (* write the rfl info_block back to dbcon *)       IF write_dbcon_block (dbcon_descriptor,                             dbc_rfl_info_blk,                              unlock_dbcon_file,                              dbcon_block,                             return_status) THEN BEGIN          return_status := rfl_dbcon_access_err;          GOTO 99;          END;           END;  (* with dbcon rfl info block *)        (**)    (* Continue the rfl onto the next volume - need label.    (*    (**)        IF rfl_label_create (              (* will lock dbcon *) 
      rfl_descriptor, 
      dbcon_block.dbcon_rfl_info_block,        rfl_label,       return_status) THEN        GOTO 99;        (* Get the history table from DBCON *)        IF read_history_table_entry (dbcon_descriptor,                                  lock_dbcon_file,                                  new_vol_num,                                  history_table_entry,                                 return_status) THEN BEGIN        return_status := rfl_dbcon_access_err;        GOTO 99;        END;         (* Update the old rfl volume info in the history table *)     WITH history_table_entry DO BEGIN            create_timestamp (end_time);       log_name := rfl_descriptor.newfl;       logical_name := new_rfl_logical_name;       num_subvolumes := zero;      
      END;  (* end with *) 
       (* write the history table back *)     IF write_history_table_entry (dbcon_descriptor,                                  unlock_dbcon_file,                                  new_vol_num,                                  history_table_entry,                                   return_status) THEN BEGIN        return_status := rfl_dbcon_access_err;        GOTO 99;        END;        (* no error *)    get_new_roll_forward_log := false;         (* send message to DBMON saying we are using the spare *)     dummy_boolean := send_message ( 
      msg_reply_code, 

      rfl_switch_warn_code, 
       zero);      99 :      END;  $ PAGE $  !(****************************************************************) ! !(*                                                              *) ! !(* Procedure RFL_continuelog                                    *) ! !(*                                                              *) ! !(* Purpose : This procedure is called when roll forward logging *) ! !(* is enabled within DBMON.  It opens the DBCON file to         *) ! !(* retrieve information concerning the current roll forward log *) ! !(* volume.  If the volume is new (indicated in the DBCON file   *) ! !(* by DBUTL when a rfl log volume is defined), then a label     *) ! !(* is created. IF the volume is not new, then the beginning of  *) ! !(* volume is found.  This procedure also opens the transaction  *) ! !(* log file (opened shared with DBMON) for future reads and     *) ! !(* the DBCON file.                                              *) ! !(*                                                              *) ! !(* Input:  nothing                                              *) ! !(*                                                              *) ! !(* Returns:                                                     *) ! !(*    (1)  RFL_descriptor ( contains the file name, status      *) ! !(*            type, and other system dependent info)            *) ! !(*    (2)  RFL label ( volume label block)                      *) ! !(*    (3)  tlf_descriptor                                       *) ! !(*    (4)  Return status ( zero or positive IMAGE error)        *) ! !(*                                                              *) ! !(* Calls:                                                       *) ! !(*    (1)  Device_control                                       *) ! !(*    (2)  End_of_tape_check                                    *) ! !(*    (3)  RFL_label_create                                     *) ! !(*                                                              *) ! !(* Called by:                                                   *) ! !(*    (1)  DBSPL main                                           *) ! !(*                                                              *) ! !(*                                                              *) ! !(****************************************************************) !         
PROCEDURE RFL_continuelog  
    ( VAR RFL_descriptor : file_descriptor;       VAR RFL_label : rfl_label_type;       VAR tlf_descriptor : file_descriptor;       VAR return_status : short_int);          LABEL      99;      VAR   
   dummy : boolean;  
     (**)  
(* global variables used : 
 (*   dbcon_descriptor - descriptor for the file DBCON   (*   dbcon_block - variable record which is a block of DBCON info   (**)     BEGIN         (* read the rfl info block *)     IF read_dbcon_block (       dbcon_descriptor,       dbc_rfl_info_blk,       do_not_lock_dbcon_file,  	      dbcon_block, 	      return_status) THEN BEGIN        return_status := rfl_dbcon_access_err;        GOTO 99;        END;         (* get the rfl file desciptor from dbcon *) "   rfl_descriptor.newfl := dbcon_block.dbcon_rfl_info_block.rfl_name; "        (* Open the roll forward log *)    IF open_existing_non_extendible (rfl_descriptor,                                     true, (* exclusive *)                                     return_status) THEN BEGIN        return_status := rfl_open_err;        GOTO 99;        END;             (* Do we need to create a new label? i.e. new RFL? *)        WITH dbcon_block.dbcon_rfl_info_block DO         IF rfl_new_log THEN BEGIN        (* create the label *) 
      IF rfl_label_create ( 
          rfl_descriptor,           dbcon_block.dbcon_rfl_info_block, 	         rfl_label, 	          return_status) THEN BEGIN           return_status := rfl_access_err;   	         GOTO 99;  	          END;            (* update the 'new rfl' flag *) 
      rfl_new_log := false; 
           END (* end if new log *)         ELSE BEGIN  (* not new - read the existing label *)            (* Is the RFL a disc file or tape device? *)       IF NOT is_tape_file (rfl_descriptor) THEN BEGIN           (* disc file *)              (**)          (* Read the RFL label.          (**)              IF do_block_transfer (                read_code,                 rfl_descriptor,                rfl_label_block_num,                 num_blks_in_rfl_label,   (* constant *)                rfl_label.reserved,      (* returns *)                 return_status) THEN                GOTO 99;                   END  (* disc file type *)            ELSE BEGIN (* magtape *)               (* Rewind the tape *) 
         If device_control( 
                rfl_descriptor,                 rewind,                 return_status) THEN BEGIN                 try_request_again (return_status,rewind);                 IF return_status <> zero THEN  
                  GOTO 99; 
               END;  (* if *)              (* Read the label *)          IF do_block_transfer (                read_code,                 rfl_descriptor, 	               one, 	               num_blks_in_rfl_label,                 rfl_label.reserved,                 return_status) THEN BEGIN                    IF return_status = rfl_dev_xfer_len_err THEN  %                     (* rec length of rec read is not the rfl label len *) %                      return_status := bad_or_not_rfl_tape_err;  
                  GOTO 99; 
                   END;  (* end if error *)                  END;  (* else magtape *)               (* Is this a legitimate label? *)       IF (RFL_label.reserved <> current_rev_num) THEN BEGIN           return_status := bad_or_not_RFL_tape_err;          GOTO 99;          END;           (* Is this the correct volume? *)       WITH RFL_label, dbcon_block.dbcon_rfl_info_block DO          IF (vol_num  <> rflf_vol_num)   OR          (log_set_name <> rflf_set_name) OR           (vol_name <> rfl_name) THEN BEGIN             return_status := rfl_wrong_vol_err;  
            GOTO 99; 
             END;  (* end if *)          %      (* if we are dealing w/tape, we need to get to the right position *) %      IF is_tape_file (rfl_descriptor) THEN BEGIN              (* fast forward until an eof is encountered *)           IF rfl_find_end_of_file (                 RFL_descriptor,                 return_status) THEN BEGIN                 IF return_status = rfl_end_of_tape_err THEN                   IF get_new_roll_forward_log (                       rfl_descriptor,                      rfl_label, 
                     false, 
                     dummy_short_int,                       return_status) THEN                         GOTO 99  
                ELSE 

                   GOTO 99; 
                 END;  (* end if *)             END;  (* if mag tape *)              END;  (* else not new rfl *)          %   (* Open the transaction log file - but first get the name from DBCON *) %    IF read_dbcon_block (       dbcon_descriptor,       dbc_tlf_info_blk,       do_not_lock_dbcon_file,  	      dbcon_block, 	      return_status) THEN BEGIN        return_status := rfl_dbcon_access_err;        GOTO 99;        END;     "   tlf_descriptor.newfl := dbcon_block.dbcon_tlf_info_block.tlf_name; "     
   IF open_existing_file ( 
      tlf_descriptor, 
      return_status) THEN        GOTO 99;     99:      END;  $ page $  #(********************************************************************) # #(*                                                                  *) # #(* Procedure spool_chunk                                            *) # #(*                                                                  *) # #(* Purpose : This procedure writes a TUF chunk from the             *) # #(* TUF to the spool buffer.  If the spool buffer is full, then      *) # #(* the buffer is written to the roll forward log file.  Chunks      *) # #(* never cross spool buffer boundaries.                             *) # #(*                                                                  *) # #(* Input :                                                          *) # #(*    (1) TUF descriptor                                            *) # #(*    (2) RFL descriptor                                            *) # #(*    (3) RFL label                                                 *) # #(*                                                                  *) # #(* Returns :                                                        *) # #(*    (3) return status                                             *) # #(*                                                                  *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE spool_chunk (      VAR tlf_descriptor : file_descriptor;     VAR rfl_descriptor : file_descriptor;     VAR rfl_label : rfl_label_type;     VAR return_status : short_int) ;       LABEL 99;       (**)  (* Global variable updated :  (*      last_spooled_block : long_int;  (**)      VAR      start_block_num : long_int;     num_blks_to_spl : short_int;      num_blks_in_spl_buffer : short_int;     save_start_block: long_int;      BEGIN          last_spooled_block := zero;      $   IF NOT (okay_to_spool) THEN BEGIN (* never got msg to continuelog *)  $       return_status := dbmon_spool_init_err;        GOTO 99;        END;  (* if not okay to spool *)         WITH message.dbspl.spool DO BEGIN        start_block_num := start_block;         num_blks_to_spl :=  end_block - start_block + one;        save_start_block := start_block;  
      END;  (* End with *) 
        (* message error check *)     IF (num_blks_to_spl < zero) OR   $      (num_blks_to_spl * words_in_disc_block > tub_word_size) THEN BEGIN $      return_status := corrupt_message_err;        GOTO 99;        END;        (* Is there room in the buffer? *)  %   num_blks_in_spl_buffer := next_spl_buf_blk_num + num_blks_to_spl - one; %     !   IF (num_blks_in_spl_buffer > max_blks_in_spl_buffer) THEN BEGIN !    $      num_blks_in_spl_buffer := num_blks_in_spl_buffer - num_blks_to_spl; $       (* write the buffer to the roll forward log *)       IF rfl_chunk_io (  
         spl_buffer, 
 !         rfl_label.current_eof_blk,  (* start block/word of rfl *) !          num_blks_in_spl_buffer,           rfl_descriptor, %         rfl_label,                  (* is returned wth updated rfl info *) %          return_status) THEN          GOTO 99;            next_spl_buf_blk_num := one;     	      END  (* if *) 	   ELSE        (**)  #      (* Don't send dbmon a reply since we haven't written anything to #      (* the rfl.        (**)       flag_send_message := false;            IF do_block_transfer (        read_code, 
      tlf_descriptor, 
       start_block_num,        num_blks_to_spl,  %      spl_buffer.wds[(next_spl_buf_blk_num - 1)* words_in_disc_block + 1], %!      return_status) THEN BEGIN           (* 'wds' begin at zero *) !      return_status := tlf_disc_io_err;  %      flag_send_message := true;   (* be sure to tell dbmon about error *) %       GOTO 99;        END;      !   next_spl_buf_blk_num := next_spl_buf_blk_num + num_blks_to_spl; !           (**)     (* If we have to do immediate posting, call rfl_chunk_io to    (* write out the blocks we just read from the TLF.    (**)         IF post_rfl_immediate THEN BEGIN  (* post that buffer! *)            IF rfl_chunk_io (spl_buffer,                        rfl_label.current_eof_blk,                        num_blks_to_spl,                         rfl_descriptor,                        rfl_label,                        return_status)           THEN GOTO 99;             next_spl_buf_blk_num := one;   (* reset buffer to empty *)       $      flag_send_message := true;  (* Have DBSPL send a reply to DBMON *) $           END; (* immediate posting *)            (* save the TUF block number of the last block we spooled *)     last_spooled_block := save_start_block; 99:      END;   (* spool chunk *)  $ Page $  !(****************************************************************) ! !(*                                                              *) ! !(* Procedure terminate_dbspl                                    *) ! !(*                                                              *) ! !(* Purpose : To terminate gracefully.                           *) ! !(*                                                              *) ! !(****************************************************************) !     
PROCEDURE terminate_dbspl( 
    VAR rfl_descriptor : file_descriptor;     VAR rfl_label : rfl_label_type;     VAR tlf_descriptor : file_descriptor;     VAR return_status : short_int);      (**)  (* Global variable updated :  
(*      continue : boolean 
 (**)      VAR   
   dummy : boolean;  
    status : short_int;      BEGIN          (* end rfl logging *)         (**)   "   (* If we were called in a normal fashion, end RF logging nicely.  "    (* But if we were called due to a fatal RF error, then       (* don't do anything more with the rfl because it had errors       (**)          IF (return_status = dbspl_terminating_warn_code) AND         NOT (abnormal_finish)  THEN   	      rfl_endlog ( 	          rfl_descriptor,  
         rfl_label,  
          true,  (* write out whats left in the buffer *)  	         status);  	        (* close transaction log file *)          dummy := close_file (        tlf_descriptor,         status);      
   (* close dbcon *) 
    dummy := close_file (       dbcon_descriptor,        status);         &   continue := false;  (* Clear the global flag which indicates that DBSPL *) &&                       (* should continue to process messages.             *) &    END;  (* end terminate_dbspl *)  $ Page $  #(********************************************************************) # #(*                      MAIN CODE                                   *) # #(********************************************************************) #     BEGIN (* DBSPL main program *)      
   okay_to_spool := false; 
 
   continue := true; 
   initialize;   (* initialize DBSPL *)         (* detach from session, if in session environment *)      detach_from_session (dummy_short_int);          WHILE (continue) DO BEGIN             return_status := dbspl_okay_status;  (* assume no error *)             (* receive request resource message *)        IF recv_message(return_status) THEN   	         GOTO 99;  	     %      (* always return a message unless 'spool_chunk' changes this flag *) %       flag_send_message := true;      "      (* call the correct procedure, dependent upon request code *)  "       CASE message.dbspl.request OF                to_spl_spool_code :           BEGIN              msg_reply_code := to_bm_spl_spool_reply_mesg_code;  
            spool_chunk (  
                tlf_descriptor,                 rfl_descriptor,  
               rfl_label,  
                return_status);            END;               to_spl_cont_log_code :            BEGIN               msg_reply_code := to_bm_spl_contlog_reply_mesg_code;               rfl_continuelog (                  rfl_descriptor,  
               rfl_label,  
                tlf_descriptor,                 return_status);              IF return_status = zero THEN BEGIN                 okay_to_spool := true;                  abnormal_finish := false;  
               END;  
          END;                to_spl_end_log_code :           BEGIN               msg_reply_code := to_bm_spl_endlog_reply_mesg_code;                rfl_endlog (                 rfl_descriptor,  
               rfl_label,  
 "               true,  (* dump out what is remaining in the buffer *) "                return_status);              abnormal_finish := true;               END;                to_spl_finis_code :           BEGIN              msg_reply_code := to_bm_spl_finis_reply_mesg_code;                  (**)  "            (* the following status code indicates to the procedure  " !            (* 'terminate_dbspl' that this is a normal termination !             (* and the rfl can be properly ended and closed.              (**)                  return_status := dbspl_terminating_warn_code;               terminate_dbspl (                  rfl_descriptor,  
               rfl_label,  
                tlf_descriptor,                 return_status);              GOTO 999;            END;  (* End finis *)      "         otherwise               (* illegal message - do nothing *)  " 
            GOTO 99; 
          END;  (* End case *)             (* done processing request - send final reply *)        IF flag_send_message THEN            dummy_boolean := send_message (               msg_reply_code,  '             return_status,       (* send this status, but do not change it *) ' %             last_spooled_block);  (* only meaningful for spool request *) %             #      (* are we supposed to terminate due to fatal error encounter? *) #       IF (return_status <> zero) THEN BEGIN   
         terminate_dbspl ( 
             rfl_descriptor,               rfl_label,              tlf_descriptor,               return_status);            (* tell dbmon we're terminating *)            dummy_boolean := send_message ( 
            msg_reply_code, 
             dbspl_terminating_warn_code,  	            zero); 	         END;     99:  (* ignore message *)     
      END;  (* end while *) 
     
999: (* terminate *) 
     END (* DBSPL main program *)  .  