$PASCAL ',7 92081-1X552 REV.5000' $  $ Title 'DBUTL: IMAGE utility program' $  $ Subtitle 'System-dependent utility routines' $  $ Heap 0 $ $ Recursive OFF $ $ Subprogram  $ $ Range OFF $      PROGRAM DBUTL_4   $ Alias 'DBUT4' $;      #(* **************************************************************** *) # #(* * (C) Copyright 1983 Hewlett-Packard.  All rights reserved.    * *) # #(* * No part of this program may be photocopied, reproduced or    * *) # #(* * translated to another program language without the express   * *) # #(* * written consent of Hewlett-Packard Company.                  * *) # #(* **************************************************************** *) #     #(********************************************************************) # #(*                                                                  *) # #(* PROGRAM : DBUTL system-dependent utility routines                *) # #(*                                                                  *) # #(* PURPOSE : These routines perform various system-dependent        *) # #(*           operations for the DBUTL program.                      *) # #(*                                                                  *) # #(* PGMR:        <EDB> <MRL>                                         *) # #(*                                                                  *) # #(* SOURCE:  92081-18552                                             *) # #(*                                                                  *) # (* DATE of last modification : <870113.1607>  #(*                                                                  *) # #(* Altered: March 1984 for new file system. <MRL>                   *) # #(*                                                                  *) # #(********************************************************************) #$ List OFF, Include '[IMAGE', List ON $ $ List OFF, Include '[DBUTL', List ON $  $ Page $  #(********************************************************************) # #(*                      EXTERNAL TYPES                              *) # #(********************************************************************) #     TYPE         options_word_type = PACKED RECORD  (* file I/O options *)        driver_bypass : boolean;        non_buffered  : boolean;        user_err_hndl : boolean;        opt_params    : boolean;        driver_spec1  : boolean;        transparency  : boolean;        driver_spec2  : boolean;        echo_input    : boolean;        driver_spec3  : boolean;        binary_data   : boolean;        LU_number     : 0..63;        END;         rmpar_array_type = ARRAY [1..5] OF short_int;         !   status1_type =                  (* status word 1 from EXEC 13 *) !	      PACKED RECORD 	          availablity: 0..3;        (* device availability *)           device_type: 0..63;       (* device type *)           device_status: 0..255;    (* device status *)  
         END; (* RECORD *) 
    !   status2_type =                  (* status word 2 from EXEC 13 *) !	      PACKED RECORD 	          d_flag: boolean;          (* DCPC flag *)          b_flag: boolean;          (* buffering flag *)          p_flag: boolean;          (* powerfail flag *)          s_flag: boolean;          (* timeout flag *)           t_flag: boolean;          (* timedout flag *)           subchannel: 0..31;        (* device subchannel *)          select_code: 0..63;       (* device select code *)  
         END; (* RECORD *) 
    !   status3_type = boolean;         (* status word 3 from EXEC 13 *) !        abreg_type = RECORD                   status:  short_int;                   length:  short_int;  
                END; 
 $ Page $      $ Include '[XUU_M' $     (* DBUTL main external defs. *)  $ Include '[XUU_3' $     (* Other DBUTL external defs.*)  $ Include '[XDSMR' $     (* String manipulation.      *)  $ Include '[XUSHF' $     (* Upshifting external defs. *)  $ Include '[XDCIO' $     (* DBCON read/write externals*)     (**** Get Fmp I/O options word from the DCB ****)     PROCEDURE get_io_options   $ Alias 'FmpIoOptions' $    (VAR dcb : dcb_type;      VAR err : short_int;     VAR opt : options_word_type);     EXTERNAL;         (**** Set Fmp I/O options word in the DCB ****)      PROCEDURE set_io_options   $ Alias 'FmpSetIoOptions' $    (VAR dcb : dcb_type;      VAR err : short_int;     VAR opt : options_word_type);     EXTERNAL;         (**** Make a string header for a run string ****)      FUNCTION make_longstr_hdr   $ Alias 'Strdsc' $    (longstr : long_str;     first,len : short_int) : f7x_str;     EXTERNAL;         (**** Make a string header for a program name ****)      FUNCTION make_program_hdr   $ Alias 'Strdsc' $    (prognm : prog_name;     first,len : short_int) : f7x_str;     EXTERNAL;             (**** Run a program ****)      FUNCTION FmpRunProgram     (    runstring : f7x_str;     VAR rmpars    : rmpar_array_type;     VAR prognm    : f7x_str) : short_int;     EXTERNAL;          (**** See if a logical unit number is an interactive device ****)       $HEAPPARMS OFF $  FUNCTION check_interactive   $ Alias 'IFTTY' $    (lu_number : Short_int) : Short_int;     EXTERNAL;              $ Page $  #(* Get_status gets the status from the specified logical unit.      *) # #(* This is very system-dependent, and returns different information *) # #(* from one system to another.                                      *) # #(* Code must be set to 13.                                          *) #    PROCEDURE get_status   $ Alias 'EXEC' $    (     code: short_int;           lu: short_int;        VAR status1: status1_type;        VAR status2: status2_type;        VAR status3: status3_type );      EXTERNAL;          (**** Convert Ascii to Short_int ****)      PROCEDURE Asc_to_Shorti  $ Alias 'CATI' $      (    ascii_string : Short_str;           first_byte   : Short_int;           byte_length  : Short_int;       VAR result       : Short_int;       VAR status       : Short_int);     EXTERNAL;          (**** Convert Ascii to Long_int ****)       PROCEDURE Asc_to_Longi   $ Alias 'CATDI' $     (    ascii_string : Short_str;           first_byte   : Short_int;           byte_length  : Short_int;       VAR result       : Long_int;      VAR status       : Short_int);     EXTERNAL;          (**** Convert Short_int to Ascii ****)      PROCEDURE Shorti_to_Asc   $ Alias 'CITA' $     (    short_integer : Short_int;      VAR result_str    : Short_str);      EXTERNAL;      $ List OFF, Include '[XDGIC', List ON $       $ List OFF, Include '[XDFMP', List ON $       (**** Read a long string from an interactive device ****)       FUNCTION reentrant_io    $ Alias 'XREIO' $     (    read_write_code : short_int;          device_id       : short_int;      VAR buffer          : short_str;          word_count      : short_int):  abreg_type;     EXTERNAL;      (* determine operating system *) FUNCTION opsys  $ Alias 'IMG.OPSY' $  : os_kinds; EXTERNAL;     (* get session id on RTE-A *) 
FUNCTION usnum : short_int; 
EXTERNAL;      FUNCTION get_idsegment  $Alias 'IDGET' $     ( name:  prog_name;       sesid:  short_int ) :  short_int; EXTERNAL;      (* RTE-A routine to determine if routine is non-clonable  *)  FUNCTION systemprocess     ( idseg:  short_int) : short_int; EXTERNAL;      $ Page $  #(********************************************************************) # #(*                      special_read                                *) # #(********************************************************************) # #(*                                                                  *) # #(* Special_read reads a line from an LU with special bits set.      *) # #(* Since the input file is in the form of a DCB, the routine has to *) # #(* go into the DCB to retrieve the LU number and functions bits,    *) # #(* and modify the functions bits for the special read.              *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE special_read   $ Alias 'Utl.SpecialRead' $     ( VAR text_file: file_descriptor; 
     VAR buffer: short_str; 
      VAR return_status : Short_int);     LABEL 99;     VAR    save_options: options_word_type;    new_options : options_word_type; 
   dummy_status: short_int; 
     BEGIN (* special_read *)        (**)      (* If input is from an interactive device, grab the LU number     (* and perform a read without echoing.    (**)         IF is_interactive_file (text_file) THEN BEGIN        (* save and replace the options word with no-echo *)            get_io_options (text_file.dcb,                        return_status,                        save_options);           IF (return_status <> zero) THEN BEGIN          return_status := fmp_to_image_error (return_status);          GOTO 99;          END;            new_options := save_options;            new_options.echo_input := false; (* do not echo input *)            set_io_options (text_file.dcb,                        return_status,                       new_options);           END; (* then file is interactive *)                 IF read_short_str (text_file,                       buffer,                        return_status)       THEN;  (* ignore error here: need to re-establish echo *)             IF is_interactive_file (text_file) THEN BEGIN            set_io_options (text_file.dcb,                       dummy_status,                        save_options);           END; (* then device is interactive *)     
99:  (* error exit *) 
    END; (* special_read *)  $ Page $  #(********************************************************************) # #(*                      run_program                                 *) # #(********************************************************************) # #(*                                                                  *) # #(* Run_program runs the specified program, sending a command line,  *) # #(* and retrieving a reply string.                                   *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE run_program   $ Alias 'Utl.RunProgram' $    (     prog: prog_name;       VAR command_line: long_str;       VAR reply_line: long_str;       VAR return_status : Short_int);     VAR  $   dummy: sched_parm_buffer_type;  (* dummy schedule parameter buffer *) $   temp_file:  file_descriptor;   (* CLONE uses this DCB *)    dummy_short_int:  short_int;         runstr_hdr : f7x_str;     runstr     : f7x_str;     prgstr     : f7x_str;  
   prognm     : prog_name; 
       rmpars : rmpar_array_type;         BEGIN (* run_program *)         runstr := make_longstr_hdr (command_line,1,chars_in_long_str);          prgstr := make_program_hdr (prognm,1,chars_in_prog_name);         return_status := FmpRunProgram (runstr,                                     rmpars,                                    prgstr);        IF return_status <> no_image_err       THEN return_status := program_schedule_err;         (* See if the scheduling utility returned an error *)    IF rmpars[one] <> no_image_err        THEN nonfatal_error (rmpars[one]);      END; (* run_program *)  $ Page $  #(********************************************************************) # #(* Construct a log file name from the 'CRN,SIZE' user input.        *) # #(********************************************************************) # #(*                                                                  *) # #(* Purpose:                                                         *) # #(*    The user is allowed to specify the cartridge and size of a    *) # #(*    log file while IMAGE supplies the name, security code and     *) # #(*    file type.  Default sizes and CRNs are not allowed.           *) # #(*    This routine constructs the full file name of the log file.   *) # #(*    Exception:  The roll forward log file name (main or spare),   *) # #(*    is '+RLxxx' where the XXX must be replaced by the appropriate *) # #(*    volume number.                                                *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION create_logfile_name   $ Alias 'Utl.LogName' $    (VAR crn_parm  : parm_entry;     VAR filesize_parm : long_int;         logfile_type : Logfile_types;     VAR filename     : new_file_name;          rflf_vol_num : short_int;    (* only used with RL & SL *)       VAR return_status: Short_int) : Boolean;     
LABEL 99;  (* error exit *) 
    CONST    blank = ' ';        high_byte_shift = 256;        rfl_replace_char = 4;  (* Characters 4-6 of rfl file name *)                           (* are replaced with volume number *)      TYPE     file_size_array_type = ARRAY [logfile_types] OF long_int;          CONST (* local structured constants *)         default_file_sizes = file_size_array_type       [default_before_image_size,         default_transaction_log_size,         default_rollforward_log_size,        default_rollforward_log_size];         minimum_file_sizes = file_size_array_type       [min_before_image_size,         min_transaction_log_size,         min_rollforward_log_size,        min_rollforward_log_size];     VAR    status    : Short_int;         (* Conversion status *)     next_char : Char;              (* next char to be parsed *)     
   min_filesize : Long_int; 
        buildname : long_str;    numberstr : short_str;         pathname  : long_str;        crn_path  : boolean;     BEGIN (* create_logfile_name *)         create_logfile_name := true;  (* Assume an error will occur *)         crn_path := false;  (* assume a new file path *)      
   buildname := ' '; 
       CASE crn_parm.typ OF           non:  (* no crn supplied *)           pathname := '/IMAGE2/';            int: BEGIN          crn_path := true; (* old crn for path *)  
         pathname := '::'; 
         append_long_str (pathname,crn_parm.ascii);          END;            asc: BEGIN "         IF (crn_parm.ascii[3] = ' ') THEN BEGIN (* assume old crn *) "            crn_path := true;             pathname := '::';             append_long_str (pathname, crn_parm.ascii);             END 	         ELSE BEGIN 	            pathname := crn_parm.ascii;             append_str (pathname, '/');              END;          END;           END; (* case statement *)            (* determine if legal file size *)      
   IF filesize_parm = zero 
      THEN filesize_parm := default_file_sizes[logfile_type];         min_filesize := minimum_file_sizes[logfile_type];         IF filesize_parm < min_filesize        THEN BEGIN          return_status := log_file_too_small_err;          GOTO 99; 
      END; (* then *) 
       (**) !   (* File system dependency: The largest positive number of blocks ! !   (* which can be specified is 16383.  For larger files, the size !    (* must be in terms of negative number of chunks where a chunk   
   (* is 128 blocks. 
   (**)     
   IF filesize_parm > 16383 
      THEN filesize_parm := -((filesize_parm+127) DIV 128);        (**)    (* At this point we have the LU number and size in blocks of  #   (* the file we want to create.  We will construct a file descriptor #    (* and return it to the caller.  NOTE! The file created    (* may not be valid:  There may not be enough disc for the    (* file, or the LU number may not be mounted, etc.    (* It is up to the calling routine to verify whatever is     (* necessary.    (**)         IF NOT crn_path THEN buildname := pathname;        CASE logfile_type OF       before_image    : append_str (buildname, '+BIF');       transaction_log : append_str (buildname, '+TLF');           main_rf_log, spare_rf_log : append_str (buildname,'+RL'); 
      END; (* case *) 
       IF (logfile_type = main_rf_log) OR        (logfile_type = spare_rf_log) THEN BEGIN       numberstr := ' ';       numberstr[1] := chr(ord('0') + (rflf_vol_num DIV 100));  "      numberstr[2] := chr(ord('0') + (rflf_vol_num MOD 100) DIV 10); "       numberstr[3] := chr(ord('0') + (rflf_vol_num MOD 10));        append_str (buildname, numberstr); 
      END; (* then *) 
        IF crn_path        THEN append_long_str (buildname, pathname)       ELSE append_str (buildname,'::');         append_str (buildname,':1:');  (* always type 1 file *)        long_int_to_readable_short_str (filesize_parm, numberstr);         append_str (buildname,numberstr);         (* Now return the file name back to the caller *)    file_dest_long_srce (filename, chars_in_new_file_name,                         buildname, chars_in_long_str,                          str_assign, zero);        create_logfile_name := false;  (* no error occurred *)     
99:  (* error exit *) 
     END; (* create_logfile_name *)  $ page $  (***************************************************************)   (* Function rename_spare                                       *)   (*                                                             *)   (* Purpose:  This function renames the spare rollforward log   *)   (* file whenever a new rollforward log file is created.        *)   (* EXAMPLE:  if the physical name for the spare is +RL002 and  *)   !(*           the physical name for the rfl is +RL001 and a new *)  ! !(*           rfl is created, the physical name for the new rfl *)  ! !(*           will be +RL002.  This means that the physical     *)  ! !(*           name for the spare must be changed to +RL003.     *)  ! (*                                                             *)   (* Input:  file_desc :     file_descriptor for old spare       *)   (*         rfl_volume_num : new volume number for rfl file     *)   (*           being created, spare will be next number          *)   (* Output:  file_desc : contains new file name so dbcon can    *)   (*                      be updated.                            *)   (*          return_status:  error incountered, if error        *)   (*                                                             *)   (***************************************************************)       FUNCTION rename_spare  $ALIAS 'UTL.RenameSpare'$    ( VAR file_desc : new_file_name;         spare_volume_num : short_int;      VAR return_status : short_int ) : BOOLEAN;     CONST     rfl_replace_char = 4;     VAR 
   newname : new_file_name; 
        BEGIN  (* rename_spare *)         (* change name on old file descriptor so that  *)     (* it will become the new file descriptor      *)     newname := file_desc;        newname[rfl_replace_char] :=               chr(ord('0') + (spare_volume_num DIV 100));        newname[rfl_replace_char + one] :=                 chr(ord('0') + (spare_volume_num MOD 100) DIV 10);         newname[rfl_replace_char + two] :=              chr(ord('0') + (spare_volume_num MOD 10));            IF rename_file (newname, file_desc, return_status)       THEN rename_spare := true        ELSE BEGIN           file_desc := newname;          rename_spare := false;        END;     END; (* rename_spare *)  $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* ROUTINE : system_process                                         *) # #(*                                                                  *) # #(*  This routine picks up the necessary information from RTE-A's    *) # #(*  tables and determines if DBUTL is non-cloned for RTE-A.         *) # #(*                                                                  *) # #(* PROGRAMMER : <MES>                                               *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION system_process $Alias 'UTL.SYSPROCESS'$     ( name:  prog_name ) : boolean;     VAR 
   idseg:  short_int; 

   ival :  short_int; 

   sesid:  short_int; 
    BEGIN        IF opsys = RTEA THEN BEGIN 
      sesid := usnum; 
       idseg := get_idsegment (name,sesid);        ival := systemprocess (idseg);       IF ival < 0 THEN system_process := true                   ELSE system_process := false;       END     ELSE system_process := true;  (* always true for RTE-6 *)      END;  .  