 $PASCAL ',7 92081-1X034 REV.2540' $   $ Title 'DBUTL: Issue error messages' $   $ Heap 0 $  	$ Recursive OFF $  	 $ Subprogram  $   $ Range OFF $       PROGRAM DBUTL_6;      #(* **************************************************************** *) # #(* * (C) Copyright 1983 Hewlett-Packard.  All rights reserved.    * *) # #(* * No part of this program may be photocopied, reproduced or    * *) # #(* * translated to another program language without the express   * *) # #(* * written consent of Hewlett-Packard Company.                  * *) # #(* **************************************************************** *) #     #(********************************************************************) # #(*                                                                  *) # #(* ROUTINE : DBUTL command execution routines                       *) # #(*                                                                  *) # #(* SOURCE:  92081-18034                                             *) # #(*                                                                  *) # #(* PURPOSE : This file contains include statements for some of the  *) # #(*           DBUTL command execution routines.                      *) # #(*                                                                  *) # #(* PGMR: <MRL>                                                      *) # #(*       <TH> for NLS                                               *) # #(*                                                                  *) # (* Date of last modification <851118.1428>  #(*                                                                  *) # #(********************************************************************) #     (**)  &(*:nl:$ATB, mdbu_6, %ut000, relocatable, 92081-16078 REV.2540 <851118.1428>  & (*:nl:$   
(*:nl:$COUNTER, 1, 1000, 1 
 (**)      $ List OFF, Include '[IMAGE', List ON $   $ List OFF, Include '[DBUTL', List ON $   $ List OFF, Include '[UTNLS', List ON $   $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) #     $ List OFF, Include '[XUU_M', List ON $   $ List OFF, Include '[XUU_3', List ON $   $ List OFF, Include '[XUU_4', List ON $   $ List OFF, Include '[XDFMP', List ON $   $ List OFF, Include '[XDCIO', List ON $   $ List OFF, Include '[XDPER', List ON $   $ List OFF, Include '[XUSHF', List ON $   $ List OFF, Include '[XDSMR', List ON $   $ List OFF, Include '[XDGCB', List ON $       $ List OFF, Include '[XDNLS', List ON $  (* NLS externals *)      $(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *)  $  PROCEDURE MDBU_6; EXTERNAL;                                            (**** Get the program name of DBUTL ****)       PROCEDURE get_program_name  $ Alias 'PNAME' $      (VAR programs_name : prog_name);      EXTERNAL;      !(**** Determine if system process (non-clonable) on RTE-A ******)  ! FUNCTION system_process  $ Alias 'UTL.SYSPROCESS' $      (name:  prog_name) : boolean;     EXTERNAL;          #(* Allocate_comm_id allocates a global communications identifier    *) # #(* for use by the IMAGE subsystem.                                  *) #     FUNCTION allocate_comm_id   $ Alias 'GETCL'      ( VAR comm_id: short_int;           global: short_int ): boolean;     EXTERNAL;          PROCEDURE pascal_error_printer $ Alias 'PAS.ErrorPrinter' $      ( VAR err_type :  error_type;       VAR err_num : short_int;        VAR err_line : short_int;       VAR err_file : err_file_name;       VAR err_flen : short_int );     EXTERNAL;  $ page $  PROCEDURE runtime_error_printer  $ Alias 'UTL.ErrorPrinter' $      ( VAR err_type : error_type;        VAR err_num  : short_int;       VAR err_line : short_int;       VAR err_file : err_file_name;       VAR err_flen : short_int );  BEGIN       pascal_error_printer ( err_type, err_num, err_line, err_file,                             err_flen );      fatal_error ( dbutl_internal_err );  END;  $ Page $  #(********************************************************************) # #(*                      send_error                                  *) # #(********************************************************************) # #(*                                                                  *) # #(* Send_error causes issue_error to be loaded with segment DBUT5.   *) # #(* Issue_error is an external routine which prints an error message.*) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE send_error   $ Alias 'Utl.SendError'$      ( error_code: short_int);      BEGIN (* send_error *)         (* check for special last error indicator *)      IF error_code = last_error_err   !      THEN error_code := last_error_code (* get last error code *) ! "      ELSE last_error_code := error_code; (* set last error code *)  "        issue_error ( log_file, error_code );      END; (* issue_error *)  $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* ROUTINE : execute_qq_command                                     *) # #(*                                                                  *) # #(* PURPOSE : This routine performs the operations of the DBUTL ??   *) # #(*           command.  The ?? command is used to display an error   *) # #(*           message.                                               *) # #(*                                                                  *) # #(* PGMR:        <EDB> <MRL>                                         *) # #(*                                                                  *) # #(********************************************************************) # $ Page $  #(********************************************************************) # #(*                      execute_qq_command                          *) # #(********************************************************************) #     PROCEDURE execute_qq_command   $ Alias 'DBUTL.QQ.CMD' $      ( VAR parameter_buffer: parm_buffer );       VAR      error_num : short_int;          (* error code *)      return_status : Short_int;       $ Page $  #(********************************************************************) # #(*                      MAIN CODE                                   *) # #(********************************************************************) #     BEGIN (* execute_qq_command *)         (* check optional error parameter *)      WITH parameter_buffer.parameter[2] DO  	      CASE typ OF  	              non: (* not supplied *)                 error_num := last_error_err;                int: (* integer parameter *)                  error_num := value;               asc: (* ascii parameter *)               nonfatal_error (illegal_parm_type_err);                END; (* CASE *)         (* issue error message *)  
   send_error (error_num); 
     END; (* execute_qq_command *)   $ Page $  #(********************************************************************) # #(*                    has_crash_occurred                            *) # #(********************************************************************) # #(*                                                                  *) # #(* Has_crash_occurred is called once at the beginning of DBUTL and  *) # #(* checks to see if DBMON is gone and the crash flag is set.  This  *) # #(* tells if a soft crash occurred.  If this is the case, the user   *) # #(* is informed, because at that point he won't be able to execute   *) # #(* certain commands.                                                *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE has_crash_occurred;   $ alias 'UTL.CrshOccurred' $      VAR      return_status : short_int;       BEGIN  (* has_crash_occurred *)          WITH dbcon_table.dbcon_status_block DO BEGIN         IF read_dbcon_table (dbcon_file,                             dbc_status_blk,                             do_not_lock_dbcon_file,                             block,                              return_status)            THEN fatal_error (return_status);            IF (flag.crash_flag) AND (NOT flag.dbmon_active)           THEN send_error ( soft_crash_err );      	   END; (* with *) 	     END;   (* has_crash_occurred *)   $ Page $  #(********************************************************************) # #(*                      initialize                                  *) # #(********************************************************************) # #(*                                                                  *) # #(* Initialize sets up the initial DBUTL environment, getting the    *) # #(* image communications buffer if available, setting it up if not;  *) # #(* activating the necessary IMAGE programs;                         *) # #(* allocating a communications identifier for passing messages;     *) # #(* reading the database control file if available, and creating it  *) # #(* if necessary.                                                    *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE initialize   $ Alias 'Utl.Initialize'$;       CONST   '   local_allocation = 0;           (* local communications path allocation *)  '    do_not_extend_file = false;     DBUTL_program_name = prog_name ['DBUTL '];           VAR      dbutl_name  : prog_name;       session_id  : short_int;  (* RTE-A session id, 0 if system *)                                (* program, 0 on RTE-6 *)      BEGIN (* initialize *)         (* Use terminal as log file initially *)      default_file (log_file.newfl);   	   open_log_file;  	        (* Verify that the program name is 'DBUTL' *)     get_program_name (dbutl_name);      IF dbutl_name <> dbutl_program_name        THEN I_am_cloned := true;       !   (* verify that DBUTL is not cloned on RTE-A (system process) *) !    IF NOT system_process (dbutl_name)         THEN I_am_cloned := true;          (* get IMAGE communications buffer *)     If get_image_comm_buffer (image_comm_buffer)         THEN initialize_image;         (* open the dbcon file if it exists, otherwise it will   *)     (* be created.  If IMAGE crn not found user file 'DBCON' *)     (* will be opened and its crn will be put in $IMCR       *)     open_db_control_file;         (* allocate a communications path *)      IF allocate_comm_id (dbutl_comm_id, local_allocation)        THEN fatal_error (dbutl_internal_err);         (* clear exit flag *)     exit_flag := false;          END; (* initialize *)   $ Page $  #(********************************************************************) # #(*                      process_run_string                          *) # #(********************************************************************) # #(*                                                                  *) # #(* Process_run_string processes the DBUTL run string, using the     *) # #(* parameter buffer entries to open the input file, list file, and  *) # #(* log file, maintenance word, and node number.  The message        *) # #(* "DBUTL ready" is displayed to the input file if it is            *) # #(* interactive.                                                     *) # #(*                                                                  *) # #(* The parameters which are expected in parameter_buffer are:       *) # #(*                                                                  *) # #(*     parameter          type                                      *) # #(*                                                                  *) # #(* [1] "RUN"              asc                                       *) # #(* [2] "DBUTL"            asc                                       *) # #(* [3] <command-file>     non/int/asc                               *) # #(* [4] <list-file>        non/int/asc                               *) # #(* [5] <log-file>         non/int/asc                               *) # #(* [6] <maint-word>       non/asc                                   *) # #(* [7] <node-number>      non/int                                   *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE process_run_string   $ Alias 'Utl.ProcRunStr'$     ( VAR parameter_buffer: parm_buffer );       CONST      empty_short_str = short_str [chars_in_short_str OF ' '];       VAR      dummy: short_int;               (* dummy variable *)      return_status : Short_int;   
   temp_string : Long_str; 
         BEGIN (* process_run_string *)         (* set primary and secondary command input file names *)      WITH parameter_buffer.parameter[3] DO BEGIN  	      IF typ = non 	          THEN default_file (input_file.newfl)   
         ELSE BEGIN  
             upshift_long_str (ascii,                                temp_string,                                chars_in_long_str);                   (* truncate parameter into input_file.newfl *)              file_dest_long_srce (input_file.newfl,                                   chars_in_new_file_name,                                   temp_string,                                    chars_in_long_str,                                    str_assign,                                   zero);                   IF open_existing_file (input_file, return_status)                  THEN fatal_error (return_status);                  IF close_file (input_file, return_status) THEN;                   END; (* else *)             END; (* WITH *)          sec_input_file_name := ' ';     interactive_secondary := false;         (* check list file name *)      WITH parameter_buffer.parameter[4] DO BEGIN  	      IF typ = non 	          THEN default_file(list_file.newfl)   
         ELSE BEGIN  
             upshift_long_str (ascii,                                temp_string,                                chars_in_long_str);                   file_dest_long_srce (list_file.newfl,                                    chars_in_new_file_name,                                   temp_string,                                    chars_in_long_str,                                    str_assign,                                   zero);               END;  (* else *)            open_list_file;             IF error_code <> no_image_err            THEN fatal_error ( error_code );             END; (* WITH *)              (* check log file name and open log file *)     WITH parameter_buffer.parameter[5] DO BEGIN  	      IF typ = non 	          THEN default_file(log_file.newfl)  
         ELSE BEGIN  
             upshift_long_str (ascii,                                temp_string,                                chars_in_long_str);                   file_dest_long_srce (temp_file.newfl,                                    chars_in_new_file_name,                                   temp_string,                                    chars_in_long_str,                                    str_assign,                                   zero);       "            (* Make sure we can open the log file before closing *)  " "            (* the currently open log file (user's terminal).    *)  "                 IF open_file_for_write (temp_file, error_code)                 THEN fatal_error ( error_code );                   IF close_file (temp_file, error_code) THEN;                   log_file.newfl := temp_file.newfl;      
            open_log_file; 
              END; (* else *)            END; (* WITH *)          (* check maintenance word *)      WITH parameter_buffer.parameter[6] DO BEGIN  	      IF typ = non 	          THEN maint_word := empty_short_str   
         ELSE BEGIN  
             upshift_long_str (ascii,                                temp_string,                                chars_in_long_str);                   truncate_str (temp_string, maint_word);            END; (* else *)        END; (* WITH *)          (* check remote node number *)      WITH parameter_buffer.parameter[7] DO BEGIN  	      IF typ = non 	          THEN node_number := 0           ELSE node_number := value;         END; (* WITH *)          (* open commmand input file *)      open_command_file;      IF error_code <> no_image_err   (* check for errors *)         THEN fatal_error (error_code);         (* test maintenance word *)     IF read_dbcon_table (dbcon_file,                           dbc_status_blk,                           do_not_lock_dbcon_file,                           dbcon_table.dbcon_status_block.block,                           return_status)        THEN fatal_error (dbcon_read_err);      #   IF (dbcon_table.dbcon_status_block.maint_word = empty_short_str) OR #       (maint_word = dbcon_table.dbcon_status_block.maint_word)        THEN database_admin := true         ELSE database_admin := false;          (* display ready message *)     IF is_interactive_file (input_file) THEN BEGIN   (*    temp_string := 'DBUTL ready'; *)        (*:nl:#*1 1000 'DBUTL ready' *)   '      (*:nl:$COPY '      length := nlread (&, #, nlerr, temp_string, len);' *) ' "      length := nlread (MDBU_6, 1000, nlerr, temp_string, len);      " "      blank_pad (temp_string, chars_in_long_str, length);  (* NLS *) "       IF write_long_str (prompt_file, temp_string, error_code)           THEN fatal_error (error_code);         END; (* THEN *)       END; (* process_run_string *)   .  