 $PASCAL ',3,51 92081-1X791 REV.5000' $  $ Title 'DBUTL: IMAGE utility program' $ 
$ Subtitle 'Main program' $ 
 $ Heap 0 $ $ Recursive OFF $ $ Range OFF $      PROGRAM DBUTL;      #(* **************************************************************** *) # #(* * (C) Copyright 1983 Hewlett-Packard.  All rights reserved.    * *) # #(* * No part of this program may be photocopied, reproduced or    * *) # #(* * translated to another program language without the express   * *) # #(* * written consent of Hewlett-Packard Company.                  * *) # #(* **************************************************************** *) #     #(********************************************************************) # #(*                                                                  *) # #(* PROGRAM : DBUTL                                                  *) # #(*                                                                  *) # #(* SOURCE:  92081-18791                                             *) # #(* RELOC:   92081-16791                                             *) # #(*                                                                  *) # #(* PURPOSE : This program provides a comprehensive set of IMAGE     *) # #(*           control features and utilites.                         *) # #(*           Some of its main functions are as follows:             *) # #(*                                                                  *) # #(*           (1) Start up and shut down IMAGE subsystem             *) # #(*           (2) Define transaction and warning log files           *) # #(*           (3) Schedule roll back and roll forward recovery       *) # #(*           (4) Backup and restore data bases                      *) # #(*           (5) Obtain IMAGE subsystem status information          *) # #(*           (6) Clean up unused IMAGE subsystem resources          *) # #(*                                                                  *) # #(* PGMR:        <EDB> <MRL>                                         *) # #(*              <TH> for NLS                                        *) # #(*                                                                  *) #(* Date of last modification: <870217.1843>  #(*                                                                  *) # #(* Altered: March 1984 for new file system.                         *) # #(* Altered: Jan.  1985 for NLS.                                     *) # #(* Altered: April 1985 for re-segmenting to fit in 30 pages.        *) # #(*                                                                  *) # #(********************************************************************) #         (**)  %(*:nl:$ '        SOURCE MESSAGE CATALOG                                  ' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '* (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1984.  ALL RIGHTS      *' % %(*:nl:$ '* RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       *' % %(*:nl:$ '* REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT *' % %(*:nl:$ '* THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.        *' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '                                                                ' % %(*:nl:$ '                           SOURCE:   92081-18078                ' % %(*:nl:$ '         S. MESSAGE CATALOG NAME :   <UT000                     ' % %(*:nl:$ '                            RELOC:   92081-16078                ' % %(*:nl:$ '         B. MESSAGE CATALOG NAME :   %UT000                     ' % %(*:nl:$ '                            PGMR :   TH                         ' % %(*:nl:$ '         REV.5000 <870217.1843>                                 ' %(*:nl:$  (*:nl:$ '*NOTE*'  %(*:nl:$ 'All the messages in DBUTL must be within the number of chars_in ' % %(*:nl:$ 'long_str -1 (=127 bytes). And parameter substitution must be    ' % %(*:nl:$ 'within the number of chars_in_short_str -1 (=15 bytes).         ' %(*:nl:$ (*:nl:$ (*:nl:$LANGID 0 (*:nl:$ (*:nl:$  (**)      $ Page $  #(********************************************************************) # #(*                      LABEL DEFINITIONS                           *) # #(********************************************************************) #    LABEL        91,92,93,94,                   (* Debug/1000 label *NLS *)     99,                            (* nonfatal error label *)     999;                            (* fatal error label *)     $ List OFF, Include '[IMAGE', List ON $      $ Page $  
$ Include '[DBUTL' $ 
 #(********************************************************************) # #(*                      LOCAL CONSTANTS                             *) # #(********************************************************************) #    CONST        dbutl_1 = prog_name             (* command segment name *)       [ 'DBUT1', chars_in_prog_name-5 OF ' ' ];        dbutl_2 = prog_name             (* command segment name *)       [ 'DBUT2', chars_in_prog_name-5 OF ' ' ];         dbutl_5 = prog_name             (* issue error segment name *)        [ 'DBUT5', chars_in_prog_name-5 OF ' ' ];        dbutl_7 = prog_name             (* command segment name *)       [ 'DBUT7', chars_in_prog_name-5 OF ' ' ];        dbutl_8 = prog_name             (* command segment name *)       [ 'DBUT8', chars_in_prog_name-5 OF ' ' ];  $ Page $  #(********************************************************************) # #(*                      LOCAL VARIABLES                             *) # #(********************************************************************) #    VAR        (*** utility variables (indexes, loop counters) ***)        slen: short_int;                 (* string length *)        (*** command processing ***)    command_line: long_str;         (* command input line *)    command: commands;              (* command identifier *)     parameter_buffer: parm_buffer;  (* command parameter buffer *)   
   prog:  prog_name; 
    dummy:  sched_parm_buffer_type;    return_status:  short_int;  $ Page $  #(********************************************************************) # #(*                      EXTERNAL SYSTEM PROCEDURES                  *) # #(********************************************************************) #     #(* Get_run_string gets the run string for the current program,      *) # #(* and returns it into the specified buffer.                        *) #     FUNCTION get_run_string $ Alias 'PAS.PARAMETERS'$      (    position: short_int;     VAR string: long_str;         string_length: short_int): short_int;     EXTERNAL;     PROCEDURE load_segment $ Alias 'PAS.SEGMENTLOAD'$  
   ( segment: prog_name ); 
    EXTERNAL;      PROCEDURE print_runtime_error $ Alias 'UTL.ErrorPrinter' $    ( VAR err_type : error_type;     VAR err_num  : short_int;     VAR err_line : short_int;     VAR err_file : err_file_name;     VAR err_flen : short_int );   EXTERNAL;  $ Page $  #(********************************************************************) # #(*   DBUTL subroutines and action routines called by DBUTL main.    *) # #(********************************************************************) #     $ List off $  
$ Include '[XUU_1' $ 
 
$ Include '[XUU_2' $ 
 
$ Include '[XUU_3' $ 
 
$ Include '[XUU_4' $ 
 
$ Include '[XDFMP' $ 
 
$ Include '[XUU_5' $ 
$ List ON $ $ List OFF, Include '[XDCIO', List ON $  #(********************************************************************) # #(*                      fatal_error                                 *) # #(********************************************************************) # #(*                                                                  *) # #(* Fatal_error is called when an error is determined to be fatal,   *) # #(* that is, DBUTL cannot perform any more functions because some    *) # #(* vital information is lost, or cannot be created.                 *) # #(* The routine issues the appropriate error message, and then       *) # #(* branches the the main program label 999, which should cause      *) # #(* DBUTL to finish and terminate.                                   *) # #(*                                                                  *) # #(********************************************************************) #    PROCEDURE fatal_error $ Alias 'Utl.FatalError'$    ( error: short_int);     BEGIN (* fatal_error *)         (* set global error code *)     error_code := error;          (* issue error message *)  
   load_segment (dbutl_5); 
    send_error (error);        (* branch to main program fatal error label *)     GOTO 999;      END; (* fatal_error *)  $ Page $  #(********************************************************************) # #(*                    has_crash_occurred                            *) # #(********************************************************************) # #(*                                                                  *) # #(* Has_crash_occurred is called once at the beginning of DBUTL and  *) # #(* checks to see if DBMON is gone and the crash flag is set.  This  *) # #(* tells if a soft crash occurred.  If this is the case, the user   *) # #(* is informed, because at that point he won't be able to execute   *) # #(* certain commands.                                                *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE has_crash_occurred;   $ alias 'UTL.CrshOccurred' $     VAR    return_status : short_int;    temp_error_code : short_int;     BEGIN  (* has_crash_occurred *)     temp_error_code := last_error_code;        WITH dbcon_table.dbcon_status_block DO BEGIN        IF read_dbcon_table (dbcon_file,                             dbc_status_blk,                             do_not_lock_dbcon_file,                            block,                            return_status)           THEN fatal_error (return_status);            IF (flag.crash_flag) AND (NOT flag.dbmon_active) THEN BEGIN            load_segment (dbutl_5);          send_error ( soft_crash_err );          END; (* then a crash has occurred *)      	   END; (* with *) 	    
   {don't report 146} 
    last_error_code := temp_error_code; END;   (* has_crash_occurred *)  $ Page $  #(********************************************************************) # #(*                      nonfatal_error                              *) # #(********************************************************************) # #(*                                                                  *) # #(* Nonfatal_error is called when an error occurs during execution   *) # #(* of a DBUTL internal or action routine.  When this occurs, the    *) # #(* routine issues the appropriate error message, and then branches  *) # #(* to the main program label 99, which should cause the command     *) # #(* loop to be repeated.                                             *) # #(*                                                                  *) # #(********************************************************************) #    PROCEDURE nonfatal_error $ Alias 'Utl.NonFatalErr'$    ( error: short_int);     LABEL    91,92;    (* Debug/1000 label *NLS*)      
BEGIN (* nonfatal_error *) 
        (* set global error code *)    error_code := error;         (* issue error message *)  
   load_segment (dbutl_5); 
 91:send_error (error);      92:IF NOT is_interactive_file(input_file) THEN BEGIN        IF (in_TR_file) AND (interactive_secondary) THEN BEGIN          input_file.newfl := sec_input_file_name; 
         open_command_file; 
         in_TR_file := false;          END  (* BEGIN *)  
      ELSE GOTO 999; 
      END;  (* handling of noninteractive input file *)         (* branch to main program nonfatal error label *)    GOTO 99;     END; (* nonfatal_error *)  $ page $  (**********************************************************)  (*                                                        *)  (* Purpose:                                               *)  (*    To capture PASCAL runtime errors and produce a      *)  (*    meaningful error for IMAGE users.  (Having the      *)  (*    standard PASCAL error message pop up on the         *)  (*    system console would not be informative or          *)  (*    helpful.                                            *)  (*                                                        *)  (* NOTE: The error catcher must be 'Pas.ErrorCatcher'.    *)  (*                                                        *)  (**********************************************************)      PROCEDURE catch_runtime_error   $ Alias 'Pas.ErrorCatcher' $              (VAR err_type : error_type;                VAR err_num  : Short_int;               VAR err_line : Short_int;               VAR err_file : err_file_name;               VAR err_flen : Short_int);       BEGIN  (* catch runtime error *)     
   load_segment (dbutl_5 ); 
    "   print_runtime_error (err_type,err_num,err_line,err_file,err_flen); "       fatal_error (err_num);      END; (* catch runtime error *)  $page$  #(********************************************************************) # #(*                      main program                                *) # #(********************************************************************) # #(*                                                                  *) # #(* The main program code is used to control DBUTL execution.        *) # #(* First, the DBUTL environment is initialized (initialize),        *) # #(* then the run string (with its scheduling command line) is        *) # #(* retrieved, parsed and processed (get_run_string, parse_command,  *) # #(* process_run_string). If an error occurs during these operations, *) # #(* Fatal_error is executed, causing control to proceed at the       *) # #(* error return label (999).                                        *) # #(* After the preceding operations are completed, a loop is entered  *) # #(* to process commands from the command input file.                 *) # #(* A command line is read, parsed, identified, checked, and then    *) # #(* processed (read_command, identify_command, check_parameters,     *) # #(* execute_xx_command). If an error occurs during these operations, *) # #(* Nonfatal_error is executed, causing control to proceed at the    *) # #(* error return label (99).                                         *) # #(* When the exit flag is set (by the EX command), the command loop  *) # #(* is exited, and the DBUTL environment is cleaned up (finish).     *) # #(* Then the main program terminates.                                *) # #(*                                                                  *) # #(********************************************************************) #     BEGIN (* DBUTL main program *)        load_segment (dbutl_5); (* load segment with initializers *)         (* debug *)    tried_once := false;        (* initialize DBUTL environment *)     initialize;    FOR slen := 1 TO 10 DO BEGIN        command_stack [slen] := ' ';       entry_sizes [slen] := zero;    END;      "91:health_check;   (* Determine the health of the IMAGE subsystem *) "        has_crash_occurred;   (* see if crash occurred *)          (* Initialization warnings should not be considered errors *)  
   last_error_code := zero; 
       (* get run string and place into parameter buffer *)     slen := get_run_string (-1,command_line,chars_in_long_str);     parse_command (command_line, slen, parameter_buffer);     IF error_code <> no_image_err        (* check for errors *)        THEN fatal_error (error_code);        (* process DBUTL run string *)    process_run_string (parameter_buffer);         (* enter command processing loop *)    REPEAT           (* read a command from the input file *);        read_command (command_line, slen, command_stack,                     entry_sizes, stack_available );           {health_check;} (* get current state of system *)       has_crash_occurred;            (* parse command line into parameter buffer *) 	      parse_command 	          (command_line, slen, parameter_buffer);       IF error_code <> no_image_err    (* check for errors *)           THEN nonfatal_error (error_code);           (* identify command name *)  !      command := identify_command (parameter_buffer.parameter[1]); !           (* check the parameters *)        check_parameters (command, parameter_buffer);                 (**)       (* Note that AL, AR and CI have been commented out.       (* These commands may be implemented at a later date.        (**)               (* execute the command *) 
      CASE command OF 
              comment_command: (* ** *)             (* do nothing *);              qq_command: (* ?? *)             BEGIN                 load_segment (dbutl_5);                execute_qq_command (parameter_buffer);                END; (* qq_command CASE *)              ac_command: (* AC *)             BEGIN                 load_segment (dbutl_2);                execute_ac_command (parameter_buffer);                END; (* ac_command CASE *)              ar_command: (* AR *)             BEGIN                 load_segment (dbutl_1);                execute_ar_command (parameter_buffer);                END; (* ar_command CASE *)               bk_command:  (* BK *)             BEGIN                 load_segment (dbutl_2);                execute_bk_command (parameter_buffer); 	               END; 	             bl_command: (* BL *)             BEGIN                 load_segment (dbutl_8);                execute_bl_command (parameter_buffer);                END; (* bl_command CASE *)      
         cl_command: 
            BEGIN                 load_segment (dbutl_8);                execute_cl_command (parameter_buffer);                END; (* cl_command case *)              ex_command: (* EX *)             BEGIN                 load_segment (dbutl_2);                execute_ex_command (parameter_buffer);                END; (* ex_command CASE *)              he_command: (* HE *)             BEGIN                 load_segment (dbutl_2);                execute_he_command (parameter_buffer);                END; (* he_command CASE *)              ld_command: (* LD *)             BEGIN                 load_segment (dbutl_1);                execute_ld_command (parameter_buffer);                END; (* ld_command CASE *)              lg_command: (* LG *)             BEGIN                 load_segment (dbutl_2);                execute_lg_command (parameter_buffer);                END; (* lg_command CASE *)              ll_command: (* LL *)             BEGIN                 load_segment (dbutl_7);                execute_ll_command (parameter_buffer);                END; (* ll_command CASE *)              lo_command: (* LO *)             BEGIN                 load_segment (dbutl_7);                execute_lo_command (parameter_buffer);                END; (* lo_command CASE *)              mw_command: (* MW *)             BEGIN                 load_segment (dbutl_2);                execute_mw_command (parameter_buffer);                END; (* mw_command CASE *)              ns_command: (* NS *)             BEGIN                 load_segment (dbutl_7); 92:            execute_ns_command (parameter_buffer);                END; (* ns_command CASE *)              rb_command: (* RB *)             BEGIN                 load_segment (dbutl_1); 93:            execute_rb_command (parameter_buffer);                END; (* rb_command CASE *)              rf_command: (* RF *)             BEGIN                 load_segment (dbutl_1);                execute_rf_command (parameter_buffer);                END; (* rf_command CASE *)              rl_command: (* RL *)             BEGIN                 load_segment (dbutl_7);                execute_rl_command (parameter_buffer);                END; (* rl_command CASE *)              rs_command: (* RS *)             BEGIN                 load_segment (dbutl_1);                execute_rs_command (parameter_buffer);                END; (* rs_command CASE *)              sd_command: (* SD *)             BEGIN                 load_segment (dbutl_8);                execute_sd_command (parameter_buffer);                END; (* sd_command CASE *)              sh_command: (* SH *)             BEGIN                 load_segment (dbutl_2);                execute_sh_command (parameter_buffer);                END; (* sh_command CASE *)              sl_command: (* SL *)             BEGIN                 load_segment (dbutl_7);                execute_sl_command (parameter_buffer);                END; (* sl_command CASE *)              st_command: (* ST *)             BEGIN                 load_segment (dbutl_1); 94:            execute_st_command (parameter_buffer);                END; (* st_command CASE *)              su_command: (* SU *)             BEGIN                 load_segment (dbutl_8);                execute_su_command (parameter_buffer);                END; (* su_command CASE *)              tl_command: (* TL *)             BEGIN                 load_segment (dbutl_8);                execute_tl_command (parameter_buffer);                END; (* tl_command CASE *)              tr_command: (* TR *)             BEGIN                 load_segment (dbutl_7);                execute_tr_command (parameter_buffer);                END; (* tr_command CASE *)              ul_command: (* UL *)             BEGIN                 load_segment (dbutl_1);                execute_ul_command (parameter_buffer);                END; (* ul_command CASE *)              wl_command: (* WL *)             BEGIN                 load_segment (dbutl_8);                execute_wl_command (parameter_buffer);                END; (* wl_command CASE *)              unknown_command: (* unknown command *)             nonfatal_error (no_such_command_err);               OTHERWISE nonfatal_error (no_such_command_err);               END; (* CASE *)     99:   (* nonfatal error exit *)            UNTIL exit_flag;      999:  (* fatal error exit *)        (* finish DBUTL environment *)     finish;     END. (* DBUTL main program *) 