 $PASCAL ',7,90 92081-1X085 REV.2540'$       $ Heap 0 $  	$ Recursive OFF $  	 $ Range OFF $       $ Subprogram $      PROGRAM dblod_seg3_library;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18085                                        *)  ! !(* RELOC:   92081-1X085                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified: <851107.1328>  !(*                                                             *)  ! !(***************************************************************)  !     !(***************************************************************)  ! !(*                                                             *)  ! !(* This module contains functions and procedures used by DBLOD *)  ! !(* in the segment DBLO3, which open the database and obtain    *)  ! !(* data set information needed to perform the load operation.  *)  ! !(* The data sets must be empty, for example.                   *)  ! !(*                                                             *)  ! !(***************************************************************)  ! $ Page $  !(***************************************************************)  ! !(*             Constants and types Declarations                *)  ! !(***************************************************************)  !     $ List OFF, Include '[IMAGE', List ON $       $ List OFF, Include '[BACKUP_UTILS', List ON $      $ List OFF, Include '[ULD_LOD', List ON $       $ List OFF, Include '[DBLOD', List ON $           !(***************************************************************)  ! !(*                   External declarations                     *)  ! !(***************************************************************)  !     $ List OFF, Include '[XBKP1', List ON $       $ List OFF, Include '[XDTDY', List ON $  (* timestamp *)      PROCEDURE get_set_list  $ Alias 'DBINF' $      (    ibase : ibase_type;   
        dummy : short_int; 
 
        mode  : short_int; 
     VAR istat : istat_type;       VAR buffer: set_list_type);      EXTERNAL;      PROCEDURE get_set_info   $ Alias 'DBINF' $     (    ibase : ibase_type;   
        setid : short_int; 
 
        mode  : short_int; 
     VAR istat : istat_type;       VAR buffer: set_info_buf_type);      EXTERNAL;          $ Page $  !(***************************************************************)  ! !(*                                                             *)  ! !(* Function OPEN_DB                                            *)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To open the specified database and gather information    *)  ! !(*    about the data sets to be loaded.                        *)  ! !(*                                                             *)  ! !(* Parameters: None.                                           *)  ! !(*                                                             *)  ! !(* Function result: 'True' if an error occurs, otherwise false.*)  ! !(*                                                             *)  ! !(***************************************************************)  !     FUNCTION open_db  $ Alias 'DBLOD.OpenDB' $     : Boolean;       
LABEL 99; (* error exit *) 
     VAR      i : short_int; (* loop for set numbers *)         set_info_buf : set_info_buf_type;     dummy        : short_int;          
BEGIN (* open_db *)  
        open_db := true; (* assume an error will occur *)         IF open_the_database (ibase, 3, istat)         THEN GOTO 99; (* error opening the database! *)          (**)   #   (* At this point, all necessary files are opened, the database has  # $   (* been opened, and we are ready to make sure the database is empty.  $    (**)          get_set_list (ibase, dummy, 203, istat, set_list);      IF (istat[1] <> zero) THEN BEGIN         report_error (istat[1]);        GOTO 99;        END;         (**)   "   (* Because we have highest level of access, all data set numbers  "    (* in the set list are negative.  Let's make them positive.     (**)       
   WITH set_list DO  
    FOR i := one TO num_sets DO        set_nums[i] := abs(set_nums[i]);         (**)      (* Make sure all sets are empty.      (**)       
   WITH set_list DO  
    FOR i := one TO set_list.num_sets DO BEGIN       !      get_set_info (ibase, set_nums[i], 202, istat, set_info_buf); !       IF (istat[1] <> zero) THEN BEGIN           report_error (istat[1]);   	         GOTO 99;  	          END;             IF set_info_buf.num_entries <> zero THEN BEGIN           report_error (data_set_not_empty_err);   	         GOTO 99;  	          END;             END; (* with...for *)              (**)      (* Initialize the skeleton volume header      (* for the I/O routines to do checks with.      (**)          WITH volume_header DO BEGIN        ident := 'DBUNLOAD2540    ';  !      reel   := zero; (* incremented by open_tape_file_for_read *) !       END; (* the rest does not need defining *)             (**)      (* Things are all set for DBLOD to go!      (**)          open_db := false; (* no error *)       99:  (* error exit *)   	END; (* open_db *) 	 .  