$PASCAL ',7 92081-1X503 REV.2440' $      
$ Include '[LBOPT' $ 
     PROGRAM logging_library;      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18503                                        *)   (* RELOC:   92081-16503                                        *)   (*                                                             *)   (* PGMR:        <stc>                                          *)   (*                                                             *)   (* Date last modified: <840912.1410>  (*                                                             *)   (***************************************************************)       #$ List OFF, Include '[IMAGE', List ON $  (* General IMAGE defn's.   *) #     TYPE    record_length = RECORD                      rec_len:  short_int;                    END;    rec_len_ptr_type = ^record_length;  $ Page $ (* EXTERNALS *)     $ Heapparms OFF $      FUNCTION make_gen_log_rec_ptr  $ Alias 'EMA.AddrToPtr' $  $ Heapparms on $   ( VAR tub_addr : short_int;     VAR ptr : ptr_log_record_header_type; $ Heapparms off $      VAR status : short_int) : BOOLEAN;   EXTERNAL;      FUNCTION get_rec_len $ Alias 'EMA.AddrToPtr' $  $ Heapparms on $   ( VAR tub_addr : short_int;     VAR ptr : rec_len_ptr_type; $ Heapparms off $     VAR status : short_int ) : BOOLEAN;   EXTERNAL;      FUNCTION get_prev_rec_len $ alias 'EMA.MakeNewPtr' $  $ Heapparms on $    (VAR ptr:  ptr_log_record_header_type;  	$ Heapparms off $  	     offset:  short_int;   $ Heapparms on $      VAR new_ptr:  rec_len_ptr_type;   	$ Heapparms off $  	     VAR return_status:  short_int) : BOOLEAN;    EXTERNAL;          FUNCTION move_pointer_forward $ alias 'EMA.MakeNewPtr' $  $ Heapparms on $    (VAR ptr:  ptr_log_record_header_type;  	$ Heapparms off $  	     offset :  short_int;  $ Heapparms on $      VAR new_ptr :  ptr_log_record_header_type;  	$ Heapparms off $  	     VAR return_status :  short_int ) : BOOLEAN;     EXTERNAL;       FUNCTION move_pointer_backward $ alias 'EMA.MakeNewPtr' $   $ Heapparms on $    (VAR ptr:  ptr_log_record_header_type;  	$ Heapparms off $  	     offset :  short_int;  $ Heapparms on $      VAR new_ptr :  ptr_log_record_header_type;  	$ Heapparms off $  	     VAR return_status :  short_int ) : BOOLEAN;     EXTERNAL;       FUNCTION rd_wr_tuf  $ alias 'EMA.DiscTransfer' $  
  (      code : short_int; 
    VAR  file_id : file_descriptor;  $ Heapparms on $      VAR  buffer : transaction_log_buffer_type; $ Heapparms off $          block_len : short_int;           start_block : long_int;     VAR  status : short_int) : BOOLEAN;     EXTERNAL;     FUNCTION rd_wr_label $ alias 'EMA.DiscTransfer' $  
  (      code : short_int; 
    VAR  file_id : file_descriptor;  $ Heapparms on $     VAR  buffer : tuf_label_type; $ Heapparms off $          block_len : short_int;           start_block : long_int;     VAR  status : short_int) : BOOLEAN;     EXTERNAL;      FUNCTION rd_wr_header $ alias 'EMA.DiscTransfer' $  
  (      code : short_int; 
     VAR  file_id : file_descriptor;   $ Heapparms on $      VAR  buffer : tuf_header_type;  	$ Heapparms off $  	          block_len : short_int;            start_block : long_int;      VAR  status : short_int) : BOOLEAN;      EXTERNAL;      FUNCTION make_eof_block_ptr   $ Alias 'EMA.AddrToPtr' $   $ Heapparms ON $     ( VAR TUB_addr       : short_int;       VAR eof_ptr        : ptr_TUF_eof_block_type;   	$ Heapparms OFF $  	      VAR error          : short_int) : Boolean;                                          EXTERNAL;          (**** Move the EOF block to proper position in TUB ****)      FUNCTION move_eof_block   $ Alias 'EMA.MoveWords' $   $ Heapparms ON $     (VAR block_one : tuf_eof_block_type;       VAR block_two : tuf_eof_block_type;   	$ Heapparms OFF $  	         words     : short_int;     VAR status    : short_int) : Boolean;     EXTERNAL;     $ List OFF, Include '[XDTDY', List ON $      $ Page $  (************************************************************)  (*                                                          *)  (* Procedure read_TUF_chunk                                 *)  (*                                                          *)  (* Purpose : The purpose of this routine is to read a       *)  (*    chunk from the transacton log file. The caller need   *)  (*    not worry about the physical end of file.             *)  (*                                                          *)  (* Input:                                                   *)  (*    (1) The file descriptor for the transaction log file. *)  (*    (2) The transction log file label block.              *)  (*    (3) Chunk buffer address which is the destination for *)  (*          the read.                                       *)  (*    (4) TUF block number which is block number for the    *)  (*          start of the chunk.                             *)  (*                                                          *)  (*                                                          *)  (* Returns:                                                 *)  (*    (4) The start of chunk ( updated only if we needed    *)  (*          to wrap around the physical end of file.        *)  (*    (5) The number of blocks in the chunk (i.e. the       *)  (*          number of blocks read).                         *)  (*    (6) Time (in milliseconds) for disc read(s) is added. *)  (*    (7) Disc I/O count to be incremented.                 *)  (*    (8) Return status.  If zero, the call was successful. *)  (*                                                          *)  (*                                                          *)  (* Calls :                                                  *)  (*    (1) read_disc_blocks                                  *)  (*                                                          *)  (* Called by: ( please identify which routines call this )  *)  (*                                                          *)  (************************************************************) $ HEAPPARMS OFF $      PROCEDURE read_TUFchunk  $ Alias 'LOG.ReadChunk' $    (VAR TUF_descriptor         : file_descriptor;      VAR tuf_label              : tuf_label_type;  $ heapparms on $     VAR buffer                 : transaction_log_buffer_type; $ Heapparms OFF $      VAR Chunk_start_block_num  : long_int;     VAR num_blocks_in_chunk    : short_int;      VAR disc_io_time           : long_int;      VAR disc_io_count          : long_int;      VAR return_status          : short_int);         VAR    start_block_num  : long_int; !   num_dummy_blocks : short_int; (* # blks at end of TUF to skip *) !   head_log_rec_ptr : ptr_log_record_header_type;    start_time       : long_int;         BEGIN        (**)     (* Handle wrapping around the physical end of TUF    (**)         num_dummy_blocks := tuf_label.num_dummy_blks;        (**)    (* Case 1 - wrapping around from the physical beginning to    (* the physical end.     (*                                   'chunk_size'     (*                                    v       v      (* +--------------------------------------------------------+       (* | headr | chunks ....              | chunk | dummy chunk |       (* +-------------------------------------- -----------------+      (*         ^                          ^     (* given   |  chunk_start is this     |      (*      block minus 'chunk_size'      |--returned chunk start      (*      (results in negative value)    (**)         IF chunk_start_block_num <= num_blks_in_tuf_header THEN        chunk_start_block_num := chunk_start_block_num +                                tuf_descriptor.fsize -                                num_blks_in_tuf_header -                                num_dummy_blocks    ELSE        (**)     (* Case 2 - wrapping around the physical end FROM the physical      (* end to the physical beginning.    (*     (* +--------------------------------------------------+     (* | headr |  chunk | .....     | chunk | dummy chunk |     (* +--------------------------------------------------+     (*         ^                            ^     (*         |-------tuf_first_blk_num    |----given chunk_start     (**)            IF ((tuf_descriptor.fsize - chunk_start_block_num)          < num_dummy_blocks) THEN         chunk_start_block_num := tuf_first_blk_num;             start_time := get_start_time;         (* read the first block of the chunk *)    IF rd_wr_tuf (        read_code, 
      tuf_descriptor, 
      buffer,        one, (* block *)        chunk_start_block_num,       return_status) THEN        IF return_status = disc_failure_err THEN          return_status := tlf_corrupt_err        ELSE           return_status := zero        ELSE BEGIN           disc_io_count := disc_io_count + one;  "      disc_io_time  := disc_io_time + get_elapsed_time (start_time); "          (* Look at the chunk header to determine *)       (* the number of blocks per chunk        *)        IF make_gen_log_rec_ptr(           buffer.log_buf[zero],  
         head_log_rec_ptr, 
          return_status) THEN          return_status := soft_crash_err (* internal error *)            ELSE          IF head_log_rec_ptr^.rec_type = tuf_eof_indicator THEN             return_status := logical_end_of_tuf_err          ELSE              num_blocks_in_chunk :=                 head_log_rec_ptr^.chunk_head.blks_per_chunk           END;  (* else look at first block of chunk *)             (* Finally we shall read the requested chunk *)         start_time := get_start_time;        IF return_status = zero  (* all is okay *)  THEN  
      IF rd_wr_tuf ( 
	         read_code, 	          tuf_descriptor,           buffer,          num_blocks_in_chunk,          chunk_start_block_num,          return_status) THEN;          disc_io_time := disc_io_time + get_elapsed_time (start_time);      disc_io_count := disc_io_count + one;     
END;   (* read_TUF_chunk *) 
 $ Page $  (************************************************************)  (*                                                          *)  (* Procedure write_TUF_chunk                                *)  (*                                                          *)  (* Purpose : The purpose of this routine is to write a      *)  (*    chunk from the transacton log file.                   *)  (*                                                          *)  (* Input:                                                   *)  (*    (1) The file descriptor for the transaction log file. *)  (*    (2) Chunk buffer address which is the destination for *)  (*          the write.                                      *)  (*    (3) TUF block number which is block number for the    *)  (*          start of the chunk.                             *)  (*    (4) Number of blocks to write.                        *)  (*    (5) Flag to indicate whether an eof block is to       *)  (*          be attached to the TUB                          *)  (*                                                          *)  (* Returns:                                                 *)  (*    (6) The block number of the last TUF block written.   *)  (*    (7) Return status.  If zero, the call was successful. *)  (*                                                          *)  (*                                                          *)  (* Calls :                                                  *)  (*    (1) write_disc_blocks                                 *)  (*                                                          *)  (* Called by: ( please identify which routines call this )  *)  (*    (1) DRAIN_TUB (DBMON)                                 *)  (*                                                          *)  (************************************************************) $ Heapparms off $      PROCEDURE write_TUFchunk  $ Alias 'LOG.WriteChunk' $   ( VAR TUF_descriptor         : file_descriptor;  $ Heapparms on $     VAR buffer                 : transaction_log_buffer_type; $ Heapparms off $      VAR Chunk_start_block_num  : long_int;     VAR num_blocks_to_write    : short_int;         flag                   : boolean;      VAR last_block_written     : long_int;      VAR disc_write_time        : long_int;      VAR return_status          : short_int);     LABEL 99;  (* error return *)     VAR     eof_block_ptr : ptr_tuf_eof_block_type;     num_words_to_write : short_int;     start_time    : long_int;     BEGIN     !   num_words_to_write := num_blocks_to_write * words_in_disc_block; !       (* should we attach an eof block to the chunk *)     IF flag = true THEN BEGIN       IF make_eof_block_ptr (           buffer.log_buf[num_words_to_write],          eof_block_ptr,           return_status) THEN          GOTO 99;           (* the eof block we attach is the  *)       (* last block of the buffer        *)        IF move_eof_block (buffer.tub_eof_block,                           eof_block_ptr^,                          words_in_disc_block,                          return_status)           THEN GOTO 99;           num_blocks_to_write := num_blocks_to_write + one;        END;         last_block_written := chunk_start_block_num +                                num_blocks_to_write - one;         start_time := get_start_time;         (* write the block to disc *)    IF rd_wr_tuf (       write_code, 
      tuf_descriptor, 
      buffer,  
      num_blocks_to_write, 
       chunk_start_block_num,       return_status) THEN        IF return_status = disc_failure_err THEN          return_status := tlf_corrupt_err        ELSE          return_status := zero;     "   disc_write_time := disc_write_time+ get_elapsed_time (start_time); "    99 : (* error return *)      END;   (* write_TUF_chunk *)  $ page $  !(****************************************************************) ! !(*                                                              *) ! !(* Procedure Get_adj_log_record                                 *) ! !(*                                                              *) ! !(* Purpose : This procedure returns a pointer to the adjacent   *) ! !(* log record within a transaction log buffer, when given       *) ! !(* a valid log record pointer. It automatically goes to the     *) ! !(* next chunk in the transaction log file, if the next          *) ! !(* log record falls in the next chunk.  If the end of file is   *) ! !(* encountered, the return status reflects that condition       *) ! !(* ('end_of_tuf_err' - see [error).                             *) ! !(*                                                              *) ! !(* Input :                                                      *) ! !(*    (1) The file descriptor for the transaction log file      *) ! !(*    (2) Transaction log buffer which contains current chunk.  *) ! !(*    (3) 'foreward' or 'backward' keyword to indicate which    *) ! !(*        log record to get (type 'TUF_wraparound_direction'    *) ! !(*        found in [LOG).                                       *) ! !(*    (4) Pointer to a log record header - this routine gets    *) ! !(*        the log record which is adjacent to the log record    *) ! !(*        whose pointer is this parameter.                      *) ! !(*                                                              *) ! !(*  Returns :                                                   *) ! !(*    (4) Pointer to a log record header - pointer to the       *) ! !(*        'next' log record.  Overwrites old pointer value.     *) ! !(*    (5) Time (in milliseconds) for disc read(s) is added to.  *) ! !(*    (6) Disc read count is incremented for each read.         *) ! !(*    (7) Return status (0 if successful)                       *) ! !(*                                                              *) ! !(*                                                              *) ! !(****************************************************************) !$ Heapparms off $     PROCEDURE get_adj_log_record     $ alias 'Log.GetAdjLogRec' $    (VAR tuf_descriptor : file_descriptor;    VAR TUF_label      : TUF_label_type;  $ heapparms on $     VAR TUB            : transaction_log_buffer_type; $ Heapparms off $        direction      : tuf_wraparound_direction;    VAR log_hdr_ptr    : ptr_log_record_header_type;    VAR disc_read_time : long_int;    VAR disc_read_count: long_int;    VAR return_status  : short_int);          LABEL 99;   (* error return *)     CONST  	   minus_one = -1; 	    VAR     rec_len_ptr:  rec_len_ptr_type;     rec_len :  short_int;     word_offset :  short_int;    new_log_hdr_ptr :  ptr_log_record_header_type;     block_number :  long_int;     number_blocks_read:  short_int;    log_record_length : short_int;         BEGIN        WITH log_hdr_ptr^ DO BEGIN      
   CASE direction OF 
    
      foreward: BEGIN 
           CASE rec_type OF              chunk_tail_log_code: BEGIN                  (* calculate starting block number of next chunk   *)               (* to read, and read that chunk, then make pointer *)              block_number := chunk_tail.TUF_block_num + 1;              word_offset := zero;                  read_TUFchunk (tuf_descriptor, TUF_label, TUB,                             block_number, number_blocks_read,                            disc_read_time, disc_read_count,                             return_status);                   IF make_gen_log_rec_ptr (TUB.log_buf [word_offset] ,                                        log_hdr_ptr, return_status )                  (* fails *) THEN GOTO 99;     !            IF log_hdr_ptr^.rec_type = tuf_eof_indicator THEN BEGIN !               return_status := logical_end_of_tuf_err;                GOTO 99; 	               END; 	              END;  (* rec_type = chunk_tail *)                 TUF_eof_indicator:   	             BEGIN 	                 return_status := logical_end_of_tuf_err;                  GOTO 99;               END;  (* rec_type = TUF_eof_indicator *)       
           OTHERWISE 
 	             BEGIN 	                log_record_length := log_hdr_ptr^.rec_len1;                     IF move_pointer_forward (log_hdr_ptr,                                          log_record_length, #                                        new_log_hdr_ptr, return_status) #                (* fails *) THEN GOTO 99;                     log_hdr_ptr := new_log_hdr_ptr;               END; (* rec_type = otherwise *)                END; (* rec_type case *)              END;  (* direction = forward  *)         
      backward: BEGIN 
             CASE rec_type OF                  chunk_head_log_code: BEGIN                     (* check for beginning of file *)                 block_number := chunk_head.tuf_block_num;                IF block_number = TUF_label.logical_beg_of_TUF                    THEN BEGIN                      return_status := logical_end_of_TUF_err;                      GOTO 99;                      END;                     (* next record is in previous chunk so read  *)                 (* previous chunk into TUB                   *)                      block_number := block_number -                                 chunk_head.prev_blks_per_chunk;      
                (**) 
                (* read_tufchunk updates block_number to handle                 (* wrapping around the physical end of tuf.  
                (**) 
                read_TUFchunk ( tuf_descriptor, TUF_label, TUB,                                  block_number, number_blocks_read,                                    disc_read_time, disc_read_count,                                   return_status );                      IF block_number <= zero THEN BEGIN                     return_status := tlf_corrupt_err; 
                   GOTO 99; 
                   END;                     (* now get record length of chunk tail *)                 (* and record right before chunk tail  *)                       word_offset := (number_blocks_read * 128) - one;                  IF get_rec_len ( TUB.log_buf [word_offset],                                  rec_len_ptr, return_status )                     (* fails *) THEN GOTO 99;      !                (* now make pointer to record before chunk tail *) ! !                word_offset :=  word_offset - rec_len_ptr^.rec_len !                                                            + one;   "                IF make_gen_log_rec_ptr ( TUB.log_buf [word_offset], " #                                          log_hdr_ptr, return_status ) #                    (* fails *) THEN GOTO 99;                  END; (* rec_type = chunk_head *)                  OTHERWISE   
              BEGIN  
     "                (* last word of each log record holds its length  *) " "                (* get this length and move pointer back that far *) "                     IF get_prev_rec_len ( log_hdr_ptr, minus_one,   !                                      rec_len_ptr, return_status ) !                     (* fails *) THEN GOTO 99;                   rec_len := - rec_len_ptr^.rec_len;                  IF rec_len = zero THEN BEGIN                     return_status := tlf_corrupt_err;                     GOTO 99;                      END;                        IF move_pointer_backward ( log_hdr_ptr, rec_len,   "                                     new_log_hdr_ptr, return_status) "                 (* fails *) THEN GOTO 99;                       log_hdr_ptr := new_log_hdr_ptr;                  END;  (* otherwise *)               END;  (* rec_type case *)              END;  (* direction = backward *)        END;  (* direction case *)  
    END;  (* with *) 
    99:   (* error encountered *)      END;  (* get_adj_log_record *)  $ Page $  !(****************************************************************) ! !(*                                                              *) ! !(* Procedure : Init_get_log_fctn                                *) ! !(*                                                              *) ! !(* Purpose : This routine sets up a pointer to a log record     *) ! !(* by reading the transaction log file chunk which contains     *) ! !(* the sought log record.  The caller must know the TUF block   *) ! !(* number where the chunk begins and the word offset within     *) ! !(* the chunk where the log record resides.                      *) ! !(*                                                              *) ! !(* Input :                                                      *) ! !(*    (1) File descriptor for the transaction log file.         *) ! !(*        (assumes file has been previously opened)             *) ! !(*    (2) TUF block number where the chunk begins.              *) ! !(*    (3) Word offset within chunk where log record resides.    *) ! !(*    (4) Transaction log buffer to hold the chunk              *) ! !(*                                                              *) ! !(* Returns :                                                    *) ! !(*    (5) Pointer to the log record                             *) ! !(*    (6) Time (in milliseconds) for disc reads, is added to.   *) ! !(*    (7) disc read count is incremented for each disc read.    *) ! !(*    (8) Return status (0 if successful)                       *) ! !(*                                                              *) ! !(****************************************************************) !$ Heapparms off $     PROCEDURE init_get_log_fctn    $ alias 'Log.InitGetLogFctn' $    (VAR tuf_descriptor : file_descriptor;    VAR TUF_label      : TUF_label_type;  $ heapparms on $     VAR TUB            : transaction_log_buffer_type; $ Heapparms off $        block_number   : long_int;         word_offset    : short_int;    VAR log_hdr_ptr    : ptr_log_record_header_type;    VAR disc_read_time : long_int;    VAR disc_read_count: long_int;    VAR return_status  : short_int);     VAR    num_blocks_read : short_int;     BEGIN         "   (* read the TUF chunk which contains the specified block number *) "   read_TUFchunk ( tuf_descriptor,   (* transaction log file *)                    TUF_label,     (* first block in tlf  *)  "                   TUB,        (* can hold largest possible chunk *) " !                   block_number,    (* starting block# in chunk *) !                   num_blocks_read,    (* returned *)                     disc_read_time,                    disc_read_count,                     return_status);      
   IF return_status = zero 
       THEN BEGIN                (* make a pointer to the area in the chunk which     *)             (* starts at the specified word offset               *)             (* NOTE:  no error checking is done to see whether   *)             (*        the pointer will be to a valid log record. *)               IF make_gen_log_rec_ptr ( TUB.log_buf [word_offset],                                    log_hdr_ptr,                                    return_status)              (* fails *)  THEN;  (* do nothing *)            END; (* IF THEN *)     END;  (* init_get_log_fctn *)  $ Page $ (*************************************************************) (*                                                           *) (*  Function TUF_label_IO                                    *) (*                                                           *) (*  Purpose: This function reads or writes the transaction   *) (*  log file label.  The label is the first block of the     *) (*  TUF. It assumes the file is open.                        *) (*                                                           *) (*  Input:                                                   *) (*    (1) File descriptor for the transaction log file.      *) (*    (2) Label block                                        *) (*    (3) Read or write code                                 *) (*                                                           *) (*  Returns:                                                 *) (*    (4) disc io time (in milliseconds)                     *) (*    (5) Return status (0 if successful)                    *) (*                      (tlf corrupt error otherwise)        *) (*  Called by:                                               *) (*                                                           *) (*************************************************************)     $ Heapparms OFF $     FUNCTION TUF_label_IO       $ Alias 'LOG.TufLabelIO ' $    (VAR tuf_descriptor : file_descriptor;         code           : short_int;  $ heapparms on $      VAR tuf_label      : tuf_label_type; $ heapparms off $      VAR disc_io_time   : long_int;     VAR return_status  : short_int) :    BOOLEAN;     BEGIN         disc_io_time := get_start_time;     	   IF rd_wr_label ( 	      code, 
      tuf_descriptor, 
       tuf_label,        num_blks_in_tuf_label,        tuf_label_blk_num,       return_status) THEN BEGIN 
      TUF_label_IO := true; 
       return_status := tlf_corrupt_err       END    ELSE        TUF_label_IO := false;        disc_io_time := get_elapsed_time (disc_io_time);     END; (* tuf_label_io *)  $ Page $ (*************************************************************) (*                                                           *) (*  Function TUF_header_IO                                   *) (*                                                           *) (*  Purpose: This function reads or writes the transaction   *) (*  log file header.  The header consists of the tuf label   *) (*  and the active transaction table.                        *) (*                                                           *) (*  Input:                                                   *) (*    (1) File descriptor for the transaction log file.      *) (*    (2) tuf header structure.                              *) (*    (3) Read or write code                                 *) (*                                                           *) (*  Returns:                                                 *) (*    (4) disc io time (in milliseconds)                     *) (*    (5) Return status (0 if successful)                    *) (*                      (tlf corrupt error otherwise)        *) (*  Called by:                                               *) (*                                                           *) (*************************************************************)     $ Heapparms OFF $     FUNCTION TUF_header_IO   $ Alias 'LOG.TufHeaderIO ' $    (VAR tuf_descriptor : file_descriptor;         code           : short_int;  $ heapparms on $     VAR tuf_header     : tuf_header_type; $ heapparms off $      VAR disc_io_time   : long_int;     VAR return_status  : short_int) :    BOOLEAN;         BEGIN         disc_io_time := get_start_time;      
   IF rd_wr_header ( 
      code, 
      tuf_descriptor, 
      tuf_header,       num_blks_in_tuf_header,        tuf_label_blk_num,       return_status) THEN BEGIN        TUF_header_IO := true;        return_status := tlf_corrupt_err       END    ELSE       TUF_header_IO := false;        disc_io_time := get_elapsed_time (disc_io_time);      END; (* tuf_header_io *)  .  