 $PASCAL ',7 92081-1X371 REV.2540'$  !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE: 92081-18371                                         *)  ! !(* RELOC:  92081-1X371                                         *)  ! !(*                                                             *)  ! (* Date last modified: <860206.0936>  !(*                                                             *)  ! !(***************************************************************)  !     $ Heap 0 $  	$ Recursive OFF $  	 $ Subprogram $  $ Range OFF $       
PROGRAM remote_only; 
     $(*********************************************************************)  $ $(*                                                                   *)  $ $(* IMAGE/1000 Data Base Management System Library                    *)  $ $(*                                                                   *)  $ $(*                                                                   *)  $ $(* The IMAGE library subroutines allow users to write program to     *)  $ $(* enter, inquire about and manipulate data in an IMAGE/1000         *)  $ $(* data base.  Fourteen intrinsics are provided.  The intrinsics     *)  $ $(* and their functions are:                                          *)  $ $(*                                                                   *)  $ $(* DBBEG  Defines the beginning of a transaction (series of          *)  $ $(*        logically related intrinsics)                              *)  $ $(* DBCLS  Closes the data base files.                                *)  $ $(* DBCTL  Provides control data record posting.                      *)  $ $(* DBDEL  Deletes existing data records.                             *)  $ $(* DBEND  Defines the end of a transaction.                          *)  $ $(* DBFND  Locates the beginning of a data chain in prepration for    *)  $ $(*        access to entries in the chain.                            *)  $ $(* DBGET  Reads data items.  Several modes are provided.             *)  $ $(* DBINF  Provides information about the organization and components *)  $ $(*        of the data base being accessed.                           *)  $ $(* DBLCK  Locks a data base or data set temporarily to provide       *)  $ $(*        exclusive access.                                          *)  $ $(* DBMEM  Provides the means to store user data in a log record.     *)  $ $(* DBOPN  Initiates access to the data base and define's the user's  *)  $ $(*        level of access.                                           *)  $ $(* DBPUT  Adds new data records.                                     *)  $ $(* DBUNL  Unlocks a data base or set previously locked by DBLCK.     *)  $ $(* DBUPD  Modifies the values of data items in existing data records.*)  $ $(*                                                                   *)  $ $(* Historical comment:                                               *)  $ $(*    These remote-only interfaces used to be written in Macro.      *)  $ $(*    They were converted to pascal for maintainability and          *)  $ $(*    the ease by which they could be compiled for CDS purposes.     *)  $ $(*                                                                   *)  $ $(*                                                                   *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $ $ Page $  $ List OFF, Include '[IMAGE', List ON $       #(********************************************************************) # #(*                      CONSTANT DECLARATIONS                       *) # #(********************************************************************) #     CONST              get_entire_string_code = -1;      ibase_param_len = max_db + one;      
   mesg_ptr_tbl_index = 0; 
 
   max_return_info = 2048; 
        stat_array_word_len = 10;      %   want_item = 1;  (* flags to routines to indicate what info is needed *) %    want_set = 2;         (* DBINF return buffer length constants *)      m102_return_len = 13;     m202_return_len = 17;     m302_return_len = 2;      m401_return_len = 7;      m801_return_len = 4;          (* DBINF mode constants *)   	   mode202 = 202;  	 	   mode801 = 801;  	        (* DBINF data item type codes returned by dbinf *)   
   type_char = 'X';  
 
   type_real = 'R';  
    type_integer = 'I';         (* DBINF data set type codes returned by dbinf *)     type_manual = 'M';      type_automatic = 'A';     type_detail = 'D';          (* DBLCK lock request buffer length *)      words_in_lock_request_buffer = 2048;       chars_in_lock_request_buffer = words_in_lock_request_buffer *                                     chars_in_word;  $ Page $  #(********************************************************************) # #(*                      TYPE DECLARATIONS                           *) # #(********************************************************************) #     TYPE         stat_array =                    (* status array *)         ARRAY [1..stat_array_word_len] OF short_int;      #   ibase_type =                    (* user data base namr parameter *) #       ARRAY [1..ibase_param_len] OF short_int;      "   item_list_type =                (* list of item names/numbers *)  "       ARRAY [1..max_words_in_user_item_list] OF short_int;         item_value_buffer_type =        (* list of item values *)        ARRAY [1..max_words_in_value_list] OF short_int;      !   lock_request_buffer =           (* DBLCK lock request buffer *) !       ARRAY [1..words_in_lock_request_buffer] OF short_int;           lock_request_char_buffer =      (* DBLCK set name list buf *)         PACKED ARRAY [1..chars_in_lock_request_buffer] OF char;          ptr_lock_char_buf = ^lock_request_char_buffer;           #   (*****************************************************************) # #   (* Following is a definition of the DBBUF table.                 *) # #   (* This table contains much of the information needed to manage  *) # #   (* message traffic between the user and the buffer manager,      *) # #   (* and manage the local database run tables.                     *) # #   (*****************************************************************) #     #   database_mesg_len_table_type =  (* database message length table *) #       ARRAY [1..max_db] OF short_int;           (* table of the worst size message required per data base *)       msg_tbl_type = ARRAY [1..max_db] OF short_int;       %   database_run_table_type =       (* database local run table pointers *) %       ARRAY [1..max_db] OF ptr_local_run_table_hdr;          statistics_table_type = (* statistics buffers pointers. *)         ARRAY [1..max_db] OF statistics_buffer_ptr_type;         DBBUF_table_type =   (* contains local system info *)        RECORD  "         process_info:             (* current process information *) "             process_description_type;            open_count: short_int;    (* open database count *)  "         user_comm_id : short_int;  (* user communication id word *) " #         comm_info : image_comm_buffer_type;  (* global comm. info *)  #           cur_mesg_len: short_int;  (* current message length *)             max_mesg_len:             (* message length array *)               database_mesg_len_table_type;   $         cur_mesg_buf:             (* current message buffer pointer *)  $             ptr_to_bm_mesg_type;      %         db_run_table:             (* database run table pointer array *)  %             database_run_table_type;  &         cur_run_table:            (* current database run table pointer *)  &             ptr_local_run_table_hdr;               statistics_table :        (* Stat buffer pointers. *)              statistics_table_type;  !         cur_stat_buffer  :        (* Current stat buffer ptr. *)  !             statistics_buffer_ptr_type;                current_item_list : tempx_table_type;           current_set_and_db: short_int; (* set*256 + db# *)            current_num_keys  : short_int;       
         END; (* RECORD *) 
        ptr_dbbuf_table =               (* pointer definition *)         ^dbbuf_table_type;  $ Page $  #   (*****************************************************************) # #   (* The following types are the structures of the status buffer   *) # #   (* returned after execution of an intrinsic. For DBINF, the      *) # #   (* records are the return buffer information for the various     *) # #   (* DBINF modes.                                                  *) # #   (*****************************************************************) #     "   beg_buffer =                    (* DBBEG return status buffer *)  "       RECORD           status: short_int;            logging_state : logging_states;           xaction_num : long_int;  
         END; (* RECORD *) 
     "   cls_buffer =                    (* DBCLS return status buffer *)  "       RECORD           status: short_int;   
         END; (* RECORD *) 
     "   ctl_buffer =                    (* DBCTL return status buffer *)  "       RECORD           status: short_int;   
         END; (* RECORD *) 
     "   del_buffer =                    (* DBDEL return status buffer *)  "       RECORD           status: short_int;   
         END; (* RECORD *) 
     "   end_buffer =                    (* DBEND return status buffer *)  " 	      beg_buffer;  	     "   fnd_buffer =                    (* DBFND return status buffer *)  "       RECORD           status: short_int;            unused: short_int;            current_rec: long_int;            current_chain_len: long_int;            current_chain_tail: long_int;           current_chain_head: long_int;  
         END; (* RECORD *) 
     "   get_buffer =                    (* DBGET return status buffer *)  "       RECORD           status: short_int;            return_data_len: short_int;           current_record_num: long_int;  
         unused: long_int; 
          prev_record_num: long_int;            next_record_num: long_int;   
         END; (* RECORD *) 
        lck_buffer =                    (* DBLCK return buffer *)        RECORD           status: short_int;   
         END; (* RECORD *) 
     #   m101_buffer =                   (* DBINF mode 101 return buffer *)  #       RECORD           item_num: short_int;   
         END; (* RECORD *) 
     #   m102_buffer =                   (* DBINF mode 102 return buffer *)  # 
      PACKED RECORD  
          item_name: item_name_type;            unused1: PACKED ARRAY [1..10] OF char;   
         item_type: char;  
          unused2: char;            sub_item_len: short_int;            sub_item_count: short_int;            unused3: long_int;   
         END; (* RECORD *) 
     '   MX03_MX04_buffer =              (* DBINF modes x03 and x04 return buffer *) '       RECORD           num_avail_items: short_int;           item_num: ARRAY [1..max_items] OF short_int;   
         END; (* RECORD *) 
     #   M201_buffer =                   (* DBINF mode 201 return buffer *)  #       RECORD           set_num: short_int;  
         END; (* RECORD *) 
     #   M202_buffer =                   (* DBINF mode 202 return buffer *)  # 
      PACKED RECORD  
 #         set_name: file_name;      (* set name must take up 8 words *) # $         unused0 : packed array [1..10] of char;   (* hence unused0  *)  $          set_type: char;           unused1: char;            entry_word_len: short_int;            blocking_factor: short_int;           unused2: long_int;            num_entries_in_set: long_int;           set_capacity: long_int;  
         END; (* RECORD *) 
     #   M301_buffer =                   (* DBINF mode 301 return buffer *)  #       RECORD           num_paths: short_int;           path_info: ARRAY [0..max_paths] OF   	            RECORD 	                set_num: short_int;                 search_item_num: short_int;                 sort_item_num: short_int;                 END; (* RECORD *)  
         END; (* RECORD *) 
     #   m302_buffer =                   (* DBINF mode 302 return buffer *)  #       RECORD           search_item_num: short_int;           master_num     : short_int;  
         END; (* RECORD *) 
     #   m40x_buffer =                   (* DBINF mode 40x return buffer *)  #       RECORD           last_accessed_rec: long_int;            previous_rec: long_int;           next_record: long_int;            current_path: short_int;   
         END; (* RECORD *) 
        m50x_buffer =           (* DBINF modes 505 and 506 *)        statistics_buffer_type;       #   m801_buffer =                   (* DBINF mode 801 return buffer *)  #       RECORD           num_blocks_used: long_int;            total_avail_blocks: long_int;   (* max number *)   
         END; (* RECORD *) 
     "   mem_buffer =                    (* DBMEM return status buffer *)  " 	      beg_buffer;  	     "   opn_buffer =                    (* DBOPN return status buffer *)  "       RECORD           status: short_int;            access_level: short_int;            length_run_table: short_int;            hi_access_indic: short_int;           db_access: db_access_type;            sys_log_stat: logging_states;  
         END; (* RECORD *) 
     "   put_buffer =                    (* DBPUT return status buffer *)  "       RECORD           status: short_int;            buffer_word_len: short_int;           new_rec_num: long_int;            num_rec_on_chain: long_int;           pred_rec_num: long_int;           succ_rec_num: long_int;  
         END; (* RECORD *) 
     "   und_buffer =                    (* DBUND return status buffer *)  " 	      beg_buffer;  	     "   unl_buffer =                    (* DBUNL return status buffer *)  "       RECORD           status: short_int;   
         END; (* RECORD *) 
     "   upd_buffer =                    (* DBUPD return status buffer *)  "       RECORD           status: short_int;            return_data_len: short_int;    (* word len *)  
         END; (* RECORD *) 
     #   return_buffer_type =            (* generic return status buffer *)  #       RECORD  
         CASE short_int OF 
 
            1: (* DBBEG *) 
                (beg: beg_buffer);   
            2: (* DBCLS *) 
                (cls: cls_buffer);   
            3: (* DBCTL *) 
                (ctl: ctl_buffer);   
            4: (* DBDEL *) 
                (del: del_buffer);   
            5: (* DBEND *) 
                (endb: end_buffer);  
            6: (* DBFND *) 
                (fnd: fnd_buffer);   
            7: (* DBGET *) 
                (get: get_buffer);               101: (* DBINF mode 101 *)                  (m101: m101_buffer);               102: (* DBINF mode 102 *)                  (m102: m102_buffer);               104: (* DBINF mode 104 *)                  (mx03_mx04: mx03_mx04_buffer);               201: (* DBINF mode 201 *)                  (m201: m201_buffer);               202: (* DBINF mode 202 *)                  (m202: m202_buffer);               301: (* DBINF mode 301 *)                  (m301: m301_buffer);               302: (* DBINF mode 302 *)                  (m302: m302_buffer);               401: (* DBINF mode 401 *)                  (m40x: m40x_buffer);               505: (* DBINF modes 505 and 506 *)                 (m50x: m50x_buffer);               801: (* DBINF mode 801 *)                  (m801: m801_buffer);   
            8: (* DBLCK *) 
                (lck: lck_buffer);   
            9: (* DBMEM *) 
                (mem: mem_buffer);               10: (* DBOPN *)                  (opn: opn_buffer);               11: (* DBPUT *)                  (put: put_buffer);               12: (* DBUND *)                  (und: und_buffer);               13: (* DBUNL *)                  (unl: unl_buffer);               14: (* DBUPD *)                  (upd: upd_buffer);   
         END; (* RECORD *) 
        ptr_return_buffer =             (* pointer definition *)   
      ^return_buffer_type; 
 $ Page $      (**** Remote dbbegin external ****)       PROCEDURE Remote_dbbegin $ Alias 'RBBEG' $     (VAR ibase : ibase_type;   
    VAR itext : text_str;  
 
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len : short_int);     EXTERNAL;          (**** Remote DBCLOSE external ****)       PROCEDURE remote_dbclose   $ Alias 'RBCLS' $     (VAR ibase  : ibase_type;      VAR set_id : item_set_name_type;      VAR mode   : short_int;       VAR istat  : return_buffer_type);      EXTERNAL;      (**** Remote DBCONTROL external ****)       PROCEDURE remote_dbcontrol  $ Alias 'RBCTL' $      (VAR ibase : ibase_type;   
    VAR dummy : short_int; 
 
    VAR mode  : short_int; 
     VAR istat : return_buffer_type);     EXTERNAL;          (**** Remote DBDELETE external ****)      PROCEDURE remote_dbdelete  $ Alias 'RBDEL' $     (VAR ibase  : ibase_type;      VAR set_id : item_set_name_type;      VAR mode   : short_int;       VAR istat  : return_buffer_type);      EXTERNAL;          (**** remote DBEND external ****)       PROCEDURE remote_dbend  $ Alias 'RBEND' $      (VAR ibase : ibase_type;       VAR user_text : text_str;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len  : short_int);      EXTERNAL;          (**** remote DBFIND external ****)      PROCEDURE remote_dbfind  $ Alias 'RBFND' $     (VAR ibase  : ibase_type;      VAR set_id : item_set_name_type;      VAR mode   : short_int;       VAR istat  : return_buffer_type;      VAR item_id: item_set_name_type;      VAR item_value : item_value_type);     EXTERNAL;          (**** remote DBGET external ****)       PROCEDURE remote_dbget  $ Alias 'RBGET' $      (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR item_list : item_list_type;       VAR item_values_buffer : data_record_type;      VAR user_argument : argument_type);      EXTERNAL;          (**** remote DBINFO external ****)      PROCEDURE remote_dbinfo   $ Alias 'RBINF' $      (VAR ibase : ibase_type;       VAR data_id : item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : stat_array;       VAR buffer : return_buffer_type);      EXTERNAL;          (**** remote DBLOCK external ****)      FUNCTION remote_dblock  $ Alias 'RBLCK' $      (VAR ibase : ibase_type;       VAR lock_request : lock_request_buffer;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type) : short_int;     EXTERNAL;          (**** remote DBMEMO external ****)      PROCEDURE remote_dbmemo   $ Alias 'RBMEM' $      (VAR ibase : ibase_type;       VAR user_text : text_str;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len : short_int);     EXTERNAL;          (**** remote DBOPEN external ****)      PROCEDURE remote_dbopen   $ Alias 'RBOPN' $      (VAR ibase : ibase_type;       VAR level : level_word_type;      VAR op_mode : short_int;      VAR istat : return_buffer_type);     EXTERNAL;          (**** remote DBPUT external ****)       PROCEDURE remote_dbput  $ Alias 'RBPUT' $      (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR item_list : item_list_type;       VAR item_value_buffer : item_value_buffer_type);     EXTERNAL;          (**** remote DBUNDO external ****)      PROCEDURE remote_dbundo   $ Alias 'RBUND' $      (VAR ibase : ibase_type;       VAR user_text : text_str;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len  : short_int);      EXTERNAL;          (**** remote DBUNLOCK external ****)      PROCEDURE remote_dbunlock   $ Alias 'RBUNL' $      (VAR ibase : ibase_type;       VAR setlst: lock_request_buffer;  
    VAR mode  : short_int; 
     VAR istat : return_buffer_type);     EXTERNAL;          (**** remote DBUPDATE external ****)      PROCEDURE remote_dbupdate   $ Alias 'RBUPD' $      (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR item_list : item_list_type;       VAR user_buffer : data_record_type);     EXTERNAL;          $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBBEGIN                                                 *)  $ $(*                                                                   *)  $ $(* Purpose:                                                          *)  $ $(*    Remote-only interface to remote_dbbegin (RBBEG).               *)  $ $(*                                                                   *)  $ $(* input  : (1) A database identifier. (ibase parm)                  *)  $ $(*          (2) Text buffer (a comment for the log record).          *)  $ $(*          (3) Mode (1 or 2)                                        *)  $ $(*          (4) Status array.                                        *)  $ $(*          (5) Text length. (-512 bytes to +256 words).             *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE DBBEGIN  $ Alias 'DBBEG' $     (VAR ibase : ibase_type;   
    VAR itext : text_str;  
 
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len : short_int);          	BEGIN (* dbbeg *)  	        remote_dbbegin (ibase, itext, mode, istat, text_len);      	END; (* DBBEGIN *) 	 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBCLOSE                                                 *)  $ $(*                                                                   *)  $ $(* purpose:                                                          *)  $ $(*    Remote-only interface to Remote_dbclose (RBCLS).               *)  $ $(*                                                                   *)  $ $(* input  : (1) The ibase parameter of the database to close.        *)  $ $(*          (2) ID of set to close. (Backward compatibility).        *)  $ $(*          (3) Mode. (1 or 2)                                       *)  $ $(*          (4) Status array.                                        *)  $ $(*                                                                   *)  $ $(* returns: (1) status (0 if successful, else IMAGE error number)    *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE DBCLOSE   $ Alias 'DBCLS' $      (VAR ibase  : ibase_type;      VAR set_id : item_set_name_type;      VAR mode   : short_int;       VAR istat  : return_buffer_type);       
BEGIN (* DBCLOSE *)  
        remote_dbclose (ibase, set_id, mode, istat);       	END; (* DBCLOSE *) 	 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBCONTROL                                               *)  $ $(*                                                                   *)  $ $(* purpose:                                                          *)  $ $(*    Remote-only interface to remote_dbcontrol (RBCTL).             *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) dummy parameter.                                           *)  $ $(*    (3) mode. (1,2,5,6).                                           *)  $ $(*    (4) Status array.                                              *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbcontrol  $ Alias 'DBCTL' $     (VAR ibase : ibase_type;   
    VAR dummy : short_int; 
 
    VAR mode  : short_int; 
     VAR istat : return_buffer_type);          BEGIN (* dbcontrol *)          remote_dbcontrol (ibase, dummy, mode, istat);      
END; (* DBCONTROL *) 
 $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* PROCEDURE DBDELETE                                               *) # #(*                                                                  *) # #(* purpose : Remote-only interface to Remote_dbdelete (RBDEL).      *) # #(*                                                                  *) # #(* input :   (1) ibase parameter.                                   *) # #(*           (2) set identifier.                                    *) # #(*           (3) mode. (must be 1)                                  *) # #(*           (4) istat array.                                       *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE DBDELETE  $ Alias 'DBDEL' $      (VAR ibase  : ibase_type;      VAR set_id : item_set_name_type;      VAR mode   : short_int;       VAR istat  : return_buffer_type);           
BEGIN (* DBDELETE *) 
        remote_dbdelete (ibase, set_id, mode, istat);      
END; (* dbdelete *)  
 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBEND                                                   *)  $ $(*                                                                   *)  $ $(* purpose: Remote-only interface to remote_dbend (RBEND).           *)  $ $(*                                                                   *)  $ $(* parameters:                                                       *)  $ $(*    (1) ibase parameter.                                           *)  $ $(*    (2) user text to include in DBEND log record.                  *)  $ $(*    (3) mode (must be 1)                                           *)  $ $(*    (4) istat array.                                               *)  $ $(*    (5) user text length.                                          *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbend  $ Alias 'DBEND' $     (VAR ibase : ibase_type;       VAR user_text : text_str;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len  : short_int);           	BEGIN (* dbend *)  	        remote_dbend (ibase, user_text, mode, istat, text_len);      END; (* dbend *)  $ Page $  "(*****************************************************************)  " "(*                                                               *)  " "(* PROCEDURE DBFIND                                              *)  " "(*                                                               *)  " "(* purpose :                                                     *)  " "(*    Remote-only interface to remote_dbfind (RBFND).            *)  " "(*                                                               *)  " "(* Parameters:                                                   *)  " "(*    (1) ibase.                                                 *)  " "(*    (2) set id. (must be a detail)                             *)  " "(*    (3) mode. (must be 1)                                      *)  " "(*    (4) istat array.                                           *)  " "(*    (5) detail's key item for the chain.                       *)  " "(*    (6) key item value to find a chain for.                    *)  " "(*                                                               *)  " "(*****************************************************************)  "     PROCEDURE dbfind  $ Alias 'DBFND' $      (VAR ibase  : ibase_type;      VAR set_id : item_set_name_type;      VAR mode   : short_int;       VAR istat  : return_buffer_type;      VAR item_id: item_set_name_type;      VAR item_value : item_value_type);          	BEGIN (* DBFIND *) 	     !   remote_dbfind (ibase, set_id, mode, istat, item_id,item_value); !     	END; (* dbfind *)  	 $ Page $  %(***********************************************************************)  % %(*                                                                     *)  % %(*  PROCEDURE DBGET                                                    *)  % %(*                                                                     *)  % %(*  Purpose :  Remote-only interface to remote_dbget (RBGET).          *)  % %(*                                                                     *)  % %(* Parameters:                                                         *)  % %(*    (1) ibase.                                                       *)  % %(*    (2) set id.                                                      *)  % %(*    (3) mode. (1-7)                                                  *)  % %(*    (4) istat array.                                                 *)  % %(*    (5) item list.                                                   *)  % %(*    (6) return buffer.                                               *)  % %(*    (7) argument (used for modes 4 and 7).                           *)  % %(*                                                                     *)  % %(*  Returns :  (6) buffer of item values, corresponding to the items   *)  % %(*                   as listed in the item list buffer.                *)  % %(*             (4) return status buffer                                *)  % %(*                 - status (0 if successful)                          *)  % %(*                 - return item values buffer length                  *)  % %(*                 - current record number                             *)  % %(*                 - previous record number (mode 5 only)              *)  % %(*                 - next record number  (mode 5 only)                 *)  % %(*                                                                     *)  % %(***********************************************************************)  %     PROCEDURE DBGET  $ Alias 'DBGET' $     (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR item_list : item_list_type;       VAR item_values_buffer : data_record_type;      VAR user_argument : argument_type);           	BEGIN (* DBGET *)  	        remote_dbget (ibase, set_id, mode, istat, item_list,                    item_values_buffer, user_argument);      END; (* DBGET *)  $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(*  procedure DBINFO                                                 *)  $ $(*                                                                   *)  $ $(*  purpose : Remote-only interface to remote_dbinfo (RBINF)         *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) set/item id.                                               *)  $ $(*    (3) mode.                                                      *)  $ $(*    (4) istat.                                                     *)  $ $(*    (5) buffer for information.                                    *)  $ $(*                                                                   *)  $ $(*  returns : (1) return_status[1] is the status (0:successful)      *)  $ $(*                return_status[2] is the length of the info in      *)  $ $(*                                 return_buffer.                    *)  $ $(*                return_buffer has various information, dependent   *)  $ $(*                                 upon the mode.                    *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbinfo   $ Alias 'DBINF' $     (VAR ibase : ibase_type;       VAR data_id : item_set_name_type;   
    VAR mode  : short_int; 
     VAR return_status : stat_array;       VAR buffer : return_buffer_type);       BEGIN (* info *)         remote_dbinfo (ibase, data_id, mode, return_status, buffer)      END; (* info *)   $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBLOCK                                                  *)  $ $(*                                                                   *)  $ $(* purpose:                                                          *)  $ $(*    Remote-only interface to remote_dblock (RBLCK).                *)  $ $(*                                                                   *)  $ $(* parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) dummy (modes 1,2), set or sets (modes 3-8).                *)  $ $(*    (3) mode.                                                      *)  $ $(*    (4) istat array.                                               *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     FUNCTION dblock  $ Alias 'DBLCK' $     (VAR ibase : ibase_type;       VAR lock_request : lock_request_buffer;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type) : short_int;      	BEGIN (* dblock *) 	        dblock := remote_dblock (ibase, lock_request, mode, istat);      	END; (* DBLOCK *)  	 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBMEMO                                                  *)  $ $(*                                                                   *)  $ $(* purpose: Remote-only interface to remote_dbmemo (DBMEM).          *)  $ $(*                                                                   *)  $ $(* parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) user text.                                                 *)  $ $(*    (3) mode. (must be 1)                                          *)  $ $(*    (4) istat array.                                               *)  $ $(*    (5) user text length.                                          *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbmemo   $ Alias 'DBMEM' $     (VAR ibase : ibase_type;       VAR user_text : text_str;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len : short_int);      BEGIN (* memo *)         remote_dbmemo (ibase, user_text, mode, istat, text_len);       END; (* memo *)   $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(*  procedure DBOPEN                                                 *)  $ $(*                                                                   *)  $ $(*  purpose : Remote-only interface to remote_dbopen (RBOPN).        *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) level word.                                                *)  $ $(*    (3) mode. (1,3,5,8)                                            *)  $ $(*    (4) istat.                                                     *)  $ $(*                                                                   *)  $ $(*  returns : (1) index into the buffer pointer table which contains *)  $ $(*                the current run table (is the same as the local    *)  $ $(*                data base number)                                  *)  $ $(*            (4) status buffer                                      *)  $ $(*                - status (zero if successful)                      *)  $ $(*                - level word number                                *)  $ $(*                - indicator if highest level was obtained          *)  $ $(*                - data base read/write access                      *)  $ $(*                - logging status                                   *)  $ $(*                                                                   *)  $ $(*  NOTE :    This routine updates                                   *)  $ $(*            (1) DBBUF table                                        *)  $ $(*            (2) Run table                                          *)  $ $(*                - header information                               *)  $ $(*                - item and set table access indicators             *)  $ $(*                                                                   *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbopen   $ Alias 'DBOPN' $     (VAR ibase : ibase_type;       VAR ilevl : level_word_type;      VAR op_mode : short_int;      VAR istat : return_buffer_type);      	BEGIN (* dbopen *) 	        remote_dbopen (ibase, ilevl, op_mode, istat);      	END; (* dbopen *)  	 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBPUT                                                   *)  $ $(*                                                                   *)  $ $(* purpose : Remote-only interface to Remote_dbput (RBPUT).          *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) set id.                                                    *)  $ $(*    (3) mode. (must be 1)                                          *)  $ $(*    (4) istat array.                                               *)  $ $(*    (5) item list.                                                 *)  $ $(*    (6) value list.                                                *)  $ $(*                                                                   *)  $ $(* returns: (4) status buffer                                        *)  $ $(*             -status (0: successful)                               *)  $ $(*             -length of the item value buffer                      *)  $ $(*             -the new record number                                *)  $ $(*             -the number of records on the chain                   *)  $ $(*             -the chain predecessor record number                  *)  $ $(*             -the chain successor record number                    *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbput  $ Alias 'DBPUT' $     (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR item_list : item_list_type;       VAR item_value_buffer : item_value_buffer_type);          	BEGIN (* dbput *)  	        remote_dbput (ibase, set_id, mode, istat, item_list,                    item_value_buffer);      END; (* dbput *)  $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBUNDO                                                  *)  $ $(*                                                                   *)  $ $(* purpose: Remote-only interface to remote_dbundo (RBUND).          *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) user text.                                                 *)  $ $(*    (3) mode (must be 1).                                          *)  $ $(*    (4) istat.                                                     *)  $ $(*    (5) text length.                                               *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbundo   $ Alias 'DBUND' $     (VAR ibase : ibase_type;       VAR user_text : text_str;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len  : short_int);       	BEGIN (* dbundo *) 	        remote_dbundo (ibase, user_text, mode, istat, text_len);       	END; (* dbundo *)  	 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBUNLOCK                                                *)  $ $(*                                                                   *)  $ $(* purpose: Remote-only interface to remote_dbunlock (RBUNL).        *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) data set list for mode 2.                                  *)  $ $(*    (3) mode. (must be 1)                                          *)  $ $(*    (4) istat.                                                     *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbunlock   $ Alias 'DBUNL' $     (VAR ibase : ibase_type;       VAR setlst: lock_request_buffer; (* data set list *)  
    VAR mode  : short_int; 
     VAR istat : return_buffer_type);          
BEGIN (* dbunlock *) 
        remote_dbunlock (ibase, setlst, mode, istat);      
END; (* dbunlock *)  
 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* PROCEDURE DBUPDATE                                                *)  $ $(*                                                                   *)  $ $(* Purpose: Remote-only interface to remote_dbupdate (RBUPD).        *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) set id.                                                    *)  $ $(*    (3) mode. (must be 1)                                          *)  $ $(*    (4) istat array.                                               *)  $ $(*    (5) item list.                                                 *)  $ $(*    (6) value list.                                                *)  $ $(*                                                                   *)  $ $(* Returns:  (4) status buffer                                       *)  $ $(*               - status (0:successful)                             *)  $ $(*               - length of the buffer of item values               *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbupdate   $ Alias 'DBUPD' $     (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR item_list : item_list_type;       VAR user_buffer : data_record_type);      
BEGIN (* dbupdate *) 
        remote_dbupdate (ibase, set_id, mode, istat,                       item_list, user_buffer);      
END; (* DBUPDATE *)  
 . (* The end *)  