 $PASCAL ',7 92081-1X564 REV.2540' $       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18564                                        *)  ! !(* RELOC:   92081-1X564                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <stc> <TH>                                     *)  ! !(*                                                             *)  ! (* Date last modified: <851118.1451>  !(*                                                             *)  ! !(***************************************************************)  !     (**)  &(*:nl:$ATB, mrf_s1, %rf000, relocatable, 92081-16075 REV.2540 <851118.1451>  & (*:nl:$   
(*:nl:$COUNTER, 1, 1000, 1 
 (**)      
$ Include '[LBOPT' $ 
     PROGRAM initialize_rfr;       $ page $  $ list off $      $ Include '[IMAGE' $    (* General IMAGE defn's.   *)       $ Include '[BMCCT' $   (* DBMON constants and types *)      !$ Include '[DBRFR' $   (* DBRFR constants, types and variables *)  ! 
$ Include '[RFSG' $  
 $ Include '[NLRFR' $   (* NLS constants and vars *)       $ List ON $   $ page $  (**)  
(* External declaractions  
 (**)      $ Include '[XUSHF' $   (* Upshift externals              *)   $ Include '[XDSMR' $   (* string manipulation externals  *)   $ Include '[XDFMP' $   (* fmp routines                   *)   $ Include '[XDCIO' $   (* dbcon i/o routines externals   *)   $ Include '[XDGDN' $   (* get dbcon name external        *)   $ Include '[XWRTF' $   (* access root file               *)   $ Include '[XWOCL' $   (* open/close root file           *)   $ Include '[XWPDB' $   (* post data blocks               *)   $ Include '[XWPTS' $   (* pointer creation               *)   $ Include '[XUROC' $   (* re-open externals              *)       $ Include '[XRFR'  $   (* main externals *)   $ Include '[XRFL1' $   (* DBRFR library externals        *)       $ Include '[XDNLS' $   (* NLS externals *)  (*:nl:$COPY 'PROCEDURE &; EXTERNAL;' *)   PROCEDURE MRF_S1; EXTERNAL;       PROCEDURE ascii_to_short_int   $ alias 'CATI' $      ( VAR buffer : short_str;           start_char : short_int;           char_len : short_int;       VAR integer_value : short_int;        VAR return_status : short_int);     EXTERNAL;      FUNCTION break_flag   $ alias 'IFBRK' $      ( dummy : short_int) : short_int;     EXTERNAL;      $ page $  !(****************************************************************) ! !(*                                                              *) ! !(* Procedure determine_recov_start_vol                          *) ! !(*                                                              *) ! !(* Purpose : This procedure is determines which volume          *) ! !(* from within a roll forward log set, recovery should begin.   *) ! !(*                                                              *) ! !(****************************************************************) !     #PROCEDURE determine_recov_start_vol; $ alias 'RFR.DetRecovStartVol' $  #     (**)  (* initilizes globals -   (*   start_recov_vol_ix   (*   start_recov_xaction_num  (**)      VAR      db_num : short_int;      BEGIN          (**)      (* If the user provided us with a list of volumes then,  !   (* the start index into our scratch dbcon file should be one -  !    (* the first volume entered by the user.      (**)          IF volume_list_flag <> cur_dbcon THEN        start_recov_vol_ix := one;      #   (* if user has not provided us with an initial database list ... *) #    IF NOT (db_list_provided) THEN BEGIN   %      (* determine the actual start later, when we go through pass one *)  %       start_recov_xaction_num := maxdint;   
      END  (* if *)  
        ELSE BEGIN             (**)  !      (* User provided us with a database list.  Look through the  ! #      (* start transaction numbers for all the databaes and determine  # 
      (* the earliest one. 
       (**)            start_recov_xaction_num := maxdint;         FOR db_num := one to db_list_count DO           WITH start_vol_id_tbl[db_num] DO  !           IF xaction_number < start_recov_xaction_num THEN BEGIN  ! 	              (**) 	 $              (* If the user did not provided us with a list of volumes  $ %              (* then begin with the volume with the earlist tran number.  % 	              (**) 	               IF volume_list_flag = cur_dbcon THEN                   start_recov_vol_ix := vol_number;                start_recov_xaction_num := xaction_number;  	              END; 	           (**)         (* subtract the volume number where we will begin recovery   !      (* from the total number of volumes in the history table in  !       (* order to get the total number we are actually using.         (**)      $      num_recov_volumes := num_recov_volumes - start_recov_vol_ix + one; $           END;  (* else *)            (**)  END;  (* determine_recov_start_vol *)   $ page $  !(****************************************************************) ! !(*                                                              *) ! !(* Procedure determine_recov_set                                *) ! !(*                                                              *) ! !(* Purpose : This procedure determines the name of the roll     *) ! !(* forward logging set from which recovery will take place.     *) ! !(* This is done by first looking in DBCON for the set name.     *) ! !(* If DBCON does not exist or the user does not want to use     *) ! !(* the set in DBCON, we prompt the user to enter the desired    *) ! !(* set name.                                                    *) ! !(*                                                              *) ! !(****************************************************************) !     !PROCEDURE determine_recov_set;         $ alias 'RFR.DetRecovSet' $ !         (**)  (* Globals initialized :  
(*    recov_set_name 
 (*  (**)      LABEL      10,11;  (* NLS message tests *)      VAR      return_status : short_int;       BEGIN       %   IF (volume_list_flag = cur_dbcon) THEN BEGIN    (* use current dbcon *) %           (* get recovery set *)        IF read_dbcon_table (   
         dbcon_descriptor, 
 
         dbc_rfl_info_blk, 
          do_not_lock_dbcon_file,           dbcon_table.dbcon_rfl_info_block.block,           return_status) THEN           fatal_error (dbcon_read_err);            WITH dbcon_table.dbcon_rfl_info_block DO BEGIN           recov_set_name := rflf_set_name;   '         (* assume we will recover all volumes listed in dbcon hist. table *)  '          num_recov_volumes := rflf_vol_num;            END; (* with *)  	      END (* if *) 	        ELSE BEGIN             (**)  #      (* If dbcon does not exist or the user wants to use a different  #       (* set.         (**)            (* if interactive, prompt user *)         IF volume_list_flag = interactive THEN BEGIN  (*       temp_long_str := ' ENTER THE LOG SET NAME:   _'; *)           (*:nl:#*1 1000 ' ENTER THE LOG SET NAME:   _' *)       
10:  (* NLS tests *) 
     !         (*:nl:$COPY '         length := nlread (&, #, nlerr,' *)  !          length := nlread (MRF_S1, 1000, nlerr,                                                temp_long_str, len);            blank_pad (temp_long_str, chars_in_long_str, length);           IF write_long_str (              input_descriptor,   
            temp_long_str, 
             return_status) THEN               fatal_error (return_status);      
11:  (* NLS tesst *) 
              END;       
      (* read the input *) 
       IF read_long_str (           vol_list_descriptor,            temp_long_str,            return_status) THEN           fatal_error (return_status);         upshift_long_str (  
      temp_long_str, 
          temp_long_str,            chars_in_long_str);        (* truncate the long str to short str *)  
      truncate_str ( 
          temp_long_str,   
         recov_set_name);  
           END;  (* else *)      END; (* procedure determine_recov_set  *)       $ page $  !(****************************************************************) ! !(*                                                              *) ! !(* Procedure process_database_list                              *) ! !(*                                                              *) ! !(* Purpose - This procedure opens all the rootfiles which       *) ! !(* are given in the 'database_list' parameter. This parameter   *) ! !(* may be either an interactive device or a file.  If it        *) ! !(* is interactive, DBRFR prompts the user for input - a single  *) ! !(* database rootfile name.  We continue this until there is     *) ! !(* no more input ( end of file or user enters a carriage        *) ! !(* return).                                                     *) ! !(*                                                              *) ! !(* The reason we are opening all the rootfiles is to identify   *) ! !(* the oldest RFL volume we need in order to perform recovery   *) ! !(* on the given databases.  The volume names are stored in the  *) ! !(* rootfile header blocks.                                      *) ! !(*                                                              *) ! !(****************************************************************) !     !PROCEDURE process_database_list;     $ alias 'RFR.ProcessDBList' $ !         LABEL      12,13,14,15;  (* NLS message tests *)  VAR   #   return_status : short_int;  (* status of operations within here *)  # !   more_input : boolean;       (* flags if there is more input *)  !         (**)  (* This procedure reads a long string from an input file and  (* parses it as a database name.  (**)      PROCEDURE read_db_name_input (     VAR input_descriptor : file_descriptor);           (**)  (* uses the process_database_list variables   (*      more_input : boolean  - set to false if eof is reached  (*      return_status : short_int - status of the operation   (*  
(* global var used - 
  (*      temp_long_str : long_str - used to hold the input string   (**)      LABEL      10,11;  (* NLS message tests *)      VAR      start : short_int;    (* start char to begin parsing *)     tbl_ix : short_int;   (* index into start table *)      db_num : short_int;   (* index into the opn_database_tbl *)     database_name_str : short_str;      rt_header : rootfile_header_ptr_type;     open_status : short_int;          temp_desc : new_file_name;       BEGIN          (* read the database name - returned in temp_long_str *)      IF read_long_str ( input_descriptor,                         temp_long_str,                        return_status) THEN BEGIN         IF return_status = bof_eof_err THEN BEGIN            more_input := false;            return_status := zero;            END;   
      END  (* if *)  
        ELSE IF temp_long_str = ' '         THEN more_input := false  (* blank line is end of list *)           ELSE BEGIN (* we have a database name *)             (* upshift the string *)        upshift_long_str (           temp_long_str,            temp_long_str,            chars_in_long_str);            file_dest_long_srce (temp_desc, chars_in_new_file_name,                              temp_long_str, chars_in_long_str,                             str_assign, zero);             build_root_name (temp_desc);            (* open the database *)         IF reopn_uncls (  
         temp_desc,  
          db_num,           workhorse_data,           open_status)   THEN BEGIN               (* error occurred opening the database *)           truncate_str (temp_long_str, database_name_str);       "(*       temp_long_str := ' ERROR OCCURRED OPENING DATABASE    '; *) "          (*:nl:$ ' ' *)   $         (*:nl:$ ' Max. 16 bytes string is appended to this message' *)  $          (*:nl:#*1 1001 ' ERROR OCCURRED OPENING DATABASE ' *)      
10:  (* NLS tests *) 
     !         (*:nl:$COPY '         length := nlread (&, #, nlerr,' *)  !          length := nlread (MRF_S1, 1001, nlerr,                                                temp_long_str, len);            blank_pad (temp_long_str, chars_in_long_str, length);           positional_append_str (  
            temp_long_str, 
             database_name_str,              chars_in_short_str,               length);  (* character position to append *)      !         IF input_log_write_long_str(temp_long_str, return_status) !             THEN fatal_error (return_status);       
11:  (* NLS tests *) 
              fatal_error (open_status);            END            ELSE BEGIN           (**)            (* Add database entry to start table             (* - this proc also checks that the set name is valid.             (*   and will update the global db_list_count.            (**)            tbl_ix := db_list_count + one;            add_to_start_table (temp_desc, db_num, tbl_ix);      
         END;  (* else *)  
       END;  (* else *)      END;  (* proc read_db_name_input *)   $ page $      BEGIN (* proc process_database_list *)         (**)       (* If there is no database list parameter, then we must begin      (* recovery from the very first RFL volume in the set.      (**)          more_input := true;     db_list_provided := true;     IF NOT recover_specific_db_flag        THEN db_list_provided := false     ELSE IF NOT is_interactive_file (db_list_descriptor)         THEN WHILE more_input DO BEGIN           IF (break_flag (temp_short_int) = break_set)               THEN finish (false);               read_db_name_input(db_list_descriptor);           IF return_status <> zero               THEN fatal_error (return_status);   
         END   (* while *) 
           ELSE BEGIN (* interactive device *)                write_blank_line (               one,              input_descriptor);               WHILE more_input DO BEGIN                  IF (break_flag (temp_short_int) = break_set) THEN                  finish (false);                  (**)  $            (* prompt for input - the underscore must be in an even byte $              (* position in order to act as a control character.                (**)      &(*          temp_long_str := ' DATABASE (enter full database name)?  _'; *)  & $            (*:nl:#*1 1002 ' DATABASE (enter full database name)?  _' *) $     
12:  (* NLS tests *) 
     $            (*:nl:$COPY '            length := nlread (&, #, nlerr,' *)  $             length := nlread (MRF_S1, 1002, nlerr,                                            temp_long_str, len);  !            blank_pad (temp_long_str, chars_in_long_str, length);  !             IF write_long_str (input_descriptor,                                 temp_long_str,                                  return_status) THEN                 fatal_error (return_status);       
13:  (* NLS tests *) 
                 read_db_name_input(input_descriptor);               IF return_status <> zero THEN                  fatal_error (return_status);                   END;  (* while *)            END;       &   (* if the user did not enter any database names in response to prompt *)  &    IF (recover_specific_db_flag) AND        (db_list_count = zero) THEN BEGIN         (* write message and terminate *)   (*    temp_long_str := ' NO DATABASES TO PROCESS '; *)        (*:nl:#*1 1003 ' NO DATABASES TO PROCESS ' *)       
14:  (* NLS tests *) 
           (*:nl:$COPY '      length := nlread (&, #, nlerr,' *)         length := nlread (MRF_S1, 1003, nlerr,                                         temp_long_str, len);         blank_pad (temp_long_str, chars_in_long_str, length);   
      IF write_long_str (  
 
         input_descriptor, 
          temp_long_str,            return_status) THEN           fatal_error (return_status);       
15:  (* NLS tests *) 
           finish (normal_termination_flag);   
      END;  (* if *) 
     END;  (* process_database_list *)   $ page $  "(*****************************************************************)  " "(*                                                               *)  " "(* Procedure process_volume_list                                 *)  " "(*                                                               *)  " "(* Purpose - This procedure processes the volume list.  The      *)  " "(* volume list can be one of three things : (1) the current      *)  " "(* dbcon file  (2) an old dbcon file (3) an interactive LU       *)  " "(* from which we get information to create a scratch dbcon       *)  " "(* file.  By the time this routine is called, we have            *)  " "(* determined which of the three above categories it falls.      *)  " "(* This routine is used to gather information for the third      *)  " "(* category.  It prompts the user (on the input parameter, which *)  " "(* must be interactive) for volume identification and stores     *)  " "(* it in a scratch file, which is made to looks like             *)  " "(* dbcon.                                                        *)  " "(*                                                               *)  " "(*****************************************************************)  "     !PROCEDURE process_volume_list;     $ alias 'RFR.ProcVolumeList' $  !     LABEL      10,11,12,13,14,15;  (* NLS message tests *)      CONST      do_not_extend_file = false;      (**)  (* modifies the global 'num_recov_volumes' to the number  (* of volumes to read during recovery   (**)      VAR   
   more_entries : boolean; 
    entry_number : short_int;     table_entry : history_table_entry_type;     size_len : array [1..2] of long_int;      volume_name_str : short_str;   
   start_char : short_int; 
 
   num_subvol : short_int; 
        temp_str : short_str;      BEGIN          (**)      (* Create a scratch file which looks like dbcon but has a     (* different name.      (**)          IF create_scratch_file ('RFR', old_dbcon_descriptor) THEN;          temp_str := ':::1:1000';       !   (* We have the file name: Now append the file type/size info *) !    file_dest_short_srce                (old_dbcon_descriptor.newfl, chars_in_new_file_name,                temp_str, chars_in_short_str,               str_append, zero);           IF open_file_for_write (old_dbcon_descriptor, return_status)          THEN fatal_error (scratch_file_create_err);          more_entries := true;     entry_number := zero;         (* get user input (volume identification) *)      WHILE more_entries DO BEGIN            IF (break_flag (temp_short_int) = break_set) THEN            finish (false);            IF volume_list_flag = interactive THEN BEGIN               (* prompt the user for volume information *)   !(*       temp_long_str := ' NEXT VOLUME (file name or LU)?  _'; *) !           (*:nl:#*1 1004 ' NEXT VOLUME (file name or LU)?  _' *)        
10:  (* NLS tests *) 
     !         (*:nl:$COPY '         length := nlread (&, #, nlerr,' *)  !          length := nlread (MRF_S1, 1004, nlerr,                                          temp_long_str, len);            blank_pad (temp_long_str, chars_in_long_str, length);               (* write this string *)           IF write_long_str (              input_descriptor,   
            temp_long_str, 
             return_status) THEN               fatal_error (return_status);      
11:  (* NLS tests *) 
              END;             IF read_long_str (           vol_list_descriptor,            temp_long_str,            return_status) THEN BEGIN               (* end of input *)            IF return_status = bof_eof_err THEN BEGIN              more_entries := false;              (* if volume list input is a file, close it *)              IF volume_list_flag = vol_list_file THEN  $               IF close_file ( vol_list_descriptor, return_status) THEN; $             END            ELSE               fatal_error (return_status)            END            ELSE IF temp_long_str = ' ' THEN BEGIN           more_entries := false;            (* if volume list input is a file, close it *)            IF volume_list_flag = vol_list_file THEN   #            IF close_file ( vol_list_descriptor, return_status) THEN;  #          END      
      (* another entry *)  
       ELSE BEGIN           file_dest_long_srce  !             (temp_file_descriptor.newfl, chars_in_new_file_name,  !               temp_long_str, chars_in_long_str,                 str_assign, zero);               (* try opening the volume *)   "         IF open_existing_file (temp_file_descriptor, return_status) "             THEN BEGIN              truncate_str (temp_long_str, volume_name_str);      "(*          temp_long_str := ' ERROR OCCURRED OPENING VOLUME  '; *)  " 
            (*:nl:$ ' ' *) 
 %            (*:nl:$ ' Max. 16 bytes string is appended to this message' *) %              (*:nl:#*1 1005 ' ERROR OCCURRED OPENING VOLUME ' *)        
12:  (* NLS tests *) 
     $            (*:nl:$COPY '            length := nlread (&, #, nlerr,' *)  $             length := nlread (MRF_S1, 1005, nlerr,      "                                               temp_long_str, len);  " !            blank_pad (temp_long_str, chars_in_long_str, length);  !             positional_append_str (                  temp_long_str,                  volume_name_str,                  chars_in_short_str,                 length);   (* character position *)              IF input_log_write_long_str (                  temp_long_str,                  return_status) THEN                 fatal_error (return_status);       
13:  (* NLS tests *) 
                 return_status := zero;              END                ELSE BEGIN  (* successful volume open *)                    (* if not a disc file, should check if a magtape *)                    (* successful open - now close it *)  #            IF close_file (temp_file_descriptor, return_status) THEN;  #                 entry_number := succ (entry_number);                   (* save the file desc in the history table entry *)                 table_entry.log_name := temp_file_descriptor.newfl;                table_entry.used_volume_flag := true;       '            (* ask user for number of subvolumes until an integer is given *)  '             return_status := -1;              WHILE return_status <> zero DO BEGIN                     return_status := zero;                      IF volume_list_flag = interactive THEN BEGIN                      (* prompt user for the number of subvolumes *)   (*                temp_long_str :=  '                     '    NUMBER OF SUBVOLUMES (ENTER INTEGER VALUE)?  _'; *)  ' '      (*:nl:#*1 1006 '    NUMBER OF SUBVOLUMES (ENTER INTEGER VALUE)?  _'; *)  '     
14:  (* NLS tests *) 
     '      (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_long_str, len);' *)  ' !   length := nlread (MRF_S1, 1006, nlerr, temp_long_str, len);     !       blank_pad (temp_long_str, chars_in_long_str, length);                     IF write_long_str (                        input_descriptor,                       temp_long_str,                        return_status) THEN                       fatal_error (return_status);       
15:  (* NLS tests *) 
                       END;  (* if *)                     IF read_short_str (                    vol_list_descriptor,                    temp_short_str,                     return_status) THEN                     IF return_status = bof_eof_err THEN                         num_subvol := zero                    ELSE                        fatal_error (return_status);                     (* convert to ascii *)                  ascii_to_short_int (                     temp_short_str,                     one,                    chars_in_short_str,                     num_subvol,                     return_status);                   END;  (* while *)                   (* save number of subvolumes into entry *)              table_entry.num_subvolumes := num_subvol;                   (* write the entry to disc *)               IF write_history_table_entry (                 old_dbcon_descriptor,                 do_not_unlock_dbcon_file,                 entry_number,                 table_entry,                  return_status) THEN                 fatal_error (return_status);                   END;  (* else successful open *)               END;  (* else there was input *)             END; (* while there is input *)          (* the number of volumes entered *)     num_recov_volumes := entry_number;       &   (* the first volume index into the dbcon history entries is set to one *) &    start_recov_vol_ix := one;       END;  (* proc process_volume_list *)  $ Page $   (*************************************************************)     (*                                                           *)     (* FUNCTION redo_close                                       *)     (*                                                           *)     (*************************************************************)            FUNCTION redo_close    $ alias 'RFR.RedoClose'$     (VAR log_rec : ptr_log_record_header_type;         abort_flag : boolean;     VAR workhorse_data : workhorse_info_type;     VAR return_status : short_int) : boolean;      BEGIN       
   IF recls_unopn (  
       log_rec^.close.db_name_id,        workhorse_data,   
      return_status) THEN  
       redo_close := true     ELSE   
      redo_close := false; 
     END;          FUNCTION post_buffers     $ alias 'RFR.PostBuffers'$     ( VAR  workhorse_data : workhorse_info_type;        VAR  return_status : short_int) : BOOLEAN;       BEGIN          IF post_data_blocks (        workhorse_data,   
      return_status) THEN  
       post_buffers := true  (* error occurred *)        ELSE   (* no error posting buffers *)   
      IF post_run_tables ( 
          workhorse_data,           return_status) THEN           post_buffers := true  (* error occurred *)         ELSE           post_buffers := false;  (* no errors occured *)      END;  $ page $   (*************************************************************)     (*                                                           *)     (* Procedure database_open                                   *)     (*                                                           *)     (* Input :                                                   *)     (*      (1) tbl_ix - This is an index into the start table.  *)     (*          The entry in the start table is to contain our   *)     (*          internal database number for the database we     *)     (*          want opened, as well as the starting transaction *)     (*          number for that database.                        *)     (*             If the user did not provided us with a list   *)     (*          of databases, this tbl_ix is the system database *)     (*          number for the database when it was originally   *)     (*          opened (during normal processing).  We get       *)     (*          this index from the log record.                  *)     (*                                                           *)     (*************************************************************)        PROCEDURE database_open  $ alias 'RFR.DatabaseOpen' $      (VAR tbl_ix : short_int;   $ heapparms on $      VAR db_nam  : new_file_name;  	$ heapparms off $  	     VAR return_status : short_int);       VAR      do_open : boolean;      db_ix : short_int;          db_desc : new_file_name;       BEGIN          WITH start_vol_id_tbl[tbl_ix] DO BEGIN          (* Does an entry already exist for our index? *)      IF rf_db_num <> zero THEN BEGIN            (**)        (* Yes...         (* Is the database occupying this entry the same as the         (* one we want opened?        (**)            db_desc := db_nam;  (* make a local copy *)       
      IF find_root ( 
 	         db_desc,  	          db_ix,            workhorse_data,           return_status) THEN           fatal_error(return_status);            IF db_ix < zero THEN BEGIN  (* not open *)               (**)            (* Close the database currently occupying the entry           (* because it must have originally be closed during           (* cleanup (hence no log record for the close).           (* Then open the one we want.           (**)       
         IF recls_unopn (  
 
            db_nam,  
             workhorse_data,               return_status) THEN               fatal_error (dbrfr_internal_err);   
         do_open := true;  
              END  (* IF *)            ELSE    (* database is already open, do nothing *)  
         do_open := false  
           END          (* no entry in table - do the open *)         ELSE         do_open := true;         IF do_open THEN BEGIN            IF reopn_uncls (           db_nam,           db_ix,            workhorse_data,           return_status) THEN           (* need to handle this error differently *)           fatal_error (dbrfr_internal_err);        (* save information into the table *)   
      add_to_start_table ( 
 	         db_desc,  	          db_ix,     (* our internal database number *)  '         tbl_ix);   (* original system database number/current table index *)  '           END;      
   END;  (* with *)  
     END;  .  