$PASCAL ',7 92081-16560 REV.5000' $  $ Title 'DBRFR: DB Roll Forward Recovery ' $ $ Subtitle 'DBRFR utility routines' $  $ Heap 2 $ $ Recursive OFF $ $ Subprogram  $ $ Range OFF $      PROGRAM RFLIB;      #(* **************************************************************** *) # #(* * (C) Copyright 1983 Hewlett-Packard.  All rights reserved.    * *) # #(* * No part of this program may be photocopied, reproduced or    * *) # #(* * translated to another program language without the express   * *) # #(* * written consent of Hewlett-Packard Company.                  * *) # #(* **************************************************************** *) #     #(********************************************************************) # #(*                                                                  *) # #(* PROGRAM : DBRFR utility routines.                                *) # #(*                                                                  *) # #(* PURPOSE : These routines perform operations for the DBRFR        *) # #(*           program. Some of the main routines are:                *) # #(*                                                                  *) # #(*           (1) finish                                             *) # #(*           (2) process_parameters                                 *) # #(*                                                                  *) # #(*                                                                  *) # #(* PGMR:        <stc> <TH>                                          *) # #(*                                                                  *) # #(* SOURCE:  92081-18560                                             *) # #(* RELOC:   92081-16560                                             *) # #(*                                                                  *) #(* Date of last modification: <870414.1630>  #(*                                                                  *) # #(********************************************************************) # (**)  &(*:nl:$ATB, mrfll , %rf000, relocatable, 92081-16075 REV.2540  <870414.1630> &(*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**) $ List OFF, Include '[IMAGE', List ON $      $$ List OFF, Include '[BMCCT', List ON $   (* Workhorse const. & types *) $ $$ List OFF, Include '[DBRFR', List ON $   (* Workhorse const. & types *) $     $ List OFF, Include '[NLRFR', List ON $   (* NLS const. & vars *)       $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) #     $ Page $ $ heapparms off $      PROCEDURE load_segment $ alias 'Pas.SegmentLoad' $    ( segment_name : Prog_name);     EXTERNAL;     FUNCTION compare_short_string $ alias 'DBCMW' $    ( VAR string1 : short_str;      VAR string2 : short_str;           len : short_int) : short_int;     EXTERNAL;      	$ heapparms off $  	 #(* Ascii_to_long_int converts an ascii string into a numeric value. *) # #(* The starting character position, and the number of characters to *) # #(* convert is required.  A long_int value is returned.              *) #     PROCEDURE ascii_to_long_int   $ Alias 'CATDI'$  
   ( VAR ascii: parm_str;  
 
         start: short_int; 
          len: short_int;  
     VAR value: long_int;  
 
     VAR err: short_int ); 
    EXTERNAL;          (**** Convert a short_int value to ascii string ****)       PROCEDURE convert_shorti_to_ascii   $ Alias 'CITA' $     (    short_int_value : Short_int;      VAR return_string   : Short_str);      EXTERNAL;          (**** Convert a long_int value to ascii string ****)      PROCEDURE convert_longi_to_ascii  $ Alias 'CDITA' $      (    long_int_value : Long_int;      VAR return_string  : Long_int_str_type);     EXTERNAL;          FUNCTION make_log_rec_ptr  $ alias 'EMA.ADDRTOPTR' $  $ heapparms on $     ( VAR  addr  : disc_block;       VAR ptr    : ptr_log_record_header_type; $ Heapparms off $       VAR status : short_int) :    BOOLEAN;     EXTERNAL;         (*** Do device transfer ****) $ Heapparms off $ FUNCTION do_device_transfer $ alias 'WKDIO' $    (     code          : short_int;       VAR tape_dcb      : dcb_type;          word_len      : short_int;  $ heapparms on $      VAR buffer_addr   : short_int; $ heapparms off $      VAR words_read    : short_int;       VAR return_status : short_int ) :    BOOLEAN;     EXTERNAL;      $ Include '[XDGDN' $    (* Get-DBCON-file-name external *)     $ Include '[XUSHF' $    (* Upshift external Defn's *)     $ Include '[XDSLJ' $    (* External defn's for zero-suppress *) !                            (* and left justification of result. *) !         (**** do a device I/O control function ****)      FUNCTION device_control_operation  $ alias 'DBIOC' $     ( VAR device_name : dcb_type;          fctn_code : device_ctrl_fctn_type;      VAR return_status : short_int): BOOLEAN;     EXTERNAL;      (**** Upshift a DBRFR parameter string ****)     $ heapparms off $ PROCEDURE upshift_parm_str  $ Alias 'UPSHIFT' $     (VAR instring : Parm_str;      VAR outstring: Long_str;          chars    : Short_int);     EXTERNAL;      FUNCTION make_label_ptr     $ alias 'EMA.ADDRTOPTR' $   $ Heapparms on $  
   ( VAR addr : short_int; 
      VAR ptr  : ptr_rfl_label_type;  $ Heapparms off $      VAR status : short_int) : BOOLEAN;     EXTERNAL;     FUNCTION check_sum   $ alias 'EMA.Checksum' $  $ Heapparms on $    ( VAR buffer : rfl_tape_buffer_type; $ Heapparms off $           start_word : short_int;          end_word : short_int) : short_int;     EXTERNAL;     FUNCTION break_flag $ alias 'IFBRK' $    ( dummy : short_int): short_int;     EXTERNAL;          (**** Issue a fatal error message and terminate DBRFR. ****)      PROCEDURE fatal_error   $ Alias 'RFR.FatalError' $     ( error : short_int);     EXTERNAL;     $ LIST OFF, INCLUDE '[XDSMR' ,LIST ON $ $ LIST OFF, INCLUDE '[XDFMP' ,LIST ON $ $ LIST OFF, INCLUDE '[XDCIO' ,LIST ON $ $ LIST OFF, INCLUDE '[XWDDT' ,LIST ON $     $ LIST OFF, INCLUDE '[XDNLS' ,LIST ON $   (* NLS externals *) (*:nl:$COPY 'PROCEDURE &; EXTERNAL;' *)  PROCEDURE MRFLL; EXTERNAL;          $ Page $ $ heapparms off $ "(*******************************************************************) ""(*                                                                 *) ""(* Function  input_log_write_long_str                              *) ""(*                                                                 *) ""(* Purpose : This function  writes a long str to both the          *) " #(* input &  log file.  If they are the same file, the string       *)  # #(* is written only once.  This is useful for writing error         *)  # #(* messages.                                                       *)  # #(*                                                                 *)  # #(* Returns fctn value false if successful, true otherwise.         *)  # #(*                                                                 *)  # #(*******************************************************************)  #     !FUNCTION input_log_write_long_str    $ alias 'RFR.InputLogWrite' $ !    ( VAR string : long_str;        VAR status : short_int): boolean;      LABEL 99;          BEGIN     
   (* assume error *) 
    input_log_write_long_str := true;         IF write_long_str (       input_descriptor,       string,  	      status) THEN 	       GOTO 99;     IF input_descriptor.newfl <> log_descriptor.newfl       THEN IF write_long_str (log_descriptor, string, status)           THEN GOTO 99;        (* no error *)    input_log_write_long_str := false;      	99 :  (* return *) 	    END;  (* end fctn input_log_write_long_str *)  $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* Function lock_unlock_non_interactive_device                      *) # #(*                                                                  *) # #(* Purpose- This function checks that a file descriptor is          *) # #(* a non-interactive device.  If so, then it locks or unlocks it.   *) # #(*                                                                  *) # #(********************************************************************) #    $FUNCTION lock_unlock_non_interactive_device   $ alias 'RFR.LckUnlckDev' $ $    ( VAR general_descriptor : file_descriptor;           lock_flag : lock_types;       VAR return_status : short_int) : BOOLEAN;     BEGIN    (* taken care of by new file system calls *)    lock_unlock_non_interactive_device := false;  END;  $ Page $  PROCEDURE write_blank_line  $ alias 'RFR.WriteBlankLine' $   (    num_lines : short_int;    VAR out_descriptor : file_descriptor);     VAR    temp_str : long_str;     status : short_int;     BEGIN     	   temp_str := ' '; 	   IF write_long_str (out_descriptor, temp_str, status)        THEN fatal_error (status);      END;  $ Page $  #(********************************************************************) # #(*                      finish                                      *) # #(********************************************************************) # #(*                                                                  *) # #(* Finish cleans up the DBRFR environment, closing the input files, *) # #(* list file, and log file.  The message "DBRFR finished" is        *) # #(* displayed to the input file if it is interactive.                *) # #(*                                                                  *) # #(* If the parameter 'done_flag' is false, then the user did not     *) # #(* wish continuation of this program.  A message is displayed to    *) # #(* indicate this.                                                   *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE finish   $ Alias 'Rfr.Finish'$     (     done_flag : boolean);     LABEL     10,11,12,13;  (* NLS message tests *)     VAR  
   temp_string : Long_str; 
   return_status : short_int;      	BEGIN (* finish *) 	        IF NOT (done_flag) THEN BEGIN (*    temp_string := ' DBRFR EARLY TERMINATION REQUESTED. '; *)        (*:nl:#*1 1000 ' DBRFR EARLY TERMINATION REQUESTED. ' *)      
10:  (* NLS tests *) 
          (*:nl:$COPY '      length := nlread (&, #, nlerr,' *)       length := nlread (MRFLL, 1000, nlerr,                                        temp_string, len);       blank_pad (temp_string, chars_in_long_str, length);  "      IF input_log_write_long_str (temp_string, return_status) THEN; "     
11:  (* NLS tests *) 
           END;        (* clear the crash flag *)    IF volume_list_flag = cur_dbcon THEN BEGIN 
      IF read_dbcon_table ( 
 
         dbcon_descriptor, 
          dbc_status_blk,          lock_dbcon_file,           dbcon_table.dbcon_status_block.block,           return_status) THEN          fatal_error (return_status);        dbcon_table.dbcon_status_block.flag.crash_flag := false;        IF write_dbcon_table (  
         dbcon_descriptor, 
          dbc_status_blk, 
         unlock_dbcon_file, 
          dbcon_table.dbcon_status_block.block,           return_status) THEN          fatal_error (return_status);        END;        (* display finish message *)     write_blank_line (one, input_descriptor); (* temp_string := ' *** DBRFR finished ***'; *)     (*:nl:#*1 1001 ' *** DBRFR finished ***' *)      
12:  (* NLS tests *) 
     $   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_string, len);' *) $   length := nlread (MRFLL, 1001, nlerr, temp_string, len);         blank_pad (temp_string, chars_in_long_str, length);     IF input_log_write_long_str (temp_string, return_status) THEN;       
13:  (* NLS tests *) 
        (* close all known files (ignore errors) *)     IF close_file (input_descriptor, return_status) THEN;    IF close_file (list_descriptor, return_status) THEN;     IF close_file (log_descriptor, return_status) THEN;     IF close_file (dbcon_descriptor, return_status) THEN;     IF close_file (redo_list_file_descriptor, return_status) THEN;         (* purge scratch redo list file *)     IF purge_file (redo_list_file_descriptor, return_status) THEN;         (* terminate - no error *)     fatal_error (zero);     END; (* finish *)  $ page $  #(********************************************************************) # #(*                                                                  *) # #(* Open up the default file in case when we get an error processing *) # #(* a run string parameter.                                          *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE default_file_open   $ alias 'RFR.DefFileOpen'$    (VAR file_id : file_descriptor);     CONST     empty_long_str = long_str [chars_in_long_str OF ' '];     do_not_extend_file = false;         VAR    return_status : short_int;  
   temp_string : long_str; 
    BEGIN         default_file (file_id.newfl);        IF open_existing_file (file_id, return_status) THEN;      END;  $ page $  #(********************************************************************) # #(* Procedure  process_parameters                                    *) # #(*                                                                  *) # #(* Purpose : Process_parameters processes the DBRFR run string.     *) # #(* "DBRFR ready" is displayed to the input file (must be            *) # #(* interacitve - is DBRFR's prompt file).                           *) # #(*                                                                  *) # #(* Input :                                                          *) # #(*                                                                  *) # #(* The parameters which are expected in parameter_buffer are:       *) # #(*                                                                  *) # #(*     parameter          type                                      *) # #(*                                                                  *) # #(* [1] <input_descriptor> non/int                                   *) # #(* [2] <list-file>        non/int/asc                               *) # #(* [3] <log-file>         non/int/asc                               *) # #(* [4] <maint-word>       asc                                       *) # #(* [5] <'SU' or 'DE'>     non/asc                                   *) # #(* [6] <'AB' or 'CO'>     non/asc                                   *) # #(* [7] <db_name_file>     non/asc                                   *) # #(* [8] <volume_list>      asc/int                                   *) # #(*                                                                  *) # #(* Returns :                                                        *) # #(*    (2) return_status   (0 if successful)                         *) # #(*                                                                  *) # #(* Called by :                                                      *) # #(*                                                                  *) # #(* Calls :                                                          *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE process_parameters   $ Alias 'Rfr.ProcParameters'$    ( VAR parameter_buffer: parm_buffer;       VAR return_status : short_int);     CONST     do_not_extend_file = false;     extend_file = true;    empty_short_str = short_str [chars_in_short_str OF ' '];     empty_long_str = long_str [chars_in_long_str OF ' '];     VAR  
   maint_word : short_str; 
 
   temp_string : Long_str; 
         BEGIN (* process_run_string *)        (**)  $   (* set the list and log descriptors to undefined in case we encounter $   (* an error before processing them    (**)     list_descriptor.newfl := ' ';    log_descriptor.newfl := ' ';             WITH parameter_buffer.parameter[3] DO BEGIN      	      IF typ = non 	         THEN default_file (input_descriptor.newfl)          ELSE file_dest_long_srce  !                  (input_descriptor.newfl, chars_in_new_file_name, !                    ascii, chars_in_long_str,                    str_assign, zero);      $      IF open_existing_file (input_descriptor, return_status) THEN BEGIN $          (* open the default file for writing error *)           default_file_open (input_descriptor);          fatal_error (specified_lu_aint_interactive_err);          END;            (* check to make sure it is interactive *)        IF NOT is_interactive_file (input_descriptor) THEN BEGIN           default_file_open (input_descriptor);          fatal_error (specified_lu_aint_interactive_err);          END;     
      END; (* WITH *) 
           (* check list file name *)     WITH parameter_buffer.parameter[4] DO BEGIN  	      IF typ = non 	          THEN default_file (list_descriptor.newfl)          ELSE file_dest_long_srce                    (list_descriptor.newfl, chars_in_new_file_name,                      ascii, chars_in_long_str,                    str_assign, zero);            IF open_file_for_append (list_descriptor, return_status)           THEN fatal_error (return_status);         
      END; (* WITH *) 
            (* check log file name *)     WITH parameter_buffer.parameter[5] DO BEGIN  	      IF typ = non 	         THEN default_file (log_descriptor.newfl)          ELSE file_dest_long_srce                     (log_descriptor.newfl, chars_in_new_file_name,                      ascii, chars_in_long_str,                    str_assign, zero);            (* will return updated log descriptor *)  $      IF open_file_for_append (log_descriptor, return_status) THEN BEGIN $$         (* indicate undefined so fatal error writes to input, not log *) $         log_descriptor.newfl := ' ';          fatal_error (return_status);          END;     
      END; (* WITH *) 
       (**)     (* What type of statistics does this user want generated?     (* 'SU' - summary information  'DE' - detailed information      (**)          WITH parameter_buffer.parameter[7] DO BEGIN      	      CASE typ OF  	              non : (* no parameter - use default value *)               detail_statistics := false;                int : (* integer parameter - error *)              fatal_error ( illegal_statistics_option_err);                asc : (* legal type - now is it 'SU' or 'DE' *)              IF ascii = 'SU' THEN                 detail_statistics := false               ELSE                 IF ascii = 'DE' THEN                     detail_statistics := true   
               ELSE  
                   fatal_error (illegal_statistics_option_err);      
         END;  (* case *)  
           END;  (* with *)         (**)       (* Does the user want us to abort upon encountering an error?      (* 'AB' - abort upon error.  'CO' - continue upon error     (**)          WITH parameter_buffer.parameter[8] DO BEGIN      	      CASE typ OF  	              non : (* no parameter - use default value *)               abort_on_error := true;                int : (* integer parameter - error *)  !            fatal_error ( illegal_abort_option_in_run_string_err); !              asc : (* legal type - now is it 'AB' or 'CO' *)              IF ascii = 'CO' THEN                 abort_on_error := false              ELSE                 IF ascii = 'AB' THEN                     abort_on_error := true  
               ELSE  
 $                  fatal_error (illegal_abort_option_in_run_string_err);  $     
         END;  (* case *)  
           END;  (* with *)      '   (* Has the user provided a list of databases which are to be recovered? *)  '    WITH parameter_buffer.parameter[9] DO BEGIN           IF typ = non THEN           recover_specific_db_flag := false        ELSE BEGIN           file_dest_long_srce              (db_list_descriptor.newfl, chars_in_new_file_name,               ascii, chars_in_long_str,                str_assign, zero);              (* a file of database names are given *)           recover_specific_db_flag := true;      !         IF open_existing_file (db_list_descriptor, return_status) !            THEN fatal_error (return_status);          END;  (* else *)            END;  (* with *)            (**) "   (* Has the user provided a file name which is either an input file " "   (* of names or is an interactive lu? (for a list of volume names) "   (**)        WITH parameter_buffer.parameter[10] DO BEGIN           IF typ  = non THEN   (* none defined *)              (**)  !         (* If the current DBCON is inaccessible, we must indicate ! "         (* that we will prompt the user interactively for the info. "         (**)          IF (dbcon_accessible = false) THEN BEGIN              default_file (old_dbcon_descriptor.newfl);              volume_list_flag := interactive;             END          ELSE   (* current dbcon is accessible *) !            volume_list_flag := cur_dbcon   (* use current dbcon *) !           ELSE BEGIN  (* parameter is defined *)               file_dest_long_srce               (old_dbcon_descriptor.newfl, chars_in_new_file_name,                ascii, chars_in_long_str,                str_assign, zero);     
         IF typ = int 
             THEN volume_list_flag := interactive             ELSE volume_list_flag := vol_list_file;               file_dest_long_srce (vol_list_descriptor.newfl,                               chars_in_new_file_name,                               ascii, chars_in_long_str,                                str_assign, zero);      "         IF open_file_for_write (vol_list_descriptor, return_status) "            THEN fatal_error (return_status);               END; (* else *)            END;  (* with *)            (* check maintenance word *)     WITH parameter_buffer.parameter[6] DO BEGIN  	      IF typ = non 	         THEN maint_word := empty_short_str 	         ELSE BEGIN 	             upshift_parm_str (ascii,                                temp_string,                               chars_in_parm_str);                 truncate_str (temp_string, maint_word);           END; (* else *) 
      END; (* WITH *) 
        (* test maintenance word *)    IF read_dbcon_table (dbcon_descriptor,                         dbc_status_blk,                          do_not_lock_dbcon_file,                           dbcon_table.dbcon_status_block.block,                           return_status)        THEN fatal_error (dbcon_read_err);        (* if maint word is blanks then accept any word *)    IF dbcon_table.dbcon_status_block.maint_word <> ' ' THEN        IF (compare_short_string ( 
          maint_word, 
           dbcon_table.dbcon_status_block.maint_word,           words_in_short_str) <> zero) THEN              fatal_error (maint_word_required_err);     END; (* process_parameters *)  $ Page $  PROCEDURE ask_user     $ alias 'RFR.AskUser' $     ( VAR string_to_ask : long_str; 
     VAR result : boolean); 
    VAR     status : short_int;     in_str : short_str;  	   ix : short_int; 	    illegal_response : boolean;     BEGIN         illegal_response := true;     WHILE (illegal_response) DO BEGIN           IF (break_flag (temp_short_int) = break_set) THEN           finish (false);     
      status := zero; 
       IF write_long_str (input_descriptor, string_to_ask, status)           THEN fatal_error (status);     "      IF read_short_str (input_descriptor, in_str, status) THEN BEGIN "          IF status <> bof_eof_err THEN fatal_error (status);           (* else response was a carriage return - ask again *)           END            ELSE BEGIN                upshift_short_str (in_str, in_str, chars_in_short_str);       #         (* Is the answer a Yes or No?  Look at first nonblank char *) #	         ix := one; 	 !         WHILE (in_str[ix] = ' ') and (ix < chars_in_short_str) DO !             ix :=  succ(ix);          illegal_response := false;           IF in_str[ix] = 'Y' THEN   
            result := true 
         ELSE              IF in_str[ix] = 'N' THEN                 result := false              ELSE                 illegal_response := true;              END;  (* end else *)      
   END;  (* while *) 
     END;  (* proc *)  $ page $ "(*******************************************************************) ""(*                                                                 *) ""(* Procedure tell_user_wrong_volume                                *) ""(*                                                                 *) ""(* Purpose : This is used by get_next_volume when a volume         *) ""(* accessed is not the one needed.  It reports the problem and     *) ""(* asks the user for the correct volume and response.              *) ""(*                                                                 *) ""(* If the user responds with a 'no', then we terminated by         *) ""(* calling finish.                                                 *) ""(*                                                                 *) ""(*******************************************************************) "     PROCEDURE tell_user_wrong_volume   $ alias 'RFR.WrongVolume' $   (VAR error_mesg : long_str; 
   VAR response : boolean); 
    LABEL  
   10,11;  (* NLS tests *) 
    BEGIN     write_blank_line (one, input_descriptor);      !   IF write_long_str (input_descriptor, error_mesg, return_status) !      THEN fatal_error (return_status);     	(* temp_long_str := 	 '      ' Make available the correct volume.  Ready (YES OR NO TO ABORT)? _'; *) '       (*:nl:#*1 1002 ' Make available the correct volume.  &' *)    (*:nl:#        'Ready (YES when ready, NO to abort)? _' *)      
10:  (* NLS tests *) 
     %   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_long_str, len);' *) %   length := nlread (MRFLL, 1002, nlerr, temp_long_str, len);     blank_pad (temp_long_str, chars_in_long_str, length);         ask_user (temp_long_str, response);      
11:  (* NLS tests *) 
        write_blank_line (one, input_descriptor);      
   IF not (response) 
      THEN finish (response);     END;  (* proc wrong_volume *)      $ page $   (**************************************************************)    (*                                                            *)    (* Procedure get_next_volume                                  *)    (*                                                            *)    (* Purpose - This procedure gets the next volume of           *)    (* the roll forward log volumes.  If it is tape, it makes     *)    (* sure the volume is mounted.  The volume is opened here.    *)    (*                                                            *)    (**************************************************************)       PROCEDURE get_next_volume       $ alias 'RFR.GetNextVol' $     (     vol_ix : short_int;          subvol_ix : short_int;       VAR history_entry : history_table_entry_type;       VAR cur_rfl_descriptor : file_descriptor;       VAR return_status : short_int);     LABEL           12,13,15,16,17,18,19, 
   20,22,23,24,26,27,28,29, 
   30,31,32,33,34,35,36,37;         (* NLS message tests *)     VAR 
   file_not_open : boolean; 
   lu_string     : short_str; 
   response      : boolean; 
   log_name_in_ascii : short_str;     label_ptr     : ptr_rfl_label_type;    msgno         : short_int;    length1       : short_int;    length2       : short_int;     BEGIN        (* what type volume is it? file or tape *)     WITH history_entry DO BEGIN            (* Tape LU's are a number from 1 to 255 *) "      IF (log_name[one] >= '0') AND (log_name[one] <= '9') THEN BEGIN "             (**)          (* If we did not get the volume names interactively,           (* we know the logical tape name.          (**)               (* convert the lu to an ascii string *) "         short_dest_file_srce (log_name_in_ascii, chars_in_short_str, "                                 log_name, chars_in_new_file_name,                                 str_assign, zero);               write_blank_line (one, input_descriptor);      $         (* Prepare message for user - case : we know the volume name *) $          IF (volume_list_flag <> interactive) THEN BEGIN  (*       temp_long_str := ' Please mount volume: '; *)  (*:nl:$ ' ' *) $(*:nl:$ ' Next two messages are concatenated ,so these should be within ' $ %(*:nl:$ ' 127 bytes with two 16 bytes strings.                           ' % &(*:nl:$ ' Please mount volume: <16 bytes str> subvolume: <16 bytes str>  '*) &          (*:nl:#*1 1003 ' Please mount volume:  ' *)      
12:  (* NLS tests *) 
     !         (*:nl:$COPY '         length1 := nlread (&, #, nlerr,' *) !         length1 := nlread (MRFLL, 1003, nlerr,                                              temp_long_str, len);          blank_pad (temp_long_str, chars_in_long_str, length1);               positional_append_str (temp_long_str, logical_name,                                 chars_in_short_str, length1);              IF subvol_ix > zero THEN BEGIN (*          temp_short_str := ' subvolume:  '; *)             (*:nl:#*1 1004 ' subvolume:  ' *)  %            (*:nl:$COPY '            length2 := nlread_s (&, #, nlerr,' *) %             length2 := nlread_s (MRFLL, 1004, nlerr,      "                                               temp_short_str, len); " #            blank_pad_s (temp_short_str, chars_in_short_str, length2); #             positional_append_str (temp_long_str, temp_short_str,  !                                   chars_in_short_str, length1+17); !                 temp_short_str := ' ';                   convert_shorti_to_ascii (subvol_ix, temp_short_str);                   positional_append_str (temp_long_str, temp_short_str,                                      chars_in_short_str,                                    length1+17+length2);              END;     %         IF write_long_str (input_descriptor, temp_long_str, return_status) %            THEN fatal_error (Return_status);      
13:  (* NLS tests *) 
    (*       temp_long_str := '    on LU'; *)          (*:nl:$ ' ' *) #         (*:nl:$ ' Max. 16 bytes string is appended to this message' *) #          (*:nl:#*1 1005 '    on LU  ' *)               (*:nl:$COPY '         length := nlread (&, #, nlerr,' *)            length := nlread (MRFLL, 1005, nlerr,                                              temp_long_str, len);           blank_pad (temp_long_str, chars_in_long_str, length);               positional_append_str (temp_long_str, log_name_in_ascii,                                   chars_in_short_str, length);      
15:  (* NLS tests *) 
              END           ELSE BEGIN   (* case: we don't know the logical name *)              IF subvol_ix > zero THEN BEGIN  (*          temp_long_str := ' Please mount volume on LU '; *)  
            (*:nl:$ ' ' *) 
 %            (*:nl:$ ' Max. 16 bytes string is appended to this message' *) %            (*:nl:#*1 1006 ' Please mount volume on LU ' *)      
16:  (* NLS tests *) 
    #            (*:nl:$COPY '            length := nlread (&, #, nlerr,' *) #            length := nlread (MRFLL, 1006, nlerr,     !                                               temp_long_str, len); !             blank_pad (temp_long_str, chars_in_long_str, length);   "            positional_append_str (temp_long_str, log_name_in_ascii, "                                   chars_in_short_str, length);      
17:  (* NLS tests *) 
                END 	         ELSE BEGIN 	 !(*          temp_long_str := ' Please mount subvolume number:'; *) ! 
            (*:nl:$ ' ' *) 
 %            (*:nl:$ ' Max. 16 bytes string is appended to this message' *) %             (*:nl:#*1 1007 ' Please mount subvolume number:  ' *)       
18:  (* NSL tests *) 
    #            (*:nl:$COPY '            length := nlread (&, #, nlerr,' *) #            length := nlread (MRFLL, 1007, nlerr,     !                                               temp_long_str, len); !             blank_pad (temp_long_str, chars_in_long_str, length);                convert_shorti_to_ascii (subvol_ix, temp_short_str);                   positional_append_str (temp_long_str, temp_short_str,                                     chars_in_short_str, length);      
19:  (* NLS tests *) 
                 END;  (* else begin subvolume *)          END; (* end else we don't know the logical name *)      $      IF write_long_str (input_descriptor, temp_long_str, return_status) $          THEN fatal_error (return_status);      
20:  (* NLS tests *) 
           (* get response *)  (*    temp_long_str :=                ' Ready (YES when ready, NO to abort)?  _'; *)  !      (*:nl:#*1 1008 ' Ready (YES when ready, NO to abort)?  _' *) !      (*:nl:$COPY '      length := nlread (&, #, nlerr,' *)       length := nlread (MRFLL, 1008, nlerr,                                    temp_long_str, len);       blank_pad (temp_long_str, chars_in_long_str, length);           ask_user (temp_long_str, response);      
22:  (* NLS tests *) 
          IF NOT (response) THEN finish (response);           END;  (* if mag tape *)             (* open the volume *)  #   cur_rfl_descriptor.newfl := log_name;  (* from the history table *) #       file_not_open := true;        WHILE file_not_open DO BEGIN                IF (break_flag (temp_short_int) = break_set)          THEN finish (false);      %      IF open_existing_file (cur_rfl_descriptor, return_status) THEN BEGIN %             (**)          (* tell user error and then wait for 'yes' or 'no'          (* when s(he)'s ready. Then try again.          (**)     "         short_dest_file_srce (log_name_in_ascii, chars_in_short_str, "                                 log_name, chars_in_new_file_name,                                 str_assign, zero);     (*       temp_long_str := ' Could not open volume '; *)          (*:nl:$ ' ' *) #         (*:nl:$ ' Max. 16 bytes string is appended to this message' *) #         (*:nl:#*1 1009 ' Could not open volume  ' *)      
23:  (* NLS tests *) 
              (*:nl:$COPY '         length := nlread (&, #, nlerr,' *)            length := nlread (MRFLL, 1009, nlerr,                                              temp_long_str, len);           blank_pad (temp_long_str, chars_in_long_str, length);               positional_append_str (temp_long_str, log_name_in_ascii,                                   chars_in_short_str, length);     %         IF write_long_str (input_descriptor, temp_long_str, return_status) %            THEN fatal_error (return_status);      
24:  (* NLS tests *) 
    #(*       temp_long_str := ' Try again (YES to try, NO to abort)? _'; *) # "         (*:nl:#*1 1010 ' Try again (YES to try, NO to abort)? _' *) "          (*:nl:$COPY '         length := nlread (&, #, nlerr,' *)            length := nlread (MRFLL, 1010, nlerr,                                              temp_long_str, len);           blank_pad (temp_long_str, chars_in_long_str, length);           ask_user (temp_long_str, response);      
26:  (* NLS tests *) 
             IF not (response) THEN finish (response)               END        ELSE file_not_open := false;               IF NOT (file_not_open) THEN BEGIN               (* lock, and rewind the mag tape *)           IF is_tape_file (cur_rfl_descriptor) THEN BEGIN                 IF device_control_operation  &                  (cur_rfl_descriptor.dcb, rewind, return_status) THEN BEGIN &                    write_blank_line (one, input_descriptor); (*             temp_long_str := #           ' Device not ready.  Ready (YES when ready, NO to abort)?_'; # *)             (*:nl:#*1 1011 ' Device not ready.  Ready &' *)            (*:nl:#        '(YES when ready, NO to abort)?_'  *)      
27:  (* NLS tests *) 
    "           (*:nl:$COPY '           length := nlread (&, #, nlerr,' *) "            length := nlread (MRFLL, 1011, nlerr,                                               temp_long_str, len);               blank_pad (temp_long_str, chars_in_long_str, length);                      ask_user (temp_long_str, response);      
28:  (* NLS tesst *) 
     !               IF not (response) THEN fatal_error (return_status); !	               END; 	                END;   (* mag tape *)              (* read the label block *)          IF do_block_transfer (                read_code,                 cur_rfl_descriptor, 	               one, 		               one, 	                temp_block[zero],                 return_status) THEN                fatal_error (return_status);               (* look at the label and verify contents *)           IF make_label_ptr (                 temp_block[zero],                label_ptr,                 return_status) THEN                fatal_error (return_status);              WITH label_ptr^ DO BEGIN             write_blank_line (one, input_descriptor);                  IF (log_set_name <> recov_set_name) OR                 (sub_vol_num <> subvol_ix) THEN BEGIN                IF sub_vol_num <> subvol_ix THEN  (*                temp_long_str := "                     ' Wrong subvolume mounted or not a RFL log. ' *) " '               (*:nl:#*1 1012 ' Wrong subvolume mounted or not a RFL log. ' *) '     
29:  (* NLS tests *) 
               (*:nl:$COPY '               msgno := #' *)                 msgno := 1012         	               ELSE 	 (*                temp_long_str :=  '             ' Log volume belongs to a different set or it is not a RFL log.'; ' *) %               (*:nl:#*1 1013 ' Log volume belongs to a different set &' *) %%               (*:nl:#        'or it is not a RFL log.'                  *) %     
30:  (* NLS tests *) 
                    (*:nl:$COPY '               msgno := #;' *)                msgno := 1013;          %               (*:nl:$COPY '               length := nlread (&, msgno,' *) %                length := nlread (MRFLL, msgno,                                            nlerr, temp_long_str, len);   "               blank_pad (temp_long_str, chars_in_long_str, length); "     
31:  (* NLS tests *) 
                     tell_user_wrong_volume (temp_long_str, response);  	               (**) 	#               (* User has elected to make available the correct volume #%               (* - verify it by repeating the open and label verification. %	               (**) 	                   file_not_open := true;     	               END; 	                 (* tell user the logical name of the volume *)  (*          temp_long_str := ' Processing log volume:  '; *)  
            (*:nl:$ ' ' *) 
 %            (*:nl:$ ' Max. 16 bytes string is appended to this message' *) %             (*:nl:#*1 1014 ' Processing log volume: ' *)      
32:  (* NLS tests *) 
    #            (*:nl:$COPY '            length := nlread (&, #, nlerr,' *) #            length := nlread (MRFLL, 1014, nlerr,                                            temp_long_str, len);              blank_pad (temp_long_str, chars_in_long_str, length);  !            positional_append_str (temp_long_str, logical_vol_name, !                                   chars_in_short_str, length);      &            IF write_long_str (input_descriptor,temp_long_str,return_status) &                THEN fatal_error (return_status);      
33:  (* NLS tests *) 
                (* if user provided us with volume names *)              IF volume_list_flag <> cur_dbcon  THEN BEGIN                    (* ask user if it is okay to continue *)  #(*             temp_long_str := ' Okay to continue (YES or NO)? _'; *) #!               (*:nl:#*1 1015 ' Okay to continue (YES or NO)? _' *) !     
34:  (* NLS tests *) 
    &               (*:nl:$COPY '               length := nlread (&, #, nlerr,' *) &                length := nlread (MRFLL, 1015, nlerr,     $                                                     temp_long_str, len); $ "               blank_pad (temp_long_str, chars_in_long_str, length); "                ask_user (temp_long_str, response);      
35:  (* NLS tests *) 
     !               IF NOT (response) THEN fatal_error (return_status); ! 	               END 	     %            ELSE BEGIN  (* verify the logical name against history entry*) % %               IF logical_name (* dbcon *) <> logical_vol_name (* label *) %                   THEN BEGIN (*                   temp_long_str :=  &             ' Logical name on tape label does not match history entry.'; *) &     '(*:nl:#*1 1016 ' Logical name on tape label does not match history entry.'; *) '     
36:  (* NLS tests *) 
     %   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_long_str, len);' *) %    length := nlread (MRFLL, 1016, nlerr, temp_long_str, len);          blank_pad (temp_long_str, chars_in_long_str, length);      
37:  (* NLS tests *) 
    "                     tell_user_wrong_volume (temp_long_str,response); "                         file_not_open := true;                       END                 END; (* else *)                  END;  (* with label *)              END;  (* if *)           END;  (* while *)     	   END;  (* with *) 	        (* reset globals *)    num_blks_in_cur_chunk := zero;    next_rfr_blk_num := num_blks_in_rfl_label + one;     cur_chunk_buf_blk_num := one;     END;  (* proc get_next_volume      *)  $ page $  !(****************************************************************) ! !(*                                                              *) ! !(* Procedure fill_buffer                                        *) ! !(*                                                              *) ! !(* Purpose : This procedure fills the rfl_buffer with as many   *) ! !(* log records as possible from the roll forwar log.  If        *) ! !(* the rfl is a disc file, the maximum number of blocks are     *) ! !(* read (log records do not cross block boundaries); if         *) ! !(* the rfl is a tape device, a single tape record is read       *) ! !(* (this tape record was originally blocked to a maximum of     *) ! !(* this block size).                                            *) ! !(*                                                              *) ! !(*                                                              *) ! !(* The return variable 'num_blocks_read' is the exact number    *) ! !(* of blocks read for tape reads, and is the requested number   *) ! !(* for disc reads.  This is because on the original write,      *) ! !(* we have a variable number of blocks per tape write but       *) ! !(* write to a type 1 file for disc.                             *) ! !(*                                                              *) ! !(****************************************************************) !         PROCEDURE fill_buffer   $ alias 'RFR.FillBuffer' $     ( VAR log_file_descriptor : file_descriptor;        VAR next_rfl_block_num : long_int;   $ heapparms on $       VAR rfr_buffer : rfl_tape_buffer_type;   	$ Heapparms off $  	      VAR num_blks_read : short_int;        VAR return_status : short_int);      VAR      num_words_transferred : short_int;      status : short_int;     BEGIN        IF NOT is_tape_file (log_file_descriptor) THEN BEGIN           (* a_disc_file *)            (* Read as many blocks as can fit into the rfr_buffer *)        IF do_disc_transfer (    (* ema version *)              read_code,             log_file_descriptor.dcb.dcb_header,             next_rfl_block_num,              num_blks_in_rfl_tape_buffer,              rfr_buffer.wds[one], 
            workhorse_data, 
            return_status) THEN BEGIN                  IF return_status <> bof_eof_err THEN                fatal_error (return_status);  
            END;  (* if *) 
              IF return_status = bof_eof_err THEN             num_blks_read := zero          ELSE             num_blks_read := num_blks_in_rfl_tape_buffer;      
      END  (* disc_file *) 
        ELSE BEGIN (* magnetic_tape_device *)            num_words_transferred := zero;       IF do_device_transfer (   (* ema version *)              read_code,              log_file_descriptor.dcb,              num_blks_in_rfl_tape_buffer * words_in_disc_block,              rfr_buffer.wds[one],              num_words_transferred,             return_status) THEN BEGIN                      (* If we hit a parity error, warn the user and              (* (1) pass one - goto pass 2  to redo all the             (*     intrinsics we've looked at so far.              (* (2) pass two - stop now              (* We return zero words read to the caller.               (**)                  IF return_status = rfl_parity_err THEN                 num_words_transferred := zero              ELSE                  (**)  "            (* no logical eof here - when eof is hit, zero words are " !            (* read.  Ignore when we hit the eot because the next  !             (* read should hit eof (zero words read). If not,               (* then we will get a fatal error.              (**)                    If return_status <> rfl_end_of_tape_err THEN                    fatal_error (return_status);              END;      $         num_blks_read := num_words_transferred DIV words_in_disc_block; $         IF num_blks_read = zero THEN BEGIN             (* rewind the tape *)             IF device_control_operation (                log_file_descriptor.dcb,                 rewind,                 status) THEN;             (* we want to return parity errors *)             IF return_status <> rfl_parity_err THEN                return_status := zero;              END;              END;  (* else is mag tape *)          END;  (* proc fill_buffer *)  $ page $  !(****************************************************************) ! !(*                                                              *) ! !(* Procedure read_next_chunk                                    *) ! !(*                                                              *) ! !(* Purpose - This procedure returns the block number for the    *) ! !(* start of the next chunk within the rfl buffer.  If there     *) ! !(* are no more chunks in memory, chunks are read into the       *) ! !(* buffer until it is filled.                                   *) ! !(*                                                              *) ! !(****************************************************************) !     PROCEDURE read_next_chunk     $ alias 'RFR.ReadNxtChunk' $          (VAR return_status : short_int);         LABEL 99;     VAR    header_ptr : ptr_log_record_header_type;    chunk_start_word_offset : short_int;     chunk_checksum_value : short_int;     num_blks_used : short_int;      num_blks_in_new_chunk : short_int;       BEGIN       
   return_status := zero;  
    IF break_flag (temp_short_int) = break_set THEN        finish (false);       
   (* first time *)  
   IF num_blks_in_cur_chunk = zero THEN BEGIN 	      fill_buffer ( 	          cur_rfl_descriptor,  
         next_rfr_blk_num, 
          rfr_buf_ptr^,           num_blks_in_cur_buffer,            (* returned *)           return_status);       cur_chunk_buf_blk_num := one;        END;         #   (* Do we have all, part or none of the next chunk in our buffer ? *) # $   num_blks_used := cur_chunk_buf_blk_num + num_blks_in_cur_chunk - one; $   IF (num_blks_used = num_blks_in_cur_buffer) THEN $      num_blks_in_new_chunk := one   (* we have none of the next chunk *) $       ELSE BEGIN            (* get the number of blocks in our next chunk *)       cur_chunk_buf_blk_num := num_blks_used + one; 
      IF make_log_rec_ptr ( 
          rfr_buf_ptr^.blk[cur_chunk_buf_blk_num],   
         header_ptr, 
          return_status) THEN           fatal_error (return_status);   #      num_blks_in_new_chunk := header_ptr^.chunk_head.blks_per_chunk;  #       END;         (* Do we have all of the next chunk in our buffer? *)     IF (num_blks_in_new_chunk + num_blks_used) >         num_blks_in_cur_buffer THEN BEGIN             next_rfr_blk_num := next_rfr_blk_num + num_blks_used;             (* fill the buffer again *)   
      fill_buffer (  
          cur_rfl_descriptor,  
         next_rfr_blk_num, 
          rfr_buf_ptr^,           num_blks_in_cur_buffer,  (* returned *)           return_status);            (* end of file reached? *)        IF num_blks_in_cur_buffer = zero THEN BEGIN            (**)   #         (* If a parity error is encountered, we treat it like an eof  # %         (* (eg. dbrbr could not recover the rfl due to tlf problem. hence %          (* no eof was written).           (**)            IF return_status <> rfl_parity_err THEN              return_status := bof_eof_err;   	         GOTO 99;  	          END;       
      (* reset pointers *) 
       cur_chunk_buf_blk_num := one;   
      END;  (* if *) 
        (* create a pointer to the current chunk *)     IF make_log_rec_ptr (        rfr_buf_ptr^.blk[cur_chunk_buf_blk_num],  	      header_ptr,  	 
      return_status) THEN  
       fatal_error (Return_status);         WITH header_ptr^ DO BEGIN            IF rec_type <> chunk_head_log_code THEN BEGIN   "         IF rec_type = tuf_eof_indicator THEN      (* end of file *) "             return_status := bof_eof_err           ELSE               fatal_error (dbrfr_internal_err);            END   (* if not chunk head *)            ELSE BEGIN   (* init globals *)            num_blks_in_cur_chunk := chunk_head.blks_per_chunk;           chunk_start_word_offset :=                (cur_chunk_buf_blk_num - one) * words_in_disc_block;                (* perform checksum verification *)           chunk_checksum_value := check_sum (  
            rfr_buf_ptr^,  
              first_chunk_checksum_word + chunk_start_word_offset,                last_chunk_checksum_word + chunk_start_word_offset);   #            IF chunk_checksum_value <> chunk_head.checksum_value THEN  #                fatal_error (corrupt_rfl_err);                (**)   #         (* Chunk sequence check performed  - make sure we don't redo  # "         (* something we have done before.  There should be no gaps  " #         (* because roll forward logging does not allow modifications  #          (* during gaps.           (**)                IF (cur_chunk_seq_num = (maxint-one)) THEN              cur_chunk_seq_num := zero;   (* wraparound *)  "         IF chunk_head.chunk_seq_num <= cur_chunk_seq_num THEN BEGIN "            (* ignore this chunk *)              return_status := ignore_this_chunk             END 	         ELSE BEGIN 	             return_status := zero;              cur_chunk_seq_num := chunk_head.chunk_seq_num;              END;  (* else *)           END; (* else *)            END;  (* with *)  99 : END;  (* procedure read_next_chunk *)  .  