 $PASCAL ',7,90 92081-1X051 REV.2540'$       $ Heap 0 $  	$ Recursive OFF $  	 $ Range OFF $       $ Subprogram $      PROGRAM dbstr_seg1_library;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18051                                        *)  ! !(* RELOC:   92081-1X051                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified: <851107.0922>  !(*                                                             *)  ! !(***************************************************************)  !     !(***************************************************************)  ! !(*                                                             *)  ! !(* This module contains functions and procedures used by DBSTR *)  ! !(* in the segment DBST1, which initialize the DBSTR environment*)  ! !(* by opening the proper files, error checking run string      *)  ! !(* parameters, opening the database and determining which data *)  ! !(* sets need to be unloaded.                                   *)  ! !(*                                                             *)  ! !(***************************************************************)  ! $ Page $  !(***************************************************************)  ! !(*             Constants and types Declarations                *)  ! !(***************************************************************)  !     $ List OFF, Include '[IMAGE', List ON $       $ List OFF, Include '[BACKUP_UTILS', List ON $      $ List OFF, Include '[STR_RST', List ON $       $ List OFF, Include '[DBSTR', List ON $       TYPE     message_buf_type = RECORD        CASE short_int OF            1: (bm : to_bm_mesg_type);            2: (me : to_user_mesg_type);         END;      $ Page $  !(***************************************************************)  ! !(*                   External declarations                     *)  ! !(***************************************************************)  !     $ List OFF, Include '[XSTOR', List ON $  (* DBSTR main *)   $ List OFF, Include '[XBKP1', List ON $       $ List OFF, Include '[XDFMP', List ON $  (* file sys calls *)   $ List OFF, Include '[XDCIO', List ON $  (* DBCON I/O      *)   $ List OFF, Include '[XDTDY', List ON $  (* timestamp *)  $ List OFF, Include '[XDGDN', List ON $  (* get dbcon name *)   $ List OFF, Include '[XDGCB', List ON $  (* get comm buffer*)   $ List OFF, Include '[XDLDP', List ON $  (* check dormancy *)   $ List OFF, Include '[XDMSG', List ON $  (* messages  *)      FUNCTION read_password_block  $ Alias 'Img.BlockIo'      (    read_code : short_int; (* constant 1 *)       VAR descriptor: file_descriptor;          first_block:long_int;           num_blocks: short_int;      VAR buffer    : password_block_type;      VAR status    : short_int) : boolean;      EXTERNAL;      FUNCTION allocate_class  $ Alias 'Getcl' $     (VAR class_number : short_int;           local        : short_int) : boolean;     EXTERNAL;      FUNCTION return_class  $ Alias 'Retcl' $     (VAR class_number : short_int) : boolean;     EXTERNAL;      FUNCTION make_file_hdr  $ Alias 'STRDSC' $     (filename   : new_file_name;       first_char : short_int;       char_length: short_int) : f7x_str;     EXTERNAL;      FUNCTION fmp_size   $ Alias 'FmpSize' $      (    file_hdr : f7x_str;       VAR blocksize: long_int) : short_int; (* error *)      EXTERNAL;      $ Page $  !(***************************************************************)  ! !(*                    get_number_of_sets                       *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To get the number of data sets out of the root file.     *)  ! !(*                                                             *)  ! !(* Parameters: None, but globals are used.                     *)  ! !(*                                                             *)  ! !(* Function result is 'true' if an error occurs.               *)  ! !(*                                                             *)  ! !(***************************************************************)  !     FUNCTION get_number_of_sets  $ Alias 'DBSTR.GetNumSets' $      : boolean;       LABEL 99;       VAR      status        : short_int;       BEGIN (* get_number_of_sets *)          get_number_of_sets := true;  (* assume an error will occur *)       "   IF read_rootfile_hdr (root_file, root_header, status) THEN BEGIN  "       report_error (status);        GOTO 99;        END;         num_sets := root_header.sets;         get_number_of_sets := false; (* no error *)      99:  (* error exit *)       END; (* get_number_of_sets *)   $ Page $  !(***************************************************************)  ! !(*                  highest_levelword                          *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To determine if the level word supplied was the highest  *)  ! !(*    in the database.                                         *)  ! !(*                                                             *)  ! !(* Parameters: None, but globals are used.                     *)  ! !(*                                                             *)  ! !(* Function result is 'true' if an error occurred.             *)  ! !(*                                                             *)  ! !(***************************************************************)  !     FUNCTION highest_levelword  $ Alias 'DBSTR.HighestLev' $     : boolean;       LABEL 99;       TYPE     block_of_passwords_type = RECORD         CASE short_int OF            1: (passwords : password_block_type);           2: (block     : disc_block);         END;      VAR      password_block: long_int;     passwords     : block_of_passwords_type;          match_found   : boolean;      highest       : boolean;          status, i     : short_int;       BEGIN (* highest_levelword *)          highest_levelword := true; (* assume an error *)       "   IF read_rootfile_hdr (root_file, root_header, status) THEN BEGIN  "       report_error (status);        GOTO 99;        END;         password_block := root_header.passw_block;          IF read_password_block (one, (* read code *)                              root_file,                              password_block,                             one, (* one block *)                              passwords.passwords,                              status) THEN BEGIN         report_error (status);        GOTO 99;        END;         match_found := false;     highest     := true;  (* Assume highest *)       
   WITH passwords DO 
    FOR i := one TO entries_in_password_block DO BEGIN         IF (passwords[i] <> ' ')           THEN highest := false;         IF passwords[i] = level_word THEN BEGIN            match_found := true;   
         highest := true;  
          END; (* then match found *)  
      END; (* for *) 
        IF NOT highest THEN BEGIN        report_error (incorrect_level_word_err);        GOTO 99;        END;         (**)      (* If there was not a level word defined in the database,     (* the user could have given anything in the run string.      (* Therefore, if no defined level word, set it to blanks      (* so that DBSTR will not be confused.      (**)          IF NOT match_found THEN level_word := ' ';          highest_levelword := false;      99:  (* highest_levelword *)      END; (* highest_levelword *)  $ Page $  !(***************************************************************)  ! !(*                                                             *)  ! !(* Function INITIALIZE_DBSTR                                   *)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To perform all DBSTR initialization, by setting the      *)  ! !(*    values of key variables, analyze the run string, open    *)  ! !(*    the appropriate files, open the rootfile, and gather     *)  ! !(*    a list of sets to be backed up.                          *)  ! !(*                                                             *)  ! !(* Parameters: None.                                           *)  ! !(*                                                             *)  ! !(* Function result: 'True' if an error occurs, otherwise false.*)  ! !(*                                                             *)  ! !(***************************************************************)  !     FUNCTION initialize_dbstr  $ Alias 'DBSTR.Initialize' $      : Boolean;       
LABEL 99; (* error exit *) 
     
$ Include '[PROG' $  
     CONST   #   local = zero; (* for assigning the class number to this program *)  #     VAR      i : short_int; (* loop for set numbers *)         data_amount  : data_amount_type;          dbcon_file   : file_descriptor;     dbcon_table  : dbcon_table_type;          status       : short_int;         class        : short_int;     comm_buf     : image_comm_buffer_type;      len_received : short_int;     message_buf  : message_buf_type;          set_info_ptr : global_dataset_ctl_table_ptr_type;     multiple_buffers : short_int;  
   fhdr         : f7x_str; 
     BEGIN (* initialize_dbstr *)         initialize_dbstr := true;  (* Assume an error will occur *)         (* Parse the run string and verify particular parameters *)      !   backup_prog := dbstore_program;  (* Say 'DBSTR is executing' *) !        IF parse_parameters THEN GOTO 99;  (* error! *)         (* Open the root file exclusively *)      IF open_rootfile (root_file, status) THEN BEGIN        report_error (status);        GOTO 99;        END;         (* Verify that the highest level word was supplied *)     IF highest_levelword THEN GOTO 99; (* if wrong levelword *)         (**)   #   (* At this point, all necessary files are opened, the rootfile has  # #   (* been opened, and we are set to begin determining which data sets #    (* we need to backup.     (* Determine how much storage space is required.      (**)          IF get_number_of_sets THEN GOTO 99;         FOR i := one TO num_sets DO BEGIN         (* For each data set, get the real number of blocks in *)           (* each data set file by calling FmpSize.              *)              IF get_set_info_from_root (i, set_info_ptr)            THEN GOTO 99;      !      (* make a FTN7X string header for the data set descriptor *) !       fhdr := make_file_hdr (set_info_ptr^.set_name, 1,                                chars_in_new_file_name);             WITH data_amount[i] DO BEGIN  #         status := fmp_size (fhdr, num_records); (* actually blocks *) #          IF (status <> 0) THEN BEGIN              report_error (status);  
            GOTO 99; 
             END;               data_len := words_in_disc_block;            END; (* with *)  
      END; (* for *) 
            (**)      (* Now we have the list of sets whose data we will unload.      (* We know the number of records to save in each set, and     (* the length of the records in those sets.     (* We can acurately measure the amount of space we require      (* and can smartly determine a file size to create, or the      (* number of linus tapes required.      (**)          determine_space_needed (data_amount);         (**)   "   (* Now include the space required to store the root file header.  "    (**)          multiple_buffers := ((root_header.passw_block-one) DIV                           tape_buffer_block_size) + one;         space_needed := space_needed +                      file_header_word_size +  "                   ((data_header_word_size + tape_data_buffer_size)* "                     multiple_buffers);         amount_saved := zero;  (* so far zero words saved *)              (**)      (* Initialize the Volume Header information for     (* open_tape_file, which services all the utilities.      (**)          WITH volume_header DO BEGIN        ident := 'DBSTORE 2540';            dbname := root_file.newfl;      
      level  := ' '; 
           FOR i := one TO chars_in_level_word DO           level[i] := level_word[i];       
      sets   := num_sets;  
 $      reel   := zero; (* incremented by open_tape_file_file_for_write *) $       get_timestamp (tmstmp);             (**)         (* Fill in the roll-forward log info:  Get the latest from         (* DBMON if active, or DBCON if IMAGE is down.        (**)            IF local_dormant_program (dbmon_program) THEN BEGIN            (**)            (* DBMON is not alive: open and read the DBCON file.            (**)       !         IF get_db_control_file_name (dbcon_file.newfl) THEN BEGIN !             report_error (dbcon_open_err);  
            GOTO 99; 
             END;               IF open_existing_file (dbcon_file, status) THEN BEGIN              report_error (status);  
            GOTO 99; 
             END;               WITH dbcon_table.dbcon_status_block DO BEGIN               IF read_dbcon_table (dbcon_file,                                   dbc_status_blk,                                   do_not_lock_dbcon_file,                                   block,                                    status) THEN BEGIN                  report_error (status);                  GOTO 99;   
               END;  
                 xact := xaction_num;              END; (* with *)                WITH dbcon_table.dbcon_rfl_info_block DO BEGIN               IF read_dbcon_table (dbcon_file,                                   dbc_rfl_info_blk,                                   do_not_lock_dbcon_file,                                   block,                                    status) THEN BEGIN                  report_error (status);                  GOTO 99;   
               END;  
                 volume := rflf_vol_num;               volnam := rfl_logical_name;               setnam := rflf_set_name;              END; (* with *)                IF close_file (dbcon_file, status) THEN;                END (* then DBMON is not alive *)            ELSE BEGIN (* DBMON is alive: ask for the info *)       $         IF close_file (root_file, status) THEN; (* so DBMON can open *) $              IF allocate_class (class, local) THEN BEGIN              report_error (class_number_err);  
            GOTO 99; 
             END;               IF get_IMAGE_comm_buffer (comm_buf) THEN BEGIN               report_error (image_not_initialized_err);   
            GOTO 99; 
             END;               WITH message_buf.bm DO BEGIN               WITH comm_buf DO BEGIN                 from_comm_id   := class;                  from_comm_lock := zero;                 to_comm_id     := dbmon_comm_id;                  to_comm_lock   := dbmon_comm_lock;                  END; (* with *)                  request := to_bm_get_bu_label_info_code;               get_bu_label_info.rootfile_name := root_file.newfl;                END; (* with *)                (**)            (* send the message to DBMON; receive a reply.            (**)                IF exchange_messages (message_buf.bm.from_comm_id,                                   to_bm_xxx_bu_label_info_mesg_len,                                  message_buf.me.from_comm_id,                                  len_received,                                  to_bm_xxx_bu_label_info_mesg_len,                                  status) THEN BEGIN               report_error (status);  
            GOTO 99; 
             END;               WITH message_buf.me.get_bu_label_info DO BEGIN               IF reply.status <> no_image_err THEN BEGIN                 report_error (reply.status);                  GOTO 99;   
               END;  
                 xact   := cur_vol_xct;              volume := cur_vol_num;              volnam := cur_logical_rfl_vol;              setnam := cur_logical_rfl_set;              END; (* with *)                IF return_class (class) THEN;               IF open_rootfile (root_file, status) THEN BEGIN              report_error (status);  
            GOTO 99; 
             END;           END; (* else talk to DBMON *)            END; (* with volume header *)          (**)      (* Things are all set for DBSTR to go!      (**)          initialize_dbstr := false; (* no error *)      99:  (* error exit *)   END;  .  