 $PASCAL ',7 92081-1X055 REV.5000'$      $ Heap 0 $ $ Range OFF $ $ Recursive ON $ (* recursion needs to be on *)      $ Subprogram $      (**)  &(*:nl:$ATB, mtape_io, %lb000,relocatable, 92081-16071 REV.2540 <870414.1640> &(*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**)  PROGRAM tape_io_library;      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18055                                        *)   (* RELOC:   92081-1X055                                        *)   (*                                                             *)   (* PGMR:        <MRL> <TH>                                     *)   (*                                                             *)   (* Date last modified: <870414.1640>  (*                                                             *)   (***************************************************************)      "(*******************************************************************) ""(*                                                                 *) ""(* This file contains tape I/O routines used by the backup         *) ""(* utilities.  Special case device handling is used to support     *) ""(* non-standard devices, namely Linus tape at this time.           *) ""(*                                                                 *) ""(*******************************************************************) "    "(*******************************************************************) ""(*                   Global Constants, Types and Vars              *) ""(*******************************************************************) "    $ List OFF, Include '[IMAGE', List ON $  $ List OFF, Include '[Backup_Utils', List ON $      TYPE  
   two_ints = RECORD 
      CASE short_int OF           0: (dblint : long_int);          1: (twoints: ARRAY [1..2] OF short_int);        END;      $ Page $ "(*******************************************************************) ""(*                     External Declarations                       *) ""(*******************************************************************) "    $ List OFF, Include '[XBKP1', List ON $ $ List OFF, Include '[XDFMP', List ON $ $ List OFF, Include '[XUSHF', List ON $ $ List OFF, Include '[XDSMR', List ON $      $ List OFF, Include '[XDNLS', List ON $  (* NLS externals *)     #(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *) # PROCEDURE MTAPE_IO; EXTERNAL;                                      FUNCTION fmp_read_tape  $ Alias 'FmpRead' $    (VAR dcb : dcb_type;      VAR err : short_int;      VAR buf : dcb_buffer_type;         max : short_int) : short_int;     EXTERNAL;      FUNCTION fmp_big_read  $ Alias 'FmpRead' $    (VAR dcb : dcb_type;      VAR err : short_int;     VAR buf : tape_buffer_type;         max : short_int) : short_int;     EXTERNAL;     PROCEDURE fmp_close  $ Alias 'FmpClose' $    (VAR dcb : dcb_type;     VAR err : short_int);     EXTERNAL;     PROCEDURE fmp_write  $ Alias 'FmpWrite' $    (VAR dcb : dcb_type;      VAR err : short_int;         buf : tape_buffer_type;         max : short_int);     EXTERNAL;     PROCEDURE fmp_write_dcb  $ Alias 'FmpWrite' $    (VAR dcb : dcb_type;      VAR err : short_int;          buf : dcb_buffer_type;         max : short_int);     EXTERNAL;     PROCEDURE move_data   $ Alias 'DBMVW' $     (    SOURCE:  short_int; (* first word of source *)     VAR dest   : short_int; (* first word of destination *)         to_move: short_int);(* number of words to move *)     EXTERNAL;     PROCEDURE move_words_to_buffer  $ Alias 'DBMVW' $     (    source : short_int; (* first word of source *)     VAR dest   : short_int; (* first word of destination *)         to_move: short_int);(* number of words to move *)     EXTERNAL;      PROCEDURE write_to_linus  $ Alias 'XLUEX', NOABORT $     (exec_write : short_int; (* constant 2 *)     func_code  : xluex_control_word_type;     buffer     : dcb_buffer_type;     length     : short_int; (* length in words *)     highblock  : short_int; (* high word of dblint block # *)      lowblock   : short_int);(* low word of dblint block # *)     EXTERNAL;     PROCEDURE do_linus_read  $ Alias 'XLUEX', NOABORT $     (    exec_read  : short_int; (* constant 1 *)         func_code  : xluex_control_word_type;     VAR buffer     : dcb_buffer_type;          length     : short_int; (* maximum length to read *)          highblock  : short_int; (* high word of dblint block # *)            lowblock   : short_int);(* low word of dblint block # *)      EXTERNAL;      PROCEDURE get_regs   $ Alias 'DBGetRegs' $  
   (VAR a_reg : short_int; 

    VAR b_reg : short_int); 
    EXTERNAL;     PROCEDURE fmp_position  $ Alias 'FmpPosition' $    (VAR dcb : dcb_type;      VAR err : short_int;     VAR rec : long_int;      VAR pos : long_int);     EXTERNAL;      PROCEDURE fmp_set_position  $ Alias 'FmpSetPosition' $    (VAR dcb : dcb_type;      VAR err : short_int;         rec : long_int;          pos : long_int);     EXTERNAL;      $ Page $ "(*******************************************************************) ""(*                       poke_buffer                               *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To place a value in a word of the logical DCB buffer.        *) ""(*    The DCB buffer is in two pieces, the first piece being       *) ""(*    128 words long and called 'dcb_buffer'.  The second piece    *) ""(*    is from 129 to words_in_big_dcb long, called 'more'.         *) ""(*                                                                 *) ""(*    This routine properly places a the word in the correct       *) ""(*    variable name for the buffer.                                *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The offset to place the value in.                  *) ""(*    (in)  (2) The value to be put in the buffer.                 *) ""(*                                                                 *) ""(*******************************************************************) "    PROCEDURE poke_buffer  $ Alias 'Bkp.PokeBuffer' $    (offset, value : short_int);     BEGIN (* poke_buffer *)      
   WITH tape_file DO 
   IF offset <= words_in_packing_buffer       THEN normal.dcb.dcb_buffer[offset] := value       ELSE more[offset] := value;      END; (* poke_buffer *)  $ Page $ "(*******************************************************************) ""(*                       peek_buffer                               *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To read  a value in a word of the logical DCB buffer.        *) ""(*    The DCB buffer is in two pieces, the first piece being       *) ""(*    128 words long and called 'dcb_buffer'.  The second piece    *) ""(*    is from 129 to words_in_big_dcb long, called 'more'.         *) ""(*                                                                 *) ""(*    This routine properly  selects  a  word in the correct       *) ""(*    variable name from the buffer.                               *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The offset to read  the value from.                *) ""(*    (out) (2) The value read from    the buffer.                 *) ""(*                                                                 *) ""(*******************************************************************) "    PROCEDURE peek_buffer  $ Alias 'Bkp.PeekBuffer' $ 
   (    offset : short_int; 
     VAR value  : short_int);     BEGIN (* peek_buffer *)      
   WITH tape_file DO 
   IF offset <= words_in_packing_buffer       THEN value := normal.dcb.dcb_buffer[offset]       ELSE value := more[offset];      END; (* peek_buffer *)  $ Page $ "(*******************************************************************) ""(*                        get_input                                *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To get the next volume file name (if disc) or prompt for     *) ""(*    next tape to be mounted when the end of a volume is reached. *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The prompt string to issue to the user.            *) ""(*                                                                 *) ""(* Function result is 'True' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "    FUNCTION get_input   $ Alias 'Bkp.GetInput' $     (prompt_string : long_str) : boolean;     
LABEL 99;  (* error exit *) 
    VAR    temp_str : long_str;     input_received : boolean;     status   : short_int;     JUNK     : BOOLEAN;     
BEGIN (* get_input *) 
        get_input := true; (* error exit *) 
   input_received := false; 
       REPEAT (* until input is received *)     #      IF write_long_str (prompt_file, prompt_string, status) THEN BEGIN #         report_error (status);          GOTO 99;          END;     "      { ignore error returned by read, rte6 mux returns -17 for t/o } "      JUNK := read_long_str  (prompt_file, temp_str, status);       upshift_long_str (temp_str, temp_str, chars_in_long_str);            CASE tape_file.storage_kind OF      
         disk_file : BEGIN 
            IF temp_str = 'AB' THEN BEGIN                report_error (eof_before_end_of_database_err);                GOTO 99; 	               END; 	                IF temp_str <> ' ' THEN BEGIN                file_dest_long_srce (tape_file.normal.newfl,                                     chars_in_new_file_name,                                       temp_str, chars_in_long_str,                                       str_assign, zero);                 input_received := true; 	               END; 	                END;  (* case of disc file *)                  Linus_tape, mag_tape : BEGIN              IF temp_str[one] = 'Y'                 THEN input_received := true              ELSE IF temp_str[one] = 'N' THEN BEGIN                report_error (eot_before_end_of_database_err);                GOTO 99; 	               END; 	             END; (* case of magtape *)               OTHERWISE BEGIN              report_error (catastrophic_utility_err);  
            GOTO 99; 
             END;           END; (* case of storage type *)     
      UNTIL input_received; 
        get_input := false; (* no error  *)     
99:  (* error exit *) 
     
END; (* get_input *) 
 $ Page $ "(*******************************************************************) ""(*                        post_tape_file                           *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To post any data that might be in the tape_file dcb,         *) ""(*    particularly for non-standard devices, but also for          *) ""(*    cleaning up when the backup utilities finish.                *) ""(*                                                                 *) ""(* Parameters: None, though globals are used.                      *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION post_tape_file   $ Alias 'Bkp.PostTapeFile' $    : Boolean;     
LABEL 99;  (* error exit *) 
    CONST     cache_code = 128; (* 200 octal *)    no_abort   = -32768;         VAR     status : short_int;     linus_block   : two_ints;    xluex_parm    : xluex_control_word_type;      
BEGIN (* post_tape_file *) 
        post_tape_file := true;  (* assume an error will occur *)        CASE tape_file.storage_kind OF           disk_file : BEGIN          IF post_file (tape_file.normal, status) THEN BEGIN              report_error (status);  
            GOTO 99; 

            END; (* then *) 
         END; (* case of disc file *)            mag_tape : BEGIN           WITH tape_file DO BEGIN             IF dirty_buf THEN BEGIN                fmp_write_dcb (tape_file.normal.dcb, status,                                tape_file.normal.dcb.dcb_buffer,                               (next_word-one)*chars_in_word);                 IF (status < zero) THEN BEGIN                    report_error (status);  
                  GOTO 99; 
                   END;                 dirty_buf := false;                 END; (* then *) 
            END; (* with *) 
         END; (* case of magtape *)            linus_tape : BEGIN !         WITH tape_file, tape_file.non_standard.linus_info DO BEGIN !                IF dirty_buf THEN BEGIN                 linus_block.dblint := next_block;                    WITH xluex_parm DO BEGIN                   extended_lu   := tape_file.tape_lu;                    function_code := cache_code;                    END;                     write_to_linus (2 + no_abort,                                 xluex_parm,                                tape_file.normal.dcb.dcb_buffer,                                next_word - one,                                 linus_block.twoints[1],                                linus_block.twoints[2]);                BEGIN (* executed if XLUEX aborts *)                   report_error (backup_io_err);  
                  GOTO 99; 
                   END; (* XLUEX abort error *)                    next_block := next_block +  %                             ((next_word - one) DIV words_in_linus_block); %                   dirty_buf  := false;                 END; (* then *) 
            END; (* with *) 
          END; (* case of linus tape *)     
      OTHERWISE BEGIN 
         report_error (catastrophic_utility_err);          GOTO 99;          END; (* otherwise *) 
      END; (* case *) 
        post_tape_file := false; (* no error *)     
99:  (* error exit *) 
    END; (* post_tape_file *)  $ Page $ "(*******************************************************************) ""(*                        use_fmp_to_write                         *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To use normal FMP calls to write a buffer to tape/disc.      *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)     (1) The buffer to be written.                       *) ""(*    (in)     (2) The number of words to write.                   *) ""(*    (out)    (3) Status code.                                    *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "    FUNCTION use_fmp_to_write   $ Alias 'Bkp.UseFmpWrite' $     (VAR buffer : tape_buffer_type; 
        len    : short_int; 
     VAR status : short_int) : boolean;     
LABEL 99;  (* error exit *) 
     BEGIN (* use_Fmp_to_write *)         use_fmp_to_write := true;  (* assume an error will occur *)         IF (backup_prog = dbunload_program) AND (len = 0) AND        (tape_file.storage_kind = mag_tape) THEN BEGIN 
      write_tape_eof; 
      use_fmp_to_write := false; (* no error *)        GOTO 99;        END;     #   fmp_write (tape_file.normal.dcb, status, buffer, len*chars_in_word); #"   IF (status = fmp_bof_eof_err) OR (status = fmp_cartridge_full_err) "       THEN BEGIN          status := bof_eof_err;          GOTO 99;           END       ELSE IF status <> zero THEN BEGIN          report_error (status);          GOTO 99;           END; (* then *)        use_Fmp_to_write := false;  (* no error *)     
99:  (* error exit *) 
    
END; (* use_Fmp_to_write *) 
 $ Page $ "(*******************************************************************) ""(*                     move_to_dcb_buffer                          *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To move a buffer into the output DCB for eventual writing    *) ""(*    to a magtape or Linus tape, or some other device.            *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The buffer to be moved.                            *) ""(*    (in)  (2) The number of words in the buffer.                 *) ""(*    (in/out) (3) The 'next word' in the DCB.                     *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION move_to_dcb_buffer  $ Alias 'Bkp.MoveToDcb' $    (VAR buffer    : tape_buffer_type;          len       : short_int;     VAR next_word : short_int) : boolean;      
LABEL 99; (* error exit *) 
    VAR 
   done    : Boolean; 
   cur_pos : short_int;    to_move : short_int;      BEGIN (* move_to_dcb_buffer *)          move_to_dcb_buffer := true;  (* assume an error will occur *)          IF (next_word > words_in_big_dcb)        THEN IF post_tape_file THEN GOTO 99;        WITH tape_file.normal.dcb DO BEGIN       poke_buffer (next_word, len);       next_word := next_word + one;  
      done := false; 
       cur_pos := zero;           WHILE NOT done DO BEGIN     "         IF (next_word + len - cur_pos) > words_in_big_dcb THEN BEGIN "             to_move := words_in_big_dcb - next_word + one;             IF next_word <= words_in_packing_buffer                     THEN move_data (buffer.word_array[cur_pos+1],                                dcb_buffer[next_word],                                to_move)                     ELSE move_data (buffer.word_array[cur_pos+1],                                tape_file.more[next_word],                                 to_move);                 cur_pos := cur_pos + to_move;             next_word := next_word + to_move;             IF post_tape_file THEN GOTO 99;             next_word := one;             END 	         ELSE BEGIN 	            to_move := len - cur_pos;                 IF next_word <= words_in_packing_buffer                     THEN move_data (buffer.word_array[cur_pos+1],                                dcb_buffer[next_word],                                to_move)                     ELSE move_data (buffer.word_array[cur_pos+1],                                tape_file.more[next_word],                                 to_move);                 next_word := next_word + to_move;                  IF next_word > words_in_big_dcb THEN BEGIN                 IF post_tape_file THEN GOTO 99;                 next_word := one; 	               END; 	                poke_buffer (next_word, len);                 next_word := next_word + one;              IF next_word > words_in_big_dcb THEN BEGIN                 IF post_tape_file THEN GOTO 99;                 next_word := one; 	               END; 	                 poke_buffer (next_word, eof_mark);                 done := true; 
            END; (* else *) 
             END; (* while *)     
      END; (* with *) 
        move_to_dcb_buffer := false; (* no error *)     
99:  (* error exit *) 
    END; (* move_to_dcb_buffer *)  $ Page $ "(*******************************************************************) ""(*                     imitate_fmp_write                           *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To simulate Fmp type-3 files on a non-disc device.  This is  *) ""(*    for Linus tapes and DBSTR magtapes.                          *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)     (1) The buffer to be written.                       *) ""(*    (in)     (2) The number of words to write.                   *) ""(*    (out)    (3) Status code.                                    *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "    FUNCTION imitate_Fmp_write   $ Alias 'Bkp.ImitateWrite' $     (VAR buffer : tape_buffer_type; 
        len    : short_int; 
     VAR status : short_int) : boolean;     
LABEL 99;  (* error exit *) 
    VAR    to_move       : short_int;         BEGIN (* imitate_Fmp_write *)        imitate_Fmp_write := true;  (* assume an error will occur *)        CASE tape_file.storage_kind OF        mag_tape : BEGIN           WITH tape_file DO BEGIN              IF move_to_dcb_buffer (buffer, len, next_word)                 THEN GOTO 99;              dirty_buf := true;              END;          END;        linus_tape : BEGIN !         WITH tape_file, tape_file.non_standard.linus_info DO BEGIN !    #            (* See if the buffer can fit on what's left of the linus *) #                IF (blocksize*words_in_linus_block) <                 ((next_block*words_in_linus_block)+                    next_word-one + len + overhead) THEN BEGIN !               next_word := next_word + one; (* include EOF mark *) !                IF post_tape_file THEN GOTO 99;                status := bof_eof_err;                GOTO 99; 	               END; 	                 IF move_to_dcb_buffer (buffer, len, next_word)                 THEN GOTO 99;              dirty_buf := true;              END;          END;        OTHERWISE; 
      END; (* case *) 
        imitate_fmp_write := false;  (* no error *)     
99:  (* error exit *) 
     END; (* imitate_fmp_write *)  $ Page $ "(*******************************************************************) ""(*                        do_tape_write                            *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To handle all of the device-dependencies of writing to the   *) ""(*    backup 'tape'.  To make all of the devices look the same,    *) ""(*    an EOF and EOT produce the same error 'bof_eof_err'.         *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)     (1) The buffer to be written.                       *) ""(*    (in)     (2) The number of words to write.                   *) ""(*    (out)    (3) Status code.                                    *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION do_tape_write   $ Alias 'Bkp.DoTapeWrite' $     (VAR buffer : tape_buffer_type; 
        len    : short_int; 
     VAR status : short_int) : boolean;     
LABEL 99;  (* error exit *) 
        BEGIN (* do_tape_write *)        do_tape_write := true;  (* assume an error will occur *)         (* Attempt to write out the buffer *)        CASE tape_file.storage_kind OF            disk_file : BEGIN (* write buffer to disc *)               IF use_fmp_to_write (buffer, len, status)             THEN GOTO 99;          END; (* case of disc file *)                mag_tape : BEGIN          IF backup_prog = dbunload_program THEN BEGIN             IF use_fmp_to_write (buffer, len, status)                 THEN GOTO 99;             IF end_of_tape THEN BEGIN                (* At EOT - return status *)                status := bof_eof_err;                GOTO 99;                END; (* then at EOT *)              END (* then dbuld *) 	         ELSE BEGIN 	 "            IF imitate_fmp_write (buffer, len, status) THEN GOTO 99; "            IF end_of_tape THEN BEGIN                 (* At EOT - post buffer, write EOF *)  !               (* Increment next_word so the -1 gets posted too *) !                WITH tape_file DO                   next_word := next_word + one;                 IF post_tape_file THEN GOTO 99;                 write_tape_eof;                status := bof_eof_err;                GOTO 99;                END; (* then at EOT *)             END; (* else dbstr *)          END;           linus_tape : BEGIN (* write buffer to linus tape *)           IF imitate_fmp_write (buffer, len, status) THEN GOTO 99;           END; (* case of magtape *)     
      OTHERWISE BEGIN 
         report_error (catastrophic_utility_err);          GOTO 99;          END;        END; (* case of device type *)             do_tape_write := false;  (* no error *)     
99:  (* error exit *) 
     END; (* do_tape_write *)  $ Page $ "(*******************************************************************) ""(*                     get_next_volume                             *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To act as a general purpose interface for the backup         *) ""(*    utilities when requesting the next volume for a backup or    *) ""(*    restore operation.  The interactive parts are handled here   *) ""(*    and proper aborts taken when necessary.                      *) ""(*    For DBULD and DBSTR, the volume is initialized with a volume *) ""(*    header.  For DBLOD and DBRST, the volume header is verfied   *) ""(*    to be correct.                                               *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(* Many global variables are used.                                 *) ""(*                                                                 *) ""(* Function results is 'true' if an error occurs.                  *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION get_next_volume  $ Alias 'Bkp.GetNextVol' $    : Boolean;         
LABEL 99,  (* error exit *) 
       8000,9000,  (* NLS message test *)        8001,9001;  (* NLS message test *)     VAR     save_device_type : storage_types;    temp_str         : long_str;     temp1_str        : long_str;      status           : short_int;     save_reel        : short_int;     length           : short_int; (* NLreadRel actual length *)     nlerr            : short_int; (* NLreadRel error code    *)     
BEGIN (* get_next_volume *) 
       get_next_volume := true;  (* Assume an error will occur *)        (**)     (* If we had an end-of-media condition,    (* prompt for the next volume to fill.    (**)         save_device_type := tape_file.storage_kind;            (* prompt for the next volume *)     
   CASE save_device_type OF 
          disk_file : BEGIN !         (*:nl:#*1 1000 'Next file name to use (AB to abort)? _' *) !          (*:nl:$COPY '8000:    length := nlread(&, #' *)  8000:    length := nlread(MTAPE_IO, 1000     "                               , nlerr, temp_str, chars_in_long_str); "         blank_pad (temp_str, chars_in_long_str, length); !(*       IF get_input ('Next file name to use (AB to abort)? _') *) ! 9000:    IF get_input (temp_str)             THEN GOTO 99;          END; (* case of disc file *)               Linus_tape, mag_tape : BEGIN (* case of magtape at EOT *)     (*       temp_str := 'Mount next volume on'; *)          (*:nl:#*1 1001 'Mount next volume on' *)          (*:nl:$COPY '8001:    length := nlread (&, #' *) 8001:    length := nlread (MTAPE_IO, 1001      !                            , nlerr, temp_str, chars_in_long_str); !         blank_pad (temp_str, chars_in_long_str, length);               long_dest_file_srce (temp_str, chars_in_long_str,                                   tape_file.normal.newfl,                                   chars_in_new_file_name,                                   str_blankappend, zero);               (*:nl:#*1 1002 ' - Ready (Y/N)? _' *)          (*:nl:$COPY '         length := nlread (&, #' *)          length := nlread (MTAPE_IO, 1002     !                            , nlerr, temp1_str, chars_in_long_str); !          blank_pad (temp1_str, chars_in_long_str, length);   (*       append_blank_and_str (temp_str, '- Ready (Y/N)? _'); *)           append_long_str (temp_str, temp1_str);               IF get_input (temp_str) THEN GOTO 99;     9001:    END; (* case of magtape and linus tape*)     
      OTHERWISE BEGIN 
         report_error (catastrophic_utility_err);          GOTO 99;          END; (* otherwise *)       END; (* case of storage type *)            get_next_volume := false; (* no error *)     
99:  (* error exit *) 
     
END; (* get_next_volume *) 
 $ Page $ "(*******************************************************************) ""(*                      use_fmp_to_read                            *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To call Fmp routines for reading from disc files and from    *) ""(*    magtape for the DBLOD program.                               *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (out) (1) buffer where data is put.                          *) ""(*    (out) (2) number of words read.                              *) ""(*    (out) (3) error code if an error occurs.                     *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION use_fmp_to_read  $ Alias 'Bkp.UseFmpRead' $     (VAR buffer : tape_buffer_type; 
    VAR len    : short_int; 
     VAR status : short_int) : boolean;      
LABEL 99; (* error exit *) 
    
BEGIN (* use_fmp_to_read *) 
       use_fmp_to_read := true;  (* assume an error will occur *)         IF (backup_prog = dbload_program) AND        (tape_file.storage_kind = mag_tape) THEN BEGIN        (* check for EOT before reading from tape *)       IF end_of_tape THEN BEGIN          status := bof_eof_err;          GOTO 99;          END;        END;        len := fmp_big_read (tape_file.normal.dcb, status, buffer,                          tape_buffer_size*chars_in_word);          (* Treat a -1 length from tape and zero-length disc record *)       (* the same; i.e. a zero-length record. (DBLOD only).      *)          IF (backup_prog = dbload_program) AND        (tape_file.storage_kind = mag_tape) THEN BEGIN        IF (len = -1) THEN BEGIN           (* have to re-open the magtape when EOF is hit *)           IF open_big_dcb (tape_file.normal, 'rwo',                            blocks_in_big_dcb, status)             THEN GOTO 99; 
         len := zero; 
          END; (* then *) 
      END; (* then *) 
        IF (status = fmp_bof_eof_err) OR (len = -1)       THEN status := bof_eof_err;         IF status <> zero THEN GOTO 99;         len := len DIV chars_in_word;        use_fmp_to_read := false; (* no error *)     
99:  (* error exit *) 
     
END; (* use_fmp_to_read *) 
 $ Page $ "(*******************************************************************) ""(*                        do_tape_read                             *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To handle all of the device dependencies for magtapes and    *) ""(*    linus tapes when reading data.                               *) ""(*                                                                 *) ""(* Parameters: None, but globals are used.                         *) ""(*                                                                 *) ""(* Function resule is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(* Procedure:                                                      *) ""(*    Use FMP for magtape and XLUEX for linus tape to read data    *) ""(*    into the DCB buffer, part of the tape_file global variable.  *) ""(*    FMP does not use the dcb buffer for non-disc devices, hence  *) ""(*    we can use it for our own packing buffer.                    *) ""(*                                                                 *) ""(* An important note:                                              *) ""(*    ALL READS (with the exception of the last one) are expected  *) ""(*    to be exactly words_in_big_dcb words long.       If this     *) ""(*    for some reason cannot be the case, another status word will *) ""(*    be necessary in the tape_file variable to keep track of the  *) ""(*    current valid data in the buffer.  The last buffer can be    *) ""(*    less because it will have an 'eof mark' which is a length    *) ""(*    of -1.                                                       *) ""(*                                                                 *) ""(*******************************************************************) "    FUNCTION do_tape_read  $ Alias 'Bkp.DoTapeRead' $    : boolean;      
LABEL 99; (* error exit *) 
    CONST 
   no_abort = -32768; 
   cached_request_code = 128; (* 200 octal *)         VAR     len    : short_int;     status : short_int;     linus_block   : two_ints;    xluex_parm    : xluex_control_word_type;     a_reg  : short_int;    rec, pos : long_int;          BEGIN (* do_tape_read *)         do_tape_read := true;  (* assume an error will occur *)        CASE tape_file.storage_kind OF            mag_tape : BEGIN          WITH tape_file.normal DO BEGIN              (**) "            (* The following kludge is a workaround to an FMP feature "#            (* of treating the EOT the same as an EOF;  the consequence # &            (* is that no data over and past the EOT is normally accessible. & $            (* However, by doing FmpPosition/FmpSetPosition, the EOF bit $%            (* in the DCB is cleared, thus allowing another forward motion, %#            (* and we look in the FMPREGS common block after to get the # $            (* length of data actually read, because the length returned $             (* to us is -1 when over/past the EOT.              (* !            (* Note: Even though FMP returns a length of -1, it has !             (* actually read the magtape buffer into memory.              (* "            (* This workaround only works AT (and after) REV.2540!!!! "             (**)                 fmp_position (dcb, status, rec, pos);             fmp_set_position (dcb, status, rec, pos);                  len := fmp_read_tape (dcb, status, dcb.dcb_buffer,  !                                  words_in_big_dcb*chars_in_word); !                  IF len = -1 THEN BEGIN  (* rats; at or beyond EOT *)                 get_regs (a_reg, len); 	               END; 	                 (* convert byte count to word count *)             len := len DIV chars_in_word;     
            END; (* with *) 
         END; (* case of magtape *)            linus_tape : BEGIN           WITH tape_file DO BEGIN                 WITH non_standard.linus_info DO BEGIN                 linus_block.dblint := next_block;                 END; (* with *)                  WITH xluex_parm DO BEGIN                 extended_lu   := tape_lu;                 function_code := cached_request_code; 	               END; 	                 do_linus_read (one + no_abort,                             xluex_parm,                            normal.dcb.dcb_buffer,                             words_in_big_dcb,                             linus_block.twoints[1],                            linus_block.twoints[2]);             BEGIN (* if abort is taken *)                 report_error (backup_io_err);                GOTO 99;                 END; (* abort processing *)                  (* normal processing resumes here *)             WITH non_standard.linus_info DO                next_block := next_block + $                             (words_in_big_dcb DIV words_in_linus_block); $    
            END; (* with *) 
              END; (* case of linus tape *)            OTHERWISE;     
      END; (* case *) 
     
   WITH tape_file DO BEGIN 
       dirty_buf := true;       next_word := one; 
      END; (* with *) 
        do_tape_read := false; (* no error *)     
99:  (* error exit *) 
    END; (* do_tape_read *)  $ Page $ "(*******************************************************************) ""(*                      imitate_fmp_read                           *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To make a non-disc device 'look like' a type-3 FMP file.     *) ""(*    Device dependencies are handled here.                        *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (out) (1) The buffer into which data is placed.              *) ""(*    (out) (2) The word length of the data read.                  *) ""(*    (out) (3) An error code if an error occurs.                  *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(* The file-like layout consists of type-3 records which look like *) ""(* so:                                                             *) ""(*                                                                 *) ""(*    word 1:         the length of the record in words.           *) ""(*    words 2-len+1:  the actual data.                             *) ""(*    word len+2:     the length of the record in words.           *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION imitate_fmp_read  $ Alias 'Bkp.ImitateRead' $     (VAR buffer : tape_buffer_type; 
    VAR len    : short_int; 
     VAR status : short_int) : boolean;      
LABEL 99; (* error exit *) 
    VAR    move_done   : boolean; 
   current_pos : short_int; 

   to_move     : short_int; 

   temp        : short_int; 
     BEGIN (* imitate_fmp_read *)         imitate_fmp_read := true;  (* assume an error will occur *)        CASE tape_file.storage_kind OF            mag_tape, linus_tape : BEGIN           WITH tape_file, tape_file.normal.dcb DO BEGIN              IF NOT dirty_buf                THEN IF do_tape_read THEN GOTO 99;                 IF next_word > words_in_big_dcb                THEN IF do_tape_read THEN GOTO 99;     !            peek_buffer (next_word, len); (* get the length word *) !                  IF len = -1 THEN BEGIN    (* check for 'eof' mark *)                 status := bof_eof_err;                GOTO 99; 	               END; 	                next_word := next_word + one;             IF next_word > words_in_big_dcb                THEN IF do_tape_read THEN GOTO 99;                 move_done := false;              current_pos := zero;                 (* Move the data to the specified buffer *)                  WHILE NOT move_done DO BEGIN                 IF (next_word + len) > words_in_big_dcb THEN BEGIN                     (**) "                  (* the record is split across physical DCB buffers. "                   (**)                     to_move := words_in_big_dcb - next_word + one;                        IF next_word <= words_in_packing_buffer                           THEN move_words_to_buffer                               (dcb_buffer[next_word],                                buffer.word_array[current_pos+one],                                 to_move)                           ELSE move_words_to_buffer                               (more[next_word],                                buffer.word_array[current_pos+one],                                to_move);                       current_pos := current_pos + to_move;                   IF do_tape_read THEN GOTO 99;                    END (* then *)                ELSE BEGIN (* do final move *)                   to_move := len - current_pos;                       IF next_word <= words_in_packing_buffer                           THEN move_words_to_buffer                               (dcb_buffer[next_word],                                buffer.word_array[current_pos+one],                                 to_move)                           ELSE move_words_to_buffer                               (dcb_buffer[next_word],                                buffer.word_array[current_pos+one],                                to_move);                       next_word := next_word + to_move;                    move_done := true;                   END; (* else *)                END; (* while *)                  (* next_word is pointing to the ending length word *)               peek_buffer (next_word, temp);                 IF temp <> len THEN BEGIN                report_error (catastrophic_utility_err);                GOTO 99; 	               END; 	                next_word := next_word + one;     
            END; (* with *) 
          END;  (* case of magtape *)            OTHERWISE; 
      END; (* case *) 
        imitate_fmp_read := false; (* no error *)     
99:  (* error exit *) 
    
END; (* imitate_fmp_read *) 
 $ Page $ "(*******************************************************************) ""(*                      read_tape_buffer                           *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To read a buffer from a 'tape' (file/magtape/linus tape)     *) ""(*    and handle the various device dependencies and quirks        *) ""(*    specific to each of the backup utilities that do tape reads. *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (out) (1) The buffer into which data is put.                 *) ""(*    (out) (2) The length of the data.                            *) ""(*    (out) (3) An error code if an error occurs.                  *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION read_tape_buffer   $ Alias 'Bkp.ReadBuffer' $     (VAR buffer : tape_buffer_type; 
    VAR len    : short_int; 
     VAR status : short_int) : boolean;     LABEL 99;     VAR 
   buffer_is_read: boolean; 
     BEGIN (* read_tape_buffer *)         read_tape_buffer := true;  (* assume an error will occur *)      
   buffer_is_read:= false; 
        WHILE NOT buffer_is_read DO BEGIN        CASE tape_file.storage_kind OF      
         disk_file : BEGIN 
             IF use_fmp_to_read (buffer, len, status)                 THEN IF status <> bof_eof_err THEN GOTO 99;              END;              mag_tape : BEGIN              IF ((backup_prog = dbstore_program) OR                  (backup_prog = dbrestore_program))                THEN IF imitate_fmp_read (buffer, len, status)                    THEN IF status <> bof_eof_err THEN GOTO 99 "                                                ELSE (* do nothing *) "                  ELSE (* do nothing *)  !               ELSE BEGIN IF use_fmp_to_read (buffer, len, status) !                  THEN IF status <> bof_eof_err                      THEN GOTO 99                       ELSE (* hit an eof - get next file header *)                            IF use_fmp_to_read (buffer, len, status)                              THEN GOTO 99;                    (* we've read a record.  check for EOT. *)                    IF end_of_tape THEN status := bof_eof_err;                    END; (* else is dblod *)              END; (* case of magtape *)     
         linus_tape : BEGIN 
            IF imitate_fmp_read (buffer, len, status)                 THEN IF status <> bof_eof_err THEN GOTO 99;              END;               OTHERWISE BEGIN              report_error (catastrophic_utility_err);  
            GOTO 99; 
             END;           END; (* case *)            IF status = bof_eof_err THEN BEGIN           IF close_tape_file_for_read THEN GOTO 99;           IF get_next_volume THEN GOTO 99                              ELSE BEGIN              IF open_tape_file_for_read THEN GOTO 99; 
            END; (* else *) 
$         IF (backup_prog = dbunload_program) THEN buffer_is_read := true; $          status := no_image_err;          END (* then *)          ELSE buffer_is_read := true;            END; (* while buffer hasn't been read *)         read_tape_buffer := false; (* no error *)     
99:  (* error exit *) 
    
END; (* read_tape_buffer *) 
 $ Page $ "(*******************************************************************) ""(*                      write_tape_buffer                          *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To write an arbitrary buffer to magtape.  The data actually  *) ""(*    will be written via FMP for files and magtapes, and via      *) ""(*    an FMP-like algorithm to Linus tape.                         *) ""(*                                                                 *) ""(* Disc files and tapes are handled a little differently when it   *) ""(* comes to an EOF/EOT condition.  Disc and Linus: a new volume    *) ""(* is prompted for, initialized, and the buffer written to the     *) ""(* new volume.  Magtape: an EOF is written to the old volume,      *) ""(* it is rewound, a new volume mounted and initialized.  (A magtape*) ""(* EOT is a warning, not like an EOF error).                       *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)     (1) The buffer to write out.                        *) ""(*    (in)     (2) The number of words of the buffer to write.     *) ""(*    (out)    (3) Status code.                                    *) ""(*                                                                 *) ""(* Many global variables used.  See [Backup_Utils.                 *) ""(*                                                                 *) ""(*                                                                 *) ""(* Function result: Boolean 'True' if an error occurs.             *) ""(*                                                                 *) ""(*******************************************************************) "    FUNCTION write_tape_buffer  $ Alias 'Bkp.WriteBuffer' $    (VAR buffer : tape_buffer_type; (* may be just a header *)         len    : short_int;        (* words to write       *)      VAR status : short_int) : Boolean;      
LABEL 99; (* error exit *) 
        VAR     buffer_written   : boolean;     BEGIN (* write_tape_buffer *)        write_tape_buffer := true;  (* Assume an error will occur *)     
   buffer_written := false; 
        REPEAT (* attempting to write the buffer *)            IF do_tape_write (buffer, len, status)           THEN IF status <> bof_eof_err              THEN GOTO 99              ELSE BEGIN                IF close_tape_file_for_write THEN GOTO 99;                 IF get_next_volume THEN GOTO 99                                    ELSE BEGIN     	               (**) 	                (* Open the new volume and initialize it. 	               (**) 	                   space_needed := space_needed +  !                               volume_header_word_size + overhead; !                    IF open_tape_file_for_write THEN GOTO 99;                    IF tape_file.storage_kind = mag_tape                    THEN buffer_written := true;                    END (* else *)      
            END (* else *) 
             ELSE buffer_written := true;     
      UNTIL buffer_written; 
       (**)     (* Accumulate the number of words of data saved so far.    (**)        amount_saved := amount_saved + len + overhead;         write_tape_buffer := false;     
99:  (* error exit *) 
     END; (* write_tape_buffer *)  .  