 $PASCAL ',7,90 92081-1X059 REV.2540'$       $ Heap 0 $  	$ Recursive OFF $  	 $ Range OFF $       $ Subprogram $      PROGRAM dbuld_seg2_library;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18059                                        *)  ! !(* RELOC:   92081-1X059                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>  <TMH>                                   *)  ! !(*                                                             *)  ! (* Date last modified: <851206.1456>  !(*                                                             *)  ! !(***************************************************************)  !     !(***************************************************************)  ! !(*                                                             *)  ! !(* This module contains functions and procedures used by DBULD *)  ! !(* in the segment DBUL1, which initialize the DBULD environment*)  ! !(* by opening the proper files, error checking run string      *)  ! !(* parameters, opening the database and determining which data *)  ! !(* sets need to be unloaded.                                   *)  ! !(*                                                             *)  ! !(***************************************************************)  ! $ Page $  !(***************************************************************)  ! !(*             Constants and types Declarations                *)  ! !(***************************************************************)  !     $ List OFF, Include '[IMAGE', List ON $       $ List OFF, Include '[BACKUP_UTILS', List ON $      $ List OFF, Include '[ULD_LOD', List ON $       $ List OFF, Include '[DBULD', List ON $           !(***************************************************************)  ! !(*                   External declarations                     *)  ! !(***************************************************************)  !     $ List OFF, Include '[XBKP1', List ON $       $ List OFF, Include '[XDTDY', List ON $  (* timestamp *)      PROCEDURE get_set_list  $ Alias 'DBINF' $      (    ibase : ibase_type;   
        dummy : short_int; 
 
        mode  : short_int; 
     VAR istat : istat_type;       VAR buffer: set_list_type);      EXTERNAL;      PROCEDURE get_set_info   $ Alias 'DBINF' $     (    ibase : ibase_type;   
        setid : short_int; 
 
        mode  : short_int; 
     VAR istat : istat_type;       VAR buffer: set_info_buf_type);      EXTERNAL;          $ Page $  !(***************************************************************)  ! !(*                                                             *)  ! !(* Function INITIALIZ2_DBULD                                   *)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To perform step 2 of DBULD initialization, by opening    *)  ! !(*    the appropriate files, open the database, and gather     *)  ! !(*    a list of set numbers to be unloaded.                    *)  ! !(*                                                             *)  ! !(* Parameters: None.                                           *)  ! !(*                                                             *)  ! !(* Function result: 'True' if an error occurs, otherwise false.*)  ! !(*                                                             *)  ! !(***************************************************************)  !     FUNCTION initializ2_dbuld  $ Alias 'DBULD.Initializ2' $      : Boolean;       
LABEL 99; (* error exit *) 
     VAR      i : short_int; (* loop for set numbers *)         set_info_buf : set_info_buf_type;     dummy        : short_int;         data_amount  : data_amount_type;          sets_saved   : short_int;              BEGIN (* initializ2_dbuld *)         initializ2_dbuld := true;  (* Assume an error will occur *)         IF open_the_database (ibase, 8, istat)         THEN GOTO 99; (* error opening the database! *)          (**)   #   (* At this point, all necessary files are opened, the database has  # #   (* been opened, and we are set to begin determining which data sets #     (* we need to do a serial read on.  As we are collecting this       (* information, determine whether there is any data to store,      (* and if so, how much space it will require.     (**)          get_set_list (ibase, dummy, 203, istat, set_list);      IF (istat[1] <> zero) THEN BEGIN         report_error (istat[1]);        GOTO 99;        END;         (**)   "   (* Because we have highest level of access, all data set numbers  "    (* in the set list are negative.  Let's make them positive.     (**)       
   WITH set_list DO  
    FOR i := one TO num_sets DO        set_nums[i] := abs(set_nums[i]);         (**)      (* Determine which sets are automatic masters and zero out      (* that set number in the list.  We only need to unload     (* manual masters and detail data sets.     (**)          sets_saved := zero;      
   WITH set_list DO  
    FOR i := one TO set_list.num_sets DO BEGIN       !      get_set_info (ibase, set_nums[i], 202, istat, set_info_buf); !       IF (istat[1] <> zero) THEN BEGIN           report_error (istat[1]);   	         GOTO 99;  	          END;             WITH set_info_buf, data_amount[i] DO         IF (set_type[1] = 'A') OR (num_entries = zero) THEN BEGIN             set_nums[i] := zero;            data_len   := zero;           num_records:= zero;           END  
         ELSE BEGIN  
 "            data_len := entry_len;      (* DBULD just saves data *)  " "            num_records := num_entries; (* from in-use records.  *)  "                 IF num_entries > zero                  THEN sets_saved := sets_saved + one;                   END; (* else *)             END; (* with...for *)              (**)      (* Now we have the list of sets whose data we will unload.      (* We know the number of records to save in each set, and     (* the length of the records in those sets.     (* We can acurately measure the amount of space we require      (* and can smartly determine a file size to create, or the      (* number of linus tapes required.      (**)          determine_space_needed (data_amount);         IF (space_needed = zero) THEN BEGIN (* no data to save *)        report_error (no_data_to_unload_err);         GOTO 99;        END;         amount_saved := zero;  (* so far zero words saved *)              (**)      (* Initialize the Volume Header information for     (* open_tape_file, which services all the utilities.      (**)          WITH volume_header DO BEGIN        ident := 'DBUNLOAD2540';        dbname := root_file.newfl;  
      level  := ' '; 
       sets   := sets_saved;   $      reel   := zero; (* incremented by open_tape_file_file_for_write *) $       get_timestamp (tmstmp);             (**)        (* The following are not useful for DBULD/DBLOD.        (**)            xact   := zero;         volume := zero;   
      volnam := ' '; 
 
      setnam := ' '; 
       END; (* with *)          (**)      (* Things are all set for DBULD to go!      (**)          initializ2_dbuld := false; (* no error *)      99:  (* error exit *)   END;  .  