 $PASCAL ',7,90 92081-1X082 REV.2540'$       $ Heap 0 $  	$ Recursive OFF $  	 $ Range OFF $       $ Subprogram $      PROGRAM dbuld_seg3_library;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18082                                        *)  ! !(* RELOC:   92081-1X082                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>  <TMH>                                   *)  ! !(*                                                             *)  ! (* Date last modified: <851107.1328>  !(*                                                             *)  ! !(***************************************************************)  !     !(***************************************************************)  ! !(*                                                             *)  ! !(* This module contains functions and procedures used by DBULD *)  ! !(* in the segment DBUL2, which initialize the DBULD environment*)  ! !(* by opening the proper files, error checking run string      *)  ! !(* parameters, opening the database and determining which data *)  ! !(* sets need to be unloaded.                                   *)  ! !(*                                                             *)  ! !(***************************************************************)  ! $ Page $  !(***************************************************************)  ! !(*             Constants and types Declarations                *)  ! !(***************************************************************)  !     $ List OFF, Include '[IMAGE', List ON $       $ List OFF, Include '[BACKUP_UTILS', List ON $      $ List OFF, Include '[ULD_LOD', List ON $       $ List OFF, Include '[DBULD', List ON $           !(***************************************************************)  ! !(*                   External declarations                     *)  ! !(***************************************************************)  !     $ List OFF, Include '[XBKP1', List ON $       PROCEDURE param_return  $ Alias 'PRTN' $ (* system routine *)      (params : return_params_type);      EXTERNAL;      PROCEDURE get_set_info  $ Alias 'DBINF' $      (    ibase : ibase_type;   
        setid : short_int; 
 
        mode  : short_int; 
     VAR istat : istat_type;       VAR buffer: set_info_buf_type);      EXTERNAL;      $ Page $  #(*******************************************************************)  # #(*                      unload_data                                *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To read all data from the manual master and detail data sets *)  # #(*    and store the data in the storage file (specified by the     *)  # #(*    global variable 'tape_file').                                *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    None.  Most data is in global variables.  See the include    *)  # #(*    files [Backup_Utils, [Uld_lod and [DBULD.                    *)  # #(*                                                                 *)  # #(*******************************************************************)  #     $(*********************************************************************)  $ $(*                 open_storage                                      *)  $ $(*********************************************************************)  $ #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To open the storage file (specified by the global variable   *)  # #(*    'tape_file').                                                *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    None.  Most data is in global variables.  See the include    *)  # #(*    files [Backup_Utils, [Uld_lod and [DBULD.                    *)  # #(*                                                                 *)  # #(* Function result: 'True' if an error occurs, otherwise false.    *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION open_storage  $ Alias 'DBULD.Openstorag' $      : Boolean;       
LABEL 99; (* error exit *) 
 (*    88;    when eof is reached *)       BEGIN (* Open_storage *)         open_storage := true; (* assume an error *)      	   atsign := '@ '; 	        (**)      (* Open the storage file/device.      (**)          IF open_tape_file_for_write THEN GOTO 99;         (**)      (* Set up the skeleton file_header variable.      (**)          WITH file_header DO BEGIN            ident := 'FILEHEAD2540';        (* setnam will be filled in later *)        filnum:= zero; (* incremented by write_tape_header *)         (* entlen, filtyp and nument will be filled in later *)         END;      
   open_storage := false;  
     99:   (* error exit *)      END;  (* open_storage *)      $(*********************************************************************)  $ $(*                 process_header                                    *)  $ $(*********************************************************************)  $ $(*                                                                   *)  $ $(* Purpose:                                                          *)  $ $(*    To fill in the information for the header & write it out       *)  $ $(*    to the storage file.                                           *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    None.  Most data is in global variables.  See the include      *)  $ $(*    files [Backup_Utils, [Uld_lod and [DBULD.                      *)  $ $(*                                                                   *)  $ $(* Function result: 'True' if an error occurs, otherwise false.      *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     FUNCTION process_header  $ Alias 'DBULD.Processhdr' $      : Boolean;       
LABEL 99; (* error exit *) 
 (*    88;    when eof is reached *)       VAR           j : short_int;  (* FOR loop var *)      BEGIN  (* process_header *)             process_header := true;  (* assume an error *)            dataset_num := set_list.set_nums[loop];             (**)  $      (* Fill in the specifics of the file header and write it to tape.  $       (**)      !      get_set_info (ibase, dataset_num, 202, istat, set_info_buf); !           IF istat[one] <> zero THEN BEGIN           report_error (istat[one]);   	         GOTO 99;  	          END;             WITH file_header, set_info_buf DO BEGIN   !         (* ident, blank1, filtyp, and blank2 filled in earlier *) !          FOR j := one TO chars_in_file_name DO              set_id.setnam[j] := set_name[j];           entlen := entry_len;            nument := num_entries;            END;             (**)         (* A note is needed here:  It may be that the root file is         (* corrupt, specifically the number of in-use entries.        (* For this reason we will serially read until the        (* eof-bof error is reached, regardless of num_entries.         (**)            IF write_file_header THEN GOTO 99;            (**)        (* Set up the data header.        (**)            WITH tape_buffer.data_header DO BEGIN            ident := 'DATAHEAD2540';            FOR j := one TO chars_in_file_name DO              set_id.setnam[j] := set_info_buf.set_name[j];            filler:= ' ';           END;             process_header := false;      99:  (* error exit *)       
END; (* process_header *)  
 .  