 $PASCAL '92081-1X308 REV.2540' $  #(* **************************************************************** *) # #(* * (C) Copyright 1983 Hewlett-Packard.  All rights reserved.    * *) # #(* * No part of this program may be photocopied, reproduced or    * *) # #(* * translated to another program language without the express   * *) # #(* * written consent of Hewlett-Packard Company.                  * *) # #(* **************************************************************** *) # #(*                                                                  *) # #(* SOURCE:  92081-18308                                             *) # #(* RELOC:   92081-1X308                                             *) # #(*                                                                  *) # #(* PGMR: <EDB> <MRL>                                                *) # #(*                                                                  *) # (* Date of last modification: <851107.0922>   #(*                                                                  *) # #(********************************************************************) # $ Page $      $ Heap 0 $  	$ Recursive OFF $  	 $ Subprogram  $   $ Range OFF $   	$ Private_Types $  	     
PROGRAM upshiftmain; 
     #(********************************************************************) # #(*                                                                  *) # #(* This file contains several routines which perform operations on  *) # #(* strings of variable length, including upshifting lower case,     *) # #(* determining the length of significant characters in a string,    *) # #(* and a general purpose string handling routine for concatenating, *) # #(* truncating, and inserting strings.                               *) # #(*                                                                  *) # #(********************************************************************) #     #(********************************************************************) # #(*                      CONSTANTS and TYPES                         *) # #(********************************************************************) #         CONST          minint = -32768;                (* minimum short integer *)     maxint = 32767;                 (* maximum short integer *)      "   chars_in_infinite_str = maxint; (* param string size in chars *)  "    no_upshift_err = 0;         zero = 0;     one  = 1;          TYPE      #   short_int = minint..maxint;     (* short integer is 16 bits wide *) #         infinite_str =                  (* input string definition *)         PACKED ARRAY [1..chars_in_infinite_str] OF char;         string_operations_type =  (* for string manipulations *)         (str_assign,       (* dest := srce *)          str_append,       (* dest := dest ++ srce *)          str_blankappend,  (* dest := dest ++ ' ' ++ srce *)  
       str_overlay,  
 "          (* dest := dest[1..n-1] ++ srce ++ dest[n+len(srce)..$] *) " 	       str_insert, 	           (* dest := dest[1..n-1] ++ srce ++ dest[n..$] *)         str_remove);      (* dest := dest -- srce *)       $ Page $  #(********************************************************************) # #(*                      upshift                                     *) # #(********************************************************************) # #(*                                                                  *) # #(* ROUTINE : UPSHIFT                                                *) # #(*                                                                  *) # #(* PURPOSE : This routine changes the case in the specified         *) # #(*           ASCII character string.                                *) # #(*           Lower case characters are converted into upper case.   *) # #(*           The upshifted string is returned.                      *) # #(*                                                                  *) # #(* Altered:  October 1983 for Upper case of arbitrary string.       *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE upshift $ALIAS 'UPSHIFT'$      ( VAR in_str  : infinite_str;       VAR out_str : infinite_str;           str_len : Short_int);          CONST   !   a_val = ord('a');               (* integer value of little a *) ! !   z_val = ord('z');               (* integer value of little z *) ! $   delta_val = ord('A') - ord('a'); (* delta value between uc and lc *)  $         VAR      str_ptr: short_int;             (* string pointer *)       chr_val: short_int;             (* character integer value *)       
BEGIN (* upshift *)  
     	   IF str_len > 0  	       THEN BEGIN               FOR str_ptr := 1 TO str_len DO BEGIN               chr_val := ord (in_str[str_ptr]);               IF (chr_val >= a_val) AND (chr_val <= z_val)  !               THEN out_str[str_ptr] := chr (chr_val + delta_val)  !                ELSE out_str[str_ptr] := chr (chr_val);  
            END; (* FOR *) 
              END; (* then *)         END; (* upshift *)   $ Page $  #(********************************************************************) # #(*                     string_length                                *) # #(********************************************************************) # #(*                                                                  *) # #(* Purpose:                                                         *) # #(*    To return the byte length of significant characters in an     *) # #(*    arbitrary string.  The string and maximum string length are   *) # #(*    needed.  The longest possible string is 32767 chars long.     *) # #(*    The string must be blank-filled to its maximum length.        *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in)  (1) The string to measure.                              *) # #(*    (in)  (2) The string's maximum length.                        *) # #(*                                                                  *) # #(* Function result:                                                 *) # #(*    The number of bytes of significant characters in the string.  *) # #(*                                                                  *) # #(* NOTE! A blank string has a length of ZERO!                       *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION string_length   $ Alias 'Img.StringLength' $      (VAR string : infinite_str;          maxlen : short_int) : short_int;      CONST      blank = ' ';       VAR      index : short_int;       
BEGIN (* string_length *)  
     
   index := maxlen;  
        WHILE (index > 0) AND (string[index] = blank) DO   
      index := index - 1;  
     
   string_length := index; 
     END; (* string_length *)  $ Page $  #(*******************************************************************)  # #(*                        find_string                              *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    Given two strings of arbitrary length, to return the starting*)  # #(*    byte where string2 exists in string1.  Zero is returned if   *)  # #(*    string2 does not exist in string1.                           *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)  (1) String to search in.                               *)  # #(*    (in)  (2) Maximum length of string to search in.             *)  # #(*    (in)  (3) String to look for.                                *)  # #(*    (in)  (4) Maximum length of string to look for.              *)  # #(*                                                                 *)  # #(* Function result:                                                *)  # #(*    0 (zero) if string2 is not in string1.                       *)  # #(*    Positive number is the byte where string2 starts in string1. *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION find_string   $ Alias 'Img.FindString' $      (VAR string1 : infinite_str;           maxlen1 : short_int;      VAR string2 : infinite_str;           maxlen2 : short_int) : short_int;       LABEL 99;  (* return label *)       VAR   
   len1, len2 : short_int; 
        index1 : short_int;     index2 : short_int;      
   match  : boolean; 
     BEGIN (* find_string *)          find_string := zero; (* Assume no match *)          len1 := string_length (string1, maxlen1);     len2 := string_length (string2, maxlen2);      !   (* If look-for is bigger than look-in, won't find anything. *)  !    IF (len2 > len1) THEN GOTO 99;          (* If look-in is null, won't find anything *)     IF (len1 = zero) THEN GOTO 99;       !   (* If look-for is a null string, return starting byte of 1. *)  !    IF (len2 = zero) THEN BEGIN  
      find_string := one;  
       GOTO 99;        END;             (**)      (* We will use a 2-level loop to first find a matching      (* first character, then an inner loop to match all chars.      (**)          FOR index1 := one TO len1 DO         IF string1[index1] = string2[one] THEN BEGIN           match := true;            FOR index2 := 2 TO len2 DO                IF (string1[index1 + index2 - one]<>string2[index2])                  THEN match := false;                IF match THEN BEGIN              find_string := index1;  
            GOTO 99; 
             END; (* substring found! *)                END; (* then first character matched *)      99:  (* return label *)       END; (* find_string *)  $ Page $  #(*******************************************************************)  # #(*                     string_manager                              *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To consolidate code and minimize redundancy of string        *)  # #(*    manipulators which perform the same algorithm with           *)  # #(*    strings of different sizes.   Virtually any common           *)  # #(*    string operation can be performed by the string manager      *)  # #(*    including assigning an arbitrary string to any other         *)  # #(*    string, (truncating if necessary), concatenating any         *)  # #(*    string with another string, (again truncating if necessary), *)  # #(*    and overlaying a part of a string with another string.       *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in/out) (1) Destination string. ('dest')                    *)  # #(*    (in)     (2) Maximum length of destination string.           *)  # #(*    (in)     (3) Source string to operate with. ('srce')         *)  # #(*    (in)     (4) Maximum length of source string.                *)  # #(*    (in)     (5) Operation code.                                 *)  # #(*    (in)     (6) Starting character for some operations.         *)  # #(*                                                                 *)  # #(* The operation codes are defined in [IMAGE, and the decimal      *)  # #(* equivalents are included here for convenience to Fortran        *)  # #(* programmers who wish to use these functions.  (++ means that    *)  # #(* the strings are concatenated or appended).   Truncation is      *)  # #(* done automatically if dest cannot contain the full result.      *)  # #(* (-- means the first occurrence of srce is deleted from dest).   *)  # #(*                                                                 *)  # #(* opcode = str_assign (or 0)                                      *)  # #(*    dest := srce;                                                *)  # #(*                                                                 *)  # #(* opcode = str_append (or 1)                                      *)  # #(*    dest := dest ++ srce;                                        *)  # #(*                                                                 *)  # #(* opcode = str_blankappend (or 2)                                 *)  # #(*    dest := dest ++ ' ' ++ srce;                                 *)  # #(*                                                                 *)  # #(* opcode = str_overlay (or 3)                                     *)  # #(*    dest := dest[1..n-1] ++ srce ++ dest[n+len(srce)..len(dest)];*)  # #(*                                                                 *)  # #(* opcode = str_insert (or 4)                                      *)  # #(*    dest := dest[1..n-1] ++ srce ++ dest[n..len(dest)];          *)  # #(*                                                                 *)  # #(* opcode = str_remove (or 5)                                      *)  # #(*    dest := dest -- srce;                                        *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE string_manager   $ Alias 'Img.StringMgr' $     (VAR dest    : infinite_str;           dmaxlen : short_int;      VAR srce    : infinite_str;           smaxlen : short_int;          opcode  : string_operations_type;           startbyte : short_int);       LABEL 99;  (* error exit *)       VAR   	   i : short_int;  	        dest_len : short_int;     srce_len : short_int;             (**** variables for adjusting dest ****)          start_adj_char : short_int;     end_adj_char   : short_int;             (**** variables for moving srce ****)         start_mov_char : short_int;             (**** variables for blank padding ****)         start_blank_char : short_int;          BEGIN  (* string manager *)          (**)      (* Make sure parameters are within certain limits:      (*    DMAXLEN and SMAXLEN must be positive.     (*    STARTBYTE must be in range of 0..DMAXLEN.     (**)          IF (dmaxlen <= zero) OR (smaxlen <= zero) OR          (startbyte < zero) OR (startbyte > dmaxlen) THEN GOTO 99;           (**)      (* All of the above operations can be described as a series     (* of two of the following string movements:      (*   1) Adjust a trailing substring of dest.      (*   2) Overlay dest at the proper place with srce.     (*   3) Blank-pad dest properly.      (*      (* For example, the str_insert operation would go:      (*   1) Move dest[n..$] to dest[n+len(srce)..$]     (*   2) Move srce to dest[n..n+len(srce)-1]     (*   3) no blank padding necessary.     (*      (* And str_remove:      (*   1) Move dest[n+len(srce)..$] to dest[n..$-len(srce)]     (*   2) Nothing needs to be done with srce.     (*   3) Blank out dest[$-len(srce)+1..$]      (**)          dest_len := string_length (dest, dmaxlen);      srce_len := string_length (srce, smaxlen);       	   CASE opcode OF  	           str_assign : BEGIN               (**)   
         (* dest := srce;  
          (*            (* 1) No adjustment to dest is needed.            (* 2) Move srce over dest[1].           (* 3) Blank pad from dest[len(srce)+1..$]           (**)                start_adj_char := -1;           start_mov_char := one;            start_blank_char := srce_len + one;               END; (* case of str_assign *)            str_append : BEGIN               (**)            (* dest := dest ++ srce;            (*            (* 1) No adjustment to dest needed.           (* 2) Move srce to dest[len(dest)+1].           (* 3) No blank padding needed.            (**)                start_adj_char := -1;           start_mov_char := dest_len + one;           start_blank_char := -1;               END; (* case of str_append *)                str_blankappend : BEGIN                (**)            (* dest := dest ++ ' ' ++ srce;           (*            (* 1) No adjustment to dest needed.           (* 2) Move srce to dest[len(dest)+2].           (* 3) No blank padding needed.            (**)                start_adj_char := -1;           start_mov_char := dest_len + 2;           start_blank_char := -1;               END; (* case of str_blankappend *)           
      str_overlay : BEGIN  
              (**)             (* dest := dest[1..n-1] ++ srce ++ dest[n+len(srce)..$]            (*            (* 1) No adjustment needed to dest.           (* 2) Move srce to dest[n].           (* 3) No blank padding needed.            (**)                start_adj_char := -1;           start_mov_char := startbyte; (* user supplied *)            start_blank_char := -1;               END; (* case of str_overlay *)                 str_insert : BEGIN               (**)             (* dest := dest[1..n-1] ++ srce ++ dest[n..$-len(srce)]            (*            (* 1) Adjust dest[n..len(dest)]           (*        to dest[n+len(srce)..len(dest)+len(srce)]           (*    and truncate if necessary.            (* 2) Move srce to dest[n].           (* 3) No blank padding needed.            (**)                start_adj_char := startbyte; (* user supplied *)            end_adj_char   := startbyte + srce_len;           start_mov_char := startbyte;            start_blank_char := -1;               END; (* case of str_insert *)                str_remove : BEGIN               (**)            (* dest := dest -- srce;  (if srce exists in dest).           (*   !         (* Find 'n' such that srce exists in dest beginning at n. !          (*            (* 1) Adjust dest[n+len(srce)..len(dest)]           (*        to dest[n..len(dest)-len(srce)].            (* 2) Srce is not moved anywhere.            (* 3) Blank pad dest[len(dest)-len(srce)+1..len(dest)]             (*            (**)       !         startbyte := find_string (dest, dmaxlen, srce, smaxlen);  !              IF (startbyte = zero) THEN GOTO 99;               start_adj_char := startbyte + srce_len;           end_adj_char   := startbyte;            start_mov_char := -1;           start_blank_char := dest_len - srce_len + one;                END; (* case of str_remove *)            OTHERWISE GOTO 99;  (* undefined opcode *)            END; (* case of opcode *)              (**)      (* Now we perform the three string manipulation functions     (* and arrive at a result to return to the caller.      (**)          (**)      (* (1) Adjust dest[start..len(dest)] to dest[end..?]      (**)          IF (start_adj_char <> -1)        THEN IF (start_adj_char < end_adj_char)                THEN FOR i := srce_len-1 DOWNTO zero DO BEGIN              IF ((end_adj_char + i) <= dmaxlen)  "               THEN dest[end_adj_char+i] := dest[start_adj_char+i];  "             END  (* making room for srce *)                ELSE FOR i := zero TO srce_len-1 DO BEGIN              IF ((start_adj_char + i) <= dmaxlen)  "               THEN dest[end_adj_char+i] := dest[start_adj_char+i];  "             END; (* removing srce from dest *)             (**)      (* (2) Move srce into the proper place in dest.     (**)          IF (start_mov_char <> -1) THEN         FOR i := zero TO srce_len-1 DO           IF (start_mov_char + i) <= dmaxlen THEN              dest[start_mov_char + i] := srce[i+one];             (**)      (* (3) Blank pad dest on the right.     (**)          IF (start_blank_char <> -1) THEN         FOR i := start_blank_char TO dmaxlen DO            dest[i] := ' ';         (**)      (* Tahdaahhh! Return the dest string to the caller.     (**)           99:  (* error exit *)       END;  .  