 $PASCAL ',7 92081-1X811 REV.2540' $   $ Title 'DBUTL Change logging status' $   $ Heap 0 $  	$ Recursive OFF $  	 $ Range OFF $       $ Subprogram $      PROGRAM change_logging_status;      !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18811                                        *)  ! !(* RELOC:   92081-16811                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <EDB> <MRL> <MES>                              *)  ! !(*              <TH> for NLS                                   *)  ! !(*                                                             *)  ! !(* Date last modified: <830128.1643>                           *)  ! !(*                                                             *)  ! !(***************************************************************)  !     (**)  &(*:nl:$ATB, mut_lg, %ut000, relocatable, 92081-16078 REV.2540 <851118.1436>  & (*:nl:$   
(*:nl:$COUNTER, 1, 1000, 1 
 (**)      $ List OFF, Include '[IMAGE', List ON $   $ List OFF, Include '[DBUTL', List ON $   $ List OFF, Include '[UTNLS', List ON $   $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) #     $ List OFF $  
$ Include '[XUU_M' $ 
 
$ Include '[XUU_3' $ 
 
$ Include '[XDSMR' $ 
 
$ Include '[XUU_4' $ 
 
$ Include '[XDFMP' $ 
     
$ Include '[XDCIO' $ 
 
$ Include '[XDMSG' $ 
 
$ Include '[XDSEM' $ 
 
$ Include '[XUSHF' $ 
 $ Include '[XDNLS' $  (* NLS externals *)   $ List ON $       $(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *)  $  PROCEDURE MUT_LG; EXTERNAL;                                        $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* ROUTINE : execute_lg_command                                     *) # #(*                                                                  *) # #(* PURPOSE : This routine performs the operations of the DBUTL LG   *) # #(*           command.  The LG command is used to control logging    *) # #(*           of data bases in the IMAGE subsystem.                  *) # #(*                                                                  *) # #(* PROGRAMMER : <EDB> <MRL> <STC> <MES>                             *) # #(*                                                                  *) # #(********************************************************************) # $ Page $  #(********************************************************************) # #(*                      execute_lg_command                          *) # #(********************************************************************) #     PROCEDURE execute_lg_command   $ Alias 'DBUTL.LG.CMD' $      ( VAR parameter_buffer: parm_buffer );       TYPE  "   logging_names_type =            (* array of names for display *)  "       ARRAY [logging_states] OF short_str;  (*  CONST      logging_names = logging_names_type   #      [ short_str [ 'Intrinsic Only', chars_in_short_str-14 of ' ' ],  #         short_str [ 'Rollback', chars_in_short_str-8 of ' ' ],  #        short_str [ 'RollFwd Spooled', chars_in_short_str-15 of ' ' ], # $        short_str [ 'RollFwd NoSpool', chars_in_short_str-15 of ' ' ] ]; $        transaction_logging =  #      long_str [ 'Transaction Logging', chars_in_long_str-19 of ' '];  #  *)         (**)        (*:nl:$   '      (*:nl:$  'The message length of No.0 to 10 must be within 127 bytes.' *) '       (*:nl:#0    'Intrinsic Only'        (*:nl:#1    'Rollback'        (*:nl:#2    'RollFwd Spooled'         (*:nl:#3    'RollFwd NoSpool'         (**)        (*:nl:#10  'Transaction Logging' *)       VAR      log_change: boolean;            (* logging change flag *)     log_option: logging_states;     (* logging change option *)      &   system_logging_flag: boolean;   (* system logging change request flag *)  & $   shutdown_flag:  boolean;        (* set if determined that shutdown *) $        log_int1, log_int2 : Short_int; (* Numeric log states *)      return_status : Short_int;      dummy_error   : Short_int;      reply_len     : Short_int;      rootfile_header : rootfile_header_type;         lname_str     : Long_str;       (* NLS *)     message_num   : Short_int;      (* NLS *)      PROCEDURE handle_system_logging;      BEGIN (* handle_system_logging *)          WITH dbcon_table.dbcon_status_block DO BEGIN         IF read_dbcon_table (dbcon_file,                             dbc_status_blk,                             do_not_lock_dbcon_file,                             block,                              return_status)            THEN nonfatal_error (return_status);             (**)  "      (* Make sure that change in logging status is always DOWNWARD  "       (* while IMAGE is active.  (Saves much code).         (**)      
      IF flag.image_active 
          THEN               IF (ord(log_option) > ord(logging_state)) OR                 (ord(log_option) >= ord(rb_rf))  !               THEN nonfatal_error (IMAGE_must_be_shut_down_err);  !     	   END; (* with *) 	        (* check if system logging change *)      IF log_change THEN BEGIN (* change sys logging state *)            WITH dbcon_table.dbcon_bif_info_block DO BEGIN           IF read_dbcon_table (dbcon_file,                                 dbc_bif_info_blk,                                 do_not_lock_dbcon_file,                                 block,                                return_status)              THEN nonfatal_error (return_status);      
         IF bif_name = ' ' 
             THEN nonfatal_error (bif_not_defined_err);           END; (* with *)            IF log_option <> intr_only           THEN WITH dbcon_table.dbcon_tlf_info_block DO BEGIN              IF read_dbcon_table (dbcon_file,                                   dbc_tlf_info_blk,                                   do_not_lock_dbcon_file,                                   block,                                    return_status)                  THEN nonfatal_error (return_status);                   IF tlf_name = ' '                  THEN nonfatal_error (tlf_not_defined_err);                   END; (* with *)                 IF (log_option = rb_rf) OR (log_option = rf_nospool)           THEN WITH dbcon_table.dbcon_rfl_info_block DO BEGIN              IF read_dbcon_table (dbcon_file,                                   dbc_rfl_info_blk,                                   do_not_lock_dbcon_file,                                   block,                                    return_status)                  THEN nonfatal_error (return_status);                   IF rfl_name = ' '                  THEN nonfatal_error (rfl_not_defined_err);                   END;  (* with *)                WITH dbcon_table.dbcon_status_block DO BEGIN           IF read_dbcon_table (dbcon_file,                                 dbc_status_blk,                                 lock_dbcon_file,                                block,                                return_status)              THEN nonfatal_error (return_status);      &         shutdown_flag := NOT (flag.image_active);(* in dbcon status blk *)  &          logging_state := log_option;                IF write_dbcon_table (dbcon_file,                                 dbc_status_blk,                                 unlock_dbcon_file,                                  block,                                  return_status)               THEN nonfatal_error (return_status);          !         (*  if shutdown, then system logging status can be    *)  ! !         (*  changed, but we can't tell the nonexistent DBMON  *)  ! !         (*  about the change.  It will find out at start-up.  *)  !              IF NOT shutdown_flag THEN BEGIN                  (* build dbmon message and check on it's status *)               IF build_dbmon_mesg_hdr ( to_bm_change_status_code,                                          return_status) THEN   #               (* we cannot send DBMON a message - it isn't around *)  #                return_status := zero  
         ELSE BEGIN  
             request_msg.dbmon.change_status.changed_status :=                     logging_state_changed;                  IF xchg_dbmon_msg (                        request_msg.dbmon,                        to_bm_change_status_mesg_len,                       request_msg.user,                       reply_len,                        to_user_utl_stat_change_mesg_len,                       return_status) THEN                       nonfatal_error(return_status);                      END;  (* else *)                    END;  (* telling DBMON about it *)                END  (* with *)      	   END  (* THEN *) 	        ELSE          WITH dbcon_table.dbcon_status_block DO BEGIN         IF read_dbcon_table (dbcon_file,                             dbc_status_blk,                             do_not_lock_dbcon_file,                             block,                              return_status)            THEN nonfatal_error (return_status);             log_option := logging_state;  
      END;  (* end with *) 
        (* display system logging state *)   (* temp_str := 'System Logging state='; *)     (*:nl:#*1 1000 'System Logging state=' *)  #   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_str, len);' *)  #    length := nlread (MUT_LG, 1000, nlerr, temp_str, len);          blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)     message_num := ord (log_option);      (*:nl:$COPY '   length := nlread (&, message_num' *)      length := nlread (MUT_LG, message_num      !                                         , nlerr, lname_str, len); !     blank_pad (lname_str, chars_in_long_str, length);  (* NLS *)    (* append_str (temp_str, logging_names [log_option]); *)     append_long_str (temp_str, lname_str);      IF write_long_str (log_file, temp_str, return_status)        THEN nonfatal_error (return_status);      END; (* handle_system_logging *)      $ Page $      PROCEDURE handle_database_logging;      CONST      all_false_alter_get_value = alter_rootfile_types         [create_time : false,          backup_time : false,          volume_number : false,          first_trans : false,          volume_name : false,          log_set_name : false,  
       checksums : false,  
        db_modified : false,          part_unlogged : false,          logging_state : false,          accessibility : false];      VAR   
   start_char : short_int; 
    system_logging_state :  logging_states;     database_trans_logging :  boolean;       BEGIN (* handle_database_logging *)          temp_str := parameter_buffer.parameter[2].ascii;           file_dest_long_srce (temp_file.newfl, chars_in_new_file_name,                           temp_str, chars_in_long_str,                          str_assign, zero);         (* Build the full root file name *)     build_root_name (temp_file.newfl);          (* Build the specific parts of the message and send it *)         IF log_change THEN BEGIN             IF log_option = intr_only            THEN database_trans_logging := false            ELSE database_trans_logging := true;             IF build_dbmon_mesg_hdr (to_bm_alter_rootfile_code,                                  return_status)   !         THEN BEGIN  (* dbmon isn't around: alter root directly *) !                     IF open_rootfile (temp_file, return_status)                  THEN nonfatal_error (return_status);                   IF read_rootfile_hdr (temp_file,                                    rootfile_header,                                    return_status)                 THEN nonfatal_error (return_status);                   IF log_option = intr_only                  THEN rootfile_header.flags.logging := false                 ELSE rootfile_header.flags.logging := true;                  IF write_rootfile_hdr (temp_file,                                      rootfile_header,                                      return_status)                  THEN nonfatal_error (return_status);                   IF close_file (temp_file, return_status) THEN;                  END (* altering rootfile directly. *)       
         ELSE BEGIN  
                 WITH request_msg.dbmon.alter_rootfile DO BEGIN                 database := temp_file.newfl;                  to_alter := all_false_alter_get_value;                  to_alter.logging_state := true;                 IF log_option = intr_only THEN                     log_state := false                    ELSE                    log_state := true;                 END;  (* with *)                   (* send the message to dbmon *)               IF xchg_dbmon_msg (                  request_msg.dbmon,                  to_bm_alter_rootfile_mesg_len,                  request_msg.user,  
               reply_len,  
                to_user_utl_stat_change_mesg_len,                 return_status) THEN                 nonfatal_error (return_status);                  WITH request_msg.user.utl_stat_change_mesg DO                  IF reply.status <> zero THEN                     nonfatal_error (reply.status);               END  (* ELSE *)            END  (* changing database log status *)          ELSE BEGIN         (* get the current database logging status *)             IF build_dbmon_mesg_hdr (to_bm_get_rootfile_info_code,                                 return_status)   !         THEN BEGIN  (* DBMON is not around: read root directly *) !                 IF open_rootfile (temp_file, return_status)                  THEN nonfatal_error (return_status);                   IF read_rootfile_hdr (temp_file,                                    rootfile_header,                                    return_status)                 THEN nonfatal_error (return_status);                   IF close_file (temp_file, return_status) THEN;                  IF rootfile_header.flags.logging                 THEN database_trans_logging := true                 ELSE database_trans_logging := false;              END (* then read info directly *)             ELSE BEGIN (* ask DBMON for the information *)               WITH request_msg.dbmon.get_rootfile_info DO BEGIN              database := temp_file.newfl;              to_get   := all_false_alter_get_value;              to_get.logging_state := true;            END; (* with *)               IF xchg_dbmon_msg (request_msg.dbmon,                              to_bm_get_rootfile_info_mesg_len,                               request_msg.user,                               reply_len,                              to_user_utl_accst_mesg_len,                               return_status)              THEN Nonfatal_error (return_status);               (* Did DBMON encounter any error ? *)           WITH request_msg.user.utl_logst_mesg DO              IF reply.status <> zero THEN                 nonfatal_error (reply.status);                IF request_msg.user.utl_logst_mesg.db_log_status               THEN database_trans_logging := true               ELSE database_trans_logging := false;             END; (* getting the info from DBMON *)         END; (* getting database logging state *)             (* display database logging state *)   (* temp_str := 'Database Logging state='; *)     (*:nl:#*1 1001 'Database Logging state=' *)  #   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_str, len);' *)  #    length := nlread (MUT_LG, 1001, nlerr, temp_str, len);          blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)         IF database_trans_logging        THEN BEGIN                (* read system logging state since dependent on that *)            WITH dbcon_table.dbcon_status_block DO BEGIN               IF read_dbcon_table (dbcon_file,                                   dbc_status_blk,                                   do_not_lock_dbcon_file,                                   block,                                    return_status)                  THEN nonfatal_error (return_status);               system_logging_state := logging_state;           END; (* WITH *)                (* just display 'TRANSACTION LOGGING' since we don't *)             (* know what kind of logging the database was given  *)   (*       append_long_str ( temp_str, transaction_logging ); *)      !         (*:nl:$COPY '         length := nlread (&, 10, nlerr' *)  !          length := nlread (MUT_LG, 10, nlerr                                                 , temp1_str, len);   #         blank_pad (temp1_str, chars_in_long_str, length);  (* NLS *)  #          append_long_str ( temp_str, temp1_str);               IF log_change              THEN IF log_option <> system_logging_state                      THEN append_str ( temp_str, '*' );               (* print the type of database logging *)             IF write_long_str ( log_file, temp_str, return_status )               THEN nonfatal_error ( return_status );               (*  now, display the system log state  *)  (*       temp_str := 'System Logging State='; *)           (*:nl:#*1 1002 'System Logging State=' *)           (*:nl:$COPY '         length := nlread (&, #' *)            length := nlread (MUT_LG, 1002       !                                          , nlerr, temp_str, len); ! "         blank_pad (temp_str, chars_in_long_str, length);  (* NLS *) " !         message_num := ord (system_logging_state);     (* NLS *)  !         (*:nl:$COPY '         length := nlread (&' *)            length := nlread (MUT_LG                             ,message_num, nlerr, lname_str, len);   #         blank_pad (lname_str, chars_in_long_str, length);  (* NLS *)  # %(*       append_str ( temp_str, logging_names [system_logging_state]); *)  %          append_long_str ( temp_str, lname_str);               IF write_long_str (log_file, temp_str, return_status)              THEN nonfatal_error (return_status);            END  (* transaction logging case *)          ELSE BEGIN  (* intrinsic logging case *)             (* just print out database logging state (intrinsic) *)         message_num := ord (log_option);  "      (*:nl:$COPY '      length := nlread (&, message_num, nlerr' *) "       length := nlread (MUT_LG, message_num, nlerr                                         , lname_str, len);   !      blank_pad (lname_str, chars_in_long_str, length);  (* NLS *) ! (*    append_str ( temp_str, logging_names [log_option]); *)        append_long_str ( temp_str, lname_str);         IF write_long_str ( log_file, temp_str, return_status)           THEN nonfatal_error ( return_status );          END; (* intrinsic logging case *)      END; (* handle_database_logging *)  $ Page $  BEGIN (* execute_lg_command *)         (* check required database parameter *)     WITH parameter_buffer.parameter [2] DO   	      CASE typ OF  	              (* cannot be not supplied *)            non:               nonfatal_error (missing_parameter_err);                int: (* integer parameter *)               nonfatal_error (illegal_parm_type_err);                asc: (* ascii parameter *)               BEGIN                  (* check parameter *)                 IF ascii = '* '                    THEN system_logging_flag := true                    ELSE system_logging_flag := false;                 END; (* asc CASE *)               END; (* CASE *)         (* check optional logging option parameter *)     WITH parameter_buffer.parameter [3] DO   	      CASE typ OF  	              non: (* not supplied *)              log_change := false;               int: (* integer parameter *)               nonfatal_error (illegal_parm_type_err);                asc: (* ascii parameter *)               BEGIN                  (* check parameter *)                 (* check for logging options *)                 IF ascii = 'IN'                    THEN log_option := intr_only                 ELSE IF ascii = 'RB'                     THEN log_option := rb_only                 ELSE IF ascii = 'RF'                     THEN log_option := rb_rf                 ELSE IF ascii = 'RFN'                    THEN log_option := rf_nospool                  ELSE nonfatal_error (illegal_option_err);                     log_change := true;                 END; (* asc CASE *)               END; (* CASE *)         (* check if system logging or database logging *)  
   IF system_logging_flag  
       THEN handle_system_logging (* handle system logging *)  !      ELSE handle_database_logging; (* handle database logging *)  !     END; (* execute_lg_command *)   .  