$PASCAL ',7 92081-1X800 REV.5000' $  $ Title 'DBUTL: Define Roll Forward Log' $  $ Heap 0 $ $ Recursive OFF $ $ Range OFF $      $ Subprogram $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18800                                        *)   (* RELOC:   92081-16800                                        *)   (*                                                             *)   (* PGMR:        <EDB> <MRL> <MES>                              *)   (*              <TH> for NLS                                   *)   (*                                                             *)   (* Date last modified: <870113.1611>  (*                                                             *)   (* Altered: July 1986 for new O/S numbers. <MRL>               *)   (*                                                             *)   (***************************************************************)       (**) %(*:nl:$ATB, mut_rl, %ut000, relocatable, 92081-16078 REV.2540 <870113.1611> %(*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**)     	PROGRAM rl_command; 	    $ List OFF, Include '[IMAGE', List ON $ $ List OFF, Include '[DBUTL', List ON $ $ List OFF, Include '[UTNLS', List ON $  $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) #      $ List OFF, Include '[XDMSG', List ON $  (* Message externals *)   !$ List OFF, Include '[XDSEM', List ON $  (* Resource# externals *) ! !$ List OFF, Include '[XDCIO', List ON $  (* DBCON I/O externals *) ! !$ List OFF, Include '[XDTDY', List ON $  (* Timestamp externals *) !    $ List OFF, Include '[XUU_M', List ON $ $ List OFF, Include '[XUU_3', List ON $ $ List OFF, Include '[XDSMR', List ON $ $ List OFF, Include '[XUU_4', List ON $ $ List OFF, Include '[XDFMP', List ON $ $ List OFF, Include '[XUSHF', List ON $  $ List OFF, Include '[XDNLS', List ON $  (* NLS externals *)     #(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *) #PROCEDURE MUT_RL; EXTERNAL;                                         (*** Get the operating system number ***)     FUNCTION operating_system  $ Alias 'IMG.OPSY' $     : os_kinds;     EXTERNAL;      $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* ROUTINE : execute_rl_command                                     *) # #(*                                                                  *) # #(* PURPOSE : This routine performs the operations of the DBUTL RL   *) # #(*           command.  The RL command is change or display the      *) # #(*           file to which transaction log records are save for     *) # #(*           roll forward recovery.                                 *) # #(*                                                                  *) # #(* PROGRAMMER : <EDB> <MRL>                                         *) # #(*                                                                  *) # #(********************************************************************) # $ Page $  #(********************************************************************) # #(*                      execute_rl_command                          *) # #(********************************************************************) #    PROCEDURE execute_rl_command   $ Alias 'DBUTL.RL.CMD' $    ( VAR parameter_buffer: parm_buffer );     CONST    blank = ' ';    all_blanks = short_str [ chars_in_short_str OF ' '];     max_rfl_volumes = entries_in_history_table; 
(* volume = short_str 
      ['VOLUME ', chars_in_short_str-7 OF ' '];  *)     do_not_extend_file = false;     VAR     rflf_change     : boolean;     (* rflf change flag *)        return_status     : Short_int; (* IMAGE error status word *)    dummy_status      : Short_int;    volume            : Short_str; (* NLS *)    volume_chars      : Short_str; (* 1-999 in character form *)    temp_volume_number: Short_int;     disc_vol_found    : Boolean;      vol_index         : Short_int;      history_entry     : History_table_entry_type;         temp_status_block : dbcon_status_block_type;      temp_string       : Long_str;     total_vol         : Short_int;      media_option      : char;     file_size         : long_int;             PROCEDURE unlock_error_exit ( return_status: short_int );     VAR        error_code:  short_int;          BEGIN  $      IF unlock_dbcon ( IMAGE_comm_buffer.dbcon_file_lock, error_code )  $          THEN nonfatal_error ( cannot_unlock_dbcon_file_err );        nonfatal_error ( return_status );          END;  (* unlock_error_exit *)      BEGIN (* execute_rl_command *)     !   rflf_change := true;  (* assume change until proven otherwise *) !        (* if no parameters supplied then assume no change *) 
   WITH parameter_buffer DO 
 !      IF (parameter[2].typ = non) AND (parameter[3].typ = non) AND !          (parameter[4].typ = non) AND (parameter[5].typ = non)          THEN rflf_change := false;             IF rflf_change THEN BEGIN            (**)        (* Make sure the rfl logical name is <= 16 characters.        (**)           IF long_str_len (parameter_buffer.parameter[2].ascii,                         chars_in_long_str) > chars_in_short_str           THEN nonfatal_error (parameter_too_long_err);            (**)        (* Make sure that IMAGE is not active.        (**)        WITH dbcon_table.dbcon_status_block DO BEGIN          IF read_dbcon_table (dbcon_file,                               dbc_status_blk,                               do_not_lock_dbcon_file,                                block,                                return_status)              THEN nonfatal_error (return_status);              IF flag.IMAGE_active             THEN nonfatal_error (image_active_err);               IF flag.corrupt_rfl             THEN nonfatal_error (new_log_set_required_err);     
      END; (* with *) 
           (**)        (* Read the DBCON rfl info block into memory for later use.         (**)            WITH dbcon_table.dbcon_rfl_info_block DO BEGIN          IF read_dbcon_table (dbcon_file,                               dbc_rfl_info_blk,                                lock_dbcon_file,                                block,                                return_status)             THEN unlock_error_exit (return_status);              IF rflf_set_name = ' '             THEN unlock_error_exit (set_not_defined_err);              (* update volume number *)           rflf_vol_num := rflf_vol_num + one;               (* if spare is defined, then make sure there *)           (* will be a volume number available for it  *)           IF (srfl_name <> ' ')              THEN total_vol := rflf_vol_num + one             ELSE total_vol := rflf_vol_num;              IF total_vol > max_rfl_volumes              THEN unlock_error_exit (max_volumes_exceeded_err);     
      END; (* with *) 
                   (**)        (* See if the media is disc or tape.        (**)            WITH parameter_buffer.parameter[3] DO   
         CASE typ OF 
     #            non,int:   (* DISC or TAPE (or D or T) must be supplied *) # !                       unlock_error_exit (missing_parameter_err);  !                 asc:  (* assign string to media option variable *)                    media_option := ascii[1];                END; (* case *)            IF (media_option <> 'D') AND (media_option <> 'T')           THEN unlock_error_exit (illegal_option_err);                 (**)        (** tape media option **)         (**)        IF media_option = 'T'   (* rfl file to be on tape *)  
         THEN BEGIN  
                 (**)  !            (* put magtape LU parameter in temp_str for later use  !             (**)                  WITH parameter_buffer.parameter[4] DO   
               CASE typ OF 
                       non: (* not supplied, default to LU 8*)                          temp_str := '8';                         int: (* integer parameter *)                          temp_str := ascii;                        asc:  unlock_error_exit (not_tape_file_err);                     END; (* case *)      !            (* magtape lu must be opened in order to get status *) !$            file_dest_long_srce (temp_file.newfl, chars_in_new_file_name, $                                 temp_str, chars_in_long_str,                                  str_assign, zero);                 IF open_file_for_write (temp_file, return_status)                 THEN unlock_error_exit (return_status);                 (* verify status returned after open *)              IF NOT is_tape_file (temp_file) THEN BEGIN                  IF close_file (temp_file, return_status) THEN;                  unlock_error_exit (not_tape_file_err);                  END; (* begin *)                  (* now close magtape lu, DBMON will open  *)              (* again later, if needed for logging.    *)              IF close_file (temp_file, return_status) THEN;                  (* make sure spare is not same magtape lu *)              WITH dbcon_table.dbcon_rfl_info_block DO BEGIN                    IF srfl_name = temp_file.newfl                   THEN unlock_error_exit (same_device_err);                    (* if spare is disc file then update    *)                (* physical name to match volume number *)  "               IF ((srfl_name[one] < '0') OR (srfl_name[one] > '9')) "                   AND (srfl_name <> ' ')                    THEN  !                     IF rename_spare (srfl_name, rflf_vol_num+one, !                                       return_status)                         THEN unlock_error_exit (return_status);     
            END; (* with *) 
           END; (* tape media option *)               (* disc media option *)       IF media_option = 'D'  (* rfl file to be on disc *) 	         THEN BEGIN 	                (* check file size *)              WITH parameter_buffer.parameter[5] DO   
               CASE typ OF 
                     non:  (* not supplied, zero will cause default *)                        file_size := 0;      
               int:  
                      file_size := value;      
               asc:  
                       unlock_error_exit (illegal_file_size_err);                       END; (* case *)                          WITH dbcon_table.dbcon_rfl_info_block DO BEGIN     "               IF create_logfile_name (parameter_buffer.parameter[4], "                                       file_size,                                        main_rf_log,                                        temp_file.newfl,                                         rflf_vol_num,                                        return_status)                   THEN unlock_error_exit ( return_status );     $               (* update physical name of spare to match volume number *) $ "               (* + one so rflf can be created with volume number *) ""               (* must be done before new rfl disc file is created *) " "               IF ((srfl_name[one] < '0') OR (srfl_name[one] > '9')) "                   AND (srfl_name <> ' ')                    THEN  !                     IF rename_spare (srfl_name, rflf_vol_num+one, !                                       return_status)                         THEN unlock_error_exit (return_status);                    (* create the roll forward log file on disc *) !               IF create_file (temp_file, return_status) THEN BEGIN !                     (* give spare back its old name *) $                    IF ((srfl_name[one] < '0') OR (srfl_name[one] > '9')) $                       AND (srfl_name <> ' ') 
                       THEN 
!                          IF rename_spare (srfl_name, rflf_vol_num, !                                            dummy_status) #                             THEN unlock_error_exit (spare_rename_err); #                           unlock_error_exit (return_status);                    END;     
            END; (* with *) 
                IF operating_system = RTE6 THEN BEGIN  #               (* remove protections on the file; DBSPL is detached *) # "               IF remove_file_protections (temp_file, return_status) "                  THEN unlock_error_exit (return_status);                 END; (* then remove file protections *)                  IF close_file (temp_file, return_status) THEN;                END; (* disc media option *)                (* now update remaining information in rfl_info_block *)        (* and write back in the DBCON file                   *)           (*:nl:#*1 1000 'VOLUME ' *) &      (*:nl:$COPY '      length := nlread_s (&, #, nlerr, volume, len_s);' *) &       length := nlread_s (MUT_RL, 1000, nlerr, volume, len_s);  !      blank_pad_s (volume, chars_in_short_str, length);  (* NLS *) !           WITH dbcon_table.dbcon_rfl_info_block DO BEGIN               (* if spare has default logical name then update   *)           (* it to match the new physical name for the spare *)          IF srfl_defaulted THEN BEGIN                 temp_str := volume;                  make_volume_num (rflf_vol_num+one,                                  volume_chars);                  append_str (temp_str, volume_chars);             truncate_str (temp_str, srfl_logical_name);     
            END; (* then *) 
                 (* update physical rfl name *)              rfl_name := temp_file.newfl;                  (* update logical rflf name *)             WITH parameter_buffer.parameter[2] DO  
               CASE typ OF 
                    non : (* make default logical name *)                   BEGIN                       temp_str := volume;                          make_volume_num (rflf_vol_num,                                        volume_chars);                          append_str (temp_str, volume_chars);                          truncate_str (temp_str, rfl_logical_name);                   END; (* non case *)                    int, asc : BEGIN                       truncate_str (ascii, rfl_logical_name);                   END; (* case of int or ascii *)                     END; (* case *)                  (* update flag so DBSPL will initialize new log *)              rfl_new_log := TRUE;                 (* write updated information to DBCON file *)             IF write_dbcon_table (dbcon_file,                                   dbc_rfl_info_blk,                                   do_not_unlock_dbcon_file,                                    block,                                    return_status)                 THEN unlock_error_exit (return_status);      !            (****************************************************) ! !            (* now update the history information in DBCON file *) ! !            (****************************************************) !                long_dest_file_srce (temp_str, chars_in_long_str, $                                 temp_file.newfl, chars_in_new_file_name, $                                 str_assign, zero);                 WITH history_entry DO BEGIN                log_name := temp_file.newfl;                 logical_name := rfl_logical_name;                 unused_1 := zero;                 unused_2 := zero;                 get_time_of_day (start_time);                 end_time := start_time;                used_volume_flag := false; 
            END; (* with *) 
                 IF write_history_table_entry                    (dbcon_file,                    unlock_dbcon_file,                     rflf_vol_num,                    history_entry,                    return_status)                 THEN unlock_error_exit (return_status);               END; (* with *)      
   END;  (* rflf_change *) 
       (* if rflf did not change then dbcon table hasn't *)    (* been read yet, so read it.                     *) 
   IF NOT rflf_change 
      THEN WITH dbcon_table.dbcon_rfl_info_block DO          IF read_dbcon_table (dbcon_file,                               dbc_rfl_info_blk,                                do_not_lock_dbcon_file,                                 block,                                return_status)              THEN nonfatal_error (return_status);        (**)    (* display roll forward log file definition.    (**)        WITH dbcon_table.dbcon_rfl_info_block DO BEGIN        temp_str := ' ';       IF write_long_str (log_file, temp_str, return_status)          THEN nonfatal_error (return_status);      (*    temp_str := 'Roll-Forward Log Set Name='; *)        (*:nl:#*1 1001 'Roll-Forward Log Set Name=' *) %      (*:nl:$COPY '      length := nlread (&, #, nlerr, temp_str, len);' *) %        length := nlread (MUT_RL, 1001, nlerr, temp_str, len);             blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)        append_str (temp_str, rflf_set_name);       IF write_long_str (log_file, temp_str, return_status)          THEN nonfatal_error (return_status);     (*    temp_str := 'Roll-Forward Log='; *)       (*:nl:#*1 1002 'Roll-Forward Log=' *) %      (*:nl:$COPY '      length := nlread (&, #, nlerr, temp_str, len);' *) %        length := nlread (MUT_RL, 1002, nlerr, temp_str, len);             blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)        IF rfl_name = ' '  (*       THEN temp_str := 'Roll-Forward Log is not defined' *) 	         THEN BEGIN 	          (*:nl:#*1 1003 'Roll-Forward Log is not defined' *)          (*:nl:$COPY '         length := nlread (&, #' *)          length := nlread (MUT_RL, 1003                                    , nlerr, temp_str, len);  "         blank_pad (temp_str, chars_in_long_str, length);  (* NLS *) "          END          ELSE long_dest_file_srce (temp_str, chars_in_long_str,  "                                   rfl_name, chars_in_new_file_name, "                                   str_append, zero);       IF write_long_str (log_file, temp_str, return_status)          THEN nonfatal_error (return_status);      (*    temp_str := 'Roll-Forward Log Logical Name='; *)        (*:nl:#*1 1004 'Roll-Forward Log Logical Name=' *) %      (*:nl:$COPY '      length := nlread (&, #, nlerr, temp_str, len);' *) %        length := nlread (MUT_RL, 1004, nlerr, temp_str, len);             blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)        IF rfl_name <> ' ' THEN BEGIN          append_str (temp_str, rfl_logical_name);           IF write_long_str (log_file, temp_str, return_status)              THEN nonfatal_error (return_status);          END;     (*    temp_str := 'Spare Roll-Forward Log='; *)       (*:nl:#*1 1005 'Spare Roll-Forward Log=' *) %      (*:nl:$COPY '      length := nlread (&, #, nlerr, temp_str, len);' *) %        length := nlread (MUT_RL, 1005, nlerr, temp_str, len);             blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)         IF srfl_name = ' ' "(*       THEN temp_str := 'Spare Roll-Forward Log is not defined.' *) "	         THEN BEGIN 	!         (*:nl:#*1 1006 'Spare Roll-Forward Log is not defined.' *) !         (*:nl:$COPY '               length := nlread (&, #' *)                length := nlread (MUT_RL, 1006                                               , nlerr, temp_str, len);   %               blank_pad (temp_str, chars_in_long_str, length);  (* NLS *) % 	               END 	           ELSE  long_dest_file_srce (temp_str, chars_in_long_str,  "                                   srfl_name, chars_in_new_file_name, "                                   str_append, zero);       IF write_long_str (log_file, temp_str, return_status)          THEN nonfatal_error (return_status);      (*    temp_str := 'Spare Roll-Forward Log Logical Name='; *)        (*:nl:#*1 1007 'Spare Roll-Forward Log Logical Name=' *) %      (*:nl:$COPY '      length := nlread (&, #, nlerr, temp_str, len);' *) %        length := nlread (MUT_RL, 1007, nlerr, temp_str, len);             blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)         IF srfl_name <> ' ' THEN BEGIN           append_str (temp_str, srfl_logical_name);           IF write_long_str (log_file, temp_str, return_status)              THEN nonfatal_error (return_status);          END;            temp_str := ' ';       IF write_long_str ( log_file, temp_str, return_status )          THEN nonfatal_error (return_status);      	   END; (* with *) 	     END; (* execute_rl_command *)   .  