 $PASCAL ',7 92081-1X517 REV.2540' $       
$ Include '[LBOPT' $ 
     PROGRAM before_image_logging;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18517                                        *)  ! !(* RELOC:   92081-16517                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Last modified: <850819.1642>   !(*                                                             *)  ! !(***************************************************************)  !             $ List OFF $  $ Include '[IMAGE' $    (* General IMAGE defn's.   *)   $ Include '[QA' $       (* Special QA codes *)  $ Include '[BMCCT' $    (* Workhorse constants and types *)       $ Include '[XWPTS' $    (* Pointer calculation routines. *)   $ Include '[XWRTF' $    (* Root file manipulation routines. *)  $ Include '[XERWD' $    (* EMA Disc I/O routines *)   $ Include '[XBQA'  $    (* QA used external *)  $ Include '[XDTDY' $    (* timing routines *)   $ List ON $   $ Page $      (**** Checksum the before-image buffer table. ****)           FUNCTION check_sum  $ Alias 'EMA.CheckSum' $  $ Heapparms ON $              (VAR BI_table   : Before_image_entry_types;   	$ Heapparms OFF $  	                  first_word : Short_int;                   last_word  : Short_int) : Short_int;      EXTERNAL;          (**** Checksum the before-image buffer table. ****)       FUNCTION checksum  $ Alias 'EMA.CheckSum' $   $ Heapparms ON $              (VAR buffer     : Long_int;   	$ Heapparms OFF $  	                  first_word : Short_int;                   last_word  : Short_int) : Short_int;      EXTERNAL;          (**** move words ****)      FUNCTION move_words          $ Alias 'EMA.MoveWords' $  $ Heapparms ON $        (VAR source_buf   : short_int;         VAR dest_buf     : short_int;  	$ Heapparms OFF $  	            num_of_words : short_int;         VAR error        : Short_int) : Boolean;      EXTERNAL;          (**** Call the proper checkpoint routine ****)      
FUNCTION check_point 
    (VAR workhorse_data : workhorse_info_type;       VAR error_code     : short_int) : Boolean;     EXTERNAL;          $ Page $  (************************************************************)  (*                                                          *)  (* Function FLUSH_BI_BUF : boolean;                         *)  (*                                                          *)  (* Purpose: To flush the before-image buffer upon request.  *)  (* Requests can come from posting of root file or data      *)  (* records to disc.  This flush is performed BEFORE writing *)  (* any data to the disc.                                    *)  (*                                                          *)  (* Parameters:                                              *)  (*    (in/out) (1) Workhorse information.                   *)  (*    (out)    (2) IMAGE error if an error occurs.          *)  (*                                                          *)  (* Errors: Disc write errors.                               *)  (*    A disc write error in this routine is FATAL!  Since   *)  (*    the disc write failed, it is impossible to gather the *)  (*    before-images for undoing either the current intrinsic*)  (*    or pasting back to checkpoint.  Therefore, this       *)  (*    constitutes a hard crash.  DBMON should quit when     *)  (*    this error is received.                               *)  (*                                                          *)  (* Function return: 'True' if an error occurred.            *)  (*                  'False' if all is well.                 *)  (*                                                          *)  (************************************************************)      	$ Heapparms OFF $  	     FUNCTION flush_BI_buf   $ Alias 'DBW.FlushBib' $     (VAR workhorse_data : workhorse_info_type;       VAR error          : short_int) : Boolean;      
LABEL 99; (* error exit *) 
     VAR   
   start_time : long_int;  
         BEGIN (* Flush_BI_buf *)      WITH workhorse_data DO BEGIN         (**)      (* If the before-image buffer is clean, just return.      (* If dirty, flush the entire buffer to disc, but do      (* not bother to reset it since we could conceivably      (* fit some other before-image blocks in the buffer.      (**)       !   IF BI_buf_state = clean         (* Does buffer need posting? *) ! !      THEN BEGIN                   (* No: return to caller.     *) !          flush_BI_buf := false;   	         GOTO 99;  	          END; (* then *)         Flush_BI_buf := true;  (* Assume an error will occur. *)              WITH bifi_buf_ptr^.tbl_hdr DO BEGIN        IF entries > zero   (* Does buffer contain data? *)            THEN BEGIN       (* Yes: Then flush the BIB to BIF *)              checksum :=   !               check_sum (bifi_buf_ptr^.BI_table[one].entry_type,  !                           one,                            words_in_BI_table);                   start_time := get_start_time;                   IF read_write_disc (write_to_device_code,                                   Before_image_file_ID,                                   entries,                                  total_bi_buffer_blocks,                                   BI_file_block,                                  error)  
               THEN BEGIN  
                   error := bif_corrupt_err;   
                  GOTO 99; 
                   END; (* then *)                   WITH sys_stats.system_stats DO BEGIN                 bif_writes := bif_writes + one;                 bif_write_io_time := bif_write_io_time +   !                                    get_elapsed_time (start_time); ! 
               END;  
                     (**)              (* Increment the bib flush count.               (**)      !            current_bib_flush_num := current_bib_flush_num + one;  !                     (* SPECIAL TEST FOR QA PURPOSES ONLY *)               IF qa_crash_code = qa_flush_bib THEN                  terminate_program (terminate_code);                END; (* then *)         END; (* flushing a before-image buffer *)         (**)      (* At this point our job is successfully complete!      (* Return 'false' to caller for 'no error'.     (**)       
   BI_buf_state := clean;  
     
   flush_BI_buf := false;  
     END;  (* with workhorse_data *)       99:   (* error exit *)      END;  (* function FLUSH_BI_BUF *)   $ Page $  (************************************************************)  (*                                                          *)  (* FUNCTION Get_next_BI_buf : Boolean;                      *)  (*                                                          *)  (*    Purpose: To handle all necessary Before-image buffer  *)  (* management and just return the next available entry      *)  (* index into the current BI buffer.                        *)  (*                                                          *)  (* Parameters:                                              *)  (*    (out)    (1) Next free entry number in the BIB.       *)  (*    (in/out) (2) Workhorse data.                          *)  (*    (out)    (3) IMAGE error if an error occurs.          *)  (*                                                          *)  (* Function Result: 'False' if no error, 'true' otherwise.  *)  (*                                                          *)  (* Possible errors: Disc failure or corrupt structures.     *)  (*                                                          *)  (************************************************************)      	$ Heapparms OFF $  	     FUNCTION Get_next_BI_entry   $ Alias 'DBW.NextBibEntry' $               (VAR entry          : Short_int;               VAR workhorse_data : workhorse_info_type;               VAR error          : Short_int) : Boolean;       
LABEL 99; (* error exit *) 
     CONST   !   bib_blocks = total_bi_buffer_blocks - one;  (*EOF not counted*) !         BEGIN (* Get_next_bi_entry *)       WITH workhorse_data DO BEGIN          Get_next_BI_entry := true;  (* Assume an error will occur. *)          WITH Bifi_buf_ptr^ DO BEGIN  !      entry := tbl_hdr.entries + one;  (* Increment entry num. *)  ! !      IF (entry > max_before_image_entries)   (* Is there room? *) ! !         THEN BEGIN                           (* No, flush BIB. *) !             IF Flush_BI_buf (workhorse_data, error)                  THEN GOTO 99;  
            entry := one;  
                 bi_file_block := bi_file_block + bib_blocks;                  END; (* THEN *)             END; (* WITH *)          Get_next_BI_entry := false; (* No error! *)      END; (* with workhorse_data *)      99:  (* error exit *)       END; (* Get_next_BI_entry *)  $ Page $  (************************************************************)  (*                                                          *)  (* Function COPY_BEFORE_IMAGE : Boolean;                    *)  (*                                                          *)  (*    Purpose: To take a buffer of disc blocks and          *)  (* move them from the source buffer (run table, data block, *)  (* or transaction buf)  into the before-image buffer.       *)  (*                                                          *)  (* Parameters:                                              *)  (*    (1) The pointer to the data to copy.                  *)  (*    (2) The number of blocks of data.                     *)  (*    (3) Starting block in file of first block to copy.    *)  (*    (4) Type of file to which data belongs.               *)  (*    (5) File namr (HP-1000 dependent).                    *)  (*    (6) Workhorse data.                                   *)  (*    (7) IMAGE error if one occurs.                        *)  (*                                                          *)  (* Outputs: None.                                           *)  (*                                                          *)  (* Function result: 'False' if no error, 'true' otherwise.  *)  (*                                                          *)  (* Possible errors:  Corrupt data or Disc Failure.          *)  (*                                                          *)  (************************************************************)      	$ Heapparms OFF $  	     FUNCTION copy_before_image   $ Alias 'DBW.MakeBImage' $               (VAR data_ptr     : Data_record_ptr_type;                    blocks       : Short_int;                   block_num    : Long_int;                    type_of_file : Image_file_types;   $ Heapparms ON $               VAR filename     : New_file_name;  	$ Heapparms OFF $  	              VAR workhorse_data : Workhorse_info_type;               VAR error          : Short_int) : Boolean;           LABEL 99;  (* error exit *)       VAR      loop    : Short_int;      entry   : Short_int;  (* entry in BI Buf header table *)           BEGIN (* COPY_BEFORE_IMAGE *)       WITH workhorse_data DO BEGIN         IF not log_before_images  (* Is before-image logging on? *)        THEN BEGIN             (* NO: return to caller.       *)           copy_before_image := false; (* no error *)   	         GOTO 99;  	          END;       !   copy_before_image := true;   (* Assume an error will occur. *)  !     "   FOR loop := one TO blocks DO BEGIN (* Do one block at a time. *)  "       IF get_next_BI_entry (entry, workhorse_data, error)            THEN GOTO 99;            WITH sys_stats.system_stats DO           bib_writes := bib_writes + one;            WITH Bifi_buf_ptr^.BI_table[entry] DO BEGIN            entry_type := bi_block;           file_type  := type_of_file;               files_name  := filename;            block_in_file := block_num + loop - one;            END; (* saving block location information. *)                WITH Bifi_buf_ptr^ DO BEGIN   #         IF move_words (data_ptr^[((loop-one) * words_in_disc_block)], # #                        bi_images[entry][zero],  (* Copy the block *)  # #                        words_in_disc_block,     (* into the buffer*)  #                         error)  
            THEN GOTO 99;  
              tbl_hdr.entries := entry;      #         BI_buf_state := dirty;   (* Before-image buffer modified. *)  #              END; (* with current_BI_buf *)           
      END; (* for loop *)  
        copy_before_image := false;  (* No error! *)           Intrinsic_in_progress := true; (* We have a before-image! *)        END; (* with workhorse_data *)      99:  (* error exit *)       END; (* function copy_before_image *)   $ Page $   (**************************************************************)    (*                                                            *)    (* Function COPY_REC_MAP_BLOCKS : Boolean;                    *)    (*                                                            *)    (*    Purpose: To make before-image copies of all data buffer *)    (* blocks pointed to by REC_MAP.  This routine should only    *)    (* be used to make before images of CONTIGUOUS blocks in      *)    (* the data buffer.  This is always the case, fortunately     *)    (* since the data buffering never allows a data record to     *)    (* be fragmented.                                             *)    (*                                                            *)    (* Inputs: None.                                              *)    (*                                                            *)    (* Outputs: None.                                             *)    (*                                                            *)    (* Global input: REC_MAP and REC_MAP_COUNT.                   *)    (*                                                            *)    (* Function Result: 'False' if no error, 'true' otherwise.    *)    (*                                                            *)    (* Possible errors: Disc failure and Corrupt structures.      *)    (*                                                            *)    (**************************************************************)       	$ Heapparms OFF $  	     FUNCTION Copy_rec_map_blocks   $ Alias 'DBW.CopyRecord' $      (VAR workhorse_data : workhorse_info_type;       VAR error          : Short_int) : Boolean;      
LABEL 99; (* error exit *) 
     VAR      data_ptr    : Data_record_ptr_type;     loop        : Short_int;      entry_index : Short_int;          set_index     : Short_int;      intrinsic_num : Short_int;          blk_num : Long_int;     Any_ptr : All_pointers_type;           BEGIN  (* copy_rec_map_blocks *)      WITH workhorse_data DO BEGIN      "   copy_rec_map_blocks := true;    (* Assume an error will occur. *) "        FOR loop := one TO rec_map_count DO BEGIN        entry_index := rec_map[loop].entry_ix;            IF (entry_index > -1) THEN BEGIN (* valid entry *)            WITH db_ptr^.data_buf_ID[entry_index] DO BEGIN           set_index     := owner_set;           intrinsic_num := last_intrin;           blk_num       := block_num;           END; (* with *)            IF (intrinsic_num <> current_intrinsic_num)            THEN BEGIN (* make copy of the block *)              any_ptr.data_buf := db_ptr;               any_ptr.value    := any_ptr.value +   "                                (entry_index * words_in_disc_block); "             data_ptr         := any_ptr.data_record;                  IF copy_before_image                   (data_ptr,                     one,  
                  blk_num, 
 
                  dataset, 
                   file_id_table_ptr^[set_index].dataset_desc,                     workhorse_data,                     error)                 THEN GOTO 99;                  WITH db_ptr^.data_buf_id[entry_index] DO BEGIN                 last_intrin := current_intrinsic_num;                 last_flush  := current_bib_flush_num;                 END; (* with *)                  END; (* then make copy of block *)               END; (* then entry is valid *)       
      END; (* for *) 
        copy_rec_map_blocks := false;  (* No error. *)       END; (* with workhorse_data *)      99:  (* error exit *)       END; (* Copy_rec_map_blocks. *)   $ Page $   (**************************************************************)    (*                                                            *)    (* Function BEFORE_IMAGE_FILE_CHECK : Boolean;                *)    (*                                                            *)    (*    Purpose: To determine how much room is remaining in     *)    (* the Before-image file and if that is enough for the        *)    (* current intrinsic.  This routine should be conservative    *)    (* in its calculations, erring on the side of caution.        *)    (* If there is not enough potential space remaining,          *)    (* a checkpoint is issued before returning to the caller.     *)    (*                                                            *)    (* Parameters:                                                *)    (*    (in)     (1) The intrinsic type to check for.           *)    (*    (in)     (2) Ptr to set which will be modified.         *)    (*    (in/out) (3) Workhorse data.                            *)    (*    (out)    (4) IMAGE error if one occurs.                 *)    (*                                                            *)    (* Function return:                                           *)    (*    'False' if no error occurs.                             *)    (*    'True ' if an error does occur.                         *)    (*                                                            *)    (* Possible errors:                                           *)    (*    Disc failure.                                           *)    (*    EMA mapping error.                                      *)    (*                                                            *)    (**************************************************************)       	$ Heapparms OFF $  	     FUNCTION Before_image_file_check  $ Alias 'DBW.CheckBifFull' $     (    intrinsic_code : Short_int;       VAR Dataset_ptr    : Global_dataset_ctl_table_ptr_type;       VAR workhorse_data : Workhorse_info_type;       VAR error          : Short_int) : Boolean;      
LABEL 99; (* error exit *) 
     CONST           max_blocks_for_master_media_record =  (* Length in blocks *)    #      (max_master_media_record_len + (2 * (words_in_disc_block - 1)))  #       DIV words_in_disc_block;              max_blocks_for_detail_media_record =  (* Length in blocks *)    #      (max_detail_media_record_len + (2 * (words_in_disc_block - 1)))  #       DIV words_in_disc_block;              max_blocks_for_any_dataset_record =   (* Length in blocks *)          (max_data_in_a_record + (2 * (words_in_disc_block - 1)))        DIV words_in_disc_block;              max_blocks_for_free_record_table =    (* Length in blocks *)    "      ((max_data_sets * bm_free_rec_len) + words_in_disc_block - 1)  "       DIV words_in_disc_block;              max_blocks_for_master_media_change =  (* Length in blocks *)          max_blocks_for_master_media_record +        max_blocks_for_free_record_table;           max_blocks_for_detail_media_change =  (* Length in blocks *)          max_blocks_for_detail_media_record +        max_blocks_for_free_record_table;           max_blocks_for_altering_automaster =  (* Length in blocks *)           ((max_master_media_record_len + max_words_in_item_value +    !        (2 * words_in_disc_block - 1)) DIV words_in_disc_block) +  !       max_blocks_for_free_record_table;           modification_overhead =               (* Length in blocks *)          (Root_header_len + words_in_disc_block - 1)         DIV words_in_disc_block;              max_blocks_for_altering_any_record =  (* Length in blocks *)          max_blocks_for_any_dataset_record +         max_blocks_for_free_record_table +        modification_overhead;              DBPUT_master_worst_case =             (* Length in blocks *)          max_blocks_for_master_media_change;           DBPUT_path_dependent_worst_case =     (* Length in blocks *)          (2 * max_blocks_for_detail_media_change) +          max_blocks_for_master_media_change +          max_blocks_for_altering_automaster;           Worst_DBPUT_BIF_blocks_needed =       (* Length in blocks *)          (max_paths * DBPUT_path_dependent_worst_case) +          max_blocks_for_altering_any_record;                  DBDEL_master_worst_case =             (* Length in blocks *)          (2 * max_blocks_for_master_media_change);           DBDEL_path_dependent_worst_case =     (* Length in blocks *)          (2 * (max_blocks_for_master_media_change +              max_blocks_for_detail_media_change)) +        max_blocks_for_altering_automaster;               Worst_DBDEL_BIF_blocks_needed =       (* Length in blocks *)          (max_paths * DBDEL_path_dependent_worst_case) +         max_blocks_for_altering_any_record +        modification_overhead;          DBUPD_before_image_blocks_needed = 0; (* Length in blocks *)           (**)      (* The path dependent worst cases are multiplied by the      (* number of paths in the detail record being added/deleted.       (* Other values are taken at face value.      (* The final number of blocks needed is the resulting value     (* from above added to max_blocks_for_altering_any_record.      (**)               max_DBPUT_file_space_needed =         (* Length in blocks *)          ((Worst_DBPUT_BIF_blocks_needed DIV   "         max_before_image_entries) + 1) * max_before_image_entries;  "             max_DBDEL_file_space_needed =         (* Length in blocks *)          ((Worst_DBDEL_BIF_blocks_needed DIV   "         max_before_image_entries) + 1) * max_before_image_entries;  "             max_DBUPD_file_space_needed =         (* Length in blocks *)          ((DBUPD_before_image_blocks_needed DIV  "         max_before_image_entries) + 1) * max_before_image_entries;  "            (**)      (* Current evaluations for the file space needed on the     (* HP-1000 are as follows:      (*      (* DBDEL:  558 blocks for the worst case.     (*      (* DBPUT:  465 blocks for worst case.     (*      (* DBUPD:  22 blocks for worst case.      (*      (**)          (**)      (* The algorithm implemented here is a very simple one to     (* reduce the amount of code needed.  This will give a   !   (* reasonable approximation of the worst case number of blocks  !    (* for an intrinsic, but will always err conservatively.      (* It assumes that all media records are the maximal size,      (* and that all data is maximal also.  The primary factor     (* in the needed number of blocks is the number of chain      (* paths.     (**)           VAR   "   paths   : Short_int;    (* Number of paths in record.         *)  " "   set_typ : Dataset_type; (* Whether master or detail.          *)  " "   Blocks  : Short_int;    (* Blocks of Before-image file needed.*)  "    remaining_blocks : Long_int;  (* Blocks left in BI file. *)         loop        : Short_int;          Bif_block_len : Long_int;          BEGIN (* before_image_file_check *)       WITH workhorse_data DO BEGIN         Before_image_file_check := true;       "   IF not log_before_images  (* Don't bother if BI logging is off *) "       THEN BEGIN           before_image_file_check := false; (* no error *)   	         GOTO 99;  	          END;          (**)      (* Increment the intrinsic counter and take care      (* of the short_int wraparound case.      (**)          current_intrinsic_num := current_intrinsic_num + one;     intrinsic_in_progress := false;             WITH dataset_ptr^ DO BEGIN         paths   := gdt.set_paths;         set_typ := gdt.set_type;        END;      
   CASE intrinsic_code OF  
           to_bm_del_code :           CASE set_typ OF              man_master :                 blocks := DBDEL_master_worst_case;       
            detail : 
 !               blocks := paths * DBDEL_path_dependent_worst_case;  !                 OTHERWISE BEGIN                  error := db_corrupt_err;                  GOTO 99;   
               END;  
              END; (* case of set_typ *)             to_bm_put_code :           CASE set_typ OF              man_master :                 blocks := DBPUT_master_worst_case;       
            detail : 
 !               blocks := paths * DBPUT_path_dependent_worst_case;  !                 OTHERWISE BEGIN                  error := db_corrupt_err;                  GOTO 99;   
               END;  
              END; (* case of set_typ *)             to_bm_upd_code :           blocks := max_dbupd_file_space_needed;                 OTHERWISE BEGIN (* incorrect intrinsic type. *)            error := db_corrupt_err;   	         GOTO 99;  	          END         END; (* case of intrinsic code *)         blocks := (((blocks + max_blocks_for_altering_any_record)                 DIV max_before_image_entries) +                one) * max_before_image_entries;         (**)      (* We now have the worst case number of blocks to perform     (* the particular PUT, DELETE or UPDATE.  Let's see how     (* many blocks there are in the file...     (**)      (* Free space = size of BIF -  "   (*              (used blocks + blocks in buffer + useless blocks) "    (**)          bif_block_len := before_image_file_id.fsize;          remaining_blocks := bif_block_len -                         ((BI_file_block - one) +                           Total_BI_buffer_blocks +  "                        (bif_block_len MOD Total_bi_buffer_blocks)); "            IF blocks >= remaining_blocks        THEN           IF Check_point (workhorse_data, error)   
            THEN GOTO 99;  
        before_image_file_check := false; (* no error *)       END; (* with workhorse_data *)      99:  (* error exit *)       END; (* before_image_file_check *)      $ Page $   (**************************************************************)    (*                                                            *)    (* Function COPY_FREE_RECORD_TABLE : Boolean;                 *)    (*                                                            *)    (*    Purpose: To copy the free record table in a run table   *)    (* from the run table buffer to the Before-image buffer.      *)    (* This routine should be called just prior to any changes    *)    (* to the free record table.  This routine will also set      *)    (* the bits in the header portion of the run table so that    *)    (* the caller need not worry about such things.               *)    (*                                                            *)    (*                                                            *)    (* Parameters:                                                *)    (*    (in)     (1) Database number.                           *)    (*    (in/out) (2) Workhorse information.                     *)    (*    (out)    (3) IMAGE error if one occurs.                 *)    (*                                                            *)    (* Function Result:                                           *)    (*    'False' if no error occurred.                           *)    (*    'True' if an error does occur.                          *)    (*                                                            *)    (**************************************************************)       	$ Heapparms OFF $  	     FUNCTION Copy_free_record_table  $ Alias 'DBW.CopyFRecTbl' $              (VAR dbase_num      : Short_int;               VAR workhorse_data : Workhorse_info_type;               VAR error          : Short_int) : Boolean;       
LABEL 99; (* error exit *) 
         VAR      rtbl_header_ptr : Rootfile_header_ptr_type;     free_rec_tbl_ptr: Data_record_ptr_type;     Block_length    : Short_int;      start_block     : Long_int;     Any_ptr         : All_pointers_type;           BEGIN  (* Copy_free_record_table *)       WITH workhorse_data DO BEGIN      !   Copy_free_record_table := true; (* Assume error will occur. *)  !        IF make_rt_header_ptr (dbase_num,                            rtbl_header_ptr,                            workhorse_data,                             error)  
      THEN GOTO 99;  
        any_ptr.rootfile_header := rtbl_header_ptr;  !   any_ptr.value := any_ptr.value + rtbl_header_ptr^.free_tbl_off; !    Free_rec_tbl_ptr := any_ptr.data_record;          WITH rtbl_header_ptr^ DO BEGIN          Block_length := (free_tbl_len + words_in_disc_block - one)                         DIV words_in_disc_block;        start_block  := free_tbl_block;         END; (* with *)          IF copy_before_image              (* Make a before-image *)           (free_rec_tbl_ptr,          (* of the free record  *)            block_length,              (* table for this run  *)            start_block,  
          rootfile,  
           opn_tbl_ptr^[dbase_num].root_file_name,   
          workhorse_data,  
           error)  
      THEN GOTO 99;  
     %   rtbl_header_ptr^.flags.FT := true;      (* Flush FRT at checkpoint. *)  %        copy_free_record_table := false;  (* No error! *)      END; (* with workhorse_data *)      99:  (* Error exit *)       END; (* Copy_free_record_table *)       $ Page $   (**************************************************************)    (*                                                            *)    (* Function MARK_END_OF_INTRINSIC : Boolean;                  *)    (*                                                            *)    (*    Purpose: To set a mark in the before-image file that    *)    (* the end of the intrinsic has been reached.  This informs   *)    (* the function UNDO_LAST_INTRINSIC when to stop.             *)    (*                                                            *)    (* Parameters:                                                *)    (*    (in/out) (1) Workhorse information.                     *)    (*    (out)    (2) IMAGE error if one occurs.                 *)    (*                                                            *)    (* Function Result: 'False' if no error, 'true' otherwise.    *)    (*                                                            *)    (* Possible errors: Corrupt data structures or disc failure.  *)    (*                                                            *)    (**************************************************************)       	$ Heapparms OFF $  	     FUNCTION Mark_end_of_intrinsic  $ Alias 'DBW.MarkEOIntrin' $     (VAR workhorse_data : Workhorse_info_type;       VAR error          : Short_int) : Boolean;      
LABEL 99; (* error exit *) 
     VAR      entry : Short_int;           BEGIN (* mark_end_of_intrinsic *)       WITH workhorse_data DO BEGIN         Mark_end_of_intrinsic := true;       #   IF NOT log_before_images (* Ignore request if BI logging is off *)  #       THEN BEGIN           mark_end_of_intrinsic := false;  	         GOTO 99;  	          END; (* then *)      !   IF get_next_BI_entry (entry,          (* Get next free entry *) ! !                         workhorse_data, (* in the BIB.         *) !                          error)   
      THEN GOTO 99;  
         !   WITH Bifi_buf_ptr^ DO BEGIN        (* Place the EOI mark in *)  ! !      tbl_hdr.entries := entry;       (* before-image buffer.  *)  !       WITH BI_table[entry] DO            entry_type := intrinsic_end;             END; (* with *)          Mark_end_of_intrinsic := false;  (* no error! *)       END; (* With workhorse_data *)      99:  (* error exit *)       END; (* function Mark_end_of_intrinsic. *)      $ Page $   (**************************************************************)    (*                                                            *)    (* Function  RECORD_MODIFIED;                                 *)    (*                                                            *)    (*   Purpose: To calculate checksums and place a timestamp    *)    (* in the data record after it has been modified by any of    *)    (* the DBDEL, DBPUT or DBUPD intrinsics.                      *)    (* Note: No before-image constructed by this procedure since  *)    (* the record is assumed to already have been modified.       *)    (* Before-images can be taken when the proper record is       *)    (* read (Hash_read or Read_dataset_record functions).         *)    (*                                                            *)    (* Record_modified also sets the st_dirty status for the      *)    (* appropriate disc blocks in the data buffer.                *)    (*                                                            *)    (*                                                            *)    (* Parameters:                                                *)    (*    (in)     (1) System database number.                    *)    (*    (in)     (2) Dataset number.                            *)    (*    (in)     (3) Record portions which changed.             *)    (*    (in)     (4) Ptr to media of changed record.            *)    (*    (in/out) (5) Workhorse information.                     *)    (*    (out)    (6) IMAGE error if an error occurs.            *)    (*                                                            *)    (* Function result:                                           *)    (*    'true' if an error occurs.                              *)    (*    'false' if no error occurs.                             *)    (*                                                            *)    (**************************************************************)       	$ Heapparms OFF $  	     FUNCTION record_modified   $ Alias 'DBW.RecModified' $     (VAR dbase_num     : Short_int;      VAR dataset_num   : Short_int;          changed_parts : Dataset_record_portions;      VAR media_ptr     : Master_media_record_ptr_type;       VAR workhorse_data: Workhorse_info_type;      VAR error         : Short_int) : Boolean;       
LABEL 99; (* error exit *) 
     CONST      trans_ID_and_checksum_word_len = 5;          VAR      first_word   : Short_int;     runtable_hdr : Rootfile_header_ptr_type;      dset_ptr     : Global_dataset_ctl_table_ptr_type;     path_ptr     : Global_dd_path_table_ptr_type;     frt_ptr      : Global_frt_entry_ptr_type;          BEGIN (* record_modified *)       WITH workhorse_data DO BEGIN         record_modified := true;  (* Assume an error will occur. *)             IF make_rt_header_ptr (dbase_num,                            runtable_hdr,                             workhorse_data,                             error)  
      THEN GOTO 99;  
        IF make_detail_pointers (dbase_num,                              dataset_num,                              dset_ptr,                               path_ptr,                               frt_ptr,                              workhorse_data,                               error)  
      THEN GOTO 99;  
            (**)   "   (* Now that we've made any alterations necessary to the run table "    (* header block, let's go ahead and change the media record     (* for the dataset record which has been altered.     (* The 'changed parts' indicator will tell us if the      (* media record, data record or both have been modified.   !   (* Note: A before-image of the record must have been made prior !    (* to calling this routine.     (*      (* Some steps in the process:     (* (1) Place the transaction ID in the media record.      (* (2) If the media record was altered, checksum it.      (* (3) If the data record was altered, checksum it.     (**)          WITH media_ptr^ DO BEGIN         IF (changed_parts <> data_record_only)            AND (runtable_hdr^.flags.CS)  
         THEN BEGIN  
 (**)  !(* The checksum routine was originally written for Fortran arrays, ! (* so the word offset begins with one.  (**)              media_checksum :=                  checksum (media_ptr^.trans_id,                            Trans_id_and_checksum_word_len + one,                           dset_ptr^.gdt.media_len);                  END; (* media checksum *)             IF (changed_parts <> media_record_only)             AND (runtable_hdr^.flags.CS)  
         THEN BEGIN  
                first_word := one + dset_ptr^.gdt.media_len;                      data_checksum :=                     checksum (media_ptr^.trans_id,                              first_word,   "                            first_word + dset_ptr^.data_len - one);  "                    END; (* then *)      	   END; (* with *) 	        record_modified := false; (* No error! *)      END; (* with workhorse_data *)      
99: (* error exit *) 
     
END;  (* function *) 
 .  