 $PASCAL ',7 92081-1X514 REV.2540' $       $ Include '[LBOPT'  $       PROGRAM data_buffering;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18514                                        *)  ! !(* RELOC:   92081-16514                                        *)  ! !(*                                                             *)  ! !(* PGMR:       <MRL>                                           *)  ! !(*                                                             *)  ! (* Date of last modification : <850819.1640>  !(*                                                             *)  ! !(***************************************************************)  !         $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)  $ Include '[BMCCT'  $    (* Workhorse constants and types. *)       $ Include '[XWPTS'  $    (* Run table pointer routines. *)  $ Include '[XWRTF'  $    (* Root file I/O routines. *)  $ Include '[XWBIF'  $    (* Before-image routines. *)   $ Include '[XWPDB'  $    (* Datablock posting routines. *)  $ Include '[XDFMP'  $    (* File Access and I/O *)  $ Include '[XWDDT'  $    (* EMA buffer Disc I/O *)  $ Include '[XDTDY'  $    (* timing routines *)  $ List ON $           	$ Heapparms OFF $  	     (**** Scan memory data block buffers for a record. ****)      FUNCTION scan_databuffers  $ Alias 'DBW.MapBuffers' $      ( VAR start_buffer : DB_ptr_type;       VAR num_blocks   : Short_int;       VAR start_block  : Long_int;        VAR set_index    : Short_int;       VAR some_found   : Boolean;       VAR Rec_map_count: Short_int;       VAR Rec_map      : Rec_map_type;        VAR best_buf_blk : short_int;       VAR error        : Short_int) : Boolean;      EXTERNAL;      (**** Checksum an arbitrary buffer of words. ****)      FUNCTION checksum  $ Alias 'EMA.CheckSum' $   $ Heapparms ON $              (VAR buffer     : short_int;  	$ Heapparms OFF $  	                  first_word : Short_int;                   last_word  : Short_int) : Short_int;      EXTERNAL;          $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* Function GET_DATASET_FILE_ID : Boolean;                           *)  $ $(*                                                                   *)  $ $(*    Purpose: To return the FILE ID for the specified dataset in    *)  $ $(* a given database.  Up to 50 datasets may be opened at one time,   *)  $ $(* and after that a circular rotation of the datasets is performed.  *)  $ $(*                                                                   *)  $ $(* Inputs:                                                           *)  $ $(*    (1) Database number.                                           *)  $ $(*    (2) Dataset number.                                            *)  $ $(*                                                                   *)  $ $(* Outputs:                                                          *)  $ $(*    (3) Index to the file id in the FILE_ID_and_NAME_equation_table*)  $ $(*        which is pointed to by FILE_ID_table_ptr.                  *)  $ $(*    (4) Workhorse information.                                     *)  $ $(*    (5) IMAGE error if an error occurs.                            *)  $ $(*                                                                   *)  $ $(*                                                                   *)  $ $(* Function result: 'False' if no error occurs, 'true' otherwise.    *)  $ $(*                                                                   *)  $ $(* Possible errors:                                                  *)  $ $(*    File open or close error.                                      *)  $ $(*    EMA mapping failure.                                           *)  $ $(*    Corrupt data structures.                                       *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     	$ Heapparms OFF $  	     FUNCTION get_dataset_file_ID   $ Alias 'DBW.FindSet' $     (VAR root_index     : Short_int;       VAR set_number     : Short_int;       VAR set_index      : Short_int;       VAR workhorse_data : Workhorse_info_type;       VAR error          : Short_int) : Boolean;          
LABEL 99; (* error exit *) 
     VAR      id_index    : Short_int;      empty_index : Short_int;      dset_ptr    : Global_dataset_ctl_table_ptr_type;      path_ptr    : Global_dd_path_table_ptr_type;      frt_ptr     : Global_frt_entry_ptr_type;       
   start_time  : long_int; 
         BEGIN (* get_dataset_file_id *)   WITH workhorse_data DO BEGIN      !   get_dataset_file_ID := true; (* Assume an error will occur. *)  !     "   empty_index := zero;         (* Assume no dataset slot is free *) "            FOR id_index := one TO max_set_file_identifiers DO      WITH file_id_table_ptr^[id_index] DO BEGIN   
     IF (status = st_free) 
         THEN IF (empty_index = zero)             THEN empty_index := id_index              ELSE (* do nothing *)          ELSE       (* See if database and dataset match *)             IF (database_num = root_index) AND                 (dataset_num = set_number)                THEN BEGIN  $                 set_index := id_index;  (* Match! Return the index. *)  $                  get_dataset_file_id := false;  $                 GOTO 99;                (* Return to caller.        *)  $                  END; (* then *)      	   END; (* with *) 	        (**)      (* If we get to this point, then the specified dataset was       (* not open.  We will check to see if there was a slot open,       (* but if not, then we will close an arbitrary dataset and      (* overwrite it with the given dataset.     (**)      (* We have to open the file, so let's find that system      (* dependent NAMR, (HP-1000), from the run table.     (* 'dset_ptr' will point to the dataset control block.      (**)          IF make_detail_pointers (root_index,                               set_number,                               dset_ptr,                               path_ptr,                               frt_ptr,                              workhorse_data,                               error)  
      THEN GOTO 99;  
        IF (empty_index = zero)   (* Any empty entry?       *)         THEN BEGIN             (* No: close 'next file'. *)            empty_index := next_file_to_close;            next_file_to_close := next_file_to_close + one;               IF (next_file_to_close > max_set_file_identifiers)               THEN next_file_to_close := one;                IF dataset_close (empty_index,                              workhorse_data,                             error)   
            THEN GOTO 99;  
              END; (* closing the dataset *)              (* Open the requested dataset. *)         temp_file_descriptor.newfl := dset_ptr^.set_name;         WITH FILE_ID_table_ptr^[empty_index] DO BEGIN            initialize_dcb_header (temp_file_descriptor);             WITH sys_stats.system_stats DO BEGIN           start_time := get_start_time;             IF force_type_one_file_open (temp_file_descriptor, error)             THEN GOTO 99;               file_open_time  :=                file_open_time + get_elapsed_time(start_time);            file_open_count := file_open_count + one;           END; (* with sys_stats.system_stats *)             file_id := temp_file_descriptor.dcb.dcb_header;             (* Put the correct information in the FILE ID table. *)             database_num := root_index;         dataset_num  := set_number;         status       := st_in_use;        dataset_desc := temp_file_descriptor.newfl;       	   END; (* with *) 	        set_index            := empty_index;  (* Give caller its *)     get_dataset_FILE_ID  := false;        (* parameters.     *)      99: (* error exit or return to caller. *)       END; (* with workhorse_data *)      END; (* get_dataset_file_id *)      $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* Function SCAN_DBUF : Boolean;                                     *)  $ $(*                                                                   *)  $ $(*                                                                   *)  $ $(* purpose: This procedure scans the data buffer (which consists     *)  $ $(*          of linked data buffer records, each record containing    *)  $ $(*          many blocks of data).  Its purpose is to determine       *)  $ $(*          if the 'num_blocks' of blocks whose address begins at    *)  $ $(*          'start_block' are in the data buffer.                    *)  $ $(*          The addresses for data buffer blocks are located in      *)  $ $(*          the table 'Data_buf_id'.                                 *)  $ $(*                                                                   *)  $ $(* Parameters :                                                      *)  $ $(*    (in)     (1) Index into open rootfile table.                   *)  $ $(*    (in)     (2) Dataset number in database.                       *)  $ $(*    (in)     (3) Starting block of record.                         *)  $ $(*    (in)     (4) Number of blocks record occupies.                 *)  $ $(*    (out)    (5) 'All' 'Some' or 'None' found flag.                *)  $ $(*    (in/out) (6) Workhorse data.                                   *)  $ $(*    (out)    (7) IMAGE error if one occurs.                        *)  $ $(*                                                                   *)  $ $(* Function result: 'False' if no error, 'true' otherwise.           *)  $ $(*                                                                   *)  $ $(*  called by: Read_dataset_record.                                  *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     	$ Heapparms OFF $  	     FUNCTION scan_dbuf   $ Alias 'DBW.ScanBuffer' $               (VAR root_index     : Short_int;               VAR dataset_num    : Short_int;                   start_block    : Long_int;                    num_blocks     : Short_int;               VAR record_status  : Block_status_types;                VAR set_index      : Short_int;               VAR best_fit_blk   : short_int;               VAR workhorse_data : Workhorse_info_type;               VAR error          : Short_int) : Boolean;       
LABEL 99; (* error exit *) 
     VAR   
   some         : Boolean; 
    blk_ix       : Short_int;     cur_blk      : Short_int;         start_time   : long_int;           BEGIN (* scan_dbuf *)       WITH workhorse_data DO BEGIN         (**)      (* Find the FILE ID for the dataset in question.      (* From that we will find the starting track and block.     (**)          scan_dbuf := true;  (* Assume an error will occur. *)      #   IF get_dataset_FILE_ID (root_index,     (* Get index of the set *)  # #                           dataset_num,    (* file ID info.        *)  #                            set_index,                              workhorse_data,                             error)   
      THEN GOTO 99;  
            (* Initialize REC_MAP *)      FOR blk_ix := one TO max_databuffer_blocks DO        rec_map[blk_ix].entry_ix := -1;       
   rec_map_count := zero;  
    start_time := get_start_time;      #   IF scan_databuffers (db_ptr,             (* Look through all of *)  # #                        num_blocks,         (* the data buffers in *)  # #                        start_block,        (* memory to see if the*)  # #                        set_index,          (* desired record is   *)  # #                        some,               (* there.              *)  # #                        rec_map_count,      (* Also finds best fit *)  # #                        rec_map[one],       (* area if any.        *)  #                         best_fit_blk,                           error)  
      THEN GOTO 99;  
        start_time := get_elapsed_time (start_time);       !   scan_dbuf := false;  (* No error can occur after this point *)  !        IF (NOT some) THEN WITH sys_stats.system_stats DO BEGIN        record_status := none_there;        cache_miss_cpu_time := cache_miss_cpu_time + start_time;        GOTO 99; (* return to caller. *)        END;             (**)      (* We know that some part of the record is in memory.     (* Let's see if the blocks are physically and logically     (* contiguous in memory.      (**)          WITH rec_map[one] DO         IF entry_ix = -1 THEN BEGIN            record_status := some_there;   	         GOTO 99;  	          END  !      ELSE cur_blk := entry_ix - one; (*get first cache index-1*)  !        record_status := all_there;  (* Assume the best case *)         FOR blk_ix := one TO num_blocks DO   !   (* If block isn't there or not contiguous then not all there *) ! 
   WITH rec_map[blk_ix] DO 
    IF entry_ix <> cur_blk+one         THEN WITH sys_stats.system_stats DO BEGIN            record_status := some_there;   !         cache_miss_cpu_time := cache_miss_cpu_time + start_time;  !          GOTO 99; (* Return to caller. *)            END (* then *)         ELSE  cur_blk := entry_ix;             (**)       (* At this point we know that the record is wholly in memory,      (* and that it is both logically and physically contiguous.     (**)          WITH sys_stats.system_stats DO BEGIN         cache_hit_cpu_time := cache_hit_cpu_time + start_time;        cache_hit_count := cache_hit_count + one;         END;      END; (* with workhorse_data *)      99: (* error exit or branching from a loop. *)      END;  (* scan_dbuf *)       $ Page $   (**************************************************************)    (*                                                            *)    (* Function READ_DATASET_RECORD : Boolean;                    *)    (*                                                            *)    (* Purpose: To read a specified record from a dataset file,   *)    (*   and optionally make a before-image copy of the record.   *)    (*   If the record is already in memory and in contiguous     *)    (*   blocks, (logically and physically), then the pointer     *)    (*   is calculated and returned.  If not wholly in memory,    *)    (*   or not physically adjacent, then the parts in memory     *)    (*   are invalidated and the entire record read in from       *)    (*   the disc.  There are many bonuses to having the record   *)    (*   physically and logically contiguous:                     *)    (*                                                            *)    (*     (A) Disc transfers can be made in one swoop.           *)    (*     (B) Single move-words/compare-words operations.        *)    (*     (C) For DBUPD, changing data need not be concerned     *)    (*         with over-running a block boundary.                *)    (*                                                            *)    (*   The drawback is if a record is entirely in memory        *)    (*   but is not contiguous, it will                           *)    (*   be erased and re-read in a contiguous chunk.  The odds   *)    (*   of this event occuring are small unless a person devotes *)    (*   a megabyte of memory for databuffers or has a very small *)    (*   data base.                                               *)    (*                                                            *)    (* Input params:                                              *)    (*   (1) System database number.                              *)    (*   (2) Dataset number.                                      *)    (*   (3) Record number to read.                               *)    (*   (4) Before-image copy indicator.                         *)    (*                                                            *)    (* Output params:                                             *)    (*   (5) Pointer to start of media record.                    *)    (*   (6) Workhorse data.                                      *)    (*   (7) IMAGE error if one occurs.                           *)    (*                                                            *)    (* Possible errors:                                           *)    (*   Disc read failure.                                       *)    (*   EMA mapping failure.                                     *)    (*                                                            *)    (*   IMPORTANT!!!!!!   NOTE!!!!!                              *)    (*   You cannot depend on any previous pointer into the       *)    (*   data buffer being correct after a call to this routine.  *)    (*   Only the pointer returned by THIS invocation is valid.   *)    (*   The data buffers could be totally and completely         *)    (*   rearranged.  If you read record x followed by record y,  *)    (*   you will have to re-read x in order to insure that it    *)    (*   is in the buffer.  Re-reading x leaves the integrity of  *)    (*   record y uncertain.                                      *)    (*                                                            *)    (*   In general, every time you need to look at or modify     *)    (*   a record, if it was not the last record you accessed,    *)    (*   you will have to re-read it.                             *)    (*   The whole reason for this is that only one data buffer   *)    (*   may even exist which may only be able to hold one record *)    (*   at a time.  Perhaps as an enhancement we could have      *)    (*   multiple buffers and memory-locking of records to insure *)    (*   that they do not disappear;  but not right now.          *)    (*                                                            *)    (**************************************************************)   	$ Heapparms OFF $  	     FUNCTION read_dataset_record  $ Alias 'DBW.ReadRecord' $     (VAR root_index     : Short_int;       VAR dataset_num    : Short_int;       VAR record_number  : Long_int;          copy_indicator : Copy_record_options;       VAR detail_ptr     : Detail_media_record_ptr_type;      VAR workhorse_data : Workhorse_info_type;       VAR error          : short_int) : Boolean;          
LABEL 99; (* error exit *) 
     CONST      trans_checksum_len = 2 +  (* trans ID *)                           1 +  (* unused word *)                          1 +  (* media checksum *)                           1;   (* data checksum *)      "   min_blocks = 4;  (* miniumum # of blocks to read in one access *) "         TYPE     block_in_memory_type = (no_block_yet,                             block_not_in_memory,                              block_is_in_memory);       VAR      word_offset : Short_int;   
   start_block : Long_int; 
    num_blocks  : Short_int;      block_index : Short_int;      set_index   : Short_int;          record_offset : Short_int;          rec_size    : Short_int;      record_status : Block_status_types;     start_word_in_buf : Short_int;          dbuf_id_index : Short_int;      dset_ptr    : Global_dataset_ctl_table_ptr_type;      path_ptr    : Global_dd_path_table_ptr_type;      frt_ptr     : Global_frt_entry_ptr_type;      root_hdr_ptr: Rootfile_header_ptr_type;         start_word  : Short_int;      end_word    : Short_int;      Any_ptr     : All_pointers_type;          save_rec_map_count : Short_int;         total_offset : short_int;     total_blocks : short_int;     word_in_dataset : long_int;         best_fit_blk : short_int;         rec_map_index : short_int;      partial_block : long_int;     increment     : short_int;          num_needed_blocks : short_int;      first_index       : short_int;      switch_count      : short_int;      save_index        : short_int;          continuous_partial : Boolean;     current_block      : block_in_memory_type;      need_to_reread     : Boolean;     start_index        : short_int;     last_index         : short_int;      
   start_time : long_int;  
 
   save_count : long_int;  
    beginning_index : short_int;       BEGIN (* read_dataset_record *)       WITH workhorse_data DO BEGIN      !   read_dataset_record := true;  (* Assume an error will occur. *) !        (**)      (* Our first job is to see if the record already exists in      (* memory.  Possible states are:   
   (*   (1) Not in memory. 
    (*   (2) Partially in memory.     (*   (3) Wholly in memory but not contiguous physically.      (*   (4) In memory and contiguous.      (*      (* For case 1, a disc read is performed.       (* For cases 2 and 3, the record is invalidated and re-read.       (* For case 4, the pointer info is returned.      (**)          IF make_detail_pointers (root_index,                               dataset_num,                              dset_ptr,                               path_ptr,                               frt_ptr,                              workhorse_data,                               error)  
      THEN GOTO 99;  
     !   IF (record_number <= zero) OR (record_number > frt_ptr^.setcp)  !       THEN BEGIN           error := DB_corrupt_err;   	         GOTO 99;  	          END; (* then *)          !   WITH dset_ptr^ DO                   (* Determine record size *) !       rec_size := gdt.media_len + data_len;          word_in_dataset := (record_number - one) * rec_size;       !   start_block := (word_in_dataset DIV words_in_disc_block) + one; !        word_offset := word_in_dataset MOD words_in_disc_block;         num_blocks  := ((word_offset + rec_size - one)                     DIV words_in_disc_block) + one;           #   IF scan_dbuf (root_index,          (* See if the record is in   *)  # #                 dataset_num,         (* memory, and if so, if it  *)  # #                 start_block,         (* is entirely in memory.    *)  # #                 num_blocks,          (* If not in memory, return  *)  # #                 record_status,       (* buffer where best fit is. *)  # #                 set_index,           (* (If there isn't a best    *)  # #                 best_fit_blk,        (*  fit, we will force it.)  *)  #                  workhorse_data,                   error)   
      THEN GOTO 99;  
        IF (record_status <> all_there) THEN BEGIN         (* Not all of record was in memory *)             IF read_ahead_flag THEN         IF ((frt_ptr^.setcp > record_number) AND            ((rec_size * 2) <= max_data_in_a_record)) THEN BEGIN               total_offset := word_offset + (2 * rec_size);           total_blocks := one +                ((total_offset - one) DIV words_in_disc_block);                IF (total_blocks < min_blocks) THEN              IF (dset_ptr^.file_size >=                   (start_block + min_blocks - one))                 THEN total_blocks := min_blocks;                IF (total_blocks > num_blocks) THEN BEGIN              num_blocks := total_blocks;                   IF scan_dbuf (root_index,                                dataset_num,                                start_block,                                num_blocks,                               record_status,                                set_index,                                best_fit_blk,                               workhorse_data,                               error)                   THEN GOTO 99;                   END; (* then scan for an extra record *)               END; (* then we can fetch an extra record *)             IF (record_status = some_there) THEN BEGIN                  (**)              (* See if the parts in memory are contiguous.               (* If the parts are contigous AND               (*    the missing parts are contiguous  #            (*    then if the missing parts are BEFORE the found parts #             (*       then if space exists in the before-area              (*          then  "            (*             post any dirty blocks in the before-area; "             (*             read in the before-parts.  #            (*          else invalidate the found partial and read the # !            (*               entire record elsewhere into memory.  !             (*       else if space exists in the after-area               (*          then  "            (*             post any dirty blocks in the after-area;  "             (*             read in the after-parts.   !            (*          else invalidate the found partial and read !             (*               the entire record elsewhere.   !            (*    else invalidate the entire record and read it in !             (*         elsewhere in memory.               (**)               rec_map_count      := num_blocks;           switch_count       := zero;           current_block      := no_block_yet;           continuous_partial := true;               FOR rec_map_index := one TO num_blocks DO           WITH rec_map[rec_map_index] DO   
         IF entry_ix = -1  
 "            THEN IF current_block <> block_not_in_memory THEN BEGIN  "                current_block := block_not_in_memory;                 num_needed_blocks := one;                 switch_count := switch_count + one;  	               END 	                 ELSE num_needed_blocks := num_needed_blocks + one   !            ELSE IF current_block <> block_is_in_memory THEN BEGIN !                current_block := block_is_in_memory;                  switch_count := switch_count + one;                 save_index := entry_ix;  	               END 	                ELSE IF save_index + one <> entry_ix                     THEN continuous_partial := false                    ELSE save_index := entry_ix;               need_to_reread := false;                WITH rec_map[one] DO            IF ((switch_count = 2) AND continuous_partial)   &            THEN IF entry_ix = -1 THEN BEGIN (* need prev blks from disc *)  &                start_index := one;                 last_index  := num_needed_blocks;                 save_index :=  "                         rec_map[num_needed_blocks + one].entry_ix;  "                IF (num_needed_blocks > save_index)                    THEN need_to_reread := true;                 first_index := save_index - num_needed_blocks;   	               END 	                 ELSE BEGIN (* need succeeding blocks from disc *)   $                  IF ((entry_ix + num_blocks) >= max_databuffer_blocks)  $                      THEN need_to_reread := true;                     first_index := entry_ix +   !                                 (num_blocks - num_needed_blocks); ! #                  start_index := num_blocks - num_needed_blocks + one; #                   last_index  := num_blocks;                    END                   ELSE need_to_reread := true;                   IF (NOT need_to_reread) THEN BEGIN   %            IF (rec_map[1].entry_ix <> -1) THEN BEGIN (* post succ blks *) %     %               beginning_index := rec_map[1].entry_ix; (* to rstr rcmp *)  %                    FOR rec_map_index := one TO                        (num_blocks - num_needed_blocks) DO                     rec_map[rec_map_index].entry_ix := -1;                     increment := zero;                      FOR rec_map_index :=                          (num_blocks - num_needed_blocks + one) TO                           num_blocks DO                    WITH rec_map[rec_map_index] DO BEGIN                       entry_ix := first_index + increment;                        increment := increment + one;  
                     END;  
                   partial_block := start_block + num_blocks -                                            num_needed_blocks;                  END (* then post succeeding blocks *)                 ELSE BEGIN  (* post blocks in before-area *)                     increment := zero;                        beginning_index := first_index;       !                  FOR rec_map_index := one TO num_needed_blocks DO !                   WITH rec_map[rec_map_index] DO BEGIN                       entry_ix := first_index + increment;                        increment := increment + one;                       END; (* for with *)      !                  FOR rec_map_index := num_needed_blocks + one TO  !                                        num_blocks DO                       rec_map[rec_map_index].entry_ix := -1;                         partial_block := start_block;                     END; (* else *)                   (**)              (* Rec_map is altered to post the proper area               (* to be overlaid.  Call Post_rec_map_blocks,               (* Then read the needed disc blocks, then               (* re-set the rec_map to the proper values.               (**)                  WITH sys_stats.system_stats DO BEGIN                 save_count := cache_io_count;                     IF post_rec_map_blocks (workhorse_data,                                         error)                     THEN GOTO 99;                      IF (save_count = cache_io_count)                     THEN miss_clean_reads := miss_clean_reads+1                     ELSE miss_dirty_reads := miss_dirty_reads+1;                 END; (* with *)      "            start_word_in_buf := first_index * words_in_disc_block;  "                 start_time := get_start_time;                   IF do_disc_transfer                          (read_from_device_code,                          file_id_table_ptr^[set_index].file_id,                          partial_block,                          num_needed_blocks,                          db_ptr^.data_buf[start_word_in_buf],                          workhorse_data,                           error)                 THEN GOTO 99;                  WITH sys_stats.system_stats DO BEGIN                 cache_elapsed_io := cache_elapsed_io +                                get_elapsed_time (start_time);                  cache_io_count := cache_io_count + one;                 END; (* with *)      !            FOR block_index := start_index TO last_index DO BEGIN  !                dbuf_id_index := rec_map[block_index].entry_ix;                  WITH db_ptr^.data_buf_id[dbuf_id_index] DO BEGIN                       block_num := start_block + block_index - one;                      owner_set := set_index;                     last_intrin := zero;                    END; (* with *)                  END; (* for *)                   mark_blocks (st_in_use, workhorse_data);      #            (* Fix the rec_map to point to all blocks of the record *) #             FOR block_index := beginning_index TO                                   beginning_index+num_blocks-one DO                   rec_map[block_index-beginning_index+one].entry_ix   $                                                        := block_index;  $     #            END; (* then we don't have to re-read the whole record *)  #              END (* some blocks are there *)           ELSE (* no blocks are there *)               need_to_reread := true;                 IF (need_to_reread) THEN BEGIN               save_count := sys_stats.system_stats.cache_io_count;       $         IF (record_status = some_there) (* remove remnants from mem *)  $ "            THEN IF invalidate_rec_map_blocks (workhorse_data,error) "                THEN GOTO 99;                   (* Read the record into memory. *)                IF (best_fit_blk = -1) THEN BEGIN  "            IF (max_databuffer_blocks - next_db_entry) < num_blocks  " !               THEN next_db_entry := zero; (* cycle the buffer *)  !                  best_fit_blk := next_db_entry;                next_db_entry := next_db_entry + num_blocks;                END; (* then there was no best fit *)                   (**)   "         (* We are now about to read in the record, but there may be " !         (* information in the databuffer we are about to overlay. ! !         (* If any of that data is dirty, the before-image buffer  !          (* will need to be flushed, and then the dirty data.            (* POST_REC_MAP performs both of these functions.           (**)                FOR block_index := best_fit_blk TO                                (best_fit_blk + num_blocks - one) DO   $            rec_map[block_index-best_fit_blk+1].entry_ix := block_index; $              rec_map_count := num_blocks;                IF post_rec_map_blocks (workhorse_data, error)   
            THEN GOTO 99;  
              WITH sys_stats.system_stats DO               IF (save_count = cache_io_count)                 THEN miss_clean_reads := miss_clean_reads + one                  ELSE miss_dirty_reads := miss_dirty_reads + one;                 (* Now we can perform the read safely. *)      !         start_word_in_buf := best_fit_blk * words_in_disc_block;  !              start_time := get_start_time;               IF Do_disc_transfer                 (read_from_device_code,                  FILE_ID_table_ptr^[set_index].FILE_ID,                  start_block,                  num_blocks,                   db_ptr^.data_buf[start_word_in_buf],                  workhorse_data,                   error)  
            THEN GOTO 99;  
              WITH sys_stats.system_stats DO BEGIN               cache_elapsed_io := cache_elapsed_io +                                  get_elapsed_time (start_time);              cache_io_count := cache_io_count + one;               END;               (**)            (* We have just read a record!!!   "         (* Place disc addr identification in the data_buf_id entry. "          (* Mark all of the blocks as being in_use.            (**)                FOR block_index := one TO num_blocks DO BEGIN              dbuf_id_index := rec_map[block_index].entry_ix;                   WITH db_ptr^.data_buf_ID[dbuf_id_index] DO BEGIN                 block_num   := start_block + block_index - one;                 owner_set   := set_index;                 last_intrin := zero;               END; (* with *)                END; (* for *)                rec_map_count := num_blocks;            mark_blocks (st_in_use, workhorse_data);                (**)            (* Now to calculate and return some necessary info            (* about where the record resides in memory.            (**)                    END; (* then need to read the record from disc *)            END; (* record is not all in memory *)         (**)      (* Make a before-image copy of the record if necessary.     (* Assume that before-imaged blocks will be modified:     (* Change the in-use status to dirty.     (**)       "   record_offset := (rec_map[one].entry_ix * words_in_disc_block) +  "                     word_offset;         IF (copy_indicator = copy_record) THEN BEGIN         mark_blocks (st_dirty, workhorse_data);         db_ptr^.dirty_flag := true;             IF copy_rec_map_blocks (workhorse_data, error)           THEN GOTO 99;        END; (* then *)          IF (copy_indicator = copy_media) THEN BEGIN        save_rec_map_count := rec_map_count;        rec_map_count :=               ((record_offset MOD words_in_disc_block) + 127 +                  dset_ptr^.gdt.media_len) DIV words_in_disc_block;              mark_blocks (st_dirty, workhorse_data);         db_ptr^.dirty_flag := true;             IF copy_rec_map_blocks (workhorse_data, error)           THEN GOTO 99;        rec_map_count := save_rec_map_count;        END;         Any_ptr.data_buf := db_ptr;     Any_ptr.value    := any_ptr.value + record_offset;      detail_ptr       := any_ptr.detail_media_record;          IF make_rt_header_ptr (root_index,                             root_hdr_ptr,                             workhorse_data,                             error)  
      THEN GOTO 99;  
        (**)      (* If checksumming is on, be sure that the record read      (* from disc is checksummed correctly.  This gives      (* immediate knowledge of a corrupt database to the user.     (**)       $   IF root_hdr_ptr^.flags.CS THEN BEGIN   (* If checksumming is on... *) $       start_word := trans_checksum_len + one;         end_word   := dset_ptr^.gdt.media_len;            IF (detail_ptr^.media_checksum <>                  checksum (db_ptr^.data_buf[record_offset],                            start_word,                           end_word) )  
         THEN BEGIN  
             error := DB_Corrupt_err;  
            GOTO 99; 
             END;  (* THEN *)                start_word := end_word + one;         end_word   := end_word + dset_ptr^.data_len;            IF (detail_ptr^.data_checksum <>                 checksum (db_ptr^.data_buf[record_offset],                            start_word,                           end_word) )  
         THEN BEGIN  
             error := data_corrupt_err;  
            GOTO 99; 
             END; (* THEN *)             END;  (* THEN *)         read_dataset_record := false; (* No error occurred! *)       END; (* with workhorse_data *)      99:  (* error exit *)       END; (* read_dataset_record. *)   .  