 $PASCAL ',7 92081-1X522 REV.2540'$      !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18522                                        *)  ! !(* RELOC:   92081-16522                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified: <850416.1428>  !(*                                                             *)  ! !(***************************************************************)  !     $ Include '[LBOPT'  $       PROGRAM check_duplicate_dcb;      $ List OFF, Include '[IMAGE' , List ON $    $ List OFF, Include '[BMCCT' , List ON $         (**************************************************************)    (*                   EXTERNAL DEFINITIONS                     *)    (**************************************************************)       $ List OFF, Include '[XDFMP' , List ON $        $ Page $   (**************************************************************)    (*                                                            *)    (* Function CHECK_DUPLICATE_DCB : Boolean;                    *)    (*                                                            *)    (* Purpose:                                                   *)    (*    Given a currently open dcb, to compare it with all      *)    (*    other open dcb's to see if the same file is open twice. *)    (*                                                            *)    (*    The new file system keeps an 'open flag' each time the  *)    (*    file is opened, even if by the same program.  The old   *)    (*    file system keeps only one entry flag for DBMON despite *)    (*    the number of times it is opened.                       *)    (*                                                            *)    (*               This means DBMON could open the same file    *)    (*    twice and only have to close it once.  This is          *)    (*    considered by many to be a feature.  However, you       *)    (*    must KNOW that the file is really only open once to     *)    (*    take advantage of this.                                 *)    (*                                                            *)    (*    Now the clincher:  Suppose you open a file which is     *)    (*    already open to you but you don't know it?  (Let's      *)    (*    say that we are opening a given "rootfile" in DBOPN,    *)    (*    and we are trying to figure out if it is already        *)    (*    opened as a rootfile, when actually the "rootfile"      *)    (*    is a dataset, mistakenly given by the caller, and       *)    (*    it just so happens that the dataset is open to DBMON... *)    (*                                                            *)    (*    Well, D.RTR says to itself, "Hmmm, DBMON already has    *)    (*    that file open, so I won't bother to allocate another   *)    (*    open flag, but I will give him a new DCB!"  DBMON       *)    (*    then figures out that the "rootfile" really isn't,      *)    (*    closes the file (which clears away the one open flag,   *)    (*    making the file appear to be totally closed, but DBMON  *)    (*    has a dataset DCB which looks like the file is still    *)    (*    open...)                                                *)    (*                                                            *)    (*    So: We currently then have the original dataset dcb     *)    (*    which appears to be open, the "rootfile" dcb which      *)    (*    has been closed, and the file directory table which     *)    (*    says the file is really closed.  FMP, however, only     *)    (*    checks the directory when allocating extents, or        *)    (*    opening/closing files;  otherwise the DCB is believed   *)    (*    to be correct.  It is therefore possible for the file   *)    (*    which DBMON and FMP believes to be open (but isn't)     *)    (*    to be moved or opened by some other program, and        *)    (*    the area of the disc where the file used to be can      *)    (*    get trashed.  (The least horrible possibility is that   *)    (*    two programs will simply not have coordinated access    *)    (*    to the file since neither will know about the other).   *)    (*                                                            *)    (*    Which finally brings us to the algorithm employed by    *)    (*    this routine:  All known root and data set files will be*)    (*    compared by this program against an input file          *)    (*    descriptor.  An indicator to tell if the dcb is a       *)    (*    duplicate will be returned, and if a duplicate,         *)    (*    the type of the file (root, dataset),                   *)    (*          will be returned.                                 *)    (*                                    The index into the      *)    (*    appropriate table is returned so that DBMON can make    *)    (*    some intelligent decisions about what to do.            *)    (*                                                            *)    (*    For the new file system, close the duplicate DCB.       *)    (*    For the old file system, do not close the duplicate.    *)    (*                                                            *)    (* Parameters:                                                *)    (*    (in)     (1) File descriptor to be compared.            *)    (*    (out)    (2) Boolean 'dcb is duplicate' indicator.      *)    (*    (out)    (3) IMAGE-file type.                           *)    (*    (out)    (4) Array index of twin, if applicable.        *)    (*    (in/out) (5) Workhorse data.                            *)    (*    (out)    (6) IMAGE error if an error occurs.            *)    (*                                                            *)    (* Function result:                                           *)    (*    Boolean 'True' if an error occurs, 'false' otherwise.   *)    (*                                                            *)    (**************************************************************)       	$ Heapparms OFF $  	     FUNCTION check_duplicate_dcb   $ Alias 'DBW.DuplicateDCB' $      (VAR file_descrip   : file_descriptor;       VAR twin_found     : Boolean;       VAR twin_type      : IMAGE_file_types;      VAR twin_index     : Short_int;       VAR workhorse_data : Workhorse_info_type;       VAR error          : Short_int) : Boolean;      LABEL      99; (* return and error exit *)          VAR      loop        : Short_int;           BEGIN  (* check_duplicate_dcb *)      WITH workhorse_data DO BEGIN      !   Check_duplicate_dcb := true;   (* Assume an error will occur *) !        twin_found := false;          (**)      (* First, see if the DCB matches any open rootfile.     (**)          FOR loop := one TO max_image_db DO      WITH opn_tbl_ptr^[loop] DO      IF open_count > zero         THEN IF (file_descrip.newfl = root_file_name)            THEN BEGIN (* found a match! *)              twin_found := true;               twin_type  := rootfile;               twin_index := loop;               check_duplicate_dcb := false;  (* no error *)   
            GOTO 99; 
             END; (* then a match was found *)              (**)      (* Check the dataset tables for a duplicate.      (**)          FOR loop := one TO max_set_file_identifiers DO      WITH file_id_table_ptr^[loop] DO      IF status <> st_free THEN        IF (file_descrip.newfl = dataset_desc) THEN BEGIN            twin_found := true;           twin_type  := dataset;            twin_index := loop;           check_duplicate_dcb := false;  (* no error *)  	         GOTO 99;  	          END; (* then a match was found *)         (**)      (* That's all the DCB's I care about.     (* If necessary, check for the warning log file, the TLF      (* the roll forward log file, and any other dcb     (* that is a DBMON-dependent dcb.     (**)          check_duplicate_dcb := false;  (* no error occurred *)       99:  (* termination or error exit *)      END; (* with workhorse_data *)      END; (* check duplicate dcb *)  .  