$PASCAL ',7 92081-1X516 REV.2440' $     
$ Include '[LBOPT'  $ 
     PROGRAM data_buffer_posting;      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18516                                        *)   (* RELOC:   92081-16516                                        *)   (*                                                             *)   (* PGMR:        <MRL>                                          *)   (*                                                             *)   (***************************************************************)       $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *) $ Include '[QA'  $       (* QA definitions *)  $ Include '[BMCCT'  $    (* Workhorse constants and types *)      $ Include '[XWBIF'  $    (* Before-image routine externals. *)  $ Include '[XDFMP'  $    (* File accessing routines *)  $ Include '[XWDDT'  $    (* EMA disc I/O routines *)  $ Include '[XBQA'   $    (* QA external *)  $ Include '[XDTDY'  $    (* timing routines *) $ List ON $      $ Page $ #(*********************************************************************) ##(*                                                                   *) ##(*  Procedure MARK_BLOCKS;                                           *) ##(*                                                                   *) ##(*  purpose: This procedure marks the data buffer blocks as          *) ##(*           indicated in the structure 'rec_map'. These blocks      *) ##(*           are marked to indicate that they are 'status'           *) ##(*                                                                   *) ##(* Parameters:                                                       *) # $(*    (in)     (1) New status for data blocks.                       *)  $ $(*    (in/out) (2) Workhorse information.                            *)  $ $(*                                                                   *)  $ $(*  called by: read_dataset_record.                                  *)  $ $(*             Invalidate_rec_map_blocks.                            *)  $#(*                                                                   *) ##(*********************************************************************) #    $ Heapparms OFF $      PROCEDURE mark_blocks   $ Alias 'DBW.MarkBlocks' $     (    status         : Status_types;      VAR workhorse_data : Workhorse_info_type);         VAR    i : Short_int;          BEGIN  (* mark blocks *)      WITH workhorse_data DO BEGIN        FOR i := one TO rec_map_count DO 
   WITH rec_map[i] DO 
    IF (entry_ix <> -1)        THEN db_ptr^.data_buf_id[entry_ix].status := status;      END; (* with workhorse_data *)      END; (* mark_blocks *)      $ Page $  !(***************************************************************)  ! !(*                                                             *)  ! !(* Function POST_REC_MAP_BLOCKS : Boolean;                     *)  ! !(*                                                             *)  ! !(*    Purpose: To take the data blocks pointed to by the       *)  ! !(* REC_MAP structure and post the dirty blocks to disc AFTER   *)  ! !(* flushing the before-images to disc (to avoid losing the     *)  ! !(* before-image when the database has already been altered).   *)  ! !(*                                                             *)  ! !(* Parameters:                                                 *)  ! !(*    (in/out) (1) Workhorse information.                      *)  ! !(*    (out)    (2) IMAGE error if an error occurs.             *)  ! !(*                                                             *)  ! !(* Function result: 'False' if no error, 'true' otherwise.     *)  ! !(*                                                             *)  ! !(* Possible errors: Disc failure, Corrupt data structures.     *)  ! !(*                                                             *)  ! !(***************************************************************)  !     	$ Heapparms OFF $  	     FUNCTION post_rec_map_blocks  $ Alias 'DBW.PostRecord' $    (VAR workhorse_data : Workhorse_info_type;      VAR error          : Short_int) : Boolean;      
LABEL 99; (* error exit *) 
    VAR    ix1,ix2 : Short_int;     (* data buffer indices *)    i_ix    : Short_int;     (* rec_map index       *)    save_ix : Short_int;  
   still_consec : boolean; 
        num_blocks   : Short_int; 
   first_block  : Long_int; 
    entry_index  : Short_int;     db_ix        : Short_int;         word         : Short_int;     set_number   : Short_int;  
   flushed      : boolean; 
 
   need_to_flush: boolean; 

   start_time   : long_int; 
         BEGIN  (* post_rec_map_blocks *)      WITH workhorse_data DO BEGIN          post_rec_map_blocks := true; (* Assume an error will occur *)          flushed := false;  (* Before-images not flushed yet. *)        i_ix := one;    WHILE (i_ix <= rec_map_count) DO BEGIN         need_to_flush := false;  (* Don't need to flush BIB yet *)             still_consec := false;            num_blocks := one;  (* If not dirty, check next block *)            entry_index := rec_map[i_ix].entry_ix;            IF (entry_index <> -1) THEN BEGIN (* block is there *)     $         IF db_ptr^.data_buf_ID[entry_index].status = st_dirty THEN BEGIN $        (* dirty block - get as many logically contiguous blocks as *)      (* there are physically contiguous (within the buffer) to   *)      (* this one.  This is done to save potential writes.        *)                  still_consec := true;             db_ix := entry_index;             save_ix := db_ix;                  WITH db_ptr^.data_buf_id[db_ix] DO BEGIN                 set_number  := owner_set;                 first_block := block_num;                status := st_in_use;                 IF (last_flush = current_bib_flush_num)                   THEN need_to_flush := true;                 END; (* with *)                 db_ix := db_ix + one;                   WHILE (still_consec) AND (db_ix <= last_db_block) DO               WITH db_ptr^.data_buf_id[db_ix] DO BEGIN                IF (last_flush >= current_bib_flush_num)                   THEN need_to_flush := true;                    IF (status <> st_free)                    THEN IF (db_ptr^.data_buf_id[db_ix-1].owner_set   !                                                      = owner_set) !
                        AND 
"                        (db_ptr^.data_buf_id[db_ix-1].block_num + one " !                                                      = block_num) !                     THEN BEGIN                          status := st_in_use;                         db_ix := db_ix + one;                          END (* then *)                      ELSE still_consec := false                       ELSE still_consec := false;                     END; (* while with *)                     (* calculate the info needed for the write *)                  num_blocks := db_ix - save_ix;              word := save_ix * words_in_disc_block;              db_ix := rec_map[i_ix].entry_ix;                     (* Post before-images if necessary *)             IF ((NOT flushed) AND (need_to_flush)) THEN BEGIN                 IF flush_bi_buf (workhorse_data, error)                   THEN GOTO 99;                flushed := true; 	               END; 	                start_time := get_start_time;                 IF do_disc_transfer                          (write_to_device_code,                            file_id_table_ptr^[set_number].file_id,  (* Post a contiguous *)  first_block,  (* block of data to  *)  num_blocks,  (* disc.             *)  db_ptr^.data_buf[word],                           workhorse_data,                          error)                 THEN GOTO 99;                  WITH sys_stats.system_stats DO BEGIN                cache_elapsed_io := cache_elapsed_io +                                     get_elapsed_time (start_time);                  cache_io_count := cache_io_count + one; 	               END; 	                 END;   (* if dirty blocks *)               END; (* if a block is there. *)            i_ix := i_ix + num_blocks;  (* Skip to next block *)     
      END; (* while loop *) 
    
   (* USED FOR QA ONLY!! *) 
    IF qa_crash_code = qa_post THEN       terminate_program (terminate_code);         post_rec_map_blocks := false; (* no error! *)      END; (* with workhorse_data *)      
99: (* error exit *) 
     END;  (* function post_rec_map_blocks *)      $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(*  FUNCTION  post_data_blocks : Boolean;                            *)  $ $(*                                                                   *)  $ $(*    Purpose: To post all dirty blocks in all data buffers.         *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (in/out) (1) Workhorse information.                            *)  $ $(*    (out)    (2) IMAGE error if one occurs.                        *)  $ $(*                                                                   *)  $ $(* Function Result: 'False' if no error, 'true' otherwise.           *)  $ $(*                                                                   *)  $ $(*  called by (1) check_point.                                       *)  $ $(*  calls:    (1) post_rec_map_blocks.                               *)  $#(*                                                                   *) ##(*********************************************************************) #    $ Heapparms OFF $      FUNCTION post_data_blocks  $ Alias 'DBW.PostRecords' $    (VAR workhorse_data : Workhorse_info_type;     VAR error          : Short_int) :  Boolean;      
LABEL 99; (* error exit *) 
    VAR 	   ix  : Short_int; 	        save_count: long_int;          BEGIN (* Post_data_blocks *)      WITH workhorse_data DO BEGIN        post_data_blocks := true; (* Assume an error will occur *)         FOR ix := one TO max_databuffer_blocks DO       rec_map[ix].entry_ix := ix - one;            save_count := sys_stats.system_stats.cache_io_count;        IF db_ptr^.dirty_flag THEN BEGIN           rec_map_count := max_databuffer_blocks;            IF post_rec_map_blocks (workhorse_data, error)           THEN GOTO 99;            db_ptr^.dirty_flag := false; 
      END; (* then *) 
       WITH sys_stats.system_stats DO        non_miss_io_count := non_miss_io_count +                            (cache_io_count - save_count);         post_data_blocks := false;  (* No error! *)      END; (* with workhorse_data *)      
99: (* error exit *) 
    END;  (* function post_data_blocks *)      $ Page $   (**************************************************************)    (*                                                            *)    (* Function INVALIDATE_REC_MAP_BLOCKS : Boolean;              *)    (*                                                            *)    (*    Purpose: To insure that a group of blocks in the        *)    (* REC_MAP structure are made 'invalid' since they would      *)    (* be duplicating information which is about to be read in    *)    (* from the disc.  Blocks are made invalid by setting their   *)    (* status to 'st_free'.                                       *)    (*                                                            *)    (* Parameters:                                                *)    (*    (in/out) (1) Workhorse information.                     *)    (*    (out)    (2) IMAGE error if an error occurs.            *)    (*                                                            *)    (* Function result: 'False' if no error, 'true' otherwise.    *)    (*                                                            *)    (* Possible errors: Corrupt data structures or                *)    (*                  Disc failure.                             *)    (*                                                            *)    (**************************************************************)       	$ Heapparms OFF $  	     FUNCTION Invalidate_rec_map_blocks  $ Alias 'DBW.FreeBlocks' $     (VAR workhorse_data : workhorse_info_type;       VAR error          : Short_int) : Boolean;      
LABEL 99; (* error exit *) 
     BEGIN  (* invalidate_rec_map_blocks *)      "   invalidate_rec_map_blocks := true; (* Assume error will occur *)  "        (**)       (* The process of invalidation is to post any dirty blocks to      (* the database(s) and then mark the buffer blocks as free.     (**)          IF post_rec_map_blocks (workhorse_data, error)   
      THEN GOTO 99;  
        mark_blocks (st_free, workhorse_data);          invalidate_rec_map_blocks := false;  (* No error! *)       
99: (* error exit *) 
     END; (* invalidate_rec_map_blocks *)      $ Page $   (**************************************************************)    (*                                                            *)    (* Function DATASET_CLOSE : Boolean;                          *)    (*                                                            *)    (* Purpose:                                                   *)    (*    To post all data blocks belonging to the specified      *)    (*    dataset, mark them free, then close the dataset.        *)    (*                                                            *)    (* Parameters:                                                *)    (*    (in)     (1) Index into open set tbl of set to close.   *)    (*    (in/out) (2) Workhorse information.                     *)    (*    (out)    (3) IMAGE error if an error occurs.            *)    (*                                                            *)    (* Function result:                                           *)    (*    'False' if no error occurs, 'true' otherwise.           *)    (*                                                            *)    (* Possible errors:                                           *)    (*    Corrupt database, disc failure or FMP close error.      *)    (*                                                            *)    (**************************************************************)      $ Heapparms OFF $     FUNCTION dataset_close   $ Alias 'DBW.CloseDataSet' $    (VAR set_index      : Short_int;     VAR workhorse_data : Workhorse_info_type;      VAR error          : Short_int) : Boolean;      
LABEL 99; (* error exit *) 
    VAR    blk_index : Short_int;    same_set  : Boolean;        close_time : long_int;    save_count : long_int;         BEGIN (* Dataset_close *)      WITH workhorse_data DO BEGIN        dataset_close := true;  (* Assume an error will occur *)        (**)    (* Post and invalidate all blocks belonging to     (* the dataset we are about to close.    (**)     
   blk_index := zero; 
        WHILE blk_index <= last_db_block DO    WITH db_ptr^.data_buf_ID[blk_index] DO       IF (owner_set = set_index) THEN BEGIN               rec_map_count := one;           rec_map[one].entry_ix := blk_index;               blk_index := blk_index + one;  
         same_set := true; 
             WHILE (blk_index <= last_db_block) AND (same_set) DO           IF (owner_set = set_index) THEN BEGIN      #     (* Collect as many adjacent blocks of the same set as possible *) #                rec_map_count := rec_map_count + one;             rec_map[rec_map_count].entry_ix := blk_index;             blk_index := blk_index + one;  
            END (* then *) 
             ELSE                same_set := false;              WITH sys_stats.system_stats DO BEGIN             save_count := cache_io_count;                  IF invalidate_rec_map_blocks                       (workhorse_data, error)                 THEN GOTO 99;                  non_miss_io_count := non_miss_io_count +                                  (cache_io_count - save_count);     
            END; (* with *) 
             END (* then *)               ELSE (* owner_set <> empty_index *)             blk_index := blk_index + one;        (**)     (* Now that the datablocks belonging to the dataset are     (* posted and erased, we can close the dataset.    (**)        temp_file_descriptor.dcb.dcb_header :=          file_id_table_ptr^[set_index].file_id;        (**)     (* Take statistics on close time.    (**)         close_time := get_start_time;         IF close_file          (temp_file_descriptor,            error) 	      THEN GOTO 99; 	       WITH sys_stats.system_stats DO BEGIN        file_close_time :=           file_close_time + get_elapsed_time(close_time);       file_close_count := file_close_count + one;        END;        dataset_close := false;  (* No error. *)      END; (* with workhorse_data *)     
99:  (* error exit *) 
     END; (* dataset_close *)  .  