 $PASCAL ',7 92081-1X511 REV.5010' $       $ Include '[LBOPT'  $       PROGRAM workhorse_put_operation;      !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18511                                        *)  ! !(* RELOC:   92081-16511                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified : <881118.1552>   !(*                                                             *)  ! !(* Fixed bug where improper detail chain info was being        *)  ! !(* returned by using variables other than those returned       *)  ! !(* from common_put_routine.  <MRL> Dec 4, 1985.                *)  ! !(*                                                             *)  ! !(* Bug fix, Sept. 15, 1986: The add_master_record routine      *)  ! !(*    worked incorrectly for the recovery programs, which      *)  ! !(*    specify an absolute record number for a redo-put         *)  ! !(*    operation.  If a record number was specified, the algo-  *)  ! !(*    rithm always made the new record the tail of any existing*)  ! !(*    synonym chain;  however, in the case where the primary   *)  ! !(*    location is empty, but synonyms exist, the new record    *)  ! !(*    really ought to become HEAD of the chain, not the tail,  *)  ! !(*    and worse, the hash bucket value was set to point to     *)  ! !(*    its own record, thus making the synonyms into orphans    *)  ! !(*    which could not be accessed through hashing.             *)  ! !(*                                                             *)  ! !(*    Other kinds of corruptions occurred after several        *)  ! !(*    recoveries: a hash bucket pointer into the free list,    *)  ! !(*    and a circular list in the free list, since the          *)  ! !(*    put/delete routines are 'trusting' about pointers,       *)  ! !(*    and don't really check the record they are reading       *)  ! !(*    to make sure it is empty/in-use as it ought to be. <MRL> *)  ! !(*                                                             *)  ! !(***************************************************************)  !         $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)      $ Include '[BMCCT'  $    (* Workhorse constants and types.*)      $ Include '[QA'     $    (* IMAGE QA constants *)       $ Include '[XWBUF'  $    (* Data buffering routines. *)   $ Include '[XWHRD'  $    (* Hash read external *)   $ Include '[XWBIF'  $    (* Before-images routines.  *)   $ Include '[XWPTS'  $    (* Runtable pointer routines. *)   $ Include '[XWPDB'  $    (* Post data buffers routines. *)  $ Include '[XWRTF'  $    (* Post run tables routines. *)  $ Include '[XWULI'  $    (* Undo last intrinsic ext. *)   $ Include '[XBQA'   $    (* QA external *)  $ List ON $       (**** move words ****)      FUNCTION move_words          $ Alias 'EMA.MoveWords' $  $ Heapparms ON $        (VAR source_buf   : short_int;         VAR dest_buf     : short_int;  	$ Heapparms OFF $  	            num_of_words : short_int;         VAR error        : Short_int) : Boolean;      EXTERNAL;          (**** compare two buffers of words ****)      FUNCTION cmp_bytes $ Alias 'EMA.BytesCompare' $   $ Heapparms ON $     (VAR buffer1 : short_int;      VAR buffer2 : short_int;  	$ Heapparms OFF $  	         number_of_words  : short_int) : short_int; EXTERNAL;          $ Page $   (**************************************************************)    (*                                                            *)    (* Function ADDED_RECORD : Boolean;                           *)    (*                                                            *)    (*    Purpose:  To update the Free record table entry for a   *)    (* dataset which has just had a record added to it.           *)    (*                                                            *)    (* Inputs:                                                    *)    (*    (1) Database number.                                    *)    (*    (2) Dataset number.                                     *)    (*    (3) Record number where record was added.               *)    (*                                                            *)    (*                                                            *)    (**************************************************************)       	$ Heapparms OFF $  	     FUNCTION Added_record   $ Alias 'DBW.AddedRecord' $      (VAR dsfrt_ptr       : global_frt_entry_ptr_type;      VAR record_number   : Long_int;       VAR next_record     : Long_int;       VAR error_code      : Short_int) : Boolean;       
LABEL 99; (* error exit *) 
     
BEGIN  (* added_record *)  
        added_record := true;   (* Assume an error will occur. *)         WITH dsfrt_ptr^ DO BEGIN   "      count := pred(count);       (* Always decrement free count. *) "     !      IF (record_number = chain)    (* If the record added was  *) ! !         THEN                       (* the first free record on *) ! !            chain := next_record;   (* the chain, get the next  *) ! !                                    (* free record.             *) !     !      IF (leof < record_number)      (* Update the logical EOF  *) ! !         THEN leof := record_number; (* when necessary.         *) !           END; (* with *)          added_record := false; (* No error! *)       99:  (* error exit *)       END; (* Function Added_record. *)       $ Page $  (**************************************************)  (*                                                *)  (* Function CREATE_MASTER_RECORD: Boolean;        *)  (*                                                *)  (* Purpose:                                       *)  (*    Given a database, dataset, record number    *)  (*    and data for a master record, this routine  *)  (*    will add the data to the master data set.   *)  (*    (Either a specific or zero record number    *)  (*     can be given.  Specific record numbers     *)  (*     are used by UNDO/REDO subroutines while    *)  (*    normal DBPUT calls put the record in the    *)  (*    most convenient place.                      *)  (*                                                *)  (* Parameters:                                    *)  (* (in)  (1) Database index number.               *)  (* (in)  (2) Data set number.                     *)  (* (in/out)(3) Record number to place data in.    *)  (* (in)  (4) Pointer to data to add.              *)  (* (out) (5) Synonym count.                       *)  (* (out) (6) Previous record in synonym chain.    *)  (* (in/out)(7) Workhorse information.             *)  (* (out) (8) IMAGE error number if error occurs.  *)  (*                                                *)  (* Note:                                          *)  (*    Parameter 3, the record number, is zero if  *)  (*    the caller does not care where the record   *)  (*    is placed.  When a convenient record is     *)  (*    found, the record number is returned in     *)  (*    the 3rd parameter.                          *)  (*                                                *)  (*   Function result:                             *)  (*       'false' if everything went OK,           *)  (*       'true' if an error occurred.             *)  (*                                                *)  (**************************************************)      	$ Heapparms OFF $  	     FUNCTION Create_master_record   $ Alias 'DBW.MakeMstrRec' $      (VAR root_index         : short_int;       VAR dataset_num        : short_int;       VAR record_number      : Long_int;      VAR ptr_to_data_record : Data_record_ptr_type;      VAR chain_length       : Long_int;      VAR prev_record        : Long_int;      VAR workhorse_data     : Workhorse_info_type;       VAR error_code         : Short_int)    : Boolean;       
Label 99; (* error exit *) 
         VAR      master_dataset_rec_ptr : master_media_record_ptr_type;      new_data_rec_ptr   : Data_record_ptr_type;   !   next_free_rec      : Long_int;  (* Next free rec from master *) ! !   prev_rec           : Long_int;  (* Prev record in free list. *) ! !   next_rec           : Long_int;  (* Next record in free list. *) !        md_tbl_ptr         : Global_dataset_ctl_table_ptr_type;     md_pth_ptr         : Global_md_path_table_ptr_type;     md_inf_ptr         : Global_md_info_ptr_type;     md_frt_ptr         : Global_frt_entry_ptr_type;         record_found           : Boolean;     hash_bucket_record     : Long_int;      hash_bucket_free_indic : Boolean;     Head_of_synonym_chain  : Long_int;      Tail_of_synonym_chain  : Long_int;          prev_free_record_num   : Long_int;      next_free_record_num   : Long_int;      add_record             : Long_int;      next_record            : Long_int;          key_val_ptr : Data_record_ptr_type;     unused_rec_num : Long_int;      data_record_len : Short_int;      any_ptr : All_pointers_type;          dummy_mst_ptr : master_media_record_ptr_type;          BEGIN  (* create_master_record *)          (**)      (* Add a master record to the set 'dataset_num'.      (**)       "   Create_master_record := true;  (* Assume a failure will occur. *) "        IF make_master_pointers (root_index,                               dataset_num,                              md_tbl_ptr,                               md_pth_ptr,                               md_inf_ptr,                               md_frt_ptr,                               workhorse_data,                               error_code)   
       THEN GOTO 99; 
        data_record_len := md_tbl_ptr^.data_len;       "   IF (md_frt_ptr^.count <= zero)   (* If there is no free record *) " "      THEN BEGIN                    (* then return an error.      *) "          error_code := master_set_full_err;   	         GOTO 99;  	          END;          Any_ptr.data_record := ptr_to_data_record;      Any_ptr.value := any_ptr.value +   $                    (md_inf_ptr^.key_start - md_tbl_ptr^.gdt.media_len); $    Key_val_ptr := any_ptr.data_record;         (**)      (* Do a hashed read of the key value to determine *)      (* if an entry exists for it in the dataset.      *)      (**)          IF Hash_read (root_index,                   dataset_num,                    key_val_ptr,                    do_not_copy,      (*returned*)  unused_rec_num,                   record_found,                   hash_bucket_record,                   hash_bucket_free_indic,                   head_of_synonym_chain,                    tail_of_synonym_chain,                    chain_length,                   next_free_record_num,                   dummy_mst_ptr,                    workhorse_data,                   error_code)  
      THEN GOTO 99;  
     	   IF record_found 	       THEN BEGIN           error_code := key_already_in_manual_set_err;   	         GOTO 99;  	          END;       !   (* record_number is 0 for DBMON, or positive for DBRBR/DBRFR *) !    add_record := record_number;          IF (add_record = hash_bucket_record) OR        ((add_record = 0) AND hash_bucket_free_indic) THEN BEGIN      #      (* This record is a primary, or becomes head of a syn. chain *)  # 
      prev_record := zero; 
       add_record  := hash_bucket_record;        next_record := head_of_synonym_chain;         END          ELSE BEGIN (* Place as tail of an existing syn. chain *)             prev_record := tail_of_synonym_chain;         IF add_record = 0            THEN add_record := next_free_record_num;   
      next_record := zero; 
       WITH workhorse_data.sys_stats.system_stats DO            hash_collisions := hash_collisions + one;        END; (* else *)           !   IF prev_record > zero      (* Need to modifiy a prev record? *) ! !      THEN BEGIN              (*   Yes...                       *) !              (* Read the previous synonym record into memory. *)               IF read_master_record (root_index,                                   dataset_num,                                  prev_record,                                  copy_media,                                   master_dataset_rec_ptr,                                   workhorse_data,                                   error_code)                  THEN GOTO 99;                   master_dataset_rec_ptr^.forward_ptr := add_record;                IF master_record_modified (root_index,                                       dataset_num,  (* Set the timestamp and *)         media_record_only,  (* checksum info in the  *)         master_dataset_rec_ptr,   (* media record.         *)         workhorse_data,                                       error_code)   
            THEN GOTO 99;  
              END; (* then *)         (**)      (* Next, change backward pointer in the     (* succeeding master synonym, if it exists.     (**)       #   IF next_record > zero   (* Is there a next record on the chain? *)  #       THEN BEGIN           (*   Yes...  *)           IF read_master_record (root_index,                                   dataset_num,                                  next_record,                                  copy_media,                                   master_dataset_rec_ptr,                                   workhorse_data,                                   error_code)   
            THEN GOTO 99;  
                  master_dataset_rec_ptr^.backward_ptr := add_record;      !         (* Recalculate checksums and add timestamp to record. *)  !          IF master_record_modified (root_index,                                       dataset_num,                                      media_record_only,                                      master_dataset_rec_ptr,                                       workhorse_data,                                       error_code)   
            THEN GOTO 99;  
              END; (* updating succeeding record in chain. *)         (**)      (* Now to actually create the new master record.      (* All we need to do is READ the new record loc,      (* Initialize the media record, and finally put     (* the data into the proper place.      (**)       "   IF Read_master_record (root_index,         (* Read the record *)  " "                          dataset_num,        (* to contain the  *)  " "                          add_record,         (* new master data.*)  "                           do_not_copy,                            master_dataset_rec_ptr,                             workhorse_data,                             error_code)   
      THEN GOTO 99;  
        IF master_dataset_rec_ptr^.entry_type <> empty         THEN BEGIN           error_code := db_corrupt_err;  	         GOTO 99;  	          END;          (**)      (* The first chore to perform is removing the new record      (* from the linked list of free master records.     (* This involves reading the previous and next records      (* in the chain and modifying their next and previous     (* record pointers (respectively) to point to each      (* other instead of the record being created.     (**)       "   WITH master_dataset_rec_ptr^ DO  (* Save record numbers of the *) " "   BEGIN                            (* previous and next free     *) " "      prev_rec := backward_ptr;     (* records in the master free *) " "      next_rec := forward_ptr;      (* record chain.              *) "    END;          IF (prev_rec > zero)         THEN BEGIN           IF read_master_record (root_index,                                   dataset_num,  (* Read previous free rec. *)   prev_rec,                                   copy_media,                                   master_dataset_rec_ptr,                                   workhorse_data,                                   error_code)   
            THEN GOTO 99;  
                  master_dataset_rec_ptr^.forward_ptr := next_rec;                IF master_record_modified (root_index,                                       dataset_num,                                      media_record_only,                                      master_dataset_rec_ptr,                                       workhorse_data,                                       error_code)   
            THEN GOTO 99;  
                  END; (* if prev_rec > zero *)             IF (next_rec > zero)         THEN BEGIN           IF read_master_record (root_index,                                   dataset_num,  (* Read next free rec. *)       next_rec,                                   copy_media,                                   master_dataset_rec_ptr,                                   workhorse_data,                                   error_code)   
            THEN GOTO 99;  
                  master_dataset_rec_ptr^.backward_ptr := prev_rec;               IF master_record_modified (root_index,                                       dataset_num,                                      media_record_only,                                      master_dataset_rec_ptr,                                       workhorse_data,                                       error_code)   
            THEN GOTO 99;  
              END; (* if next_rec > zero *)             (**)      (* Re-read the record where the master is to be added.      (**)           "   IF Read_master_record (root_index,         (* Read the record *)  " "                          dataset_num,        (* to contain the  *)  " "                          add_record,         (* new master data.*)  "                           copy_record,                            master_dataset_rec_ptr,                             workhorse_data,                             error_code)   
      THEN GOTO 99;  
        (**)      (* Begin by modifying the media record portion.     (**)          WITH master_dataset_rec_ptr^ DO     BEGIN            entry_type := in_use;       "      IF (hash_bucket_record = add_record)  (* Does rec=hash bkt? *) " "         THEN hash_bucket := add_record;    (* Yes, then point it *) " "                                            (* to itself.         *) "     "      next_free_rec := forward_ptr; (* Save next free rec in set. *) "     !      backward_ptr := prev_record;  (* Point to any synonyms in *) ! !                                    (* the master synonym chain.*) !       forward_ptr  := next_record;         END;          (**)      (* The dataset chain pointers are already all zeroes.     (* Next, place the data into the record.      (**)          IF make_master_pointers (root_index,                               dataset_num,                              md_tbl_ptr,                               md_pth_ptr,                               md_inf_ptr,                               md_frt_ptr,                               workhorse_data,                               error_code)   
      THEN GOTO 99;  
        any_ptr.master_media_record := master_dataset_rec_ptr;      any_ptr.value := any_ptr.value + md_tbl_ptr^.gdt.media_len;     new_data_rec_ptr := any_ptr.data_record;          IF move_words           (ptr_to_data_record^[zero],   (* Move the data to *)             new_data_rec_ptr^[zero],     (* the added record.*)   
          data_record_len, 
           error_code)   
       THEN GOTO 99; 
        IF master_record_modified (root_index,                                 dataset_num,                                media_and_data,                                 master_dataset_rec_ptr,                                 workhorse_data,                                 error_code)   
      THEN GOTO 99;  
        (**)      (* The record has been added.     (* Update the free record table accordingly.      (**)          IF added_record (md_frt_ptr,                       add_record,                       next_free_rec,                      error_code)   
      THEN GOTO 99;  
        IF (add_record <> hash_bucket_record) AND  
      (prev_record = zero) 
 "      THEN BEGIN  (* This record was the first of its hash value *)  " "                  (* but the hash bucket record was not empty.   *)  " "                  (* The hash bucket in the hash bucket record   *)  " "                  (* must be pointed to add_record.              *)  "              IF read_master_record (root_index,                                   dataset_num,                                  hash_bucket_record,                                   copy_media,                                   master_dataset_rec_ptr,                                   workhorse_data,                                   error_code)   
            THEN GOTO 99;  
                  master_dataset_rec_ptr^.hash_bucket := add_record;                IF master_record_modified (root_index,                                       dataset_num,                                      media_record_only,                                      master_dataset_rec_ptr,                                       workhorse_data,                                       error_code)   
            THEN GOTO 99;  
           END; (* of modifying hash bucket value. *)             (**)      (* Master record PUT is complete!     (* Set function result to 'false'.      (**)       "   record_number := add_record;  (* Tell caller where record is. *)  "        Create_master_record := false;       99: (* error return *)      END; (* create_master_record *)       $ Page $   (**************************************************************)    (*                                                            *)    (* Function GET_KEY_VAL_PTR : Boolean;                        *)    (*                                                            *)    (*    Purpose: Given a data portion of a data set record, to  *)    (* find the Nth key item value's location in the data record  *)    (* buffer and create a pointer for the key item.              *)    (*                                                            *)    (* Inputs:                                                    *)    (*    (1) Database number.                                    *)    (*    (2) Dataset number of the detail dataset.               *)    (*    (3) Path number to find a key for.                      *)    (*    (4) Pointer to the data record buffer.                  *)    (*                                                            *)    (* Outputs:                                                   *)    (*    (5) Pointer to the key value.                           *)    (*    (6) Workhorse data.                                     *)    (*    (7) IMAGE error code if an error occurs.                *)    (*                                                            *)    (* Function Result:                                           *)    (*    'False' if no error occurs.                             *)    (*    'True' if an error does occur.                          *)    (*                                                            *)    (* Possible errors:                                           *)    (*    Disc failure.                                           *)    (*    Corrupt data structures.                                *)    (*                                                            *)    (**************************************************************)       	$ Heapparms OFF $  	     FUNCTION Get_key_val_ptr   $ Alias 'DBW.GetKeyPtr' $     (VAR Database_number : Short_int;      VAR Dataset_number  : Short_int;          Path_number     : Short_int;      VAR Data_rec_ptr    : Data_record_ptr_type;       VAR Key_value_ptr   : Data_record_ptr_type;       VAR workhorse_data  : workhorse_info_type;      VAR error_code      : short_int) : Boolean;       
LABEL 99; (* error exit *) 
     VAR      detail_set_ptr : Global_dataset_ctl_table_ptr_type;     detail_pth_ptr : Global_dd_path_table_ptr_type;     detail_frt_ptr : Global_frt_entry_ptr_type;     Any_ptr        : All_pointers_type;          BEGIN  (* get_key_val_ptr *)         Get_key_val_ptr := true;   (* Assume error will occur. *)      "   IF make_detail_pointers (database_number,   (* Get pointer to *)  " "                            dataset_number,    (* the path table *)  " "                            detail_set_ptr,    (* for the detail *)  " "                            detail_pth_ptr,    (* dataset.       *)  "                             detail_frt_ptr,                               workhorse_data,                               error_code)   
      THEN GOTO 99;  
        any_ptr.data_record := data_rec_ptr;      any_ptr.value := any_ptr.value +                       (detail_pth_ptr^[path_number].key_begin -                          detail_set_ptr^.gdt.media_len);     key_value_ptr := any_ptr.data_record;         get_key_val_ptr := false;  (* No error! *)       
99: (* error exit *) 
     END; (* function get_key_val_ptr *)       $ Page $  (**********************************************************)  (*                                                        *)  (* FUNCTION common_put_routine : Boolean;                 *)  (*                                                        *)  (* Purpose:                                               *)  (*    This routine is the 'database put workhorse';       *)  (*    It performs the physical database PUT to            *)  (*    either a master or detail data set.                 *)  (*    Before-image checks are performed by this           *)  (*    subroutine.                                         *)  (*                                                        *)  (* Parameters:                                            *)  (*    (in)  (1) Database root file index.                 *)  (*    (in)  (2) Dataset number.                           *)  (*(in/out)  (3) Record Number where record is put.        *)  (*    (in)  (4) Data to be Put.                           *)  (*    (out) (5) Count of records in (last) chain.         *)  (*    (out) (6) Record number of predecessor in chain.    *)  (*    (out) (7) Record number of successor in chain.      *)  (*(in/out)  (8) Workhorse data.                           *)  (*    (out) (9) Data set # for certain errors.            *)  (*    (out)(10) IMAGE error code if an error occurs.      *)  (*                                                        *)  (* Function Result:                                       *)  (*    'True' if an error occurs, 'False' otherwise.       *)  (*                                                        *)  (* Errors:                                                *)  (*   106 : No empty record in dataset.                    *)  (*   107 : No master entry for detail key value.          *)  (*   110 : Key value alreay exists.                       *)  (*    -1 : disc error.                                    *)  (*                                                        *)  (* NOTE!!!!!                                              *)  (*    When predicate locks are introduced, (or whenever   *)  (* two users may be modifying the same data set in        *)  (* concurrent transactions), Common_Put_routine will have *)  (* to change  to find the first free record NOT OWNED by  *)  (* a currently active transaction.  Ownership of a record *)  (* is determined by comparing the transaction ID in the   *)  (* record with the active transaction table. (???)        *)  (*                                                        *)  (**********************************************************)      	$ Heapparms OFF $  	     FUNCTION common_put_routine   $ Alias 'DBW.PutRecord' $               (VAR db_index       : Short_int;               VAR set_number     : Short_int;               VAR rec_number     : Long_int;                VAR data_rec_ptr   : Data_record_ptr_type;                VAR chain_length   : Long_int;                VAR pred_rec       : Long_int;                VAR next_rec       : Long_int;                VAR workhorse_data : Workhorse_info_type;               VAR bad_set        : short_int;               VAR error_code     : Short_int)   : Boolean;       
LABEL 99; (* error exit *) 
         VAR      data_record_len      : short_int;  (* Data len to add.   *)     key_val_ptr          : Data_record_ptr_type;       !   record_found         : Boolean;    (* 'Was a record found?' *)  ! "   hash_bucket_rec      : Long_int;   (* Rec num of hash bucket. *)  " "   hash_bucket_free     : Boolean;    (* 'Is hash bucket empty?' *)  "     !   synonym_head_rec     : Long_int;   (* Head of synonym chain. *) ! !   synonym_tail_rec     : Long_int;   (* Tail of synonym chain. *) ! !   nxt_free_rec         : Long_int;   (* Next empty rec in set. *) !     #   add_record           : Long_int;   (* Rec where data will be PUT*)  # "   master_set_num       : short_int;  (* Set no. of a master set. *) "        master_rec_ptr       : Master_media_record_ptr_type;   #   master_chains        : short_int;  (* No. of paths in a master. *)  #    chain                : short_int;  (* A loop variable. *)      "   free_detail_record   : Long_int;   (* Rec no. for detail PUT. *)  " "   num_of_paths         : short_int;  (* No. of detail paths.    *)  " "   path                 : short_int;  (* Loop variable for paths. *) " "   detail_key_num       : short_int;  (* Key item no. of master. *)  "     #   master_chain         : short_int;  (* Specific chain in master. *)  # !   chain_head           : Long_int;   (* Head of detail chain. *)  ! !   chain_tail           : Long_int;   (* Tail of detail chain. *)  !        sort_item            : short_int;  (* Sort item number. *)      itm_ptr              : Global_item_table_entry_ptr_type;   !   sort_scan_done       : Boolean;    (* 'Has rec been sorted?' *) ! "   buf_start_wrd        : short_int;  (* 1st sort item wd in buf. *) "        sort_ptr1            : Ptr_any_standard_type;     sort_ptr2            : Ptr_any_standard_type;     detl_rec_ptr         : Detail_media_record_ptr_type;   "   detail_paths         : ARRAY [1..max_paths] OF Detail_chain_info; "        dst_rec_ptr          : Detail_media_record_ptr_type;      data_buf_ptr         : Data_record_ptr_type;          mst_set_ptr          : Global_dataset_ctl_table_ptr_type;     mst_path_ptr         : Global_md_path_table_ptr_type;     mst_info_ptr         : Global_md_info_ptr_type;     mst_frt_ptr          : Global_frt_entry_ptr_type;     save_error           : Short_int;         root_hdr_ptr         : Rootfile_header_ptr_type;      set_entry_ptr        : Global_dataset_ctl_table_ptr_type;     dpath_entry_ptr      : Global_dd_path_entry_ptr_type;     dpath_ptr            : Global_dd_path_table_ptr_type;     frtbl_ptr            : Global_frt_entry_ptr_type;         prev_free_rec_pointer: Long_int;      next_free_rec_pointer: Long_int;      any_ptr              : All_pointers_type;         dummy_mst_ptr        : master_media_record_ptr_type;           BEGIN   (* common_put_routine *)          common_put_routine := true;  (* assume an error will occur *)       !   bad_set := zero;  (* If master is full or missing key entry *)  !        (**)      (* Make pointers to necessary data set information.     (**)          IF make_master_pointers (db_index,                               set_number,                               mst_set_ptr,                              mst_path_ptr,                               mst_info_ptr,                               mst_frt_ptr,                              workhorse_data,                               error_code)   
      THEN GOTO 99;  
            data_record_len := mst_set_ptr^.data_len;                     (**)      (* Make a copy of the free record table.      (**)          IF copy_free_record_table (db_index,                                 workhorse_data,                                 error_code)   
      THEN GOTO 99;  
        (* used for internal QA only - not executed normally *)     IF workhorse_data.qa_crash_code = qa_put THEN        terminate_program (terminate_code);              (**)      (* Enough room exists for before-images!      (* Let's perform the PUT intrinsic!     (**)           $   CASE mst_set_ptr^.gdt.set_type OF      (* separate manual master  *)  $ $                                          (* and detail dataset PUTs *)  $ 	      man_master : 	              BEGIN                  IF Create_master_record (db_index,                                       set_number,                                       rec_number,                                       data_rec_ptr,                                       chain_length,                                       pred_rec,                                       workhorse_data,                                       error_code)                 THEN GOTO 99;               END; (* create manual master record *)                 detail :   (* Add a detail record *)               BEGIN                  IF make_rt_header_ptr (db_index,                                     root_hdr_ptr,                                     workhorse_data,                                     error_code)                 THEN GOTO 99;                  IF make_detail_pointers (db_index,                                       set_number,                                       set_entry_ptr,                                        dpath_ptr,                                        frtbl_ptr,                                        workhorse_data,                                       error_code)                 THEN GOTO 99;                       IF frtbl_ptr^.count <= zero  (* Any empty record *)                    THEN BEGIN                (* in detail set?   *)                      error_code := detail_set_full_err;                     GOTO 99;               (* No: error = 105. *)                      END;                  IF rec_number = zero                 THEN free_detail_record := frtbl_ptr^.chain                 ELSE free_detail_record := rec_number;                       num_of_paths := set_entry_ptr^.gdt.set_paths;                   FOR path := one TO num_of_paths DO BEGIN                 Any_ptr.rootfile_header := root_hdr_ptr;                  Any_ptr.value := any_ptr.value +                                   set_entry_ptr^.info_off +                                   ((path-one)*bm_detl_len);                   dpath_entry_ptr := any_ptr.global_dd_path_entry;                       WITH dpath_entry_ptr^.gdt DO BEGIN                     detail_key_num := related_key;                    master_set_num := related_set;                    END; (* with *)                      IF make_master_pointers (db_index,                                           master_set_num,                                           mst_set_ptr,                                          mst_path_ptr,                                           mst_info_ptr,                                           mst_frt_ptr,                                          workhorse_data,                                           error_code)                     THEN GOTO 99;                      IF get_key_val_ptr (db_index,                                     set_number,                                     path,                                     data_rec_ptr,                                     key_val_ptr,                                      workhorse_data,                                     error_code)                    THEN GOTO 99;                      IF Hash_read (db_index,                               master_set_num,                               key_val_ptr,                                do_not_copy,                                rec_number,                               record_found,                               hash_bucket_rec,                                hash_bucket_free,                               synonym_head_rec,                               synonym_tail_rec,                               chain_length,                               nxt_free_rec,                               dummy_mst_ptr,                                workhorse_data,                               error_code)                    THEN GOTO 99;                      IF not record_found                    THEN BEGIN                       IF mst_set_ptr^.gdt.set_type = man_master                          THEN BEGIN                              error_code := no_master_for_key_err;                               bad_set := master_set_num;                              GOTO 99;                              END                          ELSE BEGIN (* Create auto-master *)                              rec_number := zero;      (* Put the automaster *)   IF Create_master_record  (* record anywhere in *)        (db_index,  (* the data set.      *)         master_set_num,                                   rec_number,                                   key_val_ptr,                                    chain_length,                                   pred_rec,                                   workhorse_data,                                   error_code)                                THEN BEGIN                                   bad_set := master_set_num;                                    GOTO 99;                                    END;                                      END; (* creation of auto-master. *)                        END; (* if record not found *)                     IF read_master_record (db_index,                                         master_set_num,                                         rec_number,                                         do_not_copy,                                        master_rec_ptr,                                         workhorse_data,                                         error_code)                     THEN GOTO 99;                      master_chains := mst_set_ptr^.gdt.set_paths;                      master_chain := zero; (* set chain # to zero *)                     FOR chain := one TO master_chains DO                  WITH mst_path_ptr^[chain] DO                  IF ((related_set = set_number) AND                      (related_key = detail_key_num))                        THEN BEGIN                      chain_head :=   "                       master_rec_ptr^.chains[chain].head_of_chain;  "                     chain_tail :=   "                       master_rec_ptr^.chains[chain].tail_of_chain;  "                     chain_length  :=  "                       master_rec_ptr^.chains[chain].recs_in_chain;  "                         master_chain := chain;                          END; (* acquiring chain data *)                      IF (master_chain = zero) THEN BEGIN                    error_code := db_corrupt_err;   
                  GOTO 99; 
                   END;      
               (**)  
 	               (*  	                 (* At this point we have either found the master                   (* record with the key item, or we have created                  (* such an entry for an automatic master dataset.   	               (*  	                (* The record number of the master entry is in                  (* rec_number.  We want to increment the chain                  (* length and modify the chain pointers in the                  (* automatic master record if necessary.  The                 (* worst part is if the detail chain is sorted,  !               (* since that will cause a large amount of reading  !                 (* to determine the record's place in the chain.    	               (*  	 
               (**)  
     
               (**)  
                (* Step one: Where does the detail record                 (*           belong on this chain?   
               (**)  
                    sort_item := dpath_entry_ptr^.sort_num;                     IF sort_item > zero (* If chain is sorted? *)  !                  THEN BEGIN       (* then find right position. *) !                      IF item_pointer (db_index,                                         sort_item,                                        itm_ptr,                                        workhorse_data,                                         error_code)                           THEN GOTO 99;                                pred_rec := chain_tail;                       next_rec := zero;                       sort_scan_done := false;                            WHILE not sort_scan_done DO BEGIN  (* Scan down the   *)   IF pred_rec = zero (* End of chain? *)   (* detail chain for*)      THEN              (*   Yes...      *)   (* this path until *)         sort_scan_done := true  (* the end of chain*)      ELSE BEGIN   (* or new record's *)   (* sort value is   *)         IF read_detail_record   (* less than or    *)               (db_index,  (* equal to current*)                set_number,  (* record's sort   *)                pred_rec,  (* item value.     *)                do_not_copy,                                        dst_rec_ptr,                                        workhorse_data,                                       error_code)                                   THEN GOTO 99;                                    buf_start_wrd :=                                     dpath_entry_ptr^.sort_begin -    !                                     set_entry_ptr^.gdt.media_len; !     !                              Any_ptr.data_record := data_rec_ptr; !                               Any_ptr.value := any_ptr.value +                                                     buf_start_wrd;                                  Sort_ptr1 := any_ptr.any_standard;                                     Any_ptr.detail_media_record :=                                        dst_rec_ptr;                                Any_ptr.value := any_ptr.value +  !                                      dpath_entry_ptr^.sort_begin; !                                sort_ptr2 := any_ptr.any_standard;                                         CASE itm_ptr^.ite.item_type OF        (* 'I' stands for Integer *) 'I' : BEGIN    (* item type.  There are  *)    (* then 1-word and 2-word *)   CASE itm_ptr^.item_len OF    (* integer types which    *)    1 :   !  (* can be compared.       *)     IF (sort_ptr1^.short_int_val >= !                                         sort_ptr2^.short_int_val)   !                                      THEN sort_scan_done := true; !                                       2 :                                       IF sort_ptr1^.long_int_val >=                                         sort_ptr2^.long_int_val                                        THEN sort_scan_done := true;                                         OTHERWISE BEGIN   !                                     error_code := DB_corrupt_err; !                                      GOTO 99;                                        END; (* otherwise *)                                      END; (* case of item length *)                                    END; (* case 'I' of item type *)         (* 'R' stands for Real *)    'R' : BEGIN    (* item type.  2-word  *)     (* and 4-word real     *)      CASE itm_ptr^.item_len OF    (* values can be used  *)       2 :   "  (* in sorted chains.   *)        IF (sort_ptr1^.short_real_val >=  " !                                       sort_ptr2^.short_real_val)  ! !                                      THEN sort_scan_done := true; !                                       4 :   !                                   IF (sort_ptr1^.long_real_val >= !                                         sort_ptr2^.long_real_val)   !                                      THEN sort_scan_done := true; !                                   OTHERWISE BEGIN   !                                     error_code := DB_corrupt_err; !                                      GOTO 99;                                        END; (* otherwise *)                                      END; (* case of item length *)   !                                END; (* case of real item type *)  !       (* Finally there is the *)   'X' :    (* character datatype.  *)    IF cmp_bytes    (* A sorted character   *)       (sort_ptr1^.short_int_val,     (* string must have an  *)        sort_ptr2^.short_int_val,      (* even number of bytes *)        itm_ptr^.item_len*2) >= zero     (* to avoid half-word   *)     THEN sort_scan_done := true;     (* values.              *)  !                               OTHERWISE BEGIN (* bad item type *) !                                    error_code := DB_corrupt_err;                                      GOTO 99;                                    END; (* otherwise *)                                    END; (* case of item type *)                                 END; (* else begin *)        (* If we didn't *) IF not sort_scan_done    (* find the     *)    THEN BEGIN  
  (* position yet,*) 
   (* look at the  *)       next_rec := pred_rec;  
  (* next detail  *) 
   (* record in    *)       pred_rec :=  "  (* the chain.   *)          dst_rec_ptr^.chains[path].prev_record; "                                 END;  (* setting up next pointers *)                            END; (* while not sort_scan_done *)                        END  (* if sort_item > zero *)                       ELSE BEGIN (* chain is not sorted *)  #                           (* so add new record to end of the chain *) #                    pred_rec := chain_tail;                     next_rec := zero;                     END;       
               (**)  
                 (* At this point we know where the detail record                   (* will be placed, the previous and next detail                  (* records in the chain, and the record number of                   (* the associated master entry.  Using this info,                  (* we will modify the pointers in the adjacent                   (* details and increment the master chain length.   
               (**)  
     
               (**)  
                (* Save the prev and next records of the detail                  (* chain to use in creating the media record for                   (* the new detail entry.   
               (**)  
                    WITH detail_paths[path] DO BEGIN                     prev_record := pred_rec;                    next_record := next_rec;  
               END;  
     
               (**)  
                (* Modify the detail records *)  
               (**)  
                    IF pred_rec > zero                     THEN BEGIN                       IF read_detail_record  (* Read previous *)        (db_index,   (* record in the *)         set_number,   (* detail chain; *)         pred_rec,   (* make a b-image*)         copy_media,                               dst_rec_ptr,                              workhorse_data,                               error_code)                            THEN GOTO 99;                            dst_rec_ptr^.chains[path].next_record :=                            free_detail_record;                             IF detail_record_modified (db_index,                                                   set_number,  "   (* Set the timestamp and *)                   media_record_only,  "    (* checksum information. *)                   dst_rec_ptr,                                                     workhorse_data,                                                    error_code)                           THEN GOTO 99;                        END; (* modify prev detail record *)                     IF next_rec > zero                     THEN BEGIN                       IF read_detail_record  (* Read the next     *)    (db_index,   (* record in the     *)     set_number,   (* detail chain and  *)     next_rec,   (* make a copy of the*)     copy_media,   (* before-image.     *)     dst_rec_ptr,                              workhorse_data,                               error_code)                           THEN GOTO 99;                            dst_rec_ptr^.chains[path].prev_record :=                           free_detail_record;                            IF detail_record_modified (db_index,                                                   set_number,   !   (* Set the timestamp and *)                  media_record_only, !    (* checksum information. *)                  dst_rec_ptr,                                                   workhorse_data,                                                    error_code)                           THEN GOTO 99;                            END; (* modify next detail record *)                         IF read_master_record (db_index,     (* Re-read the master *)              master_set_num,     (* record for this    *)              rec_number,     (* chain and make a   *)              copy_media,     (* before-image copy. *)              master_rec_ptr,                                           workhorse_data,                                           error_code)                       THEN GOTO 99;          "                  WITH master_rec_ptr^.chains[master_chain] DO BEGIN "                      chain_length := recs_in_chain + one;   (* Increment the*)   recs_in_chain := chain_length;   	(* chain length *) 	 (* and point to *)   IF pred_rec = zero   !(* the proper   *)      THEN head_of_chain := free_detail_record;  ! 	(* head and tail*) 	 (* records of   *)   IF next_rec = zero   !(* the detail   *)      THEN tail_of_chain := free_detail_record;  ! 	(* chain.       *) 	                   END; (* modifying master chain info *)                        IF master_record_modified (db_index,  (* Place timestamps and *)                   master_set_num,   (* checksums in the     *)                   media_record_only,    (* master data record.  *)                   master_rec_ptr,                                               workhorse_data,                                               error_code)                       THEN GOTO 99;                      END; (* for path = one to paths *)                      (**)               (* At this time we have modified all of the adjacent                (* detail records for all paths, as well as verified               (* or created the proper master entries for the               (* detail.  Now we want to physically add the new                (* detail record to the dataset.  We have saved the                (* chain information in 'detail_paths'.               (**)                  IF read_detail_record (db_index,                                     set_number,  (* Read the record where *)        free_detail_record,  (* the detail is to be   *)        copy_record,   (* placed.               *)        dst_rec_ptr,                                      workhorse_data,                                     error_code)                 THEN GOTO 99;      #            add_record := free_detail_record;  (* For reply message*)  #                 WITH dst_rec_ptr^ DO BEGIN                 prev_free_rec_pointer := backward_ptr;                  next_free_rec_pointer := forward_ptr;                 entry_type   := in_use;                 backward_ptr := zero;                 forward_ptr  := zero;                 FOR path := one TO num_of_paths DO                     chains[path] := detail_paths[path];                  END; (* with *)                  IF added_record (frtbl_ptr,                                free_detail_record,                               next_free_rec_pointer,                                error_code)                 THEN GOTO 99;                  (**)              (* Now to move the data record from the               (* message buffer to the data buffer.               (**)                  Any_ptr.detail_media_record := dst_rec_ptr;               Any_ptr.value := any_ptr.value +                               set_entry_ptr^.gdt.media_len;              Data_buf_ptr := any_ptr.data_record;          !            IF move_words                  (* Move the data    *)  ! !                  (data_rec_ptr^[zero],    (* from the input   *)  ! !                   data_buf_ptr^[zero],    (* buffer to the    *)  ! !                   data_record_len,        (* data buffer.     *)  !                    error_code)                 THEN GOTO 99;                      IF detail_Record_modified (db_index,                                         set_number,  (* Set checksums  *)                   media_and_data,  (* and timestamps.*)                   dst_rec_ptr,                                          workhorse_data,                                         error_code)                 THEN GOTO 99;                      (**)  !            (* Read the previous and next records in the detail's  !             (* free record chain and modify them to point to              (* each other instead of the record which we have   
            (* just added. 
             (**)                  IF prev_free_rec_pointer > zero   
               THEN BEGIN  
                   IF read_detail_record (db_index,                                           set_number,                                            prev_free_rec_pointer,                                             copy_media,                                           dst_rec_ptr,                                            workhorse_data,                                           error_code)                       THEN GOTO 99;                        dst_rec_ptr^.forward_ptr :=                                  next_free_rec_pointer;                         IF detail_record_modified (db_index,                                               set_number,                                                media_record_only,                                                 dst_rec_ptr,                                                workhorse_data,                                               error_code)                       THEN GOTO 99;                        END; (* modify prev free record *)                  IF next_free_rec_pointer > zero   
               THEN BEGIN  
                   IF read_detail_record (db_index,                                           set_number,                                            next_free_rec_pointer,                                             copy_media,                                           dst_rec_ptr,                                            workhorse_data,                                           error_code)                       THEN GOTO 99;                        dst_rec_ptr^.backward_ptr :=                                 prev_free_rec_pointer;                         IF detail_record_modified (db_index,                                               set_number,                                                media_record_only,                                                 dst_rec_ptr,                                                workhorse_data,                                               error_code)                       THEN GOTO 99;                        END; (* modify prev free record *)               rec_number := free_detail_record;               END; (* case of detail dataset put. *)                OTHERWISE BEGIN (* set type was unrecognizable. *)               error_code := DB_corrupt_err;   
            GOTO 99; 
             END;            END; (* case of set_type *)       $ Page $     (**)      (* All of the dataset record changes have been made.   "   (* Write out an 'End of Intrinsic' Mark in the Before-image Log.  "    (**)          IF mark_end_of_intrinsic  (workhorse_data, error_code)   
      THEN GOTO 99;  
     
99: (* error exit *) 
     "   save_error := no_image_err;  (* Don't carry over earlier error *) "        IF error_code <> no_image_err        THEN BEGIN           IF undo_last_intrinsic (workhorse_data,                                   save_error)  "            THEN error_code := save_error (* Return serious error *) "          END        ELSE           common_put_routine := false;       END; (* common_put_routine *)   .  