 $PASCAL '91790-16024 REV.4010 <861018.1153>'  
$Standard_Level 'HP1000'$  
 $Private_Types$   $Recursive Off$   $Run_String 0 $   $Debug$   $Heap 0$  $Range Off$       PROGRAM CONSM;      {------------------------------------------------------------        (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  
{       NAME: CONSM  
 
{     SOURCE: 91790-18024  
 
{      RELOC: 91790-16024  
 {       PGMR: TDS, EW   {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {   Date    PCO   Prgmr    Description  { 12/20/85  ---    EW      Delete references to IPCUABORT   !{ 01/30/86  2626   EW      Remove code to attach to session. This  ! %{                          function has been moved to the Monitor (NFTMN). % {                          SR # 30957   ${ 03/20/86  2626   EW      Set the read threshold to the size of the NFT $ %{                          buffer at this node to prevent reads of partial % {                          messages. SR # 35378   ${ 03/26/86  2626   EW      If return error 32 rather than 48 if write to $ !{                          a sparse target file fails. SR # 34082  ! %{ ************************** 4.1 PCO ************************************  % '{ 05/08/86  4010   EW      For all type 1/2 files calculate the file position  ' &{                          from the record number rather than trusting what  & {                          FMPPosition returns.   &{ 05/08/86  4010   EW      Added a check to verify that any records received & #{                          are not longer that the max we can handle.  # ${                          This is needed since the 9k will send longer  $ ${                          records that the max record size agreed upon. $ %{ 05/20/86  4010   EW      If the fsize is forced in interchange mode then % ${                          don't return space past the end of the file.  $ %{ 06/23/86  4010   EW      Corrected the section of code which calculates  % %{                          the correct position to use when setting up to  % %{                          return unused disc space. This is to prevent us % %{                          from truncating the EOF marker in some variable % {                          record length files.   ${ 06/23/86  4010   EW      Check to see if we want to return unused disc $ %{                          space before we calculate file position, rather % {                          than after.  %{ 06/30/86  4010   EW      Corrected the declaration for the fromat of the % ${                          Offeri message. The restart ID was before the $ ${                          misc. interchange flags instead of after the  $ {                          numbewr of buffers.  %{ 10/15/86  4010   EW      In the AINIT packet, return the minimum of the  % '{                          buffer size sent by the producer and the configured ' {                          buffer size.   {------------------------------------------------------------   {}      {}  { PROGRAM DESCRIPTION:  {   !{   This is the Network File Transfer Consumer program. It creates ! {   target files and directories. For files, the file data is   !{   received from the NFT Producer and stored in the target file.  ! {   The Consumer interacts with the NFT Producer and no other   {   NFT process.  {}      $Page   #{-------------------------------------------------------------------}  # #{                          GLOBAL LABELS                            }  # #{-------------------------------------------------------------------}  #     LABEL      99;   { Labels end of the program }      $Page   #{-------------------------------------------------------------------}  # #{                              IMPORT                               }  # #{-------------------------------------------------------------------}  #     IMPORT         $SEARCH 'phtm/BODEC.REL'$    BODEC,     $SEARCH 'phtm/SODEC.REL'$    SODEC,     $SEARCH 'phtm/MMDEC.REL'$    MMDEC,     $SEARCH 'phtm/MMEXT.REL'$    DS_MM,     $SEARCH 'phtm/TRCMOD.REL'$   TRCMOD;       #{-------------------------------------------------------------------}  # #{                         GLOBAL CONSTANTS                          }  # #{-------------------------------------------------------------------}  #     CONST      { Include the common NFT constant declarations }      $Include 'src/NFTCONSTS.PASI'      "   { This limits the buffer size of the main send/receive buffer.  } " "   { Since we can receive data messages, this buffer must be large } " "   { enough to accomodate them. Note that this is not necessarily  } " "   { the size of our send or receive buffer size on the connection.} " "   { The connection buffer sizes were choosen by the NFT Monitor   } " "   { when he accepted the connection request.                      } "    MAX_BUFFER_WORDS     =  2048;     MAX_BUFFER_BYTES     =  MAX_BUFFER_WORDS * 2;      !   { These are used to tell Fmp what the size of the Dcb packing } ! !   { buffer is. There are two constants here because of the way  } ! !   { we use the buffer area for transparent vs. interchange mode } ! !   { transfers. Refer to DcbAndInterchRecordType for more info.  } ! !   { - - - - - - - - - - - - - NOTE - - - - - - - - - - - - - -  } ! !   { If lack of program space becomes a problem, the constant    } ! !   { MIN_DCB_BUFFERS can be reduced at the expense of worse      } ! !   { performance for all transfers.                              } !    MIN_DCB_BUFFERS      =  80;     MAX_DCB_BUFFERS      =  MIN_DCB_BUFFERS +                             (MAX_INTERCH_REC_WORDS DIV 128);       $Page   #{-------------------------------------------------------------------}  # #{                            GLOBAL TYPES                           }  # #{-------------------------------------------------------------------}  #     TYPE         { This is used by the Pascal error catcher procedure }      CatchErrorType = (RUN_TIME_ERROR, EMA_ERROR, I_O_ERROR,  "                     FILE_ERROR, SEGMENTATION_ERROR, WARNING_ERROR); "        { This is used in CreateTargetFile }      CreateOrOpenType = (CREATE, OPEN);       !   { These error types are used for local error strings that are } ! !   { sent in messages to the producer. See InsertLocalErrorMsg.  } ! !   ErrorPacType    = PACKED ARRAY [1..ERROR_STRING_SIZE] OF CHAR;  !    ErrorStringType = String [ERROR_STRING_SIZE];      !   { This record is used to accumulate information about the     } ! !   { target file if the file contains length words, is a new type} ! !   { file (on a directory), and is being written out in blocks.  } ! !   { Fmp does not look in the blocks as they are being written   } ! !   { to disc, so we must accumulate info about the file and stuff} ! !   { it in the Dcb before the file is closed. Fmp then updates   } ! !   { the directory info when the file is closed. Most of these   } ! !   { fields must be cleared before each transfer takes place.    } ! !   { Note that only three of these variables will be placed into } ! !   { the Dcb, the others are used as temporaries.                } ! !   {  ai_eof_reached       - This field is only used to indicate } ! !   {                         that we already have reached Eof in } ! !   {                         the blocks we are writing to disc   } ! !   {                         and we don't need to continue to    } ! !   {                         look at the file data before writing} ! !   {                         Initialize to FALSE                 } ! !   {  ai_first_length_word - This is the actual length word got  } ! !   {                         from file record. It must be kept   } ! !   {                         here so it can be compared with the } ! !   {                         last length word of the record when } ! !   {                         that is found. If this is negative  } ! !   {                         (other than -1 which is the Eof),   } ! !   {                         then it indicates this should be    } ! !   {                         doubled and incremented to give an  } ! !   {                         odd-byte-length record. This field  } ! !   {                         does not have to be initialized     } ! !   {  ai_max_rec_length    - This gives the largest size record  } ! !   {                         in the file in words. Initialize to } ! !   {                         (0) before accumulating info.       } ! !   {  ai_number_records    - Counts the total number of records  } ! !   {                         This is always 1 greater than the   } ! !   {                         actual number of records since      } ! !   {                         FmpSetDcbInfo decrements it. Init-  } ! !   {                         ialize to (1) before accumulating.  } ! !   {  ai_relative_rec_ptr  - An index into the record which is   } ! !   {                         relative to the start of the record.} ! !   {                         The first length word is given an   } ! !   {                         index of (-1) and the last length   } ! !   {                         word has an index = record length   } ! !   {                         Initialize to (-1)                  } ! !   {  ai_total_words       - Gives the total number of words in  } ! !   {                         the file including the length words } ! !   {                         for each record. Initialize to (0)  } ! !   {                         before accumulating info.           } !    {}      AccumulatedInfoType = RECORD         ai_eof_reached       : BOOLEAN;         ai_first_length_word : Int16;         ai_max_rec_length    : Int16;         ai_number_records    : Int32;         ai_relative_rec_ptr  : Int16;         ai_total_words       : Int32;      END;          { Used to access bits within a byte }     ByteAsBits = PACKED RECORD         CASE BOOLEAN OF            TRUE : (byt   : Byte);            FALSE: (bits  : PACKED ARRAY [0..7] OF BOOLEAN);      END;       !   { This appears in the Rinit, Ainit messages. It may indicate }  ! !   { protocol options implemented on the sending system. The    }  ! !   { first variant is used to clear bits easily                 }  !    CapabilityMaskRecord = PACKED RECORD         CASE BOOLEAN OF            TRUE : (word : Int32);            FALSE: (bits : PACKED ARRAY [0..28] OF BOOLEAN;                   hierarchical_file_sys : BOOLEAN;                    only_alphanumerics    : BOOLEAN;                    can_change_roles      : BOOLEAN);     END;           { This is an option byte in the Offeri and Offert messages }        { It contains flags which affect the target file storage   }        { These are all user-specified options which have been     }        { propagated to us by the producer                         }        {  cs_unused     - These bits are unused for now           }        {  cs_cctl       - The file contains carriage control info }        {  cs_transient  - Store the file in transient mode        }        {  cs_append     - Append to an existing file              }        {  cs_overwrite  - Overwrite an existing file              }        {  cs_replace    - Replace target file if it exists        }       {}      ConsumerStorageRecord = PACKED RECORD        cs_unused     : PACKED ARRAY [0..2] OF BOOLEAN; { MSB }         cs_cctl       : BOOLEAN;        cs_transient  : BOOLEAN;        cs_append     : BOOLEAN;        cs_overwrite  : BOOLEAN;        cs_replace    : BOOLEAN;     END;          { This is the Dcb header used with the Fmp calls }      DcbHeaderType = ARRAY [0..DCB_HEADER_LENGTH-1] OF Int16;          { This is the data packing buffer associated with Fmp }     DcbPackingBufferType = ARRAY [0..(MIN_DCB_BUFFERS*128)-1]                                   OF Int16;      "   { This is the type of the session key as defined by DsRsm/1000 }  "    DsSessionKeyType = RECORD        CASE BOOLEAN OF   %         TRUE:  (bytes  : PACKED ARRAY [1..SESSION_KEY_WORDS*2] OF Byte);  % !         FALSE: (words  : ARRAY [1..SESSION_KEY_WORDS] OF Int16);  !    END;       #   { Defines the structure of a buffer which is used to hold large  }  # #   { records for interchange transfers. See DcbAndInterchRecordType }  #    {}      InterchRecordBufferType = RECORD         CASE BOOLEAN OF            TRUE :               (words : ARRAY [0..MAX_INTERCH_REC_WORDS -1] OF                               Int16);            FALSE:   !            (chars : PACKED ARRAY [0..MAX_INTERCH_REC_BYTES -1] OF !                             Byte);     END;       #   { This record defines two large buffers and some buffer indices. }  # #   { The useage of the buffers is different in interchange mode than}  # #   { transparent mode. Their useage is:                             }  # #   {                                                                }  # #   {  INTERCHANGE                                                   }  # #   {     The first buffer is used for the packing buffer portion of }  # #   {     the Data Control Block for Fmp calls. The second buffer    }  # #   {     will serve one of two uses. The first use is to accumulate }  # #   {     records which are too large for our receive buffer size and}  # #   {     therefore must be split up across message boundaries. The  }  # #   {     second use is as the last part of the packing buffer for   }  # #   {     Fmp calls. We can determine upon receipt of the Offeri     }  # #   {     message whether or not the largest record will fit in our  }  # #   {     receive buffer and whether or not the producer will then   }  # #   {     split up records across message boundaries. Based on the   }  # #   {     knowledge of whether records will be split up we can then  }  # #   {     determine the usage of this second buffer. Always keep in  }  # #   {     mind that only entire, logical records are written to disc }  # #   {     in interchange mode.                                       }  # #   {                                                                }  # #   {  TRANSPARENT                                                   }  # #   {     Since all files are opened with a type 1 override in this  }  # #   {     mode, there is no need for the Dcb packing buffer. Also,   }  # #   {     the interchange record is obviously not needed. These two  }  # #   {     buffers are used however, to accumulate disc blocks before }  # #   {     they are written to disc, thereby minimizing disc accesses.}  # #   {     Always keep in mind that only "raw" disc blocks are written}  # #   {     to disc in transparent mode.                               }  # #   {                                                                }  # #   {  dir_last_block_index    - Used for transparent transfers, this}  # #   {                            is used to mark the start of the    }  # #   {                            data which falls within the last    }  # #   {                            128 words of the source file. This  }  # #   {                            is used to prevent undesired extents}  # #   {                            in the target file.                 }  # #   {  dir_last_word_index     - Used for transparent transfers, this}  # #   {                            is used to point to the next free   }  # #   {                            word in the packing buffer (the one }  # #   {                            just after the last word we wrote   }  # #   {                            there). This must be initialized to }  # #   {                            0 before each xfer.                 }  # #   {  dir_dcb                 - The Data Control Block. This is only}  # #   {                            the header containing the 16 control}  # #   {                            words.                              }  # #   {  dir_packing_buffer      - Used for both modes of transfer. See}  # #   {                            above discussion for more info      }  # #   {  dir_interch_record      - This may serve several uses. See the}  # #   {                            discussion above for more info      }  # #   {  dir_record_length_bytes - Used for interchange transfers, this}  # #   {                            gives the total size of the record  }  # #   {                            in the record buffer in bytes after }  # #   {                            it is accumulated in its entirety.  }  # #   {                            Does not have to be initialized.    }  # #   {  dir_record_word_index   - Used for interchange transfers, is  }  # #   {                            a word index into the record buffer.}  # #   {                            This is used to keep track of where }  # #   {                            we are in the record. If this is -1 }  # #   {                            then this indicated that we have not}  # #   {                            yet processed the record header, if }  # #   {                            any. A value of 0 or greater means  }  # #   {                            that we have processed the record   }  # #   {                            header and we are in the middle of  }  # #   {                            the data part of the record. This   }  # #   {                            must be initialized to (-1) before  }  # #   {                            each transfer                       }  #    {}      DcbAndInterchRecordType = RECORD         dir_last_block_index    : Int16;        dir_last_word_index     : Int16;        dir_record_length_bytes : Int16;        dir_record_word_index   : Int16;        dir_dcb                 : DcbHeaderType;        CASE BOOLEAN OF            TRUE : (dir_packing_buffer  : DcbPackingBufferType;                    dir_interch_record  : InterchRecordBufferType);   !         FALSE: (dir_words : ARRAY [0..(MAX_DCB_BUFFERS * 128) -1] !                                     OF Int16);     END;          { This is where the file directory entry is placed. We }      { don't presently care what the fields are             }      FileDirectoryType = ARRAY [0..31] OF Int16;      !   { This record defines the structure of the first block in a   } ! !   { transient file as stored on the HP1000. Most of the fields  } ! !   { are extracted from the fields in the Offert message. These  } ! !   { are the attributes of the source file that will be used     } ! !   { to reconstruct the file when it reaches its home system type} ! !   {  fbtf_eof_flag            - The file data is written out in } ! !   {                             128-word blocks, but the file   } ! !   {                             type is chosen as 99 to tell us } ! !   {                             and user file is transient. Is  } ! !   {                             set to (-1) to avoid bad record } ! !   {                             length errors accessing later   } ! !   {  fbtf_bit_pattern         - As an added check that the file } ! !   {                             is transient, a special pattern } ! !   {                             (1010101010101010) is placed in } ! !   {                             this word and verified when we  } ! !   {                             see that the file type is the   } ! !   {                             same as Transient_File_Type     } ! !   {  fbtf_home_system_type    - The type of system where file   } ! !   {                             was originally created          } ! !   {  fbtf_op_sys_version      - The operating system version of } ! !   {                             the originating system          } ! !   {  fbtf_home_capabil_mask   - A capability mask defined by the} ! !   {                             originating system              } ! !   {  fbtf_bytes_in_last_block - Gives the number of bytes of    } ! !   {                             valid data in the last block in } ! !   {                             the file. Is a function of the  } ! !   {                             Offert.file_size_bytes          } ! !   {  fbtf_bytes_in_attributes - Gives the number of bytes in the} ! !   {                             fbtf_attributes area            } ! !   {  fbtf_attributes_area     - System specific attributes which} ! !   {                             are used to reconstruct the file} !    {}      FirstBlockTransientFileType = RECORD         fbtf_eof_flag            : Int16;         fbtf_bit_pattern         : Int16;         fbtf_home_system_type    : Int16;         fbtf_op_sys_version      : Int16;         fbtf_home_capabil_mask   : CapabilityMaskRecord;        fbtf_bytes_in_last_block : Int16;         fbtf_bytes_in_attributes : Int16;         fbtf_attributes_area     : PACKED ARRAY [0..  "                                   MAX_TRANSIENT_ATTRIBS-1] OF CHAR; "    END;           { In creating the target file, at times the user must not  }        { be allowed to specify some or all of the file parameters }        { such as file size and file type. See CreateTargetFile    }       ForcedParamsType = (NONE, SOME, ALL);         { This is used to pass flags to Ipc calls }     IpcFlagsType = Int32;      !   { This is the string descriptor type. A string descriptor    }  ! !   { contains the length and address of a string (16 bits each) }  ! 
   FmpStringType  = Int32; 
        { This is used to contain fully qualified file pathnames }   $   FullPathnameString = PACKED ARRAY [0..MAX_1000_PATH_CHARS-1] OF CHAR; $        { These are used to get string descriptors }      String1  = PACKED ARRAY [0..0] OF CHAR;     String2  = PACKED ARRAY [0..1] OF CHAR;     String4  = PACKED ARRAY [0..3] OF CHAR;     String5  = PACKED ARRAY [0..4] OF CHAR;     String16 = PACKED ARRAY [0..15] OF CHAR;      String40 = PACKED ARRAY [0..39] OF CHAR;       !   { Following two types appear in Offert message. If the source } ! !   { file was created on an HP1000 then its attributes will be   } ! !   { extracted and placed here (else attributes will be written  } ! !   { to the file in transient format). Therefore these fields are} ! !   { NOT valid if we are storing in transient format. NOTE: These} ! !   { fields must be identical to those declared at the producer  } ! !   { (including their order). The fields are:                    } ! !   {                                                             } ! !   {  hpa_file_type       - Standard file type number            } ! !   {  hpa_file_size       - Block size of the file in either     } ! !   {                        (+Blocks) or (-Chunks). For types    } ! !   {                        (1,2) gives size of the "main".      } ! !   {                        Else gives total size (including     } ! !   {                        extents for old and new files).      } ! !   {                        The consumer will use this value     } ! !   {                        to create the target file unless     } ! !   {                        transient storage is requested       } ! !   {                        (offert.file_size_bytes is used)     } ! !   {  hpa_record_size     - For type 1 and 2 files gives the     } ! !   {                        size of the source file records in   } ! !   {                        words.                               } ! !   {  hpa_missing_extents - True if the file is missing any      } ! !   {                        extents (old or new files)           } ! !   {  hpa_is_new_file     - True if the source file was a new    } ! !   {                        type file. Used to determine if the  } ! !   {                        protection and update time are valid.} ! !   {  hpa_owners_access   - The owner's protection bits (RW)     } ! !   {  hpa_others_access   - Others protection bits (RW)          } ! !   {  hpa_update_time     - The time of last update of the source} ! !   {                        file                                 } !    {}      Hp1000AttributesType = RECORD        hpa_file_type       : Int16;        hpa_file_size       : Int16;        hpa_record_size     : Int16;        hpa_missing_extents : BOOLEAN;        hpa_is_new_file     : BOOLEAN;        hpa_owners_access   : String2;        hpa_others_access   : String2;        hpa_update_time     : Int32;     END;          Hp1000AttributesRecord = PACKED RECORD         CASE BOOLEAN OF            TRUE : (words : Hp1000AttributesType);   "         FALSE: (chars : PACKED ARRAY [0..HP1000_ATTRIBUTES_CHARS-1] "                               OF CHAR);      END;       "   { This array is used for Ipc options. Enough space is allocated } " "   { for two options and two data bytes per option.                } "    IpcOptionsType = PACKED ARRAY [0..23] OF Byte;          { This is used by the Pascal error catcher procedure }      LogicalFileNameType = PACKED ARRAY [1..150] OF CHAR;          { This flag word appears in the Offeri message }      MiscInterchFlagsType = PACKED RECORD         unused            : PACKED ARRAY [0..4] OF BOOLEAN;         fsize_estimated   : BOOLEAN;        fsize_forced      : BOOLEAN;        rsize_forced      : BOOLEAN;     END;          { This is word 2 of every nft message }     MsgTypeRecord = PACKED RECORD        protocol_id    : Byte;    { Nft protocol Id  }        nft_type       : Byte;    { Nft message type }     END;          { Used to retrieve run-string params }      NumericParamsType = ARRAY [0..4] OF Int16;           { Contains the extracted fields of the Offeri or Offert msg.}       { The fixed part is common to both offer types. All fields  }       { were extracted from the offer msg directly except the     }       { source and target name lengths. For transient storage, we }       { don't save the system specific attributes string as it is }       { extracted directly from the Offert msg directly and then  }       { written to the first block of the transient file.         }       {  omf_file_size_bytes  - Gives the total physical size of  }       {                         the file in bytes. This is used   }       {                         to create transient files and is  }       {                         used in the processing of files   }       {                         without missing extents. In both  }       {                         cases we need to know the entire  }       {                         size of the file so an undesired  }       {                         extent is not created             }      {}      OfferMsgFieldsType = RECORD        omf_source_name      : FullPathnameString;        omf_target_name      : FullPathnameString;        omf_consumer_storage : ConsumerStorageRecord;             CASE omf_offer_type : Int16 OF           OFFERI:              (omf_data_type          : Byte;                omf_record_type        : Byte;                omf_record_len_bytes   : Int32;               omf_file_organiz       : Byte;                omf_number_records     : Int32;               omf_interch_flags      : MiscInterchFlagsType;               );           OFFERT:              (omf_file_size_bytes    : Int32;               omf_home_system_type   : Int16;               omf_op_sys_version     : Int16;               omf_capability_mask    : CapabilityMaskRecord;                omf_hp1000_attributes  : Hp1000AttributesRecord;               );     END;       !   { This type is used by CloseScratchOrTargetFile. It refers to } ! !   { making the target file permanent or not.                    } !    PermOrNotType = (MAKE_PERM, NOT_PERM);       !   { This partial block record is used hold a portion of a Data  } ! !   { message that was not a complete block until the rest of the } ! !   { block arrives at which time the block can be written to disc} ! !   { Number_bytes gives the amount of data in the partial block  } ! !   { (this must be reset before each transfer begins). The word  } ! !   { variant is used for FmpWrite only.                          } !    {}      PartialBlockType = RECORD        number_bytes : Int16;         CASE BOOLEAN OF   #         TRUE : (bytes : PACKED ARRAY [0..BYTES_PER_BLOCK-1] OF Byte); #          FALSE: (word  : Int16);     END;       !   { This record contains buffers which are used by FmpParsePath } ! !   { and FmpBuildPath for temporary storage of pathname fields.  } ! !   { Also included here are string descriptors to those buffers. } ! !   { The buffers are all freed when the FmpParsePath/FmpBuildPath} ! !   { sequence is completed. The descriptors are set up in the    } ! !   { Initialize procedure. The content and use of these pathname } ! !   { fields is described in the Fmp manual.                      } !    PathnameBuffersType = RECORD         pb_dirpath_buffer    :  FullPathnameString;         pb_dirpath_descr     :  FmpStringType;        pb_ds_buffer         :  FullPathnameString;         pb_ds_descr          :  FmpStringType;        pb_filename_buffer   :  String16;         pb_filename_descr    :  FmpStringType;        pb_file_size         :  Int16;        pb_file_type         :  Int16;        pb_qualifier_buffer  :  String40;         pb_qualifier_descr   :  FmpStringType;        pb_rec_len           :  Int16;        pb_sec_code          :  Int16;        pb_typex_buffer      :  String4;        pb_typex_descr       :  FmpStringType;     END;       "   { Contains the producer system info as retrieved from the Rinit } " "   { message. The fields are exact copies of the Rinit fields      } "    ProducerInfoType = PACKED RECORD         pi_debug_flags       : ByteAsBits;        pi_misc_flags        : ByteAsBits;        pi_system_type       : Int16;         pi_op_sys_version    : Int16;         pi_buffer_size       : Int16;         pi_capability_mask   : CapabilityMaskRecord;     END;          SixCharsType = PACKED ARRAY [1..6] OF CHAR;         { Possible states as described in the Nft Protocol }      StateTypes = (IDLE, WAIT_FOR_DATA);      !   { Contains information about the target file. The fields are: } ! !   {  tfi_accumulating_info  - True if we are accumulating info  } ! !   {                           about the file. This could only be} ! !   {                           used for transparent transfers.   } ! !   {                           See next field.                   } ! !   {  tfi_accumulated_info   - This is used to accumulate info   } ! !   {                           about the target file if it's type} ! !   {                           is > 2 and it is being written in } ! !   {                           blocks. Fmp does not look in the  } ! !   {                           blocks and the directory info will} ! !   {                           not be correct unless we gather it} ! !   {                           and patch up the directory. This  } ! !   {                           could only be used for transparent} ! !   {                           transfers as interchange transfers} ! !   {                           are record-oriented and Fmp can   } ! !   {                           gather directory info then.       } ! !   {  tfi_actual_name        - The pathname of the target file   } ! !   {                           which was used in FmpOpen call.   } ! !   {                           This name is a function of the    } ! !   {                           source and target file names as   } ! !   {                           given in one of the Offer(I,T)    } ! !   {                           messages. If it is found that this} ! !   {                           file exists and the user gave the } ! !   {                           replace option then a scratch name} ! !   {                           is used and when the transfer is  } ! !   {                           done, this file is purged and     } ! !   {                           tfi_scratch_name is renamed to    } ! !   {                           this name. This field is also used} ! !   {                           to hold the name of the target    } ! !   {                           directory used in the FmpCreateDir} ! !   {                           call. This name is extracted to   } ! !   {                           build the Adirectory message also.} ! !   {  tfi_actual_descr       - A descriptor to tfi_actual_name   } ! !   {  tfi_current_word       - Only used for transparent xfers.  } ! !   {                           Counts the total number of words  } ! !   {                           that have been received as the    } ! !   {                           data portion of a Data or Eod msg.} ! !   {                           For sparse target files, each     } ! !   {                           extent has an extent number word  } ! !   {                           preceeding it which gives its     } ! !   {                           number. Knowing the size of each  } ! !   {                           extent, this helps find these     } ! !   {                           words. For non-sparse target files} ! !   {                           this is used to prevent creating  } ! !   {                           undesired extents at end-of-file. } ! !   {                           This is an absolute number that is} ! !   {                           reset before each transfer begins } ! !   {  tfi_file_is_open       - True if the file is open. The file} ! !   {                           may be the scratch or the actual  } ! !   {                           file, whichever is being used.    } ! !   {                           This is mainly used to prevent us } ! !   {                           from closing or purging a target  } ! !   {                           file which does not exist. This   } ! !   {                           can occur in CleanupAndTerminate. } ! !   {  tfi_file_type          - The file type number of the target} ! !   {                           file. This is returned by FmpOpen.} ! !   {  tfi_is_new_file        - True if the file is not on a      } ! !   {                           cartridge (new type of file).     } ! !   {  tfi_records_written    - This is only used for interchange } ! !   {                           transfers. It counts the number   } ! !   {                           of logical records written to disc} ! !   {                           so far. This value is only used   } ! !   {                           to report to the producer the     } ! !   {                           number of records written in case } ! !   {                           an error occurs, or the user wants} ! !   {                           to abort. It is used only to build} ! !   {                           the Adata and Aabort messages     } ! !   {  tfi_scratch_name       - Name of the scratch file that is  } ! !   {                           used for the target file. This    } ! !   {                           file resides on the directory     } ! !   {                           where tfi_actual_name is. See     } ! !   {                           tfi_actual_name also.             } ! !   {  tfi_scratch_descr      - A descriptor to tfi_scratch_name  } ! !   {  tfi_transient_storage  - True if the file is being stored  } ! !   {                           in transient format               } ! !   {  tfi_using_scratch      - True if we are using scratch file } ! !   {                           whose name is in tfi_scratch_name,} ! !   {                           else tfi_actual_name is the name  } ! !   {                           of the target file.               } !    {}      TargetFileInfoType = RECORD        tfi_accumulating_info  : BOOLEAN;         tfi_accumulated_info   : AccumulatedInfoType;         tfi_actual_name        : FullPathnameString;        tfi_actual_descr       : FmpStringType;         tfi_current_word       : Int32;         tfi_file_is_open       : BOOLEAN;         tfi_file_type          : Int16;         tfi_is_new_file        : BOOLEAN;         tfi_records_written    : Int32;         tfi_scratch_name       : FullPathnameString;        tfi_scratch_descr      : FmpStringType;         tfi_transient_storage  : BOOLEAN;         tfi_using_scratch      : BOOLEAN;      END;          { Used to access both halves of a 32-bit word }     TwoWordsAsOneType = RECORD         CASE BOOLEAN OF            TRUE : (upper_16bits : Int16;                   lower_16bits : Int16);            FALSE: (full_32bits  : Int32);      END;          { Used to access a word as two chars in Initialize }      WordAsCharsType = PACKED RECORD        CASE BOOLEAN OF            TRUE :  (word        : Int16);            FALSE:  (first_char  : CHAR;                     second_char : CHAR);     END;       $Page   #   {-------------------------NFT MESSAGE TYPES-----------------------} # #   { These declarations are for the fixed length portion of the mess-} # #   { ages only. Also, the Nft message header is not included in any  } # #   { of the messages since it is common to all of them. Refer to the } # #   { Nft Protocol Specification for a more detailed discussion of    } # #   { each message.                                                   } #        { Aabort message fields }     AabortMsgType = PACKED RECORD        amount_data_xferred  : Int32;         type_data_xferred    : Byte;     END;          { Adata message fields }      AdataMsgType  = PACKED RECORD        nft_error_code       : Int16;         type_data_xferred    : Byte;        unused_byte          : Byte;        amount_data_xferred  : Int32;         local_error_msg_ptr  : Int16;         error_code_enhan_ptr : Int16;         end_ptr              : Int16;      END;          { Adirectory message fields }     AdirectoryMsgType = PACKED RECORD        nft_error_code       : Int16;         target_directory_ptr : Int16;         local_error_msg_ptr  : Int16;         error_code_enhan_ptr : Int16;         end_ptr              : Int16;      END;          { Ainit message fields }      AinitMsgType = PACKED RECORD         debug_flags          : ByteAsBits;        misc_flags           : ByteAsBits;        system_type          : Int16;         op_sys_version       : Int16;         buffer_size          : Int16;         capability_mask      : CapabilityMaskRecord;        sys_specif_capa_mask : Int16;         nft_error_code       : Int16;         local_error_msg_ptr  : Int16;         error_code_enhan_ptr : Int16;         end_ptr              : Int16;      END;          { Aofferi message fields }      AofferiMsgType = PACKED RECORD         data_type            : Byte;        record_type          : Byte;        file_organiz         : Byte;        unused_byte          : Byte;        record_length        : Int32;         number_records       : Int32;         restart_id           : Int16;         nft_error_code       : Int16;         target_file_ptr      : Int16;         local_error_msg_ptr  : Int16;         error_code_enhan_ptr : Int16;         negoc_flags_ptr      : Int16;         number_buffers_ptr   : Int16;         end_ptr              : Int16;      END;          { Aoffert message fields }      AoffertMsgType = PACKED RECORD         restart_id           : Int16;         nft_error_code       : Int16;         target_file_ptr      : Int16;         local_error_msg_ptr  : Int16;         error_code_enhan_ptr : Int16;         sys_specific_msg_ptr : Int16;         negoc_flags_ptr      : Int16;         number_buffers_ptr   : Int16;         end_ptr              : Int16;      END;          { Directory message fields }      DirectoryMsgType = PACKED RECORD         source_directory_ptr : Int16;         target_directory_ptr : Int16;         system_specific_ptr  : Int16;         end_ptr              : Int16;      END;          { Offeri message fields }     OfferiMsgType = PACKED RECORD        consumer_storage     : ConsumerStorageRecord;         data_type            : Byte;        record_type          : Byte;        file_organiz         : Byte;        record_length        : Int32;         number_records       : Int32;         misc_interch_flags   : MiscInterchFlagsType;        number_buffers       : Byte;        restart_id           : Int16;         ichar_ptr            : Int16;         source_file_ptr      : Int16;         target_file_ptr      : Int16;         target_file_pass_ptr : Int16;         target_file_dev_ptr  : Int16;         negoc_flags_ptr      : Int16;         end_ptr              : Int16;      END;          { Offert message fields }     OffertMsgType = PACKED RECORD        file_size_bytes      : Int32;         home_system_type     : Int16;         op_sys_version       : Int16;         capability_mask      : CapabilityMaskRecord;        consumer_storage     : ConsumerStorageRecord;         number_buffers       : Byte;        restart_id           : Int16;         source_file_ptr      : Int16;         target_file_ptr      : Int16;         target_file_pass_ptr : Int16;         target_file_dev_ptr  : Int16;         attributes_ptr       : Int16;         negoc_flags_ptr      : Int16;         end_ptr              : Int16;      END;          { Rinit message fileds }      RinitMsgType = PACKED RECORD         debug_flags          : ByteAsBits;        misc_flags           : ByteAsBits;        system_type          : Int16;         op_sys_version       : Int16;         buffer_size          : Int16;         capability_mask      : CapabilityMaskRecord;        sys_specif_capa_mask : Int16;         logon_ptr            : Int16;         logon_pass_ptr       : Int16;         session_id_ptr       : Int16;         share_session_ptr    : Int16;         end_ptr              : Int16;      END;          { Warning message fields }      WarningMsgType = PACKED RECORD         nft_error_code       : Int16;         local_error_msg_ptr  : Int16;         error_code_enhan_ptr : Int16;         end_ptr              : Int16;      END;       $Page   #   {------------------------MAIN BUFFER TYPE------------------------}  #     "   { This is the format of each Nft message. The first two fields }  " "   { are the message header (2 words total).                      }  " 
   NftMessageType = RECORD 
       msg_length_bytes : Int16;         msg_type         : MsgTypeRecord;       
      CASE Int16 OF  
          {------------ Incoming ------------}            0 : (directory_msg   : DirectoryMsgType);           1 : (offeri_msg      : OfferiMsgType);            2 : (offert_msg      : OffertMsgType);            3 : (rinit_msg       : RinitMsgType);           {Also Abort, Cancel, Data, Eod}               {------------ Outgoing ------------}            4 : (aabort_msg      : AabortMsgType);            5 : (adata_msg       : AdataMsgType);           6 : (adirectory_msg  : AdirectoryMsgType);            7 : (ainit_msg       : AinitMsgType);           8 : (aofferi_msg     : AofferiMsgType);           9 : (aoffert_msg     : AoffertMsgType);          10 : (warning_msg     : WarningMsgType);     END;       !   { General purpose send/receive buffer. All messages sent or   } ! !   { received are passed throught this buffer. The last three    } ! !   { variants are used for general-purpose access to the message } ! !   { fields.                                                     } ! 
   MsgBufferType = RECORD  
 
      CASE Int16 OF  
          0 : (msg   : NftMessageType);  #         1 : (bytes : PACKED ARRAY [0..MAX_BUFFER_BYTES -1] OF Byte);  # #         2 : (chars : PACKED ARRAY [0..MAX_BUFFER_BYTES -1] OF CHAR);  #           3 : (words : ARRAY [0..MAX_BUFFER_WORDS -1] OF Int16);       END;           $Page   #{-------------------------------------------------------------------}  # #{                         GLOBAL VARIABLES                          }  # #{-------------------------------------------------------------------}  #     VAR       { This variable is used in the main routine to tell Ipc the }       { maximum size data message to be received                  }      data_length      : Int32;      "   { This record contains the file Dcb for Fmp calls, and a buffer } " "   { which may be used to accumulate large records in interchange  } " "   { mode. This second buffer may double as part of the Dcb if it  } " "   { is not needed.                                                } "    dcb_and_interch_record : DcbAndInterchRecordType;         { These are used in the main routine }      ipc_flags        : IpcFlagsType;      ipc_options      : IpcOptionsType;          { Used in the main routine }      error            : Int16;          { Current event. Can be Nft message type or Nft error code }       event            : Int16;         { This is used only in the main routine }     ipc_error        : Int32;         { The main buffer. Used to send and receive all msgs }      msg_buffer       : MsgBufferType;      !   { This is used to hold the buffer size value that we got from } ! !   { the global NFT_BUFF_SIZE in DSAM. It gives the size of our  } ! !   { receive buffer in words that the monitor used to accept the } ! !   { connection request. We pick this up in Initialize().        } !    nft_buffer_words : Int16;      !   { This record contains temporary buffers for use by routines }  ! !   { FmpParsePath and FmpBuildPath when parsing pathnames.      }  !    pathname_buffers : PathnameBuffersType;          { Contains the extracted fields on the producers Offeri or }        { Offert message                                           }       offer_msg_fields : OfferMsgFieldsType;       !   { Contains info about the producer system. This was given to }  ! !   { us in the Rinit message the producer sent us               }  !    producer_info    : ProducerInfoType;          { Current state as defined in the Nft Protocol Document }     state            : StateTypes;          { Contains info about the target file }     target_file_info : TargetFileInfoType;          { This is a temporary variable used by some routines to }     { implement triggers                                    }     trigger_temp     : Int16;         { Identifies the connection to the producer }     vc_socket_descr  : Int32;          $Page   #{-------------------------------------------------------------------}  # #{              EXTERNAL & FORWARD ROUTINE DECLARATIONS              }  # #{-------------------------------------------------------------------}  #     PROCEDURE AdsErrorLookup     (    service            : Int16;           error_number       : Int32;       VAR error_buffer       : ErrorPacType);      EXTERNAL;      !{ Create a target file name given a source file name and a mask. } ! !{ This is a documented Fmp routine.                              } ! PROCEDURE Calc_Dest_Name     (VAR source_name_descr  : FmpStringType;       VAR level_number       : Int16;       VAR target_name_descr  : FmpStringType;       VAR final_name_descr   : FmpStringType;       VAR temp_descr         : FmpStringType);     EXTERNAL;      PROCEDURE CaseFold  $ALIAS 'CLCUC'$      (VAR buffer             : FullPathNameString;          length             : Int16);     EXTERNAL;      PROCEDURE CleanupAndTerminate;     FORWARD;       PROCEDURE CloseScratchOrTargetFile     (VAR target_file_info         : TargetFileInfoType;          permanent_or_not         : PermOrNotType;       VAR dcb_and_interch_record   : DcbAndInterchRecordType;       VAR fmp_error                : Int16);     FORWARD;       PROCEDURE Cnumd      (    number             : Int16;           string_return      : SixCharsType);      EXTERNAL;      
PROCEDURE CreateTargetFile 
    (    create_or_open     : CreateOrOpenType;          interch_or_trans   : Int16;       VAR old_pathname       : FullPathnameString;      VAR target_file_info   : TargetFileInfoType;          number_dcb_buffers : Int16;           new_file_type      : Int16;           new_file_size      : Int16;           new_rec_length     : Int16;           forced_params      : ForcedParamsType;      VAR fmp_error          : Int16;       VAR nft_error          : Int16);     FORWARD;       
PROCEDURE FattenMask 
    (VAR file_name_descr    : FmpStringType;           what_method        : Int16);     EXTERNAL;      #{ This procedure allows the creation of extents by setting a bit in  } # #{ the DCB. This is the same as the 'X' option on FmpOpen. This is an } # #{ undocumented call and is declared and used in FmpCopy.             } # 
PROCEDURE FmpAllowExtents  
    (VAR dcb                : DcbHeaderType);     EXTERNAL;      PROCEDURE FmpBuildPath     (VAR pathname_descr     : FmpStringType;       VAR dirpath_descr      : FmpStringType;       VAR name_descr         : FmpStringType;       VAR typex_descr        : FmpStringType;       VAR qualifier_descr    : FmpStringType;       VAR sec_code           : Int16;       VAR file_type          : Int16;       VAR file_size          : Int16;       VAR rec_len            : Int16;       VAR ds_path_descr      : FmpStringType);     EXTERNAL;      #{ This procedure clears the EOF bit in the Dcb so that Fmp does not }  # #{ complain about end-of-file. This is needed when we are writing to }  # #{ files with missing extents and we need to stop Fmp from creating  }  # #{ extents at his whim. In so doing, Fmp will set this flag when     }  # #{ writing out the last block of the file. This undocumented call is }  # #{ declared and used in FmpCopy.                                     }  # PROCEDURE FmpClearEof      (    dcb                : DcbHeaderType);     EXTERNAL;      	PROCEDURE FmpClose 	    (VAR dcb                : DcbHeaderType;       VAR error              : Int16);     EXTERNAL;      FUNCTION FmpCreateDir      (VAR directory_name     : FmpStringType;           lu_number          : Int16)      : Int16;      EXTERNAL;      	PROCEDURE FmpError 	 
   $FIXED_STRING ON  
    (VAR fmp_error          : Int16;       VAR error_string       : String);   
   $FIXED_STRING OFF 
    EXTERNAL;      FUNCTION FmpExpandSize     (VAR small_size         : Int16)      : Int32;      EXTERNAL;      PROCEDURE FmpFileName      (VAR dcb                : DcbHeaderType;       VAR error              : Int16;       VAR namr_descr         : FmpStringType);     EXTERNAL;      
PROCEDURE FmpHierarchName  
    (VAR name               : FmpStringType);     EXTERNAL;      	PROCEDURE FmpInfo  	    (VAR dcb                : DcbHeaderType;       VAR fmp_error          : Int16;       VAR info_buffer        : FileDirectoryType;       VAR new_or_old         : Int16);     EXTERNAL;      "{ This procedure turns off a bit in the Dcb which allows extent   }  " "{ creation. When we are writing out file data, Fmp will create a  }  " "{ new extent just after writing out the last portion of the last  }  " "{ extent. There are some instances when this is undesirable. This }  " "{ undocumented call is declared and used in FmpCopy.              }  " PROCEDURE FmpNoExtents     (VAR dcb                : DcbHeaderType);     EXTERNAL;      FUNCTION FmpOpen     (VAR dcb                : DcbHeaderType;       VAR error              : Int16;       VAR namr_descr         : FmpStringType;       VAR opts_descr         : FmpStringType;           dcb_buffers        : Int16)      : Int16;      EXTERNAL;      
FUNCTION FmpPackSize 
    (    file_size          : Int32)      : Int16;      EXTERNAL;      PROCEDURE FmpParsePath     (VAR pathname_descr     : FmpStringType;       VAR dirpath_descr      : FmpStringType;       VAR name_descr         : FmpStringType;       VAR typex_descr        : FmpStringType;       VAR qualifier_descr    : FmpStringType;       VAR sec_code           : Int16;       VAR file_type          : Int16;       VAR file_size          : Int16;       VAR rec_len            : Int16;       VAR ds_path_descr      : FmpStringType);     EXTERNAL;      PROCEDURE FmpPosition      (VAR dcb                : DcbHeaderType;       VAR fmp_error          : Int16;       VAR record_number      : Int32;       VAR position           : Int32);     EXTERNAL;      	FUNCTION FmpPurge  	    (VAR namr_descr         : FmpStringType)      : Int16;      EXTERNAL;      
PROCEDURE FmpRename  
    (VAR old_name           : FmpStringType;       VAR fmp_error1         : Int16;       VAR new_name           : FmpStringType;       VAR fmp_error2         : Int16);     EXTERNAL;      PROCEDURE FmpSetDcbInfo      (VAR dcb                : DcbHeaderType;       VAR fmp_error          : Int16;       VAR num_records        : Int32;       VAR total_words        : Int32;       VAR record_len         : Int16);     EXTERNAL;      PROCEDURE FmpSetDirInfo      (VAR dcb                : DcbHeaderType;       VAR fmp_error          : Int16;           create_time        : Int32;           access_time        : Int32;           update_time        : Int32;           backup_bit         : Int16;           protection         : Int16);     EXTERNAL;      PROCEDURE FmpSetPosition     (VAR dcb                : DcbHeaderType;       VAR fmp_error          : Int16;       VAR record_num         : Int32;           position           : Int32);     EXTERNAL;      
FUNCTION FmpSetProtection  
    (VAR name               : FmpStringType;       VAR owner              : FmpStringType;       VAR others             : FmpStringType)      : Int16;      EXTERNAL;      
PROCEDURE FmpStandardName  
    (VAR file_name_descr    : FmpStringType);     EXTERNAL;      PROCEDURE FmpTruncate      (VAR dcb                : DcbHeaderType;       VAR fmp_error          : Int16;       VAR block_position     : Int32);     EXTERNAL;      PROCEDURE FmpUniqueName      (    file_name_prefix   : FmpStringType;       VAR final_name_descr   : FmpStringType);     EXTERNAL;      FUNCTION FmpWorkingDir     (VAR dir_name           : FmpStringType)      : Int16;      EXTERNAL;      	FUNCTION FmpWrite  	    (VAR dcb                : DcbHeaderType;       VAR error              : Int16;       VAR data_buffer        : Int16;           max_length         : Int16)      : Int16;      EXTERNAL;      	PROCEDURE InitOpt  	    (VAR opts               : IpcOptionsType;          total_entries      : Int16;       VAR error              : Int16);     EXTERNAL;      
PROCEDURE IpcControl 
    (VAR descr              : Int32;           request            : Int32;           wrtdata            : Int16;           wrtlength          : Int32;           readdata           : Int16;       VAR readlength         : Int32;       VAR flags              : IpcFlagsType;      VAR result             : Int32);     EXTERNAL;      	PROCEDURE IpcRecv  	    (VAR connct_descr       : Int32;       VAR buffer             : MsgBufferType;       VAR data_length        : Int32;       VAR flags              : IpcFlagsType;      VAR options            : IpcOptionsType;      VAR result             : Int32);     EXTERNAL;      	PROCEDURE IpcSend  	    (VAR connct_descr       : Int32;       VAR buffer             : MsgBufferType;           data_length        : Int32;       VAR flags              : IpcFlagsType;      VAR options            : IpcOptionsType;      VAR result             : Int32);     EXTERNAL;      	PROCEDURE LogEvent 	    (    nft_log_error_code : Int16;           instance           : Int16;           state              : StateTypes;          parm1              : Int32;           parm2              : Int32;           parm3              : Int32);     FORWARD;       FUNCTION Min     (    first              : Int32;           second             : Int32)      : Int16;      FORWARD;       PROCEDURE ReceiveData      (VAR state              : StateTypes;      VAR msg_buffer         : MsgBufferType;       VAR target_file_info   : TargetFileInfoType);      FORWARD;       PROCEDURE ReceiveDataInterchange     (VAR msg_buffer             : MsgBufferType;       VAR target_file_info       : TargetFileInfoType;      VAR dcb_and_interch_record : DcbAndInterchRecordType;       VAR fmp_error              : Int16;       VAR nft1000_error          : Int16;       VAR nft_error              : Int16);     FORWARD;       PROCEDURE ReceiveDataTransparent     (VAR msg_buffer             : MsgBufferType;       VAR target_file_info       : TargetFileInfoType;      VAR dcb_and_interch_record : DcbAndInterchRecordType;       VAR fmp_error              : Int16;       VAR nft_error              : Int16);     FORWARD;       
PROCEDURE ReceiveEod 
    (VAR msg_buffer         : MsgBufferType;       VAR target_file_info   : TargetFileInfoType);      FORWARD;       PROCEDURE ReceiveOfferi      (VAR msg_buffer         : MsgBufferType;       VAR nft1000_error      : Int16;       VAR fmp_error          : Int16;       VAR nft_error          : Int16);     FORWARD;       PROCEDURE ReceiveOffert      (VAR msg_buffer         : MsgBufferType;       VAR fmp_error          : Int16;       VAR nft_error          : Int16);     FORWARD;       
PROCEDURE RetrieveOfferMsg 
    (VAR msg_buffer        : MsgBufferType;      VAR offer_msg_fields  : OfferMsgFieldsType;           transient_storage : BOOLEAN;      VAR nft_error         : Int16);      FORWARD;       #{ Return a string descriptor. The type of the formal parameter must }  # #{ match the actual parameter or Pascal will copy it first and the   }  # #{ descriptor will contain the wrong address.                        }  # FUNCTION StringDescr1  $ALIAS 'StrDsc'$      (VAR string             : String1;           first_char         : Int16;           length             : Int16)   
   : FmpStringType;  
    EXTERNAL;      FUNCTION StringDescr2  $ALIAS 'StrDsc'$      (    string             : String2;           first_char         : Int16;           length             : Int16)   
   : FmpStringType;  
    EXTERNAL;      FUNCTION StringDescr4  $ALIAS 'StrDsc'$      (VAR string             : String4;           first_char         : Int16;           length             : Int16)   
   : FmpStringType;  
    EXTERNAL;      FUNCTION StringDescr5  $ALIAS 'StrDsc'$      (VAR string             : String5;           first_char         : Int16;           length             : Int16)   
   : FmpStringType;  
    EXTERNAL;      FUNCTION StringDescr16  $ALIAS 'StrDsc'$     (VAR string             : String16;          first_char         : Int16;           length             : Int16)   
   : FmpStringType;  
    EXTERNAL;      FUNCTION StringDescr40  $ALIAS 'StrDsc'$     (VAR string             : String40;          first_char         : Int16;           length             : Int16)   
   : FmpStringType;  
    EXTERNAL;      FUNCTION StringDescr64  $ALIAS 'StrDsc'$     (VAR string             : FullPathnameString;          first_char         : Int16;           length             : Int16)   
   : FmpStringType;  
    EXTERNAL;          $Page   #{-------------------------------------------------------------------}  # #{                        ACCUMULATE FILE INFO                       }  # #{-------------------------------------------------------------------}  # "{ This procedure accumulates information about the records in a file " "{ containing variable length records. A disc-image buffer is passed  " { in a as parameter and the following info is accumulated:  {     1) Total number of words (including record length words)  {     2) The largest size record in the file in words   {     3) The number of records  {   "{ Since a variable-length record may span across buffer boundaries,  " "{ temporary variables are used to keep track of where we are. These  " !{ temporaries are kept in the "accumulated_info" record also. If a ! "{ bad length word is found then an error is returned. Note that the  " "{ record length word may be negative which indicates that the length " "{ word should be doubled and incremented to get the number of bytes  "  { in the record (the record is still stored in an even number of   { words but the last byte is ignored in this case).   {   #{-------------------------------------------------------------------}  # !{ NOTE: This procedure must be aware of the structure of variable  ! "{ length records as stored in the RTE file system. If the structure  " { changes, this code may have to change.  #{-------------------------------------------------------------------}  # {   { Parameters:   {   {     dcb_and_interch_record (Input)  !{        Contains the file data in disc-image form. This includes  ! "{        the two length words per record. The file data is accessed  " {        through the dir_words variant  {   
{     buffer_index (Input) 
 {        Word index into the buffer where the data begins   {   
{     end_of_data (Input)  
  {        Word index into the buffer where the last data word is    {   {     accumulated_info (Input/Output)   !{        A record (which resides in target_file_info) which holds  ! {        the accumulated info and some temporary variables  {   {     fmp_error (Output)  "{        If non-zero will return a bad record length error (Fmp -5)  " {}  PROCEDURE  AccumulateFileInfo      (VAR dcb_and_interch_record : DcbAndInterchRecordType;           buffer_index           : Int16;           end_of_data            : Int16;       VAR accumulated_info       : AccumulatedInfoType;       VAR fmp_error              : Int16);      CONST   	   SIGN_BIT = -15; 	     TYPE     WordAsBits = RECORD        CASE BOOLEAN OF            TRUE : (word : Int16);             FALSE: (bits : PACKED ARRAY [SIGN_BIT..0] OF BOOLEAN);       END;       VAR      add_on            : Int16;      positive_rec_len  : WordAsBits;      BEGIN   	   fmp_error := 0; 	        WITH accumulated_info, dcb_and_interch_record DO         BEGIN   !      { If there is some data in the buffer and we did not reach } ! !      { end-of-file previously then process the data             } ! "      IF (end_of_data >= buffer_index) AND (NOT ai_eof_reached) THEN "          BEGIN           REPEAT               { If we are positioned to first length word then }              { pull it out and save it for later. The first   }              { length word has an offset of (-1)              }              IF ai_relative_rec_ptr = -1 THEN  
               BEGIN 
                 ai_first_length_word := dir_words [buffer_index];                  ai_relative_rec_ptr  := ai_relative_rec_ptr +1;                 buffer_index         := buffer_index +1;                  END;  { IF ai_relative_rec_ptr }                  ai_eof_reached := ai_first_length_word = -1;                   IF NOT ai_eof_reached THEN  
               BEGIN 
 !               { The length word in the file may be negative if }  ! !               { record contains odd number of bytes. Convert   }  ! !               { the length word to a positive number of words  }  !                positive_rec_len.word := ai_first_length_word;                  IF positive_rec_len.word < 0 THEN                    BEGIN                     positive_rec_len.bits [SIGN_BIT] := FALSE;  "                  positive_rec_len.word := positive_rec_len.word +1; "                   END;  { IF positive_rec_len }       "               { Increment both pointers by either the amount left } " "               { in the buffer or the amount left in the record,   } " "               { whichever is smaller (try to find last leng word) } "                add_on :=  "                  Min (positive_rec_len.word - ai_relative_rec_ptr,  " "                       end_of_data           - buffer_index     +1); "     "               buffer_index        := buffer_index        + add_on;  " "               ai_relative_rec_ptr := ai_relative_rec_ptr + add_on;  "     !               { Check if we are positioned to last length word }  ! "               IF (ai_relative_rec_ptr = positive_rec_len.word) AND  " "                  (buffer_index       <= end_of_data)           THEN "                   BEGIN                     { Make sure the record length words match }                     IF dir_words [buffer_index] <>                       ai_first_length_word     THEN                       fmp_error := FMP_BAD_RECORD_LENGTH                     ELSE  
                     BEGIN 
 !                     { Length words match, ready for next record } !                      ai_relative_rec_ptr := -1;                        buffer_index        := buffer_index +1;                            { Update the fields we are interested in }                          ai_number_records := ai_number_records +1;                         IF positive_rec_len.word >                           ai_max_rec_length     THEN  "                        ai_max_rec_length := positive_rec_len.word;  " !                     { Add current record length and its length }  ! !                     { words to the total number of words       }  !                      ai_total_words := ai_total_words +   !                                       positive_rec_len.word + 2;  !                      END;  { ELSE of IF buffer }                    END;  { IF (relative }                     END;  { IF NOT ai_eof_reached }               UNTIL ai_eof_reached            OR                  (fmp_error <> 0)          OR                  (buffer_index > end_of_data);               END;  { IF (end_of_data }        END;  { WITH accumulated_info }       END;  { AccumulateFileInfo }          $Page   #{-------------------------------------------------------------------}  # #{                         BUILD AND SEND MSG                        }  # #{-------------------------------------------------------------------}  #  { Build and send the message dictated by message_type. Send the    "{ message to the producer and return any error. The caller will not  " "{ be able to do much to recover since the connection to the producer " { was our only link to the world.   {   { Parameters:   {   
{     message_type (Input) 
  {        Identifies the type of Nft message that is to be built    {   {     nft_error (Input)   {        Gives the Nft protocol error code that occurred  {   {     nft1000_error (Input)    {        Gives an Nft/100 error code that should be mapped to a    {        string and placed in the local error message portion   
{        of some messages  
 {   {     fmp_error (Input)   {        Gives an Fmp error code that should be mapped to a   {        string and placed in the local error message portion   
{        of some messages  
 {   {     ipc_error (Output)  {        Returns any Ipc error in sending the message   {}  
PROCEDURE  BuildAndSendMsg 
    (    message_type   : Int16;           nft_error      : Int16;           nft1000_error  : Int16;           fmp_error      : Int16;       VAR ipc_error      : Int32);      VAR      ipc_flags         : IpcFlagsType;     error             : Int16;      message_length    : Int32;      temp              : Int16;      temp1             : Int16;      temp_end_ptr      : Int16;       $Page   #   {----------------------------------------------------------------}  # #   { (Local)              INSERT LOCAL ERROR MSG            (Local) }  # #   {----------------------------------------------------------------}  # "   { Given a local error code and a pointer into the msg_buffer, map " "   { the error code into an error string and place that string into  " #   { the send buffer beginning at location pointed to by the pointer.  # !   { Return the index of the next free char in the msg_buffer that !    { follows the string that was just inserted.      {     { Parameters:     {     {  nft1000_error (Input)       {     Gives an Nft/1000 error code that should be mapped to a      {     string and placed in the message      {     {  fmp_error (Input)   !   {     Gives an Fmp error code that should be mapped to a string !    {     and placed in the message     {     {  msg_buffer (Input/Output)      {     Where the local error message string is to be placed      {     {  local_error_msg_ptr (Input)       {     Points to the byte location in the msg_buffer where the      {     error string is to be placed      {     {  end_local_msg_ptr (Output)  !   {     Returns an index into the send buffer where the next free !    {     byte after the inserted string is     {}      PROCEDURE  InsertLocalErrorMsg         (VAR nft1000_error       : Int16;          VAR fmp_error           : Int16;          VAR msg_buffer          : MsgBufferType;              local_error_msg_ptr : Int16;          VAR end_local_msg_ptr   : Int16);         VAR        error_pac         : ErrorPacType;         error_string      : ErrorStringType;        loop              : Int16;        number_as_string  : String [6];         six_chars         : SixCharsType;          BEGIN        IF (nft1000_error = 0) AND (fmp_error = 0) THEN            BEGIN            { No error occurred so insert null string, and return }            end_local_msg_ptr := local_error_msg_ptr;           END        ELSE           BEGIN           SetStrLen (error_string, StrMax (error_string));       #         { Fill in the proper error string. We could have used some }  # #         { of the Pascal string routines below but many of them are }  # #         { relatively large (e.g., StrMove)                         }  #          IF nft1000_error <> 0 THEN   	            BEGIN  	             error_pac := ' ';    { Blank fill error_pac }   "            AdsErrorLookup (NFT_SERVICE, nft1000_error, error_pac);  "             FOR loop := 1 TO ERROR_STRING_SIZE DO                  error_string [loop] := error_pac [loop];               error_string := StrRtrim (error_string);              END   { IF }           ELSE   	            BEGIN  	             { Get the Fmp error string for the error code }               FmpError (fmp_error, error_string);               error_string := StrRTrim (error_string);      "            { Convert the error code to an Ascii string and append } " "            { it onto the error string.                            } "             StrAppend (error_string, '  (RTE FMP ');              IF fmp_error < 0 THEN                  StrAppend (error_string, '-');               Cnumd (Abs (fmp_error), six_chars);               SetStrLen (number_as_string, 6);              FOR loop := 1 TO 6 DO                  number_as_string [loop] := six_chars [loop];               number_as_string := StrLTrim (number_as_string);              number_as_string := StrRTrim (number_as_string);              StrAppend (error_string, number_as_string);               StrAppend (error_string, ')');              END;  { ELSE of IF nft1000_error }               { Insert the string into the send buffer }            FOR loop := 0 TO StrLen (error_string) -1 DO   	            BEGIN  	             msg_buffer.chars [local_error_msg_ptr + loop] :=                 error_string [loop +1];              END;  { FOR loop }               end_local_msg_ptr := local_error_msg_ptr +                                 StrLen (error_string);           END;  { ELSE of IF (nft1000_error }         END;  { InsertLocalErrorMsg }      $Page   #   {----------------------------------------------------------------}  # #   { (Local)             INSERT TARGET FILE NAME            (Local) }  # #   {----------------------------------------------------------------}  # "   { Insert the target file name in to the message buffer. The byte  " "   { index of the start of the target file name is passed in and the "     { index of the next free byte following the name is returned.      {  !   { If the target file is open, that is, the transfer request was ! !   { acceptable, then ask the file system for the full pathname to ! !   { the target file, otherwise return the name the user gave us.  !     { Note that if we have decided to use a scratch file for the    !   { target file then we will not want to return the scratch file  !    { name in the pathname the file system gives us.      {     { Parameters:     {     {     target_file_info (Input)   !   {        Inputs the name of the target file that we built from  ! !   {        the user's name and the source file name (see routine  !    {        CalculateFileOrDirName).     {     {     target_file_ptr (Input)  "   {        Inputs a byte index to the byte in the msg_buffer where  "    {        target file name should be placed      {     {     end_target_ptr (Output)  "   {        Returns a byte index into msg_buffer where the next free "    {        character is following the target file name      {}      PROCEDURE  InsertTargetFileName        (VAR target_file_info : TargetFileInfoType;              target_file_ptr  : Int16;         VAR end_target_ptr   : Int16);          VAR        file_name         : String16;         file_name_descr   : FmpStringType;        fmpfilename_error : Int16;        index             : Int16;        pathname          : FullPathnameString;         pathname_descr    : FmpStringType;        typex             : String4;        typex_descr       : FmpStringType;         BEGIN        WITH pathname_buffers, target_file_info DO           BEGIN  "         { If target file is open then get a fully qualified name }  "          IF tfi_file_is_open THEN   	            BEGIN  	             pathname_descr := StringDescr64 (pathname, 1,   !                                             MAX_1000_PATH_CHARS); !             FmpFileName (dcb_and_interch_record.dir_dcb,                           fmpfilename_error, pathname_descr);                  IF fmpfilename_error = 0 THEN   
               BEGIN 
                file_name_descr := StringDescr16 (file_name, 1,  #                                                 MAX_1000_FILE_CHARS); #                typex_descr     := StringDescr4  (typex, 1,  !                                                 MAX_TYPEX_CHARS); !     $               { If we are using a scratch file then pull out the user } $ $               { given file name and type extention and use them.      } $                IF tfi_using_scratch THEN                    BEGIN   "                  FmpParsePath (tfi_actual_descr, pb_dirpath_descr,  "                                 file_name_descr, typex_descr,                                    pb_qualifier_descr, pb_sec_code,   $                                pb_file_type, pb_file_size, pb_rec_len,  $                                 pb_ds_descr);       "                  { Now pull apart the full pathname we got above }  " !                  FmpParsePath (pathname_descr, pb_dirpath_descr,  ! !                                pb_filename_descr, pb_typex_descr, !                                  pb_qualifier_descr, pb_sec_code,   $                                pb_file_type, pb_file_size, pb_rec_len,  $                                 pb_ds_descr);       #                  { Clear the file type, file size and reclen fields } #                   pb_file_type := 0;                    pb_file_size := 0;                    pb_rec_len   := 0;                        { Throw the pathname back together }  !                  FmpBuildPath (pathname_descr, pb_dirpath_descr,  !                                 file_name_descr, typex_descr,                                    pb_qualifier_descr, pb_sec_code,   $                                pb_file_type, pb_file_size, pb_rec_len,  $                                 pb_ds_descr);                     END  { IF tfi_using }   
               ELSE  
                   BEGIN                     { Pull apart the fully qualified pathname }   !                  FmpParsePath (pathname_descr, pb_dirpath_descr,  ! !                                pb_filename_descr, pb_typex_descr, !                                  pb_qualifier_descr, pb_sec_code,   $                                pb_file_type, pb_file_size, pb_rec_len,  $                                 pb_ds_descr);       $                  { Clear the file type, file size and rec len fields }  $                   pb_file_type := 0;                    pb_file_size := 0;                    pb_rec_len   := 0;                        { Now put it back together }  !                  FmpBuildPath (pathname_descr, pb_dirpath_descr,  ! !                                pb_filename_descr, pb_typex_descr, !                                  pb_qualifier_descr, pb_sec_code,   $                                pb_file_type, pb_file_size, pb_rec_len,  $                                 pb_ds_descr);                     END;  { ELSE of IF tfi_using }                 END;  { IF fmpfilename_error }               END;  { IF tfi_file_is_open }       
         index := 0; 
     "         { If we got a fully qualified name above then stick that }  " "         { into the message, else insert what the user gave us    }  "          IF tfi_file_is_open AND (fmpfilename_error = 0) THEN   	            BEGIN  	             WHILE (index < MAX_1000_PATH_CHARS) AND                     (pathname [index] <> SPACE)   DO  
               BEGIN 
                { Insert fully qualified name }                 msg_buffer.chars [target_file_ptr + index] :=                    pathname [index];                  index := index +1;                  END;  { WHILE (index }               END  { IF tfi_file_is_open }           ELSE   	            BEGIN  	             WHILE (index < MAX_1000_PATH_CHARS)       AND                     (tfi_actual_name [index] <> SPACE) DO   
               BEGIN 
                { Insert user-given name }                  msg_buffer.chars [target_file_ptr + index] :=                    tfi_actual_name [index];                 index := index +1;                  END;  { WHILE (index }               END;  { ELSE of IF tfi_file_is_open }                end_target_ptr := target_file_ptr + index;            END;  { WITH pathname_buffers }         END;  { InsertTargetFileName }       $Page   
BEGIN  { BuildAndSendMsg } 
        WITH msg_buffer, msg, msg_type, target_file_info DO        BEGIN          { These first two fields are part of the message header }          nft_type    := message_type;  
      protocol_id := NFT;  
     
      CASE message_type OF 
          AABORT:  	            BEGIN  	             WITH aabort_msg DO  
               BEGIN 
                msg_length_bytes := MIN_AABORT_BYTES;                  IF offer_msg_fields.omf_offer_type = OFFERT THEN                      BEGIN                     type_data_xferred   := DATA_UNIT_IS_BYTES;                    amount_data_xferred := tfi_current_word * 2;                    END { IF }  
               ELSE  
                   BEGIN                     type_data_xferred   := DATA_UNIT_IS_RECORDS;                    amount_data_xferred := tfi_records_written;                     END;  { ELSE of IF offer_msg_fields }                      END;  { WITH aabort_msg }              END;  { AABORT }               ADATA:   	            BEGIN  	             WITH adata_msg, target_file_info DO   
               BEGIN 
                nft_error_code := nft_error;                       IF offer_msg_fields.omf_offer_type = OFFERT THEN                      BEGIN                     type_data_xferred   := DATA_UNIT_IS_BYTES;                    amount_data_xferred := tfi_current_word * 2;                    END { IF }  
               ELSE  
                   BEGIN                     type_data_xferred   := DATA_UNIT_IS_RECORDS;                    amount_data_xferred := tfi_records_written;                     END;  { ELSE of IF offer_msg_fields }                      local_error_msg_ptr  := MIN_ADATA_BYTES;                      InsertLocalErrorMsg (nft1000_error, fmp_error,   "                                    msg_buffer, local_error_msg_ptr, "                                     temp_end_ptr);                     error_code_enhan_ptr := temp_end_ptr;                 end_ptr              := error_code_enhan_ptr;                     msg_length_bytes     := end_ptr;                  END;  { WITH adata_msg }               END;  { ADATA }       
         ADIRECTORY: 
 	            BEGIN  	             WITH adirectory_msg DO  
               BEGIN 
                nft_error_code       := nft_error;                  target_directory_ptr := MIN_ADIRECTORY_BYTES;                     { The target directory name is sitting in the }                 { tfi_actual_name field of target_file_info   }                 temp := MAX_1000_PATH_CHARS -1;                 WHILE (temp >= 0)                       AND                       (tfi_actual_name [temp] = SPACE) DO                    temp := temp -1;                 FOR temp1 := 0 TO temp DO                    chars [target_directory_ptr + temp1] :=                        tfi_actual_name [temp1];                      local_error_msg_ptr := target_directory_ptr +                                        temp + 1;                  InsertLocalErrorMsg (nft1000_error, fmp_error,   "                                    msg_buffer, local_error_msg_ptr, "                                     temp_end_ptr);                     error_code_enhan_ptr := temp_end_ptr;                 end_ptr              := error_code_enhan_ptr;                 msg_length_bytes     := end_ptr;                  END;  { WITH adirectory_msg }              END;  { ADIRECTORY }               AEOD:  	            BEGIN  	             msg_length_bytes := 4;  
            END;  { AEOD } 
              AINIT:   	            BEGIN  	             WITH ainit_msg DO   
               BEGIN 
                debug_flags.byt      := 0;                  misc_flags.byt       := 0;                  system_type          := RTE;                  op_sys_version       := 0;   !               buffer_size          := MIN((nft_buffer_words * 2), ! #                                       producer_info.pi_buffer_size);  #                capability_mask.word := 0;                  capability_mask.hierarchical_file_sys := TRUE;                  sys_specif_capa_mask := 0;                  nft_error_code       := nft_error;                  local_error_msg_ptr  := MIN_AINIT_BYTES;                      InsertLocalErrorMsg (nft1000_error, fmp_error,   "                                    msg_buffer, local_error_msg_ptr, "                                     temp_end_ptr);                     error_code_enhan_ptr := temp_end_ptr;                 end_ptr              := error_code_enhan_ptr;                     msg_length_bytes     := end_ptr;                  END;  { WITH ainit_msg }               END;  { AINIT }       	         AOFFERI:  	 	            BEGIN  	             WITH aofferi_msg, target_file_info DO   
               BEGIN 
                restart_id      := 0;                 nft_error_code  := nft_error;                 target_file_ptr := MIN_AOFFERI_BYTES;                     InsertTargetFileName (target_file_info,  "                                     target_file_ptr, temp_end_ptr); "                    local_error_msg_ptr := temp_end_ptr;                      InsertLocalErrorMsg (nft1000_error, fmp_error,   "                                    msg_buffer, local_error_msg_ptr, "                                     temp_end_ptr);                     error_code_enhan_ptr := temp_end_ptr;                 negoc_flags_ptr      := error_code_enhan_ptr;                     msg_buffer.bytes [negoc_flags_ptr]   := 0;                  msg_buffer.bytes [negoc_flags_ptr+1] := 0;                      number_buffers_ptr := negoc_flags_ptr + 2;   $               msg_buffer.bytes [number_buffers_ptr] := NFT_BURST_SIZE;  $                    end_ptr := number_buffers_ptr + 1;                  msg_length_bytes := end_ptr;                  END;  { WITH aofferi_msg }               END;  { AOFFERI }       	         AOFFERT:  	 	            BEGIN  	             WITH aoffert_msg DO   
               BEGIN 
                restart_id        := 0;                 nft_error_code    := nft_error;                 target_file_ptr   := MIN_AOFFERT_BYTES;                     InsertTargetFileName (target_file_info,  "                                     target_file_ptr, temp_end_ptr); "                    local_error_msg_ptr := temp_end_ptr;                      InsertLocalErrorMsg (nft1000_error, fmp_error,   "                                    msg_buffer, local_error_msg_ptr, "                                     temp_end_ptr);                     error_code_enhan_ptr := temp_end_ptr;                 sys_specific_msg_ptr := error_code_enhan_ptr;                 negoc_flags_ptr      := sys_specific_msg_ptr;                     msg_buffer.bytes [negoc_flags_ptr]   := 0;                  msg_buffer.bytes [negoc_flags_ptr+1] := 0;                      number_buffers_ptr := negoc_flags_ptr + 2;   $               msg_buffer.bytes [number_buffers_ptr] := NFT_BURST_SIZE;  $                    end_ptr := number_buffers_ptr + 1;                  msg_length_bytes := end_ptr;                  END;  { WITH aoffert_msg }               END;  { AOFFERT }       	         WARNING:  	 	            BEGIN  	             WITH warning_msg DO   
               BEGIN 
                nft_error_code       := nft_error;                  local_error_msg_ptr  := MIN_WARNING_BYTES;                      InsertLocalErrorMsg (nft1000_error, fmp_error,   "                                    msg_buffer, local_error_msg_ptr, "                                     temp_end_ptr);                     error_code_enhan_ptr := temp_end_ptr;                 end_ptr              := error_code_enhan_ptr;                     msg_length_bytes     := end_ptr;                  END;  { WITH }               END;  { WARNING }                END;  { CASE message_type }  "         message_length := msg_length_bytes; { Need a 32 bit word }  "       END;  { WITH msg_buffer }       	   ipc_flags := 0; 	    InitOpt (ipc_options, 0, error);   "   IpcSend (vc_socket_descr, msg_buffer, message_length, ipc_flags,  "             ipc_options, ipc_error);      
END;  { BuildAndSendMsg }  
         $Page   #{-------------------------------------------------------------------}  # #{                    CALCULATE FILE OR DIR NAME                     }  # #{-------------------------------------------------------------------}  # #{ Calculate the name of the target file or directory using the source  # "{ and target names given in one of the OFFER(I,T) or DIRECTORY msgs. " "{ Given the indices into the msg_buffer where the strings are, first "  { extract them and then slap them together using Calc_Dest_Name.   {   { Parameters:   {   {     msg_buffer (Input)   {        A message is sitting here (Offeri, Offert or Directory)   {        that contains source and target names or directories   {   {     source_name_start (Input)   !{        A char index into msg_buffer where the source_name begins ! {   {     target_name_start (Input)   !{        A char index into msg_buffer where the target_name begins ! {   {     end_target_name (Input)    {        A char index into msg_buffer where the target name ends   {   {     offer_msg_fields (Output)   {        Global record where the source name target names are   {        returned (omf_source_name and omf_target_name). The  {        source and target directory names are placed here  
{        temporarily also. 
 {   {     target_file_info (Output)    {        Global record that returns the full pathname built from   {        the source and target names (in tfi_actual_name).  {}  PROCEDURE  CalculateFileOrDirName      (VAR msg_buffer         : MsgBufferType;           source_name_start  : Int16;           target_name_start  : Int16;           end_target_name    : Int16;       VAR offer_msg_fields   : OfferMsgFieldsType;      VAR target_file_info   : TargetFileInfoType);       VAR      char_index        : Int16;      number_slashes    : Int16;      source_name_descr : FmpStringType;      target_name_descr : FmpStringType;      temp_descr        : FmpStringType;      temp_string       : String2;       BEGIN      WITH msg_buffer, offer_msg_fields, target_file_info DO         BEGIN         { Get descriptors to the offer_msg_fields fields }        source_name_descr  := StringDescr64 (omf_source_name, 1,                                              MAX_1000_PATH_CHARS);         target_name_descr  := StringDescr64 (omf_target_name, 1,                                              MAX_1000_PATH_CHARS);              { Pull out the SOURCE NAME the producer gave us. We must }          { blank fill it first so the Fmp string routines work    }         omf_source_name := ' ';         FOR char_index := 0 TO Min (target_name_start -                                     source_name_start,                                    MAX_1000_PATH_CHARS) -1 DO           BEGIN           omf_source_name [char_index] :=               chars [source_name_start + char_index];           END;  { FOR char_index }              { Pull out the TARGET NAME the producer gave us. We must }          { blank fill it first so the Fmp string routines work    }         omf_target_name := ' ';         FOR char_index := 0 TO Min (end_target_name -                                     target_name_start,                                    MAX_1000_PATH_CHARS) -1 DO           BEGIN           omf_target_name [char_index] :=               chars [target_name_start + char_index];           END;  { FOR char_index }       "      { Upshift the target file name in case it is returned in an }  " "      { Aoffer message (indirectly via tfi_actual_name).          }  "       CaseFold (omf_target_name, - MAX_1000_PATH_CHARS);      #      { Count up the number of slashes in the source name for use in } # #      { procedure Calc_Dest_Name. Note that all of the source and    } # #      { target names are used (nothing is chopped off). First count  } # #      { the number of slashes in the source name so we can give the  } # #      { correct "level" number to Calc_Dest_Name. By definition of   } # #      { the NFT Protocol specification, the name must be of the form } # #      { "FOO/BAR" and not BAR::FOO.                                  } # 
      number_slashes := 0; 
       FOR char_index := 0 TO MAX_1000_PATH_CHARS -1 DO           BEGIN           IF omf_source_name [char_index] = '/' THEN               number_slashes := number_slashes +1;           END;  { FOR }             { Fatten the target mask by inserting implied wildcards }          FattenMask (target_name_descr, 0);      #      { Using the source and target names, build a target pathname.  } # #      { Calc_Dest_Name is a documented Fmp routine. The last parm    } # #      { is an undocumented optional return parameter. This solves a  } # #      { problem regarding optional string parameters in CDS Fortran. } #       temp_descr := StringDescr2 (temp_string, 1, 2);         Calc_Dest_Name (source_name_descr, number_slashes,  $                      target_name_descr, tfi_actual_descr, temp_descr);  $       END;  { WITH msg_buffer }       END;  { CalculateFileOrDirName }          $Page   $Range Off  #{-------------------------------------------------------------------}  # #{                            CATCH ERROR                            }  # #{-------------------------------------------------------------------}  # "{ This is the Pascal error catcher procedure. If we are called then  " { just log an error and bailout.  {}  PROCEDURE  CatchError  $ALIAS 'PAS.ErrorCatcher'$      (error_type    : CatchErrorType;   
    error_number  : Int16; 
 
    line_number   : Int16; 
     file_name     : LogicalFileNameType;      file_name_len : Int16);       BEGIN      LogEvent (C_LOG_INTERNAL_ERROR, 1, state, Ord (error_type),               error_number, line_number);         CleanupAndTerminate;       
END;  { CatchError } 
         $Page   #{-------------------------------------------------------------------}  # #{                        CLEANUP AND TERMINATE                      }  # #{-------------------------------------------------------------------}  # "{ Close and purge any open target file and exit the program. We are  " !{ leaving the bulk of cleanup to the cleanup program. The cleanup  ! "{ program will shutdown our sockets, and log off the session we are  " !{ running in if pertinent. This has the benefit of not needing the ! "{ appended IpcShutDown call. Having the cleanup program shutdown the " #{ vc socket may take a few more seconds (up to a max of 5), but it is  # !{ not the normal mode of termination so we will not be delaying a  ! "{ normal transfer (the producer closes his end of the connection to  " { terminate a normal transfer).   {}  PROCEDURE  CleanupAndTerminate;       VAR      fmp_error   : Int16;       BEGIN       { Close and purge any open target file. If the open flag is }       { set then the file exists, else it does not so don't try   }       { to purge it. The target file may not exist if an error    }       { occurred during initialization                            }      IF target_file_info.tfi_file_is_open THEN        BEGIN         CloseScratchOrTargetFile (target_file_info, NOT_PERM,   "                                dcb_and_interch_record, fmp_error);  "       IF target_file_info.tfi_using_scratch THEN  "         fmp_error := FmpPurge (target_file_info.tfi_scratch_descr)  "       ELSE  "         fmp_error := FmpPurge (target_file_info.tfi_actual_descr);  "       END;  { IF target_file_info }          { Goto the end of the main routine }      GOTO 99;       END;  { CleanupAndTerminate }           $Page   #{-------------------------------------------------------------------}  # #{                   CLOSE SCRATCH OR TARGET FILE                    }  # #{-------------------------------------------------------------------}  # !{ Close the file whose Dcb is in dcb_and_interch_record. This Dcb  ! !{ is used for both the scratch and actual target file so we really ! !{ don't know which we are closing here. The flag tfi_file_is_open  ! "{ applies to both files so clear it also. If we've been accumulating " "{ directory info about the file then stuff it into the Dcb first so  " !{ Fmp will place it in the file directory upon closing. Also patch ! !{ the protection bits and the update time if pertinent. Lastly, if ! { requested, make the target file permanent.  {   { Parameters:   {   {     target_file_info (Input/Output)   !{        If we are accumulating directory info about the file then ! {        this record contains the info we will need   {   {     permanent_or_not (Input)  !{        Inputs either MAKE_PERM or NOT_PERM. If is MAKE_PERM then !  {        the temporary bit in the target file's directory entry    "{        should be cleared thereby making the file permanent. If is  " #{        NOT_PERM then nothing is done to the directory entry. Recall  # "{        that target files are made temporary so Fmp will purge them " {        if we abort prematurely.   {   {     dcb_and_interch_record (Input/Output)   {        Contains the target file Dcb   {   {     fmp_error (Output)  {        Returns any Fmp error that occurred  {}  PROCEDURE  CloseScratchOrTargetFile      (VAR target_file_info       : TargetFileInfoType;          permanent_or_not       : PermOrNotType;       VAR dcb_and_interch_record : DcbAndInterchRecordType;       VAR fmp_error              : Int16);      VAR      file_descr   : Int32;     fmp_error1   : Int16;  
   opts_buffer  : String2; 
    opts_descr   : FmpStringType;     owners_descr : FmpStringType;     others_descr : FmpStringType;      BEGIN   	   fmp_error := 0; 	        WITH dcb_and_interch_record, target_file_info DO         BEGIN         IF tfi_file_is_open THEN           BEGIN  !         { Note at this point that extent creation may have been } ! !         { suppressed. To prevent any complaints below, we will  } ! !         { allow extent creation. We are not writing data anyway } !          FmpAllowExtents (dir_dcb);                { If we have been keeping track of file information }           { then write it into the Dcb here before closing    }           WITH tfi_accumulated_info DO   	            BEGIN  	             IF tfi_accumulating_info THEN   "               FmpSetDcbInfo (dir_dcb, fmp_error, ai_number_records, " !                              ai_total_words, ai_max_rec_length);  !             END;  { WITH tfi_accumulated_info }                { Get the target file name for below }            IF tfi_using_scratch THEN              file_descr := tfi_scratch_descr            ELSE               file_descr := tfi_actual_descr;       "         { Patch up the protection bits and the update time if    }  " "         { this is a transparent transfer (not transient though)  }  " "         { and the source and target files are new types of files }  "          WITH offer_msg_fields, omf_hp1000_attributes.words DO  	            BEGIN  	             IF (omf_offer_type = OFFERT)   AND                 (NOT tfi_transient_storage) AND                 tfi_is_new_file             AND                 hpa_is_new_file             THEN   
               BEGIN 
                { First patch the update time ... }                 FmpSetDirInfo (dir_dcb, fmp_error1, -1, -1,                                hpa_update_time, -1, -1);                  IF fmp_error1 <> 0 THEN                    fmp_error := fmp_error1;      $               { And now the protection bits. Note that we could have  } $ $               { set the protection using the FmpSetDirInfo call, but  } $ $               { that would require us to know how the protection bits } $ $               { are allocated in the file directory entry. Ignore the } $ $               { error here. If we can't set the protection mode then  } $ $               { we must not own the file.                             } $ "               owners_descr := StringDescr2 (hpa_owners_access,1,2); " "               others_descr := StringDescr2 (hpa_others_access,1,2); "                fmp_error1 :=                    FmpSetProtection (file_descr, owners_descr,                                                   others_descr);                 END;  { IF omf_offer_type }              END;  { WITH offer_msg_fields }                { Close the target file }           FmpClose (dir_dcb, fmp_error1);           IF fmp_error1 <> 0 THEN              fmp_error := fmp_error1;      #         { Finally, if requested, make the target file permanent by }  # #         { clearing the temporary bit in the directory entry. We    }  # #         { will ignore errors here since this is pretty boring.     }  # "         IF (fmp_error = 0) AND (permanent_or_not = MAKE_PERM) THEN  " 	            BEGIN  	             { Open the file without the 'T' and 'X' options }               opts_buffer := 'RS';              opts_descr  := StringDescr2 (opts_buffer, 1, 2);  "            fmp_error1 := FmpOpen (dir_dcb, fmp_error1, file_descr,  "                                    opts_descr, 1);              FmpClose (dir_dcb, fmp_error1);               END;  { IF (fmp_error }                tfi_file_is_open := FALSE;            END;  { IF tfi_file_is_open }        END;  { WITH dcb_and_interch_record }       END;  { CloseScratchOrTargetFile }          $Page   #{-------------------------------------------------------------------}  # #{                      CREATE FULL DIR PATHNAME                     }  # #{-------------------------------------------------------------------}  # "{ Given the pathname to the target directory, create a full pathname " { by prepending the working directory onto it.  {   { Parameters:   {   {     target_file_info (Input/Output)   "{        The tfi_actual_name field carries in a directory name which " !{        may or may not be a full pathname (including the working  ! {        directory). If it is not a full pathname then it will  {        return the full pathname.  {}  PROCEDURE  CreateFullDirPathname     (VAR target_file_info   : TargetFileInfoType);       LABEL      99;   { Labels end of the procedure }      VAR      fmp_error   : Int16;      index       : Int16;      index1      : Int16;      temp_descr  : FmpStringType;      temp_name   : FullPathnameString;      BEGIN      WITH target_file_info DO         BEGIN          { Convert the partial directory name to hierarch format }          FmpHierarchName (tfi_actual_descr);              { Do nothing if the partial directory name appears to be }          { fully qualified already (if it begins with a slash).   }         IF tfi_actual_name [0] = '/' THEN   	         GOTO 99;  	           { Copy the partial directory name }   #      temp_descr := StringDescr64 (temp_name, 1, MAX_1000_PATH_CHARS); #       temp_name  := tfi_actual_name;            fmp_error := FmpWorkingDir (tfi_actual_descr);            IF fmp_error = 0 THEN            BEGIN  !         { Convert the working directory name to hierarch format } !          FmpHierarchName (tfi_actual_descr);      "         { Find the last non-blank character in the directory name } "          index := MAX_1000_PATH_CHARS -1;            WHILE tfi_actual_name [index] = SPACE DO               index := index -1;      !         { If the last non-blank is not a slash then make it one } !          IF (tfi_actual_name [index] <> '/') AND              (index < MAX_1000_PATH_CHARS -1) THEN   	            BEGIN  	             index := index +1;              tfi_actual_name [index] := '/';               END;  { IF }      !         { Append as much of the partial directory name onto the } ! !         { working directory as will fit.                        } !          index1 := 0;            FOR index := index +1 TO MAX_1000_PATH_CHARS -1 DO   	            BEGIN  	             tfi_actual_name [index] := temp_name [index1];              index1 := index1 +1;  
            END;  { FOR }  
          END;  { IF fmp_error }       
      END;  { WITH } 
     99:   END;  { CreateFullDirPathname }           $Page   #{-------------------------------------------------------------------}  # #{                        CREATE SCRATCH FILE                        }  # #{-------------------------------------------------------------------}  # #{ Given a pathname to the existing target file, create a scratch file  # !{ and place in the directory specified by the path to the existing ! #{ file. Most parms to this procedure are passed directly to procedure  # 
{ CreateTargetFile.  
 {   { Parameters:   {   {     interch_or_trans (Input)  "{        Of interest only to CreateTargetFile. See him for more info " {   {     existing_name (Input)    {        This carries in the desired pathname. The scratch file     {        name we create will be placed in the directory given in   {        this pathname.   {   {     target_file_info (Input/Output)   !{        Global record which contains info about the target file.  ! "{        The name of the scratch file is placed in tfi_scratch_name  " {   {     number_dcb_buffers (Input)  "{        Of interest only to CreateTargetFile. See him for more info " {   
{     scratch_type (Input) 
  {        The HP1000 file type to be inserted in the namr if the    {        user did not supply a file type in existing_name   {   
{     scratch_size (Input) 
 !{        The file size to be inserted in the namr if the user did  ! !{        not supply a file size in existing_name. The value is in  ! {        (+ Blocks) or (- Chunks)   {   
{     scratch_rlen (Input) 
 !{        The record length to be inserted in the namr if the user  ! "{        did not supply a record length in existing_name (in words)  " {   
{     forced_parms (Input) 
  {        Of interest only to CreateTargetFile. See him for info    {   {     fmp_error (Output)  {        Returns an Fmp error if non-zero   {   {     nft_error (Output)  {        Returns an Nft error code if non-zero  {}  PROCEDURE  CreateScratchFile     (    interch_or_trans   : Int16;       VAR existing_name      : FullPathnameString;      VAR target_file_info   : TargetFileInfoType;          number_dcb_buffers : Int16;           scratch_type       : Int16;           scratch_size       : Int16;           scratch_rlen       : Int16;           forced_parms       : ForcedParamsType;      VAR fmp_error          : Int16;       VAR nft_error          : Int16);      VAR      existing_descr : FmpStringType;     prefix_descr   : FmpStringType;      BEGIN      existing_descr := StringDescr64 (existing_name, 1,                                       MAX_1000_PATH_CHARS);      prefix_descr   := StringDescr2  ('DS', 1, 2);         REPEAT         WITH pathname_buffers, target_file_info DO           BEGIN           { Pull apart the file pathname }            FmpParsePath (existing_descr, pb_dirpath_descr,                         pb_filename_descr, pb_typex_descr,   #                       pb_qualifier_descr, pb_sec_code, pb_file_type,  #                        pb_file_size, pb_rec_len, pb_ds_descr);      "         { Create a unique file name. Note that we have to use the } " "         { directory path given to us so that the scratch file is  } " "         { placed in the correct directory                         } "          FmpUniqueName (prefix_descr, pb_filename_descr);            pb_typex_buffer := 'TMP ';                { Put it all back together with the new file name }           FmpBuildPath (tfi_scratch_descr, pb_dirpath_descr,                          pb_filename_descr, pb_typex_descr,   #                       pb_qualifier_descr, pb_sec_code, pb_file_type,  #                        pb_file_size, pb_rec_len, pb_ds_descr);           END;  { WITH pathname_buffers }      "      CreateTargetFile (CREATE, interch_or_trans, target_file_info.  "                         tfi_scratch_name, target_file_info,                           number_dcb_buffers, scratch_type,   !                        scratch_size, scratch_rlen, forced_parms,  !                         fmp_error, nft_error);         UNTIL (nft_error <> TARGET_FILE_EXISTS);           { Set the flag which indicates we are using a scratch file  }       { Note that the name of the scratch file that was built was }       { placed in tfi_scratch_name above                          }      target_file_info.tfi_using_scratch := nft_error = 0;       END;  { CreateScratchFile }           $Page   #{-------------------------------------------------------------------}  # #{                         CREATE TARGET FILE                        }  # #{-------------------------------------------------------------------}  # "{ A file namr is given to this procedure. In this namr there may be  " !{ user-specified qualifiers (type, size, record length). If any of ! !{ these fields are not present then insert those qualifiers which  ! !{ are given as parameters. The type of open options will depend on ! "{ whether a transfer is transparent or interchange, and whether the  " { the file should be created or just opened.  {   { Parameters:   {   {     create_or_open (Input)  "{        Indicates whether the FmpOpen options should be set up for  " !{        file creation or just open. The open options will be used ! {        to check for write access to the file  {   {     interch_or_trans (Input)  {        Indicates what type of options should be used for the  "{        FmpOpen call based on the type of transfer. Will be either  " {        INTERCHANGE or TRANSPARENT   {   
{     old_pathname (Input) 
 !{        This carries in the desired pathname. Any file qualifiers ! !{        in this pathname were user specified so they will be used ! {        if they are present.   {   {     target_file_info (Input/Output)    {        Global record which contains info about the target file   {        The Dcb is used for the FmpOpen call. Tfi_is_new_file  {        returns true if the file is not on a cartridge   {   {     number_dcb_buffers (Input)  {        Specifies how many Dcb buffers should be used for the   {        file. Will be either MIN_DCB_BUFFERS or MAX_DCB_BUFFERS   {        or 0, depending on the transfer type. Recall that the  {        Dcb buffer area is used by us for transparent mode,   {        not Fmp. This is because we treat all files as type 1.    {   {     new_file_type (Input)    {        The HP1000 file type to be inserted in the namr if the    {        user did not supply a file type in old_pathname  {   {     new_file_size (Input)   !{        The file size to be inserted in the namr if the user did  !  {        not supply a file size in old_pathname. The value is in   {        (+ Blocks) or (- Chunks)   {   {     new_rec_length (Input)  !{        The record length to be inserted in the namr if the user  ! !{        did not supply a record length in old_pathname (in words) ! {   
{     forced_parms (Input) 
 !{        Can be one of three values to indicate whether SOME, ALL  ! {        or NONE of the "new_xxx" parameters to this procedure  !{        should be given precedence over any user-given parameters ! !{        in the target pathname. A value of ALL may indicate that  ! !{        the source file is sparse or we are storing transiently,  ! !{        and letting the user specify params here is dangerous. A  ! {        value of SOME indicates that we are creating a direct   {        access file in interchange mode, and some params should   {        not be left up to the user.  {   {     fmp_error (Output)  {        Returns an Fmp error if non-zero   {   {     nft_error (Output)  {        Returns an Nft error code if non-zero  {}  PROCEDURE  CreateTargetFile      (    create_or_open     : CreateOrOpenType;          interch_or_trans   : Int16;       VAR old_pathname       : FullPathnameString;      VAR target_file_info   : TargetFileInfoType;          number_dcb_buffers : Int16;           new_file_type      : Int16;           new_file_size      : Int16;           new_rec_length     : Int16;           forced_params      : ForcedParamsType;      VAR fmp_error          : Int16;       VAR nft_error          : Int16);      VAR   "   info_flag      : Int16;              { For the FmpInfo call     } " "   new_pathname   : FullPathnameString; { New target namr string   } " "   dummy_entry    : FileDirectoryType;  { Used in the FmpInfo call } "    new_path_descr : FmpStringType;     old_path_descr : FmpStringType;     opts_buffer    : String5;     opts_descr     : FmpStringType;      BEGIN      new_path_descr := StringDescr64 (new_pathname, 1,                                      MAX_1000_PATH_CHARS);      old_path_descr := StringDescr64 (old_pathname, 1,                                      MAX_1000_PATH_CHARS);      opts_descr     := StringDescr5  (opts_buffer, 1, 5);          WITH pathname_buffers, dcb_and_interch_record,           offer_msg_fields, target_file_info    DO        BEGIN   !      { Pull out all but file_type, file_size and record_length }  !       FmpParsePath (old_path_descr, pb_dirpath_descr,                       pb_filename_descr, pb_typex_descr,  !                    pb_qualifier_descr, pb_sec_code, pb_file_type, !                     pb_file_size, pb_rec_len, pb_ds_descr);             IF forced_params = SOME THEN           BEGIN            { We are creating a direct access file in interchange }             { mode. User params must be within reason             }            IF (pb_file_type = 1) OR (pb_file_type = 2) THEN               new_file_type := pb_file_type;           IF pb_file_size <> 0 THEN              new_file_size := pb_file_size;           END;  { IF forced_params }             IF forced_params = NONE THEN           BEGIN            { We can use any of the user-specified params. If any }             { any were user specified then use them               }            IF pb_file_type <> 0 THEN              new_file_type := pb_file_type;           IF pb_file_size <> 0 THEN              new_file_size := pb_file_size;           IF pb_rec_len <> 0 THEN              new_rec_length := pb_rec_len;            END;  { IF forced_params }              { Now put the pathname back together with the new fields }         FmpBuildPath (new_path_descr, pb_dirpath_descr,                       pb_filename_descr, pb_typex_descr,  "                    pb_qualifier_descr, pb_sec_code, new_file_type,  "                      new_file_size, new_rec_length, pb_ds_descr);       !      { Set up the options buffer based on the parameters. Note  } ! !      { that for the create options, we are setting the temp bit } ! !      { in the directory entry. This will cause Fmp to purge the } ! !      { target file if we abort before closing it. We must clear } ! !      { this bit when the transfer is done.                      } !       CASE interch_or_trans OF           INTERCHANGE:   	            BEGIN  	             CASE create_or_open OF                 CREATE: opts_buffer := 'WCXT ';                 OPEN:   opts_buffer := 'WOX  ';                 END;  { CASE }               END;  { INTERCHANGE }                TRANSPARENT:   	            BEGIN  	             CASE create_or_open OF                 CREATE: opts_buffer := 'WCXFT';                 OPEN:   opts_buffer := 'WOXF ';                 END;  { CASE }               END;  { TRANSPARENT }            END;  { CASE }       "      tfi_file_type := FmpOpen (dir_dcb, fmp_error, new_path_descr,  "                                  opts_descr, number_dcb_buffers);             target_file_info.tfi_file_is_open := fmp_error >= 0;            IF fmp_error = FMP_DUPLICATE_FILE_NAME THEN            BEGIN           nft_error := TARGET_FILE_EXISTS;            fmp_error := 0;           END        ELSE IF fmp_error < 0 THEN           nft_error := CANT_OPEN_TARGET_FILE         ELSE           BEGIN  "         { The open must have succeeded - the fmp_error was zero. }  " "         { Now find out if the file is a new type file. We don't  }  " "         { care about the directory entry that is returned here.  }  "          FmpInfo (dcb_and_interch_record.dir_dcb, fmp_error,                    dummy_entry, info_flag);                   tfi_is_new_file := info_flag <> 0;            IF fmp_error = 0 THEN  
            nft_error := 0 
          ELSE               nft_error := CANT_ACCESS_TARGET_FILE;            END;  { IF fmp_error }         END;  { WITH pathname_buffers }       
END;  { CreateTargetFile } 
         $Page   #{-------------------------------------------------------------------}  # #{                          EVENT HANDLER                            }  # #{-------------------------------------------------------------------}  # !{ Call the appropriate procedure to handle the event in the given  ! "{ state. If the state variable is passed into a procedure, the state " { actually branched to is a result of handling the event.   {   { Parameters:   {   
{     state (Input/Output) 
 {        Global variable indicating the current state   {   
{     event (Input)  
 {        Global variable indicating the event that occurred   {   {     msg_buffer (Input/Output)   !{        Global message buffer. Based on the event, may or may not !  {        carry in an Nft message. May be used to build a message   {   {     ipc_error (Input)   {        Gives the ipc_error that occurred if non-zero  {}  PROCEDURE  EventHandler      (VAR state      : StateTypes;      VAR event      : Int16;       VAR msg_buffer : MsgBufferType;       VAR ipc_error  : Int32);      VAR   
   fmp_error      : Int16; 
 
   fmp_error1     : Int16; 
 
   nft1000_error  : Int16; 
 
   nft_error      : Int16; 
    others_access  : String2;     others_descr   : FmpStringType;     owners_access  : String2;     owners_descr   : FmpStringType;     perm_or_not    : PermOrNotType;      BEGIN   
   fmp_error  := 0;  
 
   fmp_error1 := 0;  
 
   nft_error  := 0;  
        CASE state OF        IDLE:            BEGIN           CASE event OF  "            { These messages must be ignored due to the asynch-   }  " "            { ronous nature of the protocol. See the NFT Protocol }  " "            { Specification for more info                         }  "             ABORTMSG, CANCEL, DATA, EOD: ;                  DIRECTORY:  
               BEGIN 
 #               { First extract the source and target directory names } # #               { and build the target directory pathname from them.  } #                WITH msg_buffer.msg.directory_msg DO                     BEGIN                     { Build the target directory name }                     CalculateFileOrDirName                       (msg_buffer, source_directory_ptr,                          target_directory_ptr, system_specific_ptr,                         offer_msg_fields, target_file_info);                    END;  { WITH }                     fmp_error := FmpCreateDir (target_file_info.                                              tfi_actual_descr, 0);                   IF fmp_error <> 0 THEN                     nft_error := ERROR_CREATING_DIRECTORY   
               ELSE  
                   BEGIN                     nft_error := 0;       #                  { If the producer is an HP 1000 then he will have }  # #                  { placed the protection mode for the directory in }  # #                  { the system_specific_info string.                }  #                   IF producer_info.pi_system_type = RTE THEN  
                     BEGIN 
 $                     owners_descr := StringDescr2 (owners_access, 1, 2); $ $                     others_descr := StringDescr2 (others_access, 1, 2); $                          WITH msg_buffer, msg.directory_msg DO                          BEGIN                           owners_access [0] := chars  "                                             [system_specific_ptr];  "                         owners_access [1] := chars  $                                             [system_specific_ptr + 1];  $                         others_access [0] := chars  $                                             [system_specific_ptr + 2];  $                         others_access [1] := chars  $                                             [system_specific_ptr + 3];  $                         END;  { WITH }      $                     { Ignore any errors since we may not be the owner } $ $                     { of the directory (although we can create it if  } $ $                     { we are not the owner).                          } $                      fmp_error1 := FmpSetProtection   %                                      (target_file_info.tfi_actual_descr,  % "                                       owners_descr, others_descr);  "                      END;  { IF producer }                    END;  { ELSE of IF fmp_error }      #               { Prepend the working directory onto the directory so } # #               { the user will see the full target pathname.         } #                CreateFullDirPathname (target_file_info);      "               BuildAndSendMsg (ADIRECTORY, nft_error, 0, fmp_error, "                                 ipc_error);                  IF ipc_error <> 0 THEN                     BEGIN   %                  LogEvent (C_LOG_SEND_ERROR, 1, state, ipc_error, 0, 0);  %                   CleanupAndTerminate;                    END;  { IF }                 END;  { DIRECTORY }      
            OFFERI:  
 
               BEGIN 
                ReceiveOfferi (msg_buffer, nft1000_error,                                fmp_error, nft_error);                     { Set the new state based on what happened }                  IF nft_error = 0 THEN                    state := WAIT_FOR_DATA  
               ELSE  
                   state := IDLE;                     { Reply to the Offeri by sending an Aofferi }  !               BuildAndSendMsg (AOFFERI, nft_error, nft1000_error, !                                 fmp_error, ipc_error);                 IF ipc_error <> 0 THEN                     BEGIN   %                  LogEvent (C_LOG_SEND_ERROR, 2, state, ipc_error, 0, 0);  %                   CleanupAndTerminate;                    END;  { IF }                 END;  { OFFERI }       
            OFFERT:  
 
               BEGIN 
                 ReceiveOffert (msg_buffer, fmp_error, nft_error);                      { Set the new state based on what happened }                  IF nft_error = 0 THEN                    state := WAIT_FOR_DATA  
               ELSE  
                   state := IDLE;                     { Reply to the Offert by sending an Aoffert }  !               BuildAndSendMsg (AOFFERT, nft_error, 0, fmp_error,  !                                 ipc_error);                  IF ipc_error <> 0 THEN                     BEGIN   %                  LogEvent (C_LOG_SEND_ERROR, 3, state, ipc_error, 0, 0);  %                   CleanupAndTerminate;                    END;  { IF }                 END;  { OFFERT }                   P_C_CONNECTION_DOWN:  
               BEGIN 
                { This is the normal termination case }                 IF ipc_error <> IPC_ERR_PEER_ABORTED THEN  %                  LogEvent (C_LOG_RECV_ERROR, 1, state, ipc_error, 0, 0);  %                CleanupAndTerminate;                  END;  { P_C_CONNECTION_DOWN }                  OTHERWISE   
               BEGIN 
                { Invalid event occurred }   !               LogEvent (C_LOG_BAD_EVENT, 1, state, event, 0, 0);  !                CleanupAndTerminate;   
               END;  
             END;  { CASE event }           END;  { IDLE }       
      WAIT_FOR_DATA: 
          BEGIN           CASE event OF              ABORTMSG:   
               BEGIN 
 "               { If the target file is not a scratch file then it }  " "               { will not be purged below so make it permanent.   }  "                IF target_file_info.tfi_using_scratch THEN                     perm_or_not := NOT_PERM   
               ELSE  
                   perm_or_not := MAKE_PERM;       $               CloseScratchOrTargetFile (target_file_info, perm_or_not,  $                                           dcb_and_interch_record,                                            fmp_error);                     IF fmp_error <> 0 THEN                     nft_error := CANT_CLOSE_TARGET_FILE;                     { If using a scratch file then purge it, else }                 { leave the partial target file around        }                 IF target_file_info.tfi_using_scratch THEN                     fmp_error1 := FmpPurge (target_file_info.                                             tfi_scratch_descr);                          IF fmp_error1 <> 0 THEN                    BEGIN                     fmp_error := fmp_error1;                    nft_error := CANT_PURGE_TARGET_FILE;                    END;  { IF }      !               { If any Fmp error occurred in handling the Abort } ! !               { then return an Adata message else an Aabort     } !                IF fmp_error = 0 THEN                    BuildAndSendMsg (AABORT, 0, 0, 0, ipc_error)  
               ELSE  
                   BEGIN   !                  BuildAndSendMsg (ADATA, nft_error, 0, fmp_error, !                                    ipc_error);                    END;  { ELSE of IF fmp_error }                     IF ipc_error <> 0 THEN                     BEGIN   %                  LogEvent (C_LOG_SEND_ERROR, 4, state, ipc_error, 0, 0);  %                   CleanupAndTerminate;                    END;  { IF }                     state := IDLE;                  END;  { ABORTMSG }       
            CANCEL:  
 
               BEGIN 
 "               CloseScratchOrTargetFile (target_file_info, NOT_PERM, "                                           dcb_and_interch_record,                                            fmp_error);                 IF fmp_error <> 0 THEN                     nft_error := CANT_CLOSE_TARGET_FILE;                     { Purge the target or scratch file whichever }                  { we are using for this transfer             }                  IF target_file_info.tfi_using_scratch THEN                     fmp_error1 := FmpPurge (target_file_info.                                             tfi_scratch_descr)  
               ELSE  
                   fmp_error1 := FmpPurge (target_file_info.                                             tfi_actual_descr);                         IF fmp_error1 <> 0 THEN                    BEGIN                     fmp_error := fmp_error1;                    nft_error := CANT_PURGE_TARGET_FILE;                    END;  { IF }                      { If any Fmp error occurred then send an Adata, }                   { else send an Aabort message                   }                  IF fmp_error = 0 THEN                    BuildAndSendMsg (AABORT, 0, 0, 0, ipc_error)  
               ELSE  
                   BEGIN   !                  BuildAndSendMsg (ADATA, nft_error, 0, fmp_error, !                                    ipc_error);                    END;  { ELSE }                     IF ipc_error <> 0 THEN                     BEGIN   %                  LogEvent (C_LOG_SEND_ERROR, 5, state, ipc_error, 0, 0);  %                   CleanupAndTerminate;                    END;  { IF ipc_error }                     state := IDLE;                  END;  { CANCEL }       	            DATA:  	 
               BEGIN 
 !               ReceiveData (state, msg_buffer, target_file_info);  !                END;  { DATA }                   EOD:  
               BEGIN 
                ReceiveEod (msg_buffer, target_file_info);                  state := IDLE;                  END;  { EOD }                  P_C_CONNECTION_DOWN:  
               BEGIN 
                IF ipc_error <> IPC_ERR_PEER_ABORTED THEN  %                  LogEvent (C_LOG_RECV_ERROR, 2, state, ipc_error, 0, 0);  %                CleanupAndTerminate;                  END;  { P_C_CONNECTION_DOWN }                  OTHERWISE   
               BEGIN 
                { Invalid event occurred }   !               LogEvent (C_LOG_BAD_EVENT, 2, state, event, 0, 0);  !                CleanupAndTerminate;   
               END;  
                 END;  { CASE event }           END;  { WAIT_FOR_DATA }  
      END;  { CASE state } 
     END;  { EventHandler }          $Page   #{-------------------------------------------------------------------}  # #{                            INITIALIZE                             }  # #{-------------------------------------------------------------------}  #  { The monitor has placed us in the correct session already so we    { don't need to attach. The monitor has placed the vc socket for   "{ the producer connection into our user record, and we know what the " !{ descriptor is. There should be a Rinit message hanging on the vc ! { socket. Consume the Rinit message.  {   { Parameters:   {   {     producer_info (Output)  !{        Global record which is built from the Rinit message that  ! {        the producer sent us   {   {     vc_socket_descr (Output)  "{        Returns the vc socket descriptor identifying the connection " {        to the producer  {}  PROCEDURE  Initialize      (VAR producer_info   : ProducerInfoType;       VAR vc_socket_descr : Int32);       VAR   
   data_length    : Int32; 
 
   dummy          : Int16; 
 
   ierror         : Int16; 
 
   ipc_error      : Int32; 
    session_key    : DsSessionKeyType;   
   wkmp           : Int16; 
     BEGIN      WITH target_file_info DO         BEGIN          { Must clear the file open flag in case we try to close }           { the file (in CleanupAndTerminate) before it is opened }          tfi_file_is_open  := FALSE;         tfi_actual_descr  := StringDescr64 (tfi_actual_name, 1,                                              MAX_1000_PATH_CHARS);          tfi_scratch_descr := StringDescr64 (tfi_scratch_name, 1,                                             MAX_1000_PATH_CHARS);          END;  { WITH target_file_info }           { Initialize string descriptors to the global buffers which }       { are used in FmpParseName and FmpBuildName                 }      WITH pathname_buffers DO         BEGIN          pb_dirpath_descr   := StringDescr64 (pb_dirpath_buffer, 1,                                               MAX_1000_PATH_CHARS);         pb_ds_descr        := StringDescr64 (pb_ds_buffer, 1,                                               MAX_1000_PATH_CHARS);   !      pb_filename_descr  := StringDescr16 (pb_filename_buffer, 1,  !                                             MAX_1000_FILE_CHARS);   !      pb_qualifier_descr := StringDescr40 (pb_qualifier_buffer, 1, !                                             MAX_QUALIFIER_CHARS);         pb_typex_descr     := StringDescr4  (pb_typex_buffer, 1,                                             MAX_TYPEX_CHARS);        END;  { WITH pathname_buffers }           { Get the socket descriptor for the vc socket. Before the   }       { Nft monitor scheduled us, he placed the vc socket for the }       { connection to the producer into our user record. We know  }       { that it is our only socket (besides the "root" socket) so }       { we know he placed the socket in slot number 1 of our user }       { record. This is a global variable.                        }      vc_socket_descr := 1;      $   { Go out to DSAM and get the NFT global that gives the buffer size }  $ $   { that the monitor used when setting up the connection. When we    }  $ $   { send the Ainit message to the Producer, we need to give him this.}  $ $   { If error occurs in accessing DSAM then bailout.                  }  $    DS_EnterCritical (wkmp, ierror);      IF ierror <> 0 THEN  
      CleanupAndTerminate; 
    DS_FetchGlobal (NFT_BUFF_SIZE, 1, nft_buffer_words);      DS_LeaveCritical (wkmp);       "   { Now consume the Rinit message which should be hanging on the }  " "   { socket in its entirety (the Nft monitor did not disturb the  }  " "   { message in any way).                                         }  " 
   ipc_flags   := 0; 
    data_length := nft_buffer_words * 2;      InitOpt (ipc_options, 0, ierror);      IpcRecv (vc_socket_descr, msg_buffer, data_length, ipc_flags,               ipc_options, ipc_error);      
   IF ipc_error <> 0 THEN  
       BEGIN   !      { We got an error in receiving the Rinit message. There is } ! !      { not much we can do so bailout.                           } !       LogEvent (C_LOG_RECV_ERROR, 3, state, ipc_error, 0, 0);   
      CleanupAndTerminate; 
       END      ELSE         BEGIN          { Build the producer_info record from the Rinit message }          WITH producer_info, msg_buffer.msg DO            BEGIN           pi_debug_flags       := rinit_msg.debug_flags;            pi_misc_flags        := rinit_msg.misc_flags;           pi_system_type       := rinit_msg.system_type;            pi_op_sys_version    := rinit_msg.op_sys_version;           pi_buffer_size       := rinit_msg.buffer_size;            pi_capability_mask   := rinit_msg.capability_mask;            END;  { WITH producer_info }         END;  { ELSE of IF ipc_error }         { All went ok so tell the producer the good news }      BuildAndSendMsg (AINIT, 0, 0, 0, ipc_error);          { If an error occurred in sending the Ainit then bailout }   
   IF ipc_error <> 0 THEN  
       BEGIN         LogEvent (C_LOG_SEND_ERROR, 6, state, ipc_error, 0, 0);   
      CleanupAndTerminate; 
 	      END;  { IF } 	        { Set the time out value for the socket to infinity }  
   ipc_flags   := 0; 
 
   data_length := 0; 
    InitOpt (ipc_options, 0, ierror);     IpcControl (vc_socket_descr, IPC_SET_TIME_OUT, 0, 2,                  dummy, data_length, ipc_flags, ipc_error);          IF ipc_error = 0 THEN        BEGIN { ok to set read threshold }  &      { The monitor has set our read threshold to MAX_BUFFER_BYTES. If    }  & &      { we leave it there and the producer sends a message longer than    }  & &      { that, we may complete a read with only a partial message. We will }  & &      { set the read threshold to the size the user specified as the NFT  }  & &      { buffer size on this node. This is the size that was used by the   }  & &      { monitor when this VC socket was created.                          }  &           IpcControl (vc_socket_descr, IPC_SET_READ_THRESHOLD,                    nft_buffer_words*2, 2, dummy, data_length,                    ipc_flags, ipc_error);        END;  { ok to set read threshold }      
END;  { Initialize } 
         $Page   #{-------------------------------------------------------------------}  # #{                             LOG EVENT                             }  # #{-------------------------------------------------------------------}  #  { Log an event to the log file. Currently all events are errors    { (no warnings).  {   { Parameters  {   {     nft_log_error_code (Input)  "{        An error code defined by NFT/1000 which indicates the cause " {        of the event.  {   {     instance (Input)  {        Gives the instance of the error code. This will be a   !{        different error code for each location where LogEvent is  ! {        called with the given nft_log_error_code.  {   
{     state (Input)  
 
{        The current state 
 {   
{     parm1 (Input)  
 "{        A parameter whose usage depends on the nft_fatal_error code " {   
{     parm2 (Input)  
 "{        A parameter whose usage depends on the nft_fatal_error code " {   
{     parm3 (Input)  
 "{        A parameter whose usage depends on the nft_fatal_error code " {}  
PROCEDURE  LogEvent  
    (nft_log_error_code : Int16;       instance           : Int16;       state              : StateTypes;      parm1              : Int32;       parm2              : Int32;       parm3              : Int32);      VAR      dummy       : ContextWords;     info_msg    : ARRAY [1..5] OF Int16;      result      : Int16;      wkmp        : Int16;       BEGIN      dummy.longint := 0;     info_msg [1]  := nft_log_error_code;      info_msg [2]  := Ord (state);  
   info_msg [3]  := parm1; 
 
   info_msg [4]  := parm2; 
 
   info_msg [5]  := parm3; 
        DS_EnterCritical (wkmp, result);          IF result = 0 THEN         BEGIN   "      Log_Event (EL_ERROR, HP_NFT, instance, dummy, 5, info_msg [1], " 
                 result);  
       DS_LeaveCritical (wkmp);  	      END;  { IF } 	     	END;  { LogEvent } 	         $Page   #{-------------------------------------------------------------------}  # #{                                MIN                                }  # #{-------------------------------------------------------------------}  #  { Return the minimum of the parameters. NOTE that this procedure    { will only return a quantity which is 16 bits since it is known    { from the point of call that one of the parameters must be less   { than 32768.   {}  FUNCTION Min      (first   : Int32;        second  : Int32)       : Int16;      BEGIN   
   IF first > second THEN  
 
      Min := second  
    ELSE   
      Min := first;  
     END;  { Min }           $Page   #{-------------------------------------------------------------------}  # #{                           RECEIVE DATA                            }  # #{-------------------------------------------------------------------}  # #{ A Data message has been received from the producer. Check what type  # !{ of transfer is proceeding and call the appropriate procedure to  ! { handle the data in the message.   {   { Parameters:   {   
{     state (Input/Output) 
 {        Global variable indicating the current state. Will   {        change as a result of how the data was handled   {   {     msg_buffer (Input/Output)   {        Global buffer which contains the Nft Data message  {        May be used to build and send a message  {   {     target_file_info (Input/Output)   {        Global record which contains info about target file  {}  PROCEDURE  ReceiveData     (VAR state            : StateTypes;      VAR msg_buffer       : MsgBufferType;       VAR target_file_info : TargetFileInfoType);       VAR   
   fmp_error      : Int16; 
 
   fmp_error1     : Int16; 
 
   ipc_error      : Int32; 
 
   nft1000_error  : Int16; 
 
   nft_error      : Int16; 
     BEGIN      fmp_error     := 0;     nft_error     := 0;     nft1000_error := 0;         { Check what type of transfer is proceeding }     CASE offer_msg_fields.omf_offer_type OF        OFFERT:            BEGIN  "         { Buffer contains data in transparent format - process it } "          ReceiveDataTransparent (msg_buffer, target_file_info,                                   dcb_and_interch_record,                                   fmp_error, nft_error);   
         END;  { OFFERT }  
           OFFERI:            BEGIN  "         { Buffer contains data in interchange format - process it } "          ReceiveDataInterchange (msg_buffer, target_file_info,                                   dcb_and_interch_record,  #                                 fmp_error, nft1000_error, nft_error); # 
         END;  { OFFERI }  
       END;  { CASE offer_msg_fields }          IF (fmp_error = 0) AND (nft1000_error = 0) THEN        state := WAIT_FOR_DATA     ELSE         BEGIN   "      { Note that we don't care about any Fmp errors below because } " "      { we would rather pass the error that was returned from the  } " "      { the ReceiveData routine above (it's more interesting)      } "           { Close the target file no matter what happened }         CloseScratchOrTargetFile (target_file_info, NOT_PERM,   "                                dcb_and_interch_record, fmp_error1); "     "      { Purge the scratch or actual file, whichever is being used }  "       IF target_file_info.tfi_using_scratch THEN  "         fmp_error1 := FmpPurge (target_file_info.tfi_scratch_descr) "       ELSE  "         fmp_error1 := FmpPurge (target_file_info.tfi_actual_descr); "           { Inform the producer of the error and go idle }  '      BuildAndSendMsg (ADATA, nft_error, nft1000_error, fmp_error, ipc_error); '       IF ipc_error <> 0 THEN           BEGIN            LogEvent (C_LOG_SEND_ERROR, 7, state, ipc_error, 0, 0);            CleanupAndTerminate;            END;  { IF }       
      state := IDLE; 
       END;  { ELSE of IF nft_error }      END;  { ReceiveData }           $Page   #{-------------------------------------------------------------------}  # #{                     RECEIVE DATA INTERCHANGE                      }  # #{-------------------------------------------------------------------}  # !{ This procedure handles data in interchange format. The format of ! "{ the data in the buffer is in accordance with what was agreed upon  " !{ in the Offeri/Aofferi handshake. If the agreed upon record size  ! !{ is larger than our agreed upon buffer size then this buffer may  ! { contain partial records. In this case a global record buffer   { is used to accumulate records before they are written out. If    !{ the agreed upon record size was less than the agreed upon buffer ! !{ size then no records can span across buffer boundaries and hence ! { records can be written out directly from the buffer.  {   {  Algorithm:   {   {     WHILE there is any data in the message DO   {        IF positioned to the start of a record THEN  {           IF there is a record header THEN  {              Process the header   {           IF whole record is present THEN   {              FmpWrite the record to disc from the message   {           ELSE   {              Move extant portion from message to record buffer   {        ELSE   {           Move amount of data equal to minimum of amount   {              needed to complete record, and amount in message    {              into the record buffer (appending if necessary)  {           IF record in record buffer is now complete THEN   {              FmpWrite the record to disc  {     END WHILE   {   {  Parameters:  {   {     msg_buffer (Input)   {        Global message buffer which carries in either a Data or   {        Eod message. Note that the Eod message may be empty.   {   {     target_file_info (Input/Output)   {        Global record containing info about the target file.   {   {     dcb_and_interch_record (Input/Output)    {        Global record containing the Dcb buffer, and the buffer    {        used to collect records which span message boundaries.    {   {     fmp_error (Output)  {        Returns any Fmp error if non-zero.   {   {     nft1000_error (Output)  {        Returns any NFT/1000 error if non-zero.  {   {     nft_error (Output)  {        Returns any Nft error if non-zero.   {}  PROCEDURE  ReceiveDataInterchange      (VAR msg_buffer             : MsgBufferType;       VAR target_file_info       : TargetFileInfoType;      VAR dcb_and_interch_record : DcbAndInterchRecordType;       VAR fmp_error              : Int16;       VAR nft1000_error          : Int16;       VAR nft_error              : Int16);      LABEL      99;   { Labels end of the procedure }      VAR      bytes_written        : Int16;     index                : Int16;     record_number        : TwoWordsAsOneType;     msg_buff_word_index  : Int16;     words_to_move        : Int16;      BEGIN      msg_buff_word_index := NFT_HEADER_SIZE_WORDS;      !   { Loop and process records until all of the data is exhausted } ! !   { Note we will exit if we have an empty Eod message           } !    WHILE (msg_buff_word_index * 2)      <             msg_buffer.msg.msg_length_bytes DO        BEGIN         WITH dcb_and_interch_record, offer_msg_fields,             target_file_info                      DO            BEGIN  #         { Check if we are positioned to the header of a new record }  # #         { in the msg_buffer. This global is initialized to (-1).   }  #          IF dir_record_word_index = -1 THEN   	            BEGIN  	 "            {---------------- STARTING NEW RECORD -----------------} " "            { We are positioned to a header (if exists) so process } "             IF omf_file_organiz = DIRECT THEN   
               BEGIN 
 #               { Grab and position to the record number. Recall that } # #               { interchange records start from 0, HP1000 starts at 1} #                record_number.upper_16bits :=                    msg_buffer.words [msg_buff_word_index];                  record_number.lower_16bits :=                     msg_buffer.words [msg_buff_word_index +1] +1;                       msg_buff_word_index := msg_buff_word_index +2;                      FmpSetPosition (dir_dcb, fmp_error,                                 record_number.full_32bits, -1);                         { Bailout on any error }                  IF fmp_error <> 0 THEN                     BEGIN                     nft_error := CANT_ACCESS_TARGET_FILE;   
                  GOTO 99; 
                   END;  { IF fmp_error }                 END;  { IF omf_file_organiz }                  IF omf_record_type = FIXED THEN   
               BEGIN 
 "               { Determine how many bytes should be written out.  }  " "               { Only for type 1 files can we write out more than }  " "               { one record at a time. If the interchange format  }  " "               { file matches the type 1 format then write out as }  " "               { many full blocks as are present.                 }  "                IF (target_file_info.tfi_file_type = 1)     AND                    (omf_record_len_bytes = BYTES_PER_BLOCK) AND                     (omf_file_organiz = SEQUENTIAL)          THEN                      BEGIN   "                  { We can write more than one record, so determine} " "                  { how many full blocks are there                 } "                   dir_record_length_bytes :=                       ((msg_buffer.msg.msg_length_bytes -  #                      (msg_buff_word_index * 2)) DIV BYTES_PER_BLOCK)  #                       * BYTES_PER_BLOCK;  "                  { If there is not a full block there, then there } " "                  { must be part of a block. This will normally not} " "                  { occur since our receive buffer will always be  } " "                  { larger than the size of a type 1 record (128   } " "                  { words) and therefore records should not be     } " "                  { split up. In a few bizarre cases, it may occur } " "                  { so we'll play it safe by telling the code below} " "                  { to save the partial block until the remainder  } " "                  { arrives.                                       } "                   IF dir_record_length_bytes = 0 THEN                         dir_record_length_bytes := BYTES_PER_BLOCK;                     END  { IF (target_file_info }   
               ELSE  
 !                  dir_record_length_bytes := omf_record_len_bytes; !                END   { IF omf_record_type = FIXED }               ELSE  
               BEGIN 
 !               { Variable length records. Grab the record length } ! !               { field we are positioned to. Ignore upper 16 bits} !                dir_record_length_bytes :=                     msg_buffer.words [msg_buff_word_index +1];      %               {  The following is to bullet proof the CONSUMER against }  % %               {  Producers who send records greater the MAX we can     }  % %               {  handle. This only occurs with a producer who sends    }  % %               {  records larger than the largest record specified in   }  % %               {  the OFFERI packet. Currently this is only true of a   }  % %               {  9000 producer.                                        }  %     !               IF (msg_buffer.words[msg_buff_word_index] <> 0) OR  !                   (msg_buffer.words[msg_buff_word_index + 1] >                     MAX_INTERCH_REC_BYTES) THEN                    BEGIN                     nft_error     := INSUFF_RESOURCES_TARGET;                     nft1000_error := RECORD_SIZE_TOO_BIG;   
                  goto 99; 
                   END;  { record too large }                 msg_buff_word_index := msg_buff_word_index +2;                  END;  { ELSE of IF omf_record_type }       #            { Now that we have processed the header, set the record }  # #            { index to indicate that we are ready for the data      }  #             dir_record_word_index := 0;       #            { If the whole record is present in the msg_buffer then }  # #            { write it all out directly from the msg_buffer here,   }  # #            { else move the partial record to the record buffer     }  # !            IF (msg_buff_word_index * 2) + dir_record_length_bytes ! !               <= msg_buffer.msg.msg_length_bytes             THEN ! 
               BEGIN 
                bytes_written :=                     FmpWrite (dir_dcb, fmp_error,   "                            msg_buffer.words [msg_buff_word_index],  "                             dir_record_length_bytes);                          { Bailout on any error }                  IF fmp_error <> 0 THEN                     BEGIN                     nft_error := WRITE_TO_TARGET_FAILED;  
                  GOTO 99; 
                   END;  { IF fmp_error }                     tfi_records_written := tfi_records_written + 1;                 { Get ready for the next record }                 dir_record_word_index := -1;                  msg_buff_word_index   := msg_buff_word_index +                     (dir_record_length_bytes +1) DIV 2;                  END   { IF (msg_buff_word_index }              ELSE  
               BEGIN 
 #               { We could not write out the record since it is not  }  # #               { all present. Move the first part of the record to  }  # #               { the record buffer until the rest arrives. This part}  # #               { of data must have an even number of bytes.         }  #                words_to_move :=                     (msg_buffer.msg.msg_length_bytes DIV 2) -                     msg_buff_word_index;                     { Move the partial record }                 FOR index := 0 TO words_to_move -1 DO                    BEGIN   "                  dir_interch_record.words [dir_record_word_index +  "                                             index] :=   "                     msg_buffer.words [msg_buff_word_index + index]; "                   END;  { FOR index }                      msg_buff_word_index   := msg_buff_word_index +                                           words_to_move;                  dir_record_word_index := dir_record_word_index +                                            words_to_move;                 END;  { ELSE of IF (msg_buff_word_index }                  END   { IF dir_record_word_index = -1 }            ELSE   	            BEGIN  	 #            {---------------- FINISH CURRENT RECORD -----------------} # #            { We are positioned somewhere within a record in the     } # #            { msg_buffer. The first part of the record may have been } # #            { written to the record buffer before (except if the     } # #            { record header was the last thing in the buffer before).} # #            { The entire remainder of the record may or may not be   } # #            { present. If remainder is there then write it all out   } #     #            { Move the amount of words equal to the minimum of the   } # #            { amount needed for the rest of the record and the amount} # #            { of data left in the msg_buffer                         } #             words_to_move :=  "               Min ( ((msg_buffer.msg.msg_length_bytes +1) DIV 2) -  "                       msg_buff_word_index,                       ((dir_record_length_bytes +1) DIV 2) -                         dir_record_word_index);                    { Move the part of the record to the record_buffer }               FOR index := 0 TO words_to_move -1 DO   
               BEGIN 
                 dir_interch_record.words [dir_record_word_index +                                            index] :=  !                  msg_buffer.words [msg_buff_word_index + index];  !                END;  { FOR index }                  msg_buff_word_index   := msg_buff_word_index +                                       words_to_move;               dir_record_word_index := dir_record_word_index +                                       words_to_move;   !            { If the record in the record buffer is now complete } ! !            { then write it all out here, else wait for the next } ! !            { data message to arrive                             } !             IF dir_record_word_index * 2 >=                  dir_record_length_bytes   THEN   
               BEGIN 
                bytes_written :=                     FmpWrite (dir_dcb, fmp_error,                               dir_interch_record.words [0],                               dir_record_length_bytes);                          { Bailout on any error }                  IF fmp_error <> 0 THEN                     BEGIN                     nft_error := WRITE_TO_TARGET_FAILED;  
                  GOTO 99; 
                   END;  { IF fmp_error }                      tfi_records_written   := tfi_records_written +1;                   { Get ready for the next record }                 dir_record_word_index := -1;                  END;  { IF dir_record_word_index }                   END   { ELSE of IF dir_record_word_index = -1 }            END;  { WITH dcb_and_interch_record }        END;  { WHILE (msg_buff_word_index }      99:   END;  { ReceiveDataInterchange }          $Page   #{-------------------------------------------------------------------}  # #{                     RECEIVE DATA TRANSPARENT                      }  # #{-------------------------------------------------------------------}  #  { One message containing data in transparent format has arrived.   "{ There are three different cases to consider concerning the format  " { of the data in the messages we receive:   {   {     1) A SPARSE FILE WHICH ORIGINATED ON THE HP1000    {        In this case the source file had missing extents on the   !{        source system, and to preserve the extent structure each  ! {        chunk of extent data will have a single 16-bit word   {        preceeding it which indicates what extent number it is.   {   {     2) A NON-SPARSE FILE WHICH ORIGINATED ON THE HP1000   !{        Data messages will contain the source file data in disc-  ! "{        image form and it is written to disc precisely as received. " {   {     3) A FILE BEING STORED TRANSIENTLY  {        The file data we receive is stored in the target file  !{        precisely the same as it is received. Note that the first !  {        block of the file contains the file attributes and was    {        written to disc when we received the Offert message  {   "{ Note that cases 2 and 3 can be handled the same way therefore they " "{ both reside in the same local procedure. For all cases above, the  " !{ target file is overridden as type 1 and the file data is written ! !{ out in blocks. The file data in all cases is first buffered in a ! "{ larger buffer and then written to disc to minimize disc accesses:  " {   {       msg_buffer           dcb_and_interch_record   {    +--------------+           +--------------+   {    | Data or Eod  | --------> | File data is | -------->  Disc   {    |   message    |           |  accumulated |  {    +--------------+           +--------------+  {   #{ For any message received containing transparent data, the amount of  # #{ data in the message is completely up to the producer system, except  # "{ for two stipulations. One is that only the very last message that  " !{ carries data can have an odd number of bytes. The other is that  ! "{ the maximum size of any message cannot be larger than our receive  " "{ buffer size (this was indicated in the Ainit message we sent him). " {    { If the producer is a non-HP1000 then either the source file is   !{ already stored in transient form AND/OR the target file is being ! { stored transiently.   {   { Parameters:   {   {     msg_buffer (Input)  {        Global message buffer which contains the Nft message.  {        Could be either a Data or Eod message  {   {     target_file_info (Input/Output)   {        Global record which contains info about target file  {   {     dcb_and_interch_record (Input/Output)   !{        Global record which contains two contiguous buffers: the  !  {        Dcb and interchange record buffers. We use both buffers   "{        together to accumulate file data before it is written out.  " !{        Some data may remain here across calls to this procedure  ! {   {     fmp_error (Output)   {        Gives the specific Fmp error code. If non-zero, it will   !{        be used to generate an error message string to be placed  ! {        in a message later returned to the producer  {   {     nft_error (Output)  !{        Returns any Nft error code if non-zero. Will be returned  ! {        to the producer if non-zero.   {}  PROCEDURE  ReceiveDataTransparent      (VAR msg_buffer              : MsgBufferType;      VAR target_file_info        : TargetFileInfoType;       VAR dcb_and_interch_record  : DcbAndInterchRecordType;      VAR fmp_error               : Int16;      VAR nft_error               : Int16);       $Page   #   {----------------------------------------------------------------}  # #   { (Local)           PROCESS DATA MISSING EXTENTS         (Local) }  # #   {----------------------------------------------------------------}  #     { We are receiving data messages for a file which has missing   #   { extents. In order to position the extents properly in the target  # "   { file, each extent is preceeded by a 16-bit extent number which  " "   { is used to position the file before the extent data is written  " "   { written to disc. The extent number words start from zero. Note  " "   { that extent number zero must always appear as it is the "main". "    {     { Algorithm:      {     {     REPEAT      {        IF positioned to an extent number word THEN   
   {           BEGIN 
    {           Allow extents to be created     {           FmpSetPosition to the desired extent      {           Disallow extent creation by FmpWrite below   	   {           END 	    {      {        Move words from message to packing buffer equal to:       {           Min (amount of data left in the message,       {                amount of space left in the packing buffer,    !   {                amount of data needed to complete the extent)  !    {     {        IF (positioned to an extent number word) OR      {           (the packing buffer area is full)     THEN       {           Accumulated extent so FmpWrite the packing buffer      {     {     UNTIL message data is exhausted     {}      PROCEDURE  ProcessDataMissingExtents;         LABEL        99;   { Labels end of the procedure }          VAR        block_to_position_to : Int32;         bytes_written        : Int16;         extent_size_words    : Int32;         index                : Int16;         max_dir_words        : Int16;         msg_buff_word_index  : Int16;         words_to_move        : Int16;          BEGIN         max_dir_words       := MAX_DCB_BUFFERS * WORDS_PER_BLOCK;          msg_buff_word_index := NFT_HEADER_SIZE_WORDS;       "      { If we have received a null Eod message then bail out. Any  } " "      { data in the packing buffers will have been written to disc } " "      IF msg_buff_word_index = msg_buffer.msg.msg_length_bytes THEN  " 	         GOTO 99;  	           WITH target_file_info,             dcb_and_interch_record,             offer_msg_fields.omf_hp1000_attributes.words DO           BEGIN  "         { Determine the size of each extent by converting from   }  " "         { (+Blocks or -Chunks) to +Blocks. Convert that to words }  "          extent_size_words := FmpExpandSize (hpa_file_size) *                                 WORDS_PER_BLOCK;           REPEAT   "            { If starting new extent then position to the extent  }  " "            { indicated by that extent number word. Skip the word }  " "            IF tfi_current_word MOD (extent_size_words +1) = 0 THEN  " 
               BEGIN 
                { A 1 must be added since blocks start from 1 }                 block_to_position_to :=                    msg_buffer.words [msg_buff_word_index] *                    (extent_size_words DIV WORDS_PER_BLOCK) +1;       !               { Since extents are not allowed to be created by  } ! !               { FmpWrite, that call may have set the Eof bit in } ! !               { the Dcb after the last write so clear it now    } !                FmpClearEof (dir_dcb);       "               { Allow extents to be created only by FmpSetPosition} " "               { since we know that particular extent is desired   } "                FmpAllowExtents (dir_dcb);       "               { Position to (therefore create) the desired extent}  "                FmpSetPosition (dir_dcb, fmp_error,                                 block_to_position_to, -1);                          { Bailout on any error }                  IF fmp_error <> 0 THEN                     BEGIN                     nft_error := CANT_ACCESS_TARGET_FILE;   
                  GOTO 99; 
                   END;  { IF fmp_error }                      { Don't allow extents to be created by FmpWrite }                  FmpNoExtents (dir_dcb);                     { Skip past the extent number word }                  msg_buff_word_index := msg_buff_word_index +1;                  tfi_current_word    := tfi_current_word +1;                 END;  { IF tfi_current_word }      !            { Move words to the packing buffer equal to min of: }  ! !            {    1) amount needed to complete the extent,       }  ! !            {    2) amount of data left in the message,         }  ! !            {    3) amount of free space left in packing buffer }  !             words_to_move :=                 Min ((msg_buffer.msg.msg_length_bytes DIV 2) -                       msg_buff_word_index,                      max_dir_words - dir_last_word_index);               words_to_move :=                 Min (words_to_move,                      extent_size_words - (tfi_current_word MOD   #                                         (extent_size_words +1)) +1);  #                 FOR index := 0 TO words_to_move -1 DO   
               BEGIN 
                dir_words [dir_last_word_index + index] :=   !                  msg_buffer.words [msg_buff_word_index + index];  !                END;  { FOR index }                  { Update all pertinent indices }              dir_last_word_index := dir_last_word_index +                                     words_to_move;               msg_buff_word_index := msg_buff_word_index +                                     words_to_move;               tfi_current_word    := tfi_current_word +                                      words_to_move;       #            { Determine whether packing buffer area should be posted } # #            { to disc. If we are positioned to an extent number word } # #            { then the previous extent must be completed so write the} # #            { buffer. Also post it if the buffer itself is full      } # "            IF (tfi_current_word MOD (extent_size_words + 1) = 0) OR " #               (dir_last_word_index = max_dir_words)              THEN # 
               BEGIN 
                bytes_written :=                     FmpWrite (dir_dcb, fmp_error, dir_words [0],                              dir_last_word_index * 2);           !               { Ignore Eof errors since extents were turned off } !                IF fmp_error = FMP_EOF_REACHED THEN                    fmp_error := 0                 ELSE IF fmp_error <> 0 THEN                    nft_error := WRITE_TO_TARGET_FAILED;                     dir_last_word_index := 0;                 END;  { IF fmp_error }                   { We are done when the message data is exhausted.}              { If an error occurred then bailout also         }           UNTIL (msg_buff_word_index * 2       =                   msg_buffer.msg.msg_length_bytes) OR                  (fmp_error <> 0);            END;  { WITH target_file_info }          99:     END;  { ProcessDataMissingExtents }          $Page   #   {----------------------------------------------------------------}  # #   { (Local)               PROCESS DATA NORMAL              (Local) }  # #   {----------------------------------------------------------------}  # !   { The data we are receiving is stored in the file in disc-image !     { blocks. The target file may be a transient file or a normal      { HP1000 file. Write the data to the file just as received.     {  !   { There is some special code needed to insure we do not get an  ! !   { an extra extent when we attempt to write out the last portion !     { of the data. Note that this code assumes the producer will    !   { not send more bytes than were given in Offert.file_size. This ! !   { restriction is in the Nft Protocol Specification, but it may  !     { have an impact in the future when the source file eminates       { from a non-disc device.     {     {  Algorithm:     {     {     REPEAT       {        Move words from message to packing buffer equal to:       {           Min (amount of data left in the message,       {                amount of space left in the packing buffer)       {     {        IF (packing buffer is full)            OR      {           ((message is Eod)                   AND     {            (there is data in packing buffer)) THEN   
   {           BEGIN 
    {           Handle special case of not creating extra,      {              undesired extent past end-of-file      {           FmpWrite out the packing buffer  	   {           END 	    {     {     UNTIL message is exhausted      {}      PROCEDURE  ProcessDataNormal;         LABEL        99;   { Labels end of procedure }          VAR        at_last_block           : BOOLEAN;        bytes_written           : Int16;        index                   : Int16;        max_dir_buffer_words    : Int16;        msg_buff_word_index     : Int16;        words_to_move           : Int16;        words_to_write          : Int16;         BEGIN        at_last_block        := FALSE;         max_dir_buffer_words := MAX_DCB_BUFFERS * WORDS_PER_BLOCK;         msg_buff_word_index  := NFT_HEADER_SIZE_WORDS;            WITH dcb_and_interch_record,             target_file_info,             msg_buffer.msg      DO            BEGIN           REPEAT   "            { Move amount of words from message to packing buffer }  " "            { equal to min of amount of data left in message and  }  " "            { amount of free space in the packing buffer          }  "             words_to_move :=                  Min (max_dir_buffer_words - dir_last_word_index,                        ((msg_length_bytes +1) DIV 2) -                         msg_buff_word_index);                   FOR index := 0 TO words_to_move -1 DO   
               BEGIN 
                dir_words [dir_last_word_index + index] :=   !                  msg_buffer.words [msg_buff_word_index + index];  !                END;  { FOR index }                  dir_last_word_index := dir_last_word_index +                                     words_to_move;               msg_buff_word_index := msg_buff_word_index +                                     words_to_move;       "            { The packing buffer should be posted when it is full }  " "            { or we have an Eod message and there is something in }  " "            { the packing buffer to write out                     }  "             IF (dir_last_word_index = max_dir_buffer_words) OR                  ((msg_buffer.msg.msg_type.nft_type = EOD)    AND                     (dir_last_word_index <> 0))                 THEN   
               BEGIN 
 !               { If we are accumulating directory info about the } ! !               { file then do it here before writing the data    } !                IF tfi_accumulating_info THEN                    BEGIN                      AccumulateFileInfo (dcb_and_interch_record, 0,                                         dir_last_word_index -1,                                         tfi_accumulated_info,                                         fmp_error);           !                  { An error indicates a bad record length word }  !                   IF fmp_error <> 0 THEN  
                     BEGIN 
                      nft_error := CANT_ACCESS_SOURCE_FILE;                       GOTO 99;                        END;  { IF fmp_error }                     END;  { IF target_file_info }       "               { If we are going to write anything into the last  }  " "               { block allocated to the file then Fmp will try to }  " "               { position ahead and create an undesired extent    }  " "               { afterwards. To prevent this, write everything    }  " "               { upto the last block first, turn off extents, and }  " "               { then write out the data in the last block.       }  " !               IF (tfi_current_word + dir_last_word_index) * 2 >=  ! "                  offer_msg_fields.omf_file_size_bytes         THEN  "                   BEGIN                     words_to_write :=   "                     ((dir_last_word_index -1) DIV WORDS_PER_BLOCK)  " "                                               *   WORDS_PER_BLOCK;  "                   dir_last_block_index := words_to_write;                     at_last_block        := TRUE;                     END   { IF (tfi_current_word }  
               ELSE  
                   BEGIN   #                  { We are not writing anything into the last block }  # #                  { so we can write the entire packing buffer safely}  #                   words_to_write      := dir_last_word_index;                     dir_last_word_index := 0;                     END;  { ELSE of IF (tfi_current_word }      #               { Write out the data if there is something to write. }  # #               { There would be nothing to write if only the last   }  # #               { block was in the packing buffer                    }  #                IF words_to_write > 0 THEN                     BEGIN                     bytes_written :=  !                     FmpWrite (dir_dcb, fmp_error, dir_words [0],  !                                words_to_write * 2);                             { Bailout on any error }                    IF fmp_error <> 0 THEN  
                     BEGIN 
                      nft_error := WRITE_TO_TARGET_FAILED;                        GOTO 99;                        END;  { IF fmp_error }                         tfi_current_word := tfi_current_word +                                        words_to_write;                     END;  { IF words_to_move }      "               { If we are going to write something into the last }  " "               { block then turn off extents first                }  "                IF at_last_block THEN                    BEGIN                     FmpNoExtents (dir_dcb);                     words_to_write := dir_last_word_index -                                       dir_last_block_index;                     bytes_written :=                       FmpWrite (dir_dcb, fmp_error,                                  dir_words [dir_last_block_index],                                  words_to_write * 2);                              { Ignore any Eof error since extents are off }                     IF fmp_error = FMP_EOF_REACHED THEN                        fmp_error := 0;                        { Write to target file failed }                     IF fmp_error <> 0 THEN  
                     BEGIN 
                      nft_error := WRITE_TO_TARGET_FAILED;                        GOTO 99;                        END;  { IF }                     END;  { IF at_last_block }                     END;  { IF (dir_last_word_index }      !            { We are done when the message is exhausted. At this } ! !            { point there may still be data in the packing buffer} ! !            { if we just processed a Data message. If it was an  } ! !            { Eod message then all data has been posted          } !          UNTIL (msg_buff_word_index * 2 >= msg_length_bytes);                END;  { WITH dcb_and_interch_record }         99:     END;  { ProcessDataNormal }      $Page   BEGIN  { ReceiveDataTransparent }       	   fmp_error := 0; 	 	   nft_error := 0; 	     "   { Call the appropriate routine to handle the data. Be carefull }  " "   { here - hpa_attributes are only valid if not transient storage}  "    IF (NOT target_file_info.tfi_transient_storage) AND        (offer_msg_fields.omf_hp1000_attributes.                          words.hpa_missing_extents) THEN         BEGIN         ProcessDataMissingExtents;        END  { IF (NOT }     ELSE         BEGIN         ProcessDataNormal;        END;  { ELSE of IF (NOT }       END;  { ReceiveDataTransparent }          $Page   #{-------------------------------------------------------------------}  # #{                            RECEIVE EOD                            }  # #{-------------------------------------------------------------------}  # !{ An end-of-data message has been received from the producer. The  !  { message signals the end of the file data. There may be an odd    !{ number of bytes, or there may be no data at all. Handle any data ! !{ then send the appropriate reply message to the producer. Lastly  ! { close the target file.  {   { Parameters:   {   {     msg_buffer (Input/Output)   {        Global buffer which carries in the Eod message which   {        in turn contains the last portion of the file data.  {        This buffer is also used to build and send a message   {   {     target_file_info (Input)  {        Global record containing info about the target file  {}  PROCEDURE  ReceiveEod      (VAR msg_buffer       : MsgBufferType;       VAR target_file_info : TargetFileInfoType);       VAR      reply_msg      : Int16;    { Either Aeod or Adata }  
   fmp_error      : Int16; 
 
   fmp_error1     : Int16; 
 
   fmp_error2     : Int16; 
 
   ipc_error      : Int32; 
 
   nft_error      : Int16; 
 
   nft1000_error  : Int16; 
    perm_or_not    : PermOrNotType;  
   position       : Int32; 
 
   record_number  : Int32; 
     BEGIN      fmp_error     := 0;     nft_error     := 0;     nft1000_error := 0;         { Check what type of transfer is proceeding }     CASE offer_msg_fields.omf_offer_type OF        OFFERT:            BEGIN  "         { Buffer contains data in transparent format - process it } "          ReceiveDataTransparent (msg_buffer, target_file_info,                                   dcb_and_interch_record,                                   fmp_error, nft_error);   
         END;  { OFFERT }  
           OFFERI:            BEGIN  "         { Buffer contains data in interchange format - process it } "          ReceiveDataInterchange (msg_buffer, target_file_info,                                   dcb_and_interch_record,  #                                 fmp_error, nft1000_error, nft_error); # 
         END;  { OFFERI }  
       END;  { CASE offer_msg_fields }       "   { If everything went ok so far then truncate any unused space  }  " "   { past the current file position before closing the file.      }  "        IF (fmp_error = 0) AND (nft1000_error = 0) AND  NOT           ((offer_msg_fields.omf_offer_type = OFFERI) AND            (offer_msg_fields.omf_interch_flags.fsize_forced)) THEN         BEGIN         { Get the current file position as a word offset }        FmpPosition (dcb_and_interch_record.dir_dcb, fmp_error,                      record_number, position);                IF (fmp_error = 0) THEN            BEGIN  !         { As of RTE-A Rev. 4.0, there is one case where a call  } ! !         { to FMPPosition does not function correctly. If we     } ! !         { have just written into the last word of a fixed       } ! !         { length (type 1 or 2) file, the file system will not   } ! !         { update the value of "position". This is a BUG in the  } ! !         { file system that is caused by their method of prevent-} ! !         { ing an extra extent from being created under such     } ! !         { conditions. To avoid this problem, we will calculate  } ! !         { the position ourselves for all fixed length files.    } ! !         { SR # 2200-036962                                      } !              CASE target_file_info.tfi_file_type OF            1:               BEGIN { type 1 }              position := (record_number - 1) * WORDS_PER_BLOCK;              END;  { type 1 }           2:               BEGIN { type 2 }              position := (record_number - 1) *   #                        (offer_msg_fields.omf_record_len_bytes DIV 2); #             END;  { type 2 }  
          OTHERWISE  
                BEGIN { type > 2 }   #               { For file types greater than type 2 we will use the }  # #               { position returned by the file system but add one   }  # #               { word to account for the required EOF marker. If    }  # #               { this is not done, we may truncate the EOF marker   }  # #               { from the end of the file.                          }  #                position := position + 1;                 END;  { type > 3 }               END;  { offeri }               { Convert the word position into a block position }           position := (position + WORDS_PER_BLOCK -1) DIV                        WORDS_PER_BLOCK;      "         { Beware that FmpTruncate does not always do what one     } " "         { would expect.                                           } "           FmpTruncate (dcb_and_interch_record.dir_dcb, fmp_error,                         position);           END;  { IF fmp_error }             IF fmp_error <> 0 THEN           nft_error := CANT_ACCESS_TARGET_FILE;        END;  { IF fmp_error }      !   { If no errors have occurred so far then make the target file } ! !   { permanent when closing it.                                  } !    IF nft_error = 0 THEN        perm_or_not := MAKE_PERM     ELSE         perm_or_not := NOT_PERM;         { Close the target file no matter what happened }     CloseScratchOrTargetFile (target_file_info, perm_or_not,   !                             dcb_and_interch_record, fmp_error1);  !             { If error here and no error occurred before then save it. }        { We would rather save any previous error if there was one }       IF (fmp_error1 <> 0) AND (nft_error = 0) THEN        BEGIN         fmp_error := fmp_error1;        nft_error := CANT_CLOSE_TARGET_FILE;        END;  { IF (fmp_error1 }      
   IF nft_error <> 0  THEN 
       BEGIN          { Error occurred in processing the last piece of data so }          { purge the target file or what exists of it. Note that  }          { we are ignoring the error on the purge since the error }          { that just occurred seems to be more important          }         IF target_file_info.tfi_using_scratch THEN  "         fmp_error1 := FmpPurge (target_file_info.tfi_scratch_descr) "       ELSE  "         fmp_error1 := FmpPurge (target_file_info.tfi_actual_descr); "       END  { IF fmp_error }      ELSE         BEGIN         WITH target_file_info DO           BEGIN  #         { If we are using a scratch file then purge the old target }  # #         { file which exists (in tfi_actual_name) and rename the    }  # #         { scratch file (tfi_scratch_name) to the existing file name}  #          IF tfi_using_scratch THEN  	            BEGIN  	             fmp_error := FmpPurge (tfi_actual_descr);                       IF fmp_error <> 0 THEN  
               BEGIN 
 !               { An error occurred in purging the original file. } ! !               { Don't leave the scratch file lying around. Also } ! !               { ignore any error in purging it                  } !                fmp_error1 := FmpPurge (tfi_scratch_descr);                 nft_error  := CANT_PURGE_TARGET_FILE;                 END   { IF }               ELSE  
               BEGIN 
                 { Rename the scratch file to the original name }                   FmpRename (tfi_scratch_descr, fmp_error1,                            tfi_actual_descr, fmp_error2);                         { Return any error that occurs in the rename }                  IF fmp_error1 <> 0 THEN                    fmp_error := fmp_error1   
               ELSE  
                   fmp_error := fmp_error2;                     { Return the corresponding Nft error }                  IF fmp_error <> 0 THEN                     nft_error := CANT_ACCESS_TARGET_FILE;                  END;  { ELSE of IF fmp_error <> 0 }                  END;  { IF tfi_using_scratch }           END;  { WITH target_file_info }        END;  { ELSE of IF fmp_error <> 0 }           { If nft_error is zero here then everything went ok and let }       { the producer in on the good news with an AEOD message,    }       { else send him an ADATA with the error that occurred       }      IF nft_error = 0 THEN        reply_msg := AEOD      ELSE   
      reply_msg := ADATA;  
     "   BuildAndSendMsg (reply_msg, nft_error, nft1000_error, fmp_error,  "                     ipc_error);       
   IF ipc_error <> 0 THEN  
       BEGIN         LogEvent (C_LOG_SEND_ERROR, 8, state, ipc_error, 0, 0);   
      CleanupAndTerminate; 
       END;      
END;  { ReceiveEod } 
         $Page   #{-------------------------------------------------------------------}  # #{                           RECEIVE OFFERI                          }  # #{-------------------------------------------------------------------}  # "{ An interchange offer request has arrived from the producer system. " !{ First extract the fields from the Offer and place them in global ! "{ record offer_msg_fields for safe keeping. Next map the interchange " "{ file attributes into HP1000 file attributes and attempt to create  " !{ the target file. If the target file exists and the user gave the ! "{ replace option then use a scratch file. Based on the return error  " "{ code, the caller will determine what info to place in the Aofferi  " { message to send to the producer.  {   { Parameters:   {   {     msg_buffer (Input)   {        Carries in the received Offeri message in its entirety    {   {     nft1000_error (Output)  {        Returns an Nft/1000 error code if non-zero   {   {     fmp_error (Output)  {        Returns an Fmp error code if non-zero  {   {     nft_error (Output)  {        Returns an Nft protocol error code if non-zero   {}  PROCEDURE  ReceiveOfferi     (VAR msg_buffer     : MsgBufferType;       VAR nft1000_error  : Int16;       VAR fmp_error      : Int16;       VAR nft_error      : Int16);      LABEL      99;   { Labels end of the procedure }      VAR      forced_params      : ForcedParamsType;      hp1000_file_size   : Int16;     hp1000_file_type   : Int16;     hp1000_rec_length  : Int16;     number_dcb_buffers : Int16;      $Page   #   {----------------------------------------------------------------}  # #   { (Local)          MAP ATTRIBS TO 1000 FILE TYPE         (Local) }  # #   {----------------------------------------------------------------}  # !   { Map the interchange file attributes into an HP1000 file type  ! !   { number. There is only one file structure not supported by Nft ! !   { currently: Direct access files with Variable length records,  !    { so that is flagged as an error      {     { Parameters:     {     {     file_organiz (Input)      {        Either DIRECT or SEQUENTIAL (never null)     {     {     record_type (Input)     {        Either FIXED or VARIABLE (never null)      {  
   {     data_type (Input) 
    {        Either ASCII or BINARY (never null)      {     {     rec_length_bytes (Input)       {        Gives the requested length of records for the inter-      {        change format file     {     {     hp1000_file_type (Output)     {        The returned HP1000 file type number     {     {     forced_params (Output)       {        If we see here that the target file is going to be a       {        direct access file, then we cannot allow the user to   !   {        specify all of the target namr parameters in the file  !    {        create. This will return either SOME or NONE     {     {     nft1000_error (Output)      {        Returns an Nft/1000 error code if non-zero     {     {     nft_error (Output)      {        Returns an Nft protocol error code if non-zero     {}      PROCEDURE  MapAttribsTo1000FileType        (    file_organiz     : Byte;              record_type      : Byte;              data_type        : Byte;              rec_length_bytes : Int32;         VAR hp1000_file_type : Int16;         VAR forced_params    : ForcedParamsType;          VAR nft1000_error    : Int16;         VAR nft_error        : Int16);          BEGIN  
      nft1000_error := 0;  
 
      nft_error     := 0;  
       forced_params := NONE;            IF file_organiz = DIRECT THEN            BEGIN           {------------- DIRECT --------------}           IF record_type = VARIABLE THEN   	            BEGIN  	             nft1000_error := CANT_CREATE_DIR_VAR_FILE;              nft_error     := CONFLICTING_ATTRIBUTES               END            ELSE   	            BEGIN  	             { FIXED length records }              IF rec_length_bytes = BYTES_PER_BLOCK THEN                 hp1000_file_type := 1              ELSE                 hp1000_file_type := 2;               forced_params := SOME;              END;  { ELSE of IF record_type }           END  { IF file_organiz }         ELSE           BEGIN           {----------- SEQUENTIAL ------------}           IF record_type = VARIABLE THEN   	            BEGIN  	             IF data_type = ASCII THEN                  hp1000_file_type := 4              ELSE                 hp1000_file_type := 3;               END   { IF record_type }           ELSE   	            BEGIN  	             { FIXED length records }              IF data_type = ASCII THEN                  hp1000_file_type := 4              ELSE  
               BEGIN 
                IF rec_length_bytes = BYTES_PER_BLOCK THEN                     hp1000_file_type := 1   
               ELSE  
                   hp1000_file_type := 2;                 END;  { ELSE of IF data_type }               END;  { ELSE of IF record_type }           END;  { ELSE of IF file_organiz }         END;  { MapAttribsTo1000FileType }           $Page   #   {----------------------------------------------------------------}  # #   { (Local)          MAP ATTRIBS TO 1000 SIZE RLEN         (Local) }  # #   {----------------------------------------------------------------}  # !   { Map the passed interchange file attributes to an HP1000 file  ! !   { size and record length. The interchange attributes are first  ! 
   { bounds checked. 
    {     { Parameters:     {     {     record_length_bytes (Input)      {        Requested length of records in the interchange file       {     {     number_records (Input)       {        Requested number of records in the interchange file       {     {     record_type (Input)     {        Either FIXED or VARIABLE (never null)      {     {     interch_flags (Input)     {        Contains flags passed to us in the Offeri message      {     {     hp1000_file_size (Output)     {        Returns HP1000 file size to be used in create call     {     {     hp1000_rec_length (Output)   !   {        Returns HP1000 record length to be used in create call !    {     {     nft1000_error (Output)      {        Returns an Nft/1000 error code if non-zero     {     {     nft_error (Output)      {        Returns an Nft protocol error code if non-zero     {}      PROCEDURE  MapAttribsTo1000SizeRlen        (VAR record_length_bytes : Int32;          VAR number_records      : Int32;          VAR record_type         : Byte;         VAR misc_interch_flags  : MiscInterchFlagsType;         VAR hp1000_file_size    : Int16;          VAR hp1000_rec_length   : Int16;          VAR nft1000_error       : Int16;          VAR nft_error           : Int16);         LABEL        99;   { Labels end of the procedure }          VAR        file_size_32bits  : Int32;         BEGIN  
      nft1000_error := 0;  
           { Bounds check the record length }        IF (record_length_bytes < 0) THEN            BEGIN           nft_error := TARGET_RECORD_SIZE_INVALID;   	         GOTO 99;  	          END;  { IF }             IF (record_length_bytes > MAX_INTERCH_REC_BYTES) THEN            BEGIN           nft_error     := INSUFF_RESOURCES_TARGET;           nft1000_error := RECORD_SIZE_TOO_BIG;  	         GOTO 99;  	          END;  { IF }             { Must convert record length from bytes to words }        hp1000_rec_length := (record_length_bytes + 1) DIV 2;             { Bounds check the number of records }        IF (number_records < 0) THEN           BEGIN           nft_error := TARGET_FILE_SIZE_INVALID;   	         GOTO 99;  	          END;  { IF }       !      { The way we decide on the file size is based on the type }  ! !      { of records in the file                                  }  !       IF record_type = FIXED THEN            BEGIN  "         { First calculate the amount of space needed to hold the }  " "         { specified number of records                            }  " !         file_size_32bits := number_records * record_length_bytes; !               { If the number of records was estimated then it was  }             { estimated too high so chop it down. The value of 80 }             { may change later.                                   }            IF misc_interch_flags.fsize_estimated THEN               file_size_32bits := file_size_32bits DIV 80;           END   { IF record_type }         ELSE           BEGIN  "         { This is a little kludgey. Here we want to multiply the }  " "         { number of records (which in this case means the number }  " "         { of maximum sized records which fit in the file) by the }  " "         { maximum record size in bytes.                          }  " !         file_size_32bits := number_records * record_length_bytes; !     !         { Now we must add in the total number of length words  }  ! !         { needed for the records. The actual number of logical }  ! !         { records is wildly guesstimated here.                 }  !          file_size_32bits := file_size_32bits +                                (file_size_32bits DIV 30);       !         { If the number of records value was not forced by the }  ! !         { user then we will want to chop it down.              }  !          IF NOT misc_interch_flags.fsize_forced THEN  	            BEGIN  	 "            { If the number of records was estimated then really  }  " "            { hack it down (currently a Unix producer), else just }  " "            { chop it off a bit (currently a MPE producer). Both  }  " "            { of these fudge factors may change                   }  "             IF misc_interch_flags.fsize_estimated THEN                 file_size_32bits := file_size_32bits DIV 80              ELSE                 file_size_32bits := file_size_32bits DIV 2                   END;  { IF NOT }           END;  { ELSE of IF record_type }             { Round up the file size to the nearest block }   !      file_size_32bits := (file_size_32bits + BYTES_PER_BLOCK -1)  !                            DIV BYTES_PER_BLOCK;             hp1000_file_size := FmpPackSize (file_size_32bits);          99:     END;  { MapAttribsTo1000SizeRlen }       $Page   
BEGIN   { ReceiveOfferi }  
     #   { Reset these fields before each transfer. Refer to their global }  # #   { declarations as to the reasons why                             }  #    target_file_info.tfi_accumulating_info       := FALSE;      target_file_info.tfi_records_written         := 0;      target_file_info.tfi_using_scratch           := FALSE;      dcb_and_interch_record.dir_record_word_index := -1;     fmp_error                                    := 0;      nft1000_error                                := 0;       #   { Extract the Offer message fields and place in offer_msg_fields }  # #   RetrieveOfferMsg (msg_buffer, offer_msg_fields, FALSE, nft_error);  #        { Bailout on any error }   
   IF nft_error <> 0 THEN  
       GOTO 99;         WITH offer_msg_fields, omf_consumer_storage DO         BEGIN   "      { Map the interchange file attributes to an HP1000 file size } " "      { and record length                                          } "       MapAttribsTo1000SizeRlen  "         (omf_record_len_bytes, omf_number_records, omf_record_type, " !          omf_interch_flags, hp1000_file_size, hp1000_rec_length,  !           nft1000_error, nft_error);            { Bailout on any error }        IF nft_error <> 0 THEN  	         GOTO 99;  	     "      { Map the interchange file attributes to an HP1000 file type } "       MapAttribsTo1000FileType           (omf_file_organiz, omf_record_type, omf_data_type,              omf_record_len_bytes, hp1000_file_type, forced_params,             nft1000_error, nft_error);            { Bailout on any error }        IF nft_error <> 0 THEN  	         GOTO 99;  	     "      { Now determine how many Dcb buffers we should use. If any   } " "      { of the records in the interchange file will not fit in the } " "      { data message, then the producer will send partial records, } " "      { and only in this case do we need the use of the interchange} " "      { buffer (dir_interch_record) for the transfer. If we do not } " "      { need it then we can use this buffer as part of the Dcb     } " "      { packing buffer. We could calculate the size of the record  } " "      { header here, but assuming the largest is close enough      } "       IF (omf_record_len_bytes + NFT_HEADER_SIZE_BYTES +            MAX_RECORD_HEADER_BYTES)                     >  #         Min (producer_info.pi_buffer_size, nft_buffer_words * 2) THEN #          number_dcb_buffers := MIN_DCB_BUFFERS        ELSE           number_dcb_buffers := MAX_DCB_BUFFERS;       "      { The desired name of the target file is in tfi_actual_name. } " "      { Attempt to create that file. Replace namr fields with the  } " "      { parameters if namr fields are null                         } "       CreateTargetFile (CREATE, INTERCHANGE, target_file_info.                          tfi_actual_name, target_file_info,                          number_dcb_buffers, hp1000_file_type,                           hp1000_file_size, hp1000_rec_length,                          forced_params, fmp_error, nft_error);       !      { If the target file already exists and the user gave the }  ! !      { replace option then create a scratch file and use it    }  !       IF (nft_error = TARGET_FILE_EXISTS) AND cs_replace THEN            BEGIN  "         { In order for the scratch file scheme to work, we must  }  " "         { be able to purge the existing file. To check this, see }  " "         { if we have write access to the file                    }  "           CreateTargetFile (OPEN, INTERCHANGE, target_file_info.                               tfi_actual_name, target_file_info,                               number_dcb_buffers, hp1000_file_type,                               hp1000_file_size, hp1000_rec_length,                                forced_params, fmp_error, nft_error);                { If open succeeded then we have write access }           IF nft_error = 0 THEN              CreateScratchFile (INTERCHANGE, target_file_info.   !                               tfi_actual_name, target_file_info,  ! "                               number_dcb_buffers, hp1000_file_type, " "                               hp1000_file_size, hp1000_rec_length,  " "                               forced_params, fmp_error, nft_error); "          END;  { IF (nft_error = TARGET_FILE_EXISTS) }            END;  { WITH offer_msg_fields }       99:   END;  {  ReceiveOfferi }          $Page   #{-------------------------------------------------------------------}  # #{                          RECEIVE OFFERT                           }  # #{-------------------------------------------------------------------}  # "{ A transparent offer request has arrived. This could be a transient " "{ transfer request or a normal 1000 to 1000 transfer request. In the " "{ former case, the target file will always be the same numeric type  " !{ (given by global constant Transient_File_Type) and in the latter ! !{ case, the type of the target file will be taken from the source  ! { file attributes in the Offert.  {   { Parameters:   {   {     msg_buffer (Input)  {        Contains the received Offert message in its entirety   {   {     fmp_error (Output)  {        Returns an Fmp error if non-zero   {   {     nft_error (Output)  {        Returns an Nft error if non-zero   {}  PROCEDURE  ReceiveOffert     (VAR msg_buffer   : MsgBufferType;       VAR fmp_error    : Int16;       VAR nft_error    : Int16);      LABEL      99;   { Labels end of the procedure }      $Page   #   {----------------------------------------------------------------}  # #   {  (Local)           PREPARE NORMAL STORAGE             (Local)  }  # #   {----------------------------------------------------------------}  # !   { The Offert which arrived requested a normal HP1000 to HP1000  ! !   { transfer. Attempt to set up (open or create) the target file. ! !   { Must do some special processing if the user gave the replace  ! !   { option. The target file will be overridden as type 1 and the  !    { data will be written out in 256-byte blocks.      {     { Parameters:     {     {     offer_msg_fields (Input)       {        Global record containing the extracted fields of the   
   {        offer message. 
    {     {     target_file_info (Input)       {        Global record containing info about the target file       {     {     fmp_error (Output)      {        Returns an Fmp error if non-zero. Will be used to       {        generate an error string to be placed in the message      {        that is returned to the producer     {     {     nft_error (Output)      {        Returns the Nft error code if non-zero     {}      PROCEDURE  PrepareNormalStorage        (VAR offer_msg_fields : OfferMsgFieldsType;          VAR target_file_info : TargetFileInfoType;          VAR fmp_error        : Int16;         VAR nft_error        : Int16);          VAR        forced_params  : ForcedParamsType;        pathname_descr : FmpStringType;          BEGIN        WITH offer_msg_fields,             offer_msg_fields.omf_consumer_storage,              offer_msg_fields.omf_hp1000_attributes.words DO           BEGIN  "         { If the source file is sparse then we cannot allow the   } " "         { user to specify target file parameters - it's dangerous } "          IF hpa_missing_extents THEN              forced_params := ALL           ELSE               forced_params := NONE;      !         { Try to create the target file whose name is given in }  ! !         { tfi_actual_name.                                     }  ! !         CreateTargetFile (CREATE, TRANSPARENT, target_file_info.  !                             tfi_actual_name, target_file_info, 0,                              hpa_file_type, hpa_file_size,                             hpa_record_size, forced_params,                             fmp_error, nft_error);       !         { Use a scratch file if the file exists and the replace } ! !         { option was given by the user. !! Note that when we    } ! !         { build the Aoffert, we will not give the user the      } ! !         { correct namr fields (in tfi_actual_name) but may not  } ! !         { want this anyway !!                                   } !           IF (nft_error = TARGET_FILE_EXISTS) AND cs_replace THEN   	            BEGIN  	 !            { Before creating the scratch file, check if we have } ! !            { write access to the file. This includes the proper } ! !            { security code or protection bit (user write bit).  } ! !            { If we don't have write access then we will not be  } ! !            { able to purge the existing target file later       } ! !            CreateTargetFile (OPEN, TRANSPARENT, target_file_info. ! "                              tfi_actual_name, target_file_info, 0,  "                               hpa_file_type, hpa_file_size,                                 hpa_record_size, forced_params,                                 fmp_error, nft_error);      !            { If no error on the open then we have write access }  !             IF nft_error = 0 THEN                   CreateScratchFile (TRANSPARENT, target_file_info.   "                                  tfi_actual_name, target_file_info, " !                                  0, hpa_file_type, hpa_file_size, ! !                                  hpa_record_size, forced_params,  !                                   fmp_error, nft_error);              END;  { IF (nft_error = TARGET_FILE_EXISTS) }                 { Check if we should gather directory info about the }              { file that Fmp does not                             }             target_file_info.tfi_accumulating_info :=              (nft_error = 0)                  AND              target_file_info.tfi_is_new_file AND              (hpa_file_type > 2)              AND              (hpa_file_type <> 6);                IF target_file_info.tfi_accumulating_info THEN   	            BEGIN  	             { Prepare for accumulating info by resetting the }              { global variables that are used. The values to  }              { initialize these fields to is given in the     }              { declaration for the record                     }              WITH target_file_info.tfi_accumulated_info DO   
               BEGIN 
                ai_eof_reached      := FALSE;                 ai_relative_rec_ptr := -1;                  ai_max_rec_length   := 0;                 ai_number_records   := 1;                 ai_total_words      := 0;                 END;  { WITH target_file_info }              END;  { IF target_file_info }             END;  { WITH offer_msg_fields }          END;  { PrepareNormalStorage }           $Page   #   {----------------------------------------------------------------}  # #   {  (Local)          PREPARE TRANSIENT STORAGE           (Local)  }  # #   {----------------------------------------------------------------}  # "   { An Offert message is sitting in the msg_buffer and it requests  " "   { transient storage. Prepare this by creating the target file and " "   { writing out the attributes area (in the Offert message) as the  " !   { first record of the file. The file will be overriden as type  !     { type 1 and the data will be written out in 128-word blocks.      {     { Parameters:     {     {     msg_buffer (Input)      {        Global message buffer which contains the Offert      {        message. Will need the attributes area bytes,      {        system common attributes and file size fields.     {     {     target_file_info (Input)       {        Global record containing info about the target file.      {        We need tfi_actual_name to create the file.      {     {     fmp_error (Output)       {        Returns an Fmp error if non-zero. This will be used       {        to generate an error string to be placed in the      {        message to be returned to the producer     {     {     nft_error (Output)      {        Returns the Nft error code if non-zero     {}      PROCEDURE  PrepareTransientStorage         (VAR msg_buffer         : MsgBufferType;         VAR target_file_info   : TargetFileInfoType;          VAR fmp_error          : Int16;         VAR nft_error          : Int16);          VAR        bytes_written     : Int16;        file_size_blocks  : Int16;        first_block       : FirstBlockTransientFileType;        index             : Int16;         BEGIN        { The size of the target file should be the size given }        { in Offert message, plus the attributes area (first   }        { block) and rounded up to the nearest block           }  
      file_size_blocks :=  
          FmpPackSize ((offer_msg_fields.omf_file_size_bytes +   "                       BYTES_PER_BLOCK + 255) DIV BYTES_PER_BLOCK);  "           { The file name is in tfi_actual_name - create it now }         CreateTargetFile (CREATE, TRANSPARENT, target_file_info.                          tfi_actual_name, target_file_info, 0,                           TRANSIENT_FILE_TYPE, file_size_blocks,                          0, ALL, fmp_error, nft_error);            { If file exists and replace option given then try to }         { create a scratch file with the same attributes      }         IF (nft_error = TARGET_FILE_EXISTS)                 AND            offer_msg_fields.omf_consumer_storage.cs_replace THEN           BEGIN            { Before creating the scratch file, check if we have  }             { write access to the file. This includes the proper  }             { security code or protection bit (user write bit).   }             { If we don't have write access then we can't purge   }             { the existing target file later when transfer is done}             CreateTargetFile (OPEN, TRANSPARENT, target_file_info.                                tfi_actual_name, target_file_info, 0,   !                           TRANSIENT_FILE_TYPE, file_size_blocks,  !                            0, ALL, fmp_error, nft_error);                { If open succeeded then we have write access }           IF nft_error = 0 THEN              CreateScratchFile (TRANSPARENT, target_file_info.   !                             tfi_actual_name, target_file_info, 0, ! "                             TRANSIENT_FILE_TYPE, file_size_blocks,  "                              0, ALL, fmp_error, nft_error);            END;  { IF (nft_error = TARGET_FILE_EXISTS) }            IF nft_error = 0 THEN            BEGIN  "         { Fill in the first block of the transient file with the }  " "         { pertinent fields of the Offert message. All fields but }  " "         { the attributes string are in offer_msg_fields          }  " 
         WITH first_block, 
               offer_msg_fields,                 msg_buffer.msg.offert_msg DO  	            BEGIN  	             fbtf_eof_flag            := -1;               fbtf_bit_pattern         := TRANSIENT_BIT_PATTERN;              fbtf_home_system_type    := omf_home_system_type;               fbtf_op_sys_version      := omf_op_sys_version;               fbtf_home_capabil_mask   := omf_capability_mask;               fbtf_bytes_in_last_block := omf_file_size_bytes MOD                                            BYTES_PER_BLOCK;              IF (fbtf_bytes_in_last_block = 0) AND                  (omf_file_size_bytes > 0)      THEN                 fbtf_bytes_in_last_block := BYTES_PER_BLOCK;       !            { Now pull the system specific attributes from the  }  ! !            { Offert message directly. Note the size limitation }  !             fbtf_bytes_in_attributes :=                  Min (negoc_flags_ptr - attributes_ptr,                       MAX_TRANSIENT_ATTRIBS);               FOR index := 0 TO fbtf_bytes_in_attributes -1 DO  
               BEGIN 
                fbtf_attributes_area [index] :=                    msg_buffer.chars [attributes_ptr + index];                 END;  { FOR index }                  END;  { WITH first_block }               { Now write this first block to the transient file }   
         bytes_written :=  
              FmpWrite (dcb_and_interch_record.dir_dcb, fmp_error,   !                      first_block.fbtf_eof_flag, BYTES_PER_BLOCK); !              IF fmp_error <> 0 THEN               nft_error := WRITE_TO_TARGET_FAILED;           END;  { IF nft_error = 0 }       !      { We never accumulate directory info about transient files } !       target_file_info.tfi_accumulating_info := FALSE;         END;  { PrepareTransientStorage }      $Page   BEGIN  { ReceiveOffert }         { These globals must be reset for each transparent xfer }     dcb_and_interch_record.dir_last_word_index  := 0;     dcb_and_interch_record.dir_last_block_index := 0;     target_file_info.tfi_current_word           := 0;     target_file_info.tfi_using_scratch          := FALSE;     fmp_error                                   := 0;     nft_error                                   := 0;          { If user gave transient option or the file was not created }       { on an HP1000 then set the transient storage flag. The     }       { second case can occur when the file was stored on a 1000  }       { already in transient format but was originally created on }       { a non-HP1000 system.                                      }      target_file_info.tfi_transient_storage :=  !      (msg_buffer.msg.offert_msg.consumer_storage.cs_transient) OR !       (msg_buffer.msg.offert_msg.home_system_type <> RTE);      !   { Reject any requests for transient storage for first release } !    IF target_file_info.tfi_transient_storage THEN         BEGIN         nft_error := TRANSIENT_NOT_SUPPORTED;         GOTO 99;        END;  { IF target_file_info }       "   { Extract the offer fields and place them into offer_msg_fields } " "   RetrieveOfferMsg (msg_buffer, offer_msg_fields, target_file_info. "                      tfi_transient_storage, nft_error);          { Bailout on any error }   
   IF nft_error <> 0 THEN  
       GOTO 99;         { Call the appropriate service routine }      IF target_file_info.tfi_transient_storage THEN         BEGIN   !      { Transient storage has been requested. Prepare this by   }  ! !      { creating the target file and writing out the attributes }  ! !      { area contained in the offert message.                   }  !       PrepareTransientStorage (msg_buffer, target_file_info,                                 fmp_error, nft_error);   	      END   { IF } 	    ELSE         BEGIN   "      { A normal 1000-to-1000 transfer has been requested. Prepare } " "      { this by setting up (opening or creating) the target file   } "        PrepareNormalStorage (offer_msg_fields, target_file_info,                                fmp_error, nft_error);  
      END;  { ELSE } 
 99:   END;  { ReceiveOffert }           $Page   #{-------------------------------------------------------------------}  # #{                         RETRIEVE OFFER MSG                        }  # #{-------------------------------------------------------------------}  #  { There is an Offer(I,T) message in the msg_buffer. Extract its    !{ fields and place them in the offer_msg_fields. Non-disc transfer ! !{ requests are rejected as well as append and overwrite requests.  ! {   !{ NOTE that no warning is generated for truncating the target file ! "{ name since that name must have been user-given to be greater than  " "{ 16 chars and that is not the purpose of that warning. If the user  " { did give a name > 16 chars then Fmp will truncate it for us.  {   { Limitations:   {     1) The target device must be disc. An error is returned if   !{        there is something in the device string or the file name  ! {        begins with a digit  !{     2) Target password not used (security code must be in namr). ! !{     3) An error is returned if cs_append or cs_overwrite is set  ! {   { Parameters:   {   {     msg_buffer (Input)   {        Global buffer which contains the received offer message   {   {     offer_msg_fields (Output)   {        Global record where the offer message is saved   {   {     transient_storage (Input)   {        A boolean which is true if transient storage has been  
{        requested.  
 {   {     nft_error (Output)  {        Returns an Nft error if non-zero   {}  PROCEDURE  RetrieveOfferMsg      (VAR msg_buffer        : MsgBufferType;      VAR offer_msg_fields  : OfferMsgFieldsType;           transient_storage : BOOLEAN;      VAR nft_error         : Int16);       VAR   !   device_start      : Int16;   { Location of these three string } ! !   source_name_start : Int16;   { fields is offer-dependent, so  } ! !   target_name_start : Int16;   { we must locate them separately.} ! !   char_index        : Int16;   { Index into message string space} ! !   end_device        : Int16;   { Index for end of device string } !    end_target_name   : Int16;       BEGIN      WITH msg_buffer, msg_buffer.msg, offer_msg_fields DO         BEGIN         { Save the offer type as it is the tag field }        omf_offer_type := msg_type.nft_type;            CASE omf_offer_type OF           OFFERI:  	            BEGIN  	             WITH offeri_msg DO  
               BEGIN 
                { Locate the file name and device strings }                 source_name_start    := source_file_ptr;                  target_name_start    := target_file_ptr;                  end_target_name      := target_file_pass_ptr;                 device_start         := target_file_dev_ptr;                  end_device           := negoc_flags_ptr;       "               { Move the fixed length fields to offer_msg_fields }  "                omf_consumer_storage := consumer_storage;                 omf_data_type        := data_type;                  omf_record_type      := record_type;                  omf_record_len_bytes := record_length;                  omf_file_organiz     := file_organiz;                 omf_number_records   := number_records;                 omf_interch_flags    := misc_interch_flags;                 END;  { WITH offeri_msg }              END;  { OFFERI }               OFFERT:  	            BEGIN  	             WITH offert_msg DO  
               BEGIN 
                { Locate the file name and device strings }                 source_name_start     := source_file_ptr;                 target_name_start     := target_file_ptr;                 end_target_name       := target_file_pass_ptr;                  device_start          := target_file_dev_ptr;                 end_device            := attributes_ptr;       "               { Move the fixed length fields to offer_msg_fields }  "                omf_consumer_storage  := consumer_storage;                  omf_home_system_type  := home_system_type;                  omf_op_sys_version    := op_sys_version;                  omf_capability_mask   := capability_mask;                 omf_file_size_bytes   := file_size_bytes;      "               { If a transient transfer is taking place then we   } " "               { don't need to save the system specific attributes } " "               { string. It will be extracted directly from the    } " "               { Offert message and placed in the transient file   } "                IF NOT transient_storage THEN                    BEGIN   "                  { Now move the HP1000 source file attributes. If } " "                  { we are not storing transiently then the attrib-} " "                  { utes must be from an HP1000 by definition.     } " #                  FOR char_index := 0 TO HP1000_ATTRIBUTES_CHARS -1 DO #                       omf_hp1000_attributes.chars [char_index] :=                           chars [attributes_ptr + char_index];                    END;  { IF NOT }                     END;  { WITH offert_msg }              END;  { OFFERT }           END;  { CASE offer_type }            { Calculate and save the target file name based on the }        { source and target names given in the message. The    }        { full target file name is placed in tfi_actual_name.  }        CalculateFileOrDirName (msg_buffer, source_name_start,  !                              target_name_start, end_target_name,  ! !                              offer_msg_fields, target_file_info); !            { Convert the target file pathname to standard format in }          { case it refers to a FMGR file. For example, "/SY/FOO"  }          { will become "FOO::SY", but "/A/B/C" will not change.   }         FmpStandardName (target_file_info.tfi_actual_descr);            { Reject any requests for device transfers }        WITH target_file_info DO           BEGIN           IF ((ORD (tfi_actual_name [0]) >= ORD ('0'))  AND               (ORD (tfi_actual_name [0]) <= ORD ('9'))) OR               (device_start <> end_device)               THEN   	            BEGIN  	             nft_error := INVALID_TARGET_DEVICE;               END;  { IF }           END;  { WITH }       
      { Check for append } 
       IF offer_msg_fields.omf_consumer_storage.cs_append THEN            nft_error := APPEND_NOT_SUPPORTED;             { Check for overwrite }          IF offer_msg_fields.omf_consumer_storage.cs_overwrite THEN            nft_error := OVERWRITE_NOT_SUPPORTED;            END;  { WITH msg_buffer }       
END;  { RetrieveOfferMsg } 
         $Page   #{-------------------------------------------------------------------}  # #{                           MAIN PROGRAM                            }  # #{-------------------------------------------------------------------}  #     BEGIN       	   state := IDLE;  	     "   { Initialize by picking by receiving the RINIT message.        }  "    Initialize (producer_info, vc_socket_descr);          REPEAT          { This will always be a blocking receive since we have  }           { nothing else to do. Since we have a message interface }           { we will receive whole messages at a time              }          data_length := nft_buffer_words * 2;        ipc_flags   := 0;         InitOpt (ipc_options, 0, error);        IpcRecv (vc_socket_descr, msg_buffer, data_length,                 ipc_flags, ipc_options, ipc_error);          !      { If ipc_error = 0 then a message arrived, else the error }  ! !      { must have been fatal to the connection                  }  !       IF ipc_error <> 0 THEN           event := P_C_CONNECTION_DOWN         ELSE           BEGIN            { If the NFT message length field does not match the }              { number of bytes received then bailout              }              IF data_length <> msg_buffer.msg.msg_length_bytes THEN    	            BEGIN  	             LogEvent (C_LOG_BAD_MSG_LENGTH, 1, state,                         msg_buffer.msg.msg_type.nft_type,   "                      msg_buffer.msg.msg_length_bytes, data_length); "             CleanupAndTerminate;              END;  { IF }               event := msg_buffer.msg.msg_type.nft_type           END;  { ELSE of IF ipc_error }             EventHandler (state, event, msg_buffer, ipc_error);          UNTIL FALSE;       { We can only reach this label from CleanupAndTerminate }   99:   END.  { CONSM }  