 $PASCAL '91790-1X044 REV.4010 <860324.1043> '   $STANDARD_LEVEL 'HP1000', RANGE OFF$   $DEBUG, RECURSIVE OFF, HEAPPARMS OFF, HEAP 0, HEAP_DISPOSE OFF $       MODULE EnvOk;   $ALIAS 'N$EnvOk'      %{------------------------------------------------------------------------  %     "   (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986.  ALL RIGHTS RESERVED. "    NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED, REPRODUCED, OR   "   TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR WRITTEN  "    CONSENT OF THE HEWLETT-PACKARD COMPANY.      % ------------------------------------------------------------------------} %     {}  {        NAME : EnvOk   {      SOURCE : 91790-18044   
{       RELOC : none 
 
{        PGMR : EMS  
 {}      ${----------------------------------------------------------------------- $    MODIFICATIONS  "   850515   lms      Make DS_DsamOk be called DS_DsamCheck as it was "                      supposed to be.      $   850710   lms      Make NotOk Terminate normally not serial-reusable.  $                      Delete init_dec from imports.  "   860102   lms      Change termination of NotOk to save ID segment. "    860210   lms      Add RANGE OFF compiler directive (n314).      860210   lms      Add block comments (n386).      End of Modifications   % -----------------------------------------------------------------------}  % IMPORT      
$SEARCH 'phtm/bodec.rel'$  
    bodec,   
$SEARCH 'phtm/mmdec.rel'$  
    mmdec,   
$SEARCH 'phtm/mmext.rel'$  
    ds_mm;       $SUBTITLE ' Export procedures ', PAGE$  EXPORT  {}  { These procedures are environment checks for NS/1000.  {   #{  DS_DsamCheck is called by monitors who assume that NS is completely # {  initialized when it starts.  (Timer/#SEND).  {   {  DS_EnvOk is called by monitors who are started before NS is  "{  completely up.  The monitors block waiting for NSINIT to release  " "{  the initialization resource number (EVMON/GRPM/INPRO/OUTPRO/IFM). " {   "{  DS_TimeListWake is called by programs who are time critical, and  " !{  need to check their environments only the FIRST time they run.  ! !{  Once the environment is ok, they need to put themselves in the  ! {  time list (MATIC/UPLIN).   {   {}  CONST   
   PNAMECHARLEN = 6; 
     TYPE     ProgNameAsCharType = PACKED ARRAY[1..PNAMECHARLEN] OF Char;      $PROCEDURE DS_DsamCheck                           $ ALIAS 'DS_DsamCheck'$ $ (     passedname  : ProgNameAsCharType );   { Check state of dsam.  Also check the name of the program }      !PROCEDURE DS_EnvOk                            $ ALIAS 'DS_EnvOk'$  ! (     passedname  : ProgNameAsCharType );   ${ Wait for init rn, check state of dsam, check the name of the program } $     %PROCEDURE DS_TimeListWake                     $ ALIAS 'DS_TimeListWake' $  % (    myname:    ProgNameAsCharType;   
     howoften:    Int16 ); 
 ${ check pram1 is 'DS'. Then call DS_EnvOk. Then put self in timelist. }  $     $ SUBTITLE 'Implement', PAGE $  IMPLEMENT       CONST      TIMEINSECONDS = 2;      NOABORTBIT = -32768;       TYPE  !   Name_Int_Type = PACKED ARRAY [1..PNAMECHARLEN DIV 2] OF Int16;  !    Name_Type = RECORD CASE BOOLEAN OF            TRUE  : (int  : Name_Int_Type );            FALSE : (char : ProgNameAsCharType );        END;         RAType = Array[1..5] OF Int16;       VAR   
   retarray:      RAType;  
    progname : Name_Type;      PROCEDURE ExecTimeSched                     $ ALIAS 'EXEC' $  	$ HEAPPARMS OFF $  	 $ NOABORT $   (    icode:          Int16;        passedname:       ProgNameAsCharType;       units:          Int16;        howoften:       Int16;        whentostart:    Int16 );   $ HEAPPARMS ON $     EXTERNAL;      PROCEDURE AccessResourceNumber           $ALIAS 'RNRQ' $  $ NOABORT $    (     cntwd   : Int16;          rn      : Int16;      VAR stat    : Int16);     EXTERNAL;      PROCEDURE NotOk;     FORWARD;       PROCEDURE PNAME         (VAR name : ProgNameAsCharType);        EXTERNAL;       PROCEDURE Rmpar      (VAR returnarray: RAType );     EXTERNAL;      PROCEDURE Terminate                     $ ALIAS 'EXEC' $  (     icode:         Int16;         noname:        Int16;         kind:          Int16 );      EXTERNAL;          $SUBTITLE 'DS_DsamCheck', PAGE$   PROCEDURE DS_DsamCheck     (    passedname    : ProgNameAsCharType );   { Check state of dsam.  Also check the name of the program }          {}  { INPUT: passedname:    Name of the program being checked.  {   "{ USE: Routine to verify the state of NS is UP and that the program  " { is not cloned.  {   { ALGORITHM:  !{  Get the state of DSAM.  Make sure it is ADSINIT.  Terminate the ! {  program if it is not.  Then verify the program name matches  !{  the characters the caller passed in.  Terminate if they don't.  ! {   {}      VAR      dsamstate:  Int16;      index:      Int16;          BEGIN    { DS_DsamCheck }         progname.int[1] := 0;  
   PNAME( progname.char ); 
        dsamstate := DS_StateOfDSAM;      IF dsamstate < 0 THEN        BEGIN    { check if cloned }            FOR index := 1 TO PNAMECHARLEN -1 DO  !         IF progname.char[index] <> passedname[index] THEN NotOk;  !           END      { check if cloned }       ELSE         BEGIN    { bad state of dsam }            NotOk;        END;     { bad state of dsam }         END;     { DS_DsamCheck }      $SUBTITLE 'DS_EnvOk', PAGE$   	PROCEDURE DS_EnvOk 	    (    passedname    : ProgNameAsCharType );       {}  &{ Description: This module check the environment that program is running in. & {   {   passedname   (input)     program name   {}      {}  "{ PROGRAM DESCRIPTION : This subroutine is called by all NS monitors " !{ that were added for 91790.  It is similar to the subroutine #OK? !  { in DS/1000-IV. It checks the environment to see if the monitor   { can run.  {   {  Algorithm:   {     1. Attempt to lock the initialization rn.  This rn is   {     stored in DSAM and in Res.  #OK? gets the rn from Res   {     DS_EnvOk from DSAM.  Dsinit will lock the rn at startup   {     and at shutdown.  Each monitor will call RNRQ with wait,  {     so it will block waiting for the rn to be released when   {     NSINIT terminates.  {   {     2. When lock completes, verify the status return from   {     RTE, if not ok, Terminate the monitor.  {   {     3. Immediately unlock the rn, allowing the next monitor   	{     to lock it.  	 {   {     4. Check that the state of DS is < 0.  This ensures   {     that NSINIT's termination was a normal one.  The monitor  {     should not be allowed to run if dsinit was aborted.   {     Note that we are not prohibiting programs from running  {     if there are recoverable parity errors in the system.   {   {     5. Verify that the monitor has not been cloned by   {     checking that the name is the same as the one passed in.  {   {}      CONST      EXEC6  = 6 ;      WAIT_NOABORT = bit14+bit1;      UNLOCK_NOABORT = bit14+bit2;   
   RN_UNLOCKED = 1;  
 
   RN_LOCKED_GLOBALLY = 3; 
     VAR   
   index    : Int16; 
 
   status   : Int16; 
 
   init_rn  : Int16; 
 
   wkmap    : Int16; 
 
   dsstate:   Int16; 
        BEGIN    { DS_EnvOk }         { get the name of this monitor}     progname.int[1] := 0;     PNAME(progname.char);         {  Get the initialization rn }      DS_InitEnterCritical( wkmap, status );      IF status <> 0 THEN NotOk;          DS_FetchGlobal( DS_Init_RN, 1, init_rn );     DS_InitLeaveCritical( wkmap );          { lock and unlock the rn.  }          AccessResourceNumber( WAIT_NOABORT, init_rn, status );         BEGIN    { rnrq error }         NotOk;        END;     { rnrq error }          IF status <> RN_LOCKED_GLOBALLY THEN NotOk;         AccessResourceNumber( UNLOCK_NOABORT, init_rn, status );         BEGIN    { rnrq error }         NotOk;        END;     { rnrq error }          IF Status <> RN_UNLOCKED THEN NotOk;          { verify that ds is initialized.    }     dsstate := DS_StateOfDSAM;          IF dsstate < 0 THEN        BEGIN    { DS is initialized }            { verify that the program has not been cloned. }            FOR index:= 1 TO PNAMECHARLEN -1 DO   !          IF progname.char[index] <> passedname[index] THEN NotOk; !       END      { DS is initialized }       ELSE         BEGIN    { DS not initialized }             NotOk;        END;     { DS not initialized }          END;     { DS_EnvOk }      
$ SUBTITLE 'NotOk', PAGE $ 
 PROCEDURE NotOk;     BEGIN    { NotOk }          { May want to print: "* NS: xxxxxx Aborting." on lu1 }       
   Terminate( 6, 0 , 2 );  
        END;     { NotOk }       $SUBTITLE 'DS_TimeListWake', PAGE $   
PROCEDURE DS_TimeListWake  
 (    myname:    ProgNameAsCharType;   
     howoften:    Int16 ); 
     {}  {  INPUT: myname-    Name of the program calling this routine.  {         howoften-  The interval used when the program is  {                      put in the time list (in seconds).   {   "{  PURPOSE: called by MATIC, and UPLIN to check their environments.  " {   {  USE:   "{  This routine is used to verify the environment for programs that  "  {  put themselves in the time list like MATIC and UPLIN.  If the   "{  routine is called it should be among the first things done, since " {  it uses the RMPAR parameters.  {   {  ALGORITHM:   "{  See if the RMPAR parameter is "DS".  If it is then call DS_EnvOk. " {  That routine will terminate program execution on error.  If  !{  DS_EnvOk returns, then put the program in the time list for the ! {  interval the caller requested.   {    {  If the first RMPAR parameter is null, then call DS_DSAMCheck    !{  to make sure NS is still up.  That routine will also terminate  !  {  program execution on error.  If it returns sucessfully, then    {  return control to the caller.  {    {  If the first RMPAR parameter is something other than "DS" or    !{  null, then terminate program execution, someone else started up ! {  the program.   {   {}      BEGIN    { DS_TimeListWake }      { get the program runstring }   	Rmpar( retarray ); 	     
IF retarray[1]  <> 0 THEN  
    BEGIN    { passed string }          { verify that the first parm is 'DS' }      IF retarray[1] <> 17491 { DS } THEN        BEGIN    { bad sched call }         NotOk;        END;     { bad sched call }          { check that NS is up, and that I am not cloned }     DS_EnvOk( myname );         { put self in time list to run every five seconds. }      ExecTimeSched( 12 + NOABORTBIT,  #                              myname, TIMEINSECONDS, howoften, -15 );  #       BEGIN    { EXEC Error }         NotOk;        END;     { EXEC Error }          END      { passed string }     ELSE  
   BEGIN    { check name } 
    { If runstring parm is 0 then check that the name of the      program is the same as the one passed in by the caller, and     that NS is initialized.  This is to stop users from running      NS programs at improper times.                              }       
   DS_DsamCheck( myname ); 
 
   END;     { check name } 
     END;     { DS_TimeListWake }  END  { module }   .  