 $PASCAL ',6,27 91790-16045 REV.4010 <860424.1142>'  
$STANDARD_LEVEL 'HP1000' $ 
 $DEBUG $  $RECURSIVE OFF$   $HEAP 0$      PROGRAM EvMon;      %{------------------------------------------------------------------------  %     "   (c) COPYRIGHT HEWLETT-PACKARD COMPANY 1986.  ALL RIGHTS RESERVED. "    NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED, REPRODUCED, OR   "   TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR WRITTEN  "    CONSENT OF THE HEWLETT-PACKARD COMPANY.      % ------------------------------------------------------------------------} %     {}  {        NAME : EvMon   {      SOURCE : 91790-18045   {       RELOC : 91790-16045   
{        PGMR : ASH  
 {}      ${----------------------------------------------------------------------- $    MODIFICATIONS  8/20/84  ASH  #   Changed the declaration of the message sent to be an event message, #    so that we can log these simply.   !   Rewrote the procedure PostEvent so that it will write to a file !    either in ascii or binary.   9/20/84   $   Modified postevent.  Was writing twice to the redfile.  Also reports  $    0 length read now instead of aborting.   9/21/84      Modified the runstring.  It is now         RU,EVMON[, <error log file>][, <logging_pid>]       #   where logging_pid is the ADS pid of the  protocol who wishes to log # "   special things, or 0 if the pid does not exist.  If such a value  " #   is given in the runstring, the severity is automatically set to 0.  # 10/28/84  TDS      Changed "FindMyUserRecord" to "FindUserRecord (MyIdAdd"  12/29/84  ash      Changed format of the first line of the output.  1/22/85  ash      Eliminated the two non error files.  Everything goes to one.    1/28/85  ash      Changed to FMP IO to the log file to allow each buffer to be    !   posted as written.  Changed the formatting; changed from octal  !    to decimal output.  Added lost message counter.  4/30/85  ash     Added PostLog procedure to log the version 1 log messages.   5/17/85  ash     Added open with 'q' option      Added code to map urec to socket.   ------------------ POST ----------------------       6/5/85     Bug look at 2nd parameter in runstring      Print 'N/A' in logfile if no ecode present      Change internal doc for postlog to reflect the log file  7/10/85      Accept octal logmask only.   8/11/85   	   Add detach call 	    Change logfile default to '/SYSTEM/NS_EVENT.LOG'      Add Gateway, timer, IFP  to list of entities      Remove search of init_dec and dres      Remove socket cleanup;  now done by abort processor   ------------------ POST ----------------------   9/30/85      Import trcmod before sigmod  ------------------- POST ----------------------   11/14/85     Add sigmod as an entity.      Add Inpro, outpro, prosw, and uplin.      Remove error code field from header.      Read and write log mask from DS_LogMask.      Modify numchk to accept octal values only.      Clear break flag before starting.  ------------------- POST ----------------------   12/17/85     Add Runtime entity (DS_ErrorCatcher)   ----------------- RELEASE --------------------  3/31/86  n380   "   Add log file name to the global block so it will be accessible to "    NSINF.   4/3/86   n397   	   Add timestamps  	    Remove nulls from node name  ----------------- RELEASE --------------------  4/23/86  n421      Make file name stored in DSAM the full path file name.   %------------------------------------------------------------------------}  % {}  { PROGRAM DESCRIPTION :   "{  This is the monitor which sits on a socket waiting for events to  " ${  be mailed to it.  It reads it in and then posts it to one of several  $ "{  files.  The procedure which sends messages to EvMon is resonsible " #{  for seeing if they are "Loggable" events.  That is if the severity  # !{  code is high enough to warrant sending this particular message. ! {   {  Runstring:   {     RU EVMON [,logfile name] [,logmask]   {}  LABEL      9;       IMPORT        $search 'phtm/bodec.rel'  bodec,      { General Purpose declarations }        $search 'phtm/SODEC.rel'  sodec,      { Socket specific declaraions  }        $search 'phtm/MMdec.rel'  mmdec,      { MMgr specific declarations   }        $search 'phtm/MMEXT.rel'  ds_mm,      { Memory  Manager routines     }        $search 'phtm/trcmod.rel'   trcmod,     { Procedure and declarations for event handling }         $search 'phtm/SIGMOD.rel'   sigmod,     { Socket Routines              }        $search 'phtm/envok.rel'  envok;          $page       CONST      BIGVAL         = MAXINT16;      BUFRLEN        = 4;         { length of buffer to SBGet }     ABORT          = 57;        { action on getting an error }      RETURN         = 58;        { ditto }      !   { longest length for mask, given bits we have defined (0..7) }  !    MAXMASKLEN     = 3;         {  offsets into the various fields of msg }  
   VERSION     =  2; 
 
   INFOLEN     = 12; 
 
   ENTITY      =  8; 
 
   EVENTTYPE   =  1; 
 
   ECODE       = 13; 
 
   LOCATION    =  9; 
 
   PATHREF     = 10; 
 
   TRACEMASK   =  3; 
 
   PROCNAME    =  4; 
 
   SESSION_LU  =  7; 
 
   INFOSTART   = 25; 
        { default log file name }     DEFAULT_LOG = '/SYSTEM/NS_EVENT.LOG';      TYPE  
   ErmsgType = String[60]; 
    OctalType = Packed Array [1..6] of Char;      LongAscType = RECORD Case Int16 OF            1 : ( bufr : Int16);            2 : ( chars : PACKED ARRAY [1..MMMLEN] OF CHAR);            3 : ( words : ARRAY [1..MMMLEN DIV 2] OF Int16);   
           END;   { case } 
        { Types needed for the FMP routines }     DCBlock = ARRAY [1..144] of Int16;      fdesc   = String[64];     fmpopts = String[5];      databuf = PACKED ARRAY[1..80] of CHAR;      PacPtr  = ^databuf;          VAR      dcb       : DCBlock;   !   dummy     : Int16;           { dummy variable for detach call } ! 
   endmsg    : String[80]; 
    err       : Int16;   
   errfile   : TEXT; 
    gbl       : EventGlobal;      gsd       : Int16;           { Global socket descriptor }     logsocket : SocketRecord;  !   logtime   : Int32;           { Time to appear in the log file } !    mmflags   : MMFlagsType;     { needed for SBGet }     msg       : LongAscType;     { data sent from send_event }      ndropped  : Int16;   
   prevdropped   : Int16;  
    sigrec    : SignalRecord;     vdbuf     : VectoredDataType;      $page   {------------------------------------------}  {        External Declarations  {------------------------------------------}      { Procedure to get the byte address of a variable in memory }   PROCEDURE Adrof   &   (VAR firstword : Int16;  { Points to the first word in the data buffer }  & 
        offset    : Int16; 
     VAR ByteAddress : Int16);  { Address of the buffer }     EXTERNAL;      { Procedure to conver a number to an octal string }   PROCEDURE CNumO      (    num  : Int16;   
    VAR bufr : OctalType); 
    EXTERNAL;      
$ FIXED_STRING ON $  
     { Procedure to make the current time look pretty }  	PROCEDURE DayTime  	    (    time   : Int32;   
    VAR tmbuf  : String);  
    EXTERNAL;      
$ FIXED_STRING OFF $ 
 { Procedure to detach program from scheduling session }   PROCEDURE Detach           $ALIAS 'DTACH' $      (VAR dummy : Int16);      EXTERNAL;          { Procedure to store the socket ID in the user record }   PROCEDURE DS_StoreURec     (    urecid : Int16;           urec   : Int16);     EXTERNAL;          	$FIXED_STRING ON$  	 { Procedure to position to the end of a file }  
PROCEDURE FMPAppend  
    (VAR dcb  : DCBlock;       VAR error : Int16);      EXTERNAL;      	PROCEDURE FMPClose 	    (VAR dcb  : DCBlock;       VAR error : Int16);      EXTERNAL;      { Procedure to open a file }  	PROCEDURE FmpOpen  	    (VAR dcb  : DCBlock;       VAR error : Int16;  
        filedesc : fdesc;  
         options  : fmpopts;   
        bufs     : Int16); 
    EXTERNAL;          { Procedure which writes the buffer to the file }   	PROCEDURE FMPPost  	    (VAR dcb   : DCBlock;      VAR error : Int16);      EXTERNAL;      !{ Procedure to get the fully qualified path name of the log file } ! PROCEDURE FMPShortName  
   (VAR dcb    : DCBlock;  
     VAR error  : Int16;       VAR filedesc  : fdesc);      EXTERNAL;          { Procedure to write the data to the dcb }  	PROCEDURE FMPWrite 	    (VAR dcb   : DCBlock;      VAR error : Int16;      VAR dbuf  : Databuf;      VAR length : Int16);     EXTERNAL;  
$ FIXED_STRING OFF$  
         { Function to determine if my break flag is set }   FUNCTION IfBrk        : Int16;     EXTERNAL;      { Return our id segment address }   FUNCTION MyIdAdd        : Int16;     EXTERNAL;      "{ Procedure to retrieve the runstring and insert it into a string }  " FUNCTION Pas_SParms        $ ALIAS 'Pas.SParameters' $  "   (    pos : Int16;       { position of the parm in the runstring } " "    VAR parm : String)     { the parameter given by the scheduler }  "              : Int16;      { Length (bytes) of the parameter }     EXTERNAL;      { Procedure to get the data in a string }   FUNCTION PasStringData  $ALIAS 'Pas.StringData1' $  
   (VAR s : String)  
 
          : PacPtr;  
    EXTERNAL;      { Function to get the current time }  FUNCTION TimeNow     : Int32;      EXTERNAL;          $page   ${---------------------------------------------------------------------}  $ ${                    Forward Declarations                             }  $ ${---------------------------------------------------------------------}  $     { Check the system time, and post it if necessary }   
PROCEDURE CheckTime  
 
   (VAR lastime   : Int32; 
     VAR dcb       : DCBlock);      FORWARD;           { Error Escape }  PROCEDURE Exit  
   (    ermsg : ErmsgType; 
         error : Int16;          action: Int16);      FORWARD;       { Get The log mask if it is supplied }  	PROCEDURE GetMask  	 
   (VAR logmask : Int16);  
    FORWARD;           #{ Gets the message from the socket and cleans up any mess left over }  # PROCEDURE GetTheMessage      (VAR vdbuf       : VectoredDataType;       VAR dcb         : DCBlock;      VAR ndropped    : Int16;      VAR prevdropped : Int16;      VAR lastime     : Int32;  !    VAR msg         : LongAscType);  { data sent from send_event } !    FORWARD;           { Log an error to the log file }  	PROCEDURE LogError 	 
   (    ermsg : ErmsgType; 
         error : Int16;  
    VAR dcb   : DCBlock);  
    FORWARD;           { Log a line or record to the log file }  
PROCEDURE LogToFile  
 
   (VAR logline : String;  
     VAR filebuf : DCBlock);      FORWARD;       { Check string to be sure it is numeric }   FUNCTION Numchk      (VAR numstring : String)   
               : BOOLEAN;  
    FORWARD;           { Open the log file }   	PROCEDURE OpenLog  	    (VAR DCB      : DCBlock;       VAR gbl      : EventGlobal);     FORWARD;           { Posts events to the log file }  
PROCEDURE PostEvent  
    (VAR msg : LongAscType;  { event/error message received }  
        ndropped : Int16;  
     VAR filebuf  : DCBlock);     FORWARD;       { Posts version 2 events to the log file }  	PROCEDURE PostLog  	    (VAR msg       : LongAscType;      VAR filebuf   : DCBlock);      FORWARD;           { Takes care of initialization }  PROCEDURE SetUp      (VAR gbl       : EventGlobal;      VAR gsd       : Int16;       { socket descriptor }      VAR logsocket : SocketRecord;       VAR DCB       : DCBlock);  { File buffer }     FORWARD;       
{ Initializes the socket } 
 
PROCEDURE SocketInit 
 
   (VAR gsd       : Int16; 
     VAR logsocket : SocketRecord);     FORWARD;       
{ Writes header to file }  
 PROCEDURE WriteHeader      (VAR DCB : DCBlock);      FORWARD;       $ PAGE $  {*************************************************}   {           PROCEDURES and FUNCTIONS              }   {*************************************************}       {-------------------------------------------------}   {              CheckTime  {-------------------------------------------------}   { Check the system time, and post it if necessary }   
PROCEDURE CheckTime  
 
   (VAR lastime   : Int32; 
     VAR dcb       : DCBlock);       VAR      currenttime : Int32;      timestring  : string[30];      
BEGIN { Checktime }  
 	timestring := '';  	 currenttime := Timenow;   IF currenttime <> lastime THEN     BEGIN     setstrlen (timestring, 28);     DayTime (currenttime, timestring);      LogToFile (timestring, dcb);   
   lastime := currenttime; 
    END;   
END;  { Checktime }  
         $SUBTITLE 'Error Exit', PAGE $  { Error Escape }  {-------------------------------------------}   {           Exit                            }   {-------------------------------------------}       PROCEDURE Exit  
   (    ermsg : ErmsgType; 
         error : Int16;          action: Int16);           	   BEGIN { Exit }  	    writeln (errfile, 'EVMON: ', ermsg, error:1);         IF action = ABORT THEN goto 9;       	   END;  { Exit }  	     $SUBTITLE 'GetMask  ', PAGE $   {----------------------------------------------}  {        GetMask  {----------------------------------------------}  	PROCEDURE GetMask  	 
   (VAR logmask : Int16);  
      { Procedure to pick up and store a log mask if it is supplied }        VAR      errmsg   : ErMsgType;  	   parm2 : Int16;  	    mask  : String[20];  	   len   : Int16;  	 
   lastchar : Int16; 
 
   scanend  : Int16; 
     BEGIN      len := Pas_SParms (2, mask);       	   IF len > 0 THEN 	       BEGIN { something entered }         mask := strltrim (mask);        mask := strrtrim (mask);        lastchar := strlen(mask);         IF mask[lastchar] = 'B' THEN           BEGIN { user added a 'B', remove it }           mask[lastchar] := ' ';            mask := strrtrim (mask);            lastchar := lastchar - 1;           END;  { user added a 'B', remove it }            IF (numchk (mask)) AND (lastchar <= MAXMASKLEN) THEN           BEGIN           logmask := octal (mask);            END        ELSE           BEGIN           errmsg := 'Invalid trace mask: ' + mask;            exit (errmsg, EL_BADVALUE, ABORT);            END;         END   { something entered }      ELSE         BEGIN { no change in the mask }   
      logmask := 0;  
       END;  { no change in the mask }   END;      $SUBTITLE 'GetTheMessage  ', PAGE $   {----------------------------------------------}  {        GetTheMessage  {----------------------------------------------}  PROCEDURE GetTheMessage      (VAR vdbuf : VectoredDataType;       VAR dcb : DCBlock;  
    VAR ndropped : Int16;  
     VAR prevdropped : Int16;  
    VAR lastime   : Int32; 
     VAR msg : Longasctype);       !{ Procedure which gets the message from the socket and cleans up } ! !{     if there is left over data or if there are errors.         } !     VAR   	   wkmp  : Int16;  	 	   err   : Int16;  	 	   chars : Int16;  	    queue : SBQueueType;      gbl   : EventGlobal;       	PROCEDURE Cleanup; 	 "   { Called if there is an error dropping messages from the queue. } "    { This procedure is an encapsulation for clarity only }         VAR  
      drop_err    : Int16; 
 
      exitstatus  : Int16; 
         
   BEGIN { Cleanup } 
    LogError ('SBDrop ', err, dcb);     DS_SBDrop (gbl.sbufid, MMDROPALL, queue, drop_err);     DS_LeaveCritical (wkmp);      IF drop_err <> 0 THEN        BEGIN { cannot clean up; better abort }   
      exitstatus := ABORT; 
       err := drop_err;        END      ELSE         BEGIN         exitstatus := RETURN;         END;      %   exit ('Unexpected error cleaning up message queue ', err, exitstatus);  % 
   END;  { Cleanup } 
     $ PAGE $      BEGIN { GetTheMessage }   queue := 3;   err := 0;       	WHILE err = 0  DO  	 
   BEGIN { err = 0 } 
    chars := MMMLEN;  { gets changed every call }     DS_EnterCritical (wkmp, err);  
   IF err <> 0 THEN  
       BEGIN         LogError ('Enter Critical ', err, dcb);         exit ('Access to DSAM not allowed ', err, ABORT);         END;         DS_FetchElement (DS_EventGlobalsTD, 1, gbl.bufr);     DS_SBGet (vdbuf, BUFRLEN, gbl.sbufid, queue,                  mmflags, chars, err);     DS_LeaveCritical (wkmp);              WITH gbl DO        BEGIN  { dropped any between gets? }        ndropped := evdropped - prevdropped;        prevdropped := evdropped;         END;   { dropped any between gets }          CASE err OF        0 : BEGIN   $          CheckTime (lastime, dcb);  { see if we need a new timestamp }  $           PostEvent (msg, ndropped, dcb);             END;      
      MMWOULDBLOCK : 
           BEGIN              { nothing to do; no more messages }            END;            MMDATALEFTOVER :           { We will read in the first part of the messge, }           {  and drop the rest.  Change the length field. }            BEGIN             IF msg.words[INFOLEN] < 0 THEN               BEGIN  { write the # chars }                msg.words[INFOLEN] := -(chars-24);                END            ELSE msg.words[INFOLEN] := (chars-24) DIV 2;      $          CheckTime (lastime, dcb);  { see if we need a new timestamp }  $ #          PostEvent (msg, ndropped, dcb);      { send the first part } #               DS_EnterCritical (wkmp, err);   
          IF err <> 0 THEN 
 	             BEGIN 	              LogError ('Enter Critical ', err, dcb);               Exit ('Access to DSAM not allowed ', err, ABORT);  	             END;  	               { -1 means drop one message }             DS_SBDrop (gbl.sbufid, -1, queue, err);       #          { If we get an error here, we want to clean up the queue, }  # #          {  and then continue to get messages if possible.         }  #     
          IF err <> 0 THEN 
 	             BEGIN 	              CleanUp;                END;  { error recovery }             DS_LeaveCritical (wkmp);         END;             OTHERWISE             BEGIN  { an error other than no messages waiting }            LogError ('DS_SBGet ', err, dcb);   "          exit ('Unexpected error getting a message ', err, ABORT);  "           END;      
      END;  { case } 
 	   END;  { while } 	 END;  { GetTheMessage }               $SUBTITLE 'LogError  ', PAGE $  {----------------------------------------------}  	{        LogError  	 {----------------------------------------------}  	PROCEDURE LogError 	 
   (    ermsg : ErmsgType; 
         error : Int16;  
    VAR DCB   : DCBlock);  
          { Procedure to convert the error message to a string and send }     { it off to the log file.                                     }        VAR      len : Int16;   { length of the error message coming in. }     timestring : String[30];       BEGIN          setstrlen (timestring, 28);     DayTime (TimeNow, timestring);   
   len := Strlen (ermsg);  
    { add the error code and a time stamp }     strwrite (ermsg, len, len, error, '  ', timestring);       
   LogTofile (ermsg, dcb); 
     	END;  { LogError } 	         $SUBTITLE 'LogToFile  ', PAGE $   {----------------------------------------------}  	{        LogToFile 	 {----------------------------------------------}  
PROCEDURE LogToFile  
 
   (VAR logline : String;  
     VAR filebuf : DCBlock);       VAR      write_err : Int16;      length    : Int16;           BEGIN   write_err := 0;       { write the line into the file buffer }   length := Strlen (logline);    FmpWrite (filebuf, write_err, PasStringdata(logline)^, length);    IF write_err <> 0 THEN     BEGIN { register error and abort }      exit ('Error writing to log file ', write_err, ABORT);      END;  { register error and abort }       { Post the file buffer to the file }  FmpPost (filebuf, write_err);   IF write_err <> 0 THEN     BEGIN { register error and abort }      exit ('Error writing to log file ', write_err, ABORT);      END;  { register error and abort }       END;  { log to file }       $SUBTITLE 'NUMCHK ', PAGE $   {---------------------------------------------}   {         Numchk  {---------------------------------------------}   FUNCTION Numchk      (VAR Numstring : String)               : BOOLEAN;      {}  !{  Procedure to check that all characters in a string are numeric. ! {  It assumes the input string has been trimmed of blanks.  {}      VAR      Numeric  : BOOLEAN;  
   pos      : Int16; 
 
   len      : Int16; 
     BEGIN   
   numeric := TRUE;  
    pos   := 1;         len := strlen (numstring);   	   IF len > 0 THEN 	       REPEAT   { we have something to work with }         CASE (numstring[pos]) OF        '0'..'7' : BEGIN                   pos := pos + 1;                   END;         Otherwise  BEGIN                   numeric := FALSE;                   END;   
      END;  { case } 
       UNTIL ((pos > len) OR (NOT numeric))     ELSE         BEGIN { 0 length string }         numeric := FALSE;         END;  { 0 length string }          Numchk := numeric;       END;  { Numchk }      $SUBTITLE 'OPEN LOG ', PAGE $   {---------------------------------------------}   {     Open Log  {---------------------------------------------}   	PROCEDURE OpenLog  	    (VAR DCB      : DCBlock;       VAR gbl      : EventGlobal);      {}  "{ Procedure to open the Log File, whether or not it already exists.  " {  The log file name is then added to the Global Block.   {}      CONST      NOTTHERE = -6;  { error return from FmpOpen }      VAR   
   len      : Int16; 
 
   logfname : fdesc; 
    options : fmpopts;   
   open_err : Int16; 
     $ PAGE $      	BEGIN { openlog }  	 !   { Open the file for shared access so that people may read it }  ! !   { while logging is enabled.                                  }  !     	   open_err := 0;  	 #   options := 'qrwos';   { Open shared, read and write quick access }  # 	   logfname := ''; 	        len := PAS_SParms (1, logfname);   
   IF len <= 0 THEN  
       BEGIN { use default }         logfname := DEFAULT_LOG;        END;  { use default }          { First try to overwrite an existing file by this name }      FmpOpen (DCB, open_err, logfname, options, 1);      IF open_err = NOTTHERE THEN        BEGIN   
      open_err := 0; 
       options := 'rwcs';        FmpOpen (DCB, open_err, logfname, options, 1);        { open_err > 0 is the type of the file }  
      IF open_err < 0 THEN 
          BEGIN           exit ('Error opening log file ', open_err, ABORT);            END        END      ELSE IF open_err < 0 THEN        BEGIN { any other error.. bail out }        exit ('Error opening log file ', open_err, ABORT);        END;         FmpAppend ( dcb, open_err);     IF open_err <> 0 THEN        BEGIN         exit ('Error writing to log file ', open_err, ABORT);         END;      { Now get the full path name to store in globals }  WITH gbl DO      BEGIN     setstrlen (logfname, strmax(logfname));     FMPShortname (dcb, open_err, logfname);     IF open_err <> 0 THEN        BEGIN         exit ('Error getting full path name ',open_err, ABORT);         END;         logFNamelen := strlen (LogFName);     strmove (logfnamelen, logfname, 1, logfilename, 1);     END; { with }      	END;  { openlog }  	     $ SUBTITLE 'Post Event  ', PAGE $   { Posts events to the log file }  {-------------------------------------------------}   {              PROCEDURE PostEvent                }   {-------------------------------------------------}   
PROCEDURE PostEvent  
     (VAR msg      : LongAscType; { event/error message received }   #        ndropped : Int16;      { number dropped since the last post }  #     VAR filebuf  : DCBlock);          { Discussion:   {  Write the message in the indicated format to the log file.   !{  The message comes into this procedure in the following format:  ! 
{     word 1 :  Event Type 
 {     word 2 :  Reporting PID   {     word 3 :  Length of message. + => words, - => characters  {     word 4..n : The message.  {   #{  If the message arrives in character format, it is written into the  # !{  file as a string.  If it arrives in numeric format, each of the ! "{  numbers is written into a string and then posted to the file one  " 
{  line buffer at a time.  
 {   "{  Because of backward compatibility problems, (yes, Virginia, they  " "{  even happen in the course of development), the sign bit (bit 15)  " !{  of the EVENTTYPE word in the message will be set if we have to  ! 
{  use PostLog to format.  
 {}  CONST      START = 9;  { start of data in an ascii message }     LINELENGTH = 8;   { length of a line in a numeric message }      VAR   
   str : String[2];  
    int : Int16;   !   msg_o : OctalType;    { octal string for a word in binary msg}  ! 
   mess : string[MMMLEN];  
 	   j      : Int16; 	 
   nextpos : Int16;  
    length : Int16;   { length; + => words, - => chars }      newline : BOOLEAN;   
   evtype   : MMFlagsType; 
     $ page  
BEGIN { PostEvent }  
 nextpos := 1;  { string position index }  
j := 0;  { counter } 
 mess := '';       IF ndropped <> 0 THEN      BEGIN { dropped messages; log count to file }     Strwrite (mess, 1, j, ndropped:1, ' messages dropped.');      Logtofile (mess, filebuf);      mess := '';     END;  { dropped messages; log count to file }      evtype.int := msg.words[EVENTTYPE];       { See if this is from LogEvent (bit 15 will be set) }   IF evtype.bits[-15] THEN     BEGIN  
   PostLog (msg, filebuf)  
    END  ELSE     BEGIN     WITH msg DO        BEGIN   
      length := words[3];  
        IF length = 0 THEN          { QA: will this ever happen? }            BEGIN { 0 length message }            { error tracking for send_event }           mess := 'Send_event sent 0 length message.';            LogToFile (mess, filebuf);            END   { 0 length message }         ELSE           BEGIN  '         strwrite (mess, 1, j, 'Type: ',words[1]:1, '     PID: ',words[2]:1);  '          LogTofile (mess, filebuf);   
         mess := ''; 
          IF length < 0 THEN   	            BEGIN  	             strmove (-length, chars, START, mess, 1);               LogToFile (mess, filebuf);              END   { length < 0 }           ELSE { length > 0 }              FOR j := 1 TO length DO   
               BEGIN 
                newline := (j MOD LINELENGTH = 0);   #               strwrite (mess, nextpos, nextpos, ' ':1, words[j+3]:1); #     #               IF ((newline) OR   { if the line in the buffer is full} # #                  (j=length)) THEN   { if we have finished a record }  #                   BEGIN                     LogToFile (mess, filebuf);                    mess := '';                     nextpos := 1;                     END;                 END;  { for loop }            END;  { ELSE something to write }  
      END;  { with } 
 	   END;  { else }  	 
END;  { PostEvent }  
     $ SUBTITLE 'PostLog ', PAGE $   {-------------------------------------------------}   {              PostLog  {-------------------------------------------------}   	PROCEDURE PostLog  	    (VAR msg     : LongAscType;      VAR filebuf : DCBlock);       {}  { Discussion:   {  Procedure to log the level 2 events to the log file. }   {  The format of the first line will be:                }   {   "{  EVENTTYPE  ENTITY  LOCATION  PATHREF  TRACEMASK  PROCNAME  SSN# } " {   #{  The second line will contain the info field, indented one space for # {  easy reading, and printed either in ascii or numbers.  {}      $ PAGE $  CONST   
   LINELENGTH  = 12; 
    FIRST_ENTITY   = ENTITY_RUNTIME;       TYPE  
   Str10    = String[10];  
    str8     = string[8];  !   Entities = ARRAY [FIRST_ENTITY..LAST_INDIVIDUAL_PID] of Str10;  !    evtypes  = array [0..LASTEVENT] of str8;       CONST      PIDS     = Entities [                          str10['RUNTIME   '], { entity = -8 }                          str10['UPLIN     '], { entity = -7 }                          str10['OUTPRO    '], { entity = -6 }                          str10['INPRO     '], { entity = -5 }                          str10['PROSW     '], { entity = -4 }                          str10['SIGMOD    '], { entity = -3 }                          str10['TIMER     '], { entity = -2 }                          str10['          '], { entity = -1 }                          str10['HP-IPC    '], { pid = 0 }                          str10['ETHERNET  '], { pid = 1 }                          str10['X25       '], { pid = 2 }                          str10['MAPLE     '], { pid = 3 }                          str10['HP-TCP    '], { pid = 4 }                          str10['UDP       '], { pid = 5 }                          str10['HP-PXP    '], { pid = 6 }                          str10['IEEE-802  '], { pid = 7 }                          str10['HP-IP     '], { pid = 8 }                          str10['TELEPHONE '], { pid = 9 }                          str10['NBS-XPORT '], { pid = 10 }                           str10['HP-IFP    '], { pid = 11 }                           str10['HP-ROUTER '], { pid = 12 }                           str10['          '], { pid = 13 }                           str10['HP-GATEWAY'], { pid = 14 }                           str10['          '], { pid = 15 }                           str10['          '], { pid = 16 }                           str10['          '], { pid = 17 }                           str10['          '], { pid = 18 }                           str10['          '], { pid = 19 }                           str10['HP-RPM    '], { pid = 20 }                           str10['HP-NFT    '], { pid = 21 }                           str10['HP-VT     '], { pid = 22 }                           str10['SREG      '], { pid = 23 }                           str10['HP-PROBE  ']  { pid = 24 }                            ];              events = EvTypes [str8['LogStat '],                       str8['ProLog  '],                       str8['Event   '],                       str8['Warning '],                       str8['Error   '],                       str8['Disaster'],                       str8['RsrceLim'],                       str8['TestMsg ']   
                        ]; 
     $ PAGE $  VAR   
   sender   : Int16; 
    mask     : OctalType;     mess     : String[MMMLEN];   
   msgend   : Int16; 
 
   length   : Int16; 
    Pname    : OctalType;  
   i        : Int16; 
 
   nxtpos   : Int16; 
    newline  : Boolean;  
   evtype   : mmflagstype; 
     $ PAGE $      	BEGIN { PostLog }  	     mess := '';       sender := msg.words [ENTITY];   evtype.int := msg.words[EVENTTYPE];   evtype.bits[-15] := FALSE; { clear bit 15 }   Strwrite (mess, 1, nxtpos, ' ', events[evtype.int],' ');      IF ( sender >= FIRST_ENTITY )        AND     ( sender <= LAST_INDIVIDUAL_PID ) THEN      BEGIN { within known range }      Strwrite (mess, nxtpos, nxtpos, pids[sender]);      END   { within known range }   ELSE     BEGIN     strwrite (mess, nxtpos, nxtpos, sender:10);     END;       length := msg.words [INFOLEN];      WITH msg DO      BEGIN     Strwrite (mess, nxtpos, nxtpos, '  ', words[LOCATION]:6,                words[PATHREF]:6, words[PATHREF+1]:6);          cnumo (words[TRACEMASK], mask);     strwrite (mess, nxtpos, nxtpos, mask, 'b');      %{ Since the ID segment holds only a 5 character name, the last char will } % { always be blank, so stick '/' in there}          FOR i := 1 to 5 DO         pname[i] := chars[i+6];       
   pname[6] := '/';  
 #   strwrite (mess, nxtpos, nxtpos,'    ', pname, words[SESSION_LU]:1); # 	   END;  { with }  	     
LogToFile (mess, filebuf); 
     nxtpos := 4;  mess := '   ';      	IF length < 0 THEN 	    BEGIN { write characters to the file }      strmove  (-length, msg.chars, INFOSTART, mess, nxtpos);     LogTofile (mess, filebuf);      END  ELSE IF length = 0 THEN      BEGIN     mess := ' ';      LogToFile   (mess, filebuf);      END  ELSE     BEGIN { write numbers to the file }     msgend := length + ECODE - 1;     FOR i := ECODE to msgend DO        BEGIN         newline := (i MOD LINELENGTH = 0);        strwrite (mess, nxtpos, nxtpos, msg.words[i]:1, ' ');             IF newline OR (i = msgend) THEN            BEGIN           LogToFile (mess, filebuf);            mess := '   ';            nxtpos := 4;            END;   
      END;  { for }  
 
   END;  { write numbers } 
         	END;  { PostLog }  	     $ SUBTITLE 'SetUP ', PAGE $   { Initializes the socket, gets runstring and opens files }  {-------------------------------------------------}   {              PROCEDURE SetUp                    }   {-------------------------------------------------}   PROCEDURE SetUp      (VAR gbl   : EventGlobal;      VAR gsd   : Int16;       { socket descriptor }      VAR logsocket : SocketRecord;   
    VAR DCB   : DCBlock);  
        VAR  
      error : Int16; 
 !      evlmask   : MMFlagsType;    { log mask in the globals area } !       logfilename : fdesc;    { error file name }   
      wkmp  : Int16; 
     	   BEGIN { SetUp } 	    DS_EnvOK ('EVMON ');          DS_EnterCritical (wkmp, error);     IF error <> 0 THEN         BEGIN         exit ('Access to DSAM not allowed', error, ABORT);        END;     DS_FetchElement (DS_EventGlobalsTD, 1, gbl.bufr);     DS_LeaveCritical (wkmp);           SocketInit (gsd, logsocket);       { Initialize the socket }       gbl.SBufId := gsd * 2 - 1; { Inbound socket buffer }              OpenLog (DCB, gbl);         WriteHeader (DCB);       
   GetMask (evlmask.int);  
        DS_EnterCritical (wkmp, error);     IF error <> 0 THEN         BEGIN         LogError ('Enter Critical ', error, DCB);         exit ('Access to DSAM not allowed ', error, ABORT);         END;     DS_StoreElement (DS_EventGlobalsTD, 1, gbl.bufr);     IF evlmask.int <> 0 THEN         BEGIN { change the mask }         evlmask.bits[0] := TRUE;   { bit 0 is always set }        DS_StoreGlobal (DS_Logmask, 1, evlmask.int);        END;  { change the mask }      DS_LeaveCritical (wkmp);           	   END;  { SetUp } 	 $page   {-------------------------------------------------}   {              PROCEDURE SocketInit               }   {-------------------------------------------------}   
PROCEDURE SocketInit 
 
   (VAR gsd : Int16; 
     VAR logsocket : socketrecord);         CONST        MAXMSGIN  = 20;      { max msg queued inbound }         INLEN     = MMMLEN;  { largest inbound message }        MAXMSGOUT = 20;      { max msg queued outbound }        OUTLEN    = MMMLEN;  { largest outbound message }          VAR        error     : Int16;   { error from mmgr calls }        wkmp      : Int16;   { for enter and leave crit calls }         urecid    : Int16;   { index into user record table }         urec      : UserRecord;         temp      : Int16;         BEGIN { SocketInit }      { Get a user record for this process }      DS_EnterCritical (wkmp, error);     IF error <> 0 THEN         BEGIN { Internal error }        exit ('Access to DSAM not allowed ', error, ABORT);         END;  { Internal error }     FindUserRecord (MyIdAdd, urecid, urec, error);      IF error <> 0 THEN         BEGIN { Internal error }        DS_LeaveCritical (wkmp);  "      exit ('Unexpected error getting User Record ', error, ABORT);  "       END;  { Internal error }      { Create and initialize the socket }      %   SoCreate (MAXMSGIN, INLEN, MAXMSGOUT, OUTLEN, ROOTSOCKET, gsd, error);  %    IF error <> 0 THEN         BEGIN         DS_LeaveCritical (wkmp);        exit('Unexpected error creating socket ', error, ABORT);        END;      !{ Now store the rnd of the user record in the socket record, tying ! {  this process to the root socket we just created }  !{  Fetch the whole element for now... need to change only a byte } !        DS_SoFetchElement (gsd, logsocket.int);     logsocket.so_b.userrnd := urec.ur_rnd;      logsocket.so_urecid := urecid;      DS_SoStoreElement (gsd, logsocket.int);      ${ Now make the pointer go the other way as well, attaching the socket }  $ {  to the user record. }     AttachSoToUser (urec, gsd, temp);     DS_StoreURec (urecid, urec.int);      DS_LeaveCritical (wkmp);          END;  { SocketInit }       $SUBTITLE 'WriteHeader', PAGE $   {------------------------------------------------}  {           PROCEDURE WriteHeader                }  {------------------------------------------------}  PROCEDURE WriteHeader      (VAR DCB : DCBlock);       { Procedure to write the start time and the node name }   { into the log file.                                  }       VAR   
   ierr     : Int16; 
    mess     : String[MMMLEN];      namestring  : String[60];  
   noderec  : NodeRecord;  
 
   nxtpos   : Int16; 
    timestring  : String[30];  
   wkmp     : Int16; 
         BEGIN   
   timestring := ''; 
 
   namestring := ''; 
    DS_EnterCritical (wkmp, ierr);   
   IF ierr <> 0 THEN 
       BEGIN         LogError ('Enter Critical ', ierr, dcb);        exit ('Access to DSAM not allowed ', ierr, ABORT);        END;         DS_FetchElement (Ds_NodesTD, 1, noderec.int);     DS_LeaveCritical (wkmp);          setstrlen (timestring, 28);     DayTime (TimeNow, timestring);          LogToFile (timestring, DCB);       	   WITH noderec DO 	 "      strmove (nr_nodenamelen, nr_nodename.chars, 1, namestring, 1); "        mess := '                  Event Log at ' + namestring;  
   LogToFile (mess, DCB);  
    mess := ' ';   
   LogToFile (mess, DCB);  
     END;          $page   {------------------------------------------------}  {              Main                              }  {------------------------------------------------}  BEGIN { EvMon }       { open error file; LU 1 for now }   rewrite (errfile, '1');       SetUp (gbl, gsd, logsocket, DCB);       Sigrec.longint := 0;    { initialize the signal record }  "Sigrec.er_flags[Data_RSelenable] := TRUE;  { make socket readable }  " Adrof (msg.bufr, 0, vdbuf[1]);  vdbuf[2] := MMMLEN;   { largest it can be is one emsg }       mmflags.int := 0;       { initialize mmflags }  mmflags.bits[0] := FALSE;  { release mbufs after read }   mmflags.bits[-1] := TRUE;  { give me exactly one message }      	prevdropped := 0;  	     { Finally detach from the session }   Detach (dummy);       !dummy := Ifbrk;   { clear any break flag which may have been set } !     Logtime := TimeNow; { get the current time }      	WHILE IFBrk = 0 DO 	 	   BEGIN { while } 	    { wait for something to happen }      SoAwaitSig (gsd, INBOUND_SIG, sigrec, err);  
   IF err <> 0 THEN  
       BEGIN         LogError ('Error log terminating ', err, dcb);        exit ('Error log terminating ', err, ABORT);        END;      "   GetTheMessage (vdbuf, dcb, ndropped, prevdropped, logtime, msg);  "     	   END;  { while } 	         9:  "   { The abort processor will clean up the socket and the globals }  "    { Add a closing message }  
   setstrlen (endmsg, 28); 
    DayTime (TimeNow, endmsg);      endmsg := endmsg + '   Event logging terminated.';      LogToFile (endmsg, DCB);          FmpClose (dcb, err);   END.  { EvMon }  