     $PASCAL ',6,99 91790-16059 REV.4010 <860409.1557>'  $TITLE 'FMTRC Trace Formatter--Main Segment'$   
$STANDARD_LEVEL 'HP1000' $ 
 $DEBUG $  $RECURSIVE OFF$   $ HEAP 2 $  
$ HEAP_DISPOSE OFF $ 
 $ CDS ON $  $ RANGE OFF $               PROGRAM FMTRC;      %{------------------------------------------------------------------------  %     "   (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986.  ALL RIGHTS RESERVED. "    NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED, REPRODUCED, OR   "   TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR WRITTEN  "    CONSENT OF THE HEWLETT-PACKARD COMPANY.      % ------------------------------------------------------------------------} %     {}  {        NAME : FMTRC   {      SOURCE : 91790-18059   {       RELOC : 91790-16059   
{        PGMR : JXL  
 {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date   PCO   Prgmr  Description  {   {   12/85  Beta  JXL    Bug Fixes   ${   4/9/86  2626  ash   Removed global label, replaced with Pascal HALT  $ {                       SR#36004  {   {------------------------------------------------------------   {}  "{  FMTRC reads unformatted messages out of a VMA file that has been  " !{  created by the AdvanceDS program NETRC.  FMTRC formats the raw  ! #{  trace messages and extracts certain information about each message  # #{  from an appended buffer and in some cases from the message header.  # "{  The user can specify options that limit the formatted output to a " {  subset of the messages contained in the raw trace file.  {   {  FMTUI, FMVIN and FMTER are segments of FMTRC.  {   {}  {  Runstring parameters:  {   {    RU, FMTRC [,command input name]  {              [,raw file name]   {              [,format file name]  {              [,label field]   {              [,error file name]   {   "{    command input name  File for user commands or Log LU for user's " {                        interactive input and error logging  {    raw file name       VMA file created by NETRC  "{    format file name    File to which formatted output is directed  " #{    label field         A user's title for this run of the formatter  # {    error file name     File to which errors are logged  {}  { Calls   {  CheckFMPError           FMTRC procedure  {  CheckFMPWriteError      FMTRC procedure  {  CheckOptionsCommands    FMTRC procedure  {  ErrorProc               FMTRC procedure  {  FileInteractive         FMTRC procedure  {  FilterMessages          FMTRC procedure  {  FMPClose                RTE library routine  {  IfBrk                   RTE library routine  {  InitFormatFile          FMTRC procedure  {  InitVMA                 FMTRC procedure  {  OpenFiles               FMTRC procedure  {  ProcessCommandFileParms FMTRC procedure  {  QueryUser               FMTRC procedure  {  ReadCommandFile         FMTRC procedure  {  ReadRunstringParms      FMTRC procedure  {  ReadVmaHeader           FMTRC procedure  {  ScanVmaForSSNs          FMTRC procedure  {  UIWriteOutput           FMTRC procedure  {}  {   {             Algorithm/Pseudocode  {   {               {Process user inputs.}  {   { ReadRunstringParms and open error log   { Initialize binary and string representations of options   { If non-interactive command file used then   {    .ReadCommandFile   {    .ProcessCommandFileParms   
{    .CheckOptionsCommands 
 { Else  {    .QueryUser   { Endif    {                {Do preliminaries to filtering and formatting.}   {   { If no errors in user inputs   {    and user wants to continue   {    and breakflag is not set then  {   .OpenFiles -- VMA and text files   {   .InitVMA -- overlay with the chain of blocks data structure    	{   .ReadVmaHeader 	 
{   .SkanVmaForSSNs  
 
{   .InitFormatFile  
 {   {                {Start filtering}  {   {   .If user wants to continue  {      and breakflag is not set then  {      .FilterMessages  {    Else   {      .Issue a message that breakflag is acknowledged  {    Endif  {   {   .Close the formatted file.  {   { Else  {   .Issue a message that breakflag is acknowledged   { Endif   {}      %$INCLUDE 'src/FMTRC.PASI'$    { Include file has search list and globals } %     $SUBTITLE 'External Procedures', PAGE$  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   External Procedures                           }  " "{                                                                 }  " "{-----------------------------------------------------------------}  " 	$ HEAPPARMS OFF $  	     '{ Converts a binary number to its ascii representation as a decimal integer }  ' PROCEDURE CNumD      (   num : Int16;     { Binary Number }   
    VAR chars : SixChar);  
    EXTERNAL;      &{ Converts a binary number to its ascii representation as an octal integer } & PROCEDURE CNumO      (   num : Int16;     { Binary Number }   
    VAR chars : SixChar);  
    EXTERNAL;      	FUNCTION FmpClose  	    (VAR dcb : DcbType;          error : Int16)     : Int16;      EXTERNAL;          FUNCTION FmpInteractive      (VAR dcb : DcbType)     : Int16;      EXTERNAL;          
$ FIXED_STRING ON $  
     FUNCTION FmpOpen     (VAR dcb : DcbType;      VAR error : Int16;          filedesc : String64;  
        options : Optype;  
         bufs : Int16)      : Int16;      EXTERNAL;      FUNCTION FmpSize     (    filedesc : String64;  
    VAR filesize : Int32)  
    : Int16;      EXTERNAL;      
$ FIXED_STRING OFF $ 
         	FUNCTION FmpWrite  	    (VAR dcb : DcbType;          error : Int16;          fmp_buffer : FmpBufferType;   
        maxlength : Int16) 
    : Int16;      EXTERNAL;          PROCEDURE FTime      (VAR time_array : FtimeType);     EXTERNAL;          $ HEAPPARMS ON $      PROCEDURE GetHeapStackInfo    $ ALIAS 'Pas.GetMemInfo2' $      (VAR heap_Info : Info_Rec);     EXTERNAL;      	$ HEAPPARMS OFF $  	         FUNCTION IAnd   	    (num1 : Int16; 	 	     num2 : Int16) 	    : Int16;      EXTERNAL;          FUNCTION IfBrk     : Int16;      EXTERNAL;          FUNCTION IfTTY     (lu : Int16)      : Int16;      EXTERNAL;          FUNCTION PasSParms       $ ALIAS 'Pas.SParameters' $     (    pos : Int16;    { Parameter number }      VAR parm : String)  !   : Int16;             { Length of the parameter in characters }  !    EXTERNAL;          
$ FIXED_STRING ON $  
     	PROCEDURE VmaOpen  	    (VAR error : Int16;          name : String64;          optn : optype);      EXTERNAL;      
$ FIXED_STRING OFF $ 
     PROCEDURE VmaSt      (VAR version : Int16;  
    VAR my_size : Int16);  
    EXTERNAL;      $SUBTITLE 'FMTRC Routines', PAGE$   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{              FMTRC Routines                                     }  " "{                                                                 }  " "{-----------------------------------------------------------------}  " %$ HEAPPARMS ON $      { Heapparms option should be left on for the rest }  %     PROCEDURE AddErrorCode     (VAR msg_text   : String72;          error_code : Int16);        FORWARD;      
PROCEDURE AddMsgText 
    (VAR msg_text   : String72;      VAR add_text   : String72;          exception  : BOOLEAN);        FORWARD;      PROCEDURE AddMsgHeader     (    msg_number : Int16;       VAR msg_buf    : String72;          exception  : BOOLEAN);        FORWARD;      PROCEDURE CheckFmpError   
   (error : Int16);  
       FORWARD;      PROCEDURE CheckFmpWriteError  
   (error : Int16);  
       FORWARD;      PROCEDURE CheckOptionsCommands     ( VAR command_value : TempEntryType;        VAR options : OptionsType);        EXTERNAL;       
FUNCTION ConvertTime 
    (integer_time : Int32) : CharTimeType;         EXTERNAL;       PROCEDURE CNumA      (    num : Int16;     { Binary Number }  
    VAR chars : SixChar);  
       EXTERNAL;       
FUNCTION DefaultFormatFile 
    (VAR raw_file_name : String64) : String64;         FORWARD;      PROCEDURE DumpMessage      (VAR format_info : FormatInfoType;   
    VAR msg : MsgBuffer);  
       EXTERNAL;       FUNCTION FileInteractive     (VAR filedesc : String64)     : BOOLEAN;         FORWARD;      PROCEDURE FilterMessages     (VAR options : OptionsType;      VAR VMA_info : VmaInfoType;       VAR SSNs : SSNsPtr);        EXTERNAL;       
PROCEDURE GetSocket  
    (sequence_no : Int16;      VAR SSNs : SSNsPtr;       VAR the_socket : Int16);        EXTERNAL;       PROCEDURE InitFormatFile  
   (VAR parms: ParmsType;  
     VAR options: OptionsType;       VAR VMA_info : VmaInfoType;       VAR command_value: TempEntryType);        EXTERNAL;       	PROCEDURE InitVMA  	    (VAR VMA_info : VmaInfoType;       VAR parms : ParmsType);         EXTERNAL;       
PROCEDURE OpenFiles  
    (VAR parms : ParmsType);         EXTERNAL;       PROCEDURE ProcessCommandFileParms      ( VAR command_value : TempEntryType;        VAR parms : ParmsType);        EXTERNAL;       PROCEDURE ProcessGateway     (VAR options : OptionsType;      VAR msgline : MsgBuffer;      VAR SSNs : SSNsPtr);        EXTERNAL;       PROCEDURE ProcessLAN802      (VAR options : OptionsType;      VAR msgline : MsgBuffer;      VAR SSNs : SSNsPtr);        EXTERNAL;       
PROCEDURE ProcessNLM 
    (VAR options : OptionsType;      VAR msgline : MsgBuffer;      VAR format_info : FormatInfoType;       VAR SSNs : SSNsPtr);        EXTERNAL;       PROCEDURE ProcessOptionInput     ( VAR input_string : String72);        EXTERNAL;       
PROCEDURE ProcessSLM 
    (VAR options : OptionsType;      VAR msgline : MsgBuffer;      VAR format_info : FormatInfoType);        EXTERNAL;       PROCEDURE ProcessRouter      (VAR options : OptionsType;      VAR msgline : MsgBuffer;      VAR format_info : FormatInfoType);        EXTERNAL;       
PROCEDURE QueryUser  
 
   (VAR parms : ParmsType; 
     VAR options : OptionsType;      VAR user_abort : BOOLEAN);        EXTERNAL;       
PROCEDURE ReadCommandFile  
    ( VAR command_file : String64;        VAR command_value : TempEntryType);        EXTERNAL;       PROCEDURE ReadRunstringParms     ( VAR parms : ParmsType);        EXTERNAL;       PROCEDURE ReadVmaHeader      ( VAR VMA_info : VmaInfoType);         EXTERNAL;       PROCEDURE ScanVmaForSSNs     ( VAR options : OptionsType;        VAR VMA_info : VmaInfoType;  
     VAR SSNs : SSNsPtr);  
       EXTERNAL;       FUNCTION TestNodesPair     (VAR source_dest_string: String;       VAR nodes_setting: NodesPairType) :  Int16;         EXTERNAL;       FUNCTION TestProtocol      (VAR protocol_string: String;      VAR protocol_setting: ProtocolBitType) :  Int16;        EXTERNAL;       FUNCTION TestServMonId     (VAR servmon_string: String;       VAR servmon_setting: ServMonType) :  Int16;         EXTERNAL;       
FUNCTION TestSocket  
    (VAR socket_string: String;      VAR socket_setting: SocketType) :  Int16;         EXTERNAL;       	FUNCTION TestTime  	    (VAR time_string: String;      VAR time_setting: Int32) :  Int16;        EXTERNAL;       FUNCTION TestTraceLevel      (VAR trace_level_string: String;       VAR trace_level_setting: LevelBitsType) :  Int16;         EXTERNAL;       FUNCTION UIEndOfInput      : BOOLEAN;         FORWARD;      
PROCEDURE UIGetInput 
    (VAR prompt_string : STRING;       VAR input_string : STRING);         FORWARD;      PROCEDURE UIInit_Names;         FORWARD;      FUNCTION UIOpenExcept      (VAR name: STRING;       VAR result: Int16) : Int16;         FORWARD;      
FUNCTION UIOpenInput 
    (VAR name: STRING;       VAR result: Int16) : Int16;         FORWARD;      FUNCTION UIOpenOutput      (VAR name: STRING;       VAR result: Int16) : Int16;         FORWARD;      PROCEDURE UIWriteExcept      (VAR except_string : STRING);        FORWARD;      PROCEDURE UIWriteOutput      (VAR output_string : STRING);        FORWARD;      	PROCEDURE Upshift  	    (VAR char_string: String);         FORWARD;          $SUBTITLE 'AddErrorCode', PAGE$   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   AddErrorCode                                  }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE AddErrorCode     (VAR msg_text   : String72;          error_code : Int16);  {}  { Discussion:   "{  Call CNumD to obtain the ascii characters representing the error  " !{  code.  Insert three characters where the 'xxx' holds a place in ! !{  the msg_text.  It is assumed that the error code is one, two or !  {  three digits and that 'xxx' can be found in the msg_text as a   {  place-holder.  {}  { Parameters  %{  error_code INPUT        Error number returned in an FMP or VMA routine  % {                            call.  "{  msg_text INPUT/OUTPUT   Text of the message into which the ascii  " ${                            characters for the error code are inserted. $ {}  { Called by   {  AddMsgHeader   {  CheckFMPError  {  CheckFMPWriteError   {  OpenFiles  {  ProcessRouter  {  ProcessSLM   {}  { Calls   {  CNumD            RTE library   {}  {   {             Algorithm/Pseudocode  {   { Call CNumD to obtain the ascii for error code.  ${ Insert the two least significant characters where 'xx' holds a place.  $ {}      VAR      i : Int16;       
BEGIN {AddErrorCode} 
        i := 0;     REPEAT   	      i := i + 1;  	    UNTIL (i = MSGLEN) OR           ((msg_text [i] = 'x') AND           (msg_text [i + 1] = 'x') AND            (msg_text [i + 2] = 'x'));          IF i < MSGLEN THEN         BEGIN   "      IF error_code < 0 THEN       { Get absolute value for CNUMD }  "          error_code := -error_code;         CNumD (error_code, six_str);        msg_text [i] := six_str [4];        msg_text [i + 1] := six_str [5];        msg_text [i + 2] := six_str [6];        END;      
END;  {AddErrorCode} 
     $SUBTITLE 'AddMsgText', PAGE$   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   AddMsgText                                    }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
PROCEDURE AddMsgText 
    (VAR msg_text   : String72;      VAR add_text   : String72;          exception  : BOOLEAN);  {}  { Discussion:   #{  Check the total length of the two strings.  If the add_text can be  #  {  appended to the msg_text, then place the results in msg_text.   #{  Otherwise, output the msg_text to the output file or the exception  # {  file; assign the add_text value to msg_text and return.  ${  The caller will write the resulting msg_text to the appropriate file  $ 	{  in either case. 	 {}  { Parameters  %{  add_text   INPUT        Text to be appended to msg_text or assigned to  % {                            msg_text.  #{  exception  INPUT        Flag to indicate the destination for output # "{  msg_text INPUT/OUTPUT   Text of the message into which the ascii  " ${                            characters for the error code are inserted. $ {}  { Called by   {  CheckOptionsCommands   {  InitVMA  {  OpenFiles  {  QueryUser  {}  { Calls   {  StrLen           Pascal String Function  {  StrAppend        Pascal String Procedure   
{  UIWriteExcept    Fileio 
 
{  UIWriteOutput    Fileio 
 {}  {   {             Algorithm/Pseudocode  {   { Call StrLen on both input strings and add the results.  ${ If the total length is too great to write both pieces into one buffer  $  {   .If this is a log message (output the first part by itself)    {      .Write the msg_text to the except_file   {   .Else write the msg_text to LU1   {   .Overwrite msg_text with add_text   { Else StrAppend the add_text to the msg_text   {}      	BEGIN {AddMsgText} 	        IF ( StrLen(msg_text) + StrLen(add_text) > MSGLEN ) THEN         BEGIN       &      IF exception THEN             { Entire message won't fit, so write   } & &         UIWriteExcept (msg_text)   {  the main message here               } &       ELSE UIWriteOutput (msg_text);      &      msg_text := add_text;  {  Return added text for the caller to write }  &           END           ELSE BEGIN      { Return entire message for caller to write }             StrAppend (msg_text, add_text);       
      END;   { if strlen } 
     	END;  {AddMsgText} 	         $SUBTITLE 'AddMsgHeader', PAGE$   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   AddMsgHeader                                  }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE AddMsgHeader     (    msg_number : Int16;       VAR msg_buf    : String72;          exception  : BOOLEAN);  {}  { Discussion:   "{  Get the standard message header, insert the message number.  Then " {  get the message text in a second buffer.   #{  Check the total length of the two strings.  If the msg text can be  # {  appended to the header, then place the results in msg_buf.   "{  Otherwise, output the msg_buf to the output file or the exception " {  file; assign the msg_buf2 value to msg_buf and return.   ${  The caller will write the resulting msg_buf to the appropriate file.  $ {}  { Parameters  ${  msg_number INPUT        Error message constant used to index message  $ {                            in the array of message strings.   #{  exception  INPUT        Flag to indicate the destination for output # ${  msg_buf    OUTPUT       Text of the message obtained from the message $ "{                            constant array, with the message header " ${                            prepended and the message number inserted.  $ {}  { Called by   {  CheckFMPError  {  CheckFMPWriteError   {  CheckOptionsCommands   {  InitVMA  {  OpenFiles  {  ProcessRouter  {  ProcessSLM   {  QueryUser  {}  { Calls   {  AddErrorCode     FMTRC routine   
{  UIWriteExcept    Fileio 
 
{  UIWriteOutput    Fileio 
 {  StrLen           Pascal String Function  {  StrAppend        Pascal String Procedure   {}  {   {             Algorithm/Pseudocode  {   { Get the message label '(FMTRCERRxxx)'   ${ Call AddErrorCode to insert the msg_number where the 'xxx' hold places $ { Get the message text in a second buffer   { Call StrLen on both input strings and add the results.  ${ If the total length is too great to write both pieces into one buffer  $  {   .If this is a log message (output the first part by itself)    {      .Write the msg_buf to the except_file  {   .Else write the msg_buf to LU1  {   .Overwrite msg_buf with msg_buf2  { Else StrAppend the msg_buf2 to the msg_buf  {}      
BEGIN {AddMsgHeader} 
        msg_buf := FMTRC_MSG_LABEL;     AddErrorCode (msg_buf, msg_number);     msg_buf2 := MSGS [msg_number];          IF ( StrLen(msg_buf) + StrLen(msg_buf2) > MSGLEN ) THEN        BEGIN       &      IF exception THEN             { Entire message won't fit, so write   } & &         UIWriteExcept (msg_buf)    {  the message header here             } &       ELSE UIWriteOutput (msg_buf);       $      msg_buf := msg_buf2;  {  Return msg text for the caller to write } $           END           ELSE BEGIN      { Return entire message for caller to write }             StrAppend (msg_buf, msg_buf2);      
      END;   { if strlen } 
     
END;  {AddMsgHeader} 
         $SUBTITLE 'CheckFmpError', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   CheckFmpError                                 }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE CheckFmpError   
   (error : Int16);  
 {}  { Discussion  #{  Make certain the the error return for FMP writes is zero.  If not,  # {  write a message to the user in the error log and continue.   {}  { Parameters  "{   error   INPUT     Error returned in the FmpOpen or FmpClose call " {}  { Called by   {  Fmtrc -- main  {  OpenFiles  {}  { Calls   {  AddMsgHeader    FMTRC Procedure  {  AddErrorCode    FMTRC Procedure  
{  UIWriteExcept   Fileio  
 {}  {   {               Algorithm/Pseudocode  {   { Test error for non-zero value   	{ If non-zero then 	 {   .Make a call to add the FMP error code to the message   {   .Write out the message to the exception file  {}  $PAGE$      BEGIN  { CheckFmpError }      	IF error <> 0 THEN 	    BEGIN         AddMsgHeader (FMP_WRITE_ERROR, msg_buf, TRUE);   #   AddErrorCode (msg_buf, error);     { Insert the FMP error return }  #    UIWriteExcept (msg_buf);          END;       END;  { CheckFmpError }       $SUBTITLE 'CheckFmpWriteError', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " ${                   CheckFmpWriteError                                 } $ "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE CheckFmpWriteError  
   (error : Int16);  
 {}  { Discussion  #{  Make certain the the error return for FMP writes is zero.  If not,  # {  write a message to the user in the error log and abort.  {}  { Parameters  {   error   INPUT     Error returned in the FmpWrite call   {}  { Called by   	{  InitFormatFile  	 {  DumpMessage  {}  { Calls   {  AddMsgHeader    FMTRC Procedure  {  AddErrorCode    FMTRC Procedure  
{  UIWriteExcept   Fileio  
 {}  {   {               Algorithm/Pseudocode  {   { Test error for non-zero value   	{ If non-zero then 	 {   .Make a call to add the FMP error code to the message   {   .Write out the message to the exception file  
{   .end the program 
 {}  $PAGE$      BEGIN  { CheckFmpWriteError }       	IF error <> 0 THEN 	    BEGIN         AddMsgHeader (FMP_WRITE_ERROR, msg_buf, TRUE);   #   AddErrorCode (msg_buf, error);     { Insert the FMP error return }  #    UIWriteExcept (msg_buf);      HALT (error);         END;       END;  { CheckFmpWriteError }      $SUBTITLE 'DefaultFormatFile', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   DefaultFormatFile                             }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
FUNCTION DefaultFormatFile 
    (VAR raw_file_name : String64) : String64;   {}  { Discussion  #{  The format file name is created from the raw file name if the user  # {  has chosen to default Parm Three.  The 'TRC' extension is  #{  recognised if it exists in the raw file name and is replaced by the # "{  'FMT' extension.  Otherwise the raw file name is simply appended  " !{  with the 'FMT' extension.  A call to the file system will check ! #{  the viability of the file name thus created.  Function returns the  # 
{  format file name. 
 {}  { Parameters  "{   raw_file_name    INPUT     User specified or defaulted filename  " !{                               for the VMA file created by NETRC  ! #{   format_file_name OUTPUT    Null string that will receive the name  # "{                               created by this procedure based upon " {                               the raw file name   {}  
{ Functional return  
 {   The format file name is returned.   {}  { Called by   {  QueryUser  {  OpenFiles  {}  { Calls   {  Strpos         Pascal Standard String Function   {  Strlen         Pascal Standard String Function   {  Strappend      Pascal Standard String Procedure  {  Strdelete      Pascal Standard String Procedure  {  Strinsert      Pascal Standard String Procedure  {}  {   {               Algorithm/Pseudocode  {   { Find a dot ('.') in the raw file name   
{ If it exists then  
 {   .Set the format file name to the raw file name   {   .Replace the first 3 characters of the extension with 'FMT'    { Else  {   .Find the first occurence of ':' signalling a CRN   {   .If none was found then   {      .Find the end of the raw file name in its string + 1   {    Endif  {   .Insert the 'FMT' extension at this position  { Endif   { Set function to the created format file name  {}  $PAGE$      VAR   	   ext : String3;  	    dot_ext : String4;      len : Int16;      pos : Int16;      format_file_name : String64;       BEGIN  { DefaultFormatFile }      pos := Strpos(raw_file_name, '.');      IF pos > 0 THEN      BEGIN  {substitute 'FMT extension}      ext := 'FMT';     format_file_name := raw_file_name;      len := StrLen (format_file_name);     StrDelete (format_file_name, pos+1, len - pos);     StrAppend (format_file_name, ext);      END    {substitute 'FMT' extension}      ELSE BEGIN  {there is no extension}          format_file_name := raw_file_name;      dot_ext := '.FMT';      pos := Strpos (format_file_name,':');      	   IF pos = 0 THEN 	       BEGIN  {there is no CRN}        StrAppend (format_file_name, dot_ext);        END      ELSE BEGIN          StrInsert (dot_ext, format_file_name, pos);        END;         END;     {there is no extension}       DefaultFormatFile := format_file_name;      
END;  {DefaultFormatFile}  
         $SUBTITLE 'ErrorProc', PAGE$  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   ErrorProc                                     }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
PROCEDURE ErrorProc  
    (VAR msg_text : STRING);   {}  { Discussion  #{  Call the procedure that builds messages by referencing the message  # #{  array using the msg_code index.  Write the string to the log_file.  # {}  { Parameters  "{  msg_code   INPUT        Indexes the error messages by codes that  " #{                            are declared as constants to the program. # %{  error_code INPUT        Error number returned in an FMP or VMA routine  % #{                            call.  Include this number in the output  # #{                            message.  The error code replaces 'xx' in # {                            the message constant.  "{  msg_text INPUT/OUTPUT   Text (e.g. a filename) to be added to the " &{                            message constant.  This text is to be appended  & ${                            by BuildMessage and the complete message is $ "{                            returned here to be output to the user. " {}  { Called by   {  Main of FMTRC  {}  { Calls   
{  UIWriteExcept    Fileio 
 {}  {   {             Algorithm/Pseudocode  {   !{ Call BuildMessage to return a message string adding any text and ! {   error code that the caller passes in  { Call WriteExcept to send the message to the user  {}      	BEGIN {ErrorProc}  	        UIWriteExcept (msg_text);      	END;  {ErrorProc}  	     $SUBTITLE 'FileInteractive', PAGE$  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   FileInteractive                               }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     FUNCTION FileInteractive     (VAR filedesc : String64)     : BOOLEAN;   {}  { Discussion  {  Determine whether an LU is an interactive device.  {}  { Parameters  {  filedesc   INPUT   A string that holds a file descriptor.  {}  
{ Functional return  
 "{  The boolean returned is true if the file named is an interactive  " {    device.  {}  { Called by   {  OpenFiles  {}  { Calls   {  FMPInteractive   RTE file system function  {  IfTTY            RTE standard function   {}  {   {             Algorithm/Pseudocode  {   "{ Test the filename for numbers, indicating that it represents an LU " { If so, call IfTTY to find out if the LU is interactive  { Set the function value to a Boolean to indicate the answer  {}  $ PAGE $      CONST      LU_INTERACTIVE = -1;       VAR   
   next_pos : Int16; 
    lu : Int16;  	   return : Int16; 	     BEGIN {FileInteractive}       
FileInteractive := FALSE;  
     
IF NumChk (filedesc) THEN  
    BEGIN     Strread (filedesc,1,next_pos,lu);     return := IfTTY (lu);         IF return = LU_INTERACTIVE THEN        BEGIN         FileInteractive := TRUE;        END;         END; { if numchk }   END;  {FileInteractive}       $SUBTITLE 'UIEndOfInput', PAGE $  {--------------------------------------------------}  {              UIEndOfInput   {--------------------------------------------------}      FUNCTION UIEndOfInput : BOOLEAN;  BEGIN      UIEndOfInput := eof (input_file);  END;          $SUBTITLE 'UIGetInput',PAGE$  {------------------------------------------------------------}  {                    UIGetInput                              }  {------------------------------------------------------------}      
PROCEDURE UIGetInput 
    (VAR prompt_string : STRING;       VAR input_string : STRING);          BEGIN { UIGetInput }      IF fileinfo.input_interactive THEN         BEGIN         prompt (prompt_file, prompt_string);        END;         { Protect against null string input }     IF eoln (input_file) THEN        BEGIN         readln (input_file); { flush eoln char from buffer }  
      input_string := '';  
       END      ELSE         BEGIN   
      input_string := ' '; 
       Readln (input_file, input_string);        END;         END;  { UIGetInput }       $SUBTITLE 'UIInit_Names',PAGE$  {------------------------------------------------------------}  {                   UIInit_Names                             }  {------------------------------------------------------------}      PROCEDURE UIInit_Names;   
   BEGIN { UIInit_names }  
     
   input_file_name := '';  
 
   output_file_name := ''; 
 
   except_file_name := ''; 
        initnames := TRUE;       
   END;  { UIInit_names }  
         $SUBTITLE 'UIOpenExcept',PAGE$  {------------------------------------------------------------}   {                     UIOpenExcept                             }   {------------------------------------------------------------}      FUNCTION UIOpenExcept      (VAR name: STRING;       VAR result: Int16) : Int16;       
   BEGIN { UIOpenExcept }  
        IF NOT initnames THEN UIInit_Names;     IF strlen (name) <> 0 THEN         BEGIN  { if there is a name }          except_file_name := name;  { Initialize the global value }         rewrite (except_file, except_file_name); {??fmpopen??}        END    { if there is a name }      ELSE         BEGIN  { use the default }        rewrite (except_file, '1');         except_file_name := '1';        END;   { use the default }         { determine the value of except_writable }      IF (except_file_name = output_file_name)         OR (except_file_name = input_file_name) THEN        BEGIN         fileinfo.except_writable := FALSE         END      ELSE         BEGIN         fileinfo.except_writable := TRUE;         END;         result := 0;   
   UIOpenExcept := result; 
     
   END;  { UIOpenExcept }  
 $SUBTITLE 'UIOpenInput',PAGE$   {------------------------------------------------------------}  {                     UIOpenInput                            }  {------------------------------------------------------------}      
FUNCTION UIOpenInput 
    (VAR name: STRING;       VAR result: Int16) : Int16;         BEGIN { UIOpenInput }     IF NOT initnames THEN        BEGIN  	     UIInit_Names; 	      END;     Reset (input_file, name);     { read only }   
  input_file_name := name; 
     
{ Set values of fileinfo } 
 
   WITH fileinfo DO  
 
      BEGIN { with } 
       IF output_file_name = input_file_name THEN           BEGIN  
         innotout := FALSE 
          END        ELSE BEGIN  
         innotout := TRUE; 
          END;             IF strlen (except_file_name) <> 0 THEN           IF (except_file_name = input_file_name) THEN               BEGIN { name exists and is not unique }               except_writable := FALSE              END   { name exists and is not unique }               ELSE BEGIN { name exists and is unique }              except_writable := TRUE               END   { name exists and is unique }         ELSE BEGIN    { file not open yet }            except_writable := FALSE;           END;     { file not open yet }             IF input_file_name = '1' THEN            BEGIN           input_interactive := TRUE;            rewrite (prompt_file, '1');           END        ELSE BEGIN           input_interactive := FALSE            END;   
      END; { with }  
        result := 0;   
   UIOpenInput := result;  
        END;  { UIOpenInput }      $SUBTITLE 'UIOpenOutput',PAGE$  {------------------------------------------------------------}  {                     UIOpenOutput                           }  {------------------------------------------------------------}      FUNCTION UIOpenOutput      (VAR name: STRING;       VAR result: Int16) : Int16;       
   BEGIN { UIOpenOutput }  
    IF NOT initnames THEN UIInit_Names;     IF strlen(name) <> 0 THEN        BEGIN { user gave a file name }         rewrite (output_file, name);        output_file_name := name;         END   { user gave a file name }      ELSE         BEGIN { use default }         rewrite (output_file, '1');         output_file_name := '1';        END;  { use default }       
   WITH fileinfo DO  
 
      BEGIN { with } 
       IF output_file_name = input_file_name THEN           BEGIN  
         innotout := FALSE 
          END        ELSE BEGIN  
         innotout := TRUE  
          END;             IF strlen (except_file_name) <> 0 THEN           IF (except_file_name = output_file_name) THEN              BEGIN { name exists and is not unique }               except_writable := FALSE              END   { name exists and is not unique }            ELSE BEGIN { name exists and is unique }               except_writable := TRUE               END   { name exists and is unique }         ELSE BEGIN    { file not open yet }            except_writable := FALSE;           END;     { file not open yet }   
      END;  { with } 
        result := 0;   
   UIOpenOutput := result; 
     
   END;  { UIOpenOutput }  
             $SUBTITLE 'UIWriteExcept',PAGE$   {------------------------------------------------------------}  {                  UIWriteExcept                             }  {------------------------------------------------------------}      PROCEDURE UIWriteExcept      (VAR except_string : STRING);      
   BEGIN { UIWriteExcept } 
 
   WITH fileinfo DO  
       BEGIN         IF except_writable THEN            BEGIN           writeln (except_file, except_string);           END;             IF input_interactive THEN            BEGIN           writeln (prompt_file, except_string);           END;   
      END;  { with } 
     
   END;  { UIWriteExcept } 
     $SUBTITLE 'UIWriteOutput',PAGE$   {------------------------------------------------------------}  {                   UIWriteOutput                            }  {------------------------------------------------------------}      PROCEDURE UIWriteOutput      (VAR output_string : STRING);      
   BEGIN { UIWriteOutput } 
    IF fileinfo.innotout THEN        BEGIN         writeln (output_file, output_string);         END;         IF fileinfo.input_interactive THEN         BEGIN         writeln (prompt_file, output_string);         END;      
   END;  { UIWriteOutput } 
     $SUBTITLE 'Upshift', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   Upshift                                       }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     	PROCEDURE Upshift  	    (VAR char_string : String);  {}  { Discussion  "{  With each character in the user supplied string, if the character " {  is lower case, upshift the character.  {}  { Parameters  "{   char_string    INPUT/OUTPUT    A string of any length containing " {                                    any characters.  {}  { Called by   	{  ReadCommandFile 	 {  TestProtocol   {  TestServMonId  	{  TestTraceLevel  	 {  QueryUser  {}  { Calls   {  none   {}  {   {             Algorithm/Pseudocode  {   { For each character in the string  
{   .Case on the character 
 {      .'a'..'z' add decimal 32 to the ascii character code   {         and make that the functional return   {      .Otherwise do nothing  {    End case   { End loop  {}  $PAGE$      CONST   
   SHIFTVALUE = 32;  
     VAR   	   index : Int16;  	    len : Int16;       BEGIN  {Upshift}      len := Strlen (char_string);      FOR index := 1 TO len DO     BEGIN         CASE char_string[index] OF         'a'..'z' : BEGIN                   char_string[index] :=  "                        CHR (ORD (char_string[index]) - SHIFTVALUE); "                  END;         Otherwise  BEGIN                   END;   	      END;  {case} 	        END;  {for}      END;   {Upshift}          $SUBTITLE 'MAIN', PAGE$   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   Main -- FMTRC                                 }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     BEGIN  { FMTRC }      WITH parms DO      BEGIN         ReadRunstringParms(parms);                                       { Some initilization }     options := OPTIONS_INIT;      command_value [START_TIME_ENTRY] := D_START_TIME_STR;     command_value [STOP_TIME_ENTRY] := D_STOP_TIME_STR;     command_value [PROTOCOL_ENTRY] := D_PROTOCOL_STR;     command_value [NODES_PAIR_ENTRY] := D_NODES_PAIR_STR;     command_value [SERVMON_ENTRY] := D_SERVMON_STR;     command_value [SOCKET_ENTRY] := D_SOCKET_STR;         IF (command_input_name <> '') AND        (NOT FileInteractive (command_input_name)) THEN         BEGIN  {command input file was specified}                ReadCommandFile(command_input_name, command_value);           ProcessCommandFileParms(command_value, parms);                CheckOptionsCommands(command_value, options);        END   {command input file was specified}         ELSE BEGIN  {if no command input file was specified}             QueryUser (parms, options, user_abort);             END;     END;  {with parms}       IF (NOT (IfBrk = -1) AND NOT user_abort) THEN   %   BEGIN                           {preliminaries to filtering/formatting} %        OpenFiles (parms);      InitVMA (VMA_info, parms);      ReadVmaHeader (VMA_info);     ScanVmaForSSNs (options, VMA_info, SSNs);     InitFormatFile (parms, options, VMA_info, command_value);         IF NOT (IfBrk = -1) THEN         BEGIN                           { start filtering }         FilterMessages (options, VMA_info, SSNs);             END   { if not break }     ELSE BEGIN         msg_buf := MSGS[USER_BREAK];        UIWriteOutput (msg_buf);        END;         file_error := FmpClose (dcb, file_error);     CheckFmpError (file_error);      
   END   { if not break }  
    ELSE BEGIN         msg_buf := MSGS[USER_BREAK];        UIWriteOutput (msg_buf);        END;      END    { FMTRC }  .  