     $PASCAL '   91790-16061 REV.4010 <860409.1556>'   $TITLE 'FMTUI Trace Formatter User Interface'$  
$STANDARD_LEVEL 'HP1000' $ 
 $DEBUG $  $RECURSIVE OFF$   $HEAP 2 $   
$HEAP_DISPOSE OFF $  
 $CDS ON  $  $RANGE OFF $          $SUBPROGRAM   $           PROGRAM FMTUI;      %{------------------------------------------------------------------------  %     "   (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986.  ALL RIGHTS RESERVED. "    NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED, REPRODUCED, OR   "   TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR WRITTEN  "    CONSENT OF THE HEWLETT-PACKARD COMPANY.      % ------------------------------------------------------------------------} %     {}  {        NAME : FMTRC   {      SOURCE : 91790-18061   {       RELOC : 91790-16061   
{        PGMR : JXL  
 {}  {  FMTUI is a segment of the trace formatter program FMTRC.   {}  "{  FMTRC reads unformatted messages out of a VMA file that has been  " !{  created by the AdvanceDS program NETRC.  FMTRC formats the raw  ! "{  trace messages  and analyzes the messages somewhat.  The user can " !{  specify options that limit the formatted output to a subset of  ! {  the messages contained in the raw trace file.  {   {}  !$INCLUDE 'src/FMTRC.PASI', SUBTITLE 'Imports and Globals'; PAGE $  !     $SUBTITLE 'External Procedures'; PAGE$  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   External Procedures                           }  " "{                                                                 }  " "{-----------------------------------------------------------------}  " 	$ HEAPPARMS OFF $  	     '{ Converts a binary number to its ascii representation as a decimal integer }  ' PROCEDURE CNumD      (   num : Int16;     { Binary Number }   
    VAR chars : SixChar);  
    EXTERNAL;      &{ Converts a binary number to its ascii representation as an octal integer } & PROCEDURE CNumO      (   num : Int16;     { Binary Number }   
    VAR chars : SixChar);  
    EXTERNAL;      	FUNCTION FmpClose  	    (VAR dcb : DcbType;          error : Int16)     : Int16;      EXTERNAL;          FUNCTION FmpInteractive      (VAR dcb : DcbType)     : Int16;      EXTERNAL;          
$ FIXED_STRING ON $  
     FUNCTION FmpOpen     (VAR dcb : DcbType;      VAR error : Int16;          filedesc : String64;          options : OptionType;           bufs : Int16)      : Int16;      EXTERNAL;      
$ FIXED_STRING OFF $ 
         	FUNCTION FmpWrite  	    (VAR dcb : DcbType;          error : Int16;          fmp_buffer : FmpBufferType;   
        maxlength : Int16) 
    : Int16;      EXTERNAL;          PROCEDURE FTime      (VAR time_array : FtimeType);     EXTERNAL;          $ HEAPPARMS ON $      PROCEDURE GetHeapStackInfo    $ ALIAS 'Pas.GetMemInfo2' $      (VAR heap_Info : Info_Rec);     EXTERNAL;      	$ HEAPPARMS OFF $  	         FUNCTION IAnd   	    (num1 : Int16; 	 	     num2 : Int16) 	    : Int16;      EXTERNAL;          FUNCTION IfBrk     : Int16;      EXTERNAL;          FUNCTION IfTTY     (lu : Int16)      : Int16;      EXTERNAL;          FUNCTION PasSParms    $ ALIAS 'Pas.SParameters' $      (    pos : Int16;    { Parameter number }      VAR parm : String)  !   : Int16;             { Length of the parameter in characters }  !    EXTERNAL;          
$ FIXED_STRING ON $  
     	PROCEDURE VmaOpen  	    (VAR error : Int16;          name : String64;          optn : OptionType);      EXTERNAL;      
$ FIXED_STRING OFF $ 
 $SUBTITLE 'FMTRC Routines', PAGE$   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{              FMTRC Routines                                     }  " "{                                                                 }  " "{-----------------------------------------------------------------}  " %$ HEAPPARMS ON $      { Heapparms option should be left on for the rest }  %     PROCEDURE AddMsgHeader    (    msg_number  : Int16;      VAR msg_buf     : String72;         exception   : BOOLEAN);        EXTERNAL;       
PROCEDURE AddMsgText 
    (VAR msg_text   : String72;      VAR add_text   : String72;          exception  : BOOLEAN);        EXTERNAL;       PROCEDURE CheckOptionsCommands     ( VAR command_value : TempEntryType;        VAR options : OptionsType);        FORWARD;      
FUNCTION DefaultFormatFile 
    (VAR raw_file_name : String64) : String64;         EXTERNAL;       PROCEDURE ProcessCommandFileParms      ( VAR command_value : TempEntryType;        VAR parms : ParmsType);        FORWARD;      PROCEDURE ProcessOptionInput     ( VAR input_string : String72);        FORWARD;      
PROCEDURE QueryUser  
 
   (VAR parms : ParmsType; 
     VAR options : OptionsType;      VAR user_abort : BOOLEAN);        FORWARD;      
PROCEDURE ReadCommandFile  
    ( VAR command_file : String64;        VAR command_value : TempEntryType);        FORWARD;      FUNCTION TestNodesPair     (VAR source_dest_string: String;       VAR nodes_setting: NodesPairType) :  Int16;         FORWARD;      FUNCTION TestProtocol      (VAR protocol_string: String;      VAR protocol_setting: ProtocolBitType) :  Int16;        FORWARD;      FUNCTION TestServMonId     (VAR servmon_string: String;       VAR servmon_setting: ServMonType) :  Int16;         FORWARD;      
FUNCTION TestSocket  
    (VAR socket_string: String;      VAR socket_setting: SocketType) :  Int16;         FORWARD;      	FUNCTION TestTime  	    (VAR time_string: String;      VAR time_setting: Int32) :  Int16;        FORWARD;      FUNCTION TestTraceLevel      (VAR trace_level_string: String;       VAR trace_level_setting: LevelBitsType) :  Int16;         FORWARD;      	PROCEDURE Upshift  	    (VAR char_string : String);        EXTERNAL;       FUNCTION UIEndOfInput      : BOOLEAN;         EXTERNAL;       
PROCEDURE UIGetInput 
    (VAR prompt_string : STRING;       VAR input_string : STRING);         EXTERNAL;       
FUNCTION UIOpenInput 
    (VAR name: STRING;       VAR result: Int16) : Int16;         EXTERNAL;       FUNCTION UIOpenOutput      (VAR name: STRING;       VAR result: Int16) : Int16;         EXTERNAL;       PROCEDURE UIWriteExcept      (VAR except_string : STRING);        EXTERNAL;       PROCEDURE UIWriteOutput      (VAR output_string : STRING);        EXTERNAL;           $SUBTITLE 'CheckOptionsCommands' , PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                    CheckOptionsCommands                         }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE CheckOptionsCommands     ( VAR command_value : TempEntryType;        VAR options : OptionsType);  {}  { Discussion  "{  Process the command file records that correspond to the Options.  "  {  Check each command record calling the appropriate function to   !{  parse and test the user input for validity.  The function will  ! #{  set the relevant Option data structure values with the file inputs  # "{  if they are valid.  Any invalid input will cause an error message "  {  to be logged.  If such an error occurs, then after all inputs   "{  have been processed, the formatter will quit to allow the user to " {  correct the command file.  {}  { Parameters  #{  command_value  INPUT        Values obtained from the command file.  # "{  options        OUTPUT       Options data structure for filtering. " {}  { Called by   {  Main of FMTRC  {}  { Calls   {  AddMsgHeader        FMTRC procedure  {  AddMsgText          FMTRC procedure  {  ProcessOptionInput  FMTRC procedure  {  ReturnParms         RTE routine  {  TestTraceLevel      FMTRC function   {  TestTime            FMTRC function   {  TestProtocol        FMTRC function   {  TestNodesPair       FMTRC function   {  TestServMonId       FMTRC function   {  TestSocket          FMTRC function   {  UIWriteExcept       FileIO   {}  {   {                Algorithm/Pseudocode   {   { Loop from Option Trace Level to Option Socket   {  .If temp element is not null then  {     .Case on the Option number  
{      .Trace Level: 
 {         .Call function TestTraceLevel   	{      .Start Time 	 {         .Call function TestTime   	{      .Stop Time  	 {         .Call function TestTime   {      .Protocol  {         .Call function TestProtocol   	{      .Nodes Pair 	 {         .Call function TestNodesPair  
{      .Service/Monitor Id 
 {         .Call function TestServMonId  {      .Socket  {         .Call function TestSocket   {    End case   {   {   .If the funtion returned an error then  {      .write error message   {      .Set the flag for invalid input  {   { End loop  {   { If the invalid input flag was set for any Option then   {  .Call ReturnParms and exit   {}  $PAGE$      VAR      entry : ParmOptionEntry;      pos : Int16;   	   result : Int16; 	    valid_file_input : BOOLEAN;  
   temp_string : String72; 
     BEGIN  {CheckOptionsCommands}       WITH options DO      BEGIN  {validate command file inputs and set Option values}         result := 0;   {initialize function return}  "   valid_file_input := TRUE;   {if FALSE, FMTRC will have to quit }  "        FOR entry := TRACE_LEVEL_ENTRY TO LAST_ENTRY DO        BEGIN             ProcessOptionInput (command_value [entry]);             IF command_value [entry] <> '' THEN            BEGIN           temp_string := command_value [entry];           CASE entry OF                  TRACE_LEVEL_ENTRY :   
               BEGIN 
 "               result := TestTraceLevel (temp_string, trace_level);  "                END; { case trace_level_entry }                  START_TIME_ENTRY :  
               BEGIN 
                result := TestTime (temp_string, start_time);                 END; { case start_time_entry }                   STOP_TIME_ENTRY :   
               BEGIN 
                result := TestTime (temp_string, stop_time);                  END; { case stop_time_entry }                  PROTOCOL_ENTRY :  
               BEGIN 
                result := TestProtocol (temp_string, protocol);                 END; { case protocol_entry }                   NODES_PAIR_ENTRY :  
               BEGIN 
                result := TestNodesPair (temp_string, nodes);                 END; { case nodes_pair_entry }                   SERVMON_ENTRY :   
               BEGIN 
                 result := TestServMonId (temp_string, serv_mon);                   END; { case servmon_entry }      
            SOCKET_ENTRY : 
 
               BEGIN 
                result := TestSocket (temp_string, socket);                 END; { case socket_entry }                   Otherwise BEGIN                  result := INTERNAL_ERR_LAST_ENTRY;   
               END;  
             END; {case}                END; { IF command_value <> '' }      
      IF result <> 0 THEN  
          BEGIN  $                                { Get the msg text and numbered header } $             AddMsgHeader (result, msg_buf, TRUE);               temp_string := command_value [entry];               AddMsgText (msg_buf, temp_string, TRUE);              UIWriteExcept (msg_buf);              valid_file_input := FALSE;              result := 0;           END;         END; {for}         END;  {with options}       IF NOT valid_file_input THEN     BEGIN     prams[1] := PRTN_BAD_COMM_FILE_INPUT;  "   HALT (prams[1]);         {   and exit immediately              }  "    END;       END;   {CheckOptionsCommands}           $SUBTITLE 'ProcessCommandFileParms' , PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                  ProcessCommandFileParms                        }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE ProcessCommandFileParms      ( VAR command_value : TempEntryType;        VAR parms : ParmsType);  {}  { Discussion   {  Runstring Parms 2 - 4 are: Parm2 -- Raw Trace File, Parm 3 --   {  Format Trace File, Parm 4 -- Label Field.  "{  If Parms 2-4 have not been set in the runstring, get the command  " {  file values, if any.   #{  Be sure the formatted filename is not identical to trace filename.  # {}  { Parameters  #{  command_value  INPUT        Values obtained from the command file.  # #{  parms      INPUT/OUTPUT     Runstring parms values; values not set  # #{                               from the runstring have been set from  # {                               the command file.   {}  { Called by   {  Main of FMTRC  {}  { Calls   {  None   {}  {   {                Algorithm/Pseudocode   {   {                   {Obtain Parms}  {   !{ For any Parm (Two through Four) not obtained from the runstring  ! "{   .set the Parm data structure element from the command file input " { Check that formatted filename does not equal trace filename.  {}  $PAGE$      BEGIN  {ProcessCommandFileParms}      WITH parms DO       BEGIN  {fill in any null Parms values from the command file}       IF raw_file_name = '' THEN         BEGIN            raw_file_name := command_value[RAW_FILE_ENTRY];        END;     IF format_file_name = '' THEN        BEGIN            format_file_name := command_value[FORMAT_FILE_ENTRY];        END;     IF label_field = '' THEN         BEGIN            label_field := command_value[LABEL_FIELD_ENTRY];         END;     END;  {with}       END;   {ProcessCommandFileParms}          $SUBTITLE 'ProcessOptionInput' , PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                     ProcessOptionInput                          }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE ProcessOptionInput     ( VAR input_string : String72);  {}  { Discussion  !{  From the command file, process each string to obtain the Option ! !{  values.  First, eliminate any user comments from the end of the ! !{  record, replace commas with blanks, and right trim each record. ! {}  { Parameters  #{  input_string  INPUT/OUTPUT  Values obtained from user input or the  # {                                command file.  {}  { Called by   {  Main of FMTRC  {}  { Calls   {  Strpos           Pascal Standard string function   {  Str              Pascal Standard string function   {  Strrtrim         Pascal Standard string function   {}  {   {                Algorithm/Pseudocode   {   !{ Process a string from the command file or of interactive input:  ! {   .Strip the in-line comments from the command file entries   {   .Turn commas into blanks  {   .Right trim the command file entry strings  {}  $PAGE$      VAR      pos : Int16;       BEGIN  {ProcessOptionInput}            { eliminate in-line comments }   pos := Strpos (input_string, '*');      IF pos > 1 THEN      BEGIN     input_string := Str (input_string, 1, pos - 1);     END;  {if}            {exchange blanks for commas}   pos := Strpos (input_string, ',');  	WHILE pos <> 0 DO  	    BEGIN     input_string[pos] := ' ';     pos := Strpos (input_string, ',');      END;  {while}      input_string := Strrtrim (input_string);      END;   {ProcessOptionsInput}          $SUBTITLE 'QueryUser', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                       QueryUser                                 }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
PROCEDURE QueryUser  
 
   (VAR parms : ParmsType; 
     VAR options : OptionsType;      VAR user_abort : BOOLEAN);  {}  { Discussion  {}  { Parameters  #{  parms     INPUT/OUTPUT  Runstring parms values; values not set from # %{                            the runstring, may be set here interactively. %  {  options        OUTPUT   Options data structure for filtering.   {}  { Called by   {  Main of FMTRC  {}  { Calls   {  AddMsgHeader        FMTRC procedure  {  AddMsgText          FMTRC procedure  {  DefaultFormatFile   FMTRC function   {  ProcessOptionInput  FMTRC procedure  {  SetStrLen           Pascal Standard String procedure   {  StrAppend           Pascal Standard String procedure   {  StrLen              Pascal Standard String function  {  StrLTrim            Pascal Standard String function  {  TestTraceLevel      FMTRC function   {  TestTime            FMTRC function   {  TestProtocol        FMTRC function   {  TestNodesPair       FMTRC function   {  TestServMonId       FMTRC function   {  TestSocket          FMTRC function   {  UIGetInput          Fileio procedure   {  UIOpenInput         Fileio function  {  UIOpenOutput        Fileio function  {  UIWriteOutput       Fileio procedure   {  Upshift             FMTRC procedure  {}  {   {   {              Algorithm/Pseudocode   {   ${ IF command_input_name was not specified in the runstring, assign LU 1  $ {   to it (the default)   
{ Open command_input_name  
 %{ Print the current settings for Parms and Options (runstring settings and % {   defaults)    { Prompt the user with the query 'Do you want to change any...'    { If yes  {   .While not the end of input (input was /A or AB or /E)  {      .Loop on parms two, three and four and all options   #{         .Print a query for the parm/option at hand showing defaults  # {         .Read the user's input  {         .Process the user's input   {         .If the input is not /A or AB or /E or blank  {            .Case on parm/option   
{               .parm two, 
 {                parm three,  
{                parm four 
 "{                  : assign the value input to parms data structure  " {               .trace level  {                  : if TestTraceLevel yields no error  "{                      .assign value input to options data structure " {               .start time   {                  : if TestTime yields no error  "{                      .assign value input to options data structure " 
{               .stop time 
 {                  : if TestTime yields no error  "{                      .assign value input to options data structure " 
{               .protocol  
 {                  : if TestProtocol yields no error  "{                      .assign value input to options data structure " {               .nodes pair   {                  : if TestNodesPair yields no error   "{                      .assign value input to options data structure " {               .service/monitor id   {                  : if TestServMonId yields no error   "{                      .assign value input to options data structure " {               .socket   {                  : if TestSocket yields no error  "{                      .assign value input to options data structure " {             End case  {            .If error was returned   {               .Write the error message  {             Else increment to read the next user input  {          Else if input was blank  {            .increment to read the next user input   {          Endif  {    Endwhile   { Endif   {}  $PAGE$      CONST      BLANKS = String72 [MSGLEN OF ' '];       VAR      finished_entry : BOOLEAN;     user_end_input : BOOLEAN;     index : ParmOptionEntry;   	   result : Int16; 	    temp_string  : String72;      temp_string2 : String72;           $SUBTITLE 'ParseInput', PAGE$       "{-----------------------------------------------------------------}  " "{                                                                 }  " "{    *LOCAL*             ParseInput                   *LOCAL*     }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
PROCEDURE ParseInput 
    ( VAR temp_string : String72;       VAR user_abort : BOOLEAN;       VAR user_end_input : BOOLEAN);       VAR      len : Int16;       BEGIN  { ParseInput }       user_abort := FALSE;        { initialize }  user_end_input := FALSE;      temp_string := StrLTrim (temp_string);  len := StrLen (temp_string);      IF len > 1 THEN      BEGIN  $   IF temp_string[1] = '/' THEN        { is this a slash-type command? } $       BEGIN         IF temp_string[2] = 'E' THEN  &         user_end_input := TRUE            { '/E' is end interactive input } &       ELSE IF temp_string[2] = 'A' THEN   %         user_abort := TRUE                { '/A' is abort the formatter } %       ELSE IF temp_string[2] = 'D' THEN   $         temp_string := ' ';               { '/D' is default the entry } $       END   !   ELSE IF (temp_string[1] = 'A') AND (temp_string[2] = 'B') THEN  ! &      user_abort := TRUE;                  { 'AB' is an alternate to '/A' }  & 
   END;  { if len }  
     END;   { ParseInput }           $SUBTITLE 'ShowDefaults', PAGE$   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{   *LOCAL*              ShowDefaults                *LOCAL*      }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE ShowDefaults;       VAR      index  : Int16;                 { FOR loop control }      opt_index  : ParmOptionEntry;   { FOR loop control }           BEGIN  { ShowDefaults }       WITH parms DO      BEGIN      
   FOR index := 0 TO 5 DO  
       BEGIN   
      CASE index OF  
           0: temp_string := ' ';                1: temp_string := TITLE_DEF;                2: temp_string := ' ';      	          3: BEGIN 	              temp_string := DEFAULT_RAW_FILE;                IF parms.raw_file_name = '' THEN                   parms.raw_file_name := RAW_FILE_DEFAULT;               temp_string2 := parms.raw_file_name;                AddMsgText (temp_string, temp_string2, FALSE);                END;  { case 3 }       	          4: BEGIN 	              temp_string := DEFAULT_FORMAT_FILE;               IF parms.format_file_name = '' THEN                  parms.format_file_name :=                      DefaultFormatFile (parms.raw_file_name);                temp_string2 := parms.format_file_name;               AddMsgText (temp_string, temp_string2, FALSE);                END;  { case 4 }       	          5: BEGIN 	              temp_string := DEFAULT_LABEL_FIELD;               IF parms.label_field = '' THEN                   StrAppend (temp_string, LABEL_BLANK)               ELSE BEGIN                   temp_string2 := parms.label_field;                  AddMsgText (temp_string, temp_string2, FALSE);                  END; { label field not blank }               END;  { case 5 }               Otherwise;               END;  { case }             UIWriteOutput (temp_string);      
      END;  { for }  
        END; { with }         temp_string := DEFAULT_TRACE_LEVEL;     UIWriteOutput (temp_string);      temp_string := DEFAULT_START_TIME;      UIWriteOutput (temp_string);      temp_string := DEFAULT_STOP_TIME;     UIWriteOutput (temp_string);      temp_string := DEFAULT_PROTOCOL;      UIWriteOutput (temp_string);      temp_string := DEFAULT_NODES_PAIR;      UIWriteOutput (temp_string);      temp_string := DEFAULT_SERVMON1;      UIWriteOutput (temp_string);      temp_string := DEFAULT_SERVMON2;      UIWriteOutput (temp_string);      temp_string := DEFAULT_SOCKET;      UIWriteOutput (temp_string);      temp_string := ' ';     UIWriteOutput (temp_string);       END;   { ShowDefaults }           $SUBTITLE 'QueryUser', PAGE$      
BEGIN  { QueryUser } 
     WITH parms DO      BEGIN     IF command_input_name = '' THEN        BEGIN         command_input_name := '1';        END;  $                        { result is a dummy return in these two calls }  $    result := UIOpenInput (command_input_name, result);     result := UIOpenOutput (command_input_name, result);   	   END;  { parms } 	     ShowDefaults;       temp_string := Q_MODIFY;  UIGetInput (temp_string, temp_string);  IF (temp_string <> '') AND (temp_string <> ' ') THEN     BEGIN      
   Upshift (temp_string);  
    ParseInput (temp_string, user_abort, user_end_input);     IF temp_string[1] <> 'Y' THEN        user_end_input := TRUE     ELSE         finished_entry := FALSE;     { initialize flag }         END  ELSE user_end_input := TRUE;      IF (NOT user_end_input) AND (NOT user_abort) THEN      BEGIN         FOR index := FIRST_ENTRY TO LAST_ENTRY DO     BEGIN                        { Don't prompt the user pointlessly }          IF ((index = PROTOCOL_ENTRY) OR         (index = NODES_PAIR_ENTRY)) AND         (NOT options.trace_level[NTWORK]) THEN         finished_entry := TRUE;       '   IF ((index = SERVMON_ENTRY) AND         {  User selects services and     }  ' '       (options.trace_level[NTWORK]) AND   {  monitors only for socket msgs }  ' '       (NOT options.protocol[RROUTER])) THEN {  or router at network-level  }  '       finished_entry := TRUE;       #   IF (index = SOCKET_ENTRY) AND (NOT options.trace_level[SCKET]) THEN #       finished_entry := TRUE;              WHILE (NOT user_end_input) AND (NOT finished_entry) AND           (NOT user_abort) DO        BEGIN       
      CASE index OF  
              RAW_FILE_ENTRY    : temp_string2 := PROMPT_RAW_FILE;             FORMAT_FILE_ENTRY : temp_string2 := PROMPT_FORMAT_FILE;             LABEL_FIELD_ENTRY : temp_string2 := PROMPT_LABEL_FIELD;             TRACE_LEVEL_ENTRY : temp_string2 := PROMPT_TRACE_LEVEL;             START_TIME_ENTRY  : temp_string2 := PROMPT_START_TIME;             STOP_TIME_ENTRY   : temp_string2 := PROMPT_STOP_TIME;           PROTOCOL_ENTRY    : temp_string2 := PROMPT_PROTOCOL;             NODES_PAIR_ENTRY  : temp_string2 := PROMPT_NODES_PAIR;             SERVMON_ENTRY     : temp_string2 := PROMPT_SERVMON;           SOCKET_ENTRY      : temp_string2 := PROMPT_SOCKET;   
         Otherwise;  
          END;   { case }          #      IF index = RAW_FILE_ENTRY THEN  { default depends on runstring } #          BEGIN           IF parms.raw_file_name <> '' THEN  	            BEGIN  	             temp_string := parms.raw_file_name;                SetStrLen (temp_string2, 40);    { '...Default = ' }               StrAppend (temp_string, ' ]');              AddMsgText (temp_string2, temp_string, FALSE);              END;   { if parms.raw }            END;       $      IF index = FORMAT_FILE_ENTRY THEN  { default depends on raw file } $ $         BEGIN                           {  user may have just entered } $           temp_string := DefaultFormatFile (parms.raw_file_name);            IF temp_string <> 'NS_TRACE.FMT' THEN  	            BEGIN  	             parms.format_file_name := temp_string;               SetStrLen (temp_string2, 46);   { '...Default = ' }                StrAppend (temp_string, ' ]');              AddMsgText (temp_string2, temp_string, FALSE);              END;  { if temp_string }           END;  { if index }             temp_string  := BLANKS;         UIWriteOutput (temp_string2);         temp_string2 := FMTRC_PROMPT;         UIGetInput (temp_string2, temp_string);         temp_string2 := temp_string;      
      CASE index OF  
         TRACE_LEVEL_ENTRY..                   SOCKET_ENTRY  : ProcessOptionInput (temp_string);   	        Otherwise; 	 
      END;  { case } 
           IF temp_string <> '' THEN            BEGIN           IF index <> LABEL_FIELD_ENTRY THEN               Upshift (temp_string);           ParseInput (temp_string, user_abort, user_end_input);           END;             IF (NOT user_end_input) AND (NOT user_abort) THEN            BEGIN           IF (temp_string <> ' ') AND (temp_string <> '') THEN   	            BEGIN  	 #                      { save user's input for formatted file header }  # #                      {   information                               }  # 
            CASE index OF  
                START_TIME_ENTRY..                    SOCKET_ENTRY : BEGIN                                    command_value [index] := BLANKS;   #                                command_value [index] := temp_string;  #                                 END;  
               Otherwise;  
             END;   { case }                   WITH options DO   
               BEGIN 
                    CASE index OF      $                 RAW_FILE_ENTRY    : parms.raw_file_name := temp_string; $                      FORMAT_FILE_ENTRY :  &                    BEGIN            { Don't let user overwrite trace file } &                     IF temp_string <> parms.raw_file_name THEN                         parms.format_file_name := temp_string                      ELSE                         result := SAME_FILENAME;                       END;      #                 LABEL_FIELD_ENTRY : parms.label_field := temp_string; #                      TRACE_LEVEL_ENTRY :  $                    result := TestTraceLevel (temp_string, trace_level); $                      START_TIME_ENTRY :   !                    result := TestTime (temp_string, start_time);  !                      STOP_TIME_ENTRY :                       result := TestTime (temp_string, stop_time);                        PROTOCOL_ENTRY :   "                    result := TestProtocol (temp_string, protocol);  "                      NODES_PAIR_ENTRY :   !                    result := TestNodesPair (temp_string, nodes);  !                      SERVMON_ENTRY :  "                    result := TestServMonId (temp_string, serv_mon); "                      SOCKET_ENTRY :                        result := TestSocket (temp_string, socket);        
                 Otherwise 
                     result := INTERNAL_ERR_LAST_ENTRY;                     END;  { case }                  END;  { with }                      IF result <> 0 THEN                    BEGIN                     AddMsgHeader (result, msg_buf, FALSE);                    AddMsgText (msg_buf, temp_string2, FALSE);                    UIWriteOutput (msg_buf);                    result := 0;                    END   #               ELSE BEGIN  { user input checked out ok semantically }  #                   finished_entry := TRUE;   #                  END;     { user input checked out ok semantically }  #                 END  { if user entered a non-null value }       #         ELSE   { user wants to take the default value of this entry } #             finished_entry := TRUE;                END;  { if }             END;  { while }          IF finished_entry THEN        { reset flag for next entry }        finished_entry := FALSE;         END;  { for }         END;  { if }       
END;  { QueryUser }  
         $SUBTITLE 'ReadCommandFile', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   ReadCommandFile                               }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
PROCEDURE ReadCommandFile  
    ( VAR command_file : String64;        VAR command_value : TempEntryType);  {}  { Discussion  #{  Strings are obtained from the command file that will be translated  # "{  into Parms and Options.  Values written into the command file are " "{  expected to be in a particular order, with the value(s) for each  " "{  Parm or Option entered on a new line of the file.  Where '/D' or  " !{  a blank line is found, the default value will be assumed later. ! #{  Runstring Parms override the Parm values found in the command file. # #{  Strings that are obtained from the command file are left justified  # #{  to eliminate any leading blank characters before they are assigned  # {  to the command_value array.  {}  { Parameters  !{  command_file   INPUT   The file specified in the runstring for  ! {                         command input.  #{  command_value  OUTPUT  A simple array of strings that are obtained  # #{                         from the command file.  The array subscript  # #{                         is related to individual Parms and Options.  # {}  { Called by   {  Main of FMTRC  {}  { Calls   {  UIOpenInput      Fileio Procedure  {  UIEndOfInput     Fileio Function   {  GetNextValue     Local to ReadCommandFile  {}  {   {   {              Algorithm/Pseudocode   {   { Open the command file.  { Start with the first entry number.  { While not the end of the file   {   .Call GetNextValue into the temporary array of strings  {   .Increment the entry counter  { If not all entries were present in the file   {   .Initialize the remaining elements of the temp. array   {}  $PAGE$      VAR      text_line :    String72;         { a command file record }       trash_result : Int16;            { dummy return from Fileio }   "   entry_count :  ParmOptionEntry;  { command file values counter }  " 
   dcb_ptr : DcbPtr; 
         $SUBTITLE 'GetNextValue', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{   *LOCAL*         GetNextValue                    *LOCAL*       }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE GetNextValue     ( VAR return_value : String);  {}  { Discussion  "{  Call the Fileio procedure to read a record from the command file. " "{  Text is left justified.  Read and throw away comment lines.  Keep " !{  reading until a non-comment line is found.  '/D' changed to the ! {  null string value.  Blank line will be taken as a default.   {  The label field input need not be upshifted.   {}  { Parameters  #{  return_value    OUTPUT   A string that contains some command value  # "{                           or a null string representing a default. " {}  { Called by   	{  ReadCommandFile 	 {}  { Calls   {  UIGetInput       Fileio procedure  {  Strltrim         Pascal Standard string function   {  Upshift          FMTRC function  {}  {   {                Algorithm/Pseudocode   {   { Initialize a string variable to null  { Repeat  {   .Call GetInput with no prompt   
{   .Left trim the string  
 { Until the leftmost character is not a '*' for comment line  { If the file entry contains '/D' for default then  {   .Set the string to null for the default choice  { Pass this left justified and/or nulled string back  {}  $PAGE$          VAR      no_prompt : String1;    {Dummy string for Fileio}      BEGIN  {GetNextValue}       no_prompt := '';   return_value := '';        {Initialize to indicate the default}        REPEAT     UIGetInput (no_prompt, return_value);  !   return_value := Strltrim (return_value);       {left justfify}  ! UNTIL (return_value = '') OR (UIEndOfInput) OR  "      (return_value[1] <> '*');           {pass over comment lines}  "     IF entry_count <> LABEL_FIELD_ENTRY THEN  
   Upshift (return_value); 
 IF (return_value <> '') AND        (return_value[1] = '/') AND       (return_value[2] = 'D') THEN   
   BEGIN {default chosen}  
    return_value := '';  
   END;  {default chosen}  
     END;   {GetNextValue}       $SUBTITLE 'ReadCommandFile', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   ReadCommandFile                               }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "         BEGIN  {ReadCommandFile}      trash_result := UIOpenInput (command_file, trash_result);       "                                { Check command input file for EOF}  " FOR entry_count := FIRST_ENTRY TO LAST_ENTRY DO      BEGIN     IF (NOT UIEndOfInput) THEN         BEGIN {read records from the command file}           GetNextValue (command_value[entry_count]);         END      ELSE   "      BEGIN {initialize remaining command values if file incomplete} "          command_value[entry_count] := '';  "      END;  {initialize remaining command values if file incomplete} "    END; {for}       END;   {ReadCommandFile}      $SUBTITLE 'TestNodesPair', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   TestNodesPair                                 }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     FUNCTION TestNodesPair     (VAR source_dest_string: String;       VAR nodes_setting: NodesPairType) :  Int16;   {}  { Discussion  !{  This function checks a pair of addresses that is preceded by a  ! "{  label.  According to the protocol label, the appropriate function " !{  is called to check the syntax of each address and to return the ! !{  machine's representation of that address.  The '@' character in ! {  place of the second address value in the input string is a   !{  wildcard to match all addresses.  An error code is returned as  ! {  the function value.  {}  { Parameters  #{   source_dest_string INPUT  String into which the user input string  # {                              element is passed.   "{   nodes_setting      OUTPUT A data structure that contains a label " "{                              designating the protocol type, a flag " !{                              to signal a wildcard address and a  ! !{                              pair of addresses of the type that  !  {                              corresponds to the protocol type.   {}  
{ Functional return  
 {  An error code is returned as the function value.   {}  { Called by   
{  ProcessCommandFileInput 
 {  QueryUser  {}  { Calls   {  Strlen         Pascal Standard String Function   {  Strread        Pascal Standard String Procedure  {}  {   {              Algorithm/Pseudocode   {   {   { Set result to zero.   { Get the string length   
{ Strread the label  
 { If the label is 'GWY','802' or 'RTR' then   {   .Store the label as the protocol type for this pair   { Else  {   .Set result to invalid protocol   { Endif   { If the string is long enough and result = 0 then  {   .Strread an address appropriate to the protocol type  {   .Call function to syntax check the address  {   .If the syntax is ok then   {      .Store the machine version of the address in options   {      .Set position to read the next address   {      .If the string is long enough and result = 0 then  {         .Strread an address appropriate to the protocol type  {         .Check for an occurance of '@' in the first position  {         .If there is none then  {            .Call function to syntax check the address   {            .If the syntax is ok then  "{               .Store the machine version of the address in options " {             Else set result to invalid nodes pair   
{             Endif  
 {          Else set the wildcard flag   {          Endif  {       Else set result to invalid nodes pair   {       Endif   {    Else set result to invalid nodes pair  {    Endif  { Else set result to invalid nodes pair   { Endif   { Set function to return  {}      VAR   
   i        : Int16; 
 
   result   : Int16; 
 
   next_pos : Int16; 
    temp_node : Int32;   
   blank    : CHAR;  
    proto_temp : PACKED ARRAY [1..3] OF CHAR;     ip_addr_temp1 : String[15];     ip_addr_temp2 : String[15];     stat_addr_temp1 : String17;     stat_addr_temp2 : String17;  
   node_string : String5;  
     BEGIN  {TestNodesPair}         result := 0;      SetStrLen (source_dest_string, MSGLEN);     WITH nodes_setting DO        BEGIN             StrRead (source_dest_string, 1, next_pos, proto_temp);        CASE proto_temp[1] OF            'G' : address_type := GWY;            '8' : address_type := LAN;            'R' : address_type := RTR;            ' ' : address_type := ALL;            Otherwise result := INVALID_PROTOCOL;  
      END;  { case } 
     
      IF (result = 0) THEN 
          BEGIN           wildcard := FALSE;   $         StrDelete (source_dest_string, 1, 3);  { delete the protocol }  $          source_dest_string := StrLTrim (source_dest_string);            SetStrLen (source_dest_string, MSGLEN);           CASE address_type OF               GWY : BEGIN       &                  StrRead (source_dest_string, 1, next_pos, ip_addr_temp1);  & $                  ArpaIpAdr (ip_addr_temp1, address.ip_addr[1], result); $                       IF result = 0 THEN  
                     BEGIN 
                          StrDelete (source_dest_string, 1, 15);   %                     source_dest_string := StrLTrim (source_dest_string);  %                      SetStrLen (source_dest_string, MSGLEN);  '                     StrRead (source_dest_string, 1, next_pos, ip_addr_temp2); '                          IF ip_addr_temp2[1] = '@' THEN                           wildcard := TRUE  
                     ELSE  
 '                        ArpaIpAdr(ip_addr_temp2, address.ip_addr[2], result);  '                          END;  { if }                         IF result <> 0 THEN                        result := INVALID_NODES_PAIR;                        END;  { gwy }                   LAN : BEGIN       '                  StrRead (source_dest_string, 1, next_pos, stat_addr_temp1);  ' &                  UserToInternal (stat_addr_temp1, address.station_addr[1],  &                                   result);                    IF result = 0 THEN  
                     BEGIN 
                          StrDelete (source_dest_string, 1, 17);   %                     source_dest_string := StrLTrim (source_dest_string);  %                      SetStrLen (source_dest_string, MSGLEN);                       StrRead (source_dest_string, 1, next_pos,                                stat_addr_temp2);                        IF stat_addr_temp2[1] = '@' THEN                           wildcard := TRUE  
                     ELSE  
                         UserToInternal (stat_addr_temp2,  %                                        address.station_addr[2], result);  %                      END;  { if }                         IF result <> 0 THEN                        result := INVALID_NODES_PAIR;                        END;  { lan }                   RTR : BEGIN                          next_pos := StrPos (source_dest_string, ' ');    &                  IF (next_pos > 1) AND (next_pos <= 6) THEN  { 1-5 digits } & 
                     BEGIN 
 &                     node_string := Str (source_dest_string,1,next_pos - 1); &                          IF NumChk (node_string) THEN                           BEGIN   #                        StrRead (node_string, 1, next_pos, temp_node); # %                        IF (temp_node <= 32767) AND (temp_node >= 0) THEN  %                             BEGIN                           address.node_number[1] := temp_node;  "                        StrDelete (source_dest_string, 1, next_pos); " &                        source_dest_string := StrLTrim (source_dest_string); & &                        source_dest_string := StrRTrim (source_dest_string); &                          next_pos := StrLen (source_dest_string);                               IF next_pos <> 0 THEN                              BEGIN                             IF NumChk (source_dest_string) THEN                                BEGIN   $                              StrRead (source_dest_string, 1, next_pos,  $                                        temp_node);                                IF (temp_node <= 32767) AND                                    (temp_node >= 0) THEN  "                                 address.node_number[2] := temp_node "                                ELSE result := INVALID_NODES_PAIR;                                 END  { if NumChk }  "                           ELSE result := -1;     { Check for '@' }  "                            END  { if next_pos }                           ELSE result := INVALID_NODES_PAIR;                              END   { if temp_node }                          ELSE result := INVALID_NODES_PAIR;                              END  { if NumChk }                       ELSE result := INVALID_NODES_PAIR;                            END  { if next_pos <> 0,1 or >6 }                    ELSE result := INVALID_NODES_PAIR;                            IF result = -1 THEN   { Check for '@' }   
                     BEGIN 
 &                      { Wildcard is only valid character other than digits } &                      IF (StrLen (source_dest_string) = 1) AND                           (source_dest_string [1] = '@') THEN                           BEGIN                           result := 0;                          wildcard := TRUE;                           END   
                     ELSE  
                         result := INVALID_NODES_PAIR;                            END;  { if result = -1 }                         END;  { rtr }       
               Otherwise;  
     
            END;  { case } 
              END;  { if result }      
      END;  { with } 
        TestNodesPair := result;       END;   {TestNodesPair}      $SUBTITLE 'TestProtocol', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   TestProtocol                                  }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     FUNCTION TestProtocol      (VAR protocol_string: String;      VAR protocol_setting: ProtocolBitType) :  Int16;  {}  { Discussion   {  This function verifies that the first character of every word   "{  in the user input string is 'G' for Gateway, '8' for 802, 'R' for "  {  Router, or 'N' for None.  It checks only up to three words or   #{  abbreviations in the string.  The Option bits for Protocol are set  # #{  according to the user's input. The function value returns an error  # {  code.  {}  { Parameters  !{   protocol_string INPUT/OUTPUT  String into which the user input ! {                                   string element is passed.   "{   protocol_setting   OUTPUT     Array of three bits, one for each  " {                                   possible protocol Option.   {}  
{ Functional return  
 {  An error code is returned as the function value.   {}  { Called by   
{  ProcessCommandFileInput 
 {  QueryUser  {}  { Calls   {  Strlen        Pascal Standard String Function  {  Strpos        Pascal Standard String Function  {  Strltrim      Pascal Standard String Function  {}  {   {              Algorithm/Pseudocode   {   
{ Set result to zero 
 { Initialize the bit settings   
{ Get the string's length  
 { Loop up to 3 times or until the end of the string   {   .Strread the first character  {   .If it is valid then   {valid is 'G','8','R','N'}   
{     .Set the proper bit  
 {    Else Set result to invalid protocol  {   .Find the next non-blank character  { End loop  { Set the function value to result  {}  $PAGE$      VAR   
   count_choices : Int16;  
 	   result : Int16; 	    len : Int16;      pos : Int16;       BEGIN   { TestProtocol }      FOR pos := GATEWAY TO RROUTER DO     BEGIN     protocol_setting[pos] := FALSE;     END;       result := 0;  
count_choices := 0;  
 len := Strlen (protocol_string);      #WHILE (len > 0) AND (result = 0) AND (count_choices < MAX_CHOICES) DO  #    BEGIN     count_choices := count_choices + 1;         CASE protocol_string[1] OF   	      'G' : BEGIN  	             protocol_setting[GATEWAY] := TRUE;              END;  	      '8' : BEGIN  	             protocol_setting[LAN802] := TRUE;               END;  	      'R' : BEGIN  	             protocol_setting[RROUTER] := TRUE;              END;  %      'N' : BEGIN   { For 'None' selection, all bits are already cleared } %             END;            Otherwise BEGIN                   result := INVALID_PROTOCOL;   
                END; 
    END; {case}      "   IF result = 0 THEN      {shift the string left to the next word}  "       BEGIN         pos := Strpos (protocol_string, ' ');             IF pos <> 0 THEN           BEGIN  $         protocol_string := Str (protocol_string, pos , len - pos + 1);  $          protocol_string := Strltrim (protocol_string);            len := Strlen (protocol_string);            END;             END;  {if result}          END; {while}       TestProtocol := result;   
END;  {TestProtocol} 
         $SUBTITLE 'TestServMonId', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   TestServMonId                                 }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     FUNCTION TestServMonId     (VAR servmon_string: String;       VAR servmon_setting: ServMonType) :  Int16;   {}  { Discussion  "{  This function verifies that the user input string contains up to  " %{  three valid service/monitor ids.  The service/monitor ids found in the  % ${  temporary string are translated and assigned to the Option variable.  $ {  An error code is returned as the function value.   {}  { Parameters  !{   servmon_string INPUT/OUTPUT  String into which the user input  ! {                                  string element is passed.  "{   servmon_setting    OUTPUT    Array of three service/monitor ids  " ${                                  from the legal set; represents user's $ {                                  choices for Option settings  {}  
{ Functional return  
 {  An error code is returned as the function value.   {}  { Called by   
{  ProcessCommandFileInput 
 {  QueryUser  {}  { Calls   {  Strrtrim        Pascal Standard String Function  {  Strltrim        Pascal Standard String Function  {  Strlen          Pascal Standard String Function  {  Strpos          Pascal Standard String Function  {}  {   {               Algorithm/Pseudocode  {   {   
{ Set result to zero 
 { Initialize the Service/Monitor array to false   
{ Get input string length  
 { Loop up to 3 or until end of string   {   .Case on the first non-blank character  {      .'D' : Set element DLIST; increment counter  {      .'E' : Case on the fifth character over  
{                   .'M' : 
 {                       Set element EXECM; increment counter  
{                   .'W' : 
 {                       Set element EXECW; increment counter  ${                   .Otherwise set result to invalid service/monitor id  $ {                  End case   {      .'I' : Set element INPRO; increment counter  {      .'M' : Set element MA; increment counter   {      .'N' : Set element NFT; increment counter  {      .'O' : Set element OR; increment counter   {      .'P' : Set element PTOP; increment counter   {      .'R' : Case on the second character over   {                   .'F' :  Set element RFA   {                   .'P' :  Set element RPM   {                   .'R' :  Set element RR  ${                   .Otherwise set result to invalid service/monitor id  $ 
{                 End case 
 {      .'S' : Set element SR; increment counter   {      .'T' : Set element TRFAS; increment counter  {      .'V' : Set element VT; increment counter   {      .Otherwise set result to invalid service/monitor id  {    End case   {   .Search input string for next blank or end of string  {   .Point to the next non-blank character  { End loop   { If input string contains anything more set result to too many    {    services/monitors  { Set the function to return  {}  $PAGE$      VAR   	   result : Int16; 	    servmon_id : Int16;     pos : Int16;      len : Int16;   
   count_choices : Int16;  
     BEGIN  {TestServMonId}      FOR servmon_id := VT_S TO SERVS DO          {initialize}     BEGIN     servmon_setting[servmon_id] := FALSE;     END;       result := 0;  pos := 1;   
count_choices := 0;  
 len := Strlen (servmon_string);       #WHILE (len > 0) AND (result = 0) AND (count_choices < MAX_CHOICES) DO  #    BEGIN     count_choices := count_choices + 1;         CASE servmon_string[1] OF            'D' : BEGIN                             {DLIST}               servmon_setting[DLIST_S] := TRUE;   
            END;  {case D} 
           'E' : BEGIN                             {EXECM or EXECW}              IF len >= 5 THEN  
               BEGIN 
                CASE servmon_string[5] OF                   'M' : BEGIN                         servmon_setting[EXECM_S] := TRUE;                         END;  {case M}                    'W' : BEGIN                         servmon_setting[EXECW_S] := TRUE;                         END;  {case W}                     Otherwise BEGIN                               result := INVALID_SERVMON_ID;                               END;                    END; {inner case}                  END  {len is valid}  
               ELSE BEGIN  
                     result := INVALID_SERVMON_ID;                       END;  
            END;  {case E} 
           'I' : BEGIN                             {INPRO}               servmon_setting[INPRO_S] := TRUE;   
            END;  {case I} 
           'M' : BEGIN                             {MA}              servmon_setting[MA_S] := TRUE;  
            END;  {case M} 
           'N' : BEGIN                             {NFT}               servmon_setting[NFT_S] := TRUE;   
            END;  {case N} 
           'O' : BEGIN                             {OR}              servmon_setting[OR_S] := TRUE;  
            END;  {case O} 
           'P' : BEGIN                             {PTOP}              servmon_setting[PTOP_S] := TRUE;  
            END;  {case P} 
            'R' : BEGIN                             {RFA or RPM or RR}               IF len >= 2 THEN  
               BEGIN 
                CASE servmon_string[2] OF                   'F' : BEGIN                         servmon_setting[RFA_S] := TRUE;                         END;  {case F}                    'P' : BEGIN                         servmon_setting[RPM_S] := TRUE;                         END;  {case P}                    'R' : BEGIN                         servmon_setting[RR_S] := TRUE;                          END;  {case P}                     Otherwise BEGIN                               result := INVALID_SERVMON_ID;                               END;                    END;  {inner case}                 END   {if length is valid}               ELSE BEGIN                   result := INVALID_SERVMON_ID;                   END;   
            END;  {case R} 
           'S' : BEGIN                             {SR}              servmon_setting[SR_S] := TRUE;  
            END;  {case S} 
           'T' : BEGIN                             {TRFAS}               servmon_setting[TRFAS] := TRUE;   
            END;  {case T} 
           'V' : BEGIN                             {VT}              servmon_setting[VT_S] := TRUE;  
            END;  {case V} 
           Otherwise BEGIN                   result := INVALID_SERVMON_ID;   
                END; 
 	      END;  {case} 	        pos := Strpos (servmon_string, ' ');   
   IF pos <> 0 THEN  
       BEGIN   !      servmon_string := Str (servmon_string, pos, len - pos + 1);  !       servmon_string := Strltrim (servmon_string);        len := Strlen (servmon_string);         END  {advance to the next choice}   	   ELSE len := 0;  	        END;  {while}      IF (len > 0) AND (result = 0) THEN     result := TOO_MANY_SERVMONS;       TestServMonId := result;      END;   {TestServMonId}      $SUBTITLE 'TestSocket', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   TestSocket                                    }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
FUNCTION TestSocket  
    (VAR socket_string: String;      VAR socket_setting: SocketType) :  Int16;   {}  { Discussion  "{  This function verifies that the user input string contains up to  "  {  3 16-bit integer values.  The input string is right trimmed,    !{  and checked to contain only digits and spaces.  The integer(s)  !  {  obtained are stored in the Option variable. An error code is    {  returned in the funcion value.   {}  { Parameters  #{   socket_string   INPUT     String into which the user input string  # {                              element is passed.   #{   socket_setting  OUTPUT    Array of three integers for storing the  # !{                              user's choice(s) for Socket Options ! {}  
{ Functional return  
 {  An error code is returned as the function value.   {}  { Called by   
{  ProcessCommandFileInput 
 {  QueryUser  {}  { Calls   {  Strrtrim       Pascal Standard String Function   {  Strlen         Pascal Standard String Function   {  Strread        Pascal Standard String Function   {}  {   {               Algorithm/Pseudocode  {   {   
{ Set result to zero 
 { Get the length of the string  
{ Scan the string elements 
 {   .Case string element  {      .'0'..'9',' ' : begin end  {      .Otherwise : set return to invalid socket  {    End case   { If result still is zero then  {   .Loop up to 3 or until the end of the string  {      .Read an integer   {      .Set the Socket Option   {    End loop   #{ If there is more in the input string, set result to too many sockets # { Set function to result  { Endif   {}  $PAGE$      VAR   	   result : Int16; 	    len : Int16;      pos : Int16;      test_number : Int32;   
   count_choices : Int16;  
     BEGIN       result := 0;  pos := 1;   len := Strlen(socket_string);       REPEAT     CASE socket_string[pos] OF            {test first}         '0'..'9', ' '  : BEGIN                         pos := pos + 1;                         END;         Otherwise BEGIN                   result := INVALID_SOCKET;   
                END; 
    END; {case}      UNTIL (pos > len) OR (result <> 0);       	IF result = 0 THEN 	 !   BEGIN                                  {if valid, then convert} !    count_choices := 0;     pos := 1;         REPEAT             count_choices := count_choices + 1;         Strread (socket_string, pos, pos, test_number);         IF (test_number >= 0) AND (test_number <= 32767) THEN            socket_setting[count_choices] := test_number         ELSE result := INVALID_SOCKET;         UNTIL (pos > len) OR (count_choices = MAX_CHOICES) OR           (result <> 0);       
   END; {if result}  
     IF (result = 0) AND (len > pos) THEN     result := TOO_MANY_SOCKETS;      TestSocket := result;       	END;  {TestSocket} 	         $SUBTITLE 'TestTime' , PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   TestTime                                      }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     	FUNCTION TestTime  	    (VAR time_string: String;      VAR time_setting: Int32) :  Int16;  {}  { Discussion  !{  This function verifies that the user input string contains the  !  {  time value written in the form: HH:MM:SS:LL.  The digits are    !{  checked against the maximum possible time setting.  The Option  ! "{  value is set with this time value converted to a 2-word integer.  " {  The function value is an error return.   {}  { Parameters  #{   time_string INPUT/OUTPUT  String into which the user input string  # {                               element is passed.  "{   time_setting   OUTPUT     Single character string containing the " "{                               user's choice for Option trace level " {}  
{ Functional return  
 {  An error code is returned as the function value.   {}  { Called by   
{  ProcessCommandFileInput 
 {  QueryUser  {}  { Calls   {  Strrtrim        Pascal Standard String Function  {  Strlen          Pascal Standard String Function  {  Strread         Pascal Standard String Procedure   {}  {   {   {            Algorithm/Pseudocode   {   {   
{ Set return to zero 
 { If the string length is less than 11 then   {   .Set the function to invalid time string  { Else  {   .Assign blanks between the digits   {   .Strread (time_string,1,next_pos,HH,MM,SS,LL).   {   .If NOT ((HH > 23) OR (MM > 59) OR (SS > 59) OR (LL > 99) OR   {       (HH < 0) OR (MM < 0) OR (SS < 0) OR (LL < 0)) THEN  {     .Set return to invalid time string  {    Else   "{     .Compute tenths of milliseconds from the digits in the string  " !{        multiplying hours, minutes, and seconds appropriately and ! "{        adding the tenths of milliseconds value given in the string " {    Endif  { Set function to return(invalid time string)   {}  $PAGE$      CONST   
   TIME_LENGTH = 11; 
     VAR   	   result : Int16; 	    pos : Int16;      len : Int16;   
   next_pos : Int16; 
 
   HH, MM, SS, LL : Int16; 
    two_chars : String2;       BEGIN {TestTime}      result := 0;  len := Strlen (time_string);      "IF len <> TIME_LENGTH THEN     { the legal length for time string }  "    BEGIN     result := INVALID_TIME_STRING;      END  ELSE BEGIN  {legal length for time string}  &   Setstrlen (time_string, TIME_LENGTH + 1);  { this algorithm requires a  } & &   pos := 1;                                  { dummy character at the end } &        REPEAT         two_chars := Str (time_string, pos, 2);         IF NumChk (two_chars) THEN            BEGIN                        { eliminate the ':' for }              time_string[pos + 2] := ' '; {   Strread of integers }             pos := pos + 3;           END        ELSE BEGIN           result := INVALID_TIME_STRING;            END;      UNTIL (pos > TIME_LENGTH) OR (result <> 0);         IF result = 0 THEN         BEGIN         Strread (time_string, 1, next_pos, HH, MM, SS, LL);             IF NOT ((HH < 0) OR (MM < 0) OR (SS < 0) OR (LL < 0) OR   "              (HH > 23) OR (MM > 59) OR (SS > 59) OR (LL > 99)) THEN "          BEGIN  {if time string digits are in range}  "                   { Pascal can't handle this now in one statement } "          time_setting := ((HH * 60) + MM) * 60 + SS;           time_setting := time_setting * 100 + LL;            END        ELSE BEGIN           result := INVALID_TIME_STRING;            END;   {if time string digits are in range}      
      END;  { if result }  
    END;  {if string length is valid}      
TestTime := result;  
     END;  {TestTime}          $SUBTITLE 'TestTraceLevel', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   TestTraceLevel                                }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     FUNCTION TestTraceLevel      (VAR trace_level_string: String;       VAR trace_level_setting: LevelBitsType) :  Int16;   {}  { Discussion  !{  This function verifies that the user input string contains the  !  {  single character 'N' for Network, 'S' for Socket, or 'B' for    {  Both.  The value found is translated into the proper bit   {  settings for trace level.  An error code is returned in the  	{  funcion value.  	 {}  { Parameters  #{   trace_level_string  INPUT  String into which the user input string # {                              element is passed.   #{   trace_level_setting OUTPUT Boolean two word array representing the # "{                              user's choice for Option trace level  " {}  
{ Functional return  
 {  An error code is returned as the function value.   {}  { Called by   
{  ProcessCommandFileInput 
 {  QueryUser  {}  { Calls   {}  {   {             Algorithm/Pseudocode  {   { Check the value of the temporary string's first character   { If it is one of the accepted values then  
{   .Set the Option value  
 {   .Set the funtion value to zero  { Else set the function to invalid trace level  {}  $PAGE$      VAR   	   result : Int16; 	     BEGIN  {TestTraceLevel}       trace_level_setting [SCKET] := FALSE;   trace_level_setting [NTWORK] := FALSE;      result := 0;      CASE trace_level_string[1] OF      'B' : BEGIN           trace_level_setting [SCKET] := TRUE;            trace_level_setting [NTWORK] := TRUE;           END;      'N' : BEGIN           trace_level_setting [NTWORK] := TRUE;           END;      'S' : BEGIN           trace_level_setting [SCKET] := TRUE;            END;   
   Otherwise  BEGIN  
               result := INVALID_TRACE_LEVEL;  	              END; 	    END;  {case}       
TestTraceLevel := result;  
 END;   {TestTraceLevel}                  { FMTUI }  .  