 $PASCAL ',7 91790-1X073 REV.4010 <851216.1216>'   
$STANDARD_LEVEL 'HP1000'$  
 $debug$   $HEAPPARMS OFF$   $RECURSIVE OFF$   $RANGE OFF$   $HEAP 0$  	$HEAP_DISPOSE OFF$ 	     MODULE ifpob;   	$ALIAS 'N$IFPOB'$  	     $TITLE 'MODULE Description',PAGE$   {}  {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  
{      NAME:   IFPOB 
 
{      SOURCE: 91790-18073 
 
{      RELOC : NONE  
 	{      PGMR  : DGA 	 {}  ${----------------------------------------------------------------------- $ { MODIFICATIONS   {   {    date  Prgmr  Description   {  840208   jar   Implement "import from .rels"   "{  850404   cwj   Change IFP's IP protocol number to match change in " {                 Canonical address standard.   {  850729   RM    Converted SendEvent to Log_Event  {  850830   RM    Used negative char to log ASCII messages  {  850926   RM    Call LogEvent first thing   ${----------------------------------------------------------------------- $ {}  
{ MODULE DESCRIPTION 
 {   {    This module contains the IFP outbound routines and   {    global variables.  {   {}  $TITLE 'IMPORT Section',PAGE$       IMPORT         $SEARCH 'phtm/BODEC.REL'$     bodec,      $SEARCH 'phtm/SODEC.REL'$     sodec,      $SEARCH 'phtm/MMDEC.REL'$     mmdec,      $SEARCH 'phtm/MMEXT.REL'$     ds_mm,      $SEARCH 'phtm/TRCMOD.REL'$      trcmod,     $SEARCH 'phtm/IPDEC.REL,phtm/TMRDEC.REL'$     ipdec,   $WIDTH 150$   -   $SEARCH 'phtm/IPLIB.REL,phtm/IPDB.REL,phtm/TRCMOD.REL,phtm/SIGMOD.REL,phtm/TUSER.REL'$  - $WIDTH 80      iplib,      $SEARCH 'phtm/IFPDEC.REL'$      ifpdec;          $TITLE 'Export Section',PAGE$       %{------------------------------------------------------------------------} % %{             Export Section                                             } % %{------------------------------------------------------------------------} %     EXPORT      PROCEDURE IFPOB      (    e_msg      : EventMsgType;      VAR ierr       : Int16        );      	PROCEDURE OUTSTUB  	    (    e_msg      : EventMsgType;      VAR ierr       : Int16        );      IMPLEMENT       CONST       IFPOB_OUTSTUB       = 1 ; { Location code for Log_Event    }        IFPOB_IFPOB_1       = 2 ; { Location code for Log_Event    }        IFPOB_IFPOB_2       = 3 ; { Location code for Log_Event    }        IFPOB_IFPOB_3       = 4 ; { Location code for Log_Event    }        IFPOB_IFPOB_4       = 5 ; { Location code for Log_Event    }        IFPOB_IFPOB_5       = 6 ; { Location code for Log_Event    }        IFPOB_ENTRY         = 7 ; { Location code for Log_Event    }        VAR      pathref       : contextwords ;  { used by Log_Event }          $TITLE 'Forward Declarations',PAGE$       %{-----------------------------------------------------------------------}  % %{             Forward Declarations                                      }  % %{-----------------------------------------------------------------------}  %     PROCEDURE FetchNRVRouter            $ALIAS 'Fetch_NRV_Router'$     (     node        : Int16;        VAR nrv_entry   : NrvEntryType;       VAR nrv_index   : Int16;        VAR err         : Int16  );       EXTERNAL;      PROCEDURE GetRouterAdr     (     mbuf_ptr    : Int16;            dsam_dlen_b : Int16;        VAR router_adr  : Int16;        VAR rtn_err     : Int16 );        FORWARD;       PROCEDURE ProSw      ( VAR e_msg  : EventMsgType;   
     VAR error  : Int16 ); 
      EXTERNAL;              $TITLE 'GetRouterAdr',PAGE$           %{------------------------------------------------------------------------} % %{             GetRouterAdr                                               } % %{------------------------------------------------------------------------} %     PROCEDURE GetRouterAdr     {      mbuf_ptr    : Int16;            dsam_dlen_b : Int16;       VAR  router_adr  : Int16;       VAR  rtn_err     : Int16 };  {}  { Description   "{    This procedure returns the destination router node number that  " !{    is found in the DS/1000 router header at the tail of the DSAM ! {    message. In order to do this we must:  {   !{           1  read the IFP header to get the Router header length ! "{              to be used as an offset for reading the Router header " {   {           2  read the Router header destination node number   {   { Parameters  {    mbuf_ptr    <input>   Pointer to the message in DSAM   {   !{    dsam_dlen_b <input>   Message length <bytes> of DSAM message  ! {   "{    router_adr  <output>  Destination router address extracted from " {                          the router header in DSAM  {   {    rtn_err     <output>  Error return:  0    no error   "{                                         x    memory manager error  " {}  CONST      LEN_4_B  = 4;    { Length of 4 bytes }      LEN_8_B  = 8;    { Length of 8 bytes }       VAR   %   hdr_offset_b   : Int16;           { Offset <bytes> for DS_MRead call }  %    ifp_header     : IfpHeaderType;   { Holder for IFP header }  "   mm_flags       : MMFlagsType;     { Flags parameter for mem mgr } " !   router_header  : ZBufferType;     { Holder for router header }  !         
BEGIN {GetRouterAdr} 
 { Read the IFP header field containing the length of   }  { router header so that we know where in the DSAM msg  }  { the router header starts. }   
mm_flags.bits[0] := TRUE;  
 "DS_MRead(ifp_header.int,LEN_4_B,mbuf_ptr,OFFSET_0,mm_flags,rtn_err); " 
IF rtn_err = 0 THEN  
 
   BEGIN { no error} 
    { Read the first 8 bytes of the router header }     { which contain the destination router address}     { as well as the stream word reply flag.      }     hdr_offset_b := dsam_dlen_b - ifp_header.hdrlen_b;   '   DS_MRead(router_header.int,LEN_8_B,mbuf_ptr,hdr_offset_b,mm_flags,rtn_err); '        { Get destination adr. from header.  }      IF  router_header.zb_stream_wd.sw_rply_flag = 1  THEN        BEGIN  { reply }        router_adr   := router_header.zb_src_node_no;         END   { reply }      ELSE         BEGIN { request }         router_adr   := router_header.zb_dst_node_no;         END;  { request }       	   END; {no error} 	 
END; {GetRouterAdr}  
         $TITLE 'OutStub',PAGE$      &{--------------------------------------------------------------------------} & &{             OutStub                                                      } & &{--------------------------------------------------------------------------} &     	PROCEDURE OutStub  	    {     e_msg   : EventMsgType;       VAR err     : Int16       };   {}  { Description   #{    This procedure should not be called. It is used only as an entry  # !{    point for PROSW. It would only be called by a faulty protocol ! {    handler.   {}  VAR      ifp_wkmap : Int16;      err       : Int16;      log_pac   : AscType;      temp1     : EmsgOrCharsType;       BEGIN   DS_EnterCritical(ifp_wkmap,err);  IF err = 0 THEN      BEGIN     temp1.chars  := 'IFPOB: Outstub received spurious emsg';      log_pac.emsg := temp1.emsg;  
   pathref.longint := 0 ;  
    Log_Event(EL_ERROR,IFP_PID,IFPOB_OUTSTUB,pathref,              -MAX_LOG_LEN_BYTES,log_pac.bufr,err);      DS_LeaveCritical(ifp_wkmap);      END;   END;              
$TITLE 'IFPOB',PAGE$ 
     %{------------------------------------------------------------------------} % %{                    IFPOB                                               } % %{------------------------------------------------------------------------} %     PROCEDURE IFPOB      {    e_msg     : EventMsgType;       VAR ifpob_err : Int16 };      {}  { Description   #{    This procedure is IFP's outbound event handler. It is responsible # ${    for accepting Send_Request's from IPC on behalf of IFPM and passing $ "{    the the messages to IP for transmission. In doing so IFPOB must " {    perform the following operations:  {   {       1 Allocate an IP path on which to send.   {            to do this IFPOB must:   !{               a)    Map the destination router address to an IP  ! {                     destination address    {               b)    Map the local source router address to the   {                     source IP address   #{               c)    Call IP's path finding routine "GetIpPath" using # {                     the above mappings.   {   #{       2  Issue a Send_Request to IP which will send the message and  # {          kill the path that was just created.   {   { Parameters  {     e_msg       <input>     Outbound emsg arriving from IPC   {   !{     ifpob_err   <output>    Error return:  not currently defined ! {}      LABEL      99;      { Global exit label }       CONST      IFP_PROTO  =  octal ('353'); { IFP's IP protocol number }      VAR   &   dsam_data_len_b  : Int16;         { Length of incoming DSAM data buf   }  & &   dst_ip_adr       : INTEGER;       { Destination ip address             }  & &   dst_node_no      : Int16;         { Destination router node number     }  & &   err              : Int16;         { General error parameter            }  & &   ifp_msg          : EventMsgType;  { Event message sent by IFPOB        }  & &   ifp_wkmap        : Int16;         { IFP working map                    }  & &   ip_down_path_ref : Int16;         { IP's path reference for transmission} & &   local_ip_adr     : INTEGER;       { Local IP address                   }  & &   local_node_no    : Int16;         { Local router node number           }  & &   log_pac          : AscType;       { Holder for error logger string     }  & &   mbuf_ptr         : Int16;         { Pointer to DSAM mbuf chain         }  & &   nrv_entry        : NRVEntryType;  { Holder for NRV table entry         }  & &   nrv_index        : Int16;         { Unused parameter                   }  & &   temp1            : EmsgOrCharsType;{ Temporary holder for error log str}  &     PROCEDURE Exit;   {}     BEGIN     GOTO 99;      END;           BEGIN {IFPOB}       DS_EnterCritical(ifp_wkmap,err);      
IF err <> 0 THEN GOTO 99;  
     pathref.longint := 0; {dummy}   Log_Event(EL_EVENT,IFP_PID,IFPOB_ENTRY,pathref,                  EMSG_WORD_LEN,e_msg.int,err);      WITH  e_msg  DO      BEGIN { with e_msg }      CASE  em_event  OF   
      SEND_REQUEST:  
          BEGIN  { data }           { Map dst Router address to an IP adr }           mbuf_ptr        := emsr_mbufid;           dsam_data_len_b := abs (emsr_dlen );             GetRouterAdr(mbuf_ptr,dsam_data_len_b,dst_node_no,err);   
         IF err <> 0  THEN 
 	            BEGIN  	             pathref.longint := err ;              DS_MDispose(mbuf_ptr,err);               temp1.chars   := 'IFPOB: GetRouterAdr err;msg lost';               log_pac.emsg  := temp1.emsg;              Log_Event(EL_ERROR,IFP_PID,IFPOB_IFPOB_1,pathref,                        -MAX_LOG_LEN_BYTES,log_pac.bufr,err);              DS_LeaveCritical(ifp_wkmap);  	            Exit;  	             END;           FetchNRVRouter(dst_node_no,nrv_entry,nrv_index,err);   
         IF err <> 0 THEN  
             BEGIN {nrv err}               DS_MDispose(mbuf_ptr,err);              temp1.chars  := 'IFPOB: NRV error; msg lost';               log_pac.emsg := temp1.emsg;               pathref.longint := dst_node_no ;              Log_Event(EL_ERROR,IFP_PID,IFPOB_IFPOB_2,pathref,                        -MAX_LOG_LEN_BYTES,log_pac.bufr,err);              DS_LeaveCritical(ifp_wkmap);  	            Exit;  	             END;  {nrv err}            dst_ip_adr := nrv_entry.nv_ip_adr;                { Map local Router node number to a local IP adr }            DS_FetchGlobal(DS_Local_Node,1,local_node_no);             FetchNRVRouter(local_node_no,nrv_entry,nrv_index,err);    
         IF err <> 0 THEN  
             BEGIN  {nrv err}              DS_MDispose(mbuf_ptr,err);              temp1.chars  := 'IFPOB: NRV error; msg lost ';              log_pac.emsg := temp1.emsg;               pathref.longint := local_node_no ;              Log_Event(EL_ERROR,IFP_PID,IFPOB_IFPOB_3,pathref,                        -MAX_LOG_LEN_BYTES,log_pac.bufr,err);              DS_LeaveCritical(ifp_wkmap);  	            Exit;  	             END;   {nrv err}           local_ip_adr := nrv_entry.nv_ip_adr;                { Get an IP path (reference) on which to send}   &         GetIpPath(dst_ip_adr,local_ip_adr,IFP_PROTO,ip_down_path_ref,err);  & 
         IF err <> 0 THEN  
             BEGIN {path err}              pathref.longint := err ;              { Either:    Path was not available    or }               {            Destination unknown          }               DS_MDispose(mbuf_ptr,err);              temp1.chars := 'IFPOB: IP path error; msg lost ';               log_pac.emsg := temp1.emsg;               Log_Event(EL_ERROR,IFP_PID,IFPOB_IFPOB_4,pathref,                        -MAX_LOG_LEN_BYTES,log_pac.bufr,err);              DS_LeaveCritical(ifp_wkmap);  	            Exit;  	             END;  {path err}           { Format a send_request emsg which also causes }            { IP to kill the path after it has been used.  }            WITH ifp_msg DO  
            BEGIN  {with}  
             em_event          := SEND_REQUEST;              ehport            := IPOB_INDEX;              emsr_down_ref     := ip_down_path_ref;              emsr_mbufid       := mbuf_ptr;              emsr_dlen         := dsam_data_len_b;               emsr_flags.int    := 0;               emsr_opt_mbufid   := 0;               emsr_killsnd_cnt  := 1;               emsr_killrcv_cnt  := 0;   
            END;   {with}  
          DS_LeaveCritical(ifp_wkmap);            ProSw(ifp_msg,err);           END;   { data }            OTHERWISE            BEGIN  { unknown }            temp1.chars  := 'IFPOB: detected invalid emsg   ';            log_pac.emsg := temp1.emsg;           pathref.longint := em_event ;           Log_Event(EL_ERROR,IFP_PID,IFPOB_IFPOB_5,pathref,                    -MAX_LOG_LEN_BYTES,log_pac.bufr,err);            DS_LeaveCritical(ifp_wkmap);            END;   { unknown }   	      END; {case}  	    END;  { with e_msg }       99: ;   END; {IFPOB}      END.  { IFPOB module }     