 $PASCAL '91790-1X078 REV.4010 <860516.1624> '       $ TITLE 'InitClean Routines'$   $ STANDARD_LEVEL'HP1000', RECURSIVE OFF, RANGE OFF, HEAP 0  $   $ DEBUG $   $ CODE_INFO on      	MODULE InitClean;  	 
$ALIAS 'N$InitClean' 
     {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  {      NAME: InitClean  {    SOURCE: 91790-18078  	{     RELOC: NONE  	 {      PGMR: EMS  {}      {}  &{--------------------------------------------------------------------------  & { MODIFICATIONS:  {   {  Date  Prgmr  Description   &{  860225 lms   No longer Stop shutdown on error return from segment (n356). & #{  860319 lms   Only report segment on undefined startup errors (n370) # #{  860320 lms   Abort initialization if wrong driver for an lu (n370). # %{  860516 jc    Move ChangeStatewords out of InitASeg to StartupSegments.  % &{--------------------------------------------------------------------------- & {}      {}  { PROGRAM DESCRIPTION:   {  This module contains routines to find the state of AdvDS/1000   {   {}          IMPORT         { basic memory manager declarations }  
$SEARCH 'phtm/bodec.rel' $ 
    bodec,       
$SEARCH 'phtm/mmdec.rel' $ 
    mmdec,   
$SEARCH 'phtm/mmext.rel' $ 
    ds_mm,          { basic initialization declarations. }   $SEARCH 'phtm/init_dec.rel'$     init_dec,  $SEARCH 'phtm/initmulti.xpt'$      initmulti,   $SEARCH 'phtm/filemad.xpt'$      fileman,   $SEARCH 'phtm/parsdd.xpt' $      parser,  
$SEARCH 'phtm/dres.xpt' $  
    dres,  
$SEARCH 'phtm/alloc.xpt' $ 
    alloc,   $SEARCH 'phtm/init_rte_if.xpt' $     init_rte_if,   $SEARCH 'phtm/tcpinid.xpt' $     tcpinit,   $SEARCH 'phtm/ipcinid.xpt' $     ipcinit,   $SEARCH 'phtm/pxpinid.xpt' $     pxpinit,   $SEARCH 'phtm/tmrinid.xpt' $     tmrinit,   $SEARCH 'phtm/nrginid.xpt' $     nrginit,   $SEARCH 'phtm/muinid.xpt' $      muinit,  $SEARCH 'phtm/nminid.xpt' $      nminit,  $SEARCH 'phtm/nodinid.xpt' $     nodinit,   $SEARCH 'phtm/probinid.xpt' $      probinit,  $SEARCH 'phtm/nftinid.xpt' $     nftinit,   $SEARCH 'phtm/rtrinid.xpt' $     rtrinit,   $SEARCH 'phtm/ipinid.xpt' $      ipinit,  $SEARCH 'phtm/s1kinid.xpt' $     s1kinit,   $SEARCH 'phtm/s3kinid.xpt' $     s3kinit,   $SEARCH 'phtm/ifpinid.xpt' $     ifpinit,   $SEARCH 'phtm/nslnkinid.xpt' $     nslnkinit,   $SEARCH 'phtm/moninid.xpt' $     moninit,   $SEARCH 'phtm/initerrck.xpt'$      initerrck,   $SEARCH 'phtm/initstate.xpt' $     initstate;       $ SUBTITLE 'Exported Routines ', PAGE $       EXPORT      	PROCEDURE Cleanup  	    (   trust_var:    TrustType;          halt_value:   Int16);     { Clean up DS resources and terminate }      
PROCEDURE HandleShut 
    (    ds:           DsStateType;          ds_stateword: Int16;      VAR main_halt:    Int16 );      
PROCEDURE PreCleanup 
    (     trust_var:     TrustType );      
PROCEDURE ProtoShut  
   (      trust_var:     TrustType;           current_seg:   Int16;      VAR  passedresult:  Int16 );      
PROCEDURE StartUpSegments  
 (     netmanseccode:    Int16;        userseccode:      Int16;    VAR main_halt:        Int16 );     { Call each protocol segment's startup routine }       IMPLEMENT   { Module InitClean }      VAR      defflag:    Boolean;   
   message:    PromptType; 
    temp:       Int16;      termflag:   Boolean;       PROCEDURE DeallocateResources      (    halt_value:     Int16 );     FORWARD;      { Deallocate init RN, smb, dsam, and terminate }       $ SUBTITLE 'Cleanup', PAGE $  {------------------------------------------------------------}  {                                                            }  {                      Cleanup                               }  {                                                            }  {------------------------------------------------------------}  {   { Purpose: to cleanup.  {}  	PROCEDURE Cleanup  	    (     trust_var:     TrustType;           halt_value:    Int16 );      {}  ${  Input: trustvar-     Set to TRUST if the protocol segment's shutdown  $ ${                       routines can trust the state of their variables. $ {                       set to NOTRUST otherwise.   {   ${         halt_value-   value to hand to DeallocateDSAM so this routine  $ "{                       can return the proper indication to the user " #{                       in the halt parameter.  <0 indicates problem.  # {   {  Output: none   {  Global Variables Accessed:   !{     Cleanup changes the current segment word in DSAM as it calls ! {     each protocol segment's shutdown routine.   {    {     dsinit_type is also changed to INITCLEANUP for use by the    
{     errorcatcher.  
 {   "{  Routines Called:  ProtoShut, BailOut, DeAllocateDSAM, PrintError, " 	{     CheckResult. 	 {   %{  Cleanup is responsible for shutting down DS and returning all resources % "{  to the system.  It checks the current segment number in DSAM, and " %{  then calls ProtoShut with that number.  ProtoShut calls the appropriate % ${  protocol's shutdown routine, and returns an error parameter.  If the  $ "{  parm. indicates an error occurred, NSINIT will terminate, but the " "{  next time it is run the program will know an error occurred while " #{  shutting down that particular segment, and will pass NOTRUST to it. # {   !{  No matter what error is returned from this cleanup attempt, the ! "{  current segment number will be decremented in DSAM, and the next  " "{  shutdown routine will be called.  This means that if there are n  " "{  protocol segments NSINIT will complete cleanup in n-1 runs of the " {  program with the Shutdown option.  {   !{  When all protocol segment's shutdown routines have been called, ! ${  DSAM is deallocated, and the old services resources will be returned  $ 	{  to the system.  	 {   {}      VAR      internal_result:     Int16;     seg:                 Int16;      $SUBTITLE 'SpecialShut (Cleanup)', PAGE $   PROCEDURE SpecialShut;         { Monitor shutdown and 1k50 shutdown are special cases.       Under normal circumstances these segments are shut down       in different order than when they were started up.         But, if we are recovering from an aborted startup/shutdown         this could mean that although the startup of the segment        occurred we will not do the shutdown.  This is because        the startup number for these segments is numerically        smaller than the shutdown number.      "     Therefore:  treat these segments as special cases at shutdown,  "      and force the shutdown of these segments during abnormal         cleanup.                                                  }          BEGIN    { SpecialShut }          ProtoShut( trust_var, SEG_1K_SH, internal_result );     IF internal_result <> GOOD THEN        BEGIN    { error occurred }         CheckSegPrint( internal_result, SEG_1K_SH );         { don't bail out, since we have no record of coming here }         END;     { error occurred }          ProtoShut( trust_var, SEG_MON_SH, internal_result );      IF internal_result <> GOOD THEN        BEGIN    { error occurred }         CheckSegPrint( internal_result, SEG_MON_SH );         END;     { error occurred }      END;     { SpecialShut }       $SUBTITLE 'Cleanup', PAGE $          BEGIN    { Cleanup }           FetchStatewords( PROTOSEGWORD, FALSE, seg, internal_result );      { FALSE indicates not to exit on error in subroutine. }     IF internal_result = GOOD THEN         BEGIN    { cleanup protocol segments }      !      { IF seg is 0 then assume need to shut down every segment }  !       IF seg = 0 THEN            BEGIN    { start = last }               seg := LAST_SEGMENT;            END      { start = last }          ELSE           BEGIN    { handle special cases }            { Monitor shutdown and 1k50 shutdown are special cases.   "           Handle them here.                                       } "          SpecialShut;            END;     { handle special cases }            WHILE seg <> FIRST_SEGMENT-1 DO            BEGIN    { WHILE }            ProtoShut( trust_var, seg, internal_result );           IF internal_result <> GOOD THEN              BEGIN    { had error }              { print an error for the segment if necessary }               CheckSegPrint( internal_result, seg );                  END;     { had error }               seg := seg -1;       #         ChangeStateWords( PROTOSEGWORD, TRUE, seg, internal_result ); #          { TRUE indicates Exit on error }            END;     { WHILE }       $      { Print message telling user the state if this is normal cleanup.  $ %        Otherwise continue cleaning up.                                 }  %       IF halt_value = 0 THEN           BEGIN    { print message }                PrintError( INITMSG[CRESRETURNED], internal_result );           { ignore error messages, we're cleaning up anyway }           END;     { print message }             END      { cleanup protocol segments }       ELSE         BEGIN    { problem getting segment number }       #      MsgFilePrint( CBADSTWORD_SHUT, PMT_ERROR, 0, internal_result );  #       { don't try error recovery on print errors }            END;     { problem getting segment number }          { Now return the system resources. }      DeallocateResources( halt_value );      END;     { Cleanup }       $ SUBTITLE 'DeallocateResources', PAGE $  %{------------------------------------------------------------------------} % %{                                                                        } % %{                  DeallocateResources                                   } % %{                                                                        } % %{                                                                        } % %{------------------------------------------------------------------------} %     PROCEDURE DeallocateResources      (    halt_value:   Int16 );      VAR      dealloc_result:      Int16;         BEGIN { DeallocateResources }          { Now return the initialization resource number, we're almost   "      done cleaning up.                                           }  "    AccessInitRN(  RTNRN, dealloc_result );     { ignore rn error returns, there's nothing we can do. }         { deallocate SMB }   	   DeallocateSMB;  	        DeAllocateDSAM( halt_value );      { DeAllocate DSAM terminates, control is not returned here.}           END;  { DeallocateResources }      $ SUBTITLE 'HandleShut', PAGE $   %{------------------------------------------------------------------------} % %{                                                                        } % %{                      HandleShut                                        } % %{                                                                        } % %{------------------------------------------------------------------------} %     
PROCEDURE HandleShut 
    (    ds:           DsStateType;          ds_stateword: Int16;      VAR main_halt:    Int16 );  {}  {  Purpose: To handle shut down in the node.  {   {  Input:   ds-            state of ds  {           ds_stateword   value in DS_StateOfDS  #{           main_halt:     value main program should use as halt value # {   {  Output: none   {  Global variables accessed: none  !{  Routines Called: PrintPrompt, CheckResult, YesNoInput, BailOut. ! {   !{  Description: The routine finds out if the user really wants to  ! #{  shut down.  If he/she does, the state of ds is checked to determine # !{  whether the shutdown is after ds is INIT, or had some problem.  ! {   {  If ds is INIT, NormalShut is called to get the Network   {  security code, and shut down if the code is correct.   {   {   {}      VAR      trust_var:        TrustType;      internal_result:  Int16;      userinput:        IStringType;      yes_no:           OneCharType;       $ SUBTITLE 'CheckNetManSecCode (HandleShut)', PAGE $  %{------------------------------------------------------------------------} % %{  (LOCAL)        CheckNetManSecCode         (LOCAL)                     } % %{------------------------------------------------------------------------} %    PROCEDURE CheckNetManSecCode      ( VAR code_result:     Int16 );         VAR        savedseccode:  Int16OrCharType;         tempcode:      Int16OrCharType;             BEGIN    { CheckNetManSecCode }         defflag := FALSE;         termflag := FALSE;            CharInput( INITMSG[CNMSC1] + INITMSG[CNMSC2], TRUE,               defflag, termflag, userinput, code_result );        CheckResult( code_result );         IF code_result <> GOOD THEN BailOut;            Setstrlen( userinput, TWOCHAR );        Strmove( TWOCHAR, userinput, 1, tempcode.CIOrCType, 1 );      '      DS_GetResElement( NSINIT_AdrOf( Lb_NMSC ), 0, savedseccode.IIorCType );  '       IF savedseccode.IIorCType <> 0 THEN            BEGIN    { compare codes }            DS_Encrypt( tempcode.IIOrCType );               IF savedseccode.IIorCType = tempcode.IIorCType THEN              BEGIN    { codes match }              code_result := GOOD;              END      { codes match }             ELSE               BEGIN    { codes don't match }                  code_result := BADSECCODE;              END      { codes don't match }               END      { compare codes }           ELSE           BEGIN    { invalid state }                { until dinit functionality is completed, we could             get in this state.  return that the codes match.  Once    #         completed, we have invalid internal state to let us get here. # !         We should still try and cleanup, but the state should be  ! %         NOTRUST.                                                       }  %              MsgFilePrint( CNMSCIS0, PMT_ERROR, 0, code_result );                code_result := ERR_ALREADY_PRINTED;           END;     { invalid state }         END;     { CheckNetManSecCode }   $ SUBTITLE 'NormalShut (HandleShut)', PAGE $  %{------------------------------------------------------------------------} % %{  (LOCAL)        NormalShut                  (LOCAL)                    } % %{------------------------------------------------------------------------} %    PROCEDURE NormalShut;            BEGIN    { NormalShut }             CheckNetManSecCode( internal_result );        IF internal_result = GOOD THEN           BEGIN    { Do shutdown }                ChangeStateWords( INITSTATEWORD, TRUE, DSINIT_SHUT,  #                                                   internal_result );  #          { TRUE indicates Exit on error }                Cleanup( TRUST, 0 );            { Cleanup terminates.  Control is not returned here }               END      { Do shutdown }           ELSE           IF internal_result = BADSECCODE THEN               BEGIN    { Bad Sec code }       "            MsgFilePrint( CBADNMSC, PMT_ERROR, 0, internal_result ); "             CheckResult( internal_result );               IF internal_result <> GOOD THEN BailOut;                  { return bad halt value to main }               main_halt := 9;               END      { Bad Sec code }              ELSE               BEGIN    { other error }                  Cleanup( NOTRUST, 0 );              END;     { other error }        END;     { NormalShut }       $ SUBTITLE 'PrintActiveStats (HandleShut)', PAGE $  PROCEDURE PrintActiveStats;       CONST      CTCBS = 1;      CPNLS = 2;      CPOOL = 3;   
   FIRST50 = CTCBS;  
 	   LAST50 = CPOOL; 	 	   CCALLSOCK = 1;  	    CVCSOCK = 2;      FIRST90 = CCALLSOCK;   
   LAST90 = CVCSOCK; 
     VAR      active50:            Array[FIRST50..LAST50] OF Int16;     active90:            Array[FIRST90..LAST90] OF Int16;     dummy:               Int16;     index:               Int16;     internal_result:     Int16;         BEGIN    { PrintActiveStats }         { get 91750 statistics }   "   DS_GetResElement( NSINIT_AdrOf( Lb_BUSY ), 0, active50[CTCBS] );  "    DS_CountPNL( active50[CPNLS] );     DS_CountPOOL( active50[CPOOL] );          PrintPrompt( FALSE, '*', internal_result );     CheckResult( internal_result );     IF internal_result <> GOOD THEN BailOut;           PrintPrompt( FALSE, INITMSG[CACTIVEBANNR], internal_result );      CheckResult( internal_result );     IF internal_result <> GOOD THEN BailOut;          FOR index := FIRST50 TO LAST50 DO        BEGIN    { FOR }      
      message := ''; 
     !      Strwrite( message, 1, dummy, INITMSG[CACTIVE50 + index -1],  !                   active50[index] );        PrintPrompt( FALSE, message, internal_result );         CheckResult( internal_result );         IF internal_result <> GOOD THEN BailOut;        END;     { FOR }         { Get 91790 Stats }  %   Get90Stats( active90[CCALLSOCK], active90[CVCSOCK], internal_result );  %        IF internal_result = GOOD THEN         BEGIN    { have 91790 stats }         { If error getting the stats, just don't print them. }            FOR index := FIRST90 TO LAST90 DO   
         BEGIN    { FOR }  
              message := '';       "         Strwrite( message, 1, dummy, INITMSG[CACTIVE90 + index -1], "                      active90[index] );            PrintPrompt( FALSE, message, internal_result );           CheckResult( internal_result );           IF internal_result <> GOOD THEN BailOut;   
         END;     { FOR }  
       END;     { have 91790 stats }          PrintPrompt( FALSE, '*', internal_result );     CheckResult( internal_result );     IF internal_result <> GOOD THEN BailOut;          END;     { PrintActiveStats }  $ SUBTITLE 'HandleShut', PAGE $       
   BEGIN    { HandleShut } 
        internal_result := GOOD;           { CheckShutConditions printed information on the state of DS.        Now ask user if he/she still wants to shutdown.  If ds is  !     sick don't bother to get the security code.                }  !     
   PrintActiveStats; 
 !   { this routine will bail out if error occurs while printing. }  !        { now find out if user still wants to shut down. }   
   defflag := TRUE;  
    YesNoInput( INITMSG[CSURESHUTQ], defflag, yes_no,                               internal_result );      CheckResult( internal_result );     IF internal_result <> GOOD THEN BailOut;       	   IF defflag THEN 	       BEGIN    { use default }  
      yes_no := 'Y'; 
       END;     { use default }         IF yes_no = 'Y' THEN         BEGIN    { check ds state for shutdown }            { we need to lock the initialization rn to keep people         from starting up/running.                                }         AccessInitRN( LOCKRN, internal_result );        { ignore errors }             CASE ds OF      	         DS_INIT:  	             BEGIN    { Init }                   NormalShut;                   END;     { Init }       	         DS_SICK:  	             BEGIN    { sick }               CASE ds_stateword OF                  { know the segment in InitProtoSeg cannot trust                 his tables but the others should be able to   }                      DSINIT_START:                    BEGIN    { starting }                     trust_var := TRUST;                     END;     { starting }                      DSINIT_SHUT:                     BEGIN    { shutting }                     trust_var := TRUST;                     END;     { shutting }                      DSINIT_UNINIT:                     BEGIN    { uninit }                     DeAllocateDSAM(-5);                     END;     { uninit }                      OTHERWISE                    BEGIN    { otherwise }                    trust_var := NOTRUST;                     END;     { otherwise }                 END;     { ds_stateword CASE }       !            { this routine tells the current segment not to trust  ! !               its tables, and then calls cleanup with trust_var } !             PreCleanup( trust_var );                  END;     { sick }       	         OTHERWISE 	             BEGIN    { state error }                  { IF we get here the internal state info is off }                   { state would be uninit or lame }   $            MsgFilePrint( CDSSTATEERR, PMT_ERROR, 0, internal_result );  $             { ignore errors }                   trust_var := NOTRUST;               Cleanup( trust_var, 0 );                  END;     { state error }           END;     { ds Case }         END;     { check ds state for shutdown }  
   END;     { HandleShut } 
     $ SUBTITLE 'PreCleanup', PAGE $   {------------------------------------------------------------}  {                                                            }  {              PreCleanup                                    }  {                                                            }  {------------------------------------------------------------}  
PROCEDURE PreCleanup 
    (     trust_var:     TrustType );      {}   {  Purpose: To clean up one protocol segment that has problems,     {  and then to call cleanup with the passed value of trust_var.    {   {  Input:   trust_var- passed along to Cleanup.   #{  Output:  trust_var- passed from caller to Cleanup thru PreCleanup.  # {   {    Know NSINIT was aborted under in one of two places:  {     1. Immediately prior to calling DS_InitProtoSeg's   {                  startup/shutdown routine.  {     2. During DS_InitProtoSeg's startup/shutdown routine.   {   {    Tell this segment he cannot trust his tables.  No matter   !{    what error condition is returned from this segment, continue  ! {    attempting to clean up the segments after this one.  {   {    Pass Cleanup the value to use for "trust_var" in cleaning  {    up the rest of the protocol segments.  {}      VAR      internal_result:     Int16;     seg:                 Int16;      
   BEGIN    { PreCleanup } 
        internal_result := GOOD;   !   FetchStateWords( PROTOSEGWORD, FALSE, seg , internal_result );  !    { FALSE indicates do not exit on error.  If get an error,       keep going, need to get this one segment cleaned up. }       "   { Clean up the current segment only if there is a current segment " &     to clean up.  Otherwise just get on to the table space deallocation. }  &     IF ( seg <= LAST_SEGMENT ) AND ( seg >= FIRST_SEGMENT ) THEN    !      BEGIN    { shut down the offending segment and all others }  !       ProtoShut( NOTRUST, seg, internal_result );         { ignore error returns }      $      ChangeStatewords( PROTOSEGWORD, TRUE, seg -1 , internal_result );  $ #      { FALSE indicates do not exit on error.  Still need to clean up  # $        this segment.                                                  } $           Cleanup( trust_var, 0 );  !      END      { shut down the offending segment and all others }  !      ELSE         BEGIN    { attempt other resource deallocation }        { NSINIT's state words indicate we still have things to            clean up, but we there are no segments' cleanup routines   #        to take care of.  So, just try basic resource deallocation. }  #     #      MsgFilePrint( CATTEMPTDEALLOC, PMT_ERROR, 0, internal_result );  #       { ignore errors from print routine }            DeallocateResources( 0 );         END;     { attempt other resource deallocation }  
   END;     { PreCleanup } 
     $ SUBTITLE 'ProtoShut', PAGE $  {------------------------------------------------------------}  {                                                            }  {               ProtoShut                                    }  {                                                            }  {------------------------------------------------------------}  
PROCEDURE ProtoShut  
   (      trust_var:     TrustType;           current_seg:   Int16;      VAR  passedresult:        Int16 );      {}  &{  Purpose: To call the protocol segment in current_seg's shutdown routine.  & ${           The routine also changes the DSAM state word from ADSINIT to $ "{           ADSINITIALIZING after it shuts down the monitors.  This  " #{           happens here to ensure that the state word change does not # {           occur before the monitors are stopped.  {   #{  Input:   trust_var-  passed on to protocol's shutdown, TRUST if the # %{                       protocol can trust its tables, NOTRUST otherwise.  % {           current_seg-The segment to be shut down.  {   {  Output:  result-     <>0 If error, 0 otherwise   {   {  Global variables accessed: none  {   {  Routines Called: Each protocol segment's shutdown routine,   {                   DS_SetDSAMState.  {   {}      VAR      internal_result:  Int16;      shut_segment:     Int16;      temp:             Int16;       
   BEGIN    { ProtoShut }  
        shut_segment := current_seg;          { Note no segment number validity check is done here. }         CASE shut_segment OF             NONE,         FIRST_SEGMENT -1:            BEGIN    { no segments started }       &         { do nothing, cleanup will take care of dsam and smb deallocation } &          END;     { no segments started }             seg_NOD:           BEGIN    { seg_Nod }                ShutNod( trust_var, internal_result );            END;     { seg_Nod }             seg_1K_SH:           BEGIN    { seg_1kS }                Shut1kS( trust_var, internal_result );            END;     { seg_NM }            seg_NM:            BEGIN    { seg_1kS }                ShutNM( trust_var, internal_result );           END;     { seg_NM }            seg_IPC:           BEGIN    { seg_IPC }                ShutdnIPC( trust_var, internal_result );            END;     { seg_IPC }             seg_TCP:           BEGIN    { seg_tcp }                ShutdnTCP( trust_var, internal_result );            END;     { seg_tcp }             seg_pxp:           BEGIN    { seg_pxp }                ShutdnPXP( trust_var, internal_result );            END;     { seg_pxp }             seg_ifp:           BEGIN    { seg_ifp }                ShutIFP( trust_var, internal_result );            END;     { seg_ifp }       	      seg_Mon_SH:  	          BEGIN    { SEG_MON_SH }            { Inpro and Outpro must be stopped before the state of    %           dsam is changed to ADSINITIALIZING.  Stop the monitors first. } %          ShutMon( trust_var, internal_result );                { Now change the dsam state word to "going down" }            temp := ADSINITIALIZING;            DS_SetDSAMState(  temp );           END;     { SEG_MON_SH }            seg_NRG:           BEGIN    { seg_NRG }                ShutNRG( trust_var, internal_result );            END;     { seg_NRG }             seg_PROB:            BEGIN    { seg_PROB }               ShutPROB( trust_var, internal_result );           END;     { seg_PROB }            seg_MU:            BEGIN    { seg_MU }               ShutMU( trust_var, internal_result );           END;     { seg_MU }            seg_TMR:           BEGIN    { seg_TMR }                ShutTMR( trust_var, internal_result );            END;     { seg_TMR }             seg_NSLNK:           BEGIN    { seg_NSLNK }                ShutNSLNK( trust_var, internal_result );            END;     { seg_NSLNK }             seg_NFT:           BEGIN    { seg_NFT }                ShutNFT( trust_var, internal_result );            END;     { seg_NFT }             seg_RTR:           BEGIN    { seg_rtr }                ShutRTR( trust_var, internal_result );            END;     { seg_rtr }             seg_NRV:           BEGIN    { seg_NRV }                ShutNRV( trust_var, internal_result );            END;     { seg_NRV }             seg_ip:            BEGIN    { seg_ip }               ShutIp( trust_var, internal_result );           END;     { seg_ip }            seg_3KLNK:           BEGIN    { seg_3k }           Shut3k2( trust_var, internal_result );            END;     { seg_3k }            seg_3K_SH:           BEGIN    { seg_3k }           Shut3k1( trust_var, internal_result );            END;     { seg_3k }            { These segments are not used for shutdown }        SEG_1K_IN:     internal_result := GOOD;         SEG_MON_IN:    internal_result := GOOD;             OTHERWISE            BEGIN    { otherwise }            { got bogus segment number }            MsgFilePrint( CINTERR_SEG, PMT_ERROR, shut_segment,                                                 internal_result );            { ignore errors on print }       #         { Continue attempting cleanup, even though bad segment number # $           Do tell caller about the error that occurred.               } $          internal_result := ERR_ALREADY_PRINTED;           END;     { otherwise }             END;     { CASE }          passedresult := internal_result;       
   END;     { ProtoShut }  
     $ SUBTITLE 'StartUpSegments', PAGE $  {------------------------------------------------------------}  {                                                            }  {                  StartUpSegments                           }  {                                                            }  {------------------------------------------------------------}      
PROCEDURE StartUpSegments  
 (    netmanseccode:     Int16;       userseccode:       Int16;   VAR main_halt:         Int16 );  {}  {  purpose: To call each protocol segment's startup routine.  {   {  Input:   netmanseccode- network  security code   {                          entered by the user  {           useseccode-    user security code entered by user   {   {  Output:  main_halt-     value main program should use when   {                          it calls pascal HALT to terminate.   {   %{  Global Variables accessed: segment word in DSAM is updated immediately  % {  prior to a protocol segment's startup routine being called.  {   {  Routines Called:  Each protocol segment's startup routine  {     Cleanup if an error is detected.  {   !{  Side Effects: If an error is returned from a protocol segment,  ! !{  Cleanup is called,and the program will clean up and terminate.  ! !{  Only if no errors occur will control be returned to the caller. ! {   "{ Note for later release: could check the break flag after each seg. " {   {}      VAR      local_segment:    Int16;      internal_result:  Int16;       $ SUBTITLE 'InitializeResValues', PAGE $  PROCEDURE InitializeResValues;      $ PAGE $     BEGIN    { InitializeResValues }      { This procedure initializes some res values.  It performs          the function that DINIT used to do by moving a local copy          of part of the Res tables into RES at initialization.  }         DS_MoveCharsToRes( NSINIT_AdrOf( Lb_TBRN ), 0,                         RESINITCONST.PRC, RESINITCONSTLEN );      $   { also initialize #cnod for exexw and apldr's download node number }  $    DS_StoreResElement( NSINIT_AdrOf( Lb_CNOD ), 0, -1 );     DS_StoreResElement( NSINIT_AdrOf( Lb_CNOD ), 1, -1 );         { initialize #NODE to indicate that 91750 is not yet up }     DS_StoreResElement( NSINIT_AdrOf( Lb_NODE ), 0, -1 );         { clear number of nodes in the NRV }      DS_StoreResElement( NSINIT_AdrOf( Lb_NCNT ), 0, 0 );          { clear LUMAP's class number }      DS_StoreResElement( NSINIT_AdrOf( Lb_LUMP ), 0, 0 );          { clear #PLOG and #PLOG+1 }     DS_StoreResElement( NSINIT_AdrOf( Lb_PLOG ), 0, 0 );      DS_StoreResElement( NSINIT_AdrOf( Lb_PLOG ), 1, 0 );          { save the security codes }  "   DS_StoreResElement( NSINIT_AdrOf( Lb_NMSC ), 0, netmanseccode );  " !   DS_StoreResElement( NSINIT_AdrOf( Lb_SWRD ), 0, userseccode );  !        END;     { InitializeResValues }           $ SUBTITLE 'InitASeg', PAGE $   	PROCEDURE InitASeg 	 (     local_segment:    Int16;    VAR internal_result:  Int16 );         BEGIN    { InitASeg }         CASE local_segment OF        seg_3KLNK:           BEGIN               Init3k2( internal_result );           END;         seg_NM:            BEGIN               InitNM( internal_result );            END;         seg_1K_IN:           BEGIN               Init1kS( internal_result );           END;         seg_NOD:           BEGIN               InitNod( internal_result );           END;         seg_IPC:           BEGIN               InitIPC( internal_result );           END;         seg_TCP:           BEGIN               InitTCP( internal_result );           END;         seg_PXP:           BEGIN               InitPXP( internal_result );           END;         seg_RTR:           BEGIN               InitRTR( internal_result );           END;         seg_NRV:           BEGIN               InitNRV( internal_result );           END;         seg_IFP:           BEGIN               InitIFP( internal_result );           END;   	      seg_MON_IN:  	          BEGIN               InitMON( internal_result );           END;         seg_IP:            BEGIN               InitIP( internal_result );            END;         seg_NFT:           BEGIN               InitNFT( internal_result );           END;         seg_PROB:            BEGIN               InitPROB( internal_result );            END;         seg_NRG:           BEGIN               InitNRG( internal_result );           END;         seg_MU:            BEGIN               InitMU( internal_result );            END;         seg_TMR:           BEGIN               InitTMR( internal_result );           END;         seg_NSLNK:           BEGIN               InitNSLNK( internal_result );           END;             { these segments are only valid for shutdown }        SEG_1K_SH:     ;        SEG_3K_SH:     ;        SEG_MON_SH:    ;            OTHERWISE            BEGIN    { error somewhere }            { invalid protocol segment number! }            MsgFilePrint( CINTERR_SEG, PMT_ERROR, local_segment,                  internal_result );            Cleanup( TRUST, -7 );           END;     { error somewhere }         END;       { case local_segment startup }          END;     { InitASeg }      $ SUBTITLE 'StartupSegments', PAGE $     BEGIN          { StartupSegments }          internal_result := 0;  	   message := '';  	        InitializeResValues;          { get the init rn, save in dsam and res }     AccessInitRN( GETRN, internal_result );     CheckResult( internal_result );     IF internal_result <> GOOD THEN BailOut;          { change state to be starting }     ChangeStatewords( INITSTATEWORD, TRUE, DSINIT_START,                                           internal_result );     { TRUE indicates Exit on error }          FOR local_segment := FIRST_SEGMENT TO LASTGEN_SEG DO         BEGIN    { FOR }            { update the segment in dsam to be local_segment }        ChangeStateWords( PROTOSEGWORD, TRUE, local_segment,  $                                                     internal_result );  $       { TRUE indicates Exit on error }            InitASeg( local_segment, internal_result );         IF internal_result <> GOOD THEN            BEGIN       { error on startup }            CheckSegPrint( internal_result, local_segment );       $         { Don't worry if we couldn't print, we're cleaning up anyway. } $          Cleanup( TRUST, -8 );           END;        { error on startup }             END;     { FOR }         MarkDsamUp( internal_result );      IF internal_result <> GOOD THEN        BEGIN    { Error changing states }      #      { Got an error unlocking the rn.  Tell user we're cleaning up. } # !      MsgFilePrint( CUNDOSTARTUP, PMT_ERROR, 0, internal_result ); !       { ignore print errors }             Cleanup( TRUST, -11 );        { Cleanup exits, control is not returned here }         END;     { Error Changing states }         FOR local_segment := FIRSTLINK_SEG TO LASTLINK_SEG DO        BEGIN    { link FOR }             {}        { Link initialization routines should return error  $      { conditions ONLY on severe errors.  Having the wrong driver type  $ $      { is the only error condition that causes initialization to abort. $        { All other errors should not be bubbled back to the main.         {         { NSINIT will never abort on link initialization errors,  $      { but it will report a non-zero termination value for these error  $ 
      { conditions.  
       {}            InitASeg( local_segment, internal_result );         IF internal_result <> GOOD THEN            BEGIN       { error on startup }   
         main_halt := 10;  
              IF internal_result = CHKDRIVER_BADTYPE THEN              BEGIN    { we're bailing out }              MsgFilePrint( CHKDRIVER_BADTYPE, PMT_ERROR,                                               0, internal_result );               { ignore errors from print routine }                  Cleanup( TRUST, main_halt );              END;     { we're bailing out }               { Print error if necessary, but startup continues }           CheckSegPrint( internal_result, local_segment );   
         { ignore errors } 
              END;        { error on startup }             END;     { link FOR }       "   { change state of DS to INIT, protocol segment state word to 0 }  " %   ChangeStateWords( INITSTATEWORD, TRUE, DSINIT_INIT, internal_result );  %    { TRUE indicates Exit on error }          initglobals.IG_save_in_out := FALSE;          IF main_halt = 0 THEN        BEGIN    { tell user a ok }       "      message := '** NS started successfully.  NSINIT Completed.**'; "       PrintError( message, internal_result );         END      { tell user a ok }        ELSE         BEGIN    { tell user have problem on startup }      !      MsgFilePrint( CLINKINITERR, PMT_ERROR, 0, internal_result ); !            { hand the halt value back to the main for pascal halt. }          END;     { tell user have problem on startup }         CheckResult( internal_result );     IF internal_result <> GOOD THEN BailOut;          END;           { StartupSegments }       END        { module InitClean }   .  