 $PASCAL '91790-1X092 REV.4010 <851125.2010> '   $STANDARD_LEVEL 'HP1000'  $debug$   $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 0   	$HEAP_DISPOSE OFF  	     MODULE IPCinit;   	$ALIAS 'N$IPCinit' 	     {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  {     NAME:   IPCINIT   
{     SOURCE: 91790-18092  
 	{     RELOC:  NONE 	 	{     PGMR:   EMS  	 {}      {}  {   {  This module contains the real routines for IPC's part  {  of NSINIT, the NS/1000 initialization program.   {   {}      IMPORT      $SEARCH 'phtm/bodec.rel'     bodec,   $SEARCH 'phtm/SODEC.rel'     sodec,   $SEARCH 'phtm/mmdec.rel'     mmdec,   $SEARCH 'phtm/mmext.rel'     ds_mm,   
$SEARCH 'phtm/TRCMOD.rel'  
    trcmod,  
$SEARCH 'phtm/sigmod.rel'  
    sigmod,  $SEARCH 'phtm/init_dec.rel'      init_dec,  $SEARCH 'phtm/initmulti.xpt'     initmulti,   
$SEARCH 'phtm/parsdd.xpt'  
    parser,  
$SEARCH 'phtm/filemad.xpt' 
    fileman;           $SUBTITLE ' Export procedures ', PAGE$      EXPORT      {--------------------------------------------------------}  {                                                        }  {          EXPORT   PROCEDURES                           }  {                                                        }  {--------------------------------------------------------}          	PROCEDURE SynckIPC 	    (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR resourcnt   : Int16;      VAR result      : Int16);           
PROCEDURE ShutdnIPC  
    (    trustvar    : TrustType;      VAR result      : Int16);           	PROCEDURE InitIPC  	    (VAR result : Int16);      {----------------------------------------------------}  {               Implement Section                    }  {----------------------------------------------------}      IMPLEMENT       VAR      namerecordcount:     Int16;      
$SUBTITLE 'SynckIPC',PAGE$ 
  {-------------------------------------------------------------}     {                                                             }    !{                       SynckIPC                                }  !  {                                                             }     {-------------------------------------------------------------}        	PROCEDURE SynckIPC 	    (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR resourcnt   : Int16;      VAR result      : Int16);           {}  !{ Description: Get user input to IPC configuration items; perform  !  {   validity check on the inputs; returns DSAM Table size to the   {   caller.   {   { Parameters:   {   dsamtbsize (output)   {   socketcnt  (output)   {   classcnt   (output)   {   resourcnt  (output)   {   smbsize    (output)   {   result     (output)    Set to zero if successfull.  {}      LABEL      99;      CONST      CQUESTMID = ')..';      CQUESTFIN = ']:_';      CNAMERECQ1 =   $  '* Enter the maximum number of name records (the default is derived '; $    CNAMERECQ2 =     '* from previous responses) [1..(';       VAR      answer:              OneCharType;     default:             Boolean;     dummy:               Int16;     defnamereccnt:       Int16;     maxnamereccnt:       Int16;     internal_result:     Int16;     message:             PromptType;      terminator:          Boolean;      	PROCEDURE ExitSyn; 	    BEGIN    { ExitSyn }          { used so there is only one GOTO in this procedure }      GOTO 99;          END;     { ExitSyn }           
   BEGIN {SynckIPC}  
        { Assume all variables cleared by DSINIT }          internal_result := GOOD;      namerecordcount := 0;      #   { Set up the default values and maximum values for the question. }  # #   { These values are guestimates and may have to be tweeked.       }  #    defnamereccnt := initglobals.IG_tot_nodal_sockets DIV 2;      maxnamereccnt := initglobals.IG_tot_nodal_sockets * 3;          IF defnamereccnt < 1 THEN           defnamereccnt := 1;     IF defnamereccnt > maxnamereccnt THEN           maxnamereccnt := defnamereccnt;         { get the number of name records }      PrintPrompt( FALSE, CNAMERECQ1, internal_result );      IF internal_result <> GOOD THEN ExitSyn;       	   message := '';  	 
   default := TRUE;  
    terminator := FALSE;      Strwrite( message, 1, dummy, CNAMERECQ2, defnamereccnt:1,  #                              CQUESTMID, maxnamereccnt:1, CQUESTFIN ); #    IntInput( message, default, terminator, maxnamereccnt, 1,           namerecordcount, internal_result );     IF internal_result <> GOOD THEN ExitSyn;          IF default THEN namerecordcount := defnamereccnt;         { add the number of buckets to the name record count }   !   namerecordcount := namerecordcount + LAST_NAME_BINDING_BUCKET + !                                   LAST_GIVE_BUCKET;          { Tell caller dsam required.  Need name records       (including buckets) + the pointers to the hash buckets.}      dsamtbsize := ( namerecordcount * NAMEREC_SIZE ) +                    LAST_NAME_BINDING_BUCKET + LAST_GIVE_BUCKET ;      99:      result := internal_result;   
   END;  {SynckIPC}  
         $SUBTITLE 'IPC Shutdown module', PAGE$  {-------------------------------------------}   {              ShutdnIPC                    }   {-------------------------------------------}       
PROCEDURE ShutdnIPC  
    (    trustvar    : TrustType;      VAR result      : Int16 );      {}  { Description: Module to be called by the AdvDS/1000 Shutdown   {    program; IPC does not require any system resources on its  {    own; so its shutdown procedure do nothing.   {   { Parameters:   {    trustvar   (input)  Indicates potential corruption of  {                        data structures. For IPC there no  {                        recovery and hence does not have   {                        to worry.  {   {    result     (output) Always returns successful.   {   {}         BEGIN { ShutdnIPC }     { Always return successfully }      result := 0;      END;  { ShutdnIPC }          
$SUBTITLE 'InitIPC', PAGE$ 
 {------------------------------------------------------------}  {                                                            }  {                  InitIPC                                   }  {                                                            }  {------------------------------------------------------------}      	PROCEDURE InitIPC  	    (VAR result:       Int16);       LABEL      99;      VAR   
   i              : Int16; 
 
   ierr           : Int16; 
    namerec        : NameRecord;   
   temp           : Int16; 
 
   wkmap          : Int16; 
     $SUBTITLE 'ExitInit' , PAGE $      PROCEDURE ExitInit;     BEGIN    { ExitInit }      	   result := ierr; 	    GOTO 99;          END;     { ExitInit }      
   BEGIN { InitIPC } 
         !   {-------------------------------------------------------------} ! !   {   NAME RECORDS                                              } ! !   {-------------------------------------------------------------} ! !   { Initialize the buckets of both the name binding table and the !    { give table.     {}      DS_InitEntercritical ( wkmap, ierr );     IF ierr <> SUCCESSFUL THEN ExitInit;          { First get the pointers to the hash buckets }   $   DS_GetTableSpace ( DS_NameBsTD, 1, LAST_NAME_BINDING_BUCKET, 1,ierr); $    IF ierr <> SUCCESSFUL THEN         BEGIN    { error }        DS_InitLeaveCritical( wkmap );        ExitInit;         END;     { error }          DS_GetTableSpace ( DS_GiveBsTD, 1, LAST_GIVE_BUCKET, 1,ierr);      IF ierr <> SUCCESSFUL THEN         BEGIN    { error }        DS_InitLeaveCritical( wkmap );        ExitInit;         END;     { error }         { Now get the name records (including the buckets) }   %   DS_GetTableSpace ( DS_Namestd, 1, namerecordcount, NAMEREC_SIZE, ierr); %    IF ierr <> SUCCESSFUL THEN         BEGIN    { error }        DS_InitLeaveCritical( wkmap );        ExitInit;         END;     { error }             FOR i := 1 TO LAST_NAME_BINDING_BUCKET DO        BEGIN         temp := i;        DS_StoreElement ( DS_NameBsTD, i, temp );   	      END; {FOR i} 	        FOR i := 1 TO LAST_GIVE_BUCKET DO        BEGIN         temp := i + LAST_NAME_BINDING_BUCKET;         DS_StoreElement ( DS_GiveBsTD, i, temp );   	      END; {FOR i} 	        temp := LAST_NAME_BINDING_BUCKET + LAST_GIVE_BUCKET + 1;      DS_StoreElement ( DS_Tracktd, TL_NAME_FREEPTR, temp );              {}   $   { Initialize the name records that will be used as header records in  $    { the name binding and give tables.     {}   !   FOR i := 1 TO (LAST_NAME_BINDING_BUCKET + LAST_GIVE_BUCKET) DO  !       BEGIN         WITH namerec DO            BEGIN           nr_name.chars := '}}}}}}}}';             nr_nlen := 0;  {no entry except header record will have                            length of zero}           nr_socketd := NULL;           nr_hash_fptr := i;            nr_hash_bptr := i;            nr_namesptr := NULL;   
         END; {WITH} 
       DS_StoreElement ( DS_Namestd, i, namerec.int );   	      END; {FOR i} 	        {}      { Initialize the name records that will comprise the name     { record free pool.     {}          DS_FetchElement ( DS_Tracktd, TL_NAME_FREEPTR, temp );      FOR i := temp TO namerecordcount DO        BEGIN         WITH namerec DO            BEGIN           nr_name.chars := 'BLANK   ';            nr_nlen := 8;           nr_socketd := NULL;           nr_hash_fptr := i + 1;            nr_hash_bptr := 0;   
         nr_namesptr := 0; 
 
         END; {WITH} 
       DS_StoreElement ( DS_Namestd, i, namerec.int );   	      END; {FOR i} 	        namerec.nr_hash_fptr := NULL;      DS_StoreElement ( DS_Namestd, namerecordcount, namerec.int );      DS_InitLeaveCritical ( wkmap );      99:       
   END; { InitIPC }  
     END   .  