 $PASCAL '91790-1X095 REV.4010 <860402.1545>'  
$TITLE 'IP Declarations'$  
 $HEAP 0 $   $HEAPPARMS OFF$   $RECURSIVE OFF$   
$STANDARD_LEVEL 'HP1000'$  
 $DEBUG$   $CODE_INFO ON$  	$CODE_OFFSETS ON$  	 $RANGE OFF$       MODULE ipdec;   $ALIAS 'N$IPDEC'      {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT PACKARD COMPANY.       ------------------------------------------------------------}      {}  	{      NAME: IPDEC 	 {    SOURCE: 91790-18095  	{     RELOC: NONE  	 {      PGMR: CWJ  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   !{  2/11/85  cwj   Added Send Request & Data Indication statistics  ! {  2/14/85     cwj   Change import searches to @.rels   {  2/18/85     cwj   Add Reassembly statistics to RCB   {  2/26/85     cwj   Remove PosInt1 declaration   {  3/18/85     cwj   Added RcbStatistics record access fields   !{  3/21/85     cwj   Use IP error base for all IP status messages  ! {                    Add error codes for TRIGGER drops of msgs  {  3/26/85     cwj   Recycle some Error codes   {  4/26/85     cwj   Misc cleanups  {  5/1/85      cwj   Add Reassembly routine constants   {                    Remove references to HOLE Descriptors  {                    Change FRAG Descriptor   {                    Change RCB structure   !{  5/2/85      cwj   Change RCB statistics to match new algorithm  ! {  5/16/85     cwj   Remove commented out sections  {                    Add/Change ICMP declarations   !{                    Add Send ULP Source Quench path record state  ! {  5/20/85     cwj   ICMP Coding changes  {  5/22/85     cwj   Add ICMP calls   {                    remove ipg_reass_time  {                    add    ipg_debug   "{                    (depend: IPINF needs to change to reflect this) " {  6/3/85      cwj   Add ipg_reass_time back in to remove the   {                       IPINF & IPINIT dependancies this post   !{  6/28/85     cwj   Move the 'Subr' constants from IPIB to IPDEC  ! &{                    Change the ANH state priority of (ahst_FLOW_CONTROLLED) & {                    Clean up comments where necessary.   {                    Move some error constants from IPPATH  ${  7/3/85      cwj   Add Initialization constant for S&F reserved paths  $ {  7/29/85     cwj   Correct Statistics keeping   {  7/31/85     cwj   Bug fix: IP Global table declarations  !{  8/2/85      cwj   Add ah_netpid field to ANH rec for PROBE work ! {  8/3/85      cwj   Add SUBR code  {                    Import XPTs  {                    Remove gv_elog_msg as unused   {                    Add gv_gocrit_error  {  8/14/85     cwj   Add ips_DCNPATHSW error code   !{  8/16/85     cwj   Enable triggers & Errors to evmon as default  ! {  8/20/85     cwj   Added ProSw error return logging   ${  8/29/85     cwj   Remove ast_REASS_TMR, add ast_CANT_SEND_DATA states $ {                    Added SubrANGPRSTATES subroutine error ID  {                    Added ips_ABORT_DPATH  !{                    Merge cst_KILL_PATH and ast_CLEANUP_PATH into ! {                       ast_KILL_PATH   {  ----- posted -----   {  9/3/85      cwj   Connectionless path type changes   {  9/4/85      cwj   Moved LruLinkageType from IPLIB  {  9/11/85     cwj   Remove gv_in_emscnt  {                    Remove gv_out_emscnt   {  9/13/85     cwj   Set Idle Path timeout to 5 minutes   {  ----- N145 Submittal -----   {  9/19/85     cwj   Added SubrREASSACKTHRESH   {                    Added ips_TRIGGER_POPPED   {  ----- N152 Submittal -----   {  10/31/85    cwj   RCB list maintainance fixes  {  11/1/85     cwj   Set DEBUG flags ON by default  {  ----- N185 Submittal -----   {  11/5/85     cwj   Add Part Number  {  11/6/85     cwj   Add Module Alias   {  ----- N223 Submittal -----   {  12/2/85     cwj   Changed Emsg Counts from Int16 to Int32  {  ----- N214 Submittal -----   {  12/30/85    cwj   Add Error codes for rest of ICMP messages  {                    Remove Unused constants  {  1/3/86      cwj   Add Location code for KillRoute  {  ----- N262 Submittal -----   {  1/14/86     cwj   Move LLP emsg counts into ANH record   {  ----- N302 Submittal -----   &{  1/28/86     cwj   FindLruPath Bug Fix (priority goes to in process msgs)  & {  ----- N323 Submittal -----   {  ----- N352 Submittal -----   {  3/11/86     cwj   RANGE OFF not supplied bug fix   {                       SR# 033787  {  ----- N395 Submittal -----   ${  4/1/86      cwj   Change the Outbound message queue from LIFO to FIFO $ {                       SR# 035451  !{  4/2/86      cwj   Add Global block debug flag for S&F Borrowing ! ${              cwj   Add information differentiating between 3103 (path  $ !{                       not found) and 3105 (path not available).  ! {                       SR# 035444   {              cwj   ICMP message information logged incorrectly   {                       SR# 033035  ${              cwj   Turn Off protocol specific logging as the default.  $ {  ----- Nxxx Submittal -----   {}  {  End of Modifications Section   {------------------------------------------------------------   {}      {}  { MODULE DESCRIPTION:   {   {  This module contains the declarations of data structures   {  and constants used by IP procedures.   {}      $TITLE 'IMPORT Section',PAGE$       IMPORT        $SEARCH 'phtm/bodec.xpt'$      bodec,         $SEARCH 'phtm/sodec.xpt'$      sodec,         $SEARCH 'phtm/mmdec.xpt'$      mmdec,         $SEARCH 'phtm/mmext.xpt'$      ds_mm,         $SEARCH 'phtm/tmrdec.xpt'$     tmrdec;      EXPORT      $TITLE 'General Purpose Constants',PAGE$  {------------------------------------------------------------}  {              General Purpose Constants                     }  {------------------------------------------------------------}      {}  {  Description  {     These declarations are for general use in many of the   {     IP routines and data structures.  {   {}      CONST   #   NO_ANH_NODE = 0;           { Appropriate Next Hop Address Unknown } # %   NO_INDEX    = 0;           { No index pointer in this field currently } %    NO_HOPS     = 0;           { Hop Count is 0 }  &   NO_NGT      = 0;           { No NGT Index. This implies that IP's      }  & &                              {    routing tables have no record of the   }  & &                              {    given destination network.             }  & &   NO_PATH     = 0;           { Index used to indicate no appropriate Path } &    NO_PID      = 0;           { No PID in this field }  &   NO_ROUTE    = 0;           { There is no ANH record Index for the path }  &    NO_MSGS     = 0;           { Message count of 0 }  #   NO_FLAGS    = 0;           { Event message flags word null value }  #    NO_MBUFID   = 0;           { No mbufid present }   "   NO_LOCAL    = 0;           { No Local IP Address in this path  }  " "   NO_PROTO    = 0;           { No IP Protocol number in this path } "     NO_SEGMENTS = 0;           { No Segmentation is to be done }           { List Linkage Constants      {}      END_OF_LIST = 0;           { End of List Link value }     REC_INUSE = -2;            { Not on Free List Link value }          { Record Offset constants     {}   $   FREE_LIST_LINK_OFSET = 0;  { Offset to List Linkage for most lists }  $ $   NO_OFSET             = 0;  { Offset to first word of an array      }  $ $   FIRST_ENTRY          = 1;  { Index of First element in MMGR table  }  $ #   LAST_ENTRY           = MAXINT16;  { Last table Index for searches } # $   ONE_WORD             = 1;  { Length constant for array access      }  $         #   IP_ADR_WORD_LEN = 2;       { Length of IP address in 16-bit words } #        {}      { Global Variable Record Status values      {}   $   INVALID_DATA = -1;         { Data in global variable does NOT match } $ $                              { the data in DSAM.                      } $     $   VALID_DATA   =  0;         { Data in global variable is the same as } $ $                              { the data in DSAM.                      } $     $   UPDATED_DATA =  1;         { Data in global variable has been       } $ $                              { updated and must be posted to DSAM     } $ $                              { before leaving critical.               } $        {}   
   { Timer Constants 
    {}   &   IP_CL_TIMER     = TIMERABLE_1;   { Connectionless Path Timer Identifier } & &   IP_REASS_TIMER  = TIMERABLE_2;   { Message Reassembly Timer Identifier }  & %   IP_TIMER_OFF    = -1;      { Timerid.index flag indicating timer off  } % %   IP_TMRES        = 100;     { Time reset * IP_TMRES = # centiseconds   } % %                              { for Connectionless and Reass Timer reset } % %                              { values                                   } %        {}      {  Default Segmentation sizes  $   {     These sizes will be used in setting the defaults when it is not $     {     possible to obtain this information in the normal way.    '   {     (e.g. when an offered route changes the dnpid and a new segmentation  '    {     size is required.)      {}   $   MAX802PKT   =  1490;       { Bytes of LAN data, excludes LAN header } $ $   MAXRTRPKT   =  0;          { No segmentation over router links      } $ $   MAXGWYPKT   =  1500;       { Bytes of data over GWY line            } $ $   MAXSMLPKT   =  MAX802PKT;  { Smallest sized segments                } $     $TITLE 'Appropriate Next Hop Record',PAGE$  {------------------------------------------------------------}  {              Appropriate Next Hop Record                   }  {------------------------------------------------------------}      {}  {  DSAM Table Descriptor:  DS_IP_Anh_Rec_TD   {  DSAM Word Length:       ah_MAX_WORDS   {   { Description    {     The ANH record contains the information required to route    {     IP messages to the next gateway or host machine.  {   {     The ANH record is used for several purposes:  {   "{        1) To bind a given ANH to the Route, the down Pid/Down Path " {           pair used by the LLP to deliver IP's message.   {    {        2) To maintain other route specific information for IP.   {   {   { Record Format   {   {      5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0  {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |     Free List Link            |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |     Appropriate Next          |   {     +-+-+                       +-+-+   {     |        Hop IP Address         |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |     Path Record List Link     |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |     States word               |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |     Down PID                  |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |     Down Path                 |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |     Network PID               |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |     Segmentation Size         |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {        Housekeeping Fields  {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |     Index of ANH Record       |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |     Record Status             |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {}  { Fields  {   {  ah_free_link   "{     The Free ANH records are linked together in DSAM via this word " {     to facilitate allocation of new records.  {   {  ah_anh   {     This word contains the IP address of the Appropriate  {     Next Hop.   {     If the destination is not connected to a DCN, this is   {     the IP Address of the gateway for the internet hop.   {     If the destination is connected to a DCN, then this is  {     the IP Address of the destination node.   {     If this field is 0, the IP address of the Appropriate   
{     Next Hop is unknown. 
 {   {  ah_pr_link   {     This is the list head for the list of all path records  {     that are currently using this route. This is the index  {     This list is linked through the pr_anh_link field of the  	{     path record. 	  {     When this field is 0, there are no path records using this   {     record and the record must be killed.   {   {     This field may take on the following values:  {   
{        0 =>  End of List 
 {       >0 =>  Index of Path record   {   {  ah_states  #{     The set of state(s) that this route is in. If this set is empty, # #{     the route is sendable, otherwise the various elements in the set # {     indicate why it is not sendable.  {   ${     This field is set to the ah_NO_DOWN_PATH state at initialization.  $ {   {     The states defined are:   {   {     ahst_ROUTE_PENDING  - A REQUEST_DPATH has been sent but   {                           the reply has not yet returned.   {   {     ahst_FLOW_CONTROLED - IP has received an indication   {                           requiring temporary suspension of   {                           sends on this path.   &{                           (This state will not be used at first release )  & {   {     ahst_NO_DOWN_PATH   - There is no down path set up yet.   {   {  ah_dnpid   {        NOTE: Whenever this field is set, SegSizeCheck should  {              also be called.  {   {     The Link Interface PID to use in sending messages to  !{     the ANH. This will be obtained from an NGT entry containing  ! #{     the gateway, or, if the destination network is unknown, it will  # %{     be set to the route offered in the first inbound message referencing % 	{     this route.  	 {     This is the PID that WILL be used.  {   {  ah_dnpath  {     The path reference to use along with the down PID when  {     sending messages out to the ANH. If this field is 0, no   {     path is currently assigned.    {     Typically this will be set when a CONFIRM_DPATH message is   !{     received in response to a REQUEST_DPATH. If the destination  ! !{     network is unknown however (i.e. not in the NGT), then this  ! !{     will be set to the offered path on the first inbound message ! {     referencing this route.   {     This is that Path ref that WILL be used.  {   {  ah_segsize    {     The maximum number of bytes that may be sent out over the    {     network indicated by the down PID/Path pair.  #{     This number is a multiple of 8 since IP must generate fragments  # "{     that are multiples of 8 bytes long for all but the last piece. " {   {  ah_up_emscnt   {     The count of all inbound event messages.  {     This count is placed into any KILL_REQUEST sent   {     to the LLP on this path and then is set to 0.   "{     The LLP uses this information to know when all event messages  " "{     from IP referencing the LLP's path record have been processed. " {   {  ah_dn_emscnt   {     The count of all outbound event messages on this path.  {     This count is placed into any KILL_REQUEST sent to the  {     LLP on this path and is then set to 0.  "{     The LLP uses this information to know when all event messages  " "{     from IP referencing the LLP's path record have been processed. " {   {  ah_netpid  "{     The LLP PID that is to be used for all REQUEST_DPATHs. This is "  {     the authoritative PID to be used for traffic on this path.   "{     It is possible, for temporary periods, that other routes will  " "{     be used (e.g. if a path report contains contrary information)  " {     but IP will always attempt to set up a route using the  {     routing information contained in the NGT.   {     This is the PID that SHOULD be used.  {   {  ah_netsegsize  #{     The segmentation size entered at initialization for the netpid.  # #{     This is the segment size that will be used for messages over the # 
{     ah_netpid LLP. 
 {   {  Housekeeping Fields  {   {  ah_index   {     The index of this ANH record in DSAM. This is used to   {     restore the entry.  !{     The index of this record is also stored in the path records  ! {     that reference this record.   {   {  ah_rec_status  {     A field which indicates the current status of this  {     copy of a DSAM record. It may have one of the   {     following values:   {   {        INVALID_DATA   {           The variable contains invalid data as compared  {           to DSAM. Such variables may be used as temporary  
{           storage. 
 {   
{        VALID_DATA  
 {           The variable contains data that is the same as  
{           that in DSAM.  
 !{           This will be true as long as the process is critical.  ! {   {        UPDATED_DATA   {           The variable contains valid data which has been   {           updated and so these updates must be posted to  {           DSAM before the process leaves critical.  {}     CONST            {}        { LENGTH OF ANH RECORD        { Length of each entry in DSAM without the housekeeping         { fields in 16-bit words.         {}        ah_MAX_WORDS = 14;            { Word offset of the ah_pid element }         ah_PID_OFSET = 5;              TYPE         {}        { States word declarations        {}        AhAllStatesType  =           (              ahst_FLOW_CONTROLLED,               ahst_NO_DOWN_PATH   ,               ahst_ROUTE_PENDING                                   );             AhStateSetType = SET OF AhAllStatesType;            {}        { ANH Record Declaration        {}  
      AnhRecType = RECORD  
          CASE Int16 OF                 0: (ah_bufr : BufferType);                  1: (ah_free_link  : Int16;                  ah_anh        : Int32;                  ah_pr_link    : Int16;                  ah_states     : AhStateSetType;                 ah_dnpid      : Int16;    { see ah_PID_OFSET }   !               ah_dnpath     : Int16;      { and see note above }  !                ah_segsize    : Int16;                  ah_up_emscnt  : Int32;                  ah_dn_emscnt  : Int32;                  ah_netpid     : Int16;                  ah_netsegsize : Int16;                      ah_index      : Int16;                  ah_rec_status : Int16 );                   END;  { AnhRecType }            {}        { ANH Search Key Declaration        {   "      {     This type is used to find the appropriate ANH record in  " !      {     DSAM. The search is based on finding a record that is  ! !      {     currently being used (free link <> 0) and that has the !       {     appropriate next hop address desired.         {}        AhSrchKyType  = RECORD           CASE Int16 OF                  0: (ahsk_bufr : BufferType);                  1: (ahsk_free_link : Int16;                   ahsk_anh_adr   : Int32 );                      END;  { AhSrchKyType }          CONST        {}        { INITIAL ANH record values         {}            { States word Initial value. }        ah_INIT_STATES = AhStateSetType [ahst_NO_DOWN_PATH];            { ANH Record Initial value }        ah_INIT_ANH_REC = AnhRecType           [               ah_free_link  : REC_INUSE,        { Record in Use }    &            ah_anh        : NO_ANH_NODE,      { ANH IP Address is Unknown }  & #            ah_pr_link    : END_OF_LIST,      { No Paths linked yet }  # %            ah_states     : ah_INIT_STATES,   { States word set as above } % !            ah_dnpid      : NO_PID,           { No Down PID yet }  ! !            ah_dnpath     : NO_PATH,          { No Down Path yet } ! &            ah_segsize    : NO_SEGMENTS,      { No Segmentation this route } & "            ah_up_emscnt  : 0,                { No Emsg counts yet } " "            ah_dn_emscnt  : 0,                { No Emsg counts yet } " !            ah_netpid     : NO_PID,           { No Down PID yet }  ! $            ah_netsegsize : MAXSMLPKT,        { Smallest Segment size }  $ $            ah_index      : NO_INDEX,         { DSAM Index is unknown }  $ &            ah_rec_status : UPDATED_DATA      { This record must be posted } &          ];       $TITLE 'Event Logging',PAGE$  {-----------------------------------------------------------}   {                 Event Logging                             }   {-----------------------------------------------------------}       {}  { Description   {     These declarations are for logging IP events.   {     IP logs these types of events:  {        1) Severe Internal Errors  "{           Any severe internal error that indicates such things as: " {              internal tables are corrupt  {              a condition that is never supposed to occur  {   {        2) KILL_INDICATIONS  !{           Any time IP causes a KILL_INDICATION to be generated,  ! {           the event messgae will be logged.   {   {        3) any error   {           IP will log any error that it encounters and will   {           then do the normal recovery for such an error.  {   {        4) Status at particular points. At some points, IP    {           will generate a protocol specific log with a buffer     {           with some status indication in it. The first word of    {           such logs will contain a tag indicating what kind of   %{           information follows in the buffer. See the IPL_... constants.  % {}  CONST   #   IP_LOG_LEN  = -(2*EMSG_WORD_LEN);  { Byte len of Send_Event Logs }  #     TYPE     { The Type for the global error message logging variable.  $   { This variable will be used to build the error message to be logged. $    { It is a global variable to conserve space.      {}      ElmAryType = PACKED ARRAY [1..EMSG_BYTE_LEN] OF CHAR;         ElogMsgType  = RECORD  
      CASE Int16 OF  
          0:    (elm_em    : EventMsgType);           1:    (elm_char  : ElmAryType);            2:    (elm_words : ARRAY [1..EMSG_WORD_LEN] OF Int16);             END;  { ElogMsgType }      CONST   "   { IP Specific status logging - The tags for the various kinds of  "    { IP status logging are given here.     {}   %   IPL_RCBDONE = 1;  { Reassembly status logged when message is complete } %    IPL_RCBTO   = 2;  { Reass status logged at RCB time out }  "   IPL_HEADLOG = 3;  { Basic IP Header logged when IP drops a msg }  "    IPL_FRAGLOG = 4;  { Fragment descriptor logged }      ipl_EMSGLOG = 5;  { Event Message Logged }      ipl_ICMPHEAD= 6;  { ICMP head logged }          { IP Error condition logging.     {  #   { The format of the 'logcode' that gets logged on error events is:  #    {     {  Subroutine ID + Error qualifier      {     {  where Subroutine ID   = 100 * N      {     {        Error qualifier = 0      No additional qualifier  "   {                        = 1..49  Subroutine specific qualifiers  " !   {                                 (defined in each subroutine)  !    {                        = 50..99 Global Error qualifiers     {                                 (defined below)     {}      { Common Error Qualifiers     {}      ANHFAIL    = 50;        { Access to a ANH record failed }     PATHFAIL   = 51;        { Access to a PATH record failed }   #   GOCRITFAIL = 52;        { An EnterCritical call returned an error } # $   ICMPSENDFAIL = 53;      { An attempt to send an ICMP message failed } $     PROSWFAIL  = 54;        { An error was returned from ProSw }           {}   
   { Subroutine IDs  
    {}      SubrALLOCANH      = 100;             { Iplib.pas }      SubrBUILDIPHD     = 200;             { Iplib.pas }      SubrCHECKSUMHD    = 300;             { Iplib.pas }      SubrCHECKTMRERR   = 400;             { Iplib.pas }      SubrDROPMSG       = 500;             { Iplib.pas }         { unused       = 600; }           { Iplib.pas }      SubrGETNGT        = 700;             { Iplib.pas }      SubrGETRCB        = 800;             { Iplib.pas }      SubrPOSTRCB       = 900;             { Iplib.pas }      SubrREMOVEFRAG    = 1000;            { Iplib.pas }      SubrSAVEHEADER    = 1100;            { Iplib.pas }      SubrBUILDROUTE    = 1200;            { Ipactp.pas }     SubrIPACTOUTPATH  = 1300;            { Ipactp.pas }     SubrREQUESTDOWNP  = 1500;            { Iplib.ccp  }     SubrSENDDATA      = 1600;            { Ipactp.pas }     SubrSENDQUEERROR  = 1700;            { Ipactp.pas }     SubrSPLITMSG      = 1800;            { Ipactp.pas }     SubrPREPARENXTFR  = 1900;            { Ipactp.pas }        { unused       = 2000;  }         {            }     SubrCLEARFRAGS    = 2100;            { Ippctl.pas }     SubrCLEAROUTQUE   = 2200;            { Iplib.ccp  }     SubrCLEARREASSQ   = 2300;            { Ipactp.pas }     SubrIPPATHCNTL    = 2400;            { Ippctl.pas }     SubrKILLOFFER     = 2500;            { Ippctl.pas }     SubrKILLPATH      = 2600;            { Ipactp.pas }     SubrPROCOFFER     = 2700;            { Ippctl.pas }     SubrSENDFRAGST    = 2800;            { Ippctl.pas }     SubrSENDKILLUP    = 2900;            { Ippctl.pas }     SubrBUILDRCB      = 3000;            { ipib.pas }     SubrABORTDPATH    = 3100;            { ipib.pas }     SubrINBOUND       = 3200;            { ipib.pas }     SubrINCONFIRMDP   = 3300;            { ipib.pas }     SubrINDATAIND     = 3400;            { ipib.pas }     SubrINKILLIND     = 3500;            { ipib.pas }     SubrINSTUBB       = 3600;            { ipib.pas }     SubrIPDATAINB     = 3700;            { ipib.pas }     SubrKILLEMSG      = 3800;            { ippctl.pas }     SubrAPPENDFRAG    = 3900;            { ipib.pas }     SubrREASSEMBLE    = 4000;            { ipib.pas }        { unused       = 4100;  }         {          }     SubrSFECHOINBOUND = 4200;            { ipib.pas }        { unused       = 4300;  }         {          }     SubrASSEMBLEMSG   = 4400;            { ipib.pas }     SubrFINDRCB       = 4500;            { ipib.pas }     SubrOUTBOUND      = 4600;            { ipob.pas }     SubrOUTIPCLTIMER  = 4700;            { ipactp.pas }     SubrOUTKILLREQ    = 4800;            { ipob.pas }     SubrOUTSENDREQ    = 4900;            { ipob.pas }     SubrOUTSTUBB      = 5000;            { ipob.pas }     SubrIPADDELEM     = 5100;            { ippath.pas }     SubrBUILDPATH     = 5200;            { ippath.pas }     SubrIPINIT        = 5300;            { ippath.pas }     SubrIPVNACOMPR    = 5400;            { ippath.pas }        { unused       = 5500;  }         {          }     SubrOUTTIMEREXPR  = 5600;            { ipob.pas }        { unused       = 5700;  }         {          }     SubrREASSTIMEOUT  = 5800;            { ipob.pas }     SubrINSERTFRAG    = 5900;            { ipib.pas }     SubrDISPOSERCB    = 6000;            { ipactp.pas }        { unused       = 6100;  }         {           }      SubrSTARTREASSTMR = 6200;            { iplib.pas }      SubrNotifySource  = 6300;            { ipib.pas }     SubrOUTSATBEAM    = 6400;            { ipob.pas }     SubrGETFRAG       = 6500;            { iplib.pas }      SubrPOSTFRAG      = 6600;            { iplib.pas }      SubrICMPINBOUND   = 6700;            { ipib.pas }     SubrFETCHICMPHEAD = 6800;            { ipib.pas }     SubrICMPRTNINFO   = 6900;            { ipib.pas }     SubrICMPDSTUNREACH= 7000;            { ipib.pas }     SubrSENDULPSRCQNCH= 7100;            { ippctl.pas }     SubrICMPSRCQUENCH = 7200;            { ipib.pas }     SubrBUILDDSTUNREACH = 7300;          { iplib.pas }      SubrREDIRECTSOURCE= 7400;            { ipib.pas }     SubrKILLOLDROUTE  = 7500;            { ippctl.pas }     SubrSTARTCLTMR    = 7600;            { iplib.pas }      SubrGETIPPATH     = 7700;            { iplib.pas }      SubrUNLKPATHFANH  = 7800;            { iplib.pas }      SubrANHPRSTATES   = 7900;            { ipib.ccp   }     SubrFINDLRUPATH   = 8000;            { iplib.pas }      SubrREASSACKTHRESH = 8100;            { ipib.pas }      SubrRCBLINK       = 8200;            { iplib.pas }      SubrRCBUNLINK     = 8300;            { iplib.pas }      SubrKILLROUTE     = 8400;            { ipactp.ccp }     SubrQUEMSGONSEND  = 8500;            { iplib.ccp }          SubrTEST          = 32700;           { for test routines }       $TITLE 'Global IP Table',PAGE$     {--------------------------------------------------------}      {               Global IP Table                          }      {--------------------------------------------------------}          {}      {  DSAM Table Descriptor: DS_IP_GLOBALS_TD      {  DSAM Word Length:      ipg_MAX_WORDS     {  	   {  Description  	     {     This record contains the Global Information IP requires      {     for all of its processing.   $   {     It is the initial context IP fetches to direct its processing.  $    {  
   {  Record Format: 
    {     {   5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0     {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  IP Indentification Number    |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Free Path List Head          |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Free ANH Record List Head    |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Path Control Queue           |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Active Outbound Path Queue   |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Connectionless Path List Hd  |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Connectionless Max Idle Count|      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  CL Max Paths |  CL Inuse     |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Connectionless Path Timer ID |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Reassembly Timer ID          |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Reassembly Queue Head        |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Reassembly Timer             |      {  +-+-+                       +-+-+      {  |     Expiration Time           |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Reass time - unused field    |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Timer Reset Values           |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Debug Flag Word              |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {     Statistics:  Architecture     {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Max Paths    |  Paths Inuse  |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Disasters    |  Errors       |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Kills        |  Pad          |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {     Statistics:  Traffic      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Terminating Packets Recvd    |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Source Packets Sent          |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Transit Packets Recvd        |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Transit Packets Sent         |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {     Statistics:  Lost Packets     {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  | Checksum      |   reserved    |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  | Kill Ind recv |   reserved    |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  | Proto Unreach | TTL Expired   |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  | Oversize      | Congested     |      {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {     {     Housekeeping fields     {  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {  |  Record Status                |      {  +-------------------------------+      {}      {  Fields     {  	   {     ipg_ip_id 	    {        The IP identifier that IP will assign to the next      {        message that needs to be sent. All fragments of      {        one message will have the same identifier.     {        This field is incremented each time it is used.      {        All 16 bits are used and 0 is a valid identifier.      {  
   {     ipg_pr_free 
    {        The FREE PATH list head. This is the index of the      {        first path record on the free path list.     {        The end of list value is 0.      {  
   {     ipg_ah_free 
    {        The FREE ANH list head. This is the index of the     {        first ANH record on the free list.     {        The end of list link value is 0.     {     {     ipg_pr_cntl_que     {        The Path Control Queue list head. This is the      {        index of the first path record on this queue. A      {        path is placed on this queue if it is in any of      {        the path control states.     {     {     ipg_act_out_pr_que      {        The Active Outbound Path Queue list head. This is      {        the index of the first path record on this queue.      {        A path is placed on this queue if it is in any of      {        the Active Outbound Path states.     {     {     ipg_clpath_list  $   {        The head of the list of path records used for connectionless $ 
   {        traffic. 
    {     {     ipg_cl_maxidle      {        The Connectionless path record maximum idle time.      {           0 - No maximum defined   $   {           x - When the idle count reaches this value, the path will $    {               be deallocated.     {     {     ipg_clcnt.resvd  %   {        The number of path records reserved for use as Connectionless  % 
   {        path records.  
    {     {     ipg_clcnt.inuse     {        The number of path records currently in use as     {        Connectionless path records.     {     {     ipg_cl_tmrid   %   {        The Timer Id to be used for canceling the Connectionless Path  % 	   {        Timer. 	    {     {     ipg_reass_tmrid     {        The Timer Id to be used with the Reassembly timer      {        in canceling or resetting the timer.     {     {     ipg_reass_que  #   {        The head of the list of RCBs (Reassembly Control Blocks).  #     {        This links all messages being reassembled, together.      {  
   {     ipg_reass_expire  
 $   {        The absolute time when the reassembly is set to expire next. $ #   {        It is the positive number of centiseconds since midnight.  #    {     {     ipg_reass_time    ****   #   {        Unused field, must be removed from IPINIT and IPINF before #    {        it is removed from here.     {  	   {     ipg_reset 	     {        The reset time for IP's timers. There is one field:    &   {           ipg_reset.cl     = reset timer for Connectionless Path Timer  & $   {        This value is used in conjunction with ip_TMRES to give the  $    {        number of centiseconds until the timer pops.     {        (i.e. ipg_reset.cl * ip_TMRES = # centiseconds).     {  	   {     ipg_debug 	 #   {        The debug flags word. This is an ARRAY of bits where each  #    {        bit indicates some debug operation.      {        (default = off unless indicated)     {  !   {           IF ipg_debug.bits[0]  = 1 THEN Turn IP Triggers ON  !    {              (default = on)  #   {           IF ipg_debug.bits[-1] = 1 THEN Turn Proto Event log ON  #    {              (default = on)  #   {           IF ipg_debug.bits[-2] = 1 THEN Turn Error Event log ON  #    {              (default = on)  !   {           IF ipg_debug.bits[-3] = 1 THEN Turn Emsg Logging ON !    {              (default = on)  %   {           IF ipg_debug.bits[-4] = 1 THEN Turn New Redun Frag Drop ON  %    {              (default = off)   %   {           IF ipg_debug.bits[-5] = 1 THEN Turn Old Redun Frag Drop ON  %    {              (default = off)   $   {           IF ipg_debug.bits[-6] = 1 THEN Don't Borrow for S&F msgs  $    {              (default = do borrow)      {     {  Statistics:  Architecture      {        These fields show the resource usage of IP.      {  
   {     ipgs_paths_inuse  
    {        The number of IP path records currently in use.      {     {     ipgs_maxpaths_used   "   {        The maximimum IP path records used since this field was  "    {        last reset.      {     {     ipgs_disaster     {        The number of times IP's error logging routine has     {        been called to log a severe internal error.      {  
   {     ipgs_error  
    {        The number of times IP's error logging routine has     {        been called to log a normal error.  !   {        These errors are typically recoverable and are normal  ! "   {        in the course of events. They are logged as a debugging  "    {        aid to see exceptional conditions.     {  	   {     ipgs_kill 	    {        The number of KILL_INDICATIONS generated by IP.      {  	   {     ipgs_pad  	    {        Space for future expansion     {  
   {  Statistics:  Traffic 
 #   {        These counters indicate the number of packets that IP has  # %   {        sent or received. These counters are 16-bit integers and will  %    {        roll over.     {     {     ipgs_term_packs_recvd  #   {        The number of packets received at this node, destined for  #    {        this node.     {     {     ipgs_src_packs_sent  #   {        The number of packets sent that originated from this node. #    {     {     ipgs_transit_packs_recvd   "   {        The number of packets received at this node that are not "    {        destined for this node.      {     {     ipgs_transit_packs_sent  !   {        The number of packets sent from this node that did not !    {        originate from this node.      {     {  Statistics:  Packets Lost   %   {        These are counters that indicate the number of times a packet  %    {        was dropped by IP in this node for some reason.   !   {        These counters are 8-bit integers and will roll over.  !    {     {     ipgs_chksm_packloss  "   {        The count of packets dropped due to the checksum of the  "     {        message not matching the checksum in the IP header.       {  
   {     ipgs_llp_ki_recvd 
 !   {        The count of KILL_INDICATION messages received from a  ! #   {        Lower Level Protocol. This is an indication of the number  # "   {        of packets that were dropped due to the link going down. "    {     {     ipgs_protounrch_packloss   %   {        The count of packets dropped due to the ULP being unreachable. % $   {        (e.g. the packet was addressed to some protocol that did not $ 
   {        exist).  
    {     {     ipgs_ttl_exp_packloss  "   {        The count of packets dropped due to the TTL field in the "    {        message going to zero.     {     {     ipgs_oversize_packloss   "   {        The count of packets dropped due to the packet requiring "    {        segmentation and not being able to segment it.     {     {     ipgs_congested_packloss  #   {        The count of packets dropped due to insufficient memory as #    {        declared by memory accounting.     {  
   {  Housekeeping Fields  
 $   {        These fields do not appear in DSAM, but are maintained with  $ %   {        the local copy of this record in order to facilitate handling  %    {        the record.      {     {     ipg_rec_status   !   {        A field which indicates the status of this local copy  ! %   {        as compared to DSAM. It may take one of the following values:  %    {           INVALID_DATA   $   {              The variable contains invalid data as compared to the  $ $   {              DSAM version. Such variables may be used for temporary $    {              storage but are not written to DSAM.     {  
   {           VALID_DATA  
 %   {              The variable contains the same data as the copy in DSAM. %    {     {           UPDATED_DATA   %   {              The variable contains valid data which has been updated  % $   {              and this record must be posted to DSAM before leaving  $    {              critical.      {}       $PAGE$  CONST      {}      { Global Block Size in DSAM     {}         { Length of Globals excluding Statistics }     ipg_GLOBAL_WORDS = 14 + (2 * TIMERID_LEN);             { Length of Global Statistics            }  
   ipgs_STATS_WORDS = 11;  
           { Length of entire Global Block in DSAM  }     ipg_MAX_WORDS = ipg_GLOBAL_WORDS + ipgs_STATS_WORDS;       TYPE     {}      { Connectionless Path Statistics      {}      IpgClCntType   = PACKED RECORD   
      CASE Int16 OF  
         0: (bufr : BufferType);       
        1: (resvd : byte;  
             inuse : byte );           END;   { IpgClCntType }          {}      { Global Statistics Declarations }      {}      IpGlobStatType = PACKED RECORD   
      CASE Int16 OF  
             0: (ipgs_bufr : BufferType );               1: (ipgs_paths_inuse         : posInt8;               ipgs_maxpaths_used       : posInt8;               ipgs_disaster            : posInt8;               ipgs_error               : posInt8;               ipgs_kill                : posInt8;               ipgs_pad                 : posInt8;                   ipgs_term_packs_recvd    : Int16;               ipgs_src_packs_sent      : Int16;               ipgs_transit_packs_recvd : Int16;               ipgs_transit_packs_sent  : Int16;                   ipgs_chksm_packloss      : posInt8;               ipgs_reserved            : posInt8;               ipgs_llp_ki_recvd        : posInt8;               ipgs_reserved_for_future : posInt8;               ipgs_protounrch_packloss : posInt8;               ipgs_ttl_exp_packloss    : posInt8;               ipgs_oversize_packloss   : posInt8;               ipgs_congested_packloss  : posInt8 );                END;  { IpGlobStatType }       $PAGE$     {}      { IP Global Block Declaration     {}      TimeResetType = PACKED RECORD        cl    : posInt8;        rsv   : posInt8;        END;  { TimeResetType }          IpDebugFlagsType = PACKED RECORD   
      CASE Int16 OF  
 
         0: (int : Int16); 
          1: (bits : PACKED ARRAY [-15..0] OF PosInt1);           END;       
   IpGlobalsType = RECORD  
 
      CASE Int16 OF  
             0: (ipg_bufr : BufferType );              1: (ipg_ip_id          : Int16;               ipg_pr_free        : Int16;               ipg_ah_free        : Int16;               ipg_pr_cntl_que    : Int16;               ipg_act_out_pr_que : Int16;               ipg_clpath_list    : Int16;               ipg_cl_maxidle     : Int16;               ipg_clcnt          : IpgClCntType;              ipg_cl_tmrid       : TimerIdType;               ipg_reass_tmrid    : TimerIdType;               ipg_reass_que      : MbufIdType;              ipg_reass_expire   : Int32;   !            ipg_reass_time     : Int16;          { Unused field }  !             ipg_reset          : TimeResetType;               ipg_debug          : IpDebugFlagsType;              ipg_statistics     : IpGlobStatType;                 { Housekeeping Fields }              ipg_rec_status     : Int16 );               END;  { RECORD }         {}      { Global Block Initialization Constants     {}   CONST   	   ipg_MINELE = 1; 	 	   ipg_NUMELE = 1; 	        INIT_CLCNT  = IpgClCntType   '      [  resvd : 4,        { 4 path recs reserved for Connectionless use only} ' &         inuse : 0 ];      { 0 paths currently used for Connectionless use } &        ipg_INIT_TMRID = TimerIdType         [            index :  ip_TIMER_OFF,            key   :  ip_TIMER_OFF,         ];         { Timer Reset Initialization values   }     { Set Store and forward to 10 seconds }     { set reserved field to 0 seconds     }     ipg_INIT_TMRESET = TimeResetType         [   
         cl    : 10, 
 
         rsv   :  0, 
       ];         ipg_INIT_DEBUG = IpDebugFlagsType        [            int   :  13,   { Turn on flags 0, -2 .. -3 }         ];         { Global Statistics Initial values }      {  set all counts to 0             }      ipg_INIT_STATS = IpGlobStatType        [            ipgs_paths_inuse         : 0,           ipgs_maxpaths_used       : 0,           ipgs_disaster            : 0,           ipgs_error               : 0,           ipgs_kill                : 0,           ipgs_pad                 : 0,               ipgs_term_packs_recvd    : 0,           ipgs_src_packs_sent      : 0,           ipgs_transit_packs_recvd : 0,           ipgs_transit_packs_sent  : 0,               ipgs_chksm_packloss      : 0,           ipgs_reserved            : 0,           ipgs_llp_ki_recvd        : 0,           ipgs_reserved_for_future : 0,           ipgs_protounrch_packloss : 0,           ipgs_ttl_exp_packloss    : 0,           ipgs_oversize_packloss   : 0,           ipgs_congested_packloss  : 0,        ];             { Global Block Initial values }     ipg_INIT = IpGlobalsType         [   $         ipg_ip_id          : 0,     { First IP Message Identifier     } $ $         ipg_pr_free        : 1,     { All path recs on the free list  } $ $         ipg_ah_free        : 1,     { All ANH recs on the free list   } $ $         ipg_pr_cntl_que    : 0,     { Path Control Queue is empty     } $ $         ipg_act_out_pr_que : 0,     { Active Path Queue is empty      } $ $         ipg_clpath_list    : 0,     { No CL paths exist               } $ $         ipg_cl_maxidle     : 30,    { 30 * CL reset time = 5 min      } $ $         ipg_clcnt          : INIT_CLCNT, { CL path count init values  } $ $         ipg_cl_tmrid       : ipg_INIT_TMRID, { Timer Id Place holder  } $ $         ipg_reass_tmrid    : ipg_INIT_TMRID, { Timer Id Place holder  } $ $         ipg_reass_que      : 0,     { Msg Reassembly list head        } $ $         ipg_reass_expire   : 3*CSPD,{ Illegal time of next expiration } $ $         ipg_reass_time     : 0,               { Unused field          } $ $         ipg_reset          : ipg_INIT_TMRESET, { CL/Reass Tmr Resets  } $ $         ipg_debug          : ipg_INIT_DEBUG,  { Debug flags Initials  } $ $         ipg_statistics     : ipg_INIT_STATS,  { Stats set as above    } $ $         ipg_rec_status     : UPDATED_DATA,    { Record must be posted } $           ];          $TITLE 'Header Declarations',PAGE$     {--------------------------------------------------------}      {                HEADER DECLARATIONS                     }      {--------------------------------------------------------}       {}  	{     Description  	 !{        This is the declaration for the IP header. The IP header  !  {        will be copied from DSAM into the local code space for     {        manipulation and then any changes will cause the entire   {        record to be posted to DSAM.   {   !{        This declaration covers both the ordinary IP header with  ! {        options as well as the ICMP message format.  {   
{     Record Format: 
 {   {        An IP message is composed of several parts:  {           1) The basic IP header (10 words)   {           2) Options (these are optional)    {           3) An ULP header and data (this includes ICMP which    {              the IP protocol handler takes care of.   {   
{     The basic IP header: 
 {   #{      5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0           Type of Service Byte  # &{     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+  & &{     |Version|  IHL  |Type of Service|   |               |Prec |D|T|R|Rsv|  & &{     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+  & {     |        Total Length           |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |        Identification         |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |D|M|R|  Fragment Offset        |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     | Time To Live  | Protocol Num  |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |        Header Checksum        |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |    IP Source                  |   {     +-+-+                       +-+-+   {     |              Address          |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |    IP Destination             |   {     +-+-+                       +-+-+   {     |              Address          |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {}  $PAGE$  {}  {     Options (40 bytes maximum)  {   !{        Multiple options may appear in one message subject to the ! #{        constraint that an IP header may not be longer than 60 bytes. # {   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |C|Cls|Opt Numbr|  Length       |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |  Data                         |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {   #{        The length and data portions may be omitted for some options. # {   {        The end of the options must end on a 32 bit boundary.  !{        This may be accomplished through the use of pad options.  ! {}  $PAGE$  {}  
{     ICMP Message format  
 {   "{        ICMP messages are composed of the basic IP header, and the  "  {        ICMP specific portion with a format that depends on the   {        particular ICMP message (the ICMP protocol header).  {   #{        The data for an ICMP message could be any data (e.g. as with  # "{        an ECHO request or reply), or the IP header and first part  " #{        of the ULP's header (e.g. as with the Destination Unreachable # {        ICMP messages).  {   {        ICMP Protocol header   {   {      5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0  {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |     Type      |     Code      |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |     ICMP Msg Checksum         |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {   {        Fields Specific to various ICMP Types  {   {     Parameter Problem                   Redirect  &{     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+  & &{     |Pointer|   unused              |   |      Gateway Internet         |  & &{     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+                       +-+-+  & &{     |   IP Header + 64 bits data    |   |             Address           |  & &{     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+  & &{                                         |   IP Header + 64 bits data    |  & &{                                         +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+  & {   "{     Echo Request & Reply                Timestamp Request & Reply  " &{     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+  & &{     |  Message Identifier           |   |  Message Identifier           |  & &{     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+  & &{     |  Message Sequence Number      |   |  Message Sequence Number      |  & &{     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+  & &{     |  Data                         |   |  Originate Timestamp          |  & &{     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+  & &{                                         |  Receive Timestamp            |  & &{                                         +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+  & &{                                         |  Transmit Timestamp           |  & &{                                         +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+  & {     Information Request & Reply   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |  Message Identifier           |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |  Message Sequence Number      |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |   IP Header + 64 bits data    |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {}  {     End of ICMP / Options section   {}  {        Housekeeping Fields  {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |  Mbufid of DSAM version       |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |    Record Status              |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {   {}  $PAGE$  {}  "{     The field descriptions given here are in the order they would  " {     be found in an IP header.   {   {     Fields for accessing the IP header as a whole   	{        iphd_bufr 	 #{           This field allows treating this record as an integer array # {           for passing to and from DSAM.   {   
{        iphd_words  
 "{           Allows allocating sufficient space for the IP header and " {           possible options and/or ICMP header.   {           The header housekeeping fields (which are not found    {           in the DSAM version) follow this array.   {   
{        iphd_bytes  
 {           Allows access to IP header as an array of bytes.  {   {     Basic IP header fields  {   {        iphd.w1.version  {           The version of the IP header used in here.  {           The current version is 4.   {   {        iphd_w1.headlen  "{           The length of the entire IP header including options in  " {           number of 32-bit words.   {   
{        iphd_w1.typeofsrv 
 &{           The type of service parameters will be ignored at first release, & {           and will be set to the following values:  {   {             .precedence  := 0  Routine  {             .delay       := 0  Normal Delay   {             .Thruput     := 0  Normal Throughput  {             .Reliability := 0  Normal Reliability   {   	{        iphd.len  	 {           The length of the header and data in 8-bit bytes.   {   {        iphd.id  #{           The message identifier. All fragments of one message will  # {           have the same identifier.   {   
{        iphd.fragwd 
 !{           This word contains various fields used in controlling  ! !{           message fragmentation and reassembly. The fields are:  ! {   {             .iphd_df  - Don't Fragment Bit.   #{                             If this bit is set, the message may not  # "{                             be fragmented under any circumstances. " {   {             .iphd_mf  - More Fragments Bit.   %{                             If this bit is set, there are more fragments % {                             in this message.  {   {             .iphd_off - Fragment Offset   %{                             This field gives the offset relative to the  % ${                             entire message where this fragment starts. $ %{                             It is in units of number of '8 byte' pieces. % {   
{        iphd.w5.iphd_ttl  
 ${           This field contains the time to live value for this message. $ !{           It is set at the source and decremented at each IP hop ! #{           along the way by the time it took the node to process the  # ${           message. 1 second is the minimum any node may decrement this $  {           field. If it ever goes to 0, the message has 'lived'   {           too long, and must be discarded.  {   {        iphd.w5.iphd_proto    {           The protocol number of the ULP this message is to be   {           dispatched to at the IP destination.  {   	{        iphd.sum  	 %{           The IP Header 16-bit One's complement of the one's complement  % {           sum of the IP header.   %{           This checksum covers the entire header, including any options. % {           It does not include the data.   {   	{        iphd.src  	 %{           The IP address of the node that is the source of this message. % {   	{        iphd.dst  	 ${           The IP address of the node that is the destination for this  $ 
{           message. 
 {   {  ICMP message fields  (the basic ICMP header)   {   {     iphd_icmp.ic_kind.msgtype   
{        ICMP type field.  
 {   {     iphd_icmp.ic_kind.code  {        ICMP code field. Together with the type field, this  {        declares which ICMP message it is.   {   {     iphd_icmp.ic_cksum   {        ICMP checksum which is the 16-bit ones' complement sum    !{        of the ones' complement sum of the ICMP message starting  ! {        with the ICMP type field (iphd_icmp.ic_kind.msgtype)   {        to the end of the message.   {   {     iphd_icmp.pp_ptr_wd.ptr   !{        IF the code = 0, this identifies the byte in the options  ! {        where an error was detected.   {   {     iphd_icmp.gateway   "{        IP address of the gateway on the DCN to which messages for  " !{        the network specified in the destination address field of ! {        the original IP header should be sent.   {   	{     iphd_icmp.id 	 !{        An identifier to aid in matching requests and replies for ! {        some ICMP messages (e.g. Echo Request or Replies).   {   
{     iphd_icmp.sqn  
 !{        A sequence number to aid in matching requests and replies !  {        for some ICMP messages (e.g. Echo Request or Replies).    {   
{  ICMP data fields  
 !{     One set of these fields will follow the above ICMP message.  ! {     These contain data used in the various ICMP messages.   {   {     ** Echo Data **   {     iphd_icdata.bufr  {        Access point for Echo Request and Reply Data.  {        (Note that this declaration does not imply any   {         space for echo request or reply data.   {         That needs to be done another way.)   {   {     ** Timestamp **   {     iphd_icdata.ts_origin   {        The time the sender last touched the message.  {   
{     iphd_icdata.ts_recv  
 !{        The time the echoer first touched the message on receipt. ! {   
{     iphd_icdata.ts_xmit  
 #{        The time the echoer last touched the message on returning it. # {   {     ** IP Header and data **  
{     iphd_icdata.oldhead  
  {        Original IP header that was sent with the message that    {        caused the generation of this ICMP message.  !{        This field contains only the basic IP header (10 words).  ! {   
{     iphd_icdata.options  
 !{        Original options that were sent with the original header. ! {   
{     iphd_icdata.ulp_data 
 {        64 bits of data that followed the IP header in the   {        original message. This is returned to allow the ULP  {        to determine the source and destination ports of the   {        original message that has caused this ICMP message.  {   {  Option Fields  (handles for maintainance)  {   	{        opt_bufr  	 "{           A reference that allows the option portion of the header " {           to be accessed through a memory manager call.   {   	{        opt_words 	 !{           A reference that allows access to options as an array  ! {           of 16-bit words.  {   
{  Option-type byte  
 {   {        copy   "{           A 1-bit flag indicating whether or not this option must  " ${           be copied in fragments other than the first when segmenting  $ {           a message.  {   {        class  {           2 bits which indicate the class of option.  {   {        option   {           5 bits which indicate which option this is  {   {        length   {           The length of the option in bytes.  {           This field is not required in all options.  {   {        data   {           Data that is associated with the option.  {           This field is not required in all options.  {   {  Housekeeping Fields  {   #{     These fields do not appear in DSAM. They are associated with the # #{     header while a copy resides in a variable local to the protocol  # {     process. They are used to for maintainance purposes.  {   
{        iphd_mbufid 
 #{           This contains the pointer to the mbuf in DSAM which is the # !{           start of the message. This header is contained in this ! 	{           mbuf.  	 {   {        iphd_rec_status  {           A field which indicates the current status of this  {           copy of a DSAM record. It may have one of the   {           following values:   {   {           INVALID_DATA  {              The variable contains invalid data as compared    {              to DSAM. Such variables may be used as temporary    {              storage.   {   {           VALID_DATA  {              The variable contains data that is the same as   {              that in DSAM.  "{              This will be true as long as the process is critical. " {   {           UPDATED_DATA  {              The variable contains valid data which has been  {              updated and so these updates must be posted to   {              DSAM before the process leaves critical.   {   {}  $PAGE$         {}      { IP Header Constants     {}      CONST        WORDS_IP_HEAD         = 10;         BYTES_IP_HEAD         = WORDS_IP_HEAD * 2;            WORDS_ICMP_HEAD       = 14;         BYTES_ICMP_HEAD       = WORDS_ICMP_HEAD * 2;        WORDS_ICMP_ULPDATA    = 4;            WORDS_IP_OPTIONS      = 20;         BYTES_IP_OPTIONS      = WORDS_IP_OPTIONS * 2;             iphd_MAX_WORDS = WORDS_IP_HEAD + WORDS_IP_OPTIONS                                        + WORDS_ICMP_ULPDATA;        iphd_MAX_BYTES = iphd_MAX_WORDS * 2;          !      iphd_TTL_EXPIRED  =  0;    { Time to live Expiration Value } !     $      iphd_CKSUM_BOFSET = 10;    { Byte Offset to the checksum field  }  $ $                                 { Field used to link messages off of }  $ $                                 { Outbound Msg Queue on path recod   }  $     $PAGE$     TYPE         {}        { Type of Service Fields Declaration        {}        TOStype = PACKED RECORD            precedence  : PosInt3;            delay       : PosInt1;            Thruput     : PosInt1;            Reliability : PosInt1;            Reserved    : PosInt2;   
         END;  { TOStype } 
           {}        { Word 1 Declarations   
      {     version  
 
      {     header length  
       {     type of service         {}        IpWord1Type = PACKED RECORD            version    : PosInt4;           headlen    : PosInt4;           typeofsrv  : TOSType;  
         END;  { RECORD }  
           {}        { Fragmentation Declarations        {}        IpFragWordType = PACKED RECORD           iphd_rsv   : PosInt1;           iphd_df    : PosInt1;           iphd_mf    : PosInt1;           iphd_off   : PosInt13;   
         END;  { RECORD }  
           {}        { Word 5 Declarations         {     Time To Live        {     Protocol Number         {}        IpWord5Type = PACKED RECORD            iphd_ttl   : posInt8;           iphd_proto : posInt8;  
         END;  { RECORD }  
     $PAGE$        { Basic IP Header         {}        BasicIpHeadType = RECORD           w1      : IpWord1Type;   
         len     : Int16;  
 
         id      : Int16;  
          fragwd  : IpFragWordType;           w5      : IpWord5Type;   
         sum     : Int16;  
 
         src     : Int32;  
          dst     : Int32           END; { BasicIpHeadType }       $PAGE$        { Options Declarations        {}         CONST  
      { Option Constants } 
       op_END_OF_OPTIONS = 0;        op_NO_OPERATION   = 1;            { Option Classes        {}        opt_CONTROL = 0;        opt_DEBUG   = 2;         TYPE         IpOptType = PACKED RECORD   
         copy   : PosInt1; 
 
         class  : PosInt2; 
 
         option : PosInt5; 
          length : Byte;            END;  { IpOptType }            IpOptionsType = RECORD           CASE Int16 OF              0: (opt_bufr : BufferType);       "            1: (opt_words : ARRAY [1..WORDS_IP_OPTIONS] OF Int16 );  "     !            2: (opt_bytes : ARRAY [1..BYTES_IP_OPTIONS] OF Byte ); !     $            3: (options   : ARRAY [1..WORDS_IP_OPTIONS] OF IpOptType );  $             END;  { IpOptionsType }       $PAGE$  
      { ICMP Declarations  
       {}        IcmpTypeCodeType = PACKED RECORD           msgtype : PosInt8;            msgcode : PosInt8;            END;  { IcmpTypeCodeType }             IcmpHeadType = RECORD            CASE Int16 OF              0: (bufr : BufferType);               1: (                 icmp_tc     : IcmpTypeCodeType;                 icmp_cksum  : Int16;                  CASE Int16 OF                        { Destination Unreachable   
                  {} 
                   0: (dstunreach : Int32;                         icmp_duhd  : BasicIpHeadType);                        { Time Exceeded   
                  {} 
                   1: (timeexceed : Int32;                         icmp_ttlhd : BasicIpHeadType);                        { Source Quench   
                  {} 
                   2: (srcquench  : Int32;                         icmp_sqhd  : BasicIpHeadType);                        { Parameter Problem   
                  {} 
                   3: (pramprob  : PACKED RECORD                              ptr : PosInt8;                              pad : PosInt8;                              END;                         icmp_pphd : BasicIpHeadType;                             );                         { Redirect  
                  {} 
                   4: (redirect : RECORD                              gateway : AddressType;                              END;                         icmp_rdhd : BasicIpHeadType;                             );                         { Echo Request & Reply  
                  {} 
                   5: (echo : RECORD                              id  : Int16;                              sqn : Int16;                              END;                              );                         { Timestamp Request & Reply   
                  {} 
                   6: (timestamp : RECORD                             id   : Int16;                             sqn  : Int16;                             orig : Int32;                             recv : Int32;                             xmit : Int32;                             END;                              );                               { Information Request & Reply   
                  {} 
                   7: (info : RECORD                              id  : Int16;                              sqn : Int16;                              END;                              );   	               );  	             END;  { IcmpMsgType }       $PAGE$        {}        {  IP Header Declaration (with OPTIONS and ICMP)        {}        IpHeaderType = RECORD            CASE Int16 OF                  { for MMGR              {}              0: (iphd_bufr : BufferType );                   { Array of Words              { Housekeeping fields               {}               1: (iphd_words : ARRAY [1..iphd_MAX_WORDS] OF Int16;   	                {} 	                 { Housekeeping Fields   	                {} 	                 iphd_mbufid     : MbufIdType;                   iphd_rec_status : Int16 );                  { Array of Bytes              {}  $            2: (iphd_bytes : PACKED ARRAY [1..iphd_MAX_BYTES] OF Byte);  $                     { Basic IP Header               {}              3: (iphd : BasicIpHeadType;                   iphd_options : IpOptionsType );                   { ICMP Message fields               {}              4: (icmp_iphd : BasicIpHeadType;                  icmp      : IcmpHeadType);                  END;  { IpHeaderType }      $PAGE$     CONST        {}        { Initialization Values for IP headers        {}        iphd_VERSION    =  4;         iphd_LENGTH     =  5;   
      iphd_FIRST_FRAG = 0; 
     $TITLE 'Old ICMP Message Constants',PAGE$   {--------------------------------------------------------}  {            ICMP Message Constants                      }  {--------------------------------------------------------}      {}  {  Description  {   {     These constants are used to direct various IP routines  {     to build the various types of ICMP messages.  {     There is one for each different ICMP message.   {}      CONST       &   ICMP_PROTO_NUM               =  1; { ARPA Assigned Protocol Number for }  & &                                      { ICMP Messages                     }  &    {}      { ICMP Types & Codes      {                       type   code     {}      ECHO_REPLY              =  0;         DEST_UNREACH            =  3;        NETWORK_UNREACH             = 0;        HOST_UNREACH                = 1;        PROTOCOL_UNREACH            = 2;        PORT_UNREACH                = 3;        FRAG_NEEDED_DF_SET          = 4;        SOURCE_ROUTE_FAILED         = 5;         SOURCE_QUENCH           =  4;     REDIRECT                =  5;        NETWORK_REDIRECT            = 0;        HOST_REDIRECT               = 1;        TOSNET_REDIRECT             = 2;        TOSHOST_REDIRECT            = 3;     ECHO_REQUEST            =  8;      
   { Time Exceeded } 
    TIME_EXCEEDED           = 11;        TTL_EXPIRED                 = 0;        REASS_EXPIRED               = 1;         OPTIONS_PRAM_PROB       = 12;         TIMESTAMP_REQUEST       = 13;     TIMESTAMP_REPLY         = 14;         INFO_REQUEST            = 15;     INFO_REPLY              = 16;          $TITLE 'Local IP Address List',PAGE$     {--------------------------------------------------------}      {    Local IP Address List (LIPADlist) Declarations      }      {--------------------------------------------------------}          {}      {  DSAM Table Descriptor: DS_IP_LOCAL_ADDRS_TD      {  DSAM Word Length:      lpd_MAX_WORDS     {  	   {  Description  	    {     The LIPADlist is the list of all the possible IP      {     addresses for this local node. It is accessed     {     strictly by Memory Manager calls searching for a   
   {     given IP address. 
    {  
   {  Record Format  
    {     {         5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0     {        +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {        |        IP                     |      {        +-+-+                       +-+-+      {        |           Address             |      {        +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+      {     {  Fields     {     lpd_bufr    The start of the buffer for MMGR calls.     {     lpd_addr    An IP address assigned to the local node.     {}      CONST        {}        { Size of each entry in words.        {}        lpd_MAX_WORDS = 2;         TYPE             LipadType = RECORD           CASE Int16 OF                  0: (lpd_bufr : BufferType);               1: (lpd_addr : Int32);                  END;  { LipadType }       $TITLE 'Neighbor Gateway Table ',PAGE$     {--------------------------------------------------------}      {    Neighbor Gateway Table (NGT) Declarations           }      {--------------------------------------------------------}          {}      {  DSAM Table Descriptor: DS_IP_NEIGH_GATE_TD     {  DSAM Word Length:      ngt_MAX_WORDS     {  	   {  Description  	    {     The NGT is IP's primary routing table. It contains      {     the current best gateway to a given IP destination   	   {     network.  	    {     {     The NGT maps a given IP Destination network address     {     into the appropriate IP gateway to use in getting to      {     the network. It also contains some information      {     connected with getting messages to that gateway, such     {     as the network segment size, and the correct Link     {     Interface to be used.     {  
   {  Record Format  
    {     {            5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0      {           +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {           |     Destination IP            |     {           +-+-+                       +-+-+     {           |        Network Address        |     {           +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {           |     Neighbor Gateway          |     {           +-+-+                       +-+-+     {           |        IP Address             |     {           +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {           |        Down PID               |     {           +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {           |  Max Network Segment Size     |     {           +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {           |        Hop Count              |     {           +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {              Housekeeping Fields      {           +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {           |     NGT Index                 |     {           +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {           |     NGT Appropriate Next      |     {           +-+-+                       +-+-+     {           |        Hop IP Address         |     {           +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     {     {  Fields     {  
   {     ngt_dstnet  
    {        The destination IP network address. This value is      {        used as the primary key to this table. This is the     {        address to which the given message is to be sent.      {        There will be only one entry for every network     {        known to this node.      {     {     ngt_neighgate     {        The IP gateway to use when sending messages to     {        ngt_dstnet.       {        This field contains the IP address of that gateway.       {        If the destination network is the local network,     {        this field will be meaningless.      {  	   {     ngt_dnpid 	    {        The PID of the network interface to use in sending     {        messages to ngt_neighgate.     {        This number is tied to the network selected.  "   {        In the case of Directly Connected Networks, this will be "    {        the PID of the LLP associated with that network.     {  
   {     ngt_segsize 
    {        The maximum size of IP message allowed over this     {        network. (In units of bytes).   "   {        This number takes into account the maximum sized header  " "   {        that the LLP may append. It is set up at initialization. "    {        If set to 0, then segmentation is not necessary      {        for this network.      {  
   {     ngt_hopcnt  
    {        The number of IP gateways to pass through to get     {        to the destination. If ngt_dstnet is the directly      {        connected network, this field will be 0.     {     {     Housekeeping Fields     {     {        These fields are not in the DSAM copy of the NGT     {        record. They are for maintaining the NGT entry and     {        for ease of operation.     {  	   {     ngt_index 	    {        The index of the NGT record currently being      {        operated on.     {        This is used when restoring the record and may be      {        saved with other structures to facilitate future     {        routing decisions.     {     {     ngt_anh     {        The Appropriate next hop to use based on this      {        routing entry and the destination given.      {        If the destination is in a DCN, this field is the IP      {        address of the destination host.     {        If the destination is NOT in a DCN, then this will     {        be the IP address of the neighbor gateway.     {}      CONST        ngt_MAX_WORDS = 7;      { Size of entry in DSAM }   "      ngt_MAX_HOPS  = 255;    { Initialization value for Hop Count } "        TYPE   
      NgtRecType = RECORD  
          CASE Int16 OF                 0: (ngt_bufr : BufferType );                  1: (ngt_dstnet    : Int32;                  ngt_neighgate : Int32;                  ngt_dnpid     : Int16;                  ngt_segsize   : Int16;                  ngt_hopwd     : Int16;                      { Local housekeeping fields }                 ngt_index     : Int16;                  ngt_anh       : Int32 );                   END;  { NgtRecType }         CONST        {}        { Initialization Values for an NGT entry        {}        ngt_INIT_NGT_REC = NgtRecType            [              ngt_dstnet     : 0,               ngt_neighgate  : 0,               ngt_dnpid      : 0,               ngt_segsize    : 0,               ngt_hopwd      : 0,               ngt_index      : NO_INDEX,              ngt_anh        : NO_ANH_NODE           ];       
$TITLE 'Path Record',PAGE$ 
    {--------------------------------------------------------}      {          Path Record (PathRec) Declarations            }      {--------------------------------------------------------}          {}      {  DSAM Table Descriptor: DS_IP_PATH_REC_TD     {  DSAM Word Length:      pr_MAX_WORDS      {     {     NOTE: Some of the fields in this record are refered     {           to by offset. When changing this record, be     {           sure to reset those values to ensure that     {           the code continues to operate correctly.      {  	   {  Description  	    {     IP's path records hold context information used in      {     formatting an IP message and routing it appropriately     {     for the given destination.      {     {     A given path record links an ULP to IP and then to      {     an LLP through an ANH Record.     {  
   {  Record Format  
    {     {      5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0      {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     Free List Link            |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {        Path Record Key      {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     Remote IP                 |     {     +-+-+                       +-+-+     {     |              Address          |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     Local  IP                 |     {     +-+-+                       +-+-+     {     |              Address          |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     Protocol Number           |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {        Path Link to ULP     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     Up Protocol ID            |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     Memory Pool ID            |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {        Connectionless Path Maintainance     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |  ULP Up Emsg Counter          |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |  ULP Dn Emsg Counter          |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     | CL  Path List Link            |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     | CL  Path Idle Counter         |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     | Path Type (Connect/Cnctless)  |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {        IP Message Queue     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     Outbound Message Queue    |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     Outbound Queue Tail       |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {        Path Processing Control      {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     States Word               |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     Active Path Link          |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {        IP Route Maintainance      {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     ANH List Link             |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     ANH Record Index          |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     NGT Record Index          |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     Resvd   | Time to Live    |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {        Path Link to LLP     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |  LLP Up Event Msg Counter     |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |  LLP Down Event Msg Counter   |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {        Path Report/Inbound Msg      {              Route Offer      {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     Inbound Down PID          |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     Inbound Down Path         |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     Kill Indication Reason    |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {        Path Statistics      {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     Statistics  (6 wds)       |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {        Housekeeping Fields      {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     Path Record Index         |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |     Record Status             |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     {        Statistics (pr_statistics)     {     {      5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0      {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |  Send Requests from ULP       |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |  Send Requests to LLP         |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |  Data Indicataion to ULP      |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |  Data Indication from LLP     |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |  reserved     |  reserved     |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |  reserved     |  reserved     |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     |  reserved     |  reserved     |     {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     {     {  Fields     {  	   {  pr_free_link 	    {     The free IP path records are stored in a linked list      {     to speed the allocation of a new record. The list is   !   {     linked through this word. This word contains the index of !    {     the next path record in the list.     {     If this link is set to -2, this means that the record     {     is currently inuse (i.e. not in the Free List). This      {     is used to facilitate searching for paths already in   
   {     existance.  
    {     {               0 = End of List     {              -2 = Record is Inuse.      {     {     {        *** Path Record Key ***      {     {  pr_remote       {     The IP address of the remote machine that all messages       {     sent on this path are addressed to or from.  "   {     (For Inbound store and forward messages, this is the remote "    {      source of the message.)      {     {  pr_local     {     The IP address of the local machine. 0 is NOT a legal  !   {     IP address. If this field is 0, then this is a Store and  !     {     Forward path used only for messages either destined or       {     sourced at the pr_remote address.     {     {  pr_proto  "   {     The IP protocol number carried in IP's header. On inbound,  "     {     this number is used as a key to find the correct path,       {     on outbound, this number is put into the IP header to     {     correctly address the ULP at the remote node.     {     Store and forward paths use IP's protocol number.     {     {     {        *** Path Link to ULP ***     {     {  pr_uppid      {     The PID of the ULP connected to this path. This is the       {     PID that will be used to generate a ProSw index when      {     sending an event message to a ULP.      {     All messages on this path will use this ULP.      {     Store and Forward messages will use IP's PID.     {  	   {  pr_mpool_id  	    {     This identifies the memory account that all messages   "   {     must gain membership in prior to being passed on up to the  "    {     ULP.      {     {  pr_ulp_up_emscnt  !   {     The count of all event messages passed from IP to the ULP !     {     along this path record. This count is decremented when       {     ever a KILL_REQUEST is received from the ULP. When       {     this and the pr_ulp_dn_emscnt go to 0, this path record      {     is ready to be deallocated as it is no longer     {     referenced by the ULP.      {     {  pr_ulp_dn_emscnt      {     The count of all event messages passed from the ULP to    !   {     IP along this path record. This count is decrementd when  !    {     ever a KILL_REQUEST is received from the ULP. When       {     this and the pr_ulp_up_emscnt go to 0, this path record   !   {     is ready to be deallocated as it is no longer referenced  ! 
   {     by the ULP. 
    {     {        *** Connectionless Path Maintainance     {     {  pr_cl_link      {     Connectionless Path records are maintained in a linked       {     list to facilitate Least Recently Used processing.   #   {     This link contains the index of the next connectionless path  #    {     record, or END_OF_LIST.     {  
   {  pr_cl_idletime 
    {     The idle time counter for the LRU processing of     {     connectionless path records.   &   {     This counter is incremented each time the Connectionless Path Timer & $   {     expires and is reset to the minimum each time the path is used. $    {  	   {  pr_path_type 	     {     The type of path record, Connection or Connectionless.    $   {     This determines the processing done on receipt of KILL_REQUESTs $    {     or when there are no free path records available.     {     {        *** IP Outbound Message Queue ***      {     {  pr_out_que  !   {     The Head of a queue of messages ready to be sent out this !     {     path. If for some reason the path is not in a sendable       {     state, then outbound messages will get queued up here     {     to be sent when the path becomes sendable.      {  	   {  pr_out_tail  	     {     The Tail of the Outbound message queue. This is used to      {     queue messages on the tail of the message queue.      {     {        *** Path Processing Control ***      {     {  pr_states   $   {     This word is the set of states that this path record may be in. $    {     These states are divided into two sets,      {        A set of states for the Control Queue processing and   !   {        a set of states for the Active Path Queue processing.  !    {     {     The Control Queue handles the following states      {     in the order in which they are declared:      {  
   {     cst_HAVE_IN_ROUTE 
    {        An inbound message or path report arrived      {        with an inbound route. IP must check to see      {        if this route agrees with its own routing      {        and deal with this offered route accordingly.      {  
   {     cst_SEND_KILL_UP  
    {        A KILL_INDICATION must be set to the ULP     {        using this path record.      {     {     cst_SEND_FRAG_STATUS       {        Message segment size information needs to be sent to   $   {        the ULP to because it changed, or a message was fragmented.  $ "   {        This is to allow the ULP to do as much fragmentation as  " $   {        possible. This should be done before any remaining messages  $ %   {        are sent in order to react as quickly as possible tp changing  %    {        conditions.      {     {     cst_SEND_ULP_SRCQNCH   "   {        A Source Quench message has been received on this path.  " "   {        A status indication will be sent to the ULP on this path "    {        to allow some kind of action to be taken.      {     {     The Active Path Queue processese these states:      {     {     ast_BUILD_ROUTE     {        A new route needs to be built before messages      {        may be sent to the LLP on this path record.      {     {     ast_CANT_SEND_DATA       {        There is data to send on this path record, but there   !   {        is no route to send it on. The REQUEST_DPATH has been  ! 	   {        sent.  	    {     {     ast_SEND_DATA     {        There is data to send to the LLP queued on     {        this path.     {     {     ast_KILL_PATH     {        When all else is done on this path, Kill the     {        path record if the ULP emsg counts are 0.      {  
   {  pr_active_link 
    {     Any path record in any state will be linked  #   {     onto one of the IP Processing Queues, the Path Control Queue  # $   {     or the Active Outbound Path Queue. The Path Control Queue will  $ #   {     be processed first, with the processing being directed by the #    {     state of the path record at the head of the queue.      {  "   {     This word contains the index of the next path record in the "    {     list. 0 = End of List.      {  "   {     NOTE: This field is also refered to by offset. The ofset is "    {           given in the constant pr_ACTLINK_OFSET.     {     {        *** IP Route Maintainance      {  	   {  pr_anh_link  	    {     This word links all the path records using the same  !   {     ANH record together. It contains the index of the next IP !    {     path record in the list.      {     This list is used for path maintainance purposes.  "   {     When there are no path records in this list, the ANH record " !   {     must be deallocated and the Down Path referenced must be  !    {     killed.     {  %   {     NOTE: This field is also referenced by offset from the beginning  % #   {           of this record through the constant, pr_ANHLINK_OFSET.  #    {     {  pr_anh_idx  "   {     The index of the ANH record used by this path for routing.  " $   {     The ANH record contains the Down PID and down path information  $    {     for the current route for all messages on this path.      {     {  pr_ngt_idx  "   {     The index of the NGT record that contains the best current  "    {     route to the given destination.     {     This field is set when the path record is allocated.   #   {     If this field is 0, the destination network is unknown to IP. #    {     {  	   {  pr_ttlwd.ttl 	 $   {     This byte contains the Time to Live value that will be put into $ !   {     the IP header of every message that goes out this route.  ! %   {     It is dependant on the number of hops to the destination network  %     {     (a value which is kept in the Neighbor Gateway Table).       {     {        *** Path Report/Inbound Message Route Offer ***      {  	   {  pr_in_dnpid  	 !   {     The Inbound down PID. This is set when a message arrives  ! !   {     on this path or when a path is built from a path report.  !     {     It may or may not be the same as the route selected by       {     IP's routing.      {     It is saved here until the IP procedures have a chance       {     to process the information following processing the     {     message itself.     {  	   {  pr_in_dnpath 	 !   {     The Inbound down path. This is set when a message arrives ! !   {     on this path or when a path is built from a path report.  !     {     It may or may not be the same as the route selected by       {     IP's routing.      {     It is saved here until the IP procedures have a chance       {     to process the information following processing the     {     message itself.     {  	   {  pr_ki_reason 	    {     When IP receives a KILL_INDICATION from an LLP, the  !   {     reason is saved here until a KILL_INDICATION is generated !    {     for the ULPs.     {     {     {        *** Statistics ***     {  
   {  pr_statistics  
    {     Statistics kept for each path.      {     See the description of this record below.     {     {     {        *** Housekeeping Fields ***      {  !   {  These fields of the path record do not appear in DSAM. They  !    {  are strictly for maintainance of the path record.      {     {  pr_pathref     {     The path reference to use when accessing this path.     {     This is an index into the DSAM memory area which will     {     cause this path record to be accessed.      {  
   {  pr_rec_status  
 !   {     A field which indicates the current status of this local  ! "   {     copy of the DSAM record. It may have the following values:  "    {     {        INVALID_DATA     {           The variable contains invalid data as     {           compared to DSAM. Such variables may be     {           used as temporary storage but will never be     {           posted to DSAM.     {     {        VALID_DATA     {           The variable contains data that is the       {           same as the data in DSAM, such a record will not       {           be posted to DSAM.      {     {        UPDATED_DATA     {           The variable contains valid data which      {           has been updated and so the record now      {           must be posted to DSAM.     {     {     *** Statistics ***       {  This record within the Path Record contains the statistics       {  for this given IP path record. Each IP path may be thought      {  of as a given route for messages. These statistics are     {  then the statistics for each individual route.     {     {  Global statistics will be kept in DSAM as well. They are     {  kept in the Global IP Record.      {     {     st_sendrq_up  : Int16;      {        The number of SEND_REQUESTS received from the ULP      {     {     st_sendrq_dn  : Int16;      {        The number of SEND_REQUESTS send to the LLP      {     {     st_dataind_up : Int16;      {        The number of DATA_INDICATIONS sent to the ULP     {     {     st_dataind_dn : Int16;       {        The number of DATA_INDICATIONS received from the LLP      {  
   {     st_rsv1...st_rsv6 
    {        Fields reserved for future use.      {}          CONST      %      pr_MAX_WORDS = 33;       { Length of Path Record as it is in DSAM }  %     '      pr_CL_OFSET      = 8;    { Reference to Connectionless Maint. portion }  ' $      pr_CL_LEN        = 8;    { Word length of CL portion of path rec } $ "      pr_CL_LINK_OFSET = 12;   { Reference to the pr_CL_LINK word. } "                                { See also LRULinkageType }            pr_ACTLINK_OFSET = 18;   { Reference to pr_active_link }        pr_ANHLINK_OFSET = 19;   { Reference to pr_anh_link    }            pr_DEST_NET_UNKNOWN = 0; { NGT Index when No NGT entry }          #      cl_TIMER_RESET   = 10;   { Reset value for timer used to 'age' } # &                               { Connecntionless path records in seconds. }  &     %      cl_PATH_NOT_IDLE = 0;    { Connectionless path idle counter value  } % %                               { which indicates the path is in use.     } %     %                                   { ** Path record type identifiers ** }  % $      pr_REFED_CONNECT       = 1;  { Referenced Connection (e.g. TCP) }  $ &      pr_REFED_CONNECTLESS   = 2;  { Referenced Connectionless (e.g. IFP) }  & '      pr_UNREFED_CONNECTLESS = 3;  { Unreferenced Connectionless (e.g. S&F) }  '        TYPE         {}        { Path States Declarations        {}  
      PrAllStatesType   =  
                { Path Control Queue }            (  cst_HAVE_IN_ROUTE ,               cst_SEND_KILL_UP  ,               cst_SEND_FRAG_STATUS,               cst_SEND_ULP_SRCQNCH,                  { Active Path Queue }              ast_BUILD_ROUTE   ,               ast_CANT_SEND_DATA,               ast_SEND_DATA     ,               ast_KILL_PATH       );            PrStateSetType = SET OF PrAllStatesType;         CONST        {}        { Processing queue state subsets        {}        CNTL_STATES   = PrStateSetType [cst_HAVE_IN_ROUTE..   %                                                   cst_SEND_ULP_SRCQNCH];  % #      ACTIVE_STATES = PrStateSetType [ast_BUILD_ROUTE..ast_KILL_PATH]; #       EMPTY_SET     = PrStateSetType [];         TYPE         PrProtoType = PACKED RECORD            CASE Int16 OF              0: (int  : Int16);              1: (pad  : posInt8;                   byte : posInt8 );               END;  { PrProtoType }             PrTtlType = PACKED RECORD            rsv : Byte;    { Reserved for future use }            ttl : Byte;    { Time to Live field }           END;  { TTLwdType }            PrStatisticsType = PACKED RECORD           st_sendrq_up  : Int16;            st_sendrq_dn  : Int16;            st_dataind_up : Int16;            st_dataind_dn : Int16;            st_rsv1       : posInt8;            st_rsv2       : posInt8;            st_rsv3       : posInt8;            st_rsv4       : posInt8;            st_rsv5       : posInt8;            st_rsv6       : posInt8;   
         END;  { RECORD }  
     $PAGE$             { This portion of the path record is used to find the LRU          { Connectionless path suitable for reallocation.  !      { It must match the portion of the path record refered to by !       { the pr_CLOFSET offset.        {}        LruLinkageType = RECORD            CASE Int16 OF              0: (lru_bufr  : BufferType);      $            1: (lru_up_emscnt : Int32;         { See also pr_CL_OFSET }  $ $                lru_dn_emscnt : Int32;         {    and pr_CL_LEN     }  $ $                lru_index     : Int16;         {    which includes    }  $ $                lru_count     : Int16;         {    all these         }  $ $                lru_path_type : Int16;         {    fields            }  $ $                lru_out_que   : Int16 );       {    !!                }  $             END;  { LruLinkageType }      
      PathRecType = RECORD 
          CASE Int16 OF                 0: (pr_bufr : BufferType );                           { Path Record Key }             1: (pr_free_link : Int16;                 pr_remote    : Int32;                 pr_local     : Int32;                 pr_proto     : PrProtoType;                           { Path Link to ULP }                  pr_uppid     : Int16;                 pr_mpool_id  : Int16;      %                     { Path Maintainance }   {*  See also LRULinkageType } % %               pr_ulp_up_emscnt : Int32;     {*  See also pr_CL_OFSET    } % %               pr_ulp_dn_emscnt : Int32;     {*     and pr_CL_LEN        } % %               pr_cl_link       : Int16;     {*     and pr_CL_LINK_OFSET } % %               pr_cl_idletime   : Int16;     {*  for all these fields    } % %               pr_path_type     : Int16;     {*                          } % %                     { IP Outbound MsgQueue }{*  (including the outbound } % %               pr_out_que   : MbufIdType;    {*   message queue).        } %                pr_out_tail  : MbufIdType;                            { Path Processing Control }                 pr_states    : PrStateSetType;   &               pr_active_link : Int16;        { SEE also pr_ACTLINK_OFSET }  &                          { IP Route Maintainance }  &               pr_anh_link  : Int16;          { SEE also pr_ANHLINK_OFSET }  &                pr_anh_idx   : Int16;                 pr_ngt_idx   : Int16;                 pr_ttlwd     : PrTtlType;                           { Inbound Msg Path Offer }                  pr_in_dnpid  : Int16;                 pr_in_dnpath : Int16;                 pr_ki_reason : Int16;                           { Statistics }                  pr_statistics : PrStatisticsType;                           { Local housekeeping fields }                 pr_pathref   : Int16;                 pr_rec_status: Int16 );                  END;  { PathRecType }       $PAGE$  CONST      {}      { Initialization values for newly allocated path records      {}   
   SECS_PER_HOP = 5; 
    MAX_TTL = PrTtlType        [   
         rsv :   0,  
 
         ttl : 255,  
       ];         NO_STATISTICS = PrStatisticsType         [            st_sendrq_up  : 0,            st_sendrq_dn  : 0,            st_dataind_up : 0,            st_dataind_dn : 0,            st_rsv1       : 0,            st_rsv2       : 0,            st_rsv3       : 0,            st_rsv4       : 0,            st_rsv5       : 0,            st_rsv6       : 0,         ];         pr_INIT_PATH_REC = PathRecType         [            pr_free_link     : REC_INUSE,           pr_remote        : 0,           pr_local         : 0,           pr_proto         : PrProtoType [int : 0],           pr_uppid         : 0,           pr_mpool_id      : 0,           pr_ulp_up_emscnt : 0,           pr_ulp_dn_emscnt : 0,           pr_cl_link       : 0,    { End of list }            pr_cl_idletime   : 0,    { CL Path NOT idle }           pr_path_type     : 0,    { Undefined type }           pr_out_que       : 0,           pr_out_tail      : 0,           pr_states        : EMPTY_SET,           pr_active_link   : 0,           pr_anh_link      : 0,           pr_anh_idx       : 0,           pr_ngt_idx       : 0,           pr_ttlwd         : MAX_TTL,           pr_in_dnpid      : 0,           pr_in_dnpath     : 0,           pr_ki_reason     : 0,           pr_statistics    : NO_STATISTICS,           pr_pathref       : NO_INDEX,            pr_rec_status    : VALID_DATA        ];         {}      { Initial values for Connectionless Reserved paths.     { These paths are reserved at initialization      {}   %   pr_MAX_CL_IDLETIME   =  32767;      { CL paths never get older than . } %        pr_CL_RESV_INIT  = PathRecType         [            pr_free_link     : REC_INUSE,           pr_remote        : 0,           pr_local         : 0,           pr_proto         : PrProtoType [int : 0],           pr_uppid         : 0,           pr_mpool_id      : 0,           pr_ulp_up_emscnt : 0,           pr_ulp_dn_emscnt : 0,           pr_cl_link       : 0,           pr_cl_idletime   : pr_MAX_CL_IDLETIME,            pr_path_type     : pr_UNREFED_CONNECTLESS,            pr_out_que       : 0,           pr_out_tail      : 0,           pr_states        : EMPTY_SET,           pr_active_link   : 0,           pr_anh_link      : 0,           pr_anh_idx       : 0,           pr_ngt_idx       : 0,           pr_ttlwd         : MAX_TTL,           pr_in_dnpid      : 0,           pr_in_dnpath     : 0,           pr_ki_reason     : 0,           pr_statistics    : NO_STATISTICS,           pr_pathref       : NO_INDEX,            pr_rec_status    : VALID_DATA        ];         {}      { Initial values for Store and Forward Reserved paths.      { These paths are reserved for S&F use at initialization      {     {  This constant will disappear when IPINIT changes     {}      pr_SF_RESV_INIT = pr_CL_RESV_INIT;       $TITLE 'Protocol ID List',PAGE$      {--------------------------------------------------------}      {     Protocol ID List (PIDlist) Declarations            }      {--------------------------------------------------------}          {}      {  DSAM Table Descriptor: DS_IP_PROTO_ID_TD     {  DSAM Word Length:      pl_MAX_WORDS      {  	   {  Description  	    {     This is a list of the PIDs of all protocols that may      {     be addressed by IP messages. It maps IP's protocol      {     number into the PID and vice versa. It also contains      {     the memory accounting information that is associated      {     with the protocol.      {  
   {  Record Format  
    {     {            5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0      {           +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {           |       Proto ID                |     {           +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {           |       Proto Number            |     {           +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {           |       Memory Pool ID          |     {           +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {           |       Path Type Required      |     {           +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {           |       Canonical Address       |     {           +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+     {     {  Fields     {  	   {     pl_uppid  	    {        The PID of the protocol addressed. This is also      {        one of the primary keys to this list.      {  	   {     pl_proto  	    {        The IP Protocol Number of the ULP represented by     {        this entry.      {        This is one of the primary keys to this list.      {  
   {     pl_mpool_id 
    {        The memory pool to which any message must gain     {        membership in before that message may be passed up     {        to the ULP.      {     {     pl_path_type      {        The type of path record used in supporting the ULP     {        represented by this record.      {  	   {     pl_canadr 	    {        The Canonical Address of the ULP represented by      {        this entry. This will be used to verify that the     {        path report being used to build a new path is      {        correct. The Canonical Address and the Protocol ID  %   {        in the path report must both match in order to use the PidList % 	   {        entry. 	 !   {        In some cases, this will function as a search key into !    {        this table.      {}      CONST        pl_MAX_WORDS   = 5;  { Length of Table in DSAM }        pl_PID_OFSET   = 0;  { Ofset of PID field in record }         pl_PROTO_OFSET = 1;  { Offset of Proto Number field }   "      pl_PROTO_LEN   = 1;  { Length of Proto Number field in words } "        TYPE             PidListRecType = RECORD            CASE Int16 OF                 0: (pl_bufr : BufferType );                 1: (pl_uppid     : Int16;                 pl_proto     : Int16;                 pl_mpool_id  : Int16;                 pl_path_type : Int16;                 pl_canadr    : Int16 );                 END;  { PidListRecType }       $TITLE 'Reassembly List Declarations',PAGE$      {--------------------------------------------------------}      {              Reassembly List Declarations              }      {--------------------------------------------------------}       {}  {  Description   {     These structures allow IP to keep track of messages being    {     reassembled. Both the frag descriptor and the reassembly  {     control block are kept in DSAM, appended to the various   {     fragments of a message.   {   "{     Each fragment is described in terms of its starting and ending " {     fragment offset which is in units of 8 bytes.   #{     Each IP fragment except the last one must be an intergral number # 
{     of fragment offsets. 
 {   {  Record Format  {   {     Reassembly Control Block  {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |                               |   {     +  Frag Descriptor              +   {     |                               |   {     +                               +   {     |                               |   {     +                               +   {     |                               |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |  Rcb Link                     |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |  Reassembly Time              |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |  Path Reference               |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |  Message Identification       |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |  Backwards Link (local only)  |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |  Mbufid of this block         |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {   {     rcb_frag  {        Frag Descriptor  {        The frag descriptor list head.   !{        This describes a fragment that occurs immediately before  ! {        the first possible fragment.   {   {     rcb_link  	{        Rcb Link  	 &{        Link to the next Reassembly control block off of the same path rec. & {        It will be set to 0 to indicate end of list.   {   {     rcb_time  ${        The incremental message reassembly time out value for the next  $ {        RCB in the list (refered to by rcb_link).  #{        When this RCB times out, the timer will be set to this value  # {        for timing out the next (rcb_link) RCB.  {   "{        If it is 0, this means that when the current RCB times out, " {        the next one (rcb_link) will time out as well.   {   {     rcb_msgid   &{        The IP message identifier associated with this particular message.  & '{        Along with the path information, this field identifies all fragments  ' {        belonging to one particular message.   {   {     Reassembly statistics   ${        The next fields are used in conjunction with protocol specific  $ #{        logging to provide information regarding the way in which the # {        message was fragmented.  {   {     rcb_trims   "{        The number of fragments that partially overlapped with the  " "{        previous fragment. This is the number of fragments that had " !{        data trimmed off at the completion of message reassembly. ! {   	{     rcb_frags_in 	  {        The number of fragments processed relative to this RCB.   {   
{     rcb_newfrags_unused  
 !{        The number of times a newly arrived fragment was dropped  ! {        because it was completely redundant.   {   
{     rcb_oldfrags_unused  
  {        The number of times a fragment already in the list was    {        dropped because a new arrival made it redundant.   {   
{     rcb_stat_rsvd  
 {        A field reserved for future use.   {   
{     Housekeeping fields  
 #{        These fields do not appear in the DSAM copy, they are set up  #  {        locally only to help in the maintaince of the RCB list.   {   {     rcb_mbufid  {        The mbufid of this RCB.  {   {   
{     Fragment Descriptor  
 {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |  Link                         |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |  Offset to start of fragment  |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |  Offset to end of fragment    |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {     |  Mbufid of fragment           |   {     +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+   {   {     link  {        The MbufId of the next fragment in the list.   {   {     first   {        Offset to start of fragment  #{        The fragment offset of the first byte of data in this message # %{        fragment. It will be set to the fragment offset contained in the  % {        message header.  {   {     last  {        Offset to end of fragment.   &{        The fragment offset number of the last byte of data in the message. & %{        Fragment offsets are in units of 8 bytes, so a fragment offset of % {        2 indicates bytes 17-24 (origin 1);  {   {     mbufid  {        The mbufid of this fragment.   {}         CONST  %      { Temp declaration of REASS_TIMER until new structure is in place }  %       REASS_TIMER  = TimerMsgType                           [socket    : 0,                            direction : 0,                            signal    : 0,   
                        ]; 
     #      EOL_RCB_TIME = MAXINT16; { Max time for end of list processing } #     CONST      FRAG_BLEN   = 8;  { # bytes of FRAG Descriptor }      FRAG_WLEN   = FRAG_BLEN DIV 2;      RCB_BLEN    = 18 + FRAG_BLEN; { # bytes of RCB in DSAM }       %   FRAG_FIRST_MSG_COMPLETE = 32767;  { Offset of 'start' of EOM fragment } % $   FRAG_LAST_MSG_COMPLETE = 32760;   { Offset of 'end' of EOM fragment } $         RCB_MBUFID_UNKNOWN =  0;   { MbufId of this RCB is unknown }    $   GLOBAL_BLK_RCB     = -1;   { The RCB list head is the Global block }  $     TYPE        FragDescType = RECORD            CASE Int16 OF              0: (bufr : BufferType);               1: (                 link       : MbufIdType;                  first      : Int16;                 last       : Int16;                 mbufid     : MbufIdType;   	               );  	             END;  { FragDescType }      CONST   
   EOL_FRAG = FragDescType 
       [            link     : END_OF_LIST,           first    : FRAG_FIRST_MSG_COMPLETE,           last     : FRAG_LAST_MSG_COMPLETE,            mbufid   : RCB_MBUFID_UNKNOWN,         ];      TYPE        RcbType = RECORD           CASE Int16 OF              0: (rcb_bufr : BufferType);                   1: (                 rcb_frag    : FragDescType;                 rcb_link    : MbufIdType;                 rcb_time    : Int16;                  rcb_pathref : Int16;                  rcb_msgid   : Int16;                      { reassembly statistics }                 rcb_trims     : Int16;                  rcb_frags_in  : Int16;                  rcb_newfrags_unused : Int16;                  rcb_oldfrags_unused : Int16;                  rcb_stat_rsvd       : Int16;                      { local Housekeeping field }                  rcb_mbufid    : MbufidType;  	               );  	             END;  { RcbType }       CONST   
   READ_FAIL_RCB = RcbType 
       [            rcb_frag    : EOL_FRAG,           rcb_link    : NO_MBUFID,   
         rcb_time    : 0,  
 
         rcb_pathref : 0,  
 
         rcb_msgid   : 0,  
          { reassembly statistics }           rcb_trims     : 0,            rcb_frags_in  : 0,            rcb_newfrags_unused : 0,            rcb_oldfrags_unused : 0,            rcb_stat_rsvd       : 0,            { local Housekeeping field }            rcb_mbufid    : RCB_MBUFID_UNKNOWN,        ];      $TITLE 'Status Message Constants',PAGE$      {--------------------------------------------------------}      {              Status Message Constants                  }      {--------------------------------------------------------}          {}   	   {  Description  	    {     {     The error returns used by IP are given here.      {     {     Zero is used to indicate no error, and that the     {        called routine operated as expected.     {     {     IP's error bases are also included here. These are      {     the numbers that are used to determine the source of      {     the error when the error message is seen outside of     {     the context of the IP procedures.     {}          CONST              {**************************************}              { IP's error base for reporting errors }              {**************************************}  
      ips_IP = 3000; 
                 {*****************}               { Status Messages }               {*****************}       (*    ips_NEW_PATH_REC     = 1 + ips_IP;  *)        ips_MSG_NOT_COMPLETE = 2 + ips_IP;  (*    ips_NO_PATH          = 3 + ips_IP;        ips_LAST_FRAGMENT    = 4 + ips_IP;  !      ips_MSG_COMPLETE     = 5 + ips_IP;   { Message reassembled } ! *)  '      ips_FRAG_REDUNDANT   = 6 + ips_IP;   { Frag not needed for reassembly }  '                 {*************}               { Good return }               {*************}       
      ips_GOOD_RETURN = 0; 
                 {****************}              { Error Messages }              {****************}      (*    { Initialization Errors }            {}            { Memory could not be allocated for this table            { In DSAM. This should have been caught much   	         { sooner. 	          {}         ips_AH_NO_MEMORY  = 901 + ips_IP;   *)        ips_IPG_NO_MEMORY = 902 + ips_IP;         ips_LPD_NO_MEMORY = 903 + ips_IP;         ips_NGT_NO_MEMORY = 904 + ips_IP;         ips_PL_NO_MEMORY  = 905 + ips_IP;         ips_PR_NO_MEMORY  = 906 + ips_IP;             ips_BAD_CHECKSUM   = 101 + ips_IP;        ips_TTL_EXPIRED    = 102 + ips_IP;        ips_PATH_NOT_FOUND = 103 + ips_IP;           {  Requested Path Record could not be found }  "         {  Path requested by reference or by key was free or was  } " "         {  not found. Internal tables are incorrect               } "     (*    ips_PATH_NOT_ALLOC = 104 + ips_IP;           {  Requested path record could not be allocated }  *)            ips_PATH_NOT_AVAIL = 105 + ips_IP;           { Attempt to allocate free path record unsuccessful }           { Need more path records to correct                 }            ips_ANH_NOT_FOUND  = 106 + ips_IP;           { ANH Record Search Unsuccessful }             ips_DESTNET_UNKNOWN  = 107 + ips_IP;        ips_PROTOCOL_UNKNOWN = 108 + ips_IP;  (*    ips_ROUTE_BAD        = 109 + ips_IP;  *)            ips_BAD_VNA_DOMAIN   = 110 + ips_IP;           { The Virtual Network Address DOMAIN is not  }            { understood by IP.                          }            { See also ips_BAD_VNA                       }             ips_ILLEGAL_UPPID    = 111 + ips_IP;           { PID was not found in IP's PidList }            ips_UNKNOWN_EMSG     = 112 + ips_IP;           { IP received an event message unknown to it }             ips_BAD_PATHREF      = 113 + ips_IP;           { Requested Path record has not yet been allocated }             ips_BAD_ANHREF       = 114 + ips_IP;           { Requested ANH record has not yet been allocated }            ips_ANH_NOT_ALLOC     = 115 + ips_IP;            { ANH record could not be allocated }      (*    ips_GLOBALS_NOT_FOUND = 116 + ips_IP;            { IP Globals could not be fetched from DSAM }  *)            ips_HEAD_NOT_FOUND    = 117 + ips_IP;   #         { IP Header ref'd by mbufid could not be fetched from DSAM }  #           ips_NGT_NOT_FOUND     = 118 + ips_IP;   %         { NGT record given by NGT index could not be fetched from DSAM }  %     (*    ips_BAD_MBUFID        = 119 + ips_IP;            { Invalid mbufid was supplied to a fetch routine }   *)            ips_INEMSG_RECVD      = 120 + ips_IP;             { Outbound process can't handle Inbound emsg received }             ips_OUTEMSG_RECVD     = 121 + ips_IP;             { Inbound process can't handle Outbound emsg received }             ips_BAD_VNA           = 122 + ips_IP;            { VNA Supplied is of the wrong domain }           { See also ips_BAD_VNA_DOMAIN         }            ips_BAD_MBUFLEN       = 123 + ips_IP;   "         { Mbuf Length passed in event message does not agree with } " "         { the message length in the IP header.                    } "           ips_FRAG_NOT_ALLOWED  = 124 + ips_IP;   "         { Fragmentation is required for a message, but the        } " "         { Don't Fragment bit is set.                              } "           ips_FRAG_FAILED       = 125 + ips_IP;            { Fragmentation failed }             ips_BAD_ROUTE         = 126 + ips_IP;            { Route was supposed to be set up, but wasn't }            ips_RCB_NOT_FOUND     = 127 + ips_IP;            { A Reassembly Control Block was not found }       (*    ips_NO_DCN_NGTENTRY   = 128 + ips_IP;   !         { A ReDirect was attempted, but there was no NGT entry }  ! !         { for the DCN that contained the new gateway.          }  !           ips_NGT_POST_ERROR    = 129 + ips_IP;             { On Redirect, error occured posting the updated NGT }    *)            ips_BAD_TMREXPIRE     = 130 + ips_IP;   !         { An unknown timer expired and IP processed the signal }  !           ips_BAD_HDVERSION     = 131 + ips_IP;            { The IP Header has an unknown version number in it }            ips_TRIG_MSG_DROP     = 132 + ips_IP;            { Message dropped due to trigger popping }             ips_BAD_ICMP_CODE     = 133 + ips_IP;            { ICMP msg type was known, but code was unknown }            ips_NO_PATH_THIS_TYPE = 134 + ips_IP;            { Couldn't get path for ICMP message type }            ips_ADDR_NOT_LOCAL    = 135 + ips_IP;             { IP address in question is not for the local machine }             ips_SHORTER_ROUTE     = 136 + ips_IP;             { For PROBE, gateway request. IP would send a REDIRECT    !           message if the source send to the dest via this node. } !           ips_UNKNOWN_DCN       = 137 + ips_IP;   "         { The local node has no local IP address on the given DCN } "           ips_DCNPATHSW         = 138 + ips_IP;   %         { The down PID/Path associated with a remote node on a DCN     }  % %         { has changed due to processing a path report or an inbound    }  % %         { message.                                                     }  % %         { This should be a fixed mapping.                              }  %           ips_ABORT_DPATH       = 139 + ips_IP;   %         { ABORT_DPATH received from PROBE                              }  %           ips_TRIGGER_POPPED    = 140 + ips_IP;            { An IP trigger popped and returned an error value }       &      ips_Transit_TTL       = 148 + ips_IP; {Transit Time To Live exceeded } & $      ips_Reass_TTL         = 149 + ips_IP; {Reassembly timer expired  } $ $      ips_NET_UNREACH       = 150 + ips_IP; {Dest Net Unreachable      } $ $      ips_DEST_UNREACH      = 150 + ips_IP; {Dest Net Unreachable      } $ $      ips_HOST_UNREACH      = 151 + ips_IP; {Dest Host Unreachable     } $ $      ips_PROTO_UNREACH     = 152 + ips_IP; {Dest Protocol Unreachable } $ $      ips_PORT_UNREACH      = 153 + ips_IP; {Dest Port Unreachable     } $ %      ips_FRAG_BUT_DF       = 154 + ips_IP; {Fragments needed but DF set } % $      ips_SRC_ROUTE         = 155 + ips_IP; {Source Routing failed     } $ 	(* new at N262 *)  	 $      ips_PRAM_PROB         = 156 + ips_IP; {Parameter Problem msg     } $ $      ips_SRC_QUENCH        = 157 + ips_IP; {Source Quench             } $ $      ips_NET_REDIRECT      = 158 + ips_IP; {Redirect for Network      } $ $      ips_HOST_REDIRECT     = 159 + ips_IP; {Redirect for Host         } $ $      ips_TOS_NET_REDIRECT  = 160 + ips_IP; {Redirect for ToS & Net    } $ $      ips_TOS_HOST_REDIRECT = 161 + ips_IP; {Redirect for ToS & Host   } $ $      ips_ECHO_REQUEST      = 162 + ips_IP; {Echo Request message      } $ $      ips_ECHO_REPLY        = 163 + ips_IP; {Echo Reply message        } $ $      ips_TS_REQUEST        = 164 + ips_IP; {Time Stamp Request        } $ $      ips_TS_REPLY          = 165 + ips_IP; {Time Stamp Reply          } $ $      ips_INFO_REQUEST      = 166 + ips_IP; {Information Request msg   } $ $      ips_INFO_REPLY        = 167 + ips_IP; {Information Reply msg     } $     $      ips_BAD_ICMP_TYPE     = 168 + ips_IP; {Unknown ICMP Type Field   } $          { ICMP messages received }       $TITLE 'Global Variables',PAGE$      {--------------------------------------------------------}      {                Global Variables                        }      {--------------------------------------------------------}          {}   	   {  Description  	    {     These variables are used only by the IP routines      {     within one protocol process, but they are global to     {     all such routines.      {     They form the global context within which the IP   
   {     routines operate. 
    {     {     {  Variables      {     {     gv_ip_head         IP Header being operated on      {     gv_icmp_msg        ICMP Message Storage     {     {        Local Copies of DSAM structures      {     {     gv_ip_globals  
   {     gv_path_rec 
 
   {     gv_anh_rec  
 
   {     gv_ngt_rec  
 
   {     gv_pid_rec  
    {     {        Event Message Storage      {  %   {     gv_send_emsg   - Storage for event message sent by IP to another  %    {                      protocol.      {     {        Critical Region Control   $   {     gv_wkmap       - Working map for Enter and Leave Critical Calls $ $   {     gv_gocrit_error- Error code from most recent EnterCritical call $ !   {                      used to protect next LeaveCritical call. !    {}          VAR        gv_ip_head     : IpHeaderType;        gv_icmp_msg    : IcmpHeadType;            {}        { Local copies of DSAM structures         {}        gv_ip_globals  : IpGlobalsType;         gv_path_rec    : PathRecType;         gv_anh_rec     : AnhRecType;        gv_ngt_rec     : NgtRecType;        gv_pid_rec     : PidListRecType;            {}        { Event Message Storage         {}        gv_send_emsg   : EventMsgType;            {}        { Critical Region Control         {}        gv_wkmap        : Int16;        gv_gocrit_error : Int16;          IMPLEMENT       	$TITLE 'The End'$  	 END   { END of MODULE IPDEC }   .  