 $PASCAL '91790-1X096 REV.4010 <860404.1121>'  $ TITLE 'IP Inbound Routines' $   $HEAP 0 $   $HEAPPARMS OFF$   $RECURSIVE OFF$   
$STANDARD_LEVEL 'HP1000'$  
 $DEBUG$   $AUTOPAGE ON$   $CODE_INFO ON$  	$CODE_OFFSETS ON$  	 $RANGE OFF$       MODULE ipib;  $ALIAS 'N$IPIB'       {}  {-------------------------------------------------------------  {   { (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS  { RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   { REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT  { THE PRIOR WRITTEN CONSENT OF THE HEWLETT PACKARD COMPANY.   {   {-------------------------------------------------------------  {}      {}  {      NAME: IPIB.PAS   {    SOURCE: 91790-18096  	{     RELOC: NONE  	 {      PGMR: CWJ  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   {  1/21/85     cwj   Simplify ICMP checksum routine.  {  2/5/85      cwj   Correct message length passing   {  2/14/85     cwj   Change import searches to @.rels   !{  2/18/85     cwj   Add RCB statistics maintainance & RCB logging ! {  3/18/85     cwj   Fix RCB statistics handling  !{                    by ensuring that the local RCB is up to date  ! !{                    Allow the receipt of messages with mbuf data  ! "{                       longer than that recorded in the IP header.  " {                    Add Header Version number validation.  !{                    Change Checksuming of header to compare to 0  ! #{  3/25/85     cwj   Correct list chase algorithm for reass Hole list  # {  3/27/85     cwj   Set RCB back link in FindRcb   ${  4/10/85     cwj   Fix Trim Data to handle trimming all of a fragment  $ ${  4/11/85     cwj   Fix InsertFragment to handle overlaps of mult holes $ "{  4/16/58     cwj   Add a debug fixture to AssembleMsg to calculate " {                    the message length before reassembling.  !{  4/16/85     cwj   Add a parameter to TrimData to allow trimming ! '{                    all that is necessary off of fragments in the reassembly  ' {                    queue.   %{  4/17/85     cwj   Fix InsertFragment, and TrimData to correctly process % {                    fragments which overlap multiple holes.  !{  5/1/85      cwj   Change structure of reassembly - simplify it  ! {                    Add FragRedundant routine  {  5/2/85      cwj   Remove TrimData routine  {                    Remove AppendHoleDesc  {                    Add AppendFragDesc   {                    Remove PutHoleDesc   {                    Use PostFrag instead   {  5/3/85      cwj   Set frag.mbufid in RCB's frag descriptor   #{  5/6/85      cwj   Fix bug in message assembly section re: incorrect # !{                    trimming if more than 1 piece needs trimming. ! "{                    Fix bug in InsertFragment: When removing a frag " %{                    that is redundant due to the arrival of the newfrag,  % #{                    ensure that the local copy of newfrag is updated  # {                    if necesary.    {                    Fix bug dropping the old fragment when the    {                    new fragment is redundant  #{  5/7/85      cwj   Fix InsertFragment bug. Scanning list incorrectly # {                    when looking for old redundant fragments.  "{                    Add debug hook to drop old redundant fragments. " ${  5/8/85      cwj   Change Assemble Msg vicinity to log RCB statistics  $ {                    including the trims  "{                    Add debug hook to drop new redundant fragments. " "{                    Fix bug in disposing of redundant new fragment  "  {  5/9/85      cwj   Fix error reporting in around Assemble Msg    "{  5/13/85     cwj   Fix InsertFragment error and Assemble Msg error " #{  5/14/85     cwj   ReassembleMsg potential bug fix on test following # {                    FindRcb.   %{                    FindRcb & BuildRcb are now procedures not functions.  % {                    InsertFragment clarification   {  5/16/85     cwj   Remove commented out sections  {                    Add Icmp Routines  "{  5/17/85     cwj   More stringent hole at head Assemble time test  " %{  5/21/85     cwj   Code ICMP protocol handler for receipt of ICMP msgs.  % {  5/22/85     cwj   Add ICMP send points   {  5/29/85     cwj   Fix Echo Reply Icmp msg building   #{                    Fix ICMP error handling so emsg counts and mbufs  # {                       get cleaned up properly   {  5/30/85     cwj   Put in Protocol Unreachable generation   {  5/31/85     cwj   Generalize NotifySourceNode  {                    Add RedirectSource   !{                    Add sending of NET_UNREACH message during S&F ! {                       processing.   {  6/4/85      cwj   Change InAbortDpath processing   {                    Change InConfirmDpath processing    {                    Add Logging Emsgs on Unknown Emsg detection   {  7/3/85      cwj   for cww: Changes for PROBE SREGLIB   ${  6/28/85     cwj   Ensure that the S&F Aging timer is running whenever $ {                       a S&F message is received   #{  7/9/85      cwj   Emsg count correcting & Confirm_Dpath processing  # {                    Merge in N050 emsg format changes  {  7/29/85     cwj   Correct statistics maintainance  ${  8/2/85      cwj   InAbortDpath bug: No KI if have good offered route  $ {                    LogEvent Conversion  {  8/3/85      cwj   IMPORT @.xpt   {                    Range checking off   {                    Enter/Leave Critical error handling  {  8/14/85     cwj   Move KillOldRoute to IPLIB   {  8/16/85     cwj   Change comments re: global variables   {  8/20/85     cwj   Add ProSw error return logging   "{  8/22/85     cwj   Restart processing after Confirm_Dpath received " {  8/23/85     cwj   Set Redundant Frag dropping debug flags  {                    Restarting Sends after all Confirm_Dpaths  !{  8/26/85     cwj   Ensure error variable initialized in routines ! #{                    Add parameters to AnhPrStatesLink to set & clear  # {                       states for each path record processed.  #{                    Use AnhPrStatesLink in AbortDpath & ConfirmDpath  # {  ----- posted -----   {  9/3/85      cwj   Changes for Connectionless path handling   &{  9/11/85     cwj   Changes for Counting Confirm Dpath on errors correctly  & {                    Not counting KILL_INDICATIONS  {                    Remove gv_in_emscnt  {                    Move KillEmsg to IPPCTL  {                    Misc emsg count corrections  "{  9/12/85     cwj   Correct KillOldRoute processing in ConfirmDpath " {                    Remove DS_IncWd  {  9/13/85     cwj   StartClTimer when appropriate  !{  9/14/85     cwj   Clear connectionless path's age when its used ! {  9/17/85     cwj   Count Inbound S&F in ULP_UP_EMSCNT   {  ----- N145 Submittal -----   {  9/19/85     cwj   Check Ack Thresh for All S&F messages  "{                    Check Ack Thresh for Reassembly if reass is not " {                    complete   {                    Build CCP - remove TRIGGER code   {  9/20/85     cwj   Minor corrections to RedirectSource routine   {  9/26/85     cwj   Initialize error parameters  {  ----- N152 Submittal -----   {  9/30/85     cwj   Move Trcmod IMPORT before sigmod IMPORT  {  ----- N172 Submittal -----   {  10/31/85    cwj   RCB list maintainance fixes  {  ----- N185 Submittal -----   ${  10/9/85     cwj   Clear the ANH PENDING state on ABORT DPATH receipt  $ {  ----- N176 Submittal -----   {  11/5/85     cwj   Add Part Number  {  11/6/85     cwj   Add Module Alias   {  11/18/85    cwj   CCP out TRGLB references   {  ----- N209 Submittal -----   {  11/21/85    cwj   Handle ABORT DPATH cleanup better  {  ----- N220 Submittal -----   {  12/18/85    cwj   Out of order reassembly fix  {  ----- N247 Submittal -----   {  12/30/85    cwj   ICMP error logging fixed   {  12/31/85    cwj   ICMP msgs recvd on wrong path SR# 031849   #{                    Event logs with incorrect length fixes SR# 031708 # "{                    TTL processing changes for Intersystem Testing  " {                    Remove redundant constant  {  ----- N262 Submittal -----    {  1/9/86      cwj   IP should not call PROBE Outbound in INPRO    {  ----- N286 Submittal -----   {  1/14/86     cwj   Move LLP emsg counts to ANH record   {  ----- N302 Submittal -----   {  ----- N352 Submittal -----   !{  2/18/86     cwj   Log ABORT DPATH receipt as ERROR not WARNING  ! {                       SR# 034355  {  3/11/86     cwj   ICMP fetching wrong path record Bug Fix  {                       SR# 034280  ${                    Checksum error on ICMP message results in redundant $ {                       Kill_Request to LLP.  {                       SR# 034264  #{                    Ack Thresh Check on redundant fragment may cause  #  {                       the entire message to be dropped bug fix   {                       SR# 034256  ${                    KILL_INDICATION receipt now processes all ANH recs  $ {                       with given dnpid/dnpath.  {                       SR# 034306  "{  3/12/86     cwj   ICMP msgs should not be send for errors on ICMP " {                       messages - bug fix  {                       SR# 034272  %{                    S&F inbound message should be dropped if destination  % {                       network is unknown.   {  3/19/86     cwj   Test for node on DCN bug fix.  {                       SR# 034223  {  ----- N395  Submittal -----   {  4/2/86      cwj   Add hooks to turn off memory borrowing for    {                    S&F messages.  ${              cwj   Modifications for Outbound message queue LIFO->FIFO $ {                    conversion   {                       SR# 035451  "{              cwj   Drop ICMP messages on completion of processing. " {                       SR# xxxxxx  {              cwj   ICMP node reporting correction.  {                       SR# 033035  ${  4/4/86      cwj   Mark Header as updated when setting checksum to 0.  $ {  ----- Nxxx  Submittal -----  {}  {  End of Modification section  ${----------------------------------------------------------------------- $ {}      {}  { MODULE DESCRIPTION:   {    {  This module contains the IP Inbound procedures and functions.   {   {  This module contains the following things:   {   
{     IMPORT Section 
 {        BODEC imported for the general global declarations   #{        SODEC imported for the socket and event message declarations  # {   
{     EXPORT Section 
 ${        This contains the declarations for the IP Inbound routines that $ {        will be called by the ProSw routine:   {   {     FORWARD Procedure Decls   !{        The remainder of the Inbound routines are declared here.  ! {   {     Procedure Declarations  {        The IP Inbound routines are implemented.   {   {}      $TITLE 'IMPORT Section',PAGE$       IMPORT                  $SEARCH 'phtm/bodec.xpt'$      bodec,               $SEARCH 'phtm/sodec.xpt'$      sodec,               $SEARCH 'phtm/mmdec.xpt'     mmdec,               $SEARCH 'phtm/mmext.xpt'$      ds_mm,               $SEARCH 'phtm/trcmod.xpt'$     trcmod,              $SEARCH 'phtm/sigmod.xpt'$     sigmod,              $SEARCH 'phtm/tmrdec.xpt'$     tmrdec,              $SEARCH 'phtm/tuser.xpt'$      tuser,               $SEARCH 'phtm/ipdec.xpt'$      ipdec,               $SEARCH 'phtm/ipdb.xpt'$     ipdb,              $SEARCH 'phtm/iplib.xpt'$      iplib,               $SEARCH 'phtm/ippctl.xpt'$     ippctl,              $SEARCH 'phtm/ipactp.xpt'$     ipactp;      $TITLE 'EXPORT Section',PAGE$   EXPORT      PROCEDURE InAbortDpath             (VAR emsg_recvd : EventMsgType);       	PROCEDURE Inbound  	            (VAR emsg_recvd : EventMsgType;              VAR result     : Int16 );       PROCEDURE InConfirmDpath             (VAR emsg_recvd : EventMsgType);       
PROCEDURE InDataIndication 
            (VAR emsg_recvd : EventMsgType);       
PROCEDURE InKillIndication 
            (VAR emsg_recvd : EventMsgType);       	PROCEDURE InStubb  	            (VAR emsg_recvd  : EventMsgType;               VAR result      : Int16 );      IMPLEMENT       $TITLE 'Forward/External Decl',PAGE$  {------------------------------------------------------------}  {              Forward/External Declarations                 }  {------------------------------------------------------------}      
PROCEDURE AnhPrStatesLink  
            (    clearstates : PrStateSetType;                   setstates   : PrStateSetType;                   kireason    : Int16);   
            FORWARD; 
     PROCEDURE AppendFragDesc             (VAR iphead : IpHeaderType;              VAR result : Int16);  
            FORWARD; 
     PROCEDURE AssembleMsg              (VAR rcb    : RcbType;               VAR mbufid : MbufIdType;              VAR result : Int16);  
            FORWARD; 
     	PROCEDURE BuildRcb 	            (    pathref : Int16;                  msgid   : Int16;                  time    : Int16;              VAR mbufid  : MbufIdType;               VAR rcb     : RcbType;              VAR backref : MbufIdType;               VAR result  : Int16 );  
            FORWARD; 
     PROCEDURE FetchIcmpHead              (    head_mbuf   : MbufIdType;                   startoffset : Int16;              VAR icmphead    : IcmpHeadType;               VAR result      : Int16);   
            FORWARD; 
     
PROCEDURE FindAnhRec 
            (    start_index    : Int16;                   pid            : Int16;                   path_ref       : Int16;               VAR result         : Int16);  
            FORWARD; 
     	PROCEDURE FindRcb  	            (    pathref : Int16;                  msgid   : Int16;              VAR rcb     : RcbType;              VAR backref : MbufIdType;               VAR result  : Int16 );  
            FORWARD; 
     PROCEDURE FragRedundant              (    frag       : FragDescType;              VAR holefilled : Int16);  
            FORWARD; 
     
PROCEDURE IcmpDestUnreach  
            (VAR emsg : EventMsgType);   
            FORWARD; 
     PROCEDURE IcmpGetPath              (    mbufid : MbufIdType;                  msgtype : Int16;              VAR result  : Int16 );  
            FORWARD; 
     PROCEDURE IcmpInbound              (VAR emsg   : EventMsgType;              VAR result : Int16);  
            FORWARD; 
     PROCEDURE IcmpMsgIgnore              (VAR emsg : EventMsgType);   
            FORWARD; 
     PROCEDURE IcmpRtnInfo              (VAR emsg : EventMsgtype);   
            FORWARD; 
     
PROCEDURE IcmpSourceQuench 
            (VAR emsg : EventMsgtype);   
            FORWARD; 
     PROCEDURE InsertFragment             (VAR rcb            : RcbType;               VAR newfrag        : FragDescType;              VAR reass_complete : BOOLEAN );   
            FORWARD; 
     PROCEDURE IpDataInbound              (VAR emsg_recvd : EventMsgType);   
            FORWARD; 
     
PROCEDURE NotifySourceNode 
            (    icmptype : PosInt8;                   icmpcode : PosInt8 );   
            FORWARD; 
     PROCEDURE ProSw              (VAR emsg   : EventMsgType;              VAR result : Int16);              EXTERNAL;       PROCEDURE ReassAckThresh             (    rcb  : RcbType;                   backref : MbufIdType;                   frag : FragDescType);   
            FORWARD; 
     PROCEDURE ReassembleMsg              (VAR mbufid   : MbufIdType;              VAR msglen   : Int16;               VAR opt_mbuf : MbufIdType;              VAR pathref  : Int16;               VAR result   : Int16 );   
            FORWARD; 
     PROCEDURE RedirectSource             (    icmpcode : PosInt8;                   anhnode  : Int32);  
            FORWARD; 
     PROCEDURE SfEchoInbound              (VAR emsg_recvd : EventMsgType);   
            FORWARD; 
     PROCEDURE ValidateIpMsg              (VAR error      : Int16);  
            FORWARD; 
     
$TITLE 'Procedures',PAGE$  
 {------------------------------------------------------------}  {              Procedures                                    }  {------------------------------------------------------------}      $TITLE 'AnhPrStatesLink',PAGE$  {------------------------------------------------------------}  {           AnhPrStatesLink                                  }  {------------------------------------------------------------}      
PROCEDURE AnhPrStatesLink  
            (    clearstates : PrStateSetType;                   setstates   : PrStateSetType;                   kireason    : Int16);       {}  { Description   ${     This routine will set and clear the states and kireason passed as  $ ${     input from each path record linked off of the current ANH record.  $ #{     It will also relink these records to the appropriate processing  # {     queue depending on the state changes.   {   {     This routine leaves the current path record set to some   #{     arbitrary path record, NOT to the record that was set on entry.  # {}  { Parameters  !{     clearstates IN    The set of path states to clear from each  ! {                       path record processed.  !{     setstates   IN    The set of path states to set in each path ! {                       record processed.   "{     kireason    IN    The KILL_INDICATION reason to set into each  " {                       path record processed.  {}  { Global Data Structures  #{     gv_anh_rec     IN       The ANH record containing the list head  # ${     gv_path_rec    IN/OUT   Storage for the path records that will be  $ {                             processed.  {}  CONST      SUBR = SubrAnhPrStates;    { Subroutine ID for logging }       VAR   	   link  : Int16;  	 	   error : Int16;  	    pathstates : PrStateSetType;      killreason : Int16;      
BEGIN { AnhPrStatesLink }  
 WITH gv_anh_rec, gv_path_rec DO      BEGIN { WITH Global Variables }     { Fetch the head of the list linkage      {}      link := ah_pr_link;     WHILE link <> END_OF_LIST DO         BEGIN { WHILE more on the list }        FetchPathRec (link, error);         IF error <> 0 THEN           BEGIN { IF error on fetch of path }           IpErrorLog (EL_DISASTER, error, link, SUBR+PATHFAIL);           link := END_OF_LIST;            END   { IF error on fetch of path }         ELSE            BEGIN { ELSE have path rec }            { Save the original words to be changed           { Change the words, and then see if anything is           { different. This is to save the restore to DSAM step           { required if something changes.            {}            pathstates := pr_states;            killreason := pr_ki_reason;           pr_states := pr_states - clearstates + setstates;           pr_ki_reason := kireason;               IF (pathstates <> pr_states) OR              (pr_ki_reason <> killreason) THEN UpdatedPr;      !         { Ensure that this path rec is linked to the appropriate  !          { processing queue.  "         { Then reset the linkage for the next trip around the loop  "          {}   
         StatesLink; 
          link := pr_anh_link;            END;  { ELSE have path rec }             END;  { WHILE more on the list }         END;  { WITH Global Variables }  
END;  { AnhPrStatesLink }  
     $TITLE 'AppendFragDesc',PAGE$   {------------------------------------------------------------}  {           AppendFragDesc                                   }  {------------------------------------------------------------}      PROCEDURE AppendFragDesc             (VAR iphead : IpHeaderType;              VAR result : Int16 );       {}  { Description   {     This routine will remove the IP Header from the message,  "{     leaving the data, and will add space for the Frag Descriptor.  " "{     PostFrag will overwrite this area to post the frag descriptor. " {}  { Parameters  ${     iphead   IN       The ip header data structure that describes the  $ {                          message fragment.  ${                       This is used to get the mbufid of the fragment.  $ {   {     result      OUT   The result of this operation.   #{                          ips_GOOD_RETURN - Frag desc space appended. #  {                          MMGR error - Frag space not appended.   {}  { Global Data Structures  
{     gv_ip_head  IN 
 {}  { Error Handling  {}  CONST       SUBR = SubrAPPENDFRAG;   { Subroutine ID number for logging }       VAR   	   error : Int16;  	    frag  : FragDescType;      BEGIN { AppendFragDesc }  	WITH gv_ip_head DO 	    BEGIN { WITH Global Variables }     error := 0;         { Remove the IP Header & Options }      DS_MAdj (iphd_mbufid, iphd.w1.headlen*4, error);      IF error = ips_GOOD_RETURN THEN            BEGIN { IF MMGR call succeeds }          DS_MAppendHead (frag.bufr, FRAG_BLEN, iphd_mbufid, error);         END;  { IF MMGR call succeeds }          IF error <> ips_GOOD_RETURN THEN         BEGIN { IF MMGR call failed }         IpErrorLog (EL_ERROR, error, 0, SUBR);        END;  { IF MMGR call failed }       
   result := error;  
    END;  { WITH Global Variables }  END;  { AppendFragDesc }      
$TITLE 'AssembleMsg',PAGE$ 
 {------------------------------------------------------------}  {           AssembleMsg                                      }  {------------------------------------------------------------}      PROCEDURE AssembleMsg              (VAR rcb    : RcbType;               VAR mbufid : MbufIdType;              VAR result : Int16);      {}  { Description   %{     This routine will take a message in DSAM, linked by frag descriptors % {     and assemble the message into a complete message.   #{     It will take care of trimming each piece to fit by adjusting off # {     of the head as necessary.   "{     There must be no gaps in the message on calling this routine.  " {     It will not check for gaps.   {}  { Parameters  "{     rcb      IN/OUT    The RCB that contains the head of the list  " {                        for all fragments for this message.  &{                        The RCB statistics will be updated by this routine. & {   {     mbufid      OUT    The mbufid of the assembled message.   {   !{     result      OUT    0 => the message was assembled correctly. ! ${                        else = the message was assembled, but it needs  $ #{                               to be discarded since it is assembled  # {                               incorrectly.  {}  { Side Effects  {}  { Global Data Structures  {     gv_path_rec    IN    path index is logged with errors   {}  { Error Handling  {}  { Algorithm   {}  LABEL      99;   { Error Exit Point }       CONST       SUBR = SubrASSEMBLEMSG;  { Subroutine ID number for logging }   
      ADJUST_PROBLEM = 1;  
 
      CONCAT_PROBLEM = 2;  
 
      STILL_HOLES    = 3;  
 
      NO_FIRST_FRAG  = 4;  
     VAR   	   error : Int16;  	 #   msg   : FragDescType;   { Fragment descriptor for entire message }  # #   frag  : FragDescType;   { Fragment descriptor for each fragment  }  #     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { AssembleMsg }   error  := 0;  
result := ips_GOOD_RETURN; 
     WITH rcb, gv_path_rec DO     BEGIN { WITH rcb }      { The mbufid of the first data fragment is rcb_frag.link      { Remove the frag descriptor from that fragment,      { and set the link to the next fragment.      {}      mbufid := rcb_frag.link;      RemovefragDesc (mbufid, msg);  
   IF msg.first <> 0 THEN  
        BEGIN { IF first fragment doesn't start at the beginning }         error := ips_MSG_NOT_COMPLETE;  #      IpErrorLog (EL_DISASTER, error, pr_pathref, SUBR+NO_FIRST_FRAG); #       Exit;          END;  { IF first fragment doesn't start at the beginning }          WHILE msg.link <> END_OF_LIST DO         BEGIN { WHILE have another fragment }         RemoveFragDesc (msg.link, frag);        IF msg.last+1 < frag.first THEN            BEGIN { IF there is still a hole in the message }           { The current fragment does not have a frag           { descriptor, so glue it on before terminating.           {}            DS_MCat (mbufid, msg.link, error);                error := ips_MSG_NOT_COMPLETE;   $         IpErrorLog (EL_DISASTER, error, pr_pathref, SUBR+STILL_HOLES);  $          Exit;           END;  { IF there is still a hole in the message }      "      DS_MAdj (msg.link, ( (msg.last + 1) - frag.first )*8 , error); "       IF error <> ips_GOOD_RETURN THEN           BEGIN { IF error on adjust of message }  %         IpErrorLog (EL_DISASTER, error, pr_pathref, SUBR+ADJUST_PROBLEM); %          Exit;           END;  { IF error on adjust of message }            { Count the # of successful trims done        {}  &      IF msg.last + 1 <> frag.first THEN rcb.rcb_trims := rcb.rcb_trims + 1; &           { Update the 'last' fragment offset field         {}        IF msg.last < frag.last THEN msg.last := frag.last;             DS_MCat (mbufid, msg.link, error);        msg.link := frag.link;        IF error <> 0 THEN               BEGIN { IF error on concatenation }  %         IpErrorLog (EL_DISASTER, error, pr_pathref, SUBR+CONCAT_PROBLEM); %          Exit;           END;  { IF error on concatenation }            END;  { WHILE have another fragment }          END;  { WITH rcb }       
99:   { Exit Point } 
 result := error;  END;  { AssembleMsg }       $TITLE 'BuildRcb',PAGE$   {------------------------------------------------------------}  {           BuildRcb                                         }  {------------------------------------------------------------}      	PROCEDURE BuildRcb 	            (    pathref : Int16;                  msgid   : Int16;                  time    : Int16;              VAR mbufid  : MbufIdType;               VAR rcb     : RcbType;              VAR backref : MbufIdType;               VAR result  : Int16 );      {}  { Description    {     This routine will build an RCB and link it onto the global   {     reassembly queue.   {     It will build the RCB by appending it to the head of the  !{     current message fragment and then splitting it off into its  ! {     own seperate mbuf.  {     This ensures that memory is correctly accounted for.  {   !{     WARNING, due to implementation considerations in the memory  !  {     manager, mbuf chains that have been split should not have    {     data appended to the split ends. It is possible in some    {     such circumstances that some of the data referenced in the   {     other chain could be overwritten.   {   !{     This is not currently a problem since the message fragments  !  {     are concatenated only after the entire message arrives and   {     the RCB is no longer required.  {   {}  { Parameters  #{     pathref  IN       The Path reference that the message queued on  # {                       this RCB is associated with.  {   {     msgid    IN       The msgid for this RCB.   {   "{     time     IN       The time out value to be used for this RCB.  " !{                       (This is the number of seconds from now).  ! {   ${     mbufid   IN/OUT   The mbufid of the fragment that will supply the  $ #{                       memory for this RCB. It may change as a result # {                       of this call.   {   &{     rcb         OUT   The Reassembly Control Block build by this routine.  & {   ${     backref     OUT   The MbufId of the RCB previous to this one built $ {   {     result      OUT   The result of the operation.  #{                       ips_GOOD_RETURN - It was successful and 'rcb'  # {                             contains a valid record.  "{                       else - rcb does NOT contain a valid record.  " {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   %{     The RCB will be built using the memory reclaimed from the IP header, % "{     and any lower level header that may have been on the message.  " {   &{     Appending the RCB may require an additional mbuf. If this is the case, & "{     and the memory is not available, this message will be dropped. " {   #{     To allocate an mbuf containing the RCB, BuildRcb will append the # {     RCB to the fragment's head, and then split it off.  {   ${     WARNING: Due to implementation considerations, nothing should ever $ %{     be appended to the  data buffer until the RCB is no longer required. % {   {}  LABEL   
   99;      { Exit Label } 
     CONST       SUBR = SubrBUILDRCB;     { Subroutine ID number for logging }      APENDHD  = 1;      { Error Logging Qualifier }      RCBSPLIT = 2;      { Error Logging Qualifier }          NO_SPLITTHRESH  = 0;          FIRST_FRAG_DESC = FragDescType [link  : END_OF_LIST,                                      first : -1,                                     last  : -1,                                      mbufid: RCB_MBUFID_UNKNOWN];           INIT_RCB = RcbType [rcb_frag            : FIRST_FRAG_DESC,                          rcb_link            : END_OF_LIST,                          rcb_time            : 0,                          rcb_pathref         : 0,                          rcb_msgid           : 0,                          rcb_trims           : 0,                          rcb_frags_in        : 0,                          rcb_newfrags_unused : 0,                          rcb_oldfrags_unused : 0,                          rcb_stat_rsvd       : 0,   !                       rcb_mbufid          : RCB_MBUFID_UNKNOWN];  !         TYPE     ContextType = RECORD CASE Int16 OF         0: (longint : Int32);         1: (int     : Int16);   
      2: (pathref : Int16; 
           mbufid  : MbufIdType);        END;  { ContextType }       VAR   	   error : Int16;  	 	   dlen  : Int16;  	 
   context : ContextType;  
     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     	BEGIN { BuildRcb } 	 error := 0;       { Initialize the RCB }  rcb := INIT_RCB;  rcb.rcb_pathref := pathref;   
rcb.rcb_msgid   := msgid;  
     DS_MAppendHead (rcb.rcb_bufr, RCB_BLEN, mbufid, error);   IF error <> ips_GOOD_RETURN THEN     BEGIN { IF appendhead failed }      context.pathref := pathref;     context.mbufid  := mbufid;      IpErrorLog (EL_DISASTER, error, context.int, SUBR+APENDHD);     Exit;     END;  { IF appendhead failed }       {}  { RCB successfully appended to the fragment   {}  { Split off the RCB into a seperate mbuf }  { and record both mbufids since they may change.  {}  	dlen := RCB_BLEN;  	  DS_MSplit (mbufid, dlen, NO_SPLITTHRESH, rcb.rcb_mbufid, error);   IF error <> ips_GOOD_RETURN THEN     BEGIN { IF Msplit failed }   "   IpErrorLog (EL_DISASTER, error, rcb.rcb_pathref, SUBR+RCBSPLIT);  "    Exit;     END;  { IF Msplit failed }       {}  { RCB has its own mbufid  {     Record it in the fragment descriptor associated with it   {}  rcb.rcb_frag.mbufid := rcb.rcb_mbufid;  PostFrag (rcb.rcb_frag);      { Link the RCB onto this RCB List   {}  RcbLink (time, rcb, backref, error);      99:      { Exit Point }   	result   := error; 	 	END;  { BuildRcb } 	     $TITLE 'FetchIcmpHead',PAGE$  {------------------------------------------------------------}  {           FetchIcmpHead                                    }  {------------------------------------------------------------}      PROCEDURE FetchIcmpHead              (    head_mbuf   : MbufIdType;                   startoffset : Int16;              VAR icmphead    : IcmpHeadType;               VAR result      : Int16);       {}  { Description   {     This routine will fetch the ICMP header (following the  !{     initial IP header) on the message refered to by the mbufid.  ! {}  { Parameters  {   {   {   {   {   {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}  LABEL      99;   { Exit Point }       CONST      SUBR  =  SubrFETCHICMPHEAD;      VAR   
   mmflags : MMFlagsType;  
 
   error   : Int16;  
     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
 
      END;  { Exit } 
     BEGIN { FetchIcmpHead }   error := 0;       mmflags.int      := 0;     { Clear all flags    }   mmflags.bits [0] := TRUE;  { Copy, don't delete }       !DS_MRead (icmphead.bufr, BYTES_ICMP_HEAD, head_mbuf, startoffset,  !                          mmflags, error);       IF (error <> ips_GOOD_RETURN) AND      (error <> MMTOOFEWBYTES  ) THEN     BEGIN { IF error on read of ICMP header }     IpErrorLog (EL_DISASTER, error, 0, SUBR);     Exit;     END;  { IF error on read of ICMP header }      
99:   { Exit Point } 
 result := error;  END;  { FetchIcmpHead }       
$TITLE 'FindAnhRec',PAGE$  
 {------------------------------------------------------------}  {                 FindAnhRec                                 }  {------------------------------------------------------------}      
PROCEDURE FindAnhRec 
            (    start_index    : Int16;                   pid            : Int16;                   path_ref       : Int16;               VAR result         : Int16);  {}  { Description   !{     This routine will find the active ANH record with the given  !  {     down PID/Path pair, or return ips_ANH_NOT_FOUND in result.   {}  { Parameters   {     start_index       IN      Index of ANH rec to start search   {     pid               IN      PID of LLP in ANH record  {     path_ref          IN      Path Ref of LLP in ANH record   {   {     result               OUT  result may have two values:   {   ${                    ips_GOOD_RETURN      = The valid ANH rec was found  $ {                    ips_ANH_NOT_FOUND    = It was NOT found.   {}  { Side Effects  "{     gv_anh_rec will contain the ANH record found by this routine.  " {   {}  { Global Data Structures  "{     gv_anh_rec     OUT      The ANH record found by this routine,  " {                             or garbage.   {}  { Error Handling  #{     If the record is not found, an error is returned to the caller.  # {     (see the result parameter above).   {}  { Algorithm   ${     gv_anh_rec is first checked to see if it contains a valid copy of  $ {     the deired record.  {   !{     Failing that, DSAM is searched for an active record with the ! {     proper searchkeys.  {   ${     NOTE that DS_SerialF&F requires that the searchkeys be contiguous. $ #{     Since there are several searchkeys for ANH records that rely on  # #{     the link word as one of the fields in each key, it is difficult  # {     to keep the search fields contiguous.   {}         CONST        { Length of search field }        KEY_LENGTH = 2;          TYPE         { Record Declaration for Down PID/Path search }             DnPathSkeyType = RECORD            CASE Int16 OF                  0: (bufr : BufferType );                  1: (pid      : Int16;                   path_ref : Int16 );                   END;  { AhDnPathSkeyType }         VAR        searchkey  : DnPathSkeyType;      
      index      : Int16;  
 
      startindex : Int16;  
     
      error      : Int16;  
       rec_found  : BOOLEAN;          BEGIN { FindAnhRec }      WITH gv_anh_rec DO         BEGIN { WITH Global Variables }             { Initialize the return and error variables }         result := ips_GOOD_RETURN;        error  := ips_GOOD_RETURN;            {}        { Post the Local Record to DSAM if necessary        {}  
      SaveAnhState;  
           { Set up the search key }         searchkey.pid      := pid;        searchkey.path_ref := path_ref;             { Go try and find it in DSAM }  
      rec_found := FALSE;  
       error := ips_GOOD_RETURN;         startindex := start_index;            WHILE (error = ips_GOOD_RETURN)  AND              (NOT rec_found)            DO                BEGIN { WHILE }           { Until not found or until indicies overlap,            { look for a valid Anh record.            {}            DS_SerialFindAndFetchFields (DS_IP_Anh_Rec_TD,               startindex, MAXINT16,               ah_PID_OFSET, KEY_LENGTH, searchkey.bufr,               NO_OFSET, ah_MAX_WORDS, ah_bufr,  
            index, error); 
              { Is it a valid record?           { It must be inuse, i.e. NOT on the Free List           {}            IF (error = ips_GOOD_RETURN  ) AND               (ah_free_link <> REC_INUSE) THEN                  BEGIN { IF Found a candidate }              { This is a free record, look again. }              startindex := index + 1;              END   { IF Found a candidate }                ELSE IF error = ips_GOOD_RETURN THEN                  BEGIN { ELSE Found the record }               rec_found := TRUE;              END;  { ELSE Found the record }                END;  { WHILE }               IF error = ips_GOOD_RETURN THEN                  BEGIN { IF Valid record found }               { Found the record we were looking for.               { Set up the housekeeping fields.               {}              ah_rec_status := VALID_DATA;              ah_index      := index;               result        := ips_GOOD_RETURN;               END   { IF Valid record found }                 ELSE                  BEGIN { ELSE Valid record not found }               ah_index      := NO_INDEX;              ah_rec_status := INVALID_DATA;              result        := ips_ANH_NOT_FOUND;               END;  { ELSE Valid record not found }             END;  { WITH Global Variables }      END;  { FindAnhRec }       $TITLE 'FindRcb',PAGE$  {------------------------------------------------------------}  {           FindRcb                                          }  {------------------------------------------------------------}      	PROCEDURE FindRcb  	            (    pathref : Int16;                  msgid   : Int16;              VAR rcb     : RcbType;              VAR backref : MbufIdType;               VAR result  : Int16 );      {}  { Description   !{     This routine will search for the RCB containing the 'msgid'  ! #{     passed in. It is used to find the reassembly queue that contains # "{     the partially reassembled message that a fragment belongs to.  " {}  { Parameters  ${     pathref  IN       The pathreference that the message is associated $ {                       with.   {   {     msgid    IN       Search Key. The IP message identifier.  {   {     rcb         OUT   The Reassembly control block found.   {   {     backref     OUT   The Mbufid of the Previous RCB  {   {     result      OUT   The result of the search:   ${                          ips_GOOD_RETURN - The RCB was found and is in $ !{                                            the 'rcb' parameter.  ! %{                          ips_RCB_NOT_FOUND - 'rcb' is meaningless as the % %{                                            control block was not found.  % {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  {     The control block will either be found, or not.   {}  { Algorithm   {     see below.  {}  LABEL      99;   { Error Exit point }       CONST       SUBR = SubrFINDRCB;      { Subroutine ID number for logging }       VAR   
   error   : Int16;  
 
   mmflags : MMFlagsType;  
    found   : BOOLEAN;      link    : MbufIdType;      	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     	BEGIN { FindRcb }  	 { Initialize the MMGR call parameter }  {     the backwards list linkage     }  {     the RCB found flag             }  {     the error return parameter     }  {}  mmflags.int       := 0;    { Clear all flags }  mmflags.bits [0]  := TRUE; { Preview Data }   found             := FALSE;   error             := ips_GOOD_RETURN;       
backref := GLOBAL_BLK_RCB; 
 link    := gv_ip_globals.ipg_reass_que;   WHILE ( (link <> END_OF_LIST   ) AND          (NOT found             )    ) DO     BEGIN { WHILE processing RCBs }  #   DS_MRead (rcb.rcb_bufr, RCB_BLEN, link, NO_OFSET, mmflags, error);  #    IF error <> ips_GOOD_RETURN THEN         BEGIN { IF MMGR call failed }         IpErrorLog (EL_ERROR, error, 0, SUBR);  
      link := END_OF_LIST; 
       rcb := READ_FAIL_RCB;         RcbUnLink (rcb, backref);         Exit;         END;  { IF MMGR call failed }          { Have an RCB     {}      IF (rcb.rcb_pathref = pathref) AND         (rcb.rcb_msgid   = msgid  ) THEN            BEGIN { IF Found RCB }        { Terminate the loop, the back link is already set,         { set up the rcb_mbufid housekeeping field.         {}        found          := TRUE;         rcb.rcb_mbufid := link;         END   { IF Found RCB }          ELSE            BEGIN { ELSE this one is NOT it }         { Record the current link as the next back_link         { and Set the link for the next loop        {}        backref := link;        link    := rcb.rcb_link;        END;  { ELSE this one is NOT it }          END;  { WHILE processing RCBs }      IF NOT found THEN error := ips_RCB_NOT_FOUND;       99:     { Error Exit Point }  	result  := error;  	 	END;  { FindRcb }  	     $TITLE 'FragRedundant',PAGE$  {------------------------------------------------------------}  {           FragRedundant                                    }  {------------------------------------------------------------}      PROCEDURE FragRedundant              (    frag       : FragDescType;              VAR holefilled : Int16);  {}  { Description   "{     This routine will be used to determine if a fragment queued in " {     a reassembly list (off of some RCB), is redundant.  !{     It will do this by returning in 'holefilled' the location of ! {     the next hole assuming 'frag' is ignored.   {   {     It requires that 'holefilled' is set correctly on entry.   {     (i.e. to the largest 'frag.last+1' value for all fragments   "{           queued before the test fragment passed to this routine)  " {}  { Parameters  !{     frag     IN       The fragment being tested for redundancy.  ! {   "{     holefilled IN/OUT On input, this is the start of the last hole " {                       found before looking at 'frag'.   "{                       On output, it is the start of the first hole "  {                       that would be uncovered were, 'frag' to    {                       be dropped.   {}  VAR      nextfrag : FragDescType;       BEGIN { FragRedundant }   GetFrag (frag.link, nextfrag);      IF (holefilled >= nextfrag.first) AND   $   (nextfrag.last > holefilled)   THEN holefilled := nextfrag.last + 1;  $     WHILE nextfrag.first < frag.last DO      BEGIN { WHILE next frag overlaps frag }     GetFrag (nextfrag.link, nextfrag);      IF (holefilled >= nextfrag.first) AND  %      (nextfrag.last > holefilled)   THEN holefilled := nextfrag.last + 1; %        END;  { WHILE next frag overlaps frag }      END;  { FragRedundant }       $TITLE 'IcmpDestUnreach',PAGE$  {------------------------------------------------------------}  {           IcmpDestUnreach                                  }  {------------------------------------------------------------}      
PROCEDURE IcmpDestUnreach  
            (VAR emsg : EventMsgType);       {}  { Description   #{     This routine will process the Destination unreachable messages.  # #{     If the message indicates that there is no possibility of getting # "{     to the destination (with current IP routing algorithms), then  " ${     a KILL_INDICATION will be generated to the ULP with an appropriate $ {     reason.   {   "{     The message will be dropped as there is no further use for it. " {}  { Parameters  {     emsg  IN/OUT   The event message received.  {}  { Side Effects  {}  { Global Data Structures  {     gv_icmp_msg    IN/OUT   {     gv_path_rec    IN/OUT   {}  { Error Handling  {}  { Algorithm   {   {}  LABEL      99;   { Exit Point }       CONST      SUBR = SubrICMPDSTUNREACH;       VAR   
   error    : Int16; 
 
   icmpcode : Int16; 
     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     
BEGIN { IcmpDestUnreach }  
 WITH emsg, gv_ip_head, gv_icmp_msg, gv_path_rec DO  	   BEGIN { WITH }  	    { Find Appropriate Path record      {}      IcmpGetPath (emdi_mbufid, icmp_tc.msgtype, error);      IF error <> ips_GOOD_RETURN THEN         BEGIN { IF can't get appropriate path record }        IpErrorLog (EL_RESOURCELIM, error, 0, SUBR);        IcmpMsgIgnore (emsg);         Exit;         END;  { IF can't get appropriate path record }      #   { If this path is a connectionless path, indicate that it has been  # 	   { recently used 	    {}      IF (pr_path_type = pr_REFED_CONNECTLESS)   OR        (pr_path_type = pr_UNREFED_CONNECTLESS) THEN        BEGIN { IF connectionless path }        pr_cl_idletime := cl_PATH_NOT_IDLE;         END;  { IF connectionless path }         WITH pr_statistics DO        st_dataind_dn := st_dataind_dn + 1;      UpdatedPr;          { Log the arrival of this event message     {}   !   IcmpErrorLog (SUBR, EL_ERROR, icmp_tc.msgtype, icmp_tc.msgcode, ! $                        pr_remote, iphd.src, redirect.gateway.longint);  $        { Set up the icmpcode variable      { So both Dest Unreachable codes and TTL exceeded codes     { are unique in the error code generated.     {}      icmpcode := icmp_tc.msgcode;   "   IF icmp_tc.msgtype = TIME_EXCEEDED THEN icmpcode := icmpcode - 2; "        { Set the Kill Indication fields and state      {}      pr_states := pr_states + [cst_SEND_KILL_UP];      pr_ki_reason := ips_DEST_UNREACH + icmpcode;      StatesLink;     UpdatedPr;          { Record the offered route      {}      pr_in_dnpid := emdi_down_pid;     pr_in_dnpath := emdi_down_ref;      pr_states := pr_states + [cst_HAVE_IN_ROUTE];     UpdatedPr;      StatesLink;         { Dispose of this message as it is of no further use.     {}      DropMessage (emdi_mbufid);          { And let the state processing be done as normal      {}   	   END;  { WITH }  	     
99:   { Exit Point } 
 
END;  { IcmpDestUnreach }  
     
$TITLE 'IcmpGetPath',PAGE$ 
 {------------------------------------------------------------}  {           IcmpGetPath                                      }  {------------------------------------------------------------}      PROCEDURE IcmpGetPath              (    mbufid : MbufIdType;                  msgtype : Int16;              VAR result  : Int16 );  {}  { Description    {  This routine will fetch the appropriate path record to use in   "{  processing the ICMP message.  The address information in the old  " %{  IP header following the ICMP message is used to fetch this information. % {   {}  { Parameters  {     mbufid   IN       The mbufid of the ICMP message in DSAM  {     msgtype  IN       The ICMP message type   {     result      OUT   The result of this operation  #{                       0 = Good return, gv_path_rec contains the path # {   {}  { Global Data Structures  %{     gv_path_rec    OUT The global variable where the path record will be % {                        returned.  
{     gv_ip_head  IN 
 {}  { Error Handling  {     Any errors encountered will be returned to the caller.  {}  { Algorithm   {   {}  LABEL      99;   { Exit Point }       CONST      PATHKEYSLEN = 12;    { Bytes in Pathkeyslen }  %   OLDHDTTLOFFSET = 16; { Byte offset of TTL byte in Old header portion  } % %                        { of the ICMP message                            } %     TYPE     PathKeysType = RECORD  
      CASE Int16 OF  
          0: (bufr : BufferType);           1: (pkwd    : IpWord5Type;                pk_sum  : Int16;                pk_src  : Int32;                pk_dst  : Int32);           END;  { PathKeysType }       VAR      pathkeys : PathKeysType;   
   mmflags  : MMFlagsType; 
 
   error    : Int16; 
    msgoffset : Int16;       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { IcmpGetPath }   WITH gv_ip_head, pathkeys DO  	   BEGIN { WITH }  	    { Initialize the error variable     {}      error := ips_GOOD_RETURN;         { Set up the message offset to use for the pathkeys     {}   	   CASE msgtype OF 	       REDIRECT,   
      SOURCE_QUENCH, 
 
      TIME_EXCEEDED, 
 
      DEST_UNREACH , 
 
      OPTIONS_PRAM_PROB :  
          BEGIN           msgoffset := iphd.w1.headlen*4 + OLDHDTTLOFFSET;            END;             OTHERWISE            BEGIN           error := ips_NO_PATH_THIS_TYPE;           Exit;           END;         END;  { CASE msgtype }         { Find Appropriate Path record      {}   
   mmflags.int := 0; 
    mmflags.bits[0] := TRUE;   { Preview the data }      &   DS_MRead (pathkeys.bufr, PATHKEYSLEN, mbufid, msgoffset, mmflags, error); &    IF error <> ips_GOOD_RETURN THEN Exit;       "   { We originally sent this message, so the DEST is the remote node "    { and SRC is the local node.      {}      GetPathRec (pk_dst, pk_src, pkwd.iphd_proto, error);      IF error <> ips_GOOD_RETURN THEN  Exit;      	   END;  { WITH }  	 
99:   { Exit Point } 
 result := error;  END;  { IcmpGetPath }       
$TITLE 'IcmpInbound',PAGE$ 
 {------------------------------------------------------------}  {           IcmpInbound                                      }  {------------------------------------------------------------}      PROCEDURE IcmpInbound              (VAR emsg   : EventMsgType;              VAR result : Int16);      {}  { Description   {     This routine will process all inbound  ICMP messages.   {     It must process ICMP messages and also maintain   {     IP's LLP path emsg counts.  {}  { Parameters  {     emsg     IN       The event message with the necessary  {                       context information.  ${     result      OUT   The result of the call. It will return an error  $ "{                       only if something was wrong with the calling " {                       sequence.   {}  { Global Data Structures  {     gv_icmp_msg    OUT   The ICMP header storage  
{     gv_ip_head  IN 
 {}  { Error Handling  "{     Errors are logged, resouces are cleaned up as much as possible " {     and then control returns.   {}  { Algorithm   {   {}  LABEL      99;   { Exit Point }   CONST   
   SUBR = SubrICMPINBOUND; 
 
      CHKSUMBAD = 1; 
       ILLEGALEMSG = 2;        HDFETCHFAIL = 3;        MSGLOG      = 4;      VAR   
   error    : Int16; 
 
   icmplen  : Int16; 
    icmptype : PosInt8;      	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { IcmpInbound }   WITH emsg, gv_ip_head, gv_icmp_msg DO      BEGIN { WITH variables }      error := 0;         IF em_event <> DATA_INDICATION THEN        BEGIN { IF illegal event message }        result := ips_UNKNOWN_EMSG;         IpErrorLog (EL_DISASTER, result, 0, SUBR+ILLEGALEMSG);  %      IpBufrLog (ipl_EMSGLOG, SUBR+ILLEGALEMSG, emsg.int, EMSG_BYTE_LEN);  %       Exit;         END;  { IF illegal event message }      #   FetchIcmpHead (emdi_mbufid, iphd.w1.headlen*4, gv_icmp_msg, error); #    IF error <> ips_GOOD_RETURN THEN         BEGIN { IF error on fetch of ICMP head }        IpErrorLog (EL_DISASTER, error, 0, SUBR+HDFETCHFAIL);         IcmpMsgIgnore (emsg);         Exit;         END;  { IF error on fetch of ICMP head }         icmplen := iphd.len - iphd.w1.headlen*4;   $   IF (CheckSumIcmp (emdi_mbufid, iphd.w1.headlen*4, icmplen) <> 0)THEN  $       BEGIN { IF checksum failed }        error := ips_BAD_CHECKSUM;        IpErrorLog (EL_ERROR, error, 0, SUBR+CHKSUMBAD);        IcmpMsgIgnore (emsg);         Exit;         END;  { IF checksum failed }         icmptype := icmp_tc.msgtype;   
   CASE icmptype OF  
 
      ECHO_REQUEST:  
          BEGIN           IcmpRtnInfo (emsg);           END;       
      DEST_UNREACH:  
          BEGIN           IcmpDestUnreach (emsg);           END;       
      SOURCE_QUENCH: 
          BEGIN           IcmpSourceQuench (emsg);            END;             OTHERWISE            BEGIN  !         IcmpErrorLog (SUBR, EL_ERROR, icmptype, icmp_tc.msgcode,  ! #                           icmp_rdhd.dst,             { Remote node }  # $                           iphd.src,                  { Reporting node } $ &                           redirect.gateway.longint); { Alternate gateway }  &          IcmpMsgIgnore (emsg);           END;         END;  { CASE icmptype }          END;  { WITH variables }   
99:   { Exit Point } 
 END;  { IcmpInbound }       $TITLE 'IcmpMsgIgnore',PAGE$  {------------------------------------------------------------}  {           IcmpMsgIgnore                                    }  {------------------------------------------------------------}      PROCEDURE IcmpMsgIgnore              (VAR emsg : EventMsgType);       {}  { Description   {     This routine will ignore the inbound ICMP message   {     and clean up appropriately.   {   {     It will send a KILL_REQUEST for the inbound message and   {     this KILL_REQUEST   {   {     and will then dispose of the message.   {}  { Parameters  #{     emsg  IN/OUT   The DATA_INDICATION emsg which delivered the ICMP # {                    message.   {}      BEGIN { IcmpMsgIgnore }   WITH emsg DO     BEGIN { WITH emsg }     { Drop the ICMP message in DSAM and     { Kill this emsg to keep the emsg counts accurate     {}      DropMessage (emdi_mbufid);      KillEmsg (emdi_down_pid, emdi_down_ref);      END;  { WITH emsg }  END;  { IcmpMsgIgnore }       
$TITLE 'IcmpRtnInfo',PAGE$ 
 {------------------------------------------------------------}  {           IcmpRtnInfo                                      }  {------------------------------------------------------------}      PROCEDURE IcmpRtnInfo              (VAR emsg : EventMsgType);       {}  { Description   !{     This routine will return the ECHO reply to an ECHO request.  ! !{     It is also meant to be able to handle the INFO request/reply ! #{     processing, but for the present time, the INFO messages will be  # "{     ignored (primarily due to the additional design time required  " {     to ensure that a network of 0 is properly interpreted.  "{     (For Router networks, it is not clear what the network number  " {     is for a given inbound link).   {   #{     The routine will build the reply and queue it to the appropriate # {     path, and set that path to the SEND_DATA state.   {   {     It will overwrite the portions of the header that must  {     change, and will treat the message as Store and Forward   {     as far as memory accounting is concerned.   {   {}  { Parameters  {     emsg  IN/OUT   The event message received   {}  { Side Effects  {}  { Global Data Structures  {     gv_icmp_msg    OUT   The ICMP portion of the message  {     gv_ip_head  IN/OUT   The IP header of the message.  {     gv_path_rec    OUT  {}  LABEL      99;   { Exit Point }       CONST      SUBR  = SubrICMPRTNINFO;         CODEUNKNOWN = 1;  { Icmp Msg Code is not known }  !      HEADPOST    = 2;  { The Posting of the ICMP header failed }  ! "      CKSUMPOST   = 3;  { The Posting of the ICMP checksum failed }  "     TYPE     CheckSumType = RECORD  
      CASE Int16 OF  
          0: (  bufr : BufferType);           1: (  int  : Int16);            END;  { CheckSumType }       VAR      localipadr  : Int32;      error       : Int16;      icmplen     : Int16;      checksum    : CheckSumType;      	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { IcmpRtnInfo }   WITH emsg, gv_ip_head, gv_icmp_msg, gv_path_rec DO  	   BEGIN { WITH }  	    { Ensure the message qualifies for this operation.      { and set up the reply fields in the ICMP header      {}      IF (icmp_tc.msgtype = ECHO_REQUEST) AND        (icmp_tc.msgcode = 0           ) THEN         BEGIN { IF code 0 Echo Request }        icmp_tc.msgtype := ECHO_REPLY;        icmp_tc.msgcode := 0;         END   { IF code 0 Echo Request }      
   ELSE  { Unknown code }  
       BEGIN { ELSE code unknown }         { Log this error, and get out         {}  '      IpErrorLog (EL_ERROR, ips_BAD_ICMP_CODE, pr_pathref, SUBR+CODEUNKNOWN);  '       IcmpMsgIgnore (emsg);         Exit;         END;  { ELSE code unknown }          { Log the event of receiving this ICMP message      {}   "   IcmpErrorLog (SUBR, EL_WARNING, icmp_tc.msgtype, icmp_tc.msgcode, "                         iphd.src, iphd.src, 0);          { Fetch the appropriate Inbound Store & Forward Path      {}      GetPathRec (iphd.src, NO_LOCAL, NO_PROTO, error);     IF error <> ips_GOOD_RETURN THEN         BEGIN { IF error on fetch of path }         IpErrorLog (EL_RESOURCELIM, error, 0, SUBR+PATHFAIL);         IcmpMsgIgnore (emsg);         Exit;         END;  { IF error on fetch of path }       #   { If this path is a connectionless path, indicate that it has been  # 	   { recently used 	    {}      IF (pr_path_type = pr_REFED_CONNECTLESS)   OR        (pr_path_type = pr_UNREFED_CONNECTLESS) THEN        BEGIN { IF connectionless path }        pr_cl_idletime := cl_PATH_NOT_IDLE;         END;  { IF connectionless path }         WITH pr_statistics DO        st_dataind_dn := st_dataind_dn + 1;      UpdatedPr;          { Record Offered Route in this path     {}      pr_in_dnpid  := emdi_down_pid;      pr_in_dnpath := emdi_down_ref;      pr_states := pr_states + [cst_HAVE_IN_ROUTE];     UpdatedPr;      StatesLink;         { ***** Build the return message ***** }          { Set up to post the return IP header in DSAM     { and save all the state      {}   
   localipadr := iphd.dst; 
 
   iphd.dst   := iphd.src; 
    iphd.src   := localipadr;         UpdatedIphd;      SaveState;          { Fix up the ICMP header, and post the      {  type, code and checksum fields     {}      icmplen    := iphd.len - iphd.w1.headlen*4;  
   icmp_cksum := 0;  
        DS_MBOverWrite (gv_icmp_msg.bufr, icmplen, emdi_mbufid,                                        iphd.w1.headlen*4, error);       IF error <> ips_GOOD_RETURN THEN         BEGIN { IF ICMP header posting error }        IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+HEADPOST);        DropMessage (emdi_mbufid);         { The emsg is not KILLed since the offered route has been          { recorded in the Connectionless path.  "      { This Connectionless path will time out as any normal CL path "       {}        Exit;         END;  { IF ICMP header posting error }         { Checksum the ICMP message in DSAM     { and store the result in DSAM      {}   %   checksum.int := CheckSumIcmp (emdi_mbufid, iphd.w1.headlen*4, icmplen); %    DS_MBOverWrite (checksum.bufr, 2, emdi_mbufid,                                     (iphd.w1.headlen*4)+2, error);       IF error <> ips_GOOD_RETURN THEN         BEGIN { IF ICMP header posting error }         IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+CKSUMPOST);          DropMessage (emdi_mbufid);         { The emsg is not KILLed since the offered route has been          { recorded in the Connectionless path.        { This CL path will time out as any normal CL path        {}        Exit;         END;  { IF ICMP header posting error }         { Process this message just as if it were a S&F message     {}      SfEchoInbound (emsg);      	   END;  { WITH }  	     
99:   { Exit Point } 
 END;  { IcmpRtnInfo }       $TITLE 'IcmpSourceQuench',PAGE$   {------------------------------------------------------------}  {           IcmpSourceQuench                                 }  {------------------------------------------------------------}      
PROCEDURE IcmpSourceQuench 
            (VAR emsg : EventMsgtype);       {}  { Description   {     This routine will generate a status indication emsg for   {     the appropriate ULP, indicating that a SOURCE QUENCH was  {     received. It will then be up to the ULP to act on that.   {}  { Parameters  {     emsg     IN/OUT   The event message to act on.  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}  LABEL      99;   { Exit Label }       CONST      SUBR = SubrICMPSRCQUENCH;      VAR   
   error    : Int16; 
     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     
BEGIN { IcmpSourceQuench } 
 WITH emsg, gv_ip_head, gv_icmp_msg, gv_path_rec DO     BEGIN { WITH global variables }     { Find the appropriate path record      {}      IcmpGetPath (emdi_mbufid, icmp_tc.msgtype, error);      IF error <> ips_GOOD_RETURN THEN         BEGIN { IF can't get this path }        IpErrorLog (EL_RESOURCELIM, error, 0, SUBR);        IcmpMsgIgnore (emsg);         Exit;         END;  { IF can't get this path }      #   { If this path is a connectionless path, indicate that it has been  # 	   { recently used 	    {}      IF (pr_path_type = pr_REFED_CONNECTLESS)   OR        (pr_path_type = pr_UNREFED_CONNECTLESS) THEN        BEGIN { IF connectionless path }        pr_cl_idletime := cl_PATH_NOT_IDLE;         END;  { IF connectionless path }         WITH pr_statistics DO        st_dataind_dn := st_dataind_dn + 1;      UpdatedPr;          { Log the arrival of this ICMP message      {}   "   IcmpErrorLog (SUBR, EL_WARNING, icmp_tc.msgtype, icmp_tc.msgcode, "                         pr_remote, iphd.src, 0);         { Set the Send Source Quench bit in the path record     { Record the offered route      { and then return and let the path processing take care of      { the task      {}   %   pr_states := pr_states + [cst_SEND_ULP_SRCQNCH] + [cst_HAVE_IN_ROUTE];  %    pr_in_dnpid := emdi_down_pid;     pr_in_dnpath := emdi_down_ref;          StatesLink;     UpdatedPr;          { Drop the message as it is of no further use     {}      DropMessage (emdi_mbufid);      END;  { WITH global variables }      
99:   { Exit Point } 
 
END;  { IcmpSourceQuench } 
     $TITLE 'InAbortDpath',PAGE$   {------------------------------------------------------------}  {              InAbortDpath                                  }  {------------------------------------------------------------}      PROCEDURE InAbortDpath             (VAR emsg_recvd : EventMsgType);       {}  { Description   !{     This routine will be called to handle the ABORT_DPATH event  ! {     messages which may be sent from PROBE in answer to a  {     REQUEST_DPATH message from IP.  {   #{     Receiving this message indicates that the route which was being  # "{     verified will now never be. If there is no offered route, the  " {     path should be torn down.   {}  { Parameters  #{     emsg_recvd  IN    The event message context that will guide the  # {                       processing.   {                       The format of an ABORT_DPATH emsg is:   {   {                    emed_root_ref  - ANH record index  {                    emed_reason    - reason for the abort  &{                    emed_vna.addrpart  - IP address passed in REQUEST_DPATH & {}  { Side Effects  {}  { Global Data Structures  {     gv_anh_rec     OUT  {     gv_path_rec    OUT  {}  { Error Handling  {}  { Algorithm   #{     The ABORT_DPATH is first verified to ensure that the ANH record  # !{     is actually waiting for a reply to a REQUEST_DPATH, and that ! %{     this ABORT_DPATH carries the same address sent in the REQUEST_DPATH. % {   {     If the event is valid,  {        Each path record queued off of this ANH record   %{        is set to the SEND_KILL_UP state and queued onto the appropriate  % 
{        processing queue. 
 {}     LABEL        99;      { Exit Label }          CONST  "      SUBR = SubrABORTDPATH;   { Subroutine ID number for logging }  "       INVALIDABDPATH  = 1;     { Error Logging Qualifiers }   
      NOTROUTEPENDING = 2; 
 
      HAVEROUTE       = 3; 
 
      NOROUTE         = 4; 
        VAR        link       : Int16;    { link to next path record }   
      error      : Int16;  
           PROCEDURE Exit;            BEGIN { Exit }   	         GOTO 99;  	          END;  { Exit }       
   BEGIN { InAbortDpath }  
    WITH emsg_recvd, gv_anh_rec, gv_path_rec DO        BEGIN { WITH Global Variables }         FetchAnhRec (emed_root_ref, error);         IF error <> ips_GOOD_RETURN THEN           BEGIN { IF error fetching ANH record }   "         IpErrorLog (EL_DISASTER, error, pr_pathref, SUBR+ANHFAIL);  "          Exit;           END;  { IF error fetching ANH record }             { If ANH not in ROUTE_PENDING state, reject this msg.         {}        IF NOT (ahst_ROUTE_PENDING IN ah_states) THEN            BEGIN { IF not waiting for ABORT_DPATH }   "         IpErrorLog (EL_ERROR, 0, pr_pathref, SUBR+NOTROUTEPENDING); "          Exit;           END;  { IF not waiting for ABORT_DPATH }             { Have an ABORT DPATH for this ANH record,        { clear the PENDING state.        {}        ah_states := ah_states - [ahst_ROUTE_PENDING];  	      UpdatedAnh;  	           IF emed_vna.addrpart <> ah_anh THEN            BEGIN { IF wrong ANH address }   !         { The ABORT DPATH address doesn't match the ANH address.  ! #         { IP may have rerouted, This route still needs to be verified #          { Request new verification by OUTPRO.           {}            FetchPathRec (ah_pr_link, error);  
         IF error = 0 THEN 
             BEGIN { IF have path record }               pr_states := pr_states + [ast_BUILD_ROUTE];               UpdatedPr;              StatesLink;               END   { IF have path record }             ELSE              BEGIN { ELSE have no path record }  $            IpErrorLog (EL_DISASTER, error, ah_pr_link, SUBR+PATHFAIL);  $             END;  { ELSE have no path record }               Exit;           END;  { IF wrong ANH address }             { This is a VALID ABORT_DPATH, so let the ULP know        {    If there is still a possible route, use it.        {}            IF (ah_dnpid <> 0) AND (ah_dnpath <> 0) THEN           BEGIN { IF there is an existing route }           { There is an existing route, so keep sending on it  $         { even though PROBE can't seem to figure out how to get there.  $ "         { See that the CANT_SEND_DATA is clear for all these paths. "          {}   $         IpErrorLog (EL_WARNING, emed_reason, ah_index, SUBR+HAVEROUTE); $          AnhPrStatesLink ([ast_CANT_SEND_DATA], [], 0);            {           { WARNING: The path record context has been lost here           {}            Exit;           END;  { IF there is an existing route }                { There is no possible route,   #      { Clear the CANT_SEND_DATA and SEND_DATA states so that the path #       { can be killed if a KILL_REQUEST arrives from its ULP.   #      { Set the SEND_KILL_UP state and reason so that the ULP will be  #       { notified of this problem.         {}  !      IpErrorLog (EL_ERROR, emed_reason, ah_index, SUBR+NOROUTE);  !       AnhPrStatesLink ([ast_CANT_SEND_DATA,  ast_SEND_DATA],                         [cst_SEND_KILL_UP], ips_ABORT_DPATH);        {}        { WARNING: Path record context has been lost here         {}        Exit;         END;  { WITH Global Variables }          99:   { Exit Point }   
   END;  { InAbortDpath }  
     $TITLE 'InBound',PAGE$  {------------------------------------------------------------}  {              Inbound                                       }  {------------------------------------------------------------}      	PROCEDURE Inbound  	            (VAR emsg_recvd : EventMsgtype;              VAR result     : Int16);      {}  { Description   "{     This is the IP Inbound routine that will be called by ProSw in " {     the Inbound protocol process.   {   "{     It handles the dispatching of the event messages to the proper " "{     event message handling routine, and then calls the routines to " ${     complete the processing of any path records that may have changed  $ {     state as a result of this event message.  {   "{     It will process all the paths on the Path Control Queue and if " "{     there are any on the Active Outbound queue, it will generate a " ${     signal which will cause the IP Outbound routine to process those.  $ {}  { Parameters  "{     emsg_recvd     IN       The event message received from ProSw  " !{                             that contains the event information  ! {                             that will direct the processing.  {   "{     result            OUT   At this time it is not clear what will " {                             be returned to ProSw.   {}  { Side Effects  {   {}  { Global Data Structures  #{     gv_ip_globals  IN/OUT   The IP globals. This block contains the  # !{                             global list heads used by the state  ! {                             processing section.   {     gv_wkmap       IN/OUT   {}  { Error Handling  {     see result parameter above.   {}  { Algorithm   %{     The Inbound event will be passed to the appropriate event processing % {     routine.  %{     These routines will do the initial processing of each event, setting % ${     up the proper context, setting the paths into the proper context.  $ %{     The IP tables are set into the appropriate states by these routines. % {   "{     Then the path records which contain the state information are  " !{     processed. This may result in event messages being passed to !  {     other protocol modules. This is where the real work of the   {     protocol is done.    {     The Path Control Queue is processed first, and completely.   "{     Then, if there is something queued off of the Active Outbound  " !{     Queue, a SAT_BEAM event message is generated and sent to the ! {     IP Oubound module in the outbound protocol process.   {}  LABEL   
   99;      { Exit Label } 
     CONST       SUBR = SubrINBOUND;      { Subroutine ID number for logging }      OB_SIGNAL = 0;    { Send SatBeam to OutPro }       VAR   	   error  : Int16; 	 	   ip_gsd : Int16; 	     	   PROCEDURE Exit; 	       BEGIN  { Exit }         GOTO 99;        END;   { Exit }       	BEGIN { Inbound }  	 WITH emsg_recvd, gv_ip_globals DO          BEGIN { WITH Global Variables }     result := 0;      gv_gocrit_error := 0;         ContextLost;      DS_EnterCritical (gv_wkmap, gv_gocrit_error);     error := gv_gocrit_error;         IF error <> ips_GOOD_RETURN THEN         BEGIN { IF critical call fails }        IpErrorLog (EL_DISASTER, error, 0, SUBR+GOCRITFAIL);        Exit;         END;  { ELSE Could Not Go Critical }         IpEmsgLog (emsg_recvd, SUBR);         FetchGlobals;     {}      { Inbound Event Message Event Processing      {}   
   CASE em_event OF  
           DATA_INDICATION:           InDataIndication (emsg_recvd);       
      CONFIRM_DPATH: 
          InConfirmDpath (emsg_recvd);       	      ABORT_DPATH: 	          InAbortDpath (emsg_recvd);             KILL_INDICATION:           InKillIndication (emsg_recvd);             OTHERWISE            BEGIN           IpErrorLog (EL_ERROR, ips_UNKNOWN_EMSG, 0, SUBR);  $         IpBufrLog  (ipl_EMSGLOG, SUBR, emsg_recvd.int, EMSG_BYTE_LEN);  $          END;             END;  { CASE em_event }          WHILE ipg_pr_cntl_que <> END_OF_LIST DO        BEGIN { WHILE Paths on the control queue }        {}        { Process Path Control States         {}  
      IpPathControl; 
       END;  { WHILE Paths on the control queue }         IF ipg_act_out_pr_que <> END_OF_LIST THEN        BEGIN { IF have active processing to do }         {}        { Have some Active Outbound Processing to do        { This is all done by the outbound process.         { Send a SAT_BEAM to OutPro to wake it up.        {}        DS_FetchElement (DS_TrackTD, TL_IP_SOCKET, ip_gsd);         DS_SatBeamSignal (ip_gsd, OB_SIGNAL);         END;  { IF have active processing to do }          {}      { Emsg Processing Complete      {}          { Start the Connectionless path rec timer if necessary      {}      StartClTimer;         SaveState;      IF gv_gocrit_error = 0 THEN DS_LeaveCritical (gv_wkmap);      ContextLost;      result := ips_GOOD_RETURN;          END;  { WITH GLOBAL VARIABLES }      
99:   { Exit Point } 
 	END;  { Inbound }  	     $TITLE 'InConfirmDpath',PAGE$   {------------------------------------------------------------}  {              InConfirmDpath                                }  {------------------------------------------------------------}      PROCEDURE InConfirmDpath             (VAR emsg_recvd : EventMsgType);       {}  { Description   #{     On receipt of a CONFIRM_DPATH message from an LLP, this routine  # {     will do the preliminary processing.   "{     It will record the down PID/Path offered in the event message, " !{     and take care to begin the processing for any paths that may ! {     have been waiting for this event.   {}  { Parameters  !{     emsg_recvd  IN       The event message received from the LLP ! #{                          with the Down PID/Path information that was #  {                          requested by a REQUEST_DPATH message.   {   {                          Confirm_Dpath Emsg fields:   {   #{                          emcd_root_ref  -  Index of ANH record used  # ${                          emcd_vna.addrpart - IP address passed down in $ {                                            the REQUEST_DPATH  "{                          emcd_down_pid  -  Down PID for this route " %{                          emcd_down_ref  -  Down Path ref for this route  % {}  { Side Effects  {   {}  { Global Data Structures  ${     gv_anh_rec     OUT   The record referenced by this event message.  $ {   ${     gv_path_rec    OUT   The path records that are queued off of this  $ {                          ANH record will be processed here.   {}  { Error Handling  {   {}  { Algorithm   ${     When a CONFIRM_DPATH arrives, the ANH record will be fetched based $ {        on the index in the event message.   "{     IF the ANH record is in the proper state and the address field " "{        matches that in the event message, this is a valid confirm. " {    {        The Route offered is recorded in anh record and all the   "{        path records linked to this ANH record are linked onto the  " &{        appropriate processing queue to process any state that may be set.  & {   #{     Otherwise, if the message is accurate, but the route has already # {        been set up, the event message is counted.   {   ${        Otherwise, the message is late and can't be counted because it  $ {           refers to paths not refered to here. Such messages  #{           cause KILL_REQUESTs to be generated just counting the one  # 
{           event message. 
 {}  LABEL   
   99;      { Exit Label } 
     CONST       SUBR = SubrINCONFIRMDP;  { Subroutine ID number for logging }      OLDCNFM = 1;             { Error Logging qualifier }      NOTROUTEPENDING = 2;     { Error Logging qualifier }       VAR      path_ref   : Int16;     error      : Int16;     old_dnpid  : Int16;     old_dnpath : Int16;     llpupemscnt : Int32;      llpdnemscnt : Int32;      link       : Int16;      	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { InConfirmDpath }  WITH gv_anh_rec, gv_path_rec, emsg_recvd DO      BEGIN { WITH Global Variables }     FetchAnhRec (emcd_root_ref, error);     IF (error <> ips_GOOD_RETURN) THEN         BEGIN { IF ANH rec fetch failed }         IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+OLDCNFM);         KillEmsg (emcd_down_pid, emcd_down_ref);        Exit;         END;  { IF ANH rec fetch failed }          IF NOT (ahst_ROUTE_PENDING IN ah_states) THEN        BEGIN { IF not route pending }  !      IpErrorLog (EL_ERROR, 0, pr_pathref, SUBR+NOTROUTEPENDING);  !       KillEmsg (emcd_down_pid, emcd_down_ref);        Exit;         END;  { IF not route pending }         IF (ah_anh <> emcd_vna.addrpart) THEN        BEGIN { IF wrong ANH address }  "      { IP may have rerouted, This route still needs to be verified  "       { Clear the ROUTE PENDING state as we're not waiting        { any more, and request new verification.         {}        ah_states := ah_states - [ahst_ROUTE_PENDING];  	      UpdatedAnh;  	       FetchPathRec (ah_pr_link, error);         IF error = 0 THEN            BEGIN { IF have path record }           pr_states := pr_states + [ast_BUILD_ROUTE];  
         UpdatedPr;  
 
         StatesLink; 
          END   { IF have path record }         ELSE            BEGIN { ELSE have no path record }   "         IpErrorLog (EL_DISASTER, error, ah_pr_link, SUBR+PATHFAIL); "          END;  { ELSE have no path record }             KillEmsg (emcd_down_pid, emcd_down_ref);        Exit;         END;  { IF wrong ANH address }         { CONFIRM_DPATH is valid      {     Accept it if there is no old route to clean up      {}      IF ( (ah_dnpid = 0) OR (ah_dnpath = 0) ) OR            ( (emcd_down_pid = ah_dnpid) AND          (emcd_down_ref = ah_dnpath)       ) THEN            BEGIN { IF Confirmed route immediately acceptable }         ah_dnpid  := emcd_down_pid;         ah_dnpath := emcd_down_ref;   
      SegSizeCheck;  
       ah_states := ah_states - [ahst_ROUTE_PENDING];  	      UpdatedAnh;  	           { Count the emsg that brought the offered route         { (the confirm_dpath) in the ANH record         {}        ah_up_emscnt := ah_up_emscnt + 1;   $      { If this path is a connectionless path, indicate that it has been $       { recently used         {}        IF (pr_path_type = pr_REFED_CONNECTLESS)   OR            (pr_path_type = pr_UNREFED_CONNECTLESS) THEN            BEGIN { IF connectionless path }            pr_cl_idletime := cl_PATH_NOT_IDLE;           END;  { IF connectionless path }             UpdatedPr;            { Clear the ast_CANT_SEND_DATA block and then         { Relink any path records with things to do on the  
      { processing queues  
       { Note that the current path record context is lost.        {}        AnhPrStatesLink ([ast_CANT_SEND_DATA], [], 0);        Exit;         END;  { IF Confirmed route immediately acceptable }          { HAVE OLD ROUTE TO CLEAN UP      { Save the current route, and emsg counts.      { clear out the emsg counts.      {}   
   old_dnpid := ah_dnpid;  
    old_dnpath := ah_dnpath;      llpupemscnt := ah_up_emscnt;      llpdnemscnt := ah_dn_emscnt;      ah_up_emscnt := 0;      ah_dn_emscnt := 0;          { Record the new, confirmed route     { and count the emsg.     {}      ah_dnpid := emcd_down_pid;      ah_dnpath := emcd_down_ref;     SegSizeCheck;     ah_up_emscnt := ah_up_emscnt + 1;     ah_states := ah_states - [ahst_ROUTE_PENDING];      UpdatedAnh;         { Clear the CANT_SEND_DATA state and requeue the path as      { necessary to do the processing remaining on it.  !   { The current path record context will be lost by this routine. !    {}      AnhPrStatesLink ( [ast_CANT_SEND_DATA], [], 0);         { Kill the old route saved earlier      { and lose context.     {}       KillRoute (old_dnpid, old_dnpath, llpupemscnt, llpdnemscnt);           END;  { WITH Global Variables }      
99:   { Exit Label } 
 END;  { InConfirmDpath }      $TITLE 'InDataIndication',PAGE$   {------------------------------------------------------------}  {              InDataIndication                              }  {------------------------------------------------------------}      
PROCEDURE InDataIndication 
            (VAR emsg_recvd : EventMsgType);       {}  { Description   #{     This procedure is called to process the inbound Data Indications # {     events.   ${     It will process data messages according to the IP protocol rules.  $ {}  { Parameters  #{     emsg_recvd  IN    The event message that directs the processing. # {}  { Side Effects  {   {}  { Global Data Structures  {     gv_ip_globals  IN/OUT   {     gv_path_rec       OUT   {     gv_ip_head        OUT   {}  { Error Handling  {   {}  { Algorithm   {   {     The IP header will be fetched from DSAM and validated.   {     IF the validate succeeds, the parameters will be set up to   {        get the appropriate path record from DSAM.   !{        The path will either be found (if a suitable one exists)  ! {        or it will be built.   {   {        IF the path is found or built successfully,  #{           the Inbound Offered Route will be recorded for processing  # ${           and the path record will be linked onto a processing queue.  $ {   "{           The message will be dispatched to one of the following:  " {              the ICMP processing  {              the Store and Forward Processing   {              the Normal Data processing.  {   "{        Otherwise, if the path couldn't be build, the message will  " {           be dropped and an error logged.   !{     Otherwise,  if the message is not valid (TTL expired or bad  ! {        checksum), it will be dropped and an error logged.   {}  LABEL   
   99;      { Exit Label } 
     CONST       SUBR = SubrINDATAIND;    { Subroutine ID number for logging }      HDFETCHFAIL = 1;         { Error Qualifier }      EMSGLEN     = 2;         { Error Qualifier }      MSGINVALID  = 3;         { Error Qualifier }       VAR      error   : Int16;       { Local Error code }     result  : Int16;       { Second local error code }   
   source  : Int32;  
 
   dest    : Int32;  
 
   proto   : PrProtoType;  
 !   diff    : Int16;       { Used in removing possible extra byte } !     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     
BEGIN { InDataIndication } 
     WITH emsg_recvd, gv_ip_globals, gv_path_rec, gv_ip_head,       gv_ip_globals.ipg_statistics DO     BEGIN { WITH Global Variables }     {}      { Fetch the Header      { And validate this before doing further processing     {}      FetchIpHead (emdi_mbufid, error);     IF error <> ips_GOOD_RETURN THEN         BEGIN { IF header fetch failed }  %      IpBufrLog (IPL_HEADLOG, SUBR+HDFETCHFAIL, iphd_bufr, BYTES_IP_HEAD); %       DropMessage (emdi_mbufid);  "      IpErrorLog (EL_DISASTER, error, pr_pathref, SUBR+HDFETCHFAIL); "       KillEmsg (emdi_down_pid, emdi_down_ref);        Exit;         END;  { IF header fetch failed }         { Strip any extra odd bytes (if any)      { Get the negative number of bytes to remove from     { the tail of the message.      { Ignore the error since it will be caught either by      { FetchIpHead or ValidateIpMsg      {}      diff := iphd.len - emdi_dlen;  
   IF diff < 0  THEN 
       BEGIN { IF have extra odd bytes }         DS_MAdj (emdi_mbufid, diff, error);         emdi_dlen := emdi_dlen + diff;        END   { IF have extra odd bytes }       
   ELSE IF diff <> 0 THEN  
           BEGIN { ELSE IF Have bad length in event msg }  $      IpErrorLog (EL_ERROR, ips_BAD_MBUFLEN, pr_pathref, SUBR+EMSGLEN);  $       END;  { ELSE IF Have bad length in event msg }         { Validate the Checksum & TTL fields      {}   
   ValidateIpMsg (error);  
    IF error <> ips_GOOD_RETURN THEN         BEGIN { IF Message NOT valid }         IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+MSGINVALID);   %      IpBufrLog (IPL_HEADLOG, SUBR+MSGINVALID, iphd_bufr, BYTES_IP_HEAD);  %       DropMessage (emdi_mbufid);        IF (error = ips_TTL_EXPIRED) AND           (iphd.w5.iphd_proto <> ICMP_PROTO_NUM) THEN           BEGIN { IF Notify source of TTL expiration }            NotifySourceNode (TIME_EXCEEDED, TTL_EXPIRED);            END;  { IF Notify source of TTL expiration }             KillEmsg (emdi_down_pid, emdi_down_ref);        Exit;         END;  { IF Message NOT valid }         {}      { The IP Message is a valid one to be processed     {}      { Set up the parameters for the fetch of the path record.     {}      IF LocalAddress (iphd.dst) THEN            BEGIN { IF destined locally }         ipgs_term_packs_recvd := ipgs_term_packs_recvd + 1;   	      UpdatedIpg;  	       dest  := iphd.dst;  #      proto.int  := NO_PROTO;                 { Initialize the word }  # #      proto.byte := iphd.w5.iphd_proto;       { Set the proto byte  }  #           { ICMP messages escape here         {}        IF iphd.w5.iphd_proto = ICMP_PROTO_NUM THEN            BEGIN { IF terminal ICMP message }            IcmpInBound (emsg_recvd, error);            { Ignore error and exit           {}            Exit;           END;  { IF terminal ICMP message }         END   { IF destined locally }           ELSE            BEGIN { ELSE NOT destined locally }         { Set parameters for locating the Store and Forward Path        {}         ipgs_transit_packs_recvd := ipgs_transit_packs_recvd + 1;    	      UpdatedIpg;  	       dest      := NO_LOCAL;        proto.int := NO_PROTO;        END;  { ELSE NOT destined locally }          { Fetch the appropriate path record     {}      GetPathRec (iphd.src, dest, proto.int, error);      IF error <> ips_GOOD_RETURN THEN         BEGIN { IF could NOT get path rec }         DropMessage (emdi_mbufid);        IpErrorLog (EL_RESOURCELIM, error, 0, SUBR+PATHFAIL);   $      IpBufrLog (IPL_HEADLOG, SUBR+PATHFAIL, iphd_bufr, BYTES_IP_HEAD);  $       IF error = ips_PROTOCOL_UNKNOWN THEN           BEGIN { IF couldn't get path for this reason }            NotifySourceNode (DEST_UNREACH, PROTOCOL_UNREACH);            END;  { IF couldn't get path for this reason }             KillEmsg (emdi_down_pid, emdi_down_ref);        Exit;         END;  { IF could NOT get path rec }          {}      { Do the Initial Inbound processing on this IP message      {     Count the event     {     Record the Offered Path  !   {     The event message will be counted later when the offered  !    {        route is processed.      {}      WITH pr_statistics DO        st_dataind_dn := st_dataind_dn + 1;       #   { If this path is a connectionless path, indicate that it has been  # 	   { recently used 	    {}      IF (pr_path_type = pr_REFED_CONNECTLESS)   OR        (pr_path_type = pr_UNREFED_CONNECTLESS) THEN        BEGIN { IF connectionless path }        pr_cl_idletime := cl_PATH_NOT_IDLE;         END;  { IF connectionless path }         { Record the offered route      {}      pr_in_dnpid := emdi_down_pid;     pr_in_dnpath := emdi_down_ref;      pr_states := pr_states + [cst_HAVE_IN_ROUTE];     UpdatedPr;      StatesLink;         {}   !   { Send the message off for the rest of the Inbound Processing.  !    { This depends on the type of message,   
   {     Store and Forward 
    {     ICMP      {     All other IP messages     {}          IF NOT LocalAddress (iphd.dst) THEN            BEGIN { IF SF message }         SfEchoInbound (emsg_recvd);         END   { IF SF message }           ELSE        BEGIN { ELSE IF Other IP message }        IpDataInbound (emsg_recvd);         END;  { ELSE IF Other IP message }         END;  { WITH Global Variables }      
99:   { Exit Point } 
 
END;  { InDataIndication } 
     $TITLE 'InKillIndication',PAGE$   {------------------------------------------------------------}  {              InKillIndication                              }  {------------------------------------------------------------}      
PROCEDURE InKillIndication 
            (VAR emsg_recvd : EventMsgType);       {}  { Description   #{     When a KILL_INDICATION event arrives from the LLP, this routine  #  {     does the initial processing, setting the appropriate path    {     records into the SEND_KILL_UP state.  {   "{     The KILL_INDICATIONs will actually be sent when the path state " 
{     processing is done.  
 {   "{     NOTE that KILL_INDICATIONs are not counted in the Emsg counts  " {}  { Parameters   {     emsg_recvd  IN       The event message which contains the    {                          KILL_INDICATION.   {}  { Side Effects  {   {}  { Global Data Structures  {     gv_path_rec       OUT   {     gv_anh_rec        OUT   {     gv_ip_globals  IN/OUT   {}  { Error Handling  {   {}  { Algorithm    {     The ANH record with the down PID/Path pair that match the    {     event message is found.   {   !{     All the path records queued off of this record are then put  ! "{     into the SEND_KILL_UP state and queued off of the appropriate  " {     processing queue.   {   {     Control is then returned to the caller, where the path  {     states are processed.   {}  LABEL   
   99;      { Exit Label } 
     CONST       SUBR = SubrINKILLIND;    { Subroutine ID number for logging }       VAR      path_ref    : Int16;      error       : Int16;      start_index : Int16;       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     
BEGIN { InKillIndication } 
 WITH gv_path_rec, gv_anh_rec, emsg_recvd,        gv_ip_globals.ipg_statistics DO     BEGIN { WITH Global Variables }     ipgs_llp_ki_recvd := DS_IncBt (ipgs_llp_ki_recvd, 1);     UpdatedIpg;         error := ips_GOOD_RETURN;     start_index := MININT16;      WHILE error = ips_GOOD_RETURN DO         BEGIN { WHILE found ANH Record }  "      FindAnhRec (start_index, emki_down_pid, emki_down_ref, error); "       IF error <> ips_GOOD_RETURN THEN Exit;            { Found the appropriate ANH Record  
      { Process it.  
       {}            { Set all the paths linked to this ANH record to the        { pr_SEND_KILL_UP state.  "      { And set the reason for the kill indication in each path rec. "       { Count this emsg on the first path rec found.        {}        path_ref := ah_pr_link;         WHILE path_ref <> END_OF_LIST DO           BEGIN { WHILE }  
         { Fetch the path  
          { Set its state and link it onto a processing queue.            {}            FetchPathRec (path_ref, error);           IF error = ips_GOOD_RETURN THEN              BEGIN { IF Have path record }               pr_states := pr_states + [cst_SEND_KILL_UP];              StatesLink;                   { Set the reason for the kill }               pr_ki_reason := emki_reason;                  { Get the next reference              {}              path_ref := pr_anh_link;                  { Save the state prior to getting the next record.              {}              UpdatedPr;              SaveState;              END   { IF Have path record }                 ELSE                  BEGIN { ELSE DON'T have path record }               { Log the error and ignore this ANH record              {}  $            IpErrorLog (EL_DISASTER, error, pr_pathref, SUBR+PATHFAIL);  $             path_ref := END_OF_LIST;              error := ips_GOOD_RETURN;               END;  { ELSE DON'T have path record }                END;  { WHILE }            start_index := ah_index + 1;        END;  { WHILE ANH rec found }      END;  { WITH Global Variables }      
99:   { Exit Point } 
 
END;  { InKillIndication } 
     $TITLE 'InsertFragment',PAGE$   {------------------------------------------------------------}  {           InsertFragment                                   }  {------------------------------------------------------------}      PROCEDURE InsertFragment             (VAR rcb            : RcbType;               VAR newfrag        : FragDescType;              VAR reass_complete : BOOLEAN );       {}  { Description   %{     This routine will insert the fragment indicated by 'newfrag' in the  % {     reassembly list headed by 'rcb'.  #{     On completion, if the message is complete (i.e. no more holes),  # {     then reass_complete will return TRUE.   {   {}  { Parameters  ${     rcb         IN/OUT   The Reassembly Control Block for the message  $ {                              the fragment belongs to.   ${     newfrag     IN       The desciptor for the fragment being inserted $ %{     reass_complete OUT   The flag indicating whether or not the message  % ${                              is now complete and ready to be passed up $ {                              to the ULP.  {}  { Side Effects  {}  { Global Data Structures  
{     gv_ip_head  IN 
 {}  { Error Handling  {}  { Algorithm   {   #{  NOTE:    These message fragments MUST not be concatenated until the # #{           RCB is ready to be disposed of, since it is possible that  # #{           the RCB (which was split off of the first piece to arrive) # {           would be overlaid in some cases.  {   #{  NOTE:    Currently, dropping of redundant fragments is turned OFF.  #  {           It should typically stay that way, since that is the   {           exceptional condition.  {   {  Given:   {   !{     1) A list of fragments linked off of the RCB for the message ! {        the current fragment belongs to.   !{     2) A message fragment with a frag descriptor appended to it  ! &{        The frag descriptor is used to link the message fragments together  & ${        in order of their starting offset and to describe the fragment  $ {        so linked in.  (first & last fragment offset)  {   %{        Fragment offsets are in units of 8 bytes, and 0 is the first one. %  {        32760 is used to indicate an infinite fragment offset.    {   {  This routine will do the following:  {  (These actions are taken in parallel)  {   "{     1) Find the place where the new fragment is to be linked into  " {        the reassembly list.   {     2) See if there are any remaining holes.  {     3) See if the new fragment is redundant   {        (turned off for now)    {     4) See if any of the fragments currently linked in are now   {        redundant.  (turned off for now as it fails)   {}  LABEL   "   99;   { Exit point - immediate without posting frag descriptors } "     CONST       SUBR = SubrINSERTFRAG;   { Subroutine ID number for logging }   "      NEW_FRAG_REDUN = 1;   { Newly arrived fragment is redundant }  " #      OLD_FRAG_REDUN = 2;   { Old fragment in list is now redundant }  #     VAR      frag     : FragDescType;      backfrag : FragDescType;      drop_new_redundants : BOOLEAN;    { Set via ipg_debug }     drop_old_redundants : BOOLEAN;    { Set via ipg_debug }          $   { 'remaininghole' contains the fragment offset number associated with $ #   {     the first byte that is not filled in by a fragment queued off #    {     of this RCB.      {}   
   remaininghole : Int16;  
     "   { 'prefraghole' contains the fragment offset associated with the  " $   {     first byte of the first hole that the new fragment may overlap. $    {}   
   prefraghole   : Int16;  
     !   { 'fraghole' is used as a temporary hole-variable where needed. ! !   {     It is typically used when trying to determine whether or  !    {     not a fragment linked into an RCB list is redundant.      {}   
   fraghole      : Int16;  
         	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { InsertFragment }  { Initialize  {}  drop_new_redundants := (gv_ip_globals.ipg_debug.bits[-4] = 1);  drop_old_redundants := (gv_ip_globals.ipg_debug.bits[-5] = 1);      frag := rcb.rcb_frag;   remaininghole := frag.last + 1;   prefraghole   := frag.last + 1;   rcb.rcb_frags_in := rcb.rcb_frags_in + 1;   
reass_complete   := FALSE; 
     { Find newfrag's place in the list  { (before the frag with frag.first >= newfrag.first)  {}  REPEAT  
   backfrag := frag; 
 "   IF prefraghole < frag.last + 1 THEN prefraghole := frag.last + 1; "        GetFrag (frag.link, frag);       "   { update remaining hole if there is no hole left up to this frag  "    {}      IF (remaininghole >= frag.first) AND   &      (remaininghole < frag.last + 1)  THEN remaininghole := frag.last + 1;  &        UNTIL frag.first >= newfrag.first;       
{ Newfrag follows backfrag 
 { Set the link fields to link in newfrag  { This information will be posted later if necessary  {}  newfrag.link  := backfrag.link;   backfrag.link := newfrag.mbufid;      { Is newfrag redundant?   {}  fraghole := prefraghole;  FragRedundant (newfrag, fraghole);  IF (fraghole > newfrag.last ) AND      (drop_new_redundants     ) THEN     BEGIN { IF newfrag is redundant }     DropMessage (newfrag.mbufid);     IpErrorLog (EL_ERROR, ips_FRAG_REDUNDANT, rcb.rcb_pathref,   $                                                   SUBR+NEW_FRAG_REDUN); $    IpBufrLog  (IPL_HEADLOG, SUBR+NEW_FRAG_REDUN,                              gv_ip_head.iphd_bufr, BYTES_IP_HEAD);      rcb.rcb_newfrags_unused := rcb.rcb_newfrags_unused + 1;     Exit;     END;  { IF newfrag is redundant }      { New frag is NOT redundant, it covers up some hole   { Update the local RCB if necessary   {}  !IF backfrag.mbufid = rcb.rcb_mbufid THEN rcb.rcb_frag := backfrag; !      { Update 'remaininghole' if necessary to cover the new fragment    {}  IF (remaininghole >= newfrag.first) AND   '   (remaininghole < newfrag.last + 1) THEN remaininghole := newfrag.last + 1;  '     { Post the linking changes to link newfrag into the list  {}  
PostFrag (backfrag); 
 
PostFrag (newfrag);  
      { Are any of the other fragments covered by newfrag, redundant?    {}  GetFrag (newfrag.link, frag);   
backfrag := newfrag; 
 $IF prefraghole < newfrag.last + 1 THEN prefraghole := newfrag.last + 1;  $     WHILE (frag.first <= newfrag.last) AND        (drop_old_redundants       ) DO      BEGIN { WHILE fragments in list overlap newfrag }     fraghole := prefraghole;      FragRedundant (frag, fraghole);     IF fraghole >  frag.last THEN        BEGIN { IF frag is redundant }        { Drop the message and let the world know         {}        DropMessage (frag.mbufid);         IpErrorLog (EL_ERROR, ips_FRAG_REDUNDANT, rcb.rcb_pathref,   "                                              SUBR+OLD_FRAG_REDUN);  " %      IpBufrLog  (IPL_FRAGLOG, SUBR+OLD_FRAG_REDUN, frag.bufr, FRAG_BLEN); %       rcb.rcb_oldfrags_unused := rcb.rcb_oldfrags_unused + 1;             { Remove it from the fragment list        { and update newfrag locally if necessary         {}        backfrag.link := frag.link;   
      PostFrag (backfrag); 
 '      IF backfrag.mbufid = newfrag.mbufid THEN newfrag.link := backfrag.link;  '       END   { IF frag is redundant }          ELSE            BEGIN { ELSE frag is not redundant (it covers a hole) }         backfrag := frag;         END;  { ELSE frag is not redundant (it covers a hole) }          GetFrag (backfrag.link, frag);   $   IF prefraghole < backfrag.last THEN prefraghole := backfrag.last + 1; $    END;  { WHILE fragments in list overlap newfrag }      { Check the rest of the list for any remaining hole   {}  GetFrag (newfrag.link, frag);   IF (remaininghole >= frag.first) AND  $   (remaininghole < frag.last + 1) THEN remaininghole := frag.last + 1;  $     WHILE remaininghole >= frag.first DO     BEGIN { WHILE no holes found yet }      GetFrag (frag.link, frag);      IF (remaininghole >= frag.first) AND   %      (remaininghole < frag.last + 1) THEN remaininghole := frag.last + 1; %    END;  { WHILE no holes found yet }       reass_complete := (remaininghole >= FRAG_LAST_MSG_COMPLETE);          
99:   { Exit Point } 
 END;  { InsertFragment }      $TITLE 'InStubb',PAGE$  {------------------------------------------------------------}  {              InStubb                                       }  {------------------------------------------------------------}      	PROCEDURE InStubb  	            (VAR emsg_recvd : EventMsgtype;              VAR result     : Int16);      {}  { Description   !{     This is the IP Inbound stubb that will be called by ProSw in ! {     the Outbound protocol process.  {   "{     It handles the dispatching of the event messages to the proper " "{     event message handling routine, and then calls the routines to " ${     complete the processing of any path records that may have changed  $ {     state as a result of this event message.  {   #{     It will process all the paths on the Path Control Queue and also # {     on the Active Outbound queue.   {   %{     The primary difference between this routine and the Inbound routine, % !{     is that this one will not process DATA_INDICATIONs (logging  ! %{     an error condition instead) and will process both processing queues. % {}  { Parameters  "{     emsg_recvd     IN       The event message received from ProSw  " !{                             that contains the event information  ! {                             that will direct the processing.  {   "{     result            OUT   At this time it is not clear what will " {                             be returned to ProSw.   {}  { Side Effects  {   {}  { Global Data Structures  #{     gv_ip_globals  IN/OUT   The IP globals. This block contains the  # !{                             global list heads used by the state  ! {                             processing section.   {}  { Error Handling  {     see result parameter above.   {}  { Algorithm   %{     The Inbound event will be passed to the appropriate event processing % {     routine.  %{     These routines will do the initial processing of each event, setting % ${     up the proper context, setting the paths into the proper context.  $ %{     The IP tables are set into the appropriate states by these routines. % {   "{     Then the path records which contain the state information are  " !{     processed. This may result in event messages being passed to !  {     other protocol modules. This is where the real work of the   {     protocol is done.    {     The Path Control Queue is processed first, and completely.   "{     Then, if there is something queued off of the Active Outbound  " {     Queue, it will be processed in this routine as well.  {}  LABEL   
   99;      { Exit Label } 
     CONST       SUBR = SubrINSTUBB;      { Subroutine ID number for logging }      DATAIND  = 1;            { Error Logging Qualifier }      OTHERWSE = 2;            { Error Logging Qualifier }       VAR   	   error  : Int16; 	     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     	BEGIN { InStubb }  	 WITH emsg_recvd, gv_ip_globals DO          BEGIN { WITH Global Variables }     result := 0;      gv_gocrit_error := 0;         ContextLost;      DS_EnterCritical (gv_wkmap, gv_gocrit_error);     error := gv_gocrit_error;         IF error <> ips_GOOD_RETURN THEN         BEGIN { IF go critical fails }        IpErrorLog (EL_DISASTER, error, 0, SUBR+GOCRITFAIL);        Exit;         END;  { IF go critical fails }         IpEmsgLog (emsg_recvd, SUBR);         FetchGlobals;         {}      { Inbound Event Message Event Processing      {}   
   CASE em_event OF  
           DATA_INDICATION:  !         IpErrorLog (EL_ERROR, ips_INEMSG_RECVD, 0, SUBR+DATAIND); !     
      CONFIRM_DPATH: 
          InConfirmDpath (emsg_recvd);       	      ABORT_DPATH: 	          InAbortDpath (emsg_recvd);             KILL_INDICATION:           InKillIndication (emsg_recvd);             OTHERWISE   "         IpErrorLog (EL_ERROR, ips_UNKNOWN_EMSG, 0, SUBR+OTHERWSE);  "          IpBufrLog  (ipl_EMSGLOG, SUBR+OTHERWSE,  !                                  emsg_recvd.int, EMSG_BYTE_LEN);  !       END;  { CASE em_event }          WHILE (ipg_pr_cntl_que    <> END_OF_LIST) OR            (ipg_act_out_pr_que <> END_OF_LIST) DO             BEGIN { WHILE processing queue processing }   
      FetchGlobals;  
           IF ipg_pr_cntl_que <> END_OF_LIST THEN           BEGIN { IF control queue }            {}            { Paths on the control queue            { Process Path Control States           {}            IpPathControl;            END   { IF control queue }              ELSE                BEGIN { ELSE active queue }           {}            { Have some Active Outbound Processing to do            {}            IpActOutPath;           END;  { ELSE active queue }            END;  { WHILE processing queue processing }          {}      { Emsg Processing Complete      {}          { Start the Connectionless path rec timer if necessary      {}      StartClTimer;         SaveState;      IF gv_gocrit_error = 0 THEN DS_LeaveCritical (gv_wkmap);      ContextLost;          END;  { WITH GLOBAL VARIABLES }      
99:   { Exit Point } 
 	END;  { InStubb }  	     $TITLE 'IpDataInbound',PAGE$  {------------------------------------------------------------}  {              IpDataInbound                                 }  {------------------------------------------------------------}  PROCEDURE IpDataInbound              (VAR emsg_recvd : EventMsgType);       {}  { Description   ${     This routine will do the Inbound processing for those IP messages  $ #{     that are not ICMP messages or S&F messages, the IP Data messages # {     which are addressed to some ULP in this node.   {}  {  Parameters   "{     emsg_recvd     IN    The event message with the event context. " {}  {  Side Effects   {}  
{  Global Data Structures  
 ${     gv_ip_head     IN       Storage for the IP header to be worked on. $ !{     gv_path_rec    IN/OUT   The path record that this header is  ! {                             processed relative to.  {     gv_send_emsg      OUT   {     gv_wkmap       IN/OUT   {     gv_icmp_msg       OUT   {     gv_ip_globals  IN/OUT   {}  	{  Error Handling  	 {}  {  Algorithm  {     The message will go through the reassembly processing.  {     If a whole message is returned,   {        it is transfered to the ULP's memory account.  {        IF this succeeds, an event message is built, and   {           ProSw is called.  {        Otherwise, if the Macct transfer fails,   {           the message is dropped and an error event is logged.   {     Otherwise, if no message is returned from reassembly,   {        processing is complete and control is returned   {        to the caller.   {}     LABEL        99;      { Exit Label }          CONST  "      SUBR = SubrIPDATAINB;    { Subroutine ID number for logging }  "       NOMEMORY = 1;            { Error Qualifier }            INBOUND_FLAGS = 0;         VAR        error   : Int16;        mmflags : MMFlagsType;        opt_mbuf: MbufIdType;         msglen  : Int16;            PROCEDURE Exit;            BEGIN { Exit }   	         GOTO 99;  	          END;  { Exit }       
   BEGIN { IpDataInbound } 
    WITH gv_ip_head, emsg_recvd, gv_path_rec DO        BEGIN { WITH Global Variables }             {}        { Reassemble a possible fragmented message        {}  $      ReassembleMsg (iphd_mbufid, msglen, opt_mbuf, pr_pathref, error);  $       IF error <> ips_GOOD_RETURN THEN           BEGIN { IF Reassembly is not complete }           { There is no message to process further            { because it was either a duplicate or additional           { fragments must arrive before a complete message           { can be built.           {}            Exit;           END;  { IF Reassembly is not complete }            { Transfer the message to the appropriate memory account        {}        mmflags.int := INBOUND_FLAGS;          DS_MBTransfer (iphd_mbufid, pr_mpool_id, mmflags, error);          IF error <> ips_GOOD_RETURN THEN           BEGIN { ELSE Insufficient Memory to pass message up }           WITH gv_ip_globals.ipg_statistics DO   
            BEGIN { WITH } 
 &            ipgs_congested_packloss := DS_IncBt (ipgs_congested_packloss,1); &             UpdatedIpg;   
            END;  { WITH } 
 !         IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+NOMEMORY);  !          DropMessage (iphd_mbufid);                { Notify Source Node            {}            WITH gv_icmp_msg DO              BEGIN { WITH icmp header }              icmp_tc.msgtype := SOURCE_QUENCH;               icmp_tc.msgcode := 0;               icmp_cksum      := 0;               srcquench       := 0; { unused in ICMP msg }              END;  { WITH icmp header }           RtnIcmpMsg (gv_icmp_msg, error);            IF error <> ips_GOOD_RETURN THEN               BEGIN { IF Source quench failed }   $            IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+ICMPSENDFAIL); $             END;  { IF Source quench failed }       '         IpBufrLog (IPL_HEADLOG, SUBR+ICMPSENDFAIL, iphd_bufr, BYTES_IP_HEAD); '          Exit;           END;  { ELSE Insufficient Memory to pass message up }            {}        { Pass the Message on to the ULP        {}        WITH pr_statistics DO            st_dataind_up := st_dataind_up + 1;        UpdatedPr;            { The header has been stripped off        { The possible odd byte has also been stripped off        { The mbufid remains in the iphd variable         { Build the event message         {}        gv_send_emsg.em_event := DATA_INDICATION;   !      gv_send_emsg.ehport   := BuildPort (pr_uppid, EHIB_OFFSET);  !       gv_send_emsg.emdi_up_ref   := -1;         gv_send_emsg.emdi_down_pid := IP;         gv_send_emsg.emdi_down_ref := pr_pathref;         gv_send_emsg.emdi_mbufid   := iphd_mbufid;        gv_send_emsg.emdi_dlen     := msglen;         gv_send_emsg.emdi_flags    := NO_FLAGS;         gv_send_emsg.emdi_opt_mbuf := opt_mbuf;         gv_send_emsg.emdi_src_addr.longint := pr_local;         gv_send_emsg.emdi_dst_addr.longint := pr_remote;            { Count this event        {}        pr_ulp_up_emscnt := pr_ulp_up_emscnt + 1;         UpdatedPr;            { Link the path onto the appropriate Processing Queue  }        { Save the state, and send the event message via ProSw }        {}  	      StatesLink;  	       SaveState;            IF gv_gocrit_error = 0 THEN DS_LeaveCritical (gv_wkmap);        ProSw (gv_send_emsg, error);  	      ContextLost; 	       DS_EnterCritical (gv_wkmap, gv_gocrit_error);         { Post the Prosw error return if any, before proceeding         { Then save the EnterCritical error         {}  %      IF error <> 0 THEN IpErrorLog (EL_ERROR, error, 0, SUBR+PROSWFAIL);  %       error := gv_gocrit_error;             IF error <> ips_GOOD_RETURN THEN           BEGIN           { Enter Critical Error checking }           IpErrorLog (EL_DISASTER, error, 0, SUBR+GOCRITFAIL);            Exit;           END;       
      FetchGlobals;  
           END;  { WITH Global Variables }          99:   { Exit Point }   
   END;  { IpDataInbound } 
     $TITLE 'NotifySourceNode',PAGE$   {------------------------------------------------------------}  {           NotifySourceNode                                 }  {------------------------------------------------------------}      
PROCEDURE NotifySourceNode 
            (    icmptype : PosInt8;                   icmpcode : PosInt8 );       {}  { Description   #{  This routine will Notify the source given in the current gv_ip_head # {  via an ICMP message of some error condition.   {   "{  It will use the current path record and the current ip header as  " 	{  outlined below. 	 {}  { Parameters  ${     icmptype    IN    The ICMP type of the message (e.g. DEST_UNREACH) $  {     icmpcode    IN    The ICMP code qualifier for the message    {                       (e.g. NET_UNREACH)  {}  { Side Effects  {}  { Global Data Structures  &{     gv_ip_head  IN       This header will be copied into DSAM as the data  & {                          portion of the ICMP message built  {   ${     gv_path_rec    OUT   A new path record will be fetched and used to $  {                          send ICMP message to its destination.   {     gv_icmp_msg    OUT  {}  { Error Handling  {     Errors will be logged to the error logger.  {}     LABEL        99;   { Immediate return point }         CONST        SUBR = SubrNOTIFYSOURCE;         VAR  
      error : Int16; 
           PROCEDURE Exit;            BEGIN { Exit }   	         GOTO 99;  	          END;  { Exit }          BEGIN { NotifySourceNode }      WITH gv_ip_head, gv_path_rec DO  
      BEGIN { WITH } 
 !      { Check for ICMP message. Don't send ICMP messages for them. !       {}        IF iphd.w5.iphd_proto = ICMP_PROTO_NUM THEN Exit;              { Send a Dest Unreachable ICMP message back to the source          {}        GetPathRec (iphd.src, NO_LOCAL, NO_PROTO, error);         IF error = ips_GOOD_RETURN THEN            BEGIN { IF have proper path }           WITH gv_icmp_msg DO  
            BEGIN { WITH } 
             icmp_tc.msgtype := icmptype;              icmp_tc.msgcode := icmpcode;              icmp_cksum      := 0;               timeexceed      := 0; { unused field }  
            END;  { WITH } 
          RtnIcmpMsg (gv_icmp_msg, error);            IF error <> ips_GOOD_RETURN THEN               BEGIN { IF error }  $            IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+ICMPSENDFAIL); $             END;  { IF error }           END   { IF have proper path }        ELSE           BEGIN { ELSE couldn't get path }            IpErrorLog (EL_RESOURCELIM, error, 0, SUBR+PATHFAIL);           END;  { ELSE couldn't get path }   
      END;  { WITH } 
        99:   { Immediate Return Point }      END;  { NotifySourceNode }       $TITLE 'ReassAckThresh',PAGE$   {------------------------------------------------------------}  {           ReassAckThresh                                   }  {------------------------------------------------------------}      PROCEDURE ReassAckThresh             (    rcb     : RcbType;                  backref : MbufIdType;                   frag    : FragDescType);      {}  { Description    {     This routine will check to see that there is enough memory   {     in the appropriate memory pool to hold onto the message   {     fragment refered to in the fragment descriptor.   {   !{     If that check fails, then the entire message will be dropped ! {     to free up some memory for other inbound traffic.   {    {     It is not thought to be too bad to drop the entire message    {     because, since the fragment must be dropped by our rules,    !{     that would in almost all cases, invalidate the message being ! !{     reassembled. The Originator will most likely retransmit the  ! "{     entire message, and IP will not be able to tell that it is the " {     same message being retransmitted.   {}  { Parameters  ${     rcb   IN/OUT   The Reassembly control block to be used should the  $ {                    message have to be dropped.  {     backref IN     The mbufid of the previous RCB.  &{     frag  IN       The Fragment descriptor for the fragment to be tested.  & {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}  LABEL      99;   { Immediate exit point }       CONST      SUBR = SubrReassAckThresh;  { Error location }   !      TRFAILED      = 1;   { The MBTransfer w/ AckThresh failed }  !       SRCQNCHFAILED = 2;   { The SrcQuench attempt failed }       #   MM_FLAGS = MMFlagsType [ int : 1]; { [0] = 1 => check Ack Thresh }  #     VAR   
   error    : Int16; 
 
   numfrags : Int16; 
     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { ReassAckThresh }  
WITH gv_path_rec DO  
    BEGIN { WITH Global variables }     IF frag.mbufid = 0 THEN Exit;     DS_MBTransfer (frag.mbufid, pr_mpool_id, MM_FLAGS, error);      IF error <> 0 THEN         BEGIN { IF no memory for storing the new fragment }         RcbUnLink (rcb, backref);         DisposeRcbsQue (rcb, gv_ip_head, numfrags);         WITH gv_ip_globals.ipg_statistics DO           BEGIN { WITH }            ipgs_congested_packloss :=   #                        DS_IncBt (ipgs_congested_packloss, numfrags);  # 
         UpdatedIpg; 
          END;  { WITH }             IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+TRFAILED);        { Build a Source Quench Message         {}  
      WITH gv_icmp_msg DO  
          BEGIN { WITH icmp header }            icmp_tc.msgtype := SOURCE_QUENCH;           icmp_tc.msgcode := 0;           icmp_cksum      := 0;           srcquench       := 0; { unused in ICMP msg }            END;  { WITH icmp header }         RtnIcmpMsg (gv_icmp_msg, error);        IF error <> ips_GOOD_RETURN THEN           BEGIN { IF Source quench failed }  #         IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+SRCQNCHFAILED); #          END;  { IF Source quench failed }        END;  { IF no memory for storing the new fragment }      END;  { WITH global variables }      99:   { Immediate Exit Point }  END;  { ReassAckThresh }      $TITLE 'ReassembleMsg',PAGE$  {------------------------------------------------------------}  {              ReassemblMsg                                  }  {------------------------------------------------------------}  PROCEDURE ReassembleMsg              (VAR mbufid   : MbufIdType;              VAR msglen   : Int16;               VAR opt_mbuf : MbufIdType;              VAR pathref  : Int16;               VAR result   : Int16 );       {}  { Description   !{     This routine will take a message fragment (or whole message) ! {     and will do the reassembly processing on it.  "{     If a message is returned, it will be returned with the header  " #{     in gv_ip_head, with the header stripped off of the DSAM version  # {     and the possible extra odd byte also stripped off.  {   #{     If the result of the operation is a whole message, that message  # {     will be returned using the mbufid parameter.  {   {     If there is no whole message to return, then mbufid   {     is meaningless and result will be set to the reason.  {}  { Parameters  {     mbufid      OUT   The pointer to the message  !{     msglen      OUT   The length of the entire message in bytes. ! ${     opt_mbuf    OUT   The pointer to the mbuf containing the options.  $ ${     pathref  IN       The path reference assocated with this message.  $ "{                       This is used as a key for finding the other  " {                       fragments belonging to this message.   {     result      OUT   The result of this reassembly operation    {   #{                       ips_GOOD_RETURN => A whole message is returned # %{                                          to be passed on up to the ULP.  % {   &{                          else         => Reassembly was not yet complete.  & {                       (to be filled in)   {}  { Side Effects  {}  { Global Data Structures  #{     gv_ip_head  IN/OUT   IN: It supplies the header info and Mbufid. # '{                          On a good return, this will be set to the header of ' '{                          the message being returned. There will be no header ' {                          on the copy of the message in DSAM.  {     gv_path_rec    IN   {     gv_ip_globals  IN/OUT   {   {     The reassembly structures:  {    {     ipg_reass_que  Rcb List head contained in the path record.   {   ${     rcb            Reassembly Control Block. There is one of these for $ !{                    each message being reassembled on this path.  ! #{                    These blocks are linked off of a path record and  # ${                    contain the message ID, and a timer field relating  $ {                    to the reassembly of the message.  #{                    The fragments being reassembled are linked off of # "{                    this block, and the rcb also contains the first " {                    frag descriptor for the message.   {   #{     frag           A frag descriptor. Each fragment has appended to  # %{                    it a frag descriptor that describes the start and end % {                    fragment offsets for this fragment.  ${                    These frag descriptors are linked together to form  $ {                    the partially reassembled message.   {   {     These structures are linked as follows:   {   {   {                         rcb                           rcb   {                          frag                          frag    {                            link -------+                 link     {                            first --+   |                 first    {                            last ---|-+ |                 last    !{    ipg_reass_que           mbufid  | | |                 mbufid  ! #{          * ------------> link -----|-|-|-------------> link --> ...  # {                          time      | | |               time    {                          pathref   | | |               pathref   {                          msgid     | | |               msgid  {                                    | | |  {                    -1 fragment <---+-+ |  {                                        |  {                         +----+         |  {                         |frag| <-------+  {                         |data|  {                         |    |  {                         .    .  {                         +----+  {   ${  See the IP Design Outline for more detail regarding these structures. $ {}  { Error Handling  {}  { Algorithm   {     If the message is a message fragment then:  {   !{        The appropriate RCB for the message will be found on the  ! 
{        reassembly queue. 
 {   {        The message fragment will be added to the queue.   {   %{        If the reassembly is complete, the entire message will be removed % &{        from the reassembly queue, the pieces appended to form one message, & {        the reassembly timer will be reset if necessary,   {        and the message will be passed back to the caller.   {   "{     Otherwise, the message will be returned intact to the caller.  " {}     LABEL        99;      { Exit Label }          CONST  "      SUBR = SubrREASSEMBLE;   { Subroutine ID number for logging }  "       MBUFDSPS = 1;            { Error Logging Qualifier }        HDAPPEND = 2;            { Error Logging Qualifier }        NORCB    = 3;            { Error logging Qualifier }        HDADJ    = 4;            { Error Logging Qualifier }        TMACTIVATE = 5;          { Error on Timer Activation }         ASSEMBLE = 6;            { Error on Assembly of message }          BADCHARS = 7;            { Error on Chars in Mbuf call }        STATS    = 8;            { Log the RCB statistics }          VAR        error     : Int16;        ipheadlen : Int16;  #      link      : MbufidType;    { Mbufid of Rcb for msg to process }  #       no_more_holes : BOOLEAN;  &      frag      : FragDescType;  { start and stop parameters for the frag }  &           msgid     : Int16;        time      : Int16;  
      rcb       : RcbType; 
 
      dummyerror : Int16;  
       backref   : MbufIdType;             PROCEDURE Exit;            BEGIN { Exit }   	         GOTO 99;  	          END;  { Exit }       
   BEGIN { ReassembleMsg } 
    WITH gv_ip_head, gv_path_rec, gv_ip_globals DO         BEGIN { WITH Global Variables }         { Initialize the error return         {}        error := ips_GOOD_RETURN;             { Does this message require reassembly? }         IF (iphd.fragwd.iphd_off <> 0) OR            (iphd.fragwd.iphd_mf  =  1) THEN                BEGIN { IF reassembly required }            AppendFragDesc (gv_ip_head, error);               IF error <> ips_GOOD_RETURN THEN               BEGIN { IF can't add frag descriptor }              DropMessage (gv_ip_head.iphd_mbufid);   "            IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+HDAPPEND); "             IpBufrLog (IPL_HEADLOG, SUBR+HDAPPEND,  !                             gv_ip_head.iphd_bufr, BYTES_IP_HEAD); !             mbufid := NO_MBUFID;  	            Exit;  	             END;  { IF can't add frag descriptor }               mbufid := iphd_mbufid;   
         msgid := iphd.id; 
          time  := iphd.w5.iphd_ttl + pr_ttlwd.ttl;               { Find or build an RCB for this message           {}            FindRcb (pathref, msgid, rcb, backref, error);            IF error = ips_RCB_NOT_FOUND THEN              BEGIN { IF couldn't find the RCB }  %            BuildRcb (pathref, msgid, time, mbufid, rcb, backref, error);  %             END;  { IF couldn't find the RCB }               IF error <> ips_GOOD_RETURN THEN               BEGIN { IF rcb not built }              DropMessage (mbufid);   %            IpBufrLog (IPL_HEADLOG, SUBR+NORCB, iphd_bufr, BYTES_IP_HEAD); % !            IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+NORCB);  !             mbufid := NO_MBUFID;  	            Exit;  	             END;  { IF rcb not built }               {}            { Have a Reassembly Control Block           {}            { Set up the fragment descriptor.  #         { The fragment starts at the fragment offset from the header. # %         { and the last chunk of the fragment has a fragment offset number %          { (1 chunk = 8 bytes) as shown in frag.last.            {}            frag.link       := END_OF_LIST;           frag.first      := iphd.fragwd.iphd_off;            frag.last       := frag.first - 1  %                              + (iphd.len - iphd.w1.headlen*4 + 7) DIV 8;  %          frag.mbufid     := mbufid;            IF iphd.fragwd.iphd_mf = 0 THEN              BEGIN { IF the EOM fragment }               frag.last := FRAG_LAST_MSG_COMPLETE;              END;  { IF the EOM fragment }                InsertFragment (rcb, frag, no_more_holes);                    IF no_more_holes THEN                  BEGIN { IF no_more_holes }              { The message is complete.              { Put all the pieces together and               { dispose of the control data structures              {}              mbufid := rcb.rcb_frag.link;              RcbUnLink (rcb, backref);               AssembleMsg (rcb, mbufid, error);               IF error <> ips_GOOD_RETURN THEN                 BEGIN { IF error on assembly of message }  %               IpErrorLog (EL_DISASTER, error, pr_pathref, SUBR+ASSEMBLE); %                DropMessage (mbufid);                 { Log the RCB, then dispose of it  	               {}  	 '               IpBufrLog (IPL_RCBDONE, SUBR+ASSEMBLE, rcb.rcb_bufr, RCB_BLEN); '                DropMessage (rcb.rcb_mbufid);  
               Exit; 
                END;  { IF error on assembly of message }                  { Count the chars in the mbuf                { (clearing the sign bit (NOT EOM bit) if necessary)               {}              DS_CharsInMbuf (mbufid, 0, msglen, error);              IF msglen < 0 THEN msglen := msglen * (-1);               IF error <> ips_GOOD_RETURN THEN                 BEGIN { IF error on counting the chars }   $               IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+BADCHARS);  $                DropMessage (mbufid);                 rcb.rcb_stat_rsvd := msglen;   '               IpBufrLog (IPL_RCBDONE, SUBR+BADCHARS, rcb.rcb_bufr, RCB_BLEN); '                DropMessage (rcb.rcb_mbufid);  
               Exit; 
                END;  { IF error on counting the chars }                   { Save the msglen in the RCB stats              { Log the RCB, then dispose of it               {}              rcb.rcb_stat_rsvd := msglen;  $            IpBufrLog (IPL_RCBDONE, SUBR+STATS, rcb.rcb_bufr, RCB_BLEN); $             DS_MDispose (rcb.rcb_mbufid, dummyerror);               IF dummyerror <> ips_GOOD_RETURN THEN                  BEGIN { IF error on dispose }                 { Log it, but it won't effect the outcome  	               {}  	 &               IpErrorLog (EL_ERROR, dummyerror, pr_pathref, SUBR+MBUFDSPS); &                END;  { IF error on dispose }                  END   { IF no_more_holes }                ELSE                  BEGIN { ELSE have more holes }              { Save the RCB and its statistics               {}  
            PostRcb (rcb); 
             { Check Ack Thresh for the inbound fragment.              { If it fails, discard the entire message               {}              ReassAckThresh (rcb, backref, frag);              mbufid := NO_MBUFID;              error  := ips_MSG_NOT_COMPLETE;               END;  { ELSE have more holes }               END   { IF reassembly required }              ELSE                BEGIN { ELSE reassembly NOT required }            { Strip the header off and hand back the options            { No Reassembly necessary           {}            ipheadlen := gv_ip_head.iphd.w1.headlen*4;            msglen := iphd.len - ipheadlen;           DS_MAdj (gv_ip_head.iphd_mbufid, ipheadlen, error);           IF error <> ips_GOOD_RETURN THEN               BEGIN { IF Adjust of header fails }   !            IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+HDADJ);  !             END;  { IF Adjust of header fails }                mbufid := iphd_mbufid;            opt_mbuf := NO_MBUFID;            END;  { ELSE reassembly NOT required }             END;  { WITH Global Variables }          99:   { Exit Point }   
   result := error;  
 
   END;  { ReassembleMsg } 
     $TITLE 'RedirectSource',PAGE$   {------------------------------------------------------------}  {           RedirectSource                                   }  {------------------------------------------------------------}      PROCEDURE RedirectSource             (    icmpcode : PosInt8;                   anhnode  : Int32);      {}  { Description   !{     This procedure will generate a REDIRECT message and send it  ! {     back to the source node using the current path record.  {   {     It will be called during Store and Forward Processing   {     when ANH to be used is on the same network as the   	{     source node. 	 {}  { Parameters  !{     icmpcode IN    The ICMP code qualifier (e.g. HOST_REDIRECT)  ! {     anhnode  IN    The gateway that is being used.  {}  { Side Effects  {}  { Global Data Structures  {     gv_icmp_msg       OUT   {}  { Error Handling  {     Errors will be logged when encountered.   {}  { Algorithm   {   {}  LABEL      99;   { Immediate return point }       CONST      SUBR  = SubrREDIRECTSOURCE;      &   REDIRECT_MSG = REDIRECT;    { Allows recasting this constant as PosInt8 } &     VAR   	   error : Int16;  	     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { RedirectSource }  WITH gv_icmp_msg, gv_path_rec DO     BEGIN { WITH global icmp message }      { IF processing an ICMP message, get out.     {}       IF gv_ip_head.iphd.w5.iphd_proto = ICMP_PROTO_NUM THEN Exit;           icmp_tc.msgtype := REDIRECT_MSG;      icmp_tc.msgcode := icmpcode;      icmp_cksum      := 0;     redirect.gateway.longint := anhnode;      RtnIcmpMsg (gv_icmp_msg, error);      IF error <> ips_GOOD_RETURN THEN         BEGIN { IF error }        IpErrorLog (EL_ERROR, error, pr_pathref, SUBR);         END;  { IF error }     END;  { WITH global icmp message }       99:   { Immediate return point }  END;  { RedirectSource }      $TITLE 'SfEchoInbound',PAGE$  {------------------------------------------------------------}  {              SfEchoInbound                                 }  {------------------------------------------------------------}  PROCEDURE SfEchoInbound              (VAR emsg_recvd : EventMsgType);       {}  {  Description  "{     This routine will handle the inbound data_indication messages  " ${     that are not destined for this local node, and the ICMP echo type  $ ${     processing where the reply is built before this routine is called. $ {}  {  Parameters   {     emsg_recvd        The event context for processing.   {}  {  Side Effects   {}  
{  Global Data Structures  
 ${     gv_path_rec    IN/OUT   Storage for both the Inbound and Outbound  $ {                             path records.   {     gv_ip_head     IN/OUT   {     gv_ip_globals  IN/OUT   {     gv_icmp_msg       OUT   {     gv_ngt_rec        OUT   {}  	{  Error Handling  	 {}  {  Algorithm  "{     IF the message can be transfered to the S&F memory pool, then  " !{        the inbound event message will be counted as being passed ! !{        to the ULP, the inbound path saved, and the outbound path ! {        record set up.   {   !{        IF this context is successfully set up, the event will be ! {        counted as arriving from a ULP on the outbound path,   "{        the message will be queued onto the Outbound Message Queue  " {        and the path set to the SEND_DATA state.   {   "{     Note also, that this routine will set the idle counter in each "  {     of these path records to sf_PATH_NOT_IDLE to indicate that   {     they have been recently used.   {}  LABEL   
   99;      { Exit Label } 
     CONST   "   SUBR = SubrSfEchoInbound;    { Subroutine ID number for logging } "    TRFAILED = 1;                { Error Logging Qualifier }      SRCQNCHFAILED  = 2;          { Source Quench send failed }       &   IP_SF_MM_FLAGS = MMFlagsType [int : 1];  { [0] = TRUE, check Ack Thresh } &     VAR      error     : Int16;      mmflags   : MMFlagsType;       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { SfEchoInbound }   WITH emsg_recvd, gv_path_rec, gv_ip_head DO      BEGIN { WITH Global Variables }     { Transfer this message to the S&F Memory pool      {}      mmflags := IP_SF_MM_FLAGS;      { Set TRUE for NO borrowing if the flag is set      {}   %   IF gv_ip_globals.ipg_debug.bits[-6] = 1 THEN mmflags.bits[-1] := TRUE;  %    DS_MBTransfer (iphd_mbufid, pr_mpool_id, mmflags, error);     IF error <> ips_GOOD_RETURN THEN         BEGIN { IF Transfer failed }         { The transfer of accounts did not work, drop the message          { and return a Source Quench message to the source.         {}        WITH gv_ip_globals.ipg_statistics DO           BEGIN { WITH }   %         ipgs_congested_packloss := DS_IncBt (ipgs_congested_packloss,1);  % 
         UpdatedIpg; 
          END;  { WITH }             IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+TRFAILED);        DropMessage (iphd_mbufid);  
      WITH gv_icmp_msg DO  
          BEGIN { WITH icmp header }            icmp_tc.msgtype := SOURCE_QUENCH;           icmp_tc.msgcode := 0;           icmp_cksum      := 0;           srcquench       := 0; { unused in ICMP msg }            END;  { WITH icmp header }         RtnIcmpMsg (gv_icmp_msg, error);        IF error <> ips_GOOD_RETURN THEN           BEGIN { IF Source quench failed }  #         IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+SRCQNCHFAILED); #          END;  { IF Source quench failed }  $      IpBufrLog (IPL_HEADLOG, SUBR+TRFAILED, iphd_bufr, BYTES_IP_HEAD);  $ 
      SavePathState; 
       Exit;         END;  { ELSE MACCT Transfer Failed }         GetNgtRec (iphd.dst, error);      WITH gv_ngt_rec DO         BEGIN { WITH above globals + gv_ngt_rec }         IF error <> 0 THEN           BEGIN { IF dest net unknown }           { Send an ICMP message and quit           {}            DropMessage (iphd_mbufid);            NotifySourceNode (DEST_UNREACH, NETWORK_UNREACH);           Exit;           END   { IF dest net unknown }            ELSE IF (GetNet (iphd.src) = GetNet (ngt_anh) ) THEN               BEGIN { IF Source network = on DCN }            IF GetNet (iphd.src) = GetNet (iphd.dst) THEN              BEGIN { IF source & dest on same net }              RedirectSource (HOST_REDIRECT, ngt_anh);              END   { IF source & dest on same net }            ELSE              BEGIN { ELSE source & dest on different nets }              RedirectSource (NETWORK_REDIRECT, ngt_anh);               END;  { ELSE source & dest on different nets }               END;  { IF Source network = on DCN }             END;  { WITH above globals + gv_ngt_rec }          { Count this message as going UP on this path     {}      pr_ulp_up_emscnt := pr_ulp_up_emscnt + 1;     UpdatedPr;       	   SavePathState;  	    {}      { Set up the outbound path      {}      GetPathRec (iphd.dst, NO_LOCAL, NO_PROTO, error);     IF error <> ips_GOOD_RETURN THEN         BEGIN { IF couldn't set up Outbound SF path }         IpErrorLog (EL_RESOURCELIM, error, 0, SUBR+PATHFAIL);         DropMessage (iphd_mbufid);  $      IpBufrLog (IPL_HEADLOG, SUBR+PATHFAIL, iphd_bufr, BYTES_IP_HEAD);  $       Exit;         END;  { IF couldn't set up Outbound SF path }          { Count this as an emsg coming down into the path record }      pr_ulp_dn_emscnt := pr_ulp_dn_emscnt + 1;      #   { If this path is a connectionless path, indicate that it has been  # 	   { recently used 	    {}      IF (pr_path_type = pr_REFED_CONNECTLESS)   OR        (pr_path_type = pr_UNREFED_CONNECTLESS) THEN        BEGIN { IF connectionless path }        pr_cl_idletime := cl_PATH_NOT_IDLE;         END;  { IF connectionless path }         { Link the message onto the outbound message queue      { Save the state before exiting.      {}      iphd.sum := END_OF_LIST;      UpdatedIphd;      QueueMsgonSendQue (iphd_mbufid);          SaveState;          END;  { WITH Global Variables }      
99:   { Exit Point } 
 END;  { SfEchoInbound }       $TITLE 'ValidateIpMsg',PAGE$  {------------------------------------------------------------}  {           ValidateIpMsg                                    }  {------------------------------------------------------------}      PROCEDURE ValidateIpMsg              (VAR error      : Int16);      {}  { Description   %{     This routine will check the header in the IP global header variable. % "{     IF it is found to be a valid packet, this routine will return  " %{     a good result, otherwise it will return a bad result indicating the  % {     reason.   {   { Parameters  "{     error          OUT      Error may return the following values: " {   #{                             ips_GOOD_RETURN  - The header is valid.  # ${                             ips_TTL_EXPIRED  - The header is too old.  $ ${                             ips_BAD_CHECKSUM - The header is corrupt.  $ {}  { Side Effects  {}  { Global Data Structures  {     gv_ip_head     IN       The IP Header being validated.  {     gv_ip_globals  IN/OUT   {}  { Error Handling  {}  { Algorithm   {     see the code below  {}      VAR   
   checksum : Int16; 
     BEGIN { ValidateIpMsg }   WITH gv_ip_head, gv_ip_globals.ipg_statistics DO     BEGIN { WITH Global Variables }         IF iphd.w1.version <> iphd_VERSION THEN        BEGIN { IF bad header version }         error := ips_BAD_HDVERSION;         END   { IF bad header version }          ELSE IF CheckSumHeader <> 0 THEN             BEGIN { IF Bad Checksum }         ipgs_chksm_packloss := DS_IncBt (ipgs_chksm_packloss,1);  	      UpdatedIpg;  	       error := ips_BAD_CHECKSUM;        END   { IF Bad Checksum }           ELSE            BEGIN { ELSE Valid Checksum }          { Time to live will only expire for S&F messages where the         { TTL value will go to 0 on exit.         { To save processing, check this case on inbound.         {         { For Terminal messages, accept all of them.        {}        IF (NOT LocalAddress (iphd.dst) ) AND            ((iphd.w5.iphd_ttl = 0) OR             (iphd.w5.iphd_ttl = 1)    )      THEN                BEGIN { IF TTL expired }   #         ipgs_ttl_exp_packloss := DS_IncBt (ipgs_ttl_exp_packloss,1);  # 
         UpdatedIpg; 
          error := ips_TTL_EXPIRED;           END   { IF TTL expired }             END;  { ELSE Valid Checksum }          END;  { WITH Global Variables }  END;  { ValidateIpMsg }       $PAGE$ (*   $TITLE 'template',PAGE$   {------------------------------------------------------------}  {           template                                         }  {------------------------------------------------------------}      {}  { Description   {}  { Parameters  {   {   {   {   {   {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}      	BEGIN { Template } 	 	END;  { Template } 	     *)      	$TITLE 'The End'$  	 
END   { IMPLEMENT }  
 .     { End of File }  