 $PASCAL '91790-1X105 REV.4010 <860311.1333>'  $ TITLE 'IP User Interface' $   $HEAP 0 $   $HEAPPARMS OFF$   $RECURSIVE OFF$   
$STANDARD_LEVEL 'HP1000'$  
 $DEBUG$   $AUTOPAGE ON$   $CODE_INFO ON$  	$CODE_OFFSETS ON$  	 $RANGE OFF$       MODULE ipui;  $ALIAS 'N$IPUI'       {}  {-------------------------------------------------------------  {   { (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS  { RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   { REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT  { THE PRIOR WRITTEN CONSENT OF THE HEWLETT PACKARD COMPANY.   {   {-------------------------------------------------------------  {}      {}  	{      NAME: IPUI  	 {    SOURCE: 91790-18105  	{     RELOC: NONE  	 {      PGMR: CWJ  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   {  8/3/85      cwj   IMPORT @.xpt   {  ----------  xxxx Submittal ------------  {  11/4/85     cwj   IP Address parsing bug fix   {  11/5/85     cwj   Add Part Number  {  ----------  N192 Submittal ------------  {  11/21/85    cwj   Module aliasing  {  ----------  N223 Submittal ------------  {  3/11/86     cwj   RANGE OFF not supplied bug fix   {                       SR# 033787  {  ----- Nxxx Submittal -----   {}  {  End of Modify section  {------------------------------------------------------------   {}      {}  { MODULE DESCRIPTION:   {   "{  This module contains the routines that users might call, such as  " 
{  NSINF and NSINIT. 
 {}  $TITLE 'IMPORT Section',PAGE$       IMPORT              $SEARCH 'phtm/bodec.xpt'$      bodec,               $SEARCH 'phtm/sodec.xpt'$      sodec;       $TITLE 'EXPORT Section',PAGE$   {------------------------------------------------------------}  {              Export Section                                }  {------------------------------------------------------------}  EXPORT  
{ IP Address parsing 
 { CONSTANT and TYPE declarations  {}  CONST   
   MAXARPASTR  = 20; 
 
   MAXARPAPAC  = 15; 
 
   MAXCLASSSTR =  1; 
     TYPE     ArpaStrType  = STRING[MAXARPASTR];      ArpaPacType  = PACKED ARRAY [1..MAXARPAPAC] OF CHAR;      ClassStrType = STRING [MAXCLASSSTR];           
PROCEDURE ArpaIpAdr  
            (    arpastr : ArpaStrType;              VAR ipadr   : Int32;              VAR result  : Int16);       PROCEDURE ArpaPacIpAdr    $ALIAS 'ArpaPacIpAdr'$             (    arpapac : ArpaPacType;              VAR ipadr   : Int32;              VAR result  : Int16);       
PROCEDURE IpArpaPac  
            (    ipadr : Int32;              VAR buffer : ArpaPacType);      
FUNCTION  IpArpaStr  
            (    ipadr : Int32) : ArpaStrType;           
FUNCTION  IpClassStr 
            (    ipadr : Int32) : ClassStrType;          IMPLEMENT       $TITLE 'Forward/Externals',PAGE$  {------------------------------------------------------------}  {              Forward/External Declarations                 }  {------------------------------------------------------------}      TYPE      #   ParsedType = PACKED ARRAY [1..33] OF Int16;   { for PARSE routine}  #         PROCEDURE Parse              (    arpapac   : ArpaPacType ;               VAR charcount : Int16;              VAR parsedbuf : ParsedType );               EXTERNAL;           
$TITLE 'Procedures',PAGE$  
 {------------------------------------------------------------}  {              Procedures                                    }  {------------------------------------------------------------}          $TITLE 'ArpaIpAdr',PAGE$  {------------------------------------------------------------}  {           ArpaIpAdr                                        }  {------------------------------------------------------------}      
PROCEDURE ArpaIpAdr  
            (    arpastr : ArpaStrType;              VAR ipadr   : Int32;              VAR result  : Int16);       {}  { Description   {     This routine will take as input, a string containing  {     an IP address in the xxx.xxx.xxx.xxx format.  {     The routine will parse this address and return the  {     IP address in an Int32;   {   "{     This routine assumes that addresses obey the following rules:  " {   {        1)    0 <= xxx < 256    {        2)    There are 4 sets of xxx with '.'s as seperators.    {}  { Parameters  !{     arpastr  IN    A string which contains an ASCII IP address.  !  {                    in the format 'xxx.xxx.xxx.xxx' where each    "{                    xxx represents a byte in the 2 word IP address. " {   "{     ipadr       OUT   The Int32 address represented by the number. " {   &{     result      OUT   The result of the parsing operation. 0 = Good Return & {                          0 = Good Return  '{                         -1 = BAD_IP_ADDRESS - String is not in this format.  ' {}  { Error Handling  ${     If the passed in string does not follow the format described above $ {     result will be set to BAD_IP_ADDRESS.   {}  LABEL      99;   { Error Exit }       CONST   "   BAD_IP_ADDRESS = -1;    { String passed in is not an IP address } "     VAR      a, b, c, d : Int32;     { Base 256 digits }     npos       : Int16;     pos        : Int16;     i          : Int16;     ipaddress  : AddressType;     error      : Int16;     numofdigits : Int16;      numofdots   : Int16;       	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
        PROCEDURE ExitIfBadDigits          (VAR numofdigits : Int16);            BEGIN { ExitIfBadDigits }         IF (numofdigits <= 0) OR           (numofdigits > 3)  THEN               BEGIN { IF bad number of digits }           error := BAD_IP_ADDRESS;            Exit;           END   { IF bad number of digits }             ELSE                BEGIN { ELSE number of digits is ok }  
         numofdigits := 0; 
          END;  { ELSE number of digits is ok }        END;  { ExitIfBadDigits }       
BEGIN { ArpaIpAdr }  
 error := 0;   ipadr := 0;    { IP Address for error return }      { Check the format of the input string  {}  {  Remove leading and trailing blanks.  {}  arpastr := StrRtrim (StrLtrim (arpastr) );      	numofdigits := 0;  	 	numofdots   := 0;  	 FOR i := 1 TO StrLen (arpastr) DO   
   BEGIN { FOR each char } 
    CASE arpastr[i] OF         '0'..'9':   BEGIN { Number }                    numofdigits := numofdigits + 1;                     END;  { Number }            '.':        BEGIN { DOT }                     numofdots := numofdots + 1;                     ExitIfBadDigits (numofdigits);                    END;  { DOT }             OTHERWISE            error := BAD_IP_ADDRESS;            Exit;           END;  { CASE }       
   END;  { FOR each char } 
     { If the last digits are incorrect,   { or if the number of dots is incorrect,  { Exit with an error.   {}  ExitIfBadDigits (numofdigits);  IF numofdots <> 3 THEN     BEGIN { IF bad number of dots }     error := BAD_IP_ADDRESS;      Exit;     END;  { IF bad number of dots }      { All is well, so continue with the parsing.  {   { Change 3 '.'s to ',' so StrRead can parse it  {}  	FOR i := 1 TO 3 DO 	 
   BEGIN { FOR each '.' }  
    pos := StrPos (arpastr, '.');  	   IF pos > 0 THEN 	       BEGIN { IF found '.' }        arpastr [pos] := ' ';         END   { IF found '.' }      ELSE        BEGIN { ELSE bad format address }         error := BAD_IP_ADDRESS;        Exit;         END;  { ELSE bad format address }       
   END;  { FOR each '.' }  
     
{ Fetch the numbers  
 {}  StrRead (arpastr, 1, npos, a, b, c, d);   { Check the range on these numbers  {}  IF (a = a MOD 256) AND     (b = b MOD 256) AND     (c = c MOD 256) AND     (d = d MOD 256) THEN          BEGIN { IF digits are within range }      ipaddress.bytes[0] := a;      ipaddress.bytes[1] := b;      ipaddress.bytes[2] := c;      ipaddress.bytes[3] := d;      END   { IF digits are within range }        ELSE          BEGIN { ELSE illegal digit }      error := BAD_IP_ADDRESS;      Exit;     END;  { ELSE illegal digit }       ipadr := ipaddress.longint;       
99:   { Exit Point } 
 result := error;  
END;  { ArpaIpAdr }  
     $TITLE 'ArpaPacIpAdr',PAGE$   {------------------------------------------------------------}  {           ArpaPacIpAdr                                     }  {------------------------------------------------------------}      PROCEDURE ArpaPacIpAdr             (    arpapac : ArpaPacType;              VAR ipadr   : Int32;              VAR result  : Int16);       {}  { Description    {     This routine will take as input, a packed array containing   {     an IP address in the xxx.xxx.xxx.xxx format.  {     The routine will parse this address and return the  {     IP address in an Int32;   {   "{     This routine assumes that addresses obey the following rules:  " {   {        1)    0 <= xxx < 256    {        2)    There are 4 sets of xxx with '.'s as seperators.    {   {}  { Parameters  !{     arpapac  IN    A string which contains an ASCII IP address.  !  {                    in the format 'xxx.xxx.xxx.xxx' where each    "{                    xxx represents a byte in the 2 word IP address. " {   "{     ipadr       OUT   The Int32 address represented by the number. " {   &{     result      OUT   The result of the parsing operation. 0 = Good Return & {                          0 = Good Return  '{                         -1 = BAD_IP_ADDRESS - String is not in this format.  ' {}  { Error Handling  ${     If the passed in array does not follow the format described above  $ {     result will be set to BAD_IP_ADDRESS.   {}  LABEL      99;   { Error Exit }       CONST   "   BAD_IP_ADDRESS = -1;    { String passed in is not an IP address } " VAR      charcount  : Int16;     parsedbuf  : ParsedType ;     i          : Int16;     ipaddress  : AddressType;     error      : Int16;      	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { ArpaPacIpAdr }  error := 0;   ipadr := 0;    { IP Address for error return }  !charcount := MAXARPAPAC ;    { number of characters to be parsed } !     { Change 3 '.'s to ',' so StrRead can parse it  {}  FOR i := 1 TO MAXARPAPAC DO   
   BEGIN { FOR each item } 
    CASE arpapac[i] OF         '.',#0:  BEGIN { IF . or null }                  arpapac [i] := ',' ;                  END ; { IF . or null }             OTHERWISE   
               BEGIN 
                { Ignore all other characters }  
               END;  
 
      END;  { CASE } 
     
   END;  { FOR each item } 
     
{ Fetch the numbers  
 {}  PARSE (arpapac , charcount , parsedbuf ) ;  { Check the range on these numbers  {}  #IF (parsedbuf[ 1] = 1 ) AND (parsedbuf[ 2] = parsedbuf[ 2]MOD 256) AND # #   (parsedbuf[ 5] = 1 ) AND (parsedbuf[ 6] = parsedbuf[ 6]MOD 256) AND # #   (parsedbuf[ 9] = 1 ) AND (parsedbuf[10] = parsedbuf[10]MOD 256) AND # $   (parsedbuf[13] = 1 ) AND (parsedbuf[14] = parsedbuf[14]MOD 256) THEN  $        BEGIN { IF digits are within range }      ipaddress.bytes[0] := parsedbuf[ 2] ;     ipaddress.bytes[1] := parsedbuf[ 6] ;     ipaddress.bytes[2] := parsedbuf[10] ;     ipaddress.bytes[3] := parsedbuf[14] ;     END   { IF digits are within range }        ELSE          BEGIN { ELSE illegal digit }      error := BAD_IP_ADDRESS;      Exit;     END;  { ELSE illegal digit }       ipadr := ipaddress.longint;       
99:   { Exit Point } 
 result := error;  END;  { ArpaPacIpAdr }      $TITLE 'IpArpaPac',PAGE$  {------------------------------------------------------------}  {           IpArpaPac                                        }  {------------------------------------------------------------}      
PROCEDURE IpArpaPac  
            (    ipadr : Int32;              VAR buffer : ArpaPacType);      {}  { Description   #{     This routine will take and IP address and return a PAC formatted # {     as:   {           xxx.xxx.xxx.xxx   {   {     where xxx are three digits and may be between 255-0.  {     Leading zeros in all positions will be supplied.  {     (NOTE that xxx functions as a base 256 digit).  {   {     SEE ALSO IpArpaStr  {}  { Parameters  {     ipadr    IN    The IP address to format   {   "{     buffer      OUT      The PAC containing the formatted address. " {}      CONST      DOT    = '.';      TYPE     DArray   = ARRAY [1..3] OF Int16;     DigitArrayType = PACKED ARRAY [0..9] OF CHAR;      CONST      DIVISORS = DArray [100,10,1];     DIGITS = DigitArrayType ['0123456789'];      VAR   	   npos  : Int16;  	 	   i,j   : Int16;  	 	   bytes : RECORD  	 
      CASE Int16 OF  
          0:    (longint : Int32);            1:    (bytes   : PACKED ARRAY [1..4] OF posInt8);           END;  { bytes }         word : PACKED RECORD   
      CASE Int16 OF  
          0:    (int : Int16);            1:    (pad : PosInt8;                  byt : PosInt8);            END;  { word }       
BEGIN { IpArpaPac }  
 bytes.longint := ipadr;   npos := 1;      	FOR i := 1 TO 4 DO 	    BEGIN { FOR each base 256 digit }  	   word.int := 0;  	    word.byt := bytes.bytes [i];          FOR j := 1 TO 3 DO         BEGIN { FOR each base 10 digit }        buffer [npos] := DIGITS [word.int DIV divisors [j]];        word.int := word.int MOD divisors [j];        npos := npos + 1;         END;  { FOR each base 10 digit }         IF i < 4 THEN buffer [npos] := DOT;  
   npos := npos + 1; 
        END;  { FOR each base 256 digit }          
END;  { IpArpaPac }  
     $TITLE 'IpArpaStr',PAGE$  {------------------------------------------------------------}  {           IpArpaStr                                        }  {------------------------------------------------------------}      
FUNCTION  IpArpaStr  
            (    ipadr : Int32) : ArpaStrType;       {}  { Description   ${     This routine will take an IP address and return a string formated  $ {     as:   {              xxx.xxx.xxx.xxx  {   {     where xxx are three digits and may be between 255-0.  !{     Leading zeros in all positions but the left most xxx will be ! {     supplied. (NOTE that xxx functions as a base 256 digit).  {}  { Parameters  {     ipadr    IN          The IP Address to format   {   ${     function    OUT      The string containing the Arpa format address $ {   {}      CONST   	   ZEROS = '000';  	     VAR      outst     : STRING[MAXARPASTR+1];  
   digit     : STRING[3];  
    remainder : Int32;      spos      : Int16;      npos      : Int16;      i         : Int16;      tmpipadr  : AddressType;       
BEGIN { IpArpaStr }  
 
tmpipadr.longint := ipadr; 
     
{ Build the output string  
 {  (first initialize the strings)   {}  
SetStrLen (outst,0); 
 
SetStrLen (digit,0); 
 	FOR i := 0 TO 3 DO 	    BEGIN { FOR each field }      StrWrite (digit, 1, npos, tmpipadr.bytes[i]:1);  #   StrAppend (outst, Str(ZEROS,1,4-npos) + Str(digit,1,npos-1) + '.'); #    END;  { FOR each field }       { Remove the extra '.' at the end   { and return the string   {}  IpArpaStr := Str (outst, 1, StrLen (outst) -1);       
END;  { IpArpaStr }  
     
$TITLE 'IpClassStr',PAGE$  
 {------------------------------------------------------------}   {           IpClassStr                                         }   {------------------------------------------------------------}      
FUNCTION  IpClassStr 
            (    ipadr : Int32) : ClassStrType;      {}  { Description   {     This routine will take an IP address and return the   {     character which indicates the class of the address  {     (i.e. A, B, C, or X).   {}  { Parameters  {     ipadr    IN       The IP address being parsed.  {   {     IpClassStr  OUT   The class of the address.   {                       A, B, C, or X   {}  { Algorithm   {   {}         CONST  
      CLASS_A =  0;  
 
      CLASS_B = -2;  
 
      CLASS_C = -2;  
 
      CLASS_X = -1;  
        TYPE         IpNetAdrType = PACKED RECORD           CASE Int16 OF              0: (classA : PosInt1;                   pada   : Int15;                   wda2   : Int16);                  1: (classB : Int2;                  padb   : Int14;                   wdb2   : Int16);                  2: (classC : Int3;                  padc   : Int13;                   wdc2   : Int16);                  3: (classX : Int3;                  padx   : Int13;                   wdx2   : Int16);                  4: (bigint : Int32);  
            END;  { CASE } 
        VAR        word     : IpNetAdrType;      
BEGIN { IpClassStr } 
 word.bigint := ipadr;       {}  	{ Select the mask  	 {}  IF      word.classA = CLASS_A THEN IpClassStr := 'A'  ELSE IF word.classB = CLASS_B THEN IpClassStr := 'B'  ELSE IF word.classC = CLASS_C THEN IpClassStr := 'C'  ELSE IF word.classX = CLASS_X THEN IpClassStr := 'X';       
END;  { IpClassStr } 
     $TITLE ' ',PAGE$      	$TITLE 'The End'$  	 
END   { IMPLEMENT }  
 .     { End of File }  