 $PASCAL '91790-1X106 REV.4010 <860327.1457>'      
$STANDARD_LEVEL 'HP1000' $ 
 $DEBUG $  $HEAP 0$  $RECURSIVE OFF$       MODULE LAN8;      %{------------------------------------------------------------------------  %     "   (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986.  ALL RIGHTS RESERVED. "    NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED, REPRODUCED, OR   "   TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR WRITTEN  "    CONSENT OF THE HEWLETT-PACKARD COMPANY.      % ------------------------------------------------------------------------} %     {}  
{        NAME : Lan8 
 {      SOURCE : 91790-18106   
{       RELOC : NONE 
 
{        PGMR : ASH  
 {}      ${----------------------------------------------------------------------- $    MODIFICATIONS  6/21/85  ash  #   Remove EnterCritical calls in Build Path.  We are already critical. #     Add check in build path for ip address.  We were trashing the      netname.      Add StoreLRT in Send request.  Ref counts not incremented.      Add down_pid and down_ref in BuildPath   6/24/85  ash  #   More of a general note.  MaxLANLu (max cards genned in) is 3.  The  # #   driver can handle 8.  To add more, change the constants MAXLANLU to # #   the number of cards needed, and then LANGBLEN must be increased by  #    7 words for each additional card.         Add default multicast addresses for probe target and proxy.  7/10/85      Bug in split.  Pathref of 0 should not be allowed.      Make BuildPath search for local address.   8/5/85     Remove global variable err_msg.  Not needed.      Make LANSearch check for LocalAddress.   ------------------- POST ------------------------------------   8/13/85      Remove extra EnterCrit in In802 and Out802      Clean up SendRequest   ------------------- POST ------------------------------------   8/16/85   $   Create separate outbound event handler for the send_request in INPRO. $ "      ProSw was trashing the return point if both the inbound and OB " 
      were the same. 
 8/27/85      Add Kill request handling to InbndOut802   ------------------- POST ------------------------------------   9/10/85      Remove IP address from multicast path records     Clear IP address when adding to the free list  9/11/85   &   Clean up reference counting in LANSearch, LANGivePath and KillIndication  & 9/13/85   $   In PreparetoSend, find up_pid first so if we have to escape, we send  $       a kill indication to the right pid.      Add pid to the error log in refcntchk.       Look for a multicast path in use before allocating a new one.    ------------------- POST --------------------------------------    9/23/85       Send Kill indication to inbound event handler in Send Request      Clean up location codes in Send Request for event logging  9/25/85      Remove negative check in refcntchk because of roll around.   !------------------- POST ----------------------------------------  ! 10/29/85     Correct IP sap to 6  !------------------- POST ----------------------------------------  ! 11/1/85      Remove negative check in Kill Request for rollaround.     Ensure we send no error return back through ProSw  !------------------- POST ----------------------------------------  ! 12/3/85      Accomodate 32 bit reference counts   !------------------- POST ----------------------------------------  ! 1/11/86      If tracing is enabled, add correct station address      Correct bugs in long pkt handling in SendRequest      Move MAXPKTLEN -> MAX802PKT in IPDEC   !------------------- POST ----------------------------------------  ! 2/26/86  cwj     LanSearch would return incorrectly if any but the 1st LU      in the system is used. REPEAT..UNTIL loop terminated      prematurely due to an uninitialized variable.  !------------------- POST ----------------------------------------  ! 
3/19/86  ash   n383  
   DATAIndication, IEEE802BuildPath     SR#035329 Decrement path refs if internal error    KILLIndication     SR#034819 initialize lu_err    LANSearch      SR#035337 Decrement path refs if internal error     SR#035592 Send V.Addr request out appropriate LU                Log mmgr error instead of LAN_Internal_error.    LinkUp               Return LAN_UnknownLU when appropriate    MCSendRequest      SR#035261 Make output good for tracing                Check for error in MDispose call   &   SR#034801 Convert local constants PROXY and TARGET to those used in SODEC & "   SR#035501 Overwrite all 6 bytes of mcast addr when more than 1 LU "   PrepareToSend   $   SR#035311 Send LI_LinkDown error only when link is down, not for some $              other error          {}  { PROGRAM DESCRIPTION :   {   !{  This is the module which contains the outbound routines for LAN ! {  and the LAN specific declarations  {}  IMPORT                       $ SEARCH 'phtm/bodec.xpt'  bodec,                       $ search 'phtm/sodec.xpt'  sodec,                       $ SEARCH 'phtm/mmdec.xpt'  mmdec,                       $ SEARCH 'phtm/mmext.xpt'  ds_mm,                       $ SEARCH 'phtm/trcmod.rel'   trcmod,                        $ search 'phtm/lklb.rel'   lk,                { contains declaration for appendage buff }                        $ SEARCH 'phtm/tmrdec.rel, phtm/ipdec.rel'    ipdec,  $WIDTH 150$   +$search 'phtm/sigmod.rel,phtm/iplib.rel,phtm/tmrdec.rel,phtm/tuser.rel,phtm/ipdb.rel'$ + $WIDTH 80   iplib;  $ PAGE $  EXPORT  CONST       
   EMPTYLU     = -2; 
        HPEXPSAP    = 252;      IPSAP       =   6;   { given by the IEEE }      PROBESAP    = 1283;  { Probe's canonical address }      UP_PIDCT    = 2;     { number of up_pids lan knows of }             { Length constants }      IPADDRLEN   = 2;     { 2 words for IP address }     PIDLEN      = 1;     { length of PID in ProtoMap table }   
   SAPLEN      = 1;  
 
   EXPSAPLEN   = 2;  
    LANGB_LEN   = 35;    { Length of the lan global block }  %   LRTELE_LEN  = 12;    { Length of an element in the LAN routing table }  % $   PMTELE_LEN  = 3;     { Length of element in Protocol Mapping table }  $ !   VNADDRLEN   = 3;     { length of the Virtual network address }  !        HDRLEN = 17;      { IEEE standard header length is 17 }     EXPHDRLEN = 24;   { HP expansion header length }          { Offset constants into LRT }  	   STATIONOFF = 0; 	    IPADOFF = 3;      LUOFF = 9;   	   STATUSOFF = 10; 	        { Offset constants into PMT }     PIDOFF = 0;     SAPOFF = 1;  	   EXPSAPOFF = 2;  	        { Word offsets into the path report element  }   	   PR_STATOFF = 2; 	 	   PR_SAPOFF = 1;  	        LANPATHELELEN = 8;          { Byte offsets into the header }   	   HD_SAPOff = 14; 	        LANEB = 4000;         { Constants for error returns }     LI_LINKDOWN       = LANEB + 1;      LI_NOTFOUND       = LANEB + 2;   { Used in table searches }  $   LI_NORESOURCES    = LANEB + 3; { when there isn't room in the table } $ "   LI_IMPOSSIBLEPATH = LANEB + 4; { when the path cannot be built }  " !   LI_INTERNALERROR  = LANEB + 5; { a should_never_happen error }  ! $   LI_PKTTOOLONG     = LANEB + 6; { another should_never_happen error }  $     LAN_PKTINVALID    = LANEB + 7;  { an invalid packet arrived }   "   LAN_UNKNOWNLU     = LANEB + 8;  { table search for an LU failed } "        { constants for depletable resources }      LRT            = 13;          { constants for procedure identifiers for error logging }  
   LANERPT        = 1000;  
        ADDELEMENT     = LANERPT * 1;     IEBUILDPATH    = LANERPT * 2;     DATA_IND       = LANERPT * 3;     IN_802         = LANERPT * 4;     INBNDOUT_802   = LANERPT * 5;     KILL_IND       = LANERPT * 6;     KILL_REQ       = LANERPT * 7;     LAN_GIVEPATH   = LANERPT * 8;     LAN_MAPVNA     = LANERPT * 9;     LAN_SEARCH     = LANERPT * 10;      MC_SEND_REQ    = LANERPT * 11;      OUT_802        = LANERPT * 12;      REFCOUNT       = LANERPT * 13;      SEND_REQ       = LANERPT * 14;           
   { Miscellaneia }  
 "   LINKISDOWN  = -5;    { Used for marking link status in LRTable }  " 
   LINKISUP    =  5; 
 #   INUSE       =  1;     { Used for marking dynamic elements in LRT }  # 
   NOTINUSE    =  0; 
 
   ENDLIST     = -1; 
 #   INBNDATA    = -19;   { used for event trace to mark inbound data }  #    MAXLRT      = 512;   
   MAXPMT      = 32; 
    UI          = 3;     { control field }   $   BYT_PRE_LEN = 14;    { bytes in the header before the length field }  $    HARDERROR   = 8;     { error from the driver }          KI_LEN      =  5;    { length of a kill indication emsg }     DI_LEN      = 13;    { length of a data indication emsg }     SR_LEN      =  9;    { length of a send request emsg }       
   MAXLANLU    = 3;  
     $ PAGE $      CONST  { used at init time }     DEFAULT_STATION   = StatAddr [STATADDRLEN of 0];      { default probe target multicast address }      DEFAULT_T_MCAST   = StatAddr [2304, 2304, 1];     { default probe proxy multicast address }     DEFAULT_P_MCAST   = StatAddr [2304, 2304, 2];      TYPE     { Service Access Point or dispatch address }   	   Sap = PosInt8;  	         ${---------------------------------------------------------------------}  $ ${                     LAN HEADER                                      }  $ ${                                                                     }  $ ${  The formal declaration of the lan header.  This declaration        }  $ ${  assumes that all messages AdvanceDS LAN will send or receive       }  $ ${  will contain the HP expansion SAPs or IEEE's IP SAP.               }  $ ${  Therefore the record is a variant type, since there may not be an  }  $ ${  expansion SAPs.                                                    }  $ ${                                                                     }  $ ${                                                                     }  $ ${    C: Individual or group address      (I=0,G=1)                    }  $ ${    A: Locally or Globally administered (G=0,L=1)                    }  $ ${    Length: In octets from the first bit after the length field      }  $ ${        max length of the entire packet is 1514 bytes =>             }  $ ${        max value of Length =  1502                                  }  $ ${    G: Individual or group SAP          (I=0,G=1)                    }  $ ${    R: If set, this address is assigned by IEEE.  In the declaration,}  $ ${        this bit is incorporated into the SAP field.                 }  $ ${    C: Command or response frame        (C=0,R=1)                    }  $ ${    Control: Type of frame (UI, TEST, XID)                           }  $ ${    PAD: Pad bytes.  Present only if value of SSAP or DSAP = 374b    }  $ ${    DXSAP: Expansion SAP.  Present only if value of DSAP=374b        }  $ ${    SXSAP: Expansion SAP.  Present only if value of SSAP=374b        }  $ ${                                                                     }  $ ${     NOTE: 374b is the special HP Expansion SAP, indicating the      }  $ ${     presence of the special fields.                                 }  $ {}      $ PAGE $  ${        15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0              }  $ ${       +--+--+-----------+--+--+-----------------+--+--+             }  $ ${       |                 | A| C|                       |             }  $ ${       +                 +--+--+                       +             {  $ ${       |         Destination Station                   |             }  $ ${       +            Address (46 Bits)                  +             }  $ ${       |                                               |             }  $ ${       +-----------------+--+--+-----------------+--+--+             }  $ ${       |                 | A| C|                       |             }  $ ${       +                 +--+--+                       +             }  $ ${       |         Source Station                        |             }  $ ${       +            Address (46 Bits)                  +             }  $ ${       |                                               |             }  $ ${       +-----------------------------------------------+             }  $ ${       |               Length (16 bits)                |             }  $ ${       +-----------------+--+--+-----------------+--+--+             }  $ ${       |  DSAP (6 Bits)  | R| G|  SSAP (6 bits)  | R| C|             }  $ ${       +-----------------+--+--+-----------------+--+--+             }  $ ${       |    Control (8 bits)   |     PAD (8 bits)      |             }  $ ${       +-----------------------+-----------------------+             }  $ ${       |                 PAD (16 bits)                 |             }  $ ${       +-----------------------+-----------------------+             }  $ ${       |        DXSAP (16 bits)                        |             }  $ ${       +-----------------------------------------------+             }  $ ${       |        SXSAP (16 bits)                        |             }  $ ${       +-----------------------------------------------+             }  $ ${       |                                               |             }  $ ${       |                                               |             }  $ ${       |          Beginning of "DATA"                  |             }  $ ${       |                                               |             }  $ ${       |                                               |             }  $ ${       .                                               .             }  $ ${       .                                               .             }  $ ${       .                                               .             }  $ ${       |                                               |             }  $ ${       +-----------------------------------------------+             }  $ ${                                                                     }  $     $ PAGE$       
   LanHead = PACKED RECORD 
               dsta : StatAddr;   { destination address }                ssta : StatAddr;   { source address      }                Length : Int16;   
              Dsap : Sap;  
               Ssap : PACKED RECORD CASE BOOLEAN OF                    TRUE  : (byt : SAP);                    FALSE : (adr : PosInt7;                              cmnd : 0..1);  
                     END;  
               CASE BOOLEAN OF   !               TRUE : (ctl : byte); { 'Standard' 17 byte header }  !                FALSE : (XCtl : Byte; { HP expansion header }                         Pad1 : Byte;                          Pad2 : Int16;                         DXSap : Int16;                          Sxsap : Int16);               END;  { LanHead }  $page   ${----------------------------------------------------------------------} $ ${                                                                      } $ ${                    Lan Routing Table                                 } $ ${                                                                      } $ ${----------------------------------------------------------------------} $ {}  ${  This is the table from which LAN derives all of its external routing  $ "{  information.  It contains the Station address to Virtual Network  " "{  address mapping, including the LU which must be used for outbound " {  traffic.  In addition, it has the up_ and down_ reference  "{  counts which are maintained in order to determine when to kill a  " {  path.  {   "{  If the node is connected to "N" LANs, the first N entries in the  " "{  LRT will be static, and will map the network part of the Virtual  " #{  Network Address to the LU.  The station address field will have the # #{  broadcast station address.  The next N entries are also static and  # "{  contain all local station addresses and the corresponding Virtual " 
{  Network Address.  
 {}  ${                                                                      } $ ${                                                                      } $ ${                                                                      } $ ${               +---------------------------------------+              } $ ${               |                                       |              } $ ${               +                                       +              } $ ${               |          Station address              |              } $ ${               +            ( 3 words )                +              } $ ${               |                                       |              } $ ${               +---------------------------------------+              } $ ${               |          IP address or                |              } $ ${               +                                       +              } $ ${               |  Virtual Network Address (2 words)    |              } $ ${               +-------------------+-------------------+              } $ ${               |                                       |              } $ ${               +         SndULPCt    ( 2 words )       +              } $ ${               |                                       |              } $ ${               +---------------------------------------+              } $ ${               |                                       |              } $ ${               +         RcvULPCt    ( 2 words )       +              } $ ${               |                                       |              } $ ${               +---------------------------------------+              } $ ${               |           LU        ( 1 word )        |              } $ ${               +---------------------------------------+              } $ ${               |           status    ( 1 word)         |              } $ ${               +---------------------------------------+              } $ ${               |           next      ( 1 word)         |              } $ ${               +---------------------------------------+              } $ ${                                                                      } $ ${  NOTE:                                                               } $ ${     LU and status require fewer than 16 bits, but will occupy a      } $ ${     full word for speed of access.                                   } $ ${                                                                      } $     $ page $  TYPE     IPAddrType = RECORD CASE BOOLEAN OF              TRUE : (Addr  : Int32);               FALSE : (Arry : ARRAY [1..2] OF Int16);   
                END; 
        LRTElement = RECORD CASE BOOLEAN of              TRUE : ( bufr     : Int16);               FALSE : (LANAddr  : StatAddr;                        IPAddr   : IPAddrType;                        SndULPCt : Int32;                       RcvULPCt : Int32;                       LU       : Int16;                       status   : Int16;                       next     : Int16);   
                END; 
 $page   ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${                 Path Report Element (LANProtoElementRecord)         }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $     ${                ---------------------------                          }  $ ${                | IEEE802    |   length   |                          }  $ ${                ---------------------------                          }  $ ${                |   rsvd     |  dsap[1]   |                          }  $ ${                ---------------------------                          }  $ ${                |     stationAddr[1]      |                          }  $ ${                ---------------------------                          }  $ ${                |     stationAddr[2]      |                          }  $ ${                ---------------------------                          }  $ ${                |     stationaddr[3]      |                          }  $ ${                ---------------------------                          }  $ ${                                                                     }  $ ${                                                                     }  $ ${  Where IEEE802 is the LAN PID, length is  8 (bytes), dsap[1] is     }  $ ${  the dsap field in the header, and must always be IP at first       }  $ ${  release, and stationaddr is the local station                      }  $ ${  address which corresponds to the virtual network address           }  $ ${                                                                     }  $ ${                                                                     }  $ {}  TYPE     LANProtoElementRecord = PACKED RECORD           CASE Int16 OF             1 : (Int : Int16);              2 : (pid : byte;                   len : byte;                   rsv : byte;                   uppid_sap : byte;                   OurAddr : StatAddr);                  END;  { lanprotorecord }          $page   %{------------------------------------------------------------------------} % %{                                                                        } % %{                       Protocol Mapping Table                           } % %{                                                                        } % %{------------------------------------------------------------------------} % {   #{  The protocol mapping table is used to map the protocol identifiers  # #{  which are used by ProSw and are 1000 specific, to the SAP field in  # {  the LAN header.  SAPs are known throughout the network.  If  {  the SAP is an IEEE defined SAP, the expansion SAP field is   {  undefined.   {   {   "{                 PID (16 bits)    SAP (16 bits)    ExpSap (16 bits) " #{               +----------------+-----------------+----------------+  # #{               |                |                 |                |  # #{               +----------------+-----------------+----------------+  # #{               |                |                 |                |  # #{               +----------------+-----------------+----------------+  # {   {   {  Fields:  {   {  PID : Protocol Identifier.  8 bits, but search routines  "{        (DS_SerialF&F) require search fields to be alligned on word " 
{        boundaries. 
 {   {  SAP : LAN SAP which will appear in the DSAP and SSAP field   {        in the LAN header.  Defined to be 8 bits, but must be  ${        stored in 16 bits for access.  The least significant bit of the $ !{        SAP is used for purposes other than addressing and so is  ! !{        cleared before storing it, or comparing it to any other.  ! !{  ExpSAP : HP expansion SAP, also known as the Canonical Address. ! "{        This field contains the canonical address which corresponds " #{        to the given PID if the SAP field contains the  HP expansion  # {        SAP (374b).  It is otherwise undefined.  {   {  Search key: PID or (SAP + ExpSAP)  {}      SapArray = ARRAY [1..2] of Int16;       PMTElement = RECORD CASE BOOLEAN OF            TRUE : (bufr : Int16);            FALSE : (PID : Int16;                    SAP : SapArray);               END; { PmtElement }  $ PAGE $       {-------------------------------------------------------------}     {                                                             }     {           LAN Global Block                                  }     {                                                             }     {-------------------------------------------------------------}    { NOTE*   "{ This declaration contains all global information needed by the LAN "  {  software.  It contains an array of records which contain the    {  multicast addresses needed by PROBE.   {}      LANGlobalType = RECORD CASE BOOLEAN OF        TRUE  : ( bufr : Buffertype);   #      FALSE : ( netcount : Int16;  { number of networks we belong to } # !                pidcount : Int16;  { number of SAPs Lan knows of } !                  lrtlen   : Int16;  { total length of the table }       !                mcast    :         { array of m'cast addrs + LU }  !                            ARRAY [1..MAXLANLU] of mcastinfo;      #                NextFree : Int16;  { points to head of the free list } #                    { Now the statistics }   !                err      : RECORD CASE Int16 OF  { driver errors } !                        1 : (int : Int16);   "                       2 : (bits : PACKED ARRAY[0..15] of BOOLEAN);  "                            END;  { case }   !                NDropped : Int16;  { number of messages dropped }  ! $                NDI      : Int32;  { number of data indications rec'd }  $ $                NKI      : Int32;  { number of kill indications rec'd }  $ "                NSR      : Int32;  { number of send requests rec'd } " "                NKR      : Int32); { number of kill requests rec'd } " 
         END; { globals }  
     $page$  "{------------------------------------------------------------------} " "{                                                                  } " "{                   PathRefType                                    } " "{                                                                  } " "{------------------------------------------------------------------} " {   #{ This declaration is for a path reference which is the concatenation  # "{  of two table indices.  The fastest way to concatenate them is to  " {  use a PASCAL variant record.   {}         PathRefType = RECORD CASE BOOLEAN OF         TRUE  : (bufr : Int16);         FALSE : (ref : PACKED RECORD                       statindex : Posint10;                       pidindex  : Posint6;   
                     END); 
                  END;                           $SUBTITLE 'Procedures and Functions', PAGE $  {------------------------------------------------------}  {   Exported Procedures and Functions   {------------------------------------------------------}      {------------------------------------------------------}  {              FUNCTION AddToLRT  {------------------------------------------------------}      {  Add an element to the LAN Routing Table }      	FUNCTION AddToLRT  	    (VAR StationAddr : StatAddr;       VAR IPAddress   : Int32;      VAR Gbl         : LANGlobalType;          InLU        : Int16;      VAR ierr        : Int16)                      : Int16;      !{----------------------------------------------------------------} ! !{   IEEE 802 ADD ELEMENT                                         } ! !{----------------------------------------------------------------} !     PROCEDURE IEEE802AddElement      ( VAR sp        : Int16;        VAR stack     : TemplateControlStack;       VAR crec      : TemplateControlRecord;        VAR vnarec    : VNARecord;        VAR pathstart : Int16;        VAR rptr      : Int16;        VAR report    : PathReportRecord;       VAR dynamicptr: Int16;        VAR ierr      : Int16 );       {------------------------------------------------------}  {              IEEE-802 Build Path                     }  {------------------------------------------------------}  
PROCEDURE IEEE802BuildPath 
    (VAR Pathreport  : PathreportRecord;           vnaptr      : Int16;          elementptr  : Int16;          up_pid      : Int16;      VAR down_pid    : Int16;      VAR down_ref    : Int16;      VAR options     : PathOptionsRecord;      VAR bp_wkmp     : Int16;      VAR ierr        : Int16);               $ PAGE $  {------------------------------------------------------}  {              PROCEDURE IN802  {------------------------------------------------------}  PROCEDURE IN802      (VAR emsg : EventMsgType;      VAR ierr : Int16);                  {------------------------------------------------------}  {              PROCEDURE InbndOUT802  {------------------------------------------------------}  PROCEDURE InbndOut802      (VAR emsg : EventMsgType;      VAR ierr : Int16);                  {------------------------------------------------------}  {              PROCEDURE LANGivePath                   }  {------------------------------------------------------}      "{ Given a station address, IPAddr, and PID return a path reference } "     PROCEDURE LANGivePath      (VAR VNA         : VNARecord;          PID         : Int16;      VAR down_ref    : Int16;      VAR ierr        : Int16);       {------------------------------------------------------}  {              PROCEDURE LANMapVNA                     }  {------------------------------------------------------}      { Maps vna onto a LAN Path Report Element which includes }  {  all LAN addressing info necessary to get here.        }      
PROCEDURE LANMapVNA  
    (VAR VNA          : VNARecord;       VAR LanElement   : LANProtoElementRecord;       VAR ierr         : Int16);          $ PAGE $  {------------------------------------------------------}  {              PROCEDURE LANSearch                     }  {------------------------------------------------------}      { Gets a path reference for the given ULP and IPAddr }      
PROCEDURE LANSearch  
    (VAR VNA    : VNARecord;           ULP    : Int16;       VAR PathRef: Int16;       VAR ierr   : Int16);          {------------------------------------------------------}  {              PROCEDURE Out802   {------------------------------------------------------}  
{ outbound event handler } 
     PROCEDURE Out802     (VAR emsg : EventMsgType;      VAR ierr : Int16);          $ SUBTITLE 'Forward and External Declarations', PAGE $  IMPLEMENT       {------------------------------------------------------}  {              FUNCTION Concat  {------------------------------------------------------}       { Given indices into the two tables, returns a path reference }        FUNCTION Concat   "   (    LRTIndex : Int16;     { Index of the LRT part of the path }  " "        PMTIndex : Int16;     { Index of the PMT part of the path }  "     VAR ierr     : Int16)     { error return }  
                 : Int16;  
    FORWARD;           {------------------------------------------------------}  {              PROCEDURE Data Indication               }  {------------------------------------------------------}  PROCEDURE DataIndication     (VAR emsg : EventMsgType;      VAR wkmp   : Int16;       VAR err  : Int16);     FORWARD;           {------------------------------------------------------}  {              FUNCTION FetchLU   {------------------------------------------------------}      { Given a IP address, return the LU to which it corresponds }       FUNCTION FetchLU     (VAR IPNet  : Int32;   "        netcnt : Int16;       { number of nets to which we belong }  "     VAR ierr   : Int16)       { error return }                 : Int16;      FORWARD;       $ PAGE $  {------------------------------------------------------}  {              FUNCTION IPAdIndex   {------------------------------------------------------}      !{ Given a Virtual Network Address, returns its index in the LRT }  !     	FUNCTION IPAdIndex 	    (VAR IPAddr      : Int32;       { Virtual Network Address }      VAR StationAddr : StatAddr;       VAR ierr        : Int16)       { error return }                       : Int16;         FORWARD;           {------------------------------------------------------}  {              PROCEDURE Kill Indication               }  {------------------------------------------------------}  PROCEDURE KillIndication     (VAR emsg : EventMsgType;      VAR ierr : Int16);     FORWARD;           {------------------------------------------------------}  {              PROCEDURE Kill Path  {------------------------------------------------------}  	PROCEDURE KillPath 	 
   (    LRTIndex  : Int16; 
     VAR gbl       : LANGlobalType);      FORWARD;           {------------------------------------------------------}  {              PROCEDURE Kill Request                  }  {------------------------------------------------------}  PROCEDURE KillRequest      (VAR emsg : EventMsgType;      VAR err  : Int16);     FORWARD;               {------------------------------------------------------}  {              FUNCTION LinkUp                         }  {------------------------------------------------------}      { Determines status of the given LU }       FUNCTION LinkUp      (    lu      : Int16;          netcnt  : Int16;      VAR luindex : Int16;      VAR ierr    : Int16) : BOOLEAN;      FORWARD;       $ PAGE $  {------------------------------------------------------}  {              PROCEDURE MCSendrequest  {------------------------------------------------------}      { send request to a list of multicast addresses }       PROCEDURE MCSendRequest      (VAR emsg : EventMsgType;      VAR ierr : Int16);     FORWARD;           {------------------------------------------------------}  {              FUNCTION MCStatIndex   {------------------------------------------------------}  
FUNCTION MCStatIndex 
 
   (VAR MCAddr : StatAddr; 
         LU     : Int16;       VAR ierr   : Int16)                  : Int16;      FORWARD;           {------------------------------------------------------}  {              FUNCTION PidIndex  {------------------------------------------------------}      { Given a PID return its index in the PMT }       	FUNCTION PidIndex  	    (    PID  : Int16;         { Pid part of the path }      VAR DSAP : SapArray;      { Corresponding DSAP }      VAR ierr : Int16)         { error return }               : Int16;      FORWARD;           {------------------------------------------------------}  {              PROCEDURE PrepareDataInd                }  {------------------------------------------------------}  PROCEDURE PrepareDataInd     (    up_pid : Int16;   
        PMTIndex : Int16;  
 
        LRTIndex : Int16;  
         m        : MbufIdType;  
        length   : Int16;  
     VAR emsg     : EventMsgType;  
    VAR ierr     : Int16); 
    FORWARD;           {------------------------------------------------------}  {              PROCEDURE PrepareHeader                 }  {------------------------------------------------------}      { Procedure to prepare a header for an outbound packet }      PROCEDURE PrepareHeader      (VAR DestSap     : SapArray;       VAR StationAddr : StatAddr;       VAR Header      : LanHead;      VAR Headlen     : Int16);      FORWARD;       $ PAGE $  {------------------------------------------------------}  {              PROCEDURE PrepareKillInd                }  {------------------------------------------------------}  PROCEDURE PrepareKillInd  
   (    down_ref : Int16;  
 
        up_pid   : Int16;  
 
        reason   : Int16;  
     VAR kl_emsg  : EventMsgType);      FORWARD;           {------------------------------------------------------}  {              PROCEDURE PrepareToSend                 }  {------------------------------------------------------}  PROCEDURE PrepareToSend      (VAR emsg    : EventMsgType;       VAR LRTEle  : LRTElement;           LRTIndex: Int16;      VAR gbl     : LANGlobalType;      VAR PMTIndex: Int16;      VAR up_pid  : Int16;      VAR headlen : Int16;  
    VAR ierr    : Int16);  
    FORWARD;           {------------------------------------------------------}  {              PROCEDURE ProSW  {------------------------------------------------------}  PROCEDURE ProSw      (VAR e_msg : EventMsgType;       VAR ierr : Int16);     EXTERNAL;      {------------------------------------------------------}  {              PROCEDURE RefCntChk  {------------------------------------------------------}  { Paranoid procedure to be sure the reference counts don't get  
{  all screw up.   } 
 
PROCEDURE RefCntChk  
    (VAR LRTEle : LRTElement;  
        LRTindex  : Int16; 
     VAR gbl    : LANGlobalType);     FORWARD;           {------------------------------------------------------}  {              FUNCTION SAPIndex  {------------------------------------------------------}      { Given the SAP, returns its index in the PMT }   	FUNCTION SAPIndex  	    (    DSAP : SapArray;      VAR pid  : Int16;       VAR ierr : Int16)      { error return }                : Int16;      FORWARD;       $ PAGE $  {------------------------------------------------------}  {              PROCEDURE SendRequest                   }  {------------------------------------------------------}      {  Called on receipt of a SendRequest event message    }      PROCEDURE SendRequest      (VAR emsg : EventMsgType;      VAR wkmp : Int16;      { used to Leave Critical }       VAR ierr : Int16);     FORWARD;           {------------------------------------------------------}  {              PROCEDURE Split  {------------------------------------------------------}      { Given a path reference, turns it into two table indices }       PROCEDURE Split   
   (    pathref  : Int16;  
     VAR gbl      : LANGlobalType;   
    VAR LRTIndex : Int16;  
 
    VAR PMTIndex : Int16;  
 
    VAR ierr     : Int16); 
    FORWARD;           {------------------------------------------------------}  {              FUNCTION Statindex   {------------------------------------------------------}      { Given a station Address, returns its index in the LRT }       	FUNCTION StatIndex 	    (VAR StationAddr : StatAddr;  { LAN station address }      VAR ierr : Int16)            { error return }         : Int16;     FORWARD;           $ SUBTITLE 'AddToLRT', PAGE $       {------------------------------------------------------}  {              FUNCTION AddToLRT  {------------------------------------------------------}      {  Add an element to the LAN Routing Table }      	FUNCTION AddToLRT  	    (VAR StationAddr : StatAddr;       VAR IPAddress   : Int32;      VAR gbl         : LANGlobalType;          InLU        : Int16;      VAR ierr        : Int16)                      : INT16;  {}  { PARAMETERS:   {  StationAddr       INPUT    LAN station address   ${  IPAddress         INPUT    Virtual network address (may not be here)  $ '{  Gbl               BOTH     Global info, head of free list; number of cards  ' #{  InLU              INPUT    LU associated with this station address  # {  ierr              OUTPUT   see error returns   {}  { ERROR RETURNS:  #{  LI_IMPOSSIBLEPATH    LAN does not know about the network associated # {                       with the IPAddr.  "{  LI_NORESOURCES       There is no room in th LAN table for another " {                       entry.  DIASTER!  {}  { DISCUSSION:   #{  This is a fairly general purpose routine which will be called with  # #{  different parameters.  The station address will always be good, and # #{  either the lu or the IPAddr (or both) will be here.  If the IPAddr  # "{  is there, the procedure searches the static entries in the LRT to " #{  record the correct lu.  Then find a free entry, mark it in use and  # {  insert all given info.  Then store it in DSAM.   {}  LABEL      99;      VAR      findindex : Int16;      err : Int16;   
   fieldbuf : LRTElement;  
 	   index : Int16;  	 
   netname : Int32;  
     $ PAGE $  PROCEDURE escape (value:Int16);      BEGIN  	   ierr := value;  	    goto 99;      END;           	BEGIN { AddToLRT } 	        ierr := 0;   #   { First check to see if we were supplied with an lu or we have to } # #   { get one.                                                        } #     
   IF InLU = 0 THEN  
       BEGIN { determine the LU }        netname := GetNet (IPAddress);        InLU := FetchLU (netname, gbl.netcount, err);         IF err <> 0 THEN escape (LI_IMPOSSIBLEPATH);        END;  { determine the LU }         WITH gbl DO        IF nextfree <> ENDLIST THEN            BEGIN { if there is room in the table }           findindex := nextfree;            { Find the next on the free list }   "         DS_FetchElement (DS_LANRouteTD, findindex, fieldbuf.bufr);  "          nextfree := fieldbuf.next;            END   { if there is room in the table }        ELSE escape (LI_NORESOURCES);          WITH Fieldbuf DO  { create a new entry }         BEGIN         LANAddr := StationAddr;         IPAddr.addr  := IPAddress;  	      LU := InLU;  	 
      SndULPCt := 1; 
 
      RcvULPCt := 0; 
       status := INUSE;  
      END;  { with } 
        DS_StoreElement (DS_LANRouteTD, findindex, fieldbuf.bufr );  
   AddToLRT := findindex;  
     99:   	END;  { AddToLRT } 	     $ SUBTITLE 'Concat', PAGE $   {------------------------------------------------------}  {              FUNCTION Concat  {------------------------------------------------------}       { Given indices into the two tables, returns a path reference }        FUNCTION Concat   "   (    LRTIndex : Int16;     { Index of the LRT part of the path }  " "        PMTIndex : Int16;     { Index of the PMT part of the path }  "     VAR ierr     : Int16)     { error return }        : Int16;      {}  { PARAMETERS:   {  LRTIndex INPUT    Index into the LRT   {  PMTIndex INPUT    Index into the PMT   {  ierr     OUTPUT   see error returns  {}  { ERROR RETURNS:  !{  LI_IMPOSSIBLEPATH  There was an overflow condition with one of  ! "{                    the table indices.  A path reference will never " {                    be able to be built using these indices.   {}  { DISCUSSION:    {  First bounds checking is done on the indices to be sure that     {  they will not cause an overflow.  If they pass, then they are   "{  assigned to a record of type Pathref.  See discussion for Split.  " {}  LABEL      99;      VAR   
   catword : PathRefType;  
     $ PAGE  {-------------------------------------------------}   {            Escape (internal)                    }   {-------------------------------------------------}       	PROCEDURE escape;  	    BEGIN     ierr := LI_IMPOSSIBLEPATH;      GOTO 99;      END;               {-------------------------------------------------}   {            CheckBound (internal)                }   {-------------------------------------------------}       PROCEDURE CheckBound (index, upperbound : Int16);      BEGIN     IF (index <= 0) OR (index >= upperbound) THEN escape;     END;                       BEGIN { Concat }  CheckBound ( LRTIndex, MAXLRT);   CheckBound ( PMTIndex, MAXPMT);   catword.ref.statindex := LRTIndex;  catword.ref.pidindex := PMTIndex;   concat := catword.bufr;   ierr := 0;      99:   END;  { Concat }      $ SUBTITLE 'Data Indication', PAGE $  {------------------------------------------------------}  {              PROCEDURE Data Indication               }  {------------------------------------------------------}  PROCEDURE DataIndication     (VAR emsg : EventMsgType;      VAR wkmp : Int16;       VAR err  : Int16);  {}  { PARAMETERS:   {  emsg     INPUT     event message received from LLP   {  wkmp     INPUT     Used to leave critical  {  err      OUTPUT    any error status. Used for debugging  {}  { DISCUSSION:    {  This procedure is called by the link interface when data has     {  arrived.  It reads in the LAN header, checks it for validity,    {  (a DSAP I know about, valid control field, reserved bits set    {  to 0, command bit set.  It builds a reference in the LRT if   {  necessary, increments the inbound reference count (SndULPCt),   !{  prepares a path reference and a data indication event message,  ! !{  and then sends it to the ULP indicated by the DSAP field in the !  {  header.  If any of the validity checks fails, it disposes of    {  the message.   {}      LABEL      99;      VAR   
   header : LANhead; 
    headlen : Int16;     { length of the header }  
   luindex : Int16;  
 	   status : Int16; 	 
   LRTIndex : Int16; 
 
   PMTIndex : Int16; 
 	   m : MBufIdType; 	 
   dsap : SapArray;  
    lu : Int16;  
   datalen : Int16;  
 	   IPAddr : Int32; 	 	   up_pid : Int16; 	 
   stationAddr : Stataddr; 
    LRTEle : LRTElement;   
   gbl    : LANGlobalType; 
     $ PAGE $  PROCEDURE escape (loc : Int16; ecode : Int16);      VAR      eventtype : Int16;      info      : Int16;      location  : Int16;      context   : contextwords;          
   BEGIN { escape }  
    IF ecode = LI_NORESOURCES THEN         BEGIN         eventtype := EL_RESOURCELIM;        info      := LRT;         END      ELSE         BEGIN         eventtype := EL_ERROR;  
      info      := ecode;  
       END;         location := DATA_IND + loc;         WITH emsg DO         BEGIN         context.ints[1] := emdi_mbufid;         context.ints[2] := emdi_down_ref;         END;      "   Log_Event (eventtype, IEEE_802, location, context, 1, info, err); "    DS_MDispose (emsg.emdi_mbufid, err);   
   IF err <> 0 THEN  
       BEGIN         location := DATA_IND;   $      Log_Event (eventtype, IEEE_802, location, context, 1, info, err);  $       END;  { log this also }          gbl.ndropped := gbl.ndropped + 1;     DS_StoreElement (DS_LANGlobalsTD, 1, gbl.bufr);     err := ecode;  { return the error }         DS_LeaveCritical (wkmp);      goto 99;   
   END;  { escape }  
     $ PAGE $  FUNCTION ValidHead (VAR header : LANHead) : BOOLEAN;      
BEGIN { ValidHead }  
 WITH header DO     BEGIN     ValidHead := ((ctl = UI) AND (ssap.cmnd = 0));      END;       
END;  { ValidHead }  
     PROCEDURE GetHeader (    m : mbufidType;                       VAR header : LANHead;                       VAR headlen : Int16);      VAR   
   mmflags : mmflagstype;  
    sapbuf : PACKED RECORD CASE BOOLEAN OF         TRUE : (bufr: Int16);         FALSE : (DSap : PosInt8;                 SSap : PosInt8);               END;         headbuf : RECORD CASE BOOLEAN OF         TRUE : (bufr : Int16);        FALSE : (hd : LANHead);               END;      	   mmbuf : Int16;  	     BEGIN   !   { Read in two bytes of Sap to see if this is an expansion sap } ! 
   mmflags.int := 0; 
    mmflags.bits[0] := TRUE;      DS_MRead (mmbuf, 2, m, HD_SAPOFF, mmflags, err);      IF err <> 0 THEN escape (1, err);         sapbuf.bufr := mmbuf;     IF sapbuf.DSap = HPEXPSAP THEN   
      headlen := EXPHDRLEN 
    ELSE         headlen := HDRLEN;         mmflags.bits[0] := FALSE;  { now delete the data }      DS_MRead (headbuf.bufr, headlen, m, 0, mmflags, err);     IF err <> 0 THEN escape(2, err);          header := headbuf.hd;      
END;  { GetHeader }  
         $ PAGE $  BEGIN { DataIndication }  err := 0;   m := emsg.emdi_mbufid;      DS_FetchElement (DS_LANGlobalsTD, 1, gbl.bufr);   GetHeader (m, header, headlen);   "{ Check to be sure the lengths in the header and the emsg agree.  If " ${  there is extra data (emsg.emdi_len is too big) that's ok, just ignore $ #{  it, but if there is not enough, then we have garbage, so drop it }  #     IF header.length + BYT_PRE_LEN <> emsg.emdi_dlen     THEN escape (3, LAN_PKTINVALID);       datalen := emsg.emdi_dlen - headlen;      IF NOT ValidHead (header) THEN escape (4, LI_HEADER_INVALID);       dsap[1] := header.dsap;   IF headlen = HDRLEN THEN     dsap[2] := 0   ELSE dsap[2] := header.dxsap;       PMTIndex := SAPIndex (dsap, up_pid, err);   IF err <> 0 THEN escape (5, err);       
lu := emsg.emdi_down_ref;  
 !{ be sure we know of this LU; and that the tables are up to date } ! IF NOT linkUp (lu, gbl.netcount, luindex, err) THEN      BEGIN  
   IF err <> 0 THEN  
       BEGIN { oops; never heard of it }         escape (8, err);        END   { oops; never heard of it }      ELSE         BEGIN { This acts as a Link Up message }  
      status := LINKISUP;  
 "      DS_StoreFields (DS_LANRouteTD, luindex, status, STATUSOFF, 1); "       END;     END;       StationAddr := header.ssta;   LRTIndex := StatIndex (StationAddr, err);       IF err <> 0 THEN  
   BEGIN { not in table }  
    IF err <> LI_NOTFOUND THEN escape (6, err);     IPAddr := 0;      LRTIndex := AddToLRT (StationAddr, IPAddr, gbl, lu, err);     IF err <> 0 THEN escape(7, err);   
   END   { not in table }  
 ELSE { we have a match }     BEGIN { still need to update stats }      DS_FetchElement (DS_LANRouteTD, LRTindex, LRTele.bufr);     LRTEle.SndULPCt := LRTEle.SndULPCt + 1;     LRTEle.lu   := LU;   { make sure LU is up to date }     DS_StoreElement (DS_LANRouteTD, LRTindex, LRTele.bufr);     END;  { still need to update stats }       gbl.ndi := gbl.ndi + 1;    { increment global stats }       "PrepareDataInd (up_pid, PMTIndex, LRTIndex, m, datalen, emsg, err);  " IF err <> 0 THEN     BEGIN { kill the path; then bail out }      KillPath (LRTIndex, gbl);     DS_StoreElement (DS_LANGlobalsTD, 1, gbl.bufr);  
   escape (9, err);  
    END;  { kill the path; then bail out }       $DS_StoreElement (DS_LanGlobalsTD, 1, gbl.bufr); { store only if updated} $     DS_LeaveCritical (wkmp);  	ProSw (emsg, err); 	     99:   END;  { DataIndication }      $ SUBTITLE ' FetchLU', PAGE $   {------------------------------------------------------}  {              FUNCTION FetchLU   {------------------------------------------------------}      !{ Given a local IP address, find the LU to which it corresponds }  !     FUNCTION FetchLU     (VAR IPNet  : Int32;           netcnt : Int16;       VAR ierr   : Int16)       { error return }        : Int16;  {}  { PARAMETERS :  ${  IPNet    INPUT    IP network name for net to which the LU corresponds $ {  Netcnt   INPUT    Number of networks to which we belong  {  ierr     OUTPUT   see error returns  {}  	{ ERROR RETURNS :  	 {  LI_NOTFOUND       The given network name is not in the LRT   {  MMGRERROR         Memory Manager returned an error   {}  { DISCUSSION :  !{  This procedure is used to determine the LU which corresponds to ! {  on of the IP addresses for this node.  It searches the   {  static part of its tables which maps IP addresses to LUs.  {  The search is a linear search, done by calling DS_SerialF&F  {}  LABEL      99;      VAR      err : Int16;      Startindex, StopIndex, maskoff, masklen : Int16;      mask : RECORD CASE BOOLEAN OF           TRUE : (bufr : BufferType);           FALSE : (netname : Int32);            END;      fieldoff, fieldlen, findindex : Int16;   
   fieldbuf : Int16; 
         $ PAGE $  PROCEDURE Escape (    value : Int16);       BEGIN      IF value = MMNOTFOUND THEN   
      ierr := LI_NOTFOUND  
    ELSE ierr := value;  	   FetchLU := -1;  	    goto 99;   END;      	BEGIN { FetchLU }  	     %   { Start at the beginning of the table and examine each entry for the }  %    { correct network name. (we let mmgr do this for us)  }  
   startindex := 1;  
    stopindex := netcnt;      maskoff := IPADOFF;     masklen := IPAddrLEN;     fieldoff := LUOFF;   	   fieldlen := 1;  	 
   mask.netname := IPNet;  
            DS_SerialFindandFetchFields  %      (DS_LANRouteTD, Startindex, StopIndex, maskoff, masklen, mask.bufr,  %        fieldoff, fieldlen, fieldbuf, findindex, err);          IF err <> 0 THEN escape (err);          FetchLU := fieldbuf;      ierr := 0;   99:   	END;  { fetchLU }  	     $ SUBTITLE 'IEEE802AddElement', PAGE $  !{----------------------------------------------------------------} ! !{   IEEE 802 ADD ELEMENT                                         } ! !{----------------------------------------------------------------} !     PROCEDURE IEEE802AddElement      ( VAR sp        : Int16;        VAR stack     : TemplateControlStack;       VAR crec      : TemplateControlRecord;        VAR vnarec    : VNARecord;        VAR pathstart : Int16;        VAR rptr      : Int16;        VAR report    : PathReportRecord;       VAR dynamicptr: Int16;        VAR ierr      : Int16 );   {}  { PARAMETERS:   {   { sp          INPUT    not used   { stack       INPUT    not used   !{ crec        INPUT    control record.  Used to determine the PID  ! !{                      above LAN to map it to the appropriate DSAP ! {                      for the report.  !{ VnaRec      INPUT    Virtual Network Address.  Used to determine ! "{                      the appropriate station address of the local  " {                      node.  "{ pathstart   INPUT    byte address in this path record of the start " {                      of the current path.    { rptr        INPUT    points to the first free byte in the path   {                      report   "{             OUTPUT   points to the first byte after the LAN entry  " { report      INPUT    the path report  {             OUTPUT   the path report including LAN  { dynamicptr  INPUT    not used   { ierr        OUTPUT   see error returns  {}  { ERROR RETURNS:  #{ LI_NODSAP   the PID given in the control record is not one LAN knows # #{             about.  LAN will not make an entry on its behalf.  This  # #{             is a user configuration error and should be reported so  # {             the user can change the PMT with AdsMod.  #{ LI_NOSTATION  LAN does not know of the given virtual Network address # #{             and therefore has no station address which corresponds.  # {             Again,  a configuration error which should be   {             corrected by AdsMod.  {}  $ PAGE $  { DISCUSSION:   ${ This procedure will be called to make an entry in the path record once $ %{ for each protocol which is supported by LAN.  At first release that will % 	{ be IP and PROBE. 	 {}  { ALGORITHM:  "{ The PID of the protocol above is contained in the control record.  " #{ That is mapped onto the appropriate SAP using the PMT.  The Virtual  # %{ Network address for this node is mapped to the corresponding LAN station % #{ address.  If both mappings are successful then the element is filled # "{ out.  If there is an error, the Path record is returned unchanged. " {}  {                 LAN Path Report Element   {   {              ----------------------------   {              | IEEE802     |  length    |   {              ----------------------------   {              |    rsvd     |    dsap    |   {              ----------------------------   {              |       StationAddr[1]     |   {              ----------------------------   {              |       StationAddr[2]     |   {              ----------------------------   {              |       StationAddr[3]     |   {              ----------------------------   {   {  Where the length will always be 8 (bytes), dsap will be  ${  the IEEE dsap which corresponds to the up_pid given in crec.  In the  $ !{  event that we need to make a path report element for an up_pid  ! ${  which does not have an ieee802 dsap (that is anything other than IP), $ #{  we will need to use the expansion sap and somehow indicate that in  # #{  the path report. (version number, different langth, set a bit... )  # #{  The three word stationaddr will be the local station address which  # !{  corresponds to the Virtual Network address contained in VnaRec. ! {}  $ PAGE $  LABEL 99;       VAR      dsap    : Saparray;  
   err     : Int16;  
 
   i       : Int16;  
 
   index   : Int16;  
    IPAddr  : IPAddrType;  
   netname : Int32;  
 
   oldrptr : Int16;  
 
   StationAddr : StatAddr; 
         PROCEDURE Escape ( loc : Int16; value  : Int16 );       VAR   
   location : Int16; 
    context  : contextwords;              BEGIN     location := ADDELEMENT + loc;     context.longint := ipaddr.addr;  #   Log_Event (EL_ERROR, IEEE_802, location, context, 1, value, ierr);  #     	   ierr := value;  	 
   rptr := oldrptr;  
    GOTO 99;      END; {Escape}      $ PAGE $  BEGIN   
   oldrptr := rptr;  
    report.bytes[rptr] := IEEE_802;  
   rptr := rptr + 1; 
    report.bytes[rptr] := LANPATHELELEN; {element length}     rptr := rptr + 1;  {index sap}          index := PIDIndex ( crec.tc_uppid, dsap, err);          { check to be sure there is no expansion sap here }  #   IF (dsap[2] <> 0) OR (err <> 0) THEN escape (1, LI_IMPOSSIBLEPATH); #     
   i := rptr DIV 2;  
    report.ints[i] := dsap[1];   
   rptr := rptr + 2; 
        IPAddr.arry[1] := VNarec.ints[1];     IPAddr.arry[2] := VNArec.ints[2];         { We store only the name of the corresponding network }     netname := GetNet (ipaddr.addr);      index := IPAdIndex (netname, StationAddr, err);  #   { error return means we don't know about this name for ourselves }  #    IF err <> 0 THEN escape (2, LI_IMPOSSIBLEPATH);      
   i := rptr DIV 2;  
    report.ints [i] := StationAddr[1];      report.ints [i+1] := StationAddr[2];      report.ints [i+2] := StationAddr[3];          rptr := rptr + 6; {index first byte beyond 802 element}      ierr := 0;      99:   
END; {IEEE802AddElement1}  
         $ SUBTITLE ' IEEE802 Build Path ', PAGE $   {------------------------------------------------------}  {              PROCEDURE IEEE802BuildPath              }  {------------------------------------------------------}  
PROCEDURE IEEE802BuildPath 
    (VAR Pathreport  : PathreportRecord;           vnaptr      : Int16;          elementptr  : Int16;          up_pid      : Int16;      VAR down_pid    : Int16;      VAR down_ref    : Int16;      VAR options     : PathOptionsRecord;      VAR bp_wkmp     : Int16;      VAR ierr        : Int16);   {}  { PARAMETERS:   {   {  Pathreport  INPUT    The report  !{  vnaptr      INPUT    Points to byte in the report for this path ! {                       where the three word IPAddr starts.   !{  elementptr  INPUT    Points to the beginning of the 802 element ! #{  up_pid      INPUT    Used to be sure our DSAP and that of the path  # {                       match.  {  down_pid    OUTPUT   IEEE802 pid   ${  down_ref    OUTPUT   reference to the path created by this procedure  $ {  options     OUTPUT   not defined   {  bp_wkmp     IN/OUT   not changed   {  ierr        OUTPUT   see error returns   {}  { ERROR RETURNS:  #{  LI_IMPOSSIBLEPATH  The DSAP in the path report is unknown; the DSAP # ${                       for up_pid does not match the one in the table;  $ ${                       the network named is unknown, so we have no LU;  $ !{  LI_INTERNALERROR   Overflow in calculating the path reference.  ! {}  { DISCUSSION:   "{  The virtual Network Address and the corresponding station address "  {  added to the LRT.  Find the LU from the static entries in the   {  LRT (network names to LUs).  ${  Get the index of the DSAP in the PMT, and check the PID with Up_pid.  $ ${  Concatenate the two indices and return it as the down path reference. $ {  Return IEEE802 as down_pid.  {}      $ PAGE $  LABEL      99;      VAR      gbl      : LANGlobalType;  
   wkmp     : Int16; 
 
   err      : Int16; 
    DSap     : SapArray;   
   PMTIndex : Int16; 
 
   LRTIndex : Int16; 
 
   LRTEle   : LRTElement;  
 
   PID      : Int16; 
 
   StationAddr : StatAddr; 
    intptr  : int16;  { elementptr as a word offset }     ipindex : int16;  { vnaptr as a word offset }     IPAd    : IPAddrType;              ${----------------------------------------------------------------------} $ ${                        Escape  ( Internal )                          } $ ${----------------------------------------------------------------------} $     PROCEDURE escape ( loc : Int16; value : Int16);   VAR   
   location : Int16; 
    context  : contextwords;      eventtype : Int16;      wkmp : Int16;     err : Int16;          BEGIN     location := IEBUILDPATH + loc;      context.longint := ipad.addr;         IF value = LI_NORESOURCES THEN         eventtype := EL_RESOURCELIM      ELSE eventtype := EL_ERROR;      #   Log_Event (eventtype, IEEE_802, location, context, 1, value, err);  #     	   ierr := value;  	    goto 99;      END;       $ PAGE $              
BEGIN { IEEE802BuildPath } 
    { index beyond the domain to get to the IP address }      vnaptr := vnaptr + 2;  "   { this will be a problem if vnaptr comes in odd.  IT SHOULDNT! }  "    ipindex := vnaptr DIV 2;      IPad.Arry[1] := pathreport.ints[ipindex];     IPAd.arry[2] := pathreport.ints[ipindex+1];         { Paranoid checks }     IF pathreport.bytes[elementptr] <> IEEE_802        THEN escape (1, LI_IMPOSSIBLEPATH);          IF pathreport.bytes[elementptr+1] <> LANPATHELELEN         THEN escape (2, LI_IMPOSSIBLEPATH);      intptr := elementptr DIV 2;     DSap[1] := pathreport.ints[intptr + PR_SAPOFF];      #   { Caution, caution...  This path report length is coded for first } # %   { release only!  It assumes (really) that IP will be the only up_pid }  % $   { which will appear in a path report.  There needs to be some other } $ $   { indication in the path report if the expansion sap is to be used. } $        DSap[2] := 0;         StationAddr[1] := pathreport.ints[intptr + PR_STATOFF];     StationAddr[2] := pathreport.ints[intptr + PR_STATOFF+1];     StationAddr[3] := pathreport.ints[intptr + PR_STATOFF+2];             PMTIndex := SAPIndex (DSAP, PID, err);   $   IF (err <> 0) OR (PID <> up_pid) THEN escape (3, LI_IMPOSSIBLEPATH);  $        IF LocalAddress (ipad.addr) THEN         BEGIN { this is a local address; use loopback }   
      LRTIndex := 1; 
       err := 0;         END   { this is a local address; use loopback }      ELSE         BEGIN { find it }         LRTIndex := StatIndex ( StationAddr, err);        END;  { find it }       
   IF err <> 0 THEN  
       BEGIN { didn't find it }        IF err <> LI_NOTFOUND THEN escape (4, err);         DS_FetchElement (DS_LANGlobalsTD, 1, gbl.bufr);   '      { The 0 means we don't know the LU and must deduce it from the IP addr } ' !      LRTIndex := AddToLRT (StationAddr, IPad.Addr, gbl, 0, err);  !       IF err <> 0 THEN escape (5, err);         DS_StoreElement (DS_LANGlobalsTD, 1, gbl.bufr);         END      ELSE         BEGIN { have a match }        DS_FetchElement (DS_LANRouteTD, LRTIndex, LRTEle.bufr);   
      WITH LRTEle DO 
          BEGIN  $         { Check to see if an IP address is here.  If so, it may be a }  $ $         {  network name.  Or it may be the loopback path.  Keep those}  $          IF (IPAddr.addr = 0) AND (LRTIndex <> 1) THEN  !            BEGIN { add this address; this is not a static entry } !             IPAddr.addr := IPad.addr;               END;  { add this address }  #         SndULPCt := SndULPCt + 1;  { this is like a data indication } #          END;         DS_StoreElement (DS_LANRouteTD, LRTIndex, LRTEle.bufr);         END;         { now return values for the next guy up }     down_pid := IEEE_802;     down_ref := Concat (LRTIndex, PMTIndex, err);  
   IF err <> 0 THEN  
       BEGIN { we need to clean up the new entry }         DS_FetchElement (DS_LANGlobalsTD, 1, gbl.bufr);         KillPath (lrtindex, gbl);         DS_StoreElement (DS_LANGlobalsTD, 1, gbl.bufr);         escape (6, err);        END;  99:   
END;  { IEEE802BuildPath } 
     $ SUBTITLE 'In802   ', PAGE $   {------------------------------------------------------}  {              PROCEDURE IN802  {------------------------------------------------------}  PROCEDURE IN802      (VAR emsg : EventMsgType;      VAR ierr : Int16);      { Discussion:   %{  Procedure which is the entry point for ProSw.  It uses a case statement % ${  on the type of event message, and then proceeds with the processing.  $ {}      LABEL      99;      VAR   
   location : Int16; 
    context  : contextwords;   
   wkmp     : Int16; 
     BEGIN { In802 }       
location := IN_802;  
 context.longint := 0;       DS_EnterCritical (wkmp, ierr);  
IF ierr <> 0 THEN goto 99; 
     Log_Event (EL_EVENT, IEEE_802, location, context,              EMSG_WORD_LEN, emsg.int, ierr);      WITH emsg DO  
   CASE em_event OF  
        Data_Indication : DataIndication (emsg, wkmp, ierr);       
   Kill_Indication : 
       BEGIN         KillIndication (emsg, ierr);        DS_LeaveCritical (wkmp);        END;      	   Kill_Request :  	       BEGIN         KillRequest (emsg, ierr);         DS_LeaveCritical (wkmp);        END;         Send_Request : SendRequest (emsg, wkmp, ierr);          Otherwise { unknown event message }        BEGIN            context.ints[1] := LI_EVENT_MSG_INVALID;            context.ints[2] := emsg.em_event;               Log_Event (EL_ERROR, IEEE_802, location, context,                     EMSG_WORD_LEN, emsg.int, ierr);           DS_LeaveCritical (wkmp);         END;   { unknown event message }  	   END;  { Case }  	     99:   ierr := 0;  END;  { In802 }       $ SUBTITLE 'InbndOUT802   ', PAGE $   {------------------------------------------------------}  {              PROCEDURE INBndOut802  {------------------------------------------------------}  PROCEDURE INBndOut802      (VAR emsg : EventMsgType;      VAR ierr : Int16);      { Discussion:   "{  Procedure which is the entry point for the outbound event handler " #{  in the inbound process (called by ProSw).  It uses a case statement # ${  on the type of event message, and then proceeds with the processing.  $ {}      LABEL      99;      VAR   
   location : Int16; 
    context  : contextwords;   
   wkmp     : Int16; 
     PROCEDURE LogError (   loc : Int16);         BEGIN { log error }     context.ints[1] := LI_EVENT_MSG_INVALID;      context.ints[2] := emsg.em_event;         location := location + loc;     Log_Event (EL_ERROR, IEEE_802, location, context,                EMSG_WORD_LEN, emsg.int, ierr);      DS_LeaveCritical (wkmp);          goto 99;      END;   { log error }       $ PAGE $  BEGIN { In802 }       
location := IN_802;  
 context.longint := 0;       DS_EnterCritical (wkmp, ierr);  
IF ierr <> 0 THEN goto 99; 
     Log_Event (EL_EVENT, IEEE_802, location, context,              EMSG_WORD_LEN, emsg.int, ierr);      WITH emsg DO  
   CASE em_event OF  
     
   Kill_Request   : BEGIN  
                     KillRequest (emsg, ierr);                       DS_LeaveCritical (wkmp);                      END;         Send_Request : IF emsg.emsr_flags.int = 0 THEN   
                     BEGIN 
                      { Leave critical within send request }                        SendRequest (emsg, wkmp, ierr);                       END                    ELSE  
                     BEGIN 
                      { leave critical in here }                        LogError (1);  
                     END;  
        Otherwise { unknown event message }        BEGIN   
      LogError (2);  
       END;   { unknown event message }  	   END;  { Case }  	     99:   ierr := 0;  END;  { InbndOut802 }       $ SUBTITLE 'IPAdIndex', PAGE $  {------------------------------------------------------}  {              FUNCTION IPAdIndex   {------------------------------------------------------}      !{ Given a Virtual Network Address, returns its index in the LRT }  !     	FUNCTION IPAdIndex 	    (VAR IPAddr      : Int32;   { Virtual Network Address }      VAR StationAddr : StatAddr;       VAR ierr        : Int16)           { error return }                       : Int16;      {}  { PARAMETERS :  {  IPAddr     INPUT    Virtual Network Address  {  StatonAddr OUTPUT   corresponding station address  {  ierr       OUTPUT   see error returns  {}  	{ ERROR RETURNS :  	 {  LI_NOTFOUND       The given network name is not in the LRT   {  MMGRERROR         Memory Manager returned an error   {}  { DISCUSSION :  {  This procedure will be called when LAN needs to find a path  #{  reference, given the virtual network address.  This procedure will  # #{  be called from the procedure LANSeasrch, and also when LAN is asked # {  to provide an entry for a path report.   {  The search is a linear search, done by calling DS_SerialF&F  {}  LABEL      99;      VAR      err : Int16;      global : LANGlobalType;    { LAN's global block }     Startindex, StopIndex, maskoff, masklen : Int16;      mask : RECORD CASE BOOLEAN OF           TRUE : (bufr : BufferType);           FALSE : (IPAddress : Int32);            END;      fieldoff, fieldlen, findindex : Int16;      fieldbuf : RECORD CASE BOOLEAN OF           TRUE  : (bufr : Int16);           FALSE : (addr : StatAddr);               END;      $ PAGE $  PROCEDURE Escape (    value : Int16);       BEGIN      IF value = MMNOTFOUND THEN   
      ierr := LI_NOTFOUND  
    ELSE ierr := value;  
   IPAdIndex := -1;  
    goto 99;   END;      
BEGIN { IPAdIndex }  
    DS_FetchElement (DS_LANGlobalsTD, 1, global.bufr);       #   { We start with the names for ourselves, but beyond the broadcast } # #   {  addresses which we store for PROBE.                            } # 
   startindex := MININT16; 
    stopindex := global.LRTLen;     maskoff := IPADOFF;     masklen := IPAddrLEN;  
   fieldoff := STATIONOFF; 
    fieldlen := STATADDRLEN;      mask.IPAddress := IPAddr;             DS_SerialFindandFetchFields  %      (DS_LANRouteTD, Startindex, StopIndex, maskoff, masklen, mask.bufr,  %        fieldoff, fieldlen, fieldbuf.bufr, findindex, err);         IF err <> 0 THEN escape (err);          StationAddr := fieldbuf.addr;  
   IPAdIndex := findindex; 
    ierr := 0;   99:   
END;  { IPAdIndex }  
     $ SUBTITLE 'Kill Indication', PAGE $  {------------------------------------------------------}  {              PROCEDURE Kill Indication               }  {------------------------------------------------------}  PROCEDURE KillIndication     (VAR emsg : EventMsgType;      VAR ierr : Int16);  {}  { DISCUSSION*   {  A Kill Indication event message is received when the   "{  link interface is notified by INPRO that the driver has reported  " "{  an error on a read completion.  The error number is noted in the  " "{  LAN globals.  If the error is an irrecoverable error (HARDERROR), " #{  the link is marked down, to prevent any futile attempts at outbound # {  traffic on an unusable link.   {}      VAR      LU : Int16;  
   luindex : Int16;  
 	   lu_err : Int16; 	 	   status : Int16; 	 
   gbl    : LANGlobalType; 
 
   context : contextwords; 
 
   location : Int16; 
     $ page  BEGIN { KillIndication }  ierr := 0;  lu_err := 0;      DS_FetchElement (DS_LANGlobalsTD, 1, gbl.bufr);   	WITH emsg, gbl DO  	    BEGIN     LU := emki_down_ref;  { the lu which is sick }   "   { We need to find out if the error is a driver or a card error }  "    { The reason is given in the emki_reason }      err.bits[emki_reason] := TRUE;   	   nki := nki + 1; 	    IF ((emki_reason > HARDERROR) AND      (LinkUp (lu, netcount, luindex, lu_err))) THEN        BEGIN         status := LINKISDOWN;   "      DS_StoreFields (DS_LANRouteTd, luindex, status, STATUSOFF, 1); "       END;     END;   DS_StoreElement (DS_LANGlobalsTD, 1, gbl.bufr);   
IF lu_err <> 0 THEN  
    BEGIN { log error }     location := KILL_IND;     context.ints[1] := emsg.emki_reason;      context.ints[2] := emsg.emki_down_ref;   #   Log_Event (EL_ERROR, IEEE_802, location, context, 1, lu_err, ierr); # 	   ierr := lu_err; 	    END;  { log error }      END;  { KillIndication }          $ SUBTITLE 'Kill Path', PAGE $  {------------------------------------------------------}  {              PROCEDURE Kill Path  {------------------------------------------------------}  	PROCEDURE KillPath 	 
   (    LRTIndex  : Int16; 
     VAR gbl       : LANGlobalType);       { DISCUSSION:    {  Procedure called as part of a disaster cleanup procedure.  In   "{  general, we have already built a path record in the LRT, but then " {  have encountered some internal error, causing us to abort  !{  processing of the current message or path report.  In that case !  {  we must also remove the corresponding entry from out tables.    {}      VAR   
   lrtele   : LRTElement;  
         
BEGIN { Kill Path }  
 DS_FetchElement (DS_LANRouteTD, lrtindex, lrtele.bufr);   LRTEle.sndulpct := LRTEle.sndulpct - 1;   { Now add it to the free list if indicated }  RefcntChk   (lrtele, lrtindex, gbl);  DS_StoreElement (DS_LANRouteTD, lrtindex, lrtele.bufr);   
END;  { Kill Path }  
         $ SUBTITLE 'Kill Request', PAGE $   {------------------------------------------------------}  {              PROCEDURE Kill Request                  }  {------------------------------------------------------}  PROCEDURE KillRequest      (VAR emsg : EventMsgType;      VAR err  : Int16);  {}  { DISCUSSION:   !{  Event message received from an ULP to destroy a path.  In LAN's ! ${  case, the LRTelement is marked NOTINUSE if both reference counts are  $  {  zero.  If either is negative (should_never_happen), then that   {  reference count is set to zero, and the error is logged.   {}  LABEL      99;      VAR   
   pathref : Int16;  
 	   result : Int16; 	    gbl      : LANGlobalType;  
   LRTIndex : Int16; 
 
   PMTIndex : Int16; 
    LRTEle : LRTElement;      ierr : Int16;      PROCEDURE escape (loc : Int16; value : Int16);  VAR      context  : contextwords;   
   location : Int16; 
        BEGIN     WITH emsg DO         BEGIN         context.ints[1] := emkr_down_ref;         context.ints[2] := 0;         END;     location := KILL_REQ + loc;  "   Log_Event (EL_ERROR, IEEE_802, location, context, 1, value, err); "    err := value;     goto 99;      END;       $ PAGE $      BEGIN { KillRequest }   err := 0;       WITH emsg DO     BEGIN         pathref := emkr_down_ref;     DS_FetchElement (DS_LanGlobalsTD, 1, gbl.bufr);     Split (pathref, gbl, LRTIndex, PMTIndex, ierr);     IF ierr <> 0 THEN escape (2, ierr);         DS_FetchElement (DS_LANRouteTD, LRTIndex, LRTEle.bufr);      !   IF (LRTEle.status <> INUSE) AND (LRTIndex > gbl.netcount) THEN  !       BEGIN { a dynamic path on the free list }         escape (3, LI_IMPOSSIBLEPATH);        END;  { a dynamic path on the free list }       	   WITH LRTEle DO  	       BEGIN         SndULPCt := SndULPCt - emkr_msg_rcv_cnt;  #      RcvULPCt := RcvULPCt - emkr_msg_snd_cnt + 1; { add in this one } #           RefCntChk (LRTEle, LRTIndex, gbl);        { refcntchk may change the head of the free list }            gbl.nkr := gbl.nkr + 1;         DS_StoreElement (DS_LANGlobalsTD, 1, gbl.bufr);         END;  { with LRTEle }          DS_StoreElement (DS_LANRouteTd, LRTIndex, LRTEle.bufr);     END;       99:   END;  { KillRequest }       $ SUBTITLE 'LANGivePath ', PAGE $   {------------------------------------------------------}  {              PROCEDURE LANGivePath                   }  {------------------------------------------------------}      PROCEDURE LANGivePath      (VAR VNA         : VNARecord;          PID         : Int16;      VAR down_ref    : Int16;      VAR ierr        : Int16);   {}  { PARAMETERS:   {  VNA               INPUT    Virtual Network Address   {  pid               INPUT    pid of the path user  ${  down_ref     INPUT/OUTPUT  IN: down path ref of a virtual addr reply  $ {                             OUT: pathref for pid to use   {  ierr              OUTPUT   see error returns   {}  { ERRORS LOGGED:   {  LI_IMPOSSIBLEPATH    There is no way to build a path with the   !{                       given information.  Either the PID or the  ! {                       network are unknown to LAN  !{  LI_INTERNALERROR     An error doing the math to create the path ! {                       reference.  Should_never_happen.  { Note:   {  All errors are returned to PROBE as U_INTERNALERR.   {}  { DISCUSSION:   !{  LAN will search the PMT for the given PID, and note its index.  ! #{  LAN will verify that the network to which the IP address belongs is # #{  one LAN knows about.  It will then access the LRTElement, using the # "{  LRT index given in the path reference.  The IP address is added,  " ${  but the reference counts remain unchanged, since we want to kill the  $ {  path created for PROBE, and create one to IP.  {   #{  LAN will then create a path reference using the two table indices.  # {}  LABEL      99;          VAR      dsap     : SapArray;   
   err      : Int16; 
    gbl      : LANGlobalType;  
   IPaddr   : Int32; 
 
   LRTEle   : LRTElement;  
 
   LRTIndex : Int16; 
 
   LU       : Int16; 
 
   netname  : Int32; 
 
   pathref  : Int16; 
 
   PMTIndex : Int16; 
     $ PAGE $  PROCEDURE Escape (loc : Int16; value : Int16);  VAR   
   location : Int16; 
    context  : contextwords;              BEGIN     context.longint := ipaddr;      location := LAN_GIVEPATH + loc;      #   Log_Event (EL_ERROR, IEEE_802, location, context, 1, value, ierr);  #         ierr := U_INTERNALERR;  { probe only wants to see this one }       goto 99;      END;       $ page $  BEGIN { LANGivePath }      ierr := 0;          IPAddr := GetIP (VNA, err);     IF err <> 0 THEN escape (1, LI_INTERNALERROR);          DS_FetchElement (DS_LANGlobalsTD, 1, gbl.bufr);     Split ( down_ref, gbl, LRTIndex, PMTIndex, err);      IF err <> 0 THEN escape (2, LI_INTERNALERROR);          { PMTIndex belongs to PROBE; get one for PID }      PMTIndex := PIDIndex (PID, dsap, err);      IF err <> 0 THEN escape (3, LI_IMPOSSIBLEPATH);         netname := GetNet (ipaddr);     LU  := FetchLU (netname, gbl.netcount, err);      IF err <> 0 THEN escape (4, LI_IMPOSSIBLEPATH);         DS_FetchElement (DS_LANRouteTD, LRTIndex, lrtele.bufr);     IF lrtele.LU <> LU THEN escape (5, LI_INTERNALERROR);      IF lrtele.status <> INUSE THEN escape (6, LI_IMPOSSIBLEPATH);          LRTele.ipaddr.addr := IPAddr;     DS_StoreElement (DS_LANRouteTD, LRTIndex, lrtele.bufr);         pathref := Concat ( LRTIndex, PMTIndex, err);     IF err <> 0 THEN escape (7, LI_INTERNALERROR); { overflow }         down_ref := pathref;       99:   END;  { LANGivePath }           $ SUBTITLE ' LANMapVNA ', PAGE $  {------------------------------------------------------}  {              PROCEDURE LANMapVNA  {------------------------------------------------------}  
PROCEDURE LANMapVNA  
    (VAR VNA          : VNARecord;       VAR Lanelement   : LANProtoElementRecord;       VAR ierr         : Int16);      {}  { Parameters:   {  VNA         INPUT    Our virtual network Address   !{  LanElement  OUTPUT   Mini path element with our LAN addressing  ! {                       Information   {  ierr        OUTPUT   see error returns   {}  { ERRORS LOGGED:  !{  LI_IMPOSSIBLEPATH  we have no record of this VNA for ourselves  ! { Note:   {  This error is returned to PROBE as U_INTERNALERR.  {}  { Discussion:   #{  Check to see that we know of this VNA for ourselves.  Retrieve the  # "{  corresponding addressing information for ourselves, and return it " {  to the caller in the record LANElement.  {}          LABEL      99;      VAR      index       : Int16;      IPAddr      : Int32;      LM_err      : Int16;      netname     : Int32;   
   StationAddr : StatAddr; 
     $ PAGE $  PROCEDURE Escape (loc : Int16; value : Int16);  VAR   
   location : Int16; 
    context  : contextwords;              BEGIN     context.longint := IPAddr;      location := LAN_MAPVNA + loc;  #   Log_Event (EL_ERROR, IEEE_802, location, context, 1, value, ierr);  #     
   ierr := U_INTERNALERR;  
    goto 99;      END;           
BEGIN { LANMapVNA }  
 ierr := 0;      IPAddr := GetIP (VNA, ierr);  IF ierr <> 0 THEN escape (1, LI_INTERNALERROR);       netname := GetNet (IPAddr);       index := IPAdIndex (netname, stationaddr, lm_err);  IF lm_err <> 0 THEN escape (2, LI_IMPOSSIBLEPATH);      	WITH LANElement DO 	    BEGIN  
   pid := IEEE_802;  
    len := LANPATHELELEN;     rsv := 0;     uppid_sap := IPSAP;  
   OurAddr := StationAddr; 
    END;       99:   
END;  { LANMapVNA }  
     $ SUBTITLE ' LANSearch ', PAGE $  {------------------------------------------------------}  {              PROCEDURE LANSearch                     }  {------------------------------------------------------}          
PROCEDURE LANSearch  
    (VAR VNA    : VNARecord;           ULP    : Int16;       VAR PathRef: Int16;       VAR ierr   : Int16);      {}  { PARAMETERS:   {  VNA      INPUT       Virtual Network Address   !{  ULP      INPUT       PID of the requesting upper level protocol ! {  PathRef  OUTPUT      Path reference  {  ierr     OUTPUT      see error returns   {}  { ERROR RETURNS:  %{  LI_NOTFOUND          The Virtual network address given is not currently % {                       in the LRT.   %{  U_INTERNALERR        Either the ULP or the Network are unknown to LAN,  % #{                       and so a path will never be able to be built/  # "{                       Overflow encountered when concatenating the  " {                       two indices into a path refernce.   #{  U_NO_802_PATHRECS    No room in the LRT to build a path for Probe.  # {}  { DISCUSSION:   #{  This procedure will be called ONLY BY PROBE!!  PROBE will call this # #{  procedure when an ULP requests a down path reference which LAN may  # {  be able to resolve.  If the  "{  Virtual Network Address is located, a path reference is returned  " ${  to PROBE which is a path reference for the ULP to use.  If the VNA is $ %{  not found, but the network is known to LAN, it will return an error of  % ${  LI_NOTFOUND.  In addition, the PathRef parameter will contain a path  $ !{  reference for a PROBE message.  PROBE will then prepare a PROBE ! #{  message which will be broadcast throughout the appropriate network. # {   { NOTE:  Assume caller critical.  {}      LABEL      99;      VAR   
   LRTIndex : Int16; 
 
   LRTEle   : LRTElement;  
 
   PMTIndex : Int16; 
 
   err      : Int16; 
 #   dsap     : SapArray;    { ULP's corresponding sap.  Not used here } #    gbl      : LANGlobalType;     staddr   : StatAddr;   
   IPAddr   : Int32; 
     $ PAGE $  {-----------------------------------------------------------}   {                 Escape (internal)   {-----------------------------------------------------------}           PROCEDURE Escape (loc : Int16; value:Int16);      VAR      eventtype : Int16;   
   location : Int16; 
 
   context : contextwords; 
 
   Le_error : Int16; 
 
   info     : Int16; 
        BEGIN     location := LAN_Search + loc;     context.longint := IPaddr;          IF value = LI_NORESOURCES THEN         BEGIN         eventtype := EL_RESOURCELIM;  	      info := LRT; 	       ierr := U_NO_802_PATHRECS;        END      ELSE         BEGIN         eventtype := EL_ERROR;  
      info := value; 
       ierr := U_INTERNALERR;        END;  %   Log_Event (eventtype, IEEE_802, location, context, 1, info, le_error);  %        goto 99;      END;       $ PAGE $  {-----------------------------------------------------}   {           CreateProbePath (internal)  {-----------------------------------------------------}   
PROCEDURE CreateProbePath  
    (VAR IPAddr : Int32;       VAR lrtindex  : Int16);       {}  { Discussion:   !{  We did not know of the IP address, and so have to build a path  ! !{  for PROBE to use.  We must be sure to send the request out the  ! {  correct LU if we are a LAN gateway.  {}      VAR   
   err      : Int16; 
    FoundLU  : BOOLEAN;     gbl      : LANGlobalType;     i        : Int16;          { loop index }  
   LU       : Int16; 
     netname  : Int32;          { network part of the IP address }      staddr   : StatAddr;       
BEGIN { CreateProbePath }  
        DS_FetchElement (DS_LANGlobalsTD, 1, gbl.bufr);     { Find the network to which IPAddr belongs }      netname := GetNet (IPAddr);     LU := FetchLU (netname, gbl.netcount, err);     IF err <> 0 THEN escape (3, LI_IMPOSSIBLEPATH);      !   { Now search through the LUs in the global table to get the  }  ! !   {  appropriate target multicast address.                     }  !        i := 1;  
   FoundLu := FALSE; 
    REPEAT      IF gbl.mcast[i].mc_lu = LU THEN        BEGIN         FoundLU := TRUE;        staddr := gbl.mcast[i].mc_target;         END;     i := i + 1;     UNTIL (FoundLU) OR (i > gbl.netcount);          IF NOT FoundLU THEN escape (4, LI_INTERNALERROR);         { Now look first for a match in the existing path list }      LRTIndex := MCStatIndex (staddr, LU, err);          CASE err OF        0:           BEGIN { found one, increment the reference counts }            DS_FetchElement (DS_LANRouteTD, LRTIndex, LRTEle.bufr);            LRTEle.sndUlpCt := LRTEle.sndUlpCt + 1;            DS_StoreElement (DS_LANRouteTD, LRTIndex, LRTEle.bufr);            END;  { found one, increment the reference counts }      	      LI_NOTFOUND: 	          BEGIN { create a new one }   '         { Even though we know the IP address, we don't want it to be        } ' '         { associated with the multicast address, so we send 0 in its place. } '          IPAddr := 0;            LRTIndex := AddToLRT (staddr, IPAddr, gbl, LU, err);            IF err <> 0 THEN escape (5, err);               DS_StoreElement (DS_LANGlobalsTD, 1, gbl.bufr);           END;  { create a new one }             OTHERWISE            BEGIN { unknown error, bail out }  
         escape (6, err);  
          END;  { unknown error, bail out }  	   END;  { case }  	     
END;  { CreateProbePath }  
     $ PAGE $      
BEGIN { LANSearch }  
 ierr := 0;  { Initialize this value }       IPAddr := GetIP (VNA, err);   IF err <> 0 THEN escape (1, LI_INTERNALERROR);      IF localAddress (IPAddr) THEN      BEGIN { use the loopback entry }      err := 0;  	   LRTIndex := 1;  	    END   { use the loopback entry }   ELSE     BEGIN { search for the IPAddr in the LRT }      LRTIndex := IPAdIndex ( IPAddr, staddr, err);     END;  { search for the IPAddr in the LRT }       CASE err OF      0:         BEGIN { increment the reference counts }        DS_FetchElement (DS_LANRouteTD, lrtindex, lrtele.bufr);         LRTEle.SndUlpCt := LRTEle.SndUlpCt + 1;         DS_StoreElement (DS_LANRouteTD, lrtindex, lrtele.bufr);         END;  { increment the reference counts }         LI_NOTFOUND:         BEGIN { IPAddr not found }         { set return parameter to tell PROBE we couldn't find it }   
      ierr := LI_NOTFOUND; 
       ULP := PROBE;    { change the PMT reference }             { Now build a path for a PROBE multicast message }        CreateProbePath (IPAddr, LRTIndex);         END;  { IPAddr not found }         OTHERWISE        BEGIN {unknown error }        escape (2, err);        END;  {unknown error }      	   END;  { case }  	     PMTIndex := PIDIndex (ULP, dsap, err);  IF err <> 0 THEN     BEGIN { this is a big problem }     DS_FetchElement (DS_LANGlobalsTD, 1, gbl.bufr);     KillPath (lrtindex, gbl);     DS_StoreElement (DS_LANGlobalsTD, 1, gbl.bufr);     escape (7, LI_IMPOSSIBLEPATH);      END;       "{ Finally create the path reference by concatenating the indices. }  " %{ An error here means an overflow in concatenating.  Should_never_happen}  %     Pathref := Concat ( LRTIndex, PMTIndex, err);   IF err <> 0 THEN     BEGIN     DS_FetchElement (DS_LANGlobalsTD, 1, gbl.bufr);     KillPath (lrtindex, gbl);     DS_StoreElement (DS_LANGlobalsTD, 1, gbl.bufr);     escape (8, LI_INTERNALERROR);     END;       99:   
END;  { LANSearch }  
     $ SUBTITLE 'LinkUP', PAGE $   {------------------------------------------------------}  {              FUNCTION LinkUp                         }  {------------------------------------------------------}      FUNCTION LinkUp      (    lu   : Int16;           netcnt  : Int16;      VAR luindex : Int16;      VAR ierr : Int16) : BOOLEAN;      {}  { PARAMETERS:   {  LU      INPUT    LU to find status of  {  NetCnt  INPUT  The number of networks to which we belong   {  LUIndex OUTPUT Index of the lu entry in the LRT  {}  { DISCUSSION:   "{  This routine searches the static entries of the LRT to see if the " "{  LU is operational.  This procedure is called each time LAN wishes " {  to send a message.   {}      LABEL      99;      VAR      Startindex, StopIndex, maskoff, masklen : Int16;      fieldoff, fieldlen, findindex : Int16;   
   mask, fieldbuf : Int16; 
    err : Int16;       $ PAGE $  PROCEDURE Escape (    value : Int16);       BEGIN      IF value = MMNOTFOUND THEN         ierr := LAN_UNKNOWNLU      ELSE ierr := value;  
   LinkUp := FALSE;  
    goto 99;   END;      BEGIN { LinkUp }  
   startindex := MININT16; 
    stopindex := netcnt;   
   maskoff := LUOFF; 
    masklen := 1;     fieldoff := STATUSOFF; { return status word }  	   fieldlen := 1;  	    mask := LU;         DS_SerialFindandFetchFields  "      (DS_LANRouteTD, Startindex, StopIndex, maskoff, masklen, mask, "        fieldoff, fieldlen, fieldbuf, findindex, err);          IF err <> 0 THEN escape (err);          ierr := 0;  { no internal error }     IF fieldbuf = LINKISUP THEN        BEGIN   
      Linkup := TRUE 
       END      ELSE         BEGIN         LinkUp := FALSE;        END;         LuIndex := findindex;      99:   END;  { LinkUp }      $ SUBTITLE 'MCSendRequest', PAGE$   {------------------------------------------------------}  {              PRODEDURE MCSendRequest  {------------------------------------------------------}  PROCEDURE MCSendRequest      (VAR emsg : EventMsgType;      VAR ierr : Int16);      { DISCUSSION:    {  Procedure to send multiple send requests on behalf of probe.    !{  The mcsr_type field in the event message will determine whether ! "{  we are to send to all the target multicast addresses we know of,  " !{  or whether we are to send to all the proxy multicast addresses. ! !{  This procedure uses performs many of the same functions as the  ! {  regular send request routine.  {   #{  Note that no path records are created for these sends.  We keep no  # {  context, including event message counts.   {}      LABEL      99;      CONST      BYTESIX  = 6;  { offset into our header }  
   FIRSTBYTE   = 0;  { " } 
    SIXBYTES = 6;  { constants for MM calls }      VAR      apdg     : AppendageBuffer;  
   datalen  : Int16; 
    gbl      : LANGlobalType;     header   : LANHead;  
   headlen  : Int16; 
 
   i        : Int16; 
 
   index    : Int16; 
 
   lu       : Int16; 
 
   m        : mbufidtype;  
    mcaddr   : StatAddr;   
   mcsr_err : Int16; 
 
   offset   : Int16; 
    Pr_sap   : SapArray;      trace_class : Int16;    { holds NSTRC's class number }      Tracing  : Boolean;     { is tracing enabled? }      $page $       {-------------------------------------------}   {           LogError    ( internal )        }   {-------------------------------------------}   &PROCEDURE LogError (loc : Int16; lu : Int16; value : Int16; m : mbufidtype); &     VAR      context  : contextwords;      location  : Int16;   
   err      : Int16; 
        BEGIN     context.ints[1] := m;  
   context.ints[2] := lu;  
    location := MC_SEND_REQ + loc;       "   Log_Event (EL_ERROR, IEEE_802, location, context, 1, value, err); "    END;  { LogError }                       {-------------------------------------------}   {           Escape ( internal )             }   {-------------------------------------------}   %PROCEDURE escape (loc : Int16; lu : Int16; value : Int16; m : mbufidtype); %    BEGIN     LogError (loc, lu, m, value);      	   ierr := value;  	 
   DS_MDispose (m, value); 
    { If we can't dispose it we should log that error as well }     IF value <> 0 THEN LogError (10, lu, m, value);         gbl.ndropped := gbl.ndropped + 1;     DS_StoreElement (DS_LANGlobalsTD, 1, gbl.bufr);         goto 99;   
   END;  { escape }  
         $ PAGE $  {-------------------------------------------}   {           GetProbeSap ( internal )        }   {-------------------------------------------}   PROCEDURE GetProbeSap (VAR Pr_sap : SAPArray);      { Procedure to provide an easy transition to more complicated       {  structure of PMT, because of more up_pids.  For now it is       {  hard coded since we know the contents of the PMT.      {}       BEGIN   
   pr_sap[1] := HPEXPSAP;  
 
   pr_sap[2] := PROBESAP;  
 END;                  {-------------------------------------------}   {           FixForTracing ( internal )      }   {-------------------------------------------}   PROCEDURE FixForTracing   
   (VAR m   : mbufidType;  
     lu_index   : Int16);  {}  #{ Procedure to make the write completion for this send look the way it # {  will on the line.  We access our tables to get our Station    {  address which corresponds to the LU being used for this send.   {}      VAR      mm_err   : Int16; { error return }      MyEle : LRTElement;      BEGIN { FixForTracing }   DS_FetchElement (DS_LANRouteTD, lu_index, myele.bufr);      #{ we will ignore errors on this call since we don't want to drop it }  # #{  just because we can't make it pretty.                            }  #  DS_MBOverwrite (myele.LANAddr[1], SIXBYTES, M, BYTESIX, mm_err);   END;  { FixForTracing }               $ PAGE $  {-------------------------------------------}   {           SendTheRest ( internal )        }   {-------------------------------------------}       PROCEDURE SendTheRest   
   { encapsulation } 
    (VAR gbl    : LANGlobalType;           offset : Int16;           m      : mbufidtype;          dlen   : Int16;       VAR apdg   : AppendageBuffer;       VAR ierr   : Int16);      {}  { Discussion:    {  This procedure sends the message along the multicast address    !{  to all the other LUs to which we are connected.  The same mbuf  !  {  chain is used, the destination address is overwritten and the    {  LU is changed.  If there is an error from the LiSend call, it   {  is sent to the error logger, but not reported to PROBE.  {}  VAR   
   i        : Int16; 
 
   index    : Int16; 
    newaddr  : StatAddr;   
   newlu    : Int16; 
 
   snd_err  : Int16; 
     $ PAGE $  BEGIN          i := 1;     { skip over the loop back entry }     ierr := 0;          REPEAT      i := i + 1;     IF offset = 0 THEN         BEGIN         newaddr := gbl.mcast[i].mc_target;        END      ELSE         BEGIN         newaddr := gbl.mcast[i].mc_proxy;         END;         newlu   := gbl.mcast[i].mc_lu;          IF (newlu <> EMPTYLU) AND        (LinkUp (newlu, gbl.netcount, index, snd_err)) THEN         BEGIN          DS_MBOverwrite (newaddr[1], SIXBYTES, m, FIRSTBYTE, ierr);         IF ierr = 0 THEN           BEGIN           IF tracing THEN FixForTracing (m, index);           apdg.lan_gg.link_lu := newlu;           LiSend (m, dlen, apdg, 4, snd_err);           IF snd_err <> 0 THEN               BEGIN { log it }              LogError ( 5, newlu, m, snd_err);               END   { log it }           END        END;      !   UNTIL ((newlu = EMPTYLU) OR (i = gbl.netcount)) OR (ierr <> 0); !     END;      $ page $      BEGIN { mc_sendrequest }      DS_FetchElement (DS_LANGlobalsTD, 1, gbl.bufr);   GetProbeSap (pr_sap);       { see if Tracing is enabled }   DS_FetchGlobal (DS_LLTClass, 1, trace_class);   tracing := (trace_class <> 0);      WITH emsg DO     BEGIN     IF ( emsr_down_ref <> LAN_PROBE_PROXY ) AND        ( emsr_down_ref <> LAN_PROBE_TARGET ) THEN        BEGIN         escape (1, 0, emsr_mbufid, LI_INTERNALERROR);         END;         IF emsr_down_ref = LAN_PROBE_TARGET THEN         BEGIN   	      offset := 0; 	       mcaddr := gbl.mcast[1].mc_target;         END      ELSE BEGIN   	      offset := 1; 	       mcaddr := gbl.mcast[1].mc_proxy;        END;         lu     := gbl.mcast[1].mc_lu;         PrepareHeader (pr_sap, mcaddr, header, headlen);       
   m := emsr_mbufid; 
    header.length := headlen - BYT_PRE_LEN + emsr_dlen;     DS_MAppendHead (header.dsta[1], headlen, m, mcsr_err);      IF mcsr_err <> 0 THEN escape (2, lu, m, mcsr_err);          IF LinkUP ( lu, gbl.netcount, index, mcsr_err) THEN        BEGIN         IF tracing THEN FixForTracing (m, index);         apdg.lan_gg.link_lu := lu;        apdg.lan_gg.ni_type := IEEE_802;        datalen := -1*(emsr_dlen + headlen);        LiSend (m, datalen, apdg, 4, mcsr_err);         IF mcsr_err <> 0 THEN            BEGIN           LogError (3, lu, m, mcsr_err);            END;         END;         IF gbl.netcount > 2 THEN { skip over the loopback entry }        BEGIN { we are connected to more than one network }         SendTheRest (gbl, offset, m, datalen, apdg, mcsr_err);        IF mcsr_err <> 0 THEN escape (4, 0, m, mcsr_err);         END;  { we are connected to more than one network }       	   END;  { with }  	     DS_StoreElement (DS_LANGlobalsTD, 1, gbl.bufr);   
DS_MDispose (m, mcsr_err); 
 IF mcsr_err <> 0 THEN LogError (6, 0, m, mcsr_err);       99:   END;  {MCSend_Rquest }      $ SUBTITLE  'MCStatIndex', PAGE $   {------------------------------------------------------}  {              FUNCTION MCStatindex   {------------------------------------------------------}      #{ Given a station Address and LU pair, returns its index in the LRT }  #     
FUNCTION MCStatIndex 
    (VAR MCAddr : StatAddr;  { LAN station address }           LU     : Int16;       VAR ierr   : Int16)     { error return }        : Int16;      {}  { PARAMETERS :  {  MCAddr      INPUT    Station Address   {  InLU        INPUT    LU on which the message arrived   {  ierr        OUTPUT   see error returns   {}  	{ ERROR RETURNS :  	 {  LI_NOTFOUND       The given network name is not in the LRT   {  MMGRERROR         Memory Manager returned an error   {}  { DISCUSSION :  {  This procedure will be called when LAN is building a path   {  for PROBE since we were unable to find an entry which matched   !{  the given IP address.  It will search the entire table looking  ! "{  for the given station address-LU pair.  IF a match is not found,  " {  LAN will return the error LI_NOTFOUND.   {  The search is a linear search, done by calling DS_SerialF&F  {}  VAR      err : Int16;      Startindex, StopIndex, maskoff, masklen : Int16;      mask : RECORD CASE BOOLEAN OF           TRUE : (bufr : BufferType);           FALSE : (station : StatAddr);           END;      fieldoff, fieldlen, findindex : Int16;   
   fieldbuf : LRTElement;  
         $ PAGE $  BEGIN { MCStatIndex }   
   startindex := MININT16; 
    stopindex := MAXINT16;  { search the entire table }  
   maskoff := STATIONOFF;  
 
   masklen := StatAddrLEN; 
    fieldoff := LUOFF;      { return the LU }  	   fieldlen := 1;  	 
   mask.station := MCAddr; 
     $   { loop through the entire table until we have a match with both the } $ $   { station address and the LU.  We do a series of searches, always   } $ $   { starting with the succeeding entry if the station addresses match } $ $   { but the LUs don't.                                                } $        REPEAT      DS_SerialFindandFetchFields  %      (DS_LANRouteTD, Startindex, StopIndex, maskoff, masklen, mask.bufr,  %        fieldoff, fieldlen, fieldbuf.bufr, findindex, err);     startindex := findindex + 1;      UNTIL (err <> 0) OR (fieldbuf.bufr = LU);      	   IF err = 0 THEN 	       BEGIN  { we have a match }        MCStatIndex := findindex;         ierr := 0;        END      ELSE         BEGIN         IF err = MMNOTFOUND THEN           ierr := LI_NOTFOUND        ELSE ierr := err;         MCStatindex := -1;        END;      END;  { MCstatindex }   
$ SUBTITLE 'OUT802', PAGE$ 
 {------------------------------------------------------}  {              PROCEDURE Out802   {------------------------------------------------------}  PROCEDURE Out802     (VAR emsg : EventMsgType;      VAR ierr : Int16);      LABEL      99;      VAR      context  : contextwords;   
   wkmp     : Int16; 
         {--------------------------------------------------------}  {           LogErr (Internal )  {--------------------------------------------------------}      PROCEDURE LogErr (   loc : Int16);      VAR   
   location : Int16; 
        BEGIN { an unknown emsg }     location := OUT_802 + loc;      context.ints[1] := LI_EVENT_MSG_INVALID;   $   context.ints[2] := emsg.em_event; { event message we cannot handle }  $        Log_Event (EL_ERROR, IEEE_802, location, context,                EMSG_WORD_LEN, emsg.int, ierr);      END;  { an unknown emsg }      $ PAGE $  BEGIN   context.longint := 0;       DS_EnterCritical (wkmp, ierr);  
IF ierr <> 0 THEN goto 99; 
     
{ Log the event message }  
 Log_Event (EL_EVENT, IEEE_802, OUT_802, context,              EMSG_WORD_LEN, emsg.int, ierr);       WITH emsg DO  
   CASE  em_event OF 
       Send_Request : IF emsr_flags.int = 0 THEN                           BEGIN                           SendRequest (emsg, wkmp, ierr);   #                        { we leave critical in send request handling } #                         END                        ELSE IF emsr_flags.bits[0] THEN                          BEGIN { it is a multicast request }                           MCSendRequest (emsg, ierr);                           DS_LeaveCritical (wkmp);                          END   { it is a multicast request }   
                     ELSE  
                         BEGIN { unknown emsg }                          LogErr (1);                           DS_LeaveCritical (wkmp);                          END;  { unknown emsg }            Kill_Indication : BEGIN                           KillIndication (emsg, ierr);                          DS_LeaveCritical (wkmp)                           END;            Kill_Request :    BEGIN                           KillRequest (emsg, ierr);                           DS_LeaveCritical (wkmp);                          END;            Otherwise   { unknown event message }            BEGIN  
         LogErr (2); 
          DS_LeaveCritical (wkmp);            END;   	   END;  { case }  	     99:   ierr := 0;  END;  { Out802 }          $ SUBTITLE 'PIDIndex', PAGE $   {------------------------------------------------------}  {              FUNCTION PidIndex  {------------------------------------------------------}      { Given a PID return its index int the PMT }      	FUNCTION PidIndex  	    (    PID  : Int16;         { Pid part of the path }      VAR DSAP : SAPArray;      VAR ierr : Int16)         { error return }               : Int16;       {}  { PARAMETERS :  {  PID      INPUT    Protocol Identifier   {  DSAP     OUTPUT   SAP which corresponds to the pid in the PMT   {  ierr     OUTPUT   see error returns  {}  	{ ERROR RETURNS :  	 {  LI_NOTFOUND       The given pid is not in the PMT  {  memory manager errors from the various mmgr calls  {}  { DISCUSSION :  {  This procedure will be called when LAN is building a path  {  reference for any upper level protocol.  It will search the  {  Protocol mapping table, which maps PIDs to SAPs.   {  It returns the SAP which corresponds to the PID, needed for  
{  building headers. 
 {  The search is a linear search, done by calling DS_SerialF&F  {}  LABEL      99;      VAR      err : Int16;      global : LANGlobalType;    { LAN's global block }     Startindex, StopIndex, maskoff, masklen : Int16;      fieldoff, fieldlen, findindex : Int16;      fieldbuf : RECORD CASE BOOLEAN OF              TRUE : ( bufr : BufferType);              FALSE : ( sapfield : SAPArray);   	              END; 	     $ PAGE $  PROCEDURE Escape (    value : Int16);       BEGIN      IF value = MMNOTFOUND THEN   
      ierr := LI_NOTFOUND  
    ELSE ierr := value;  	   PIDIndex := -1; 	    goto 99;   END;      	BEGIN { PIDIndex } 	     
   startindex := MININT16; 
    stopindex := MAXINT16;  { search the entire table }     maskoff := PIDOFF;      masklen := PIDLEN;      fieldoff := SAPOFF;  
   fieldlen := EXPSAPLEN;  
        DS_SerialFindandFetchFields  "      (DS_ProtoMapTD, Startindex, StopIndex, maskoff, masklen, pid,  "        fieldoff, fieldlen, fieldbuf.bufr, findindex, err);         IF err <> 0 THEN escape (err);          DSAP := fieldbuf.sapfield;   
   PIDIndex := findindex;  
    ierr := 0;   99:   	END; { pidindex }  	         $ SUBTITLE ' Prepare Data Ind', PAGE $      {------------------------------------------------------}  {              PROCEDURE PrepareDataInd                }  {------------------------------------------------------}  PROCEDURE PrepareDataInd     (    up_pid : Int16;   
        PMTIndex : Int16;  
 
        LRTIndex : Int16;  
         m        : MbufIdType;  
        length   : Int16;  
     VAR emsg     : EventMsgType;  
    VAR ierr     : Int16); 
 {}  { PARAMETERS:   !{  up_pid      INPUT       PId of the protocol to receive the D.I. ! {  PMTIndex    INPUT       needed for path reference  {  LRTIndex    INPUT       needed for path reference  !{  m           INPUT       points to the mbuf chain with the data  ! {  length      INPUT       number of bytes of data  {  emsg        OUTPUT      the event message to be sent   {}  { DISCUSSION:   {  A series of simple assignments to prepare the event message  {}      VAR   	   result : Int16; 	     BEGIN { PrepareDataInd }  WITH emsg DO     BEGIN     ehport :=  (up_pid * EHS_PER) + EHIB_OFFSET;      em_event := DATA_INDICATION;      emdi_up_ref := -1;   { not used }  
   emdi_mbufid := m; 
    emdi_down_pid := IEEE_802;      emdi_dlen := length;      emdi_down_ref := Concat (LRTIndex, PMTIndex, ierr);     { IF ierr <> 0 THEN we'll handle it above }     END;       END;  { PrepareDataInd }      $ SUBTITLE ' Prepare Header', PAGE $  {------------------------------------------------------}  {              PROCEDURE PrepareHeader                 }  {------------------------------------------------------}      PROCEDURE PrepareHeader      (VAR DestSap     : SapArray;       VAR StationAddr : StatAddr;       VAR Header      : LanHead;      VAR Headlen     : Int16);   {}  { DISCUSSION:   %{  This procedure prepares a header for a packet. (see header description  % "{  at the beginning of the code.  If the DSAP is IEEE assigned, then " #{  the header is the statndard size (17 octets).  Otherwise, it is the # ${  longer header.  IEEE assigned DSAP is true if DestSap[1] = HPEXPSAP.  $ {}  { PARAMETERS:   {  DestSap     INPUT    Destination Sap   !{  StationAddr INPUT    Station Address.  May be broadcast address ! {  Header      OUTPUT   header for the packet   {  Headlen     OUTPUT   byte length of the header   {}  BEGIN { Prepare Header }  WITH Header DO     BEGIN     { do the simple stuff first }     dsta := StationAddr;       dsap := DestSap[1];  { we know these 6 bits are always here }      ssap.byt := dsap;        { always send to a peer }      ssap.cmnd := 0;     { command }      
   IF dsap = HPEXPSAP THEN 
       BEGIN { Prepare long header }         headlen := EXPHDRLEN;   	      xctl := UI;  	       pad1 := 0;        pad2 := 0;  
      dxsap := DestSap[2]; 
       sxsap := dxsap;         END   { prepare long header }      ELSE         BEGIN { prepare short header }        ctl := UI;        headlen := HDRLEN;        END;  { prepare short header }      	   END;  { with }  	     END;  { Prepare Header }      $ SUBTITLE 'Prepare Kill Ind', PAGE $   {------------------------------------------------------}  {              PROCEDURE PrepareKillInd                }  {------------------------------------------------------}  PROCEDURE PrepareKillInd  
   (    down_ref : Int16;  
 
        up_pid   : Int16;  
 
        reason   : Int16;  
     VAR kl_emsg  : EventMsgType);   {}  { PARAMETERS:   {  down_ref    INPUT       the path which is to die    {  up_pid      INPUT       the protocol to receive the Kill Ind    {  reason      INPUT       The error which triggered this   {  kl_emsg     OUTPUT      The event message  {}  { DISCUSSION:   {  A straightforward set of assignment statements   {}  BEGIN { PrepareKillInd }  WITH kl_emsg DO      BEGIN     ehport := (up_pid * EHS_PER) + EHIB_OFFSET;     em_event := KILL_INDICATION;      emki_down_ref := down_ref;      emki_down_pid := IEEE_802;   
   emki_reason := reason;  
    END;       END;  { PrepareKillInd }  $SUBTITLE 'Prepare To Send ', PAGE $  {------------------------------------------------------}  {              PROCEDURE PrepareToSend                 }  {------------------------------------------------------}      { Procedure to prepare a packet to be sent.            }      PROCEDURE PrepareToSend      (VAR emsg    : EventMsgType;       VAR LRTEle  : LRTElement;           LRTIndex: Int16;      VAR gbl     : LANGlobalType;      VAR PMTIndex: Int16;      VAR up_pid  : Int16;      VAR headlen : Int16;  
    VAR ierr    : Int16);  
 {}  { DISCUSSION:    {  This procedure prepares a packet to be sent onto the LAN.  It   #{  prepares the header from the table entries extracted from the path  # ${  reference, and appends it to the packet.  If there is any error with  $ &{  the path, it marks the entry in the LRT inactive and notifies the calling & {  procedure so that it may take appropriate action.  {   {  The static entries (i.e. loopback) are treated specially.  {   {  If tracing is enabled, add our own station address.  {}  { PARAMETERS:   '{  Emsg        INPUT    The original event message.  Mbuf pointer is changed.  ' !{              OUTPUT   Points to the packet with the header added !  {  LRTEle      BOTH     The table element containing path info.    {  LRTIndex    INPUT    Index of this element   {  Gbl         BOTH     Global info.  "{  PMTIndex    INPUT    Index into ProtoMapping Table for this path. " %{  up_pid      OUTPUT   The PID of the protocol to notify in case of error % #{  headlen     OUTPUT   The length of the header.  Used by the calling # %{                       procedure to determine byte length of the message. % {  ierr        OUTPUT   See error returns   {}  { ERROR RETURNS:  ${  LI_IMPOSSIBLEPATH    The path reference is bogus.  One or both of the $ {                       indices are out of range.   #{  LAN_UNKNOWNLU        This is an internal error.  The LU in the path # !{                       record is not found in the static entries. ! {   #{  LI_LINKDOWN          The link is down.  A KillIndication should be  # {                       prepared by the calling proc.   {   #{  There are also various memory manager errors, which would be fairly # {  disastrous.  They are MMOUTOFMEMORY, MMILLEGALBUFID, etc.  {}      $ PAGE $  LABEL      99;      VAR   
   PMTele   : PMTelement;  
 
   err      : Int16; 
    header   : LanHead;  
   luindex  : Int16; 
 
   m        : MBufIdType;  
 "   myele    : LRTElement;     { one of LAN's alias LRTEle entries }  " '   trace_class : Int16;       { class number for NSTRC; <>0 when tracing on }  '     PROCEDURE escape (value : Int16);       BEGIN { escape }  	   ierr := value;  	    goto 99;   END;  { escape }      $ PAGE $      BEGIN { PrepareToSend }    { Any invalid path will have status marked NOTINUSE, set when }     {  a path is placed on the free list.                         }     { Note that the loopback paths use the status field to        }     {  store the link status, whose values are LINKISUP or -DOWN  }        { Get up_pid first, in case we need to escape }   DS_FetchElement (DS_ProtoMapTD, PMTIndex, PMTele.bufr);   up_pid := PMTEle.pid;       IF LRTele.status = NOTINUSE THEN escape (LI_IMPOSSIBLEPATH);      IF NOT LinkUp (LRTEle.lu, gbl.netcount, luindex, err)  THEN      BEGIN     IF err = 0 THEN err := LI_LINKDOWN;     escape (err);     END;   PrepareHeader (PMTele.sap, LRTele.LANAddr, header, headlen);      !{ If there is an accompanying kill request, update the refcounts } ! 
WITH emsg, LRTele DO 
    BEGIN     IF (emsr_killsnd_cnt <> 0) OR        (emsr_killrcv_cnt <> 0) THEN        BEGIN { a kill request as well }        RcvULPCt := RcvULPCt - emsr_killsnd_cnt;        SndULPCt := SndULPCt - emsr_killrcv_cnt;        RefCntChk (LRTEle, LRTIndex, gbl);        END;  { a kill request as well }     END;       "{ now dance with the source station address.  If it is a loopback }  " "{  packet, then the source station address must be 0              }  " 
IF lrtindex = 1 THEN 
    BEGIN { we have loopback }      header.ssta := DEFAULT_STATION;     END   { we have loopback }   ELSE     BEGIN { do we have tracing }   &   { If tracing is enabled, then let's add the real source station address } &    DS_FetchGlobal (DS_LLTClass, 1, trace_class);     IF trace_class <> 0 THEN         BEGIN { get our own address for this LU }         DS_FetchElement (DS_LANRouteTD, luindex, myele.bufr);         header.ssta := myele.LANAddr;         END;  { get our own address for this LU }      END; { do we have tracing }      
WITH emsg, header DO 
    BEGIN { with header }  &   length := headlen - BYT_PRE_LEN + emsr_dlen; { fill in the length field } & 
   m := emsr_mbufid; 
    DS_MAppendHead (dsta[1], headlen, m, err);      IF err <> 0 THEN escape (err);      emsr_mbufid := m;    { update our copy of mbuf pointer }   	   END;  { with }  	     99:   END;  { PrepareToSend }           $ SUBTITLE 'PROCEDURE RefCntChk ', PAGE$      {------------------------------------------------------}  {              PROCEDURE RefCntChk  {------------------------------------------------------}  { Paranoid procedure to be sure the reference counts don't get  	{  all screw up. } 	 
PROCEDURE RefCntChk  
    (VAR LRTEle : LRTElement;  
        LRTIndex  : Int16; 
     VAR gbl    : LANGlobalType);      { DISCUSSION:   "{  Procedure to be sure the reference counts never get below 0.    } " "{  If the reach 0, the entry ismarked inactive and pushed onto the } " "{  free list.                                                      } "     VAR   	   result : Int16; 	    context  : contextwords;   
   location : Int16; 
 
   ierr     : Int16; 
     
BEGIN { RefCntChk }  
 	   WITH LRTEle DO  	       BEGIN             IF (SndULPCt = 0) AND (RcvULPCt = 0) THEN            BEGIN           LANAddr := DEFAULT_STATION;  
         IPAddr.addr := 0; 
          status := NOTINUSE;  !         LRTEle.next := gbl.nextfree; { push onto the free list }  !          gbl.nextfree := LRTIndex;           END;       
      END;  { with } 
 	END; {RefCntChk }  	 $ SUBTITLE ' FUNCTION SAPIndex  ', PAGE$  {------------------------------------------------------}  {              FUNCTION SAPIndex  {------------------------------------------------------}      { Given the SAP, returns its index in the PMT }   	FUNCTION SAPIndex  	    (    DSAP : SapArray;      VAR PID  : Int16;       VAR ierr : Int16)      { error return }         : Int16;      {}  { PARAMETERS :  {  DSAP     INPUT    One or two word SAP  !{  PID      OUTPUT   Pid which corresponds to the SAP in the table ! {  ierr     OUTPUT   see error returns  {}  	{ ERROR RETURNS :  	 {  LI_NOTFOUND       The given network name is not in the LRT   {  MMGRERROR         Memory Manager returned an error   {}  { DISCUSSION :  "{  This procedure will be called when LAN is building a path for an  " !{  inbound message.  The header of the message will contain a SAP, ! "{  and ProSw requires the corresponding PID.  The first word of the  " !{  DSAP is examined to see if it is an IEEE SAP or an HP EXP SAP.  ! {  The search is a linear search, done by calling DS_SerialF&F  {}  LABEL      99;      VAR      err : Int16;      Startindex, StopIndex, maskoff, masklen : Int16;      mask : RECORD CASE BOOLEAN OF           TRUE : (bufr : BufferType);           FALSE : (sapfield : SapArray);            END;      fieldoff, fieldlen, findindex : Int16;       $ PAGE $  PROCEDURE Escape (    value : Int16);       BEGIN      IF value = MMNOTFOUND THEN   
      ierr := LI_NOTFOUND  
    ELSE ierr := value;     goto 99;   END;      	BEGIN { SAPIndex } 	 
   startindex := MININT16; 
    stopindex := MAXINT16;  { search the entire table }     maskoff := SAPOFF;      IF DSAP[1] = HPEXPSAP THEN         BEGIN { expansion sap }         masklen := EXPSAPLEN;         END   { expansion sap }      ELSE         BEGIN { IEEE sap }        masklen := SAPLEN;        END;  { IEEE sap }  
   mask.sapfield := DSAP;  
    fieldoff := PIDOFF;     fieldlen := PIDLEN;         DS_SerialFindandFetchFields  %      (DS_ProtoMAPTD, Startindex, StopIndex, maskoff, masklen, mask.bufr,  %        fieldoff, fieldlen, pid, findindex, err);         IF err <> 0 THEN escape (err);          { return the index of the entry }  
   SAPIndex := findindex;  
    ierr := 0;   99:   	END; { SapIndex }  	         $ SUBTITLE ' Send Request', PAGE $  {------------------------------------------------------}  {              PROCEDURE SendRequest                   }  {------------------------------------------------------}      PROCEDURE SendRequest      (VAR emsg : EventMsgType;      VAR wkmp : Int16;       VAR ierr : Int16);  {}  { DISCUSSION:   !{  This procedure is called when LAN receives a Send Request event ! "{  message.  It checks the length of the packet, prepares a header,  " {  sends the message and disposes the mbuf.   &{  If there is any problem with the path ( the link is down, bad reference,  & #{  etc.), a kill indication is sent to the ULP indicated in the emsg.  # {}  { PARAMETERS:   "{  emsg        INPUT    The event message containing all information " {                       necessary to send the packet.   {  wkmp        INPUT    Used to leave critical  !{  ierr        OUTPUT   Any error which occurs during processing.  ! #{                       This error will not bubble back to caller, but # {                       is useful in debugging.   {}  LABEL      99;      VAR   
   err      : Int16; 
    global   : LANGlobalType;  
   LRTEle   : LRTElement;  
 
   LRTIndex : Int16; 
 
   PMTIndex : Int16; 
 %   headerlen: Int16;    { Length of the header.  Used for packet length }  % 
   up_pid   : Int16; 
    kl_emsg  : EventMsgType;      Apndge_buf : AppendageBuffer;  { LISend needs this info }  
   m        : MBufIdType;  
    result   : Int16;    { result from send_event call }   
   sr_err   : Int16; 
 
   location : Int16; 
    context  : contextwords;       $ PAGE $  {------------------------------------------------------}  {                 Log Error (internal)  {------------------------------------------------------}  	PROCEDURE LogError 	 
   (   m    : Int16; 
 %       dn_ref  : Int16;    { down reference in the send request message }  %        ecode   : Int16;          loc     : Int16);         BEGIN { logerror }      location := SEND_REQ + loc;     context.ints[1] := m;     context.ints[2] := dn_ref;       #   Log_Event (EL_ERROR, IEEE_802, location, context, 1, ecode, ierr);  #        END;  { log error }      $ PAGE $  {-----------------------------------------------------}   {              EndOfSend (internal )  {-----------------------------------------------------}       "{ This procedure is an encapsulation of all processing which must }  " {  occur no matter what the termination error condition }       
PROCEDURE EndOfSend; 
        VAR        md_error : Int16;          BEGIN {EndofSend }          DS_MDispose (m, md_error);      IF md_error <> 0 THEN        BEGIN { log it }        LogError (m, emsg.emsr_down_ref, md_error, 1);        END;  { log it }         DS_StoreElement (DS_LANRouteTd, lrtindex, lrtele.bufr);     DS_StoreElement (DS_LANGlobalsTd, 1, global.bufr);          END;  {EndofSend }           $ PAGE $  {-----------------------------------------------------}   {              Escape (internal)  {-----------------------------------------------------}   PROCEDURE escape (    loc : Int16;                        err : Int16);       ${ Procedure to log the error which caused such a panic, and then clean } $ { up as best we can, and leave }      BEGIN   WITH emsg DO     BEGIN     LogError (emsr_mbufid, emsr_down_ref, err, loc);          DS_MDispose (emsr_mbufid, err);  
   IF err <> 0 THEN  
       BEGIN { log it }        LogError (emsr_mbufid, emsr_down_ref, err, 2);        END;  { log it }     END;  { with emsg }      global.ndropped := global.ndropped + 1;   DS_StoreElement (DS_LANGlobalsTD, 1, global.bufr);  DS_LeaveCritical (wkmp);  ierr := err;  goto 99;  END;  { escape }      $ PAGE $  BEGIN { sendrequest }   sr_err := 0;  ierr := 0;  DS_FetchElement (DS_LanGlobalsTD, 1, global.bufr);      WITH emsg DO     BEGIN { with emsg }     global.nsr := global.nsr + 1;     Split (emsr_down_ref, global, LRTIndex, PMTIndex, sr_err);      IF sr_err <> 0 THEN        BEGIN         escape (4, LI_IMPOSSIBLEPATH);        END ;      DS_FetchElement (DS_LANRouteTD, LRTIndex, LRTEle.bufr);     LRTEle.RcvUlpCt := LRTEle.RcvUlpCt + 1;         IF emsr_dlen > MAX802PKT THEN        BEGIN         DS_StoreElement (DS_LANRouteTD, LRTIndex, LRTEle.bufr);         escape (3, LI_PKTTOOLONG);        END;         { PrepareToSend may change the head of the free list,     }     { since a send request may contain a kill request as well }     PrepareToSend (emsg, LRTEle, LRTIndex, global, PMTIndex,                     up_pid, headerlen, sr_err);       #   m := emsr_mbufid;    { mbufid changes after appending the header }  # 	   CASE sr_err OF  	       0 :            BEGIN { no error, send it }           WITH apndge_buf.lan_gg DO  	            BEGIN  	             ni_type := IEEE_802;              link_lu := LRTEle.lu;               END;      #         LISend (m, -1*(emsr_dlen+headerlen), apndge_buf, 4, sr_err);  #          IF sr_err <> 0 THEN  	            BEGIN  	 %            { This will be something like no SAM.  We want to encourage }  % $            { retransmission, so don't tell IP about the error, just  }  $             { log it, then terminate normally }               LogError (m, emsr_down_ref, sr_err, 5);               END;      
         EndOfSend;  
          DS_LeaveCritical (wkmp);            END;  { no error }             LI_IMPOSSIBLEPATH,  
      LAN_UNKNOWNLU, 
 
      LI_LINKDOWN :  
          BEGIN  %         { These are errors which we can live with.  Something is wrong }  % %         { with the path.  Prepare a kill ind for IP so it won't try to }  %          { reuse the path, drop the message and terminate }   !         PrepareKillInd (emsr_down_ref, up_pid, sr_err, kl_emsg);  !          global.ndropped := global.ndropped + 1;           { log the kill indication }           location := SEND_REQ + 6;           context.ints[1] := sr_err;            context.ints[2] := 0;               Log_Event (EL_ERROR, IEEE_802, location,                        context, KI_LEN, kl_emsg.int, result);   
         EndOfSend;  
              DS_LeaveCritical (wkmp);            ProSw (kl_emsg, sr_err);            END;  { something wrong with the path }         Otherwise { some other error.  Store state }            BEGIN           global.ndropped := global.ndropped + 1;           LogError (m, emsr_down_ref, sr_err, 7);  
         EndOfSend;  
          DS_LeaveCritical (wkmp);            END;       
      END;  { CASE } 
    END;  { with emsg }      99:   END;  { sendrequest }           
$ SUBTITLE ' Split', PAGE$ 
 {------------------------------------------------------}  {              PROCEDURE Split  {------------------------------------------------------}      { Given a path reference, turns it into two table indices }       PROCEDURE Split   
   (    pathref  : Int16;  
     VAR gbl      : LANGlobalType;   
    VAR LRTIndex : Int16;  
 
    VAR PMTIndex : Int16;  
 
    VAR ierr     : Int16); 
 {}  { PARAMETERS:   {  pathref  INPUT    path reference which is to be split  {  gbl      INPUT    LAN global block   {  LRTIndex OUTPUT   index into the LRTable   {  PMTIndex OUTPUT   index into the PMTable   {  ierr     OUTPUT   see error returns  {}  { ERROR RETURNS:  "{  LI_InternalError  The path reference given resolves into a bogus  " {                    table access.  { DISCUSSION:   "{  This procedure takes a path reference and turns it into twu table " !{  references.  The fastest way to do this in Pascal is to assign  ! "{  the Int16 to a variable which is a variant record: one variant is " !{  an Int16, the other is a Packed record of PosInt10 and PosInt6; ! {  Voila! the two references are extracted.   {}      VAR      splitword : Pathreftype;       BEGIN { Split }      splitword.bufr := pathref;      LRTIndex := splitword.ref.statindex;      PMTIndex := splitword.ref.pidindex;     IF (LRTIndex > gbl.lrtlen) OR (PMTIndex > gbl.pidcount)        OR (LrtIndex <= 0) OR (PMTIndex <= 0) THEN        BEGIN         ierr := LI_INTERNALERROR;         END   	   ELSE ierr := 0; 	 END;  { Split }       $ SUBTITLE  'StatIndex', PAGE $   {------------------------------------------------------}  {              FUNCTION Statindex   {------------------------------------------------------}      { Given a station Address, returns its index in the LRT }       	FUNCTION StatIndex 	    (VAR StationAddr : StatAddr;  { LAN station address }      VAR ierr : Int16)            { error return }         : Int16;      {}  { PARAMETERS :  {  StationAddr INPUT    Station Address   {  InLU        INPUT    LU on which the message arrived   {  ierr        OUTPUT   see error returns   {}  	{ ERROR RETURNS :  	 {  LI_NOTFOUND       The given network name is not in the LRT   {  MMGRERROR         Memory Manager returned an error   {}  { DISCUSSION :  {  This procedure will be called when LAN is building a path  "{  for an inbound message.  It will search the entire table looking  "  {  for the given station address.  IF a match is not found, LAN    {  will return the error LI_NOTFOUND.   {  The search is a linear search, done by calling DS_SerialF&F  {}  LABEL      99;      VAR      err : Int16;      Startindex, StopIndex, maskoff, masklen : Int16;      mask : RECORD CASE BOOLEAN OF           TRUE : (bufr : BufferType);           FALSE : (station : StatAddr);           END;      fieldoff, fieldlen, findindex : Int16;   
   fieldbuf : LRTElement;  
         $ PAGE $  PROCEDURE Escape (    value : Int16);       BEGIN      IF value = MMNOTFOUND THEN   
      ierr := LI_NOTFOUND  
    ELSE ierr := value;  
   StatIndex := -1;  
    goto 99;   END;      
BEGIN { StatIndex }  
 
   startindex := MININT16; 
    stopindex := MAXINT16;  { search the entire table }  
   maskoff := STATIONOFF;  
 
   masklen := StatAddrLEN; 
    fieldoff := 0;    { return no data }   	   fieldlen := 0;  	    mask.station := StationAddr;          DS_SerialFindandFetchFields  %      (DS_LANRouteTD, Startindex, StopIndex, maskoff, masklen, mask.bufr,  %        fieldoff, fieldlen, fieldbuf.bufr, findindex, err);         IF err <> 0 THEN escape (err);       
   StatIndex := findindex; 
    ierr := 0;   99:   
END;  { statindex }  
     END.  { Lan8 } 