 $PASCAL '91790-1X108 REV.4010 <860519.0945>'      
$STANDARD_LEVEL 'HP1000' $ 
 $HEAP 0$  $DEBUG $  $RECURSIVE OFF$       MODULE LANInit;       %{------------------------------------------------------------------------  %     "   (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986.  ALL RIGHTS RESERVED. "    NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED, REPRODUCED, OR   "   TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR WRITTEN  "    CONSENT OF THE HEWLETT-PACKARD COMPANY.      % ------------------------------------------------------------------------} %     {}  {        NAME : LANinit   {      SOURCE : 91790-18108   
{       RELOC : NONE 
 
{        PGMR : ASH  
 {}      ${----------------------------------------------------------------------- $    MODIFICATIONS  !6/8/85   ash   Added setting the bit for LAN in PROBE's proto rec. !  6/14/85  ash   Added procedures LANClearClass, LANActivateClass,                  RegisterClass.   "6/19/85  ash   Change type of Tableok in LANClearClass to TrustType  " %6/26/85  ash   Add check for LAN presence in LANClearClass, LANStoreClass  % $8/24/85  ash   Restructured LANOpenLines to write station address while  $                not critical.  --------------------------- POST -----------------------------  11/14/85 ash   Export RWStataddr                 Remove RWStatAddr call it from LANOpenLines                 Set multicast bit on card receive packet filter                 Add "NSINIT:" prompt to error message  --------------- post --------------------------------   submittal n365   1/11/86  ash   Try to handle corrupt tables while shutting down.   2/27/86  ash   Driver error code as posint4   --------------- post --------------------------------   Submittal n370  3/12/86  lms   Set NoSuspendBit in XLUEX calls.   3/15/86  lms   Handle RTE errors in RWStatAddr.   #3/15/86  lms   return ERR_ALREADY_PRINTED for XLUEX error in SetMCBit. # 3/17/86  lms   Document error returns from CheckDriverType.   3/18/86  lms   Use init_rte_if XLUEX error handling routines.   --------------- post  -------------------------------   '5/16/86  jc    Fix the bugs in SetMCBit so it will quit (GOTO 99) when error.  '     % -----------------------------------------------------------------------}  % {}  { PROGRAM DESCRIPTION :   "{  This module contains all initialization related procedures which  " {  may be called during any phase of initialization.  {}  IMPORT     $ SEARCH 'phtm/bodec.xpt'  bodec,     $SEARCH 'phtm/sodec.xpt'   sodec,     $SEARCH 'phtm/mmdec.xpt'   mmdec,     $SEARCH 'phtm/mmext.xpt'   ds_mm,     $SEARCH 'phtm/trcmod.rel'  trcmod,   
   $search 'phtm/lklb.rel' 
 lk,      $search 'phtm/sigmod.rel'  sigmod,      $search 'phtm/tmrdec.rel'  tmrdec,      $search 'phtm/tuser.rel'   tuser,     $search 'phtm/ipdec.rel'   ipdec,     $search 'phtm/iplib.rel,phtm/ipdb.rel'   iplib,  
   $search 'phtm/lan8.xpt' 
 lan8,      $search 'phtm/lanui.xpt'   lanui,     $search 'phtm/init_dec.rel'  init_dec,   
   $search 'phtm/dres.xpt' 
 dres,      $search 'phtm/initmulti.xpt'   initmulti,     $search 'phtm/parsdd.xpt'  parser,      $search 'phtm/filemad.xpt'   fileman,     $search 'phtm/init_rte_if.xpt'   init_rte_if;          EXPORT      {------------------------------------------------------}  {              CheckDriverType  {------------------------------------------------------}  
PROCEDURE CheckDriverType  
 
   (    LU        : Int16; 
 
        DrvType   : Int16; 
     VAR result    : Int16);           {------------------------------------------------------}  {              IEEE-802 INIT  {------------------------------------------------------}  PROCEDURE IEEE802init      (VAR ierr : Int16);          {------------------------------------------------------}  {              LANClearClass  {------------------------------------------------------}      { Called during shutdown to clear the class#/dsap table }   { in the driver dvt                                     }       PROCEDURE LANClearClass      (    TableOK   : TrustType;      VAR ierr      : Int16);           {------------------------------------------------------}  {              PROCEDURE LANOpenLines   {------------------------------------------------------}      { Procedure to open the LAN links }       PROCEDURE LANOpenLines     (VAR ierr : Int16);          {------------------------------------------------------}  {              PROCEDURE LANStoreMcast  {------------------------------------------------------}      #{ Procedure to store multicast addresses different from the default }  #     PROCEDURE LANStoreMcast      (VAR SuppliedAddrs   : MCastInfo;      VAR ierr            : Int16);           {------------------------------------------------------}  {              PROCEDURE RWStatAddr   {------------------------------------------------------}  
PROCEDURE RWStatAddr 
    (VAR lrtele: LRTElement;       VAR ierr  : Int16);           $SUBTITLE 'IMPLEMENT SECTION', PAGE$      IMPLEMENT       CONST   &   FIRST_ALIAS = 2;     { first entry in the LRT which is an alias for me }  &    NOABORT  = -32768;      READ  = 1 + NOABORT;      WRITE = 2 + NOABORT;       TYPE  !   cntwds   = ARRAY [1..2] of Int16;  { used for driver requests } !         { Arrangement of bits from DVT 6 (request from the driver) }       EQTStatusType = PACKED RECORD           upperbyte   : Byte;           err_code    : PosInt4;            ds_bit      : BOOLEAN;            wr_bit      : BOOLEAN;            er_bit      : BOOLEAN;            nop_bit     : BOOLEAN;            END;  {EQTStatusType }          LRTList  = ARRAY [FIRST_ALIAS..MAXLANLU] OF LRTElement;         StatusType  = PACKED RECORD  { value from RMPAR }           ecode       : EQTStatusType;            dvtwd       : Array [17..20] of Int16;            END;  { StatusType }           VAR   
   err_msg  : String[76];  
     {------------------------------------------------------}  {              PROCEDURE ABREG  {------------------------------------------------------}  PROCEDURE ABReg      (VAR areg   : Int16;       VAR breg   : Int16);     EXTERNAL;          {------------------------------------------------------}  {              GetType  {------------------------------------------------------}  PROCEDURE GetType          $ALIAS 'XLUEX', NOABORT$      (    ecode  : Int16;           cntl   : Cntwds;      VAR result : Int16);     EXTERNAL;          {------------------------------------------------------}  {              LANActivateSAP   {------------------------------------------------------}  PROCEDURE LANActivateSAP      (    nets         : Int16;    { index of last alias in LRT }            InproClass   : Int16;       VAR AliasList    :  LRTList;      VAR ierr         : Int16);     FORWARD;           {-----------------------------------------------------}   {              PROCEDURE LogError   {-----------------------------------------------------}       ${ Procedure to send an error message to the generic printerror routine } $     	PROCEDURE LogError 	    (VAR e_msg  : string;          lu     : Int16;           ierr   : Int16;       VAR return : Int16);     FORWARD;       {------------------------------------------------------}  {              PROCEDURE RegMCast   {------------------------------------------------------}  	PROCEDURE RegMCast 	    (VAR gbl : LANGlobalType;      VAR ierr : Int16);     FORWARD;       {------------------------------------------------------}  {              PROCEDURE RegisterClass  {------------------------------------------------------}  PROCEDURE RegisterClass (    lu   : Int16;                               class : Int16;                            VAR ierr : Int16);      FORWARD;       {------------------------------------------------------}  {              PROCEDURE RMPAR  {------------------------------------------------------}  PROCEDURE RMPAR      (VAR stat   : statustype);      EXTERNAL;              {------------------------------------------------------}  {              PROCEDURE XLUEX  {------------------------------------------------------}      { Used to talk to the driver }      PROCEDURE Xluex                $ ALIAS 'XLUEX', NOABORT $      (    ecode  : Int16;           cntl   : cntwds;      VAR bufr   : Int16;           bufln  : Int16);     EXTERNAL;          {------------------------------------------------------}  {              PROCEDURE XLUEXWRITE   {------------------------------------------------------}      { Used to talk to the driver }      PROCEDURE XluexWrite     $ALIAS 'XLUEX', NOABORT $     (    ecode  : Int16;           cntl   : cntwds;  
    VAR bufr   : StatAddr; 
         bufln  : Int16;           sc     : Int16);     EXTERNAL;                  $SUBTITLE 'CheckDriverType ', PAGE $  {------------------------------------------------------}  {              CheckDriverType  {------------------------------------------------------}  
PROCEDURE CheckDriverType  
 
   (    LU        : Int16; 
 
        DrvType   : Int16; 
     VAR result    : Int16);   {}  {  Discussion:  {  Procedure to check the driver type for the given LU and  {  verify that it is the same as the supplied type.   {   {     INPUT:  {        lu-      Lu to check   {        dvrtype- Type to check against   {     OUTPUT:   "{        result-  error indication (CONSTANTS declared in init_dec). " #{                 possible values: CHKDRIVER_BADLU, CHKDRIVER_BADTYPE. # {}      LABEL      99;      TYPE     DVTAns   = PACKED RECORD Case Int16 OF                  1 : (int    : Int16);                 2 : (av     : PosInt2;                       DvType : PosInt6;                       rsv    : Byte);                 END;   { dvtans }       VAR   	   cntl  : cntwds; 	 	   ecode : Int16;  	 	   parm1 : Int16;  	    return   : DVTAns;       
BEGIN { CheckdriverType }  
 result := 0;  cntl [2] := 0;  cntl [1] := LU;   ecode := 13 + NOABORT + NOSUSPENDBIT;   GetType (ecode, cntl, parm1);   
   BEGIN { error return }  
    result := CHKDRIVER_BADLU;      goto 99;   
   END;  { error return }  
     {}   { We don't need to call ABReg here to check for RTE downing the     { lu, since we're only going into the DVT, and RTE will not down   { the LU in this case.  {}      
return.int := parm1; 
 IF return.dvtype <> drvtype THEN     BEGIN     result := CHKDRIVER_BADTYPE;      END;       99:   
END;  { CheckdriverType }  
     $SUBTITLE 'IEEE802INIT ', PAGE $  {------------------------------------------------------}  {           IEEE802 INIT  {------------------------------------------------------}  PROCEDURE IEEE802Init      (VAR ierr : Int16);      {}  { Abstract:   !{  This routine pretends to be the official initialization routine ! !{  for IEEE-802. It is to be used only temporarily while debugging !  {  the path report generation routines. Basically, running this    "{  routine should make our node think that it supports the IEEE-802  " {  protocol under the HPDSN protocol domain.  {}      LABEL      99;      VAR      domainrec      : DomainRecord;      protorec       : ProtocolRecord;   
   wkmap          : Int16; 
     BEGIN   DS_InitEnterCritical (wkmap, ierr );  
IF ierr <> 0 THEN goto 99; 
     { Register in the IP protocol record that IEEE-802 is a link  { level protocol that supports IP.  {}  DS_FetchElement (DS_ProtosTD, IP, protorec.int);  protorec.pr_supportingpids.bits[IEEE_802] := TRUE;  DS_StoreElement (DS_ProtosTD, IP, protorec.int);       { Register in the PROBE protocol record that IEEE-802 is a link    { level protocol that supports PROBE.   {}  DS_FetchElement (DS_ProtosTD, PROBE, protorec.int);   protorec.pr_supportingpids.bits[IEEE_802] := TRUE;  DS_StoreElement (DS_ProtosTD, PROBE, protorec.int);       DS_FetchElement (DS_DomainsTD, HPDSN_DOMAIN, domainrec.int);  domainrec.dr_memberpids.bits[IEEE_802] := TRUE;   DS_StoreElement (DS_DomainsTD, HPDSN_DOMAIN, domainrec.int);      DS_InitLeaveCritical (wkmap);       99:   	END; {IEEE802Init} 	     $ SUBTITLE 'LANActivateSAP', PAGE $   {------------------------------------------------------}  {           LANActivateSAP                             }  {------------------------------------------------------}  
PROCEDURE  LANActivateSAP  
     (    nets         : Int16;    { index of last alias in LRT }            InproClass   : Int16;       VAR AliasList    : LRTList;       VAR ierr         : Int16);  {}  { Discussion  "{  Procedure to be called during startup to enable INPRO to receive  " {  inbound messages from the network.  INPRO's class number is  ${  stored in the driver's class/dsap mapping table for each enabled LU.  $ #{  This procedure is called AFTER we have verified that this node does # 
{  indeed exist on a LAN.  
 {}  { Parameters  {}  { Error Returns   {}      LABEL      99;      VAR   
   i        : Int16; 
 
   result   : Int16; 
 
   wkmp     : Int16; 
     $ page $  BEGIN { LANActivateSAP }  result := 0;          FOR i := FIRST_ALIAS to nets DO      BEGIN { clear for each enabled lu }         IF aliaslist[i].status = LINKISUP THEN         BEGIN { class numbers to set }        RegisterClass (aliaslist[i].lu, InproClass, result);        IF result <> 0 THEN goto 99;            END;  { class numbers to set }     END;  { set for each enabled lu }      99:   ierr := result;   END;  { LANActivateSAP }      $ SUBTITLE 'LANClearClass ', PAGE $   {------------------------------------------------------}  {              LANClearClass  {------------------------------------------------------}  PROCEDURE LANClearClass      (    tableOK   : TrustType;      VAR ierr      : Int16);   {}  { Discussion  #{  Procedure to be called during shutdown to prevent any more inbound  # "{  messages from being delivered to INPRO.  INPRO's class number is  " ${  cleared in the driver's class/dsap mapping table for each enabled LU. $ #{  This procedure is called AFTER we have verified that this node does # 
{  indeed exist on a LAN.  
 {}  { Parameters  {}  { Error Returns   {     (declared in init_dec)  #{  LANCLASSERR:        Error clearing a class number with the driver.  # ${  LANTABLEERR:        something has occurred which leads us to believe  $ {                      our tables are not well.   {   {  error parm from DS_InitEnterCritical call  {  error parm from RegisterClass.   {}      LABEL      99;      VAR      aliaslist: LRTList;     gbl      : LANGlobalType;  
   i        : Int16; 
 
   result   : Int16; 
    td       : TableDescriptorType;  
   temp     : Int16; 
 
   wkmp     : Int16; 
     $ page $  BEGIN { LANCLearClass }       { Initialize }  ierr := 0;  result := 0;  temp := 0;      IF tableOK = TRUST THEN      BEGIN { tables ok }     DS_InitEnterCritical (wkmp, result);      IF result <> 0 THEN        BEGIN    { can't enter critical }         result := CANT_ENTER_CRIT;        GOTO 99;        END;     { can't enter critical }          DS_FetchTableDescriptor (DS_LANGlobalsTD, td, result);      IF (td.td_wordsperelement = 0) OR        (result <> 0) THEN        BEGIN { no LAN here }         DS_InitLeaveCritical (wkmp);        goto 99;        END;  { no LAN here }          DS_FetchElement (DS_LANGlobalsTD, 1, gbl.bufr);         { read in the entire first part of the table }   #   { In spite of the fact that TABLEOK is ok, it may be the LAN tables #    {  which are trashed.  Do some range checking.      {}      WITH gbl DO        BEGIN         IF (netcount <= 0) OR            (netcount > MAXLANLU) OR            (pidcount <= 0) OR            (pidcount > UP_PIDCT) OR   
         (lrtlen <= 0) OR  
          (lrtlen > MAXLRT) OR            (nextfree <= 0) OR            (nextfree > MAXLRT) THEN            BEGIN { our global block has been trashed }           result := LANTABLEERR;            DS_InitLeaveCritical (wkmp);   	         goto 99;  	          END;  { our global block has been trashed }        END; { with gbl }              FOR i := FIRST_ALIAS to gbl.netcount DO        DS_FetchElement (DS_LANRouteTD, i, aliaslist[i].bufr);         DS_InitLeaveCritical (wkmp);       %   { We are no longer critical, since the calls are now IO to the driver } %        FOR i := FIRST_ALIAS to gbl.netcount DO        BEGIN { clear for each enabled LU }         IF aliaslist[i].status = LINKISUP THEN           BEGIN { class numbers to clear }            RegisterClass (aliaslist[i].lu, 0, temp);      !         { If we get an error, we want to try to clear the rest. } ! !         { There is nothing to do anyway.  Tell caller we had a  } ! !         { problem at the end. Any error will be reported to the } ! !         { caller via the RegisterClass routine.                 } !          IF temp <> 0 THEN result := temp;               END;  { class numbers to clear }         END;  { clear for each enabled lu }          IF temp <> 0 THEN result := LANCLASSERR;          END;  { tables ok }  99:   ierr := result;   END;  { LANClearClass }           $ SUBTITLE ' LANOpenLines ', PAGE $   {------------------------------------------------------}  {              PROCEDURE LANOpenLines   {------------------------------------------------------}      { Procedure to open the LAN links }   "{  A note on LAN driver voodoo.  If bit 1 in the A register is set,  " "{  then there is an error with the call.  The error code is found in " #{  the high four bits of the low byte of areg.  RMPAR may be called to # #{  get the extended status, although it is not here.  See driver ERS.  # {         The RMPAR parameters look like:   {                   RMPAR (dvt16, dvt17, dvt18, dvt19, junk );  {   "{  This procedure has the most complicated dance with criticality }  " %{  Since we cannot read or write station addresses or multicast addresses  % {  while critical, the flow is as follows:  {   {        Enter Critical   {        Read globals   {        read all alias LRT entries   {        Leave critical   {   {        R/W Station address  {        Register mcast   {   {        Enter Critical   {        For each alias LRT entry   &{           Read it from DSAM  (it may have changed while we were not crit)  & {           Decide if we need to update station address   {           Write entry back out if necessary   {        LeaveCritical  {   {}  $ PAGE $  PROCEDURE LANOpenLines     (VAR ierr   : Int16);      LABEL      99;      VAR      aliaslist: LRTList;     gbl      : LANGlobalType;  
   i        : Int16; 
    inproclass  : Int16;   
   lrtele   : LRTElement;  
 
   wkmp     : Int16; 
         BEGIN { LANOpenLines }  ierr := 0;  { If there is no LAN, then return }   IF NOT initglobals.ig_have_IEEE802 THEN goto 99;      DS_InitEnterCritical (wkmp, ierr);  
IF ierr <> 0 THEN goto 99; 
     DS_FetchElement (DS_LANGlobalsTD, 1, gbl.bufr);   DS_FetchGlobal (DS_Inpro_Class, 1, inproclass);   { now get the LRT entries for each of our aliases }   FOR i := FIRST_ALIAS TO gbl.netcount DO      BEGIN { fetch an alias }      DS_FetchElement (DS_LANRouteTD, i, aliaslist[i].bufr);      END;  { fetch an alias }       DS_InitLeaveCritical (wkmp);      RegMCast (gbl, ierr);   ${ ierr <> 0  ==> big probs here.  Return error to caller.  Error codes } $ ${ are defined in init_dec so NSINIT will know what they mean.          } $ 	IF ierr <> 0 THEN  	    BEGIN  !   { The class numbers will not be registered for ANY LUS is an  } ! !   { error occurs for one LU.  An error message has already been } ! !   { printed.   NSINIT will tell the user an error occurred, but } ! !   { initialization will be allowed to complete.                 } !    goto 99;      END;       { Store the class # with the driver }   LANActivateSAP (gbl.netcount, inproclass, aliaslist, ierr);   { bubble the error back to the main.  }       99:       END;  { LANOpenLines }      $ SUBTITLE 'LANStoreMCast', PAGE $  {------------------------------------------------------}  {              PROCEDURE LANStoreMcast  {------------------------------------------------------}      #{ Procedure to store multicast addresses different from the default }  # { syntax checking has been done }           PROCEDURE LANStoreMcast      (VAR SuppliedAddrs   : MCastInfo;      VAR ierr            : Int16);       LABEL      99;      VAR   
   gbl   : LANGlobalType;  
 	   index : Int16;  	 
   lrtele   : LRTElement;  
 	   wkmp  : Int16;  	             BEGIN { LANStoreMcast }   ierr := 0;  DS_InitEnterCritical (wkmp, ierr);  
IF ierr <> 0 THEN goto 99; 
     DS_FetchElement (DS_LANGlobalsTD, 1, gbl.bufr);   index := 0;       REPEAT     index := index + 1;      
$ PARTIAL_EVAL ON $  
 UNTIL (index > MAXLANLU) OR         (gbl.mcast[index].mc_lu = SuppliedAddrs.mc_lu);       IF index > MAXLANLU THEN     BEGIN     ierr := LANTABLEERR;      END  ELSE     BEGIN     gbl.mcast[index].mc_proxy := SuppliedAddrs.mc_proxy;      gbl.mcast[index].mc_target := SuppliedAddrs.mc_target;      DS_StoreElement (DS_LANGlobalsTD, 1, gbl.bufr);     END;       DS_InitLeaveCritical (wkmp);      99:   END;  { LANStoreMcast }           $SUBTITLE 'LogError', PAGE$       	PROCEDURE LogError 	    (VAR e_msg  : String;          lu     : Int16;           ierr   : Int16;       VAR return : Int16);      VAR   
   scanend  : Int16; 
 
   start    : Int16; 
     	BEGIN { LogError } 	     start := strlen (e_msg) + 1;  %strwrite (e_msg, start, scanend, lu:1, '. Driver reports ',ierr:1,' **');  % return := 0;  printerror (err_msg, return);           	END;  { LogError } 	     $SUBTITLE 'RegisterClass', PAGE $   {------------------------------------------------}  {             RegisterClass   {------------------------------------------------}      PROCEDURE RegisterClass (    lu   : Int16;                               class : Int16;                            VAR ierr : Int16);   {}  {  Discussion:   {  Procedure to register our class number with the driver on the    {  table of LU.  It is also called at shutdown time to clear the   {  class number. (class = 0).   {   {  The general purpose RTE error handlingg routines take care   !{  of checking for errors on the XLUEX call, and will print errors ! !{  if an error occurs.  These routines also set the error value to ! "{  a well defined value so it can be bubbled back to NSINIT without  " {  conflicting with other errors.   {   {  INPUT:    {     lu-         Lu which needs class number registered for it.   {     class-      class number to register with the driver.   {   {  OUTPUT:  {     ierr-       error parm.   {                 Possible values:  errors returned from  {                       HandleAbortReturn and CheckXLUEXCall.   "{                       CXC_RTEERROR, CXC_DVRERROR, HAR_XLUEXABORT.  " {                       (all declared in init_dec)  {}      LABEL      9;       CONST    CLASS_STORE_ERR_4104 =   %        '** (4104) NSINIT: Error storing class number.  Driver Reports:';  %     TYPE     RegType  = RECORD CASE Int16 of                 1 : ( eqt : EQTStatusType);                 2 : ( chr : PACKED ARRAY [1..2] of CHAR);                 3 : ( int : Int16);                END;   { regType }          VAR      areg     : Int16OrCharType;     breg     : Int16OrCharType;     cntlwd   : cntwds;   
   dsap     : Int16; 
 
   ecode    : Int16; 
 
   j        : Int16; 
 
   return   : Int16; 
 
   scanend  : Int16; 
         BEGIN { Registerclass }   err_msg := '';  return := 0;      ecode := 3 + NOABORT + NOSUSPENDBIT;   { a control request }  	cntlwd [1] := lu;  	 cntlwd [2] := 24 { subfunction } * 64;  	FOR j := 1 to 2 DO 	    BEGIN { clear both dsaps }      IF j = 1 THEN        BEGIN   
      dsap := IPSAP; 
       END      ELSE         BEGIN         dsap := HPEXPSAP;         END;         Xluex (ecode, cntlwd, dsap, class);        BEGIN { error routine }             ABReg (areg.IIOrCType, breg.IIOrCType);         HandleAbortReturn( areg, breg, lu, return );        GOTO 9;         END;  { error from system }          { Check for RTE and driver errors on the call }     ABreg (areg.IIOrCType, breg.IIOrCType);  !   CheckXLUEXCall( areg, breg, lu, CLASS_STORE_ERR_4104, return ); !     { Routine will print the error if one occurred.            }        { Always hand error indication to the caller.              }       IF return <> 0 THEN goto 9;         END;  { clear both dsaps }       9:  ierr := return;   END;  { Registerclass }       $SUBTITLE 'RegMCast', PAGE $  {------------------------------------------------}  {             RegMCast                           }  {------------------------------------------------}  	PROCEDURE RegMCast 	    (VAR gbl : LANGlobalType;      VAR ierr : Int16);       { Procedure to register the multicast addresses for each card }     {  with the driver.  These are the target multicast address   }     {  and the proxy multicast used by PROBE.  It then sets the   }     {  multicast bit on the card.                                 }        LABEL      99;      CONST       MCAST_STORE_ERR_4102 =  %     '** (4102) NSINIT: Error Registering MCAST Address. Driver Reports:'; %     TYPE     MCastList = RECORD CASE Int16 OF               1 : (Int : Int16);              2 : (arry : ARRAY [1..2] of StatAddr);  
               END;  
     VAR      addrs    : MCastList;  
   addrlen  : Int16; 
    areg     : Int16OrCharType;     breg     : Int16OrCharType;     control  : cntwds;   
   i        : Int16; 
 
   pe_error : Int16; 
     $ PAGE $  
PROCEDURE SetMCBit;  
     VAR      areg     : Int16OrCharType;     breg     : Int16OrCharType;  
   dummy    : Int16; 
    xstat : statustype;  	   filter : Int16; 	     	BEGIN {setmcbit }  	 %{ now set the multicast bit in the receive packet filter.  First we will } % %{  read it, then if the bit is not set, AND in that bit and write the    } % %{  filter back to the card.                                              } %        control[2] := octal('63700');     xluex (3+NOABORT+NOSUSPENDBIT, control, dummy, 1);         BEGIN { error return }        ABReg (areg.IIOrCType, breg.IIOrCType);          HandleAbortReturn( areg, breg, gbl.mcast[i].mc_lu, ierr );   $      { routine checks for RTE errors, and prints the error indication } $       GOTO 99;        END;  { error return }          { CheckXLUEXCall will print an error if RTE encountered a  }        { problem accessing the LU.  The driver error is checked   }        { via RMPAR in this case.                                  }       ABReg (areg.IIOrCType, breg.IIOrCType);     CheckXLUEXCall( areg, breg, gbl.mcast[i].mc_lu, '', ierr );     IF ierr <> 0 THEN GOTO 99;          { Status is returned via RMPAR }   	   RMPAR (xstat);  	        IF xstat.ecode.er_bit THEN   
      BEGIN { log error }  
 &      err_msg := '** (4105) NSINIT: Error reading receive pkt filter. LU ';  & &      LogError (err_msg, gbl.mcast[i].mc_lu, xstat.ecode.err_code,pe_error); &           ierr := ERR_ALREADY_PRINTED;        GOTO 99;  
      END   { log error }  
    ELSE IF xstat.dvtwd[18] < 4 THEN         BEGIN { we need to set the bit }  !      filter := xstat.dvtwd[18] + 4;   { bit 2 is the mcast bit }  !       xluex (3+NOABORT+NOSUSPENDBIT, control, filter, 20465);            BEGIN { error return }            ABReg (areg.IIOrCType, breg.IIOrCType);  "         HandleAbortReturn( areg, breg, gbl.mcast[i].mc_lu, ierr );  "          { Routine prints error indication from RTE error  }           { and sets ierr to a value NSINIT can understand. }  	         GOTO 99;  	          END;  { error return }             { CheckXLUEXCall will check for RTE errors, will print }        { the error indication, and will set ierr to a value   }        { value NSINIT can understand.                         }        ABReg (areg.IIOrCType, breg.IIOrCType);   !      CheckXLUEXCall( areg, breg, gbl.mcast[i].mc_lu, '', ierr );  !       IF ierr <> 0 THEN GOTO 99;            { status is returned via RMPAR }  
      RMPAR (xstat); 
           IF xstat.ecode.er_bit THEN           BEGIN { log error }  '         err_msg := '** (4106) NSINIT: Error writing receive pkt filter. LU '; ' #         LogError (err_msg, gbl.mcast[i].mc_lu, xstat.ecode.err_code,  #                      pe_error);            ierr := ERR_ALREADY_PRINTED;   	         GOTO 99;  	          END;  { log error }        END;  { set the bit }   	END;  {setmcbit }  	     $ PAGE $  	BEGIN { RegMCast } 	     ierr := 0;  i := 1;       WHILE gbl.mcast[i].mc_lu <> EMPTYLU DO     BEGIN     addrs.arry[1] := gbl.mcast[i].mc_target;      addrs.arry[2] := gbl.mcast[i].mc_proxy;  	   addrlen  := 6;  	    control[1] := gbl.mcast[i].mc_lu;     control[2] := octal ('61400');       xluex (2+NOABORT+NOSUSPENDBIT, control, addrs.int, addrlen);          BEGIN { error return }        ABReg (areg.IIOrCType, breg.IIOrCType);          HandleAbortReturn(areg, breg, gbl.mcast[i].mc_lu, ierr );          { This routine prints the error indication and sets }         { ierr to a value NSINIT can understand.            }         GOTO 99;        END;  { error return }         ABREG (areg.IIOrCType, breg.IIOrCType);     { CheckXLUEXCall checks for RTE and driver errors. }      { It then prints the appropriate error indication, }      { (4102 for driver errors), and sets ierr to a     }      { value NSINIT understands.                        }      CheckXLUEXCall( areg, breg, gbl.mcast[i].mc_lu,                               MCAST_STORE_ERR_4102, ierr );     IF ierr <> 0 THEN GOTO 99;          Setmcbit;  #   { Setmcbit will GOTO 99 on error, ierr will be returned to caller } #        i := i + 1;  	   END;  { while } 	 99:   	END;  { RegMCast } 	     $SUBTITLE 'RWStatAddr', PAGE $      {----------------------------------------------}  {      PROCEDURE  RWStatAddr  {----------------------------------------------}  {}  !{ Procedure to read the default station address from the card into ! {  our tables, or to write the station address from our tables  {  onto the card.  We are not critical here.  {   {  INPUT:   {     lrtele-     contains station addresses to write.  {   {  OUTPUT:  {     ierr-       error parm.   {                 Possible values:  errors returned from  {                       HandleAbortReturn and CheckXLUEXCall.   "{                       CXC_RTEERROR, CXC_DVRERROR, HAR_XLUEXABORT.  " {                       (all declared in init_dec)  {}      
PROCEDURE RWStatAddr 
    (VAR lrtele : LRTElement;      VAR ierr  : Int16);       LABEL      99;      CONST      STATADDR_STORE_ERR_4101 =  #      '** (4101) NSINIT: Error storing Station Addr. Driver Reports:'; #     VAR      areg     : Int16OrCharType;     breg     : Int16OrCharType;  
   bufln    : Int16; 
    cntl     : cntwds;   
   ecode    : Int16; 
     
BEGIN { RWStatAddr } 
 ierr := 0;  cntl[2] := 10 * 64;  { subfunction 12b }  cntl[1] := lrtele.lu;   bufln   := 3;       IF LRTEle.status = LINKISUP THEN     BEGIN { enable link }     IF (LRTEle.LANAddr[1] = DEFAULT_STATION[1]) AND        (LRTEle.LANAddr[2] = DEFAULT_STATION[2]) AND        (LRTEle.LANAddr[3] = DEFAULT_STATION[3]) THEN         BEGIN { get address off the card }            ecode := READ + NOSUSPENDBIT;         XLUEX (ecode, cntl, LRTEle.LANAddr[1], bufln);           BEGIN { error return }            ABREG( areg.IIOrCType, breg.IIOrCType );            HandleAbortReturn( areg, breg, lrtele.lu, ierr );           { This routine prints the error indication and sets }           { ierr to a value NSINIT can understand.            }  	         GOTO 99;  	          END;  { error return }             { CheckXLUEXCall checks for RTE and driver errors. }        { It then prints the appropriate error indication, }        { (4101 for driver errors), and sets ierr to a     }        { value NSINIT understands.                        }        ABReg (areg.IIOrCType, breg.IIOrCType);   '      CheckXLUEXCall( areg, breg, lrtele.lu, STATADDR_STORE_ERR_4101, ierr );  '       { hand error back to caller }         END   { get address off the card }     ELSE         BEGIN { user wants to overwrite }             ecode := WRITE + NOSUSPENDBIT;        XLUEXWrite (ecode, cntl, LRTEle.LANAddr, bufln, 20465);            BEGIN { error return }            ABREG( areg.IIOrCType, breg.IIOrCType );            HandleAbortReturn( areg, breg, lrtele.lu, ierr );           { This routine prints the error indication and sets }           { ierr to a value NSINIT can understand.            }  	         GOTO 99;  	          END;  { error return }             { CheckXLUEXCall checks for RTE and driver errors. }        { It then prints the appropriate error indication, }        { (4101 for driver errors), and sets ierr to a     }        { value NSINIT understands.                        }        ABReg (areg.IIOrCType, breg.IIOrCType);   '      CheckXLUEXCall( areg, breg, lrtele.lu, STATADDR_STORE_ERR_4101, ierr );  '       END;  { user wants to overwrite }          END;  { enable link }      99:   
END; { RWStatAddr }  
             	END.  { LANInit }  	